/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests.ast2;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.cdt.core.dom.ICodeReaderFactory;
import org.eclipse.cdt.core.dom.ast.ASTSignatureUtil;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTCastExpression;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTConditionalExpression;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IASTTypeIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.c.CASTVisitor;
import org.eclipse.cdt.core.dom.ast.c.ICASTTypeIdInitializerExpression;
import org.eclipse.cdt.core.dom.ast.cpp.CPPASTVisitor;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.NullLogService;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.internal.core.dom.parser.c.ANSICParserExtensionConfiguration;
import org.eclipse.cdt.internal.core.dom.parser.c.CVisitor;
import org.eclipse.cdt.internal.core.dom.parser.c.GCCParserExtensionConfiguration;
import org.eclipse.cdt.internal.core.dom.parser.c.GNUCSourceParser;
import org.eclipse.cdt.internal.core.dom.parser.c.ICParserExtensionConfiguration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ANSICPPParserExtensionConfiguration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.GNUCPPSourceParser;
import org.eclipse.cdt.internal.core.dom.parser.cpp.GPPParserExtensionConfiguration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPParserExtensionConfiguration;
import org.eclipse.cdt.internal.core.parser.ParserException;
import org.eclipse.cdt.internal.core.parser.scanner2.DOMScanner;
import org.eclipse.cdt.internal.core.parser.scanner2.FileCodeReaderFactory;
import org.eclipse.cdt.internal.core.parser.scanner2.GCCScannerExtensionConfiguration;
import org.eclipse.cdt.internal.core.parser.scanner2.GPPScannerExtensionConfiguration;
import org.eclipse.cdt.internal.core.parser.scanner2.IScannerExtensionConfiguration;

public class AST2BaseTest
extends TestCase {
    private static final IParserLogService NULL_LOG = new NullLogService();

    protected IASTTranslationUnit parse(String string, ParserLanguage parserLanguage) throws ParserException {
        return this.parse(string, parserLanguage, false, true);
    }

    protected IASTTranslationUnit parse(String string, ParserLanguage parserLanguage, boolean bl) throws ParserException {
        return this.parse(string, parserLanguage, bl, true);
    }

    protected IASTTranslationUnit parse(String string, ParserLanguage parserLanguage, boolean bl, boolean bl2) throws ParserException {
        Object object;
        CodeReader codeReader = new CodeReader(string.toCharArray());
        ScannerInfo scannerInfo = new ScannerInfo();
        Object object2 = null;
        object2 = parserLanguage == ParserLanguage.C ? new GCCScannerExtensionConfiguration() : new GPPScannerExtensionConfiguration();
        DOMScanner dOMScanner = new DOMScanner(codeReader, (IScannerInfo)scannerInfo, ParserMode.COMPLETE_PARSE, parserLanguage, NULL_LOG, (IScannerExtensionConfiguration)object2, (ICodeReaderFactory)FileCodeReaderFactory.getInstance());
        GNUCPPSourceParser gNUCPPSourceParser = null;
        if (parserLanguage == ParserLanguage.CPP) {
            object = null;
            object = bl ? new GPPParserExtensionConfiguration() : new ANSICPPParserExtensionConfiguration();
            gNUCPPSourceParser = new GNUCPPSourceParser((IScanner)dOMScanner, ParserMode.COMPLETE_PARSE, NULL_LOG, (ICPPParserExtensionConfiguration)object);
        } else {
            object = null;
            object = bl ? new GCCParserExtensionConfiguration() : new ANSICParserExtensionConfiguration();
            gNUCPPSourceParser = new GNUCSourceParser((IScanner)dOMScanner, ParserMode.COMPLETE_PARSE, NULL_LOG, (ICParserExtensionConfiguration)object);
        }
        object = gNUCPPSourceParser.parse();
        if (gNUCPPSourceParser.encounteredError() && bl2) {
            throw new ParserException("FAILURE");
        }
        if (parserLanguage == ParserLanguage.C && bl2) {
            AST2BaseTest.assertEquals((int)CVisitor.getProblems((IASTTranslationUnit)object).length, (int)0);
            AST2BaseTest.assertEquals((int)object.getPreprocessorProblems().length, (int)0);
        } else if (parserLanguage == ParserLanguage.CPP && bl2) {
            AST2BaseTest.assertEquals((int)CPPVisitor.getProblems((IASTTranslationUnit)object).length, (int)0);
            AST2BaseTest.assertEquals((int)object.getPreprocessorProblems().length, (int)0);
        }
        if (bl2) {
            AST2BaseTest.assertEquals((int)0, (int)object.getPreprocessorProblems().length);
        }
        return object;
    }

    protected void validateSimplePostfixInitializerExpressionC(String string) throws ParserException {
        ICASTTypeIdInitializerExpression iCASTTypeIdInitializerExpression = (ICASTTypeIdInitializerExpression)this.getExpressionFromStatementInCode(string, ParserLanguage.C);
        AST2BaseTest.assertNotNull((Object)iCASTTypeIdInitializerExpression);
        AST2BaseTest.assertNotNull((Object)iCASTTypeIdInitializerExpression.getTypeId());
        AST2BaseTest.assertNotNull((Object)iCASTTypeIdInitializerExpression.getInitializer());
    }

    protected void validateSimpleUnaryTypeIdExpression(String string, int n) throws ParserException {
        IASTCastExpression iASTCastExpression = (IASTCastExpression)this.getExpressionFromStatementInCode(string, ParserLanguage.C);
        AST2BaseTest.assertNotNull((Object)iASTCastExpression);
        AST2BaseTest.assertEquals((int)iASTCastExpression.getOperator(), (int)n);
        AST2BaseTest.assertNotNull((Object)iASTCastExpression.getTypeId());
        IASTIdExpression iASTIdExpression = (IASTIdExpression)iASTCastExpression.getOperand();
        AST2BaseTest.assertEquals((String)iASTIdExpression.getName().toString(), (String)"x");
    }

    protected void validateSimpleTypeIdExpressionC(String string, int n) throws ParserException {
        IASTTypeIdExpression iASTTypeIdExpression = (IASTTypeIdExpression)this.getExpressionFromStatementInCode(string, ParserLanguage.C);
        AST2BaseTest.assertNotNull((Object)iASTTypeIdExpression);
        AST2BaseTest.assertEquals((int)iASTTypeIdExpression.getOperator(), (int)n);
        AST2BaseTest.assertNotNull((Object)iASTTypeIdExpression.getTypeId());
    }

    protected void validateSimpleUnaryExpressionC(String string, int n) throws ParserException {
        IASTUnaryExpression iASTUnaryExpression = (IASTUnaryExpression)this.getExpressionFromStatementInCode(string, ParserLanguage.C);
        AST2BaseTest.assertNotNull((Object)iASTUnaryExpression);
        AST2BaseTest.assertEquals((int)iASTUnaryExpression.getOperator(), (int)n);
        IASTIdExpression iASTIdExpression = (IASTIdExpression)iASTUnaryExpression.getOperand();
        AST2BaseTest.assertEquals((String)iASTIdExpression.getName().toString(), (String)"x");
    }

    protected void validateConditionalExpressionC(String string) throws ParserException {
        IASTConditionalExpression iASTConditionalExpression = (IASTConditionalExpression)this.getExpressionFromStatementInCode(string, ParserLanguage.C);
        AST2BaseTest.assertNotNull((Object)iASTConditionalExpression);
        IASTIdExpression iASTIdExpression = (IASTIdExpression)iASTConditionalExpression.getLogicalConditionExpression();
        AST2BaseTest.assertEquals((String)iASTIdExpression.getName().toString(), (String)"x");
        IASTIdExpression iASTIdExpression2 = (IASTIdExpression)iASTConditionalExpression.getPositiveResultExpression();
        AST2BaseTest.assertEquals((String)iASTIdExpression2.getName().toString(), (String)"y");
        IASTIdExpression iASTIdExpression3 = (IASTIdExpression)iASTConditionalExpression.getNegativeResultExpression();
        AST2BaseTest.assertEquals((String)iASTIdExpression.getName().toString(), (String)iASTIdExpression3.getName().toString());
    }

    protected void validateSimpleBinaryExpressionC(String string, int n) throws ParserException {
        IASTBinaryExpression iASTBinaryExpression = (IASTBinaryExpression)this.getExpressionFromStatementInCode(string, ParserLanguage.C);
        AST2BaseTest.assertNotNull((Object)iASTBinaryExpression);
        AST2BaseTest.assertEquals((int)iASTBinaryExpression.getOperator(), (int)n);
        IASTIdExpression iASTIdExpression = (IASTIdExpression)iASTBinaryExpression.getOperand1();
        AST2BaseTest.assertEquals((String)iASTIdExpression.getName().toString(), (String)"x");
        IASTIdExpression iASTIdExpression2 = (IASTIdExpression)iASTBinaryExpression.getOperand2();
        AST2BaseTest.assertEquals((String)iASTIdExpression2.getName().toString(), (String)"y");
    }

    protected IASTExpression getExpressionFromStatementInCode(String string, ParserLanguage parserLanguage) throws ParserException {
        StringBuffer stringBuffer = new StringBuffer("void f() { ");
        stringBuffer.append("int x, y;\n");
        stringBuffer.append(string);
        stringBuffer.append(";\n}");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), parserLanguage);
        IASTFunctionDefinition iASTFunctionDefinition = (IASTFunctionDefinition)iASTTranslationUnit.getDeclarations()[0];
        IASTCompoundStatement iASTCompoundStatement = (IASTCompoundStatement)iASTFunctionDefinition.getBody();
        IASTExpressionStatement iASTExpressionStatement = (IASTExpressionStatement)iASTCompoundStatement.getStatements()[1];
        return iASTExpressionStatement.getExpression();
    }

    protected void assertInstances(CNameCollector cNameCollector, IBinding iBinding, int n) throws Exception {
        int n2 = 0;
        if (iBinding == null) {
            AST2BaseTest.assertTrue((boolean)false);
        }
        int n3 = 0;
        while (n3 < cNameCollector.size()) {
            if (cNameCollector.getName(n3).resolveBinding() == iBinding) {
                ++n2;
            }
            ++n3;
        }
        AST2BaseTest.assertEquals((int)n2, (int)n);
    }

    protected void assertInstances(CPPNameCollector cPPNameCollector, IBinding iBinding, int n) throws Exception {
        int n2 = 0;
        int n3 = 0;
        while (n3 < cPPNameCollector.size()) {
            if (cPPNameCollector.getName(n3).resolveBinding() == iBinding) {
                ++n2;
            }
            ++n3;
        }
        AST2BaseTest.assertEquals((int)n, (int)n2);
    }

    protected void isExpressionStringEqual(IASTExpression iASTExpression, String string) {
        String string2 = ASTSignatureUtil.getExpressionString((IASTExpression)iASTExpression);
        AST2BaseTest.assertEquals((String)string, (String)string2);
    }

    protected void isParameterSignatureEqual(IASTDeclarator iASTDeclarator, String string) {
        AST2BaseTest.assertEquals((String)string, (String)ASTSignatureUtil.getParameterSignature((IASTDeclarator)iASTDeclarator));
    }

    protected void isSignatureEqual(IASTDeclarator iASTDeclarator, String string) {
        AST2BaseTest.assertEquals((String)string, (String)ASTSignatureUtil.getSignature((IASTDeclarator)iASTDeclarator));
    }

    protected void isSignatureEqual(IASTDeclSpecifier iASTDeclSpecifier, String string) {
        AST2BaseTest.assertEquals((String)string, (String)ASTSignatureUtil.getSignature((IASTDeclSpecifier)iASTDeclSpecifier));
    }

    protected void isSignatureEqual(IASTTypeId iASTTypeId, String string) {
        AST2BaseTest.assertEquals((String)string, (String)ASTSignatureUtil.getSignature((IASTTypeId)iASTTypeId));
    }

    protected void isTypeEqual(IASTDeclarator iASTDeclarator, String string) {
        AST2BaseTest.assertEquals((String)string, (String)ASTTypeUtil.getType((IASTDeclarator)iASTDeclarator));
    }

    protected void isTypeEqual(IASTTypeId iASTTypeId, String string) {
        AST2BaseTest.assertEquals((String)string, (String)ASTTypeUtil.getType((IASTTypeId)iASTTypeId));
    }

    protected void isTypeEqual(IType iType, String string) {
        AST2BaseTest.assertEquals((String)string, (String)ASTTypeUtil.getType((IType)iType));
    }

    protected void isParameterTypeEqual(IFunctionType iFunctionType, String string) {
        AST2BaseTest.assertEquals((String)string, (String)ASTTypeUtil.getParameterTypeString((IFunctionType)iFunctionType));
    }

    protected static class CNameCollector
    extends CASTVisitor {
        public List nameList;

        protected CNameCollector() {
            this.shouldVisitNames = true;
            this.nameList = new ArrayList();
        }

        public int visit(IASTName iASTName) {
            this.nameList.add(iASTName);
            return 3;
        }

        public IASTName getName(int n) {
            if (n < 0 || n >= this.nameList.size()) {
                return null;
            }
            return (IASTName)this.nameList.get(n);
        }

        public int size() {
            return this.nameList.size();
        }
    }

    protected static class CPPNameCollector
    extends CPPASTVisitor {
        public List nameList;

        protected CPPNameCollector() {
            this.shouldVisitNames = true;
            this.nameList = new ArrayList();
        }

        public int visit(IASTName iASTName) {
            this.nameList.add(iASTName);
            return 3;
        }

        public IASTName getName(int n) {
            if (n < 0 || n >= this.nameList.size()) {
                return null;
            }
            return (IASTName)this.nameList.get(n);
        }

        public int size() {
            return this.nameList.size();
        }
    }

    protected static class CNameResolver
    extends CASTVisitor {
        public int numProblemBindings;
        public int numNullBindings;
        public List nameList;

        protected CNameResolver() {
            this.shouldVisitNames = true;
            this.numProblemBindings = 0;
            this.numNullBindings = 0;
            this.nameList = new ArrayList();
        }

        public int visit(IASTName iASTName) {
            this.nameList.add(iASTName);
            IBinding iBinding = iASTName.resolveBinding();
            if (iBinding instanceof IProblemBinding) {
                ++this.numProblemBindings;
            }
            if (iBinding == null) {
                ++this.numNullBindings;
            }
            return 3;
        }

        public IASTName getName(int n) {
            if (n < 0 || n >= this.nameList.size()) {
                return null;
            }
            return (IASTName)this.nameList.get(n);
        }

        public int size() {
            return this.nameList.size();
        }
    }

    protected static class CPPNameResolver
    extends CPPASTVisitor {
        public int numProblemBindings;
        public int numNullBindings;
        public List nameList;

        protected CPPNameResolver() {
            this.shouldVisitNames = true;
            this.numProblemBindings = 0;
            this.numNullBindings = 0;
            this.nameList = new ArrayList();
        }

        public int visit(IASTName iASTName) {
            this.nameList.add(iASTName);
            IBinding iBinding = iASTName.resolveBinding();
            if (iBinding instanceof IProblemBinding) {
                ++this.numProblemBindings;
            }
            if (iBinding == null) {
                ++this.numNullBindings;
            }
            return 3;
        }

        public IASTName getName(int n) {
            if (n < 0 || n >= this.nameList.size()) {
                return null;
            }
            return (IASTName)this.nameList.get(n);
        }

        public int size() {
            return this.nameList.size();
        }
    }
}

