/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests.ast2;

import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.tests.ast2.AST2SpecBaseTest;

public class AST2CSpecTest
extends AST2SpecBaseTest {
    public void test4s6() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#ifdef _ _STDC_IEC_559_ _ /* FE_UPWARD defined */\n");
        stringBuffer.append("fesetround(FE_UPWARD);\n");
        stringBuffer.append("#endif\n");
        this.parseCandCPP(stringBuffer.toString(), false, 0);
    }

    public void test5_1_1_3s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("char i;\n");
        stringBuffer.append("int i;\n");
        this.parseCandCPP(stringBuffer.toString(), false, 0);
    }

    public void test5_1_2_3s10() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int f() {\n");
        stringBuffer.append("char c1, c2;\n");
        stringBuffer.append("c1 = c1 + c2;\n");
        stringBuffer.append("}\n");
        this.parseCandCPP(stringBuffer.toString(), true, 0);
    }

    public void test5_1_2_3s11() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int f() {\n");
        stringBuffer.append("float f1, f2;\n");
        stringBuffer.append("double d;\n");
        stringBuffer.append("f1 = f2 * d;\n");
        stringBuffer.append("}\n");
        this.parseCandCPP(stringBuffer.toString(), true, 0);
    }

    public void test5_1_2_3s12() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int f() {\n");
        stringBuffer.append("double d1, d2;\n");
        stringBuffer.append("float f;\n");
        stringBuffer.append("d1 = f = 1;\n");
        stringBuffer.append("d2 = (float) 1;\n");
        stringBuffer.append("}\n");
        this.parseCandCPP(stringBuffer.toString(), true, 0);
    }

    public void test5_1_2_3s13() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int f() {\n");
        stringBuffer.append("double x, y, z;\n");
        stringBuffer.append("x = (x * y) * z; // not equivalent tox *= y * z;\n");
        stringBuffer.append("z = (x - y) + y ; // not equivalent toz = x;\n");
        stringBuffer.append("z = x + x * y; // not equivalent toz = x * (1.0 + y);\n");
        stringBuffer.append("y = x / 5.0; // not equivalent toy = x * 0.2;\n");
        stringBuffer.append("}\n");
        this.parseCandCPP(stringBuffer.toString(), true, 0);
    }

    public void test5_1_2_3s14() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int f() {\n");
        stringBuffer.append("int a, b;\n");
        stringBuffer.append("a = a + 32760 + b + 5;\n");
        stringBuffer.append("a = (((a + 32760) + b) + 5);\n");
        stringBuffer.append("a = ((a + b) + 32765);\n");
        stringBuffer.append("a = ((a + 32765) + b);\n");
        stringBuffer.append("a = (a + (b + 32765));\n");
        stringBuffer.append("}\n");
        this.parseCandCPP(stringBuffer.toString(), true, 0);
    }

    public void test5_1_2_3s15() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("//#include <stdio.h>\n");
        stringBuffer.append("int sum;\n");
        stringBuffer.append("char *p;\n");
        stringBuffer.append("sum = sum * 10 - '0' + (*p++ = getchar());\n");
        stringBuffer.append("sum = (((sum * 10) - '0') + ((*(p++)) = (getchar())));\n");
        this.parseCandCPP(stringBuffer.toString(), false, 0);
    }

    public void test6_2_5s28() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct tag (* a[5])(float);\n");
        this.parseCandCPP(stringBuffer.toString(), false, 0);
    }

    public void test6_2_7s5() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int f(int (*)(), double (*)[3]);\n");
        stringBuffer.append("int f(int (*)(char *), double (*)[]);\n");
        stringBuffer.append("int f(int (*)(char *), double (*)[3]);\n");
        this.parse(stringBuffer.toString(), ParserLanguage.C, true, 0);
    }

    public void test6_4_4_4s12() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("char x='\\023';\n");
        stringBuffer.append("char y='\\0';\n");
        stringBuffer.append("char z='\\x13';\n");
        this.parseCandCPP(stringBuffer.toString(), true, 0);
    }

    public void test6_5_2_2s12() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int f1() {}\n");
        stringBuffer.append("int f2() {}\n");
        stringBuffer.append("int f3() {}\n");
        stringBuffer.append("int f4() {}\n");
        stringBuffer.append("int (*pf[5])(int a, int b);\n");
        stringBuffer.append("int foo() {\n");
        stringBuffer.append("int x=(*pf[f1()]) (f2(), f3() + f4());\n");
        stringBuffer.append("}\n");
        this.parseCandCPP(stringBuffer.toString(), true, 0);
    }

    public void test6_5_2_3s7() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct s { int i; const int ci; };\n");
        stringBuffer.append("struct s s;\n");
        stringBuffer.append("const struct s cs;\n");
        stringBuffer.append("volatile struct s vs;\n");
        stringBuffer.append("int f() {\n");
        stringBuffer.append("s.i; // int\n");
        stringBuffer.append("s.ci; // const int\n");
        stringBuffer.append("cs.i; // const int\n");
        stringBuffer.append("cs.ci; // const int\n");
        stringBuffer.append("vs.i; // volatile int\n");
        stringBuffer.append("vs.ci; // volatile const int\n");
        stringBuffer.append("}\n");
        this.parseCandCPP(stringBuffer.toString(), true, 0);
    }

    public void test6_5_2_3s8a() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("union {\n");
        stringBuffer.append("struct {\n");
        stringBuffer.append("int alltypes;\n");
        stringBuffer.append("} n;\n");
        stringBuffer.append("struct {\n");
        stringBuffer.append("int type;\n");
        stringBuffer.append("int intnode;\n");
        stringBuffer.append("} ni;\n");
        stringBuffer.append("struct {\n");
        stringBuffer.append("int type;\n");
        stringBuffer.append("double doublenode;\n");
        stringBuffer.append("} nf;\n");
        stringBuffer.append("} u;\n");
        stringBuffer.append("int f() {\n");
        stringBuffer.append("u.nf.type = 1;\n");
        stringBuffer.append("u.nf.doublenode = 3.14;\n");
        stringBuffer.append("if (u.n.alltypes == 1)\n");
        stringBuffer.append("return 0;\n");
        stringBuffer.append("if (sin(u.nf.doublenode) == 0.0)\n");
        stringBuffer.append("return 0;\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.C, true, 0);
    }

    public void test6_5_2_3s8b() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct t1 { int m; };\n");
        stringBuffer.append("struct t2 { int m; };\n");
        stringBuffer.append("int f(struct t1 * p1, struct t2 * p2)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("if (p1->m < 0)\n");
        stringBuffer.append("p2->m = -p2->m;\n");
        stringBuffer.append("return p1->m;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("int g()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("union {\n");
        stringBuffer.append("struct t1 s1;\n");
        stringBuffer.append("struct t2 s2;\n");
        stringBuffer.append("} u;\n");
        stringBuffer.append("return f(&u.s1, &u.s2);\n");
        stringBuffer.append("}\n");
        this.parseCandCPP(stringBuffer.toString(), false, 0);
    }

    public void test6_5_2_5s9() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int *p = (int []){2, 4};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.C, true, 0);
    }

    public void test6_5_2_5s10() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void f(void)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("int *p;\n");
        stringBuffer.append("p = (int [2]){*p};\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.C, true, 0);
    }

    public void test6_5_2_5s11() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int f(){\n");
        stringBuffer.append("drawline((struct point){.x=1, .y=1},\n");
        stringBuffer.append("(struct point){.x=3, .y=4});\n");
        stringBuffer.append("drawline(&(struct point){.x=1, .y=1},\n");
        stringBuffer.append("&(struct point){.x=3, .y=4});\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.C, false, 0);
    }

    public void test6_5_2_5s12() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int f() {\n");
        stringBuffer.append("(const float []){1e0, 1e1, 1e2, 1e3, 1e4, 1e5, 1e6};\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.C, true, 0);
    }

    public void test6_5_2_5s13() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int f() {\n");
        stringBuffer.append("\"/tmp/fileXXXXXX\";\n");
        stringBuffer.append("(char []){\"/tmp/fileXXXXXX\"};\n");
        stringBuffer.append("(const char []){\"/tmp/fileXXXXXX\"};\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.C, true, 0);
    }

    public void test6_5_2_5s14() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int f() {\n");
        stringBuffer.append("(const char []){\"abc\"} == \"abc\";\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.C, true, 0);
    }

    public void test6_5_2_5s15() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int f() {\n");
        stringBuffer.append("struct int_list { int car; struct int_list *cdr; };\n");
        stringBuffer.append("struct int_list endless_zeros = {0, &endless_zeros};\n");
        stringBuffer.append("eval(endless_zeros);\n");
        stringBuffer.append("}\n");
        this.parseCandCPP(stringBuffer.toString(), false, 0);
    }

    public void test6_5_2_5s16() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct s { int i; };\n");
        stringBuffer.append("int f (void)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("struct s *p = 0, *q;\n");
        stringBuffer.append("int j = 0;\n");
        stringBuffer.append("again:\n");
        stringBuffer.append("q = p, p = &((struct s){ j++ });\n");
        stringBuffer.append("if (j < 2) goto again;\n");
        stringBuffer.append("return p == q && q->i == 1;\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.C, true, 0);
    }

    public void test6_5_3_4s5() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("extern void *alloc(size_t);\n");
        stringBuffer.append("double *dp = alloc(sizeof *dp);\n");
        this.parseCandCPP(stringBuffer.toString(), false, 0);
    }

    public void test6_5_3_4s6() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int f() {\n");
        stringBuffer.append("int array[5];\n");
        stringBuffer.append("int x = sizeof array / sizeof array[0];\n");
        stringBuffer.append("}\n");
        this.parseCandCPP(stringBuffer.toString(), true, 0);
    }

    public void test6_5_6s10() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int f() {\n");
        stringBuffer.append("int n = 4, m = 3;\n");
        stringBuffer.append("int a[n][m];\n");
        stringBuffer.append("int (*p)[m] = a; // p == &a[0]\n");
        stringBuffer.append("p += 1; // p == &a[1]\n");
        stringBuffer.append("(*p)[2] = 99; // a[1][2] == 99\n");
        stringBuffer.append("n = p - a; // n == 1\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.C, true, 0);
    }

    public void test6_5_15s8() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int f() {\n");
        stringBuffer.append("const void *c_vp;\n");
        stringBuffer.append("void *vp;\n");
        stringBuffer.append("const int *c_ip;\n");
        stringBuffer.append("volatile int *v_ip;\n");
        stringBuffer.append("int *ip;\n");
        stringBuffer.append("const char *c_cp;\n");
        stringBuffer.append("}\n");
        this.parseCandCPP(stringBuffer.toString(), true, 0);
    }

    public void test6_5_16_1s5() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int f() {\n");
        stringBuffer.append("char c;\n");
        stringBuffer.append("int i;\n");
        stringBuffer.append("long l;\n");
        stringBuffer.append("l = (c = i);\n");
        stringBuffer.append("}\n");
        this.parseCandCPP(stringBuffer.toString(), true, 0);
    }

    public void test6_5_16_1s6() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int f() {\n");
        stringBuffer.append("const char **cpp;\n");
        stringBuffer.append("char *p;\n");
        stringBuffer.append("const char c = 'A';\n");
        stringBuffer.append("cpp = &p; // constraint violation\n");
        stringBuffer.append("*cpp = &c; // valid\n");
        stringBuffer.append("*p = 0; // valid\n");
        stringBuffer.append("}\n");
        this.parseCandCPP(stringBuffer.toString(), true, 0);
    }

    public void test6_7_2_1s17() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct s { int n; double d[]; };\n");
        stringBuffer.append("struct ss { int n; double d[1]; };\n");
        stringBuffer.append("int f() {\n");
        stringBuffer.append("sizeof (struct s);\n");
        stringBuffer.append("offsetof(struct s, d);\n");
        stringBuffer.append("offsetof(struct ss, d);\n");
        stringBuffer.append("}\n");
        this.parseCandCPP(stringBuffer.toString(), false, 0);
    }

    public void test6_7_2_1s18a() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int f() {\n");
        stringBuffer.append("struct s *s1;\n");
        stringBuffer.append("struct s *s2;\n");
        stringBuffer.append("s1 = malloc(sizeof (struct s) + 64);\n");
        stringBuffer.append("s2 = malloc(sizeof (struct s) + 46);\n");
        stringBuffer.append("}\n");
        this.parseCandCPP(stringBuffer.toString(), false, 0);
    }

    public void test6_7_2_1s18b() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct { int n; double d[8]; } *s1;\n");
        stringBuffer.append("struct { int n; double d[5]; } *s2;\n");
        this.parseCandCPP(stringBuffer.toString(), true, 0);
    }

    public void test6_7_2_2s5() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int f() {\n");
        stringBuffer.append("enum hue { chartreuse, burgundy, claret=20, winedark };\n");
        stringBuffer.append("enum hue col, *cp;\n");
        stringBuffer.append("col = claret;\n");
        stringBuffer.append("cp = &col;\n");
        stringBuffer.append("if (*cp != burgundy)\n");
        stringBuffer.append("return 0;\n");
        stringBuffer.append("}\n");
        this.parseCandCPP(stringBuffer.toString(), true, 0);
    }

    public void test6_7_2_3s9() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct tnode {\n");
        stringBuffer.append("int count;\n");
        stringBuffer.append("struct tnode *left, *right;\n");
        stringBuffer.append("};\n");
        stringBuffer.append("struct tnode s, *sp;\n");
        this.parseCandCPP(stringBuffer.toString(), true, 0);
    }

    public void test6_7_2_3s10() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("typedef struct tnode TNODE;\n");
        stringBuffer.append("struct tnode {\n");
        stringBuffer.append("int count;\n");
        stringBuffer.append("TNODE *left, *right;\n");
        stringBuffer.append("};\n");
        stringBuffer.append("TNODE s, *sp;\n");
        this.parseCandCPP(stringBuffer.toString(), true, 0);
    }

    public void test6_7_2_3s11() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct s2;\n");
        stringBuffer.append("struct s1 { struct s2 *s2p; }; // D1\n");
        stringBuffer.append("struct s2 { struct s1 *s1p; }; // D2\n");
        this.parseCandCPP(stringBuffer.toString(), true, 0);
    }

    public void test6_7_3s10() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("extern const volatile int real_time_clock;\n");
        this.parseCandCPP(stringBuffer.toString(), true, 0);
    }

    public void test6_7_3s11() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int f() {\n");
        stringBuffer.append("const struct s { int mem; } cs = { 1 };\n");
        stringBuffer.append("struct s ncs; // the object ncs is modifiable\n");
        stringBuffer.append("typedef int A[2][3];\n");
        stringBuffer.append("const A a = {{4, 5, 6}, {7, 8, 9}}; // array of array of const int\n");
        stringBuffer.append("int *pi;\n");
        stringBuffer.append("const int *pci;\n");
        stringBuffer.append("ncs = cs; // valid\n");
        stringBuffer.append("cs = ncs; // violates modifiable lvalue constraint for =\n");
        stringBuffer.append("pi = &ncs.mem; // valid\n");
        stringBuffer.append("pi = &cs.mem; // violates type constraints for =\n");
        stringBuffer.append("pci = &cs.mem; // valid\n");
        stringBuffer.append("pi = a[0]; // invalid: a[0] has type \ufffd\ufffdconst int *\ufffd\ufffd\n");
        stringBuffer.append("}\n");
        this.parseCandCPP(stringBuffer.toString(), true, 0);
    }

    public void test6_7_3_1s7() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int * restrict a;\n");
        stringBuffer.append("int * restrict b;\n");
        stringBuffer.append("extern int c[];\n");
        this.parse(stringBuffer.toString(), ParserLanguage.C, true, 0);
    }

    public void test6_7_3_1s8() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void f(int n, int * restrict p, int * restrict q)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("while (n-- > 0)\n");
        stringBuffer.append("*p++ = *q++;\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.C, true, 0);
    }

    public void test6_7_3_1s9() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void f(int n, int * restrict p, int * restrict q)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("while (n-- > 0)\n");
        stringBuffer.append("*p++ = *q++;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("void g(void)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("extern int d[100];\n");
        stringBuffer.append("f(50, d + 50, d); // valid\n");
        stringBuffer.append("f(50, d + 1, d); // undefined behavior\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.C, true, 0);
    }

    public void test6_7_3_1s10() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void h(int n, int * restrict p, int * restrict q, int * restrict r)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("int i;\n");
        stringBuffer.append("for (i = 0; i < n; i++)\n");
        stringBuffer.append("p[i] = q[i] + r[i];\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.C, true, 0);
    }

    public void test6_7_3_1s11() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int f()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("int * restrict p1;\n");
        stringBuffer.append("int * restrict q1;\n");
        stringBuffer.append("p1 = q1; // undefined behavior\n");
        stringBuffer.append("{\n");
        stringBuffer.append("int * restrict p2 = p1; // valid\n");
        stringBuffer.append("int * restrict q2 = q1; // valid\n");
        stringBuffer.append("p1 = q2; // undefined behavior\n");
        stringBuffer.append("p2 = q2; // undefined behavior\n");
        stringBuffer.append("}\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.C, true, 0);
    }

    public void test6_7_3_1s12() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("typedef struct { int n; float * restrict v; } vector;\n");
        stringBuffer.append("vector new_vector(int n)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("vector t;\n");
        stringBuffer.append("t.n = n;\n");
        stringBuffer.append("t.v = malloc(n * sizeof (float));\n");
        stringBuffer.append("return t;\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.C, false, 0);
    }

    public void test6_7_4s7() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("inline double fahr(double t)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("return (9.0 * t) / 5.0 + 32.0;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("inline double cels(double t)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("return (5.0 * (t - 32.0)) / 9.0;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("extern double fahr(double); // creates an external definition\n");
        stringBuffer.append("double convert(int is_fahr, double temp)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("return is_fahr ? cels(temp) : fahr(temp);\n");
        stringBuffer.append("}\n");
        this.parseCandCPP(stringBuffer.toString(), true, 0);
    }

    public void test6_7_5_1s4() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("const int *ptr_to_constant;\n");
        stringBuffer.append("int *const constant_ptr1;\n");
        stringBuffer.append("typedef int *int_ptr;\n");
        stringBuffer.append("const int_ptr constant_ptr2;\n");
        this.parseCandCPP(stringBuffer.toString(), true, 0);
    }

    public void test6_7_5_2s7() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("float fa[11], *afp[17];\n");
        this.parseCandCPP(stringBuffer.toString(), true, 0);
    }

    public void test6_7_5_2s8() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("extern int *x;\n");
        stringBuffer.append("extern int y[];\n");
        this.parseCandCPP(stringBuffer.toString(), true, 0);
    }

    public void test6_7_5_2s9() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("extern int n;\n");
        stringBuffer.append("extern int m;\n");
        stringBuffer.append("void fcompat(void)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("int a[n][6][m];\n");
        stringBuffer.append("int (*p)[4][n+1];\n");
        stringBuffer.append("int c[n][n][6][m];\n");
        stringBuffer.append("int (*r)[n][n][n+1];\n");
        stringBuffer.append("p = a; // invalid: not compatible because4 != 6\n");
        stringBuffer.append("r = c; // compatible, but defined behavior only if\n");
        stringBuffer.append("// n == 6 andm == n+1\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.C, true, 0);
    }

    public void test6_7_5_2s10() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("extern int n;\n");
        stringBuffer.append("int A[n]; // invalid: file scope VLA\n");
        stringBuffer.append("extern int (*p2)[n]; // invalid: file scope VM\n");
        stringBuffer.append("int B[100]; // valid: file scope but not VM\n");
        stringBuffer.append("void fvla(int m, int C[m][m]); // valid: VLA with prototype scope\n");
        stringBuffer.append("void fvla(int m, int C[m][m]) // valid: adjusted to auto pointer to VLA\n");
        stringBuffer.append("{\n");
        stringBuffer.append("typedef int VLA[m][m]; // valid: block scope typedef VLA\n");
        stringBuffer.append("struct tag {\n");
        stringBuffer.append("int (*y)[n]; // invalid: y not ordinary identifier\n");
        stringBuffer.append("int z[n]; // invalid: z not ordinary identifier\n");
        stringBuffer.append("};\n");
        stringBuffer.append("int D[m]; // valid: auto VLA\n");
        stringBuffer.append("static int E[m]; // invalid: static block scope VLA\n");
        stringBuffer.append("extern int F[m]; // invalid: F has linkage and is VLA\n");
        stringBuffer.append("int (*s)[m]; // valid: auto pointer to VLA\n");
        stringBuffer.append("extern int (*r)[m]; // invalid: r has linkage and points to VLA\n");
        stringBuffer.append("static int (*q)[m] = &B; // valid: q is a static block pointer to VLA\n");
        stringBuffer.append("}\n");
        this.parseCandCPP(stringBuffer.toString(), false, 0);
    }

    public void test6_7_5_3s16() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int f(void), *fip(), (*pfi)();\n");
        this.parseCandCPP(stringBuffer.toString(), true, 0);
    }

    public void test6_7_5_3s18() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int (*apfi[3])(int *x, int *y);\n");
        this.parseCandCPP(stringBuffer.toString(), true, 0);
    }

    public void test6_7_5_3s19() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int (*fpfi(int (*)(long), int))(int, ...);\n");
        this.parseCandCPP(stringBuffer.toString(), true, 0);
    }

    public void test6_7_5_3s20() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void addscalar(int n, int m,\n");
        stringBuffer.append("double a[n][n*m+300], double x);\n");
        stringBuffer.append("int main()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("double b[4][308];\n");
        stringBuffer.append("addscalar(4, 2, b, 2.17);\n");
        stringBuffer.append("return 0;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("void addscalar(int n, int m,\n");
        stringBuffer.append("double a[n][n*m+300], double x)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("for (int i = 0; i < n; i++)\n");
        stringBuffer.append("for (int j = 0, k = n*m+300; j < k; j++)\n");
        stringBuffer.append("// a is a pointer to a VLA with n*m+300 elements\n");
        stringBuffer.append("a[i][j] += x;\n");
        stringBuffer.append("}\n");
        this.parseCandCPP(stringBuffer.toString(), true, 0);
    }

    public void test6_7_5_3s21() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("double maximum1(int n, int m, double a[n][m]);\n");
        stringBuffer.append("double maximum2(int n, int m, double a[*][*]);\n");
        stringBuffer.append("double maximum3(int n, int m, double a[ ][*]);\n");
        stringBuffer.append("double maximum4(int n, int m, double a[ ][m]);\n");
        stringBuffer.append("void f1(double (* restrict a)[5]);\n");
        stringBuffer.append("void f2(double a[restrict][5]);\n");
        stringBuffer.append("void f3(double a[restrict 3][5]);\n");
        stringBuffer.append("void f4(double a[restrict static 3][5]);\n");
        this.parse(stringBuffer.toString(), ParserLanguage.C, true, 0);
    }

    public void test6_7_7s4() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("typedef int MILES, KLICKSP();\n");
        stringBuffer.append("typedef struct { double hi, lo; } range;\n");
        stringBuffer.append("MILES distance;\n");
        stringBuffer.append("extern KLICKSP *metricp;\n");
        stringBuffer.append("range x;\n");
        stringBuffer.append("range z, *zp;\n");
        this.parseCandCPP(stringBuffer.toString(), true, 0);
    }

    public void test6_7_7s5() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("typedef struct s1 { int x; } t1, *tp1;\n");
        stringBuffer.append("typedef struct s2 { int x; } t2, *tp2;\n");
        this.parseCandCPP(stringBuffer.toString(), true, 0);
    }

    public void test6_7_7s7() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("typedef void fv(int), (*pfv)(int);\n");
        stringBuffer.append("void (*signal(int, void (*)(int)))(int);\n");
        stringBuffer.append("fv *signal(int, fv *);\n");
        stringBuffer.append("pfv signal(int, pfv);\n");
        this.parseCandCPP(stringBuffer.toString(), true, 0);
    }

    public void test6_7_7s8() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void copyt(int n)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("typedef int B[n]; // B is n ints, n evaluated now\n");
        stringBuffer.append("n += 1;\n");
        stringBuffer.append("B a; // ais n ints, n without += 1\n");
        stringBuffer.append("int b[n]; // a and b are different sizes\n");
        stringBuffer.append("for (int i = 1; i < n; i++)\n");
        stringBuffer.append("a[i-1] = b[i];\n");
        stringBuffer.append("}\n");
        this.parseCandCPP(stringBuffer.toString(), true, 0);
    }

    public void test6_7_8s24() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int i = 3.5;\n");
        stringBuffer.append("complex c = 5 + 3 * I;\n");
        this.parseCandCPP(stringBuffer.toString(), false, 0);
    }

    public void test6_7_8s25() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int x[] = { 1, 3, 5 };\n");
        this.parseCandCPP(stringBuffer.toString(), true, 0);
    }

    public void test6_7_8s26a() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int y[4][3] = {\n");
        stringBuffer.append("{ 1, 3, 5 },\n");
        stringBuffer.append("{ 2, 4, 6 },\n");
        stringBuffer.append("{ 3, 5, 7 },\n");
        stringBuffer.append("};\n");
        this.parseCandCPP(stringBuffer.toString(), true, 0);
    }

    public void test6_7_8s26b() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int y[4][3] = {\n");
        stringBuffer.append("1, 3, 5, 2, 4, 6, 3, 5, 7\n");
        stringBuffer.append("};\n");
        this.parseCandCPP(stringBuffer.toString(), true, 0);
    }

    public void test6_7_8s27() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int z[4][3] = {\n");
        stringBuffer.append("{ 1 }, { 2 }, { 3 }, { 4 }\n");
        stringBuffer.append("};\n");
        this.parseCandCPP(stringBuffer.toString(), true, 0);
    }

    public void test6_7_8s28() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct { int a[3], b; } w[] = { { 1 }, 2 };\n");
        this.parseCandCPP(stringBuffer.toString(), true, 0);
    }

    public void test6_7_8s29() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("short q1[4][3][2] = {\n");
        stringBuffer.append("{ 1 },\n");
        stringBuffer.append("{ 2, 3 },\n");
        stringBuffer.append("{ 4, 5, 6 }\n");
        stringBuffer.append("};\n");
        stringBuffer.append("short q2[4][3][2] = {\n");
        stringBuffer.append("1, 0, 0, 0, 0, 0,\n");
        stringBuffer.append("2, 3, 0, 0, 0, 0,\n");
        stringBuffer.append("4, 5, 6\n");
        stringBuffer.append("};\n");
        stringBuffer.append("short q3[4][3][2] = {\n");
        stringBuffer.append("{\n");
        stringBuffer.append("{ 1 },\n");
        stringBuffer.append("},\n");
        stringBuffer.append("{\n");
        stringBuffer.append("{ 2, 3 },\n");
        stringBuffer.append("},\n");
        stringBuffer.append("{\n");
        stringBuffer.append("{ 4, 5 },\n");
        stringBuffer.append("{ 6 },\n");
        stringBuffer.append("}\n");
        stringBuffer.append("};\n");
        this.parseCandCPP(stringBuffer.toString(), true, 0);
    }

    public void test6_7_8s31() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("typedef int A[]; // OK - declared with block scope\n");
        stringBuffer.append("A a1 = { 1, 2 }, b1 = { 3, 4, 5 };\n");
        stringBuffer.append("int a2[] = { 1, 2 }, b2[] = { 3, 4, 5 };\n");
        this.parseCandCPP(stringBuffer.toString(), true, 0);
    }

    public void test6_7_8s32() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int foo() {\n");
        stringBuffer.append("char s1[] = \"abc\", t1[3] = \"abc\";\n");
        stringBuffer.append("char s2[] = { 'a', 'b', 'c', '\u0000' },\n");
        stringBuffer.append("t2[] = { 'a', 'b', 'c' };\n");
        stringBuffer.append("char *p = \"abc\";\n");
        stringBuffer.append("}\n");
        this.parseCandCPP(stringBuffer.toString(), true, 0);
    }

    public void test6_7_8s33() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("enum { member_one, member_two };\n");
        stringBuffer.append("const char *nm[] = {\n");
        stringBuffer.append("[member_two] = \"member two\",\n");
        stringBuffer.append("[member_one] = \"member one\",\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.C, true, 0);
    }

    public void test6_7_8s34() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("div_t answer = { .quot = 2, .rem = -1 };\n");
        this.parse(stringBuffer.toString(), ParserLanguage.C, true, 0);
    }

    public void test6_7_8s35() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct { int a[3], b; } w[] =\n");
        stringBuffer.append("{ [0].a = {1}, [1].a[0] = 2 };\n");
        this.parse(stringBuffer.toString(), ParserLanguage.C, true, 0);
    }

    public void test6_7_8s36() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int MAX=15;\n");
        stringBuffer.append("int a[MAX] = {\n");
        stringBuffer.append("1, 3, 5, 7, 9, [MAX-5] = 8, 6, 4, 2, 0\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.C, true, 0);
    }

    public void test6_7_8s38() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("union { int any_member; } u = { .any_member = 42 };\n");
        this.parse(stringBuffer.toString(), ParserLanguage.C, true, 0);
    }

    public void test6_8_3s4() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int p(int);\n");
        stringBuffer.append("int f() {\n");
        stringBuffer.append("(void)p(0);\n");
        stringBuffer.append("}\n");
        this.parseCandCPP(stringBuffer.toString(), true, 0);
    }

    public void test6_8_3s5() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int f() {\n");
        stringBuffer.append("char *s;\n");
        stringBuffer.append("while (*s++ != '\u0000')\n");
        stringBuffer.append(";\n");
        stringBuffer.append("}\n");
        this.parseCandCPP(stringBuffer.toString(), true, 0);
    }

    public void test6_8_3s6() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int f() {\n");
        stringBuffer.append("int i=1;\n");
        stringBuffer.append("while (i) {\n");
        stringBuffer.append("while (1) {\n");
        stringBuffer.append("i=0;\n");
        stringBuffer.append("if (1)\n");
        stringBuffer.append("goto end_loop1;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("end_loop1: ;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("}\n");
        this.parseCandCPP(stringBuffer.toString(), true, 0);
    }

    public void test6_8_4s7() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int f(int a) {}\n");
        stringBuffer.append("int g(int expr) {\n");
        stringBuffer.append("switch (expr)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("int i = 4;\n");
        stringBuffer.append("f(i);\n");
        stringBuffer.append("case 0:\n");
        stringBuffer.append("i = 17;\n");
        stringBuffer.append("default:\n");
        stringBuffer.append("f(i+1);\n");
        stringBuffer.append("}\n");
        stringBuffer.append("}\n");
        this.parseCandCPP(stringBuffer.toString(), true, 0);
    }

    public void test6_8_6_1s3() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int f() {\n");
        stringBuffer.append("goto first_time;\n");
        stringBuffer.append("for (;;) {\n");
        stringBuffer.append("// determine next operation\n");
        stringBuffer.append("if (1) {\n");
        stringBuffer.append("// reinitialize-only code\n");
        stringBuffer.append("first_time:\n");
        stringBuffer.append("// general initialization code\n");
        stringBuffer.append("continue;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("// handle other operations\n");
        stringBuffer.append("}\n");
        stringBuffer.append("}\n");
        this.parseCandCPP(stringBuffer.toString(), true, 0);
    }

    public void test6_8_6_1s4() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int f() {\n");
        stringBuffer.append("goto lab3; // invalid: going INTO scope of VLA.\n");
        stringBuffer.append("{\n");
        stringBuffer.append("double a[n];\n");
        stringBuffer.append("a[j] = 4.4;\n");
        stringBuffer.append("lab3:\n");
        stringBuffer.append("a[j] = 3.3;\n");
        stringBuffer.append("goto lab4; // valid: going WITHIN scope of VLA.\n");
        stringBuffer.append("a[j] = 5.5;\n");
        stringBuffer.append("lab4:\n");
        stringBuffer.append("a[j] = 6.6;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("goto lab4; // invalid: going INTO scope of VLA.\n");
        stringBuffer.append("}\n");
        this.parseCandCPP(stringBuffer.toString(), false, 0);
    }

    public void test6_8_6_4s4() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct s { double i; } f(void);\n");
        stringBuffer.append("union {\n");
        stringBuffer.append("struct {\n");
        stringBuffer.append("int f1;\n");
        stringBuffer.append("struct s f2;\n");
        stringBuffer.append("} u1;\n");
        stringBuffer.append("struct {\n");
        stringBuffer.append("struct s f3;\n");
        stringBuffer.append("int f4;\n");
        stringBuffer.append("} u2;\n");
        stringBuffer.append("} g;\n");
        stringBuffer.append("struct s f(void)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("return g.u1.f2;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("int foo() {\n");
        stringBuffer.append("g.u2.f3 = f();\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.C, true, 0);
    }

    public void test6_9_1s13() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("extern int max(int a, int b)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("return a > b ? a : b;\n");
        stringBuffer.append("}\n");
        this.parseCandCPP(stringBuffer.toString(), true, 0);
    }

    public void test6_9_1s14() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void g(int (*funcp)(void))\n");
        stringBuffer.append("{\n");
        stringBuffer.append("(*funcp)();\n");
        stringBuffer.append("funcp();\n");
        stringBuffer.append("}\n");
        this.parseCandCPP(stringBuffer.toString(), true, 0);
    }

    public void test6_9_2s4() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int i1 = 1; // definition, external linkage\n");
        stringBuffer.append("static int i2 = 2; // definition, internal linkage\n");
        stringBuffer.append("extern int i3 = 3; // definition, external linkage\n");
        stringBuffer.append("int i4; // tentative definition, external linkage\n");
        stringBuffer.append("static int i5; // tentative definition, internal linkage\n");
        stringBuffer.append("int i1; // valid tentative definition, refers to pre vious\n");
        stringBuffer.append("//int i2; // 6.2.2 renders undefined, linkage disagreement\n");
        stringBuffer.append("int i3; // valid tentative definition, refers to pre vious\n");
        stringBuffer.append("int i4; // valid tentative definition, refers to pre vious\n");
        stringBuffer.append("//int i5; // 6.2.2 renders undefined, linkage disagreement\n");
        stringBuffer.append("extern int i1; // refers to pre vious, whose linkage is external\n");
        stringBuffer.append("extern int i2; // refers to pre vious, whose linkage is internal\n");
        stringBuffer.append("extern int i3; // refers to pre vious, whose linkage is external\n");
        stringBuffer.append("extern int i4; // refers to pre vious, whose linkage is external\n");
        stringBuffer.append("extern int i5; // refers to pre vious, whose linkage is internal\n");
        this.parseCandCPP(stringBuffer.toString(), true, 0);
    }

    public void test6_10_1s4() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int g() {}\n");
        stringBuffer.append("int f() {\n");
        stringBuffer.append("#if 'z' - 'a' == 25\n");
        stringBuffer.append("g();\n");
        stringBuffer.append("#endif\n");
        stringBuffer.append("if ('z' - 'a' == 25)\n");
        stringBuffer.append("g();\n");
        stringBuffer.append("}\n");
        this.parseCandCPP(stringBuffer.toString(), true, 0);
    }

    public void test6_10_3_3s4() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#define hash_hash # ## #\n");
        stringBuffer.append("#define mkstr(a) # a\n");
        stringBuffer.append("#define in_between(a) mkstr(a)\n");
        stringBuffer.append("#define join(c, d) in_between(c hash_hash d)\n");
        stringBuffer.append("char p[] = join(x, y); // equivalent to\n");
        stringBuffer.append("// char p[] = \"x ## y\";\n");
        this.parseCandCPP(stringBuffer.toString(), true, 0);
    }

    public void test6_10_3_5s3() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#define TABSIZE 100\n");
        stringBuffer.append("int table[TABSIZE];\n");
        this.parseCandCPP(stringBuffer.toString(), true, 0);
    }

    public void test6_10_3_5s4() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#define max(a, b) ((a) > (b) ? (a) : (b))\n");
        this.parseCandCPP(stringBuffer.toString(), true, 0);
    }

    public void test6_10_3_5s6() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#define str(s) # s                    \n");
        stringBuffer.append("#define xstr(s) str(s)                \n");
        stringBuffer.append("#define debug(s, t) printf(\"x\" # s \"= %d, x\" # t \"= %s\", \\\n");
        stringBuffer.append("x ## s, x ## t)                       \n");
        stringBuffer.append("#define INCFILE(n) vers ## n          \n");
        stringBuffer.append("#define glue(a, b) a ## b             \n");
        stringBuffer.append("#define xglue(a, b) glue(a, b)        \n");
        stringBuffer.append("#define HIGHLOW \"hello\"             \n");
        stringBuffer.append("#define LOW LOW \", world\"           \n");
        stringBuffer.append("void printf( char *, ...);            \n");
        stringBuffer.append("void fputs( char *, ... );            \n");
        stringBuffer.append("int x1, x2, s;                        \n");
        stringBuffer.append("int f() {                             \n");
        stringBuffer.append("   debug(1, 2);                       \n");
        stringBuffer.append("   fputs(str(strncmp(\"abc\u0000d\", \"abc\", '\u0004') // this goes away\n");
        stringBuffer.append("   == 0) str(: @\n), s);              \n");
        stringBuffer.append("   char * c = glue(HIGH, LOW);        \n");
        stringBuffer.append("   c = xglue(HIGH, LOW);              \n");
        stringBuffer.append("}                                     \n");
        this.parseCandCPP(stringBuffer.toString(), false, 0);
    }

    public void test6_10_3_5s8() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#define OBJ_LIKE1 (1-1)\n");
        stringBuffer.append("#define OBJ_LIKE2    \\n");
        stringBuffer.append("         (1-1)       \\n");
        stringBuffer.append("#define FUNC_LIKE1(a) ( a )\n");
        stringBuffer.append("#define FUNC_LIKE2( a )(              \\n");
        stringBuffer.append("                 a                    \\n");
        stringBuffer.append("                                      )\n");
        this.parseCandCPP(stringBuffer.toString(), true, 0);
    }

    public void test6_10_3_5s9() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#define debug(...) fprintf(stderr, __VA_ARGS__)\n");
        stringBuffer.append("#define showlist(...) puts(#__VA_ARGS__)\n");
        stringBuffer.append("#define report(test, ...) ((test)?puts(#test):\\\n");
        stringBuffer.append("printf(__VA_ARGS__))                             \n");
        stringBuffer.append("void fprintf( ... );                             \n");
        stringBuffer.append("void puts(char * );                              \n");
        stringBuffer.append("void printf( char *, ... );                      \n");
        stringBuffer.append("int stderr, x, y;                                \n");
        stringBuffer.append("int f() {                                        \n");
        stringBuffer.append("   debug(\"Flag\");                              \n");
        stringBuffer.append("   debug(\"X = %d\\n\", x);                      \n");
        stringBuffer.append("   showlist(The first, second, and third items.);\n");
        stringBuffer.append("   report(x>y, \"x is %d but y is %d\", x, y);   \n");
        stringBuffer.append("}                                                \n");
        this.parseCandCPP(stringBuffer.toString(), false, 0);
    }
}

