/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests.ast2;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.cdt.core.dom.ICodeReaderFactory;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.c.CASTVisitor;
import org.eclipse.cdt.core.dom.ast.cpp.CPPASTVisitor;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.NullLogService;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.internal.core.dom.parser.c.ANSICParserExtensionConfiguration;
import org.eclipse.cdt.internal.core.dom.parser.c.CVisitor;
import org.eclipse.cdt.internal.core.dom.parser.c.GCCParserExtensionConfiguration;
import org.eclipse.cdt.internal.core.dom.parser.c.GNUCSourceParser;
import org.eclipse.cdt.internal.core.dom.parser.c.ICParserExtensionConfiguration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ANSICPPParserExtensionConfiguration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.GNUCPPSourceParser;
import org.eclipse.cdt.internal.core.dom.parser.cpp.GPPParserExtensionConfiguration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPParserExtensionConfiguration;
import org.eclipse.cdt.internal.core.parser.ParserException;
import org.eclipse.cdt.internal.core.parser.scanner2.DOMScanner;
import org.eclipse.cdt.internal.core.parser.scanner2.FileCodeReaderFactory;
import org.eclipse.cdt.internal.core.parser.scanner2.GCCScannerExtensionConfiguration;
import org.eclipse.cdt.internal.core.parser.scanner2.GPPScannerExtensionConfiguration;
import org.eclipse.cdt.internal.core.parser.scanner2.IScannerExtensionConfiguration;

public class AST2SpecBaseTest
extends TestCase {
    private static final IParserLogService NULL_LOG = new NullLogService();

    protected void parseCandCPP(String string, boolean bl, int n) throws ParserException {
        this.parse(string, ParserLanguage.C, false, true, bl, n);
        this.parse(string, ParserLanguage.CPP, false, true, bl, n);
    }

    protected IASTTranslationUnit parse(String string, ParserLanguage parserLanguage, boolean bl, int n) throws ParserException {
        return this.parse(string, parserLanguage, false, true, bl, n);
    }

    private IASTTranslationUnit parse(String string, ParserLanguage parserLanguage, boolean bl, boolean bl2, boolean bl3, int n) throws ParserException {
        CodeReader codeReader = new CodeReader(string.toCharArray());
        return this.parse(codeReader, parserLanguage, bl, bl2, bl3, n);
    }

    private IASTTranslationUnit parse(CodeReader codeReader, ParserLanguage parserLanguage, boolean bl, boolean bl2, boolean bl3, int n) throws ParserException {
        Object object;
        ScannerInfo scannerInfo = new ScannerInfo();
        Object object2 = null;
        object2 = parserLanguage == ParserLanguage.C ? new GCCScannerExtensionConfiguration() : new GPPScannerExtensionConfiguration();
        DOMScanner dOMScanner = new DOMScanner(codeReader, (IScannerInfo)scannerInfo, ParserMode.COMPLETE_PARSE, parserLanguage, NULL_LOG, (IScannerExtensionConfiguration)object2, (ICodeReaderFactory)FileCodeReaderFactory.getInstance());
        GNUCPPSourceParser gNUCPPSourceParser = null;
        if (parserLanguage == ParserLanguage.CPP) {
            object = null;
            object = bl ? new GPPParserExtensionConfiguration() : new ANSICPPParserExtensionConfiguration();
            gNUCPPSourceParser = new GNUCPPSourceParser((IScanner)dOMScanner, ParserMode.COMPLETE_PARSE, NULL_LOG, (ICPPParserExtensionConfiguration)object);
        } else {
            object = null;
            object = bl ? new GCCParserExtensionConfiguration() : new ANSICParserExtensionConfiguration();
            gNUCPPSourceParser = new GNUCSourceParser((IScanner)dOMScanner, ParserMode.COMPLETE_PARSE, NULL_LOG, (ICParserExtensionConfiguration)object);
        }
        object = gNUCPPSourceParser.parse();
        if (bl3) {
            if (parserLanguage == ParserLanguage.CPP) {
                CPPNameResolver cPPNameResolver = new CPPNameResolver();
                object.accept((ASTVisitor)cPPNameResolver);
                if (cPPNameResolver.numProblemBindings != n) {
                    throw new ParserException("Expected " + n + " problems, encountered " + cPPNameResolver.numProblemBindings);
                }
            } else if (parserLanguage == ParserLanguage.C) {
                CNameResolver cNameResolver = new CNameResolver();
                object.accept((ASTVisitor)cNameResolver);
                if (cNameResolver.numProblemBindings != n) {
                    throw new ParserException("Expected " + n + " problems, encountered " + cNameResolver.numProblemBindings);
                }
            }
        }
        if (gNUCPPSourceParser.encounteredError() && bl2) {
            throw new ParserException("FAILURE");
        }
        if (parserLanguage == ParserLanguage.C && bl2) {
            if (CVisitor.getProblems((IASTTranslationUnit)object).length != 0) {
                throw new ParserException(" CVisitor has AST Problems ");
            }
            if (object.getPreprocessorProblems().length != 0) {
                throw new ParserException(" C TranslationUnit has Preprocessor Problems ");
            }
        } else if (parserLanguage == ParserLanguage.CPP && bl2) {
            if (CPPVisitor.getProblems((IASTTranslationUnit)object).length != 0) {
                throw new ParserException(" CPPVisitor has AST Problems ");
            }
            if (object.getPreprocessorProblems().length != 0) {
                throw new ParserException(" CPP TranslationUnit has Preprocessor Problems ");
            }
        }
        return object;
    }

    protected static class CNameResolver
    extends CASTVisitor {
        public int numProblemBindings;
        public int numNullBindings;
        public List nameList;

        protected CNameResolver() {
            this.shouldVisitNames = true;
            this.numProblemBindings = 0;
            this.numNullBindings = 0;
            this.nameList = new ArrayList();
        }

        public int visit(IASTName iASTName) {
            this.nameList.add(iASTName);
            IBinding iBinding = iASTName.resolveBinding();
            if (iBinding instanceof IProblemBinding) {
                ++this.numProblemBindings;
            }
            if (iBinding == null) {
                ++this.numNullBindings;
            }
            return 3;
        }

        public IASTName getName(int n) {
            if (n < 0 || n >= this.nameList.size()) {
                return null;
            }
            return (IASTName)this.nameList.get(n);
        }

        public int size() {
            return this.nameList.size();
        }
    }

    protected static class CPPNameResolver
    extends CPPASTVisitor {
        public int numProblemBindings;
        public int numNullBindings;
        public List nameList;

        protected CPPNameResolver() {
            this.shouldVisitNames = true;
            this.numProblemBindings = 0;
            this.numNullBindings = 0;
            this.nameList = new ArrayList();
        }

        public int visit(IASTName iASTName) {
            this.nameList.add(iASTName);
            IBinding iBinding = iASTName.resolveBinding();
            if (iBinding instanceof IProblemBinding) {
                ++this.numProblemBindings;
            }
            if (iBinding == null) {
                ++this.numNullBindings;
            }
            return 3;
        }

        public IASTName getName(int n) {
            if (n < 0 || n >= this.nameList.size()) {
                return null;
            }
            return (IASTName)this.nameList.get(n);
        }

        public int size() {
            return this.nameList.size();
        }
    }
}

