/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests.ast2;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplatePartialSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPDelegate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateNonTypeParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateTypeParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPVariable;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.tests.ast2.AST2BaseTest;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPVisitor;

public class AST2TemplateTests
extends AST2BaseTest {
    public void testBasicClassTemplate() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("template <class T> class A{ T t; };", ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        AST2TemplateTests.assertEquals((int)cPPNameCollector.size(), (int)4);
        ICPPClassTemplate iCPPClassTemplate = (ICPPClassTemplate)cPPNameCollector.getName(1).resolveBinding();
        ICPPTemplateParameter iCPPTemplateParameter = (ICPPTemplateParameter)cPPNameCollector.getName(0).resolveBinding();
        ICPPTemplateScope iCPPTemplateScope = (ICPPTemplateScope)iCPPTemplateParameter.getScope();
        IScope iScope = iCPPClassTemplate.getScope();
        AST2TemplateTests.assertSame((Object)iCPPTemplateScope, (Object)iScope);
        ICPPField iCPPField = (ICPPField)cPPNameCollector.getName(3).resolveBinding();
        ICPPTemplateParameter iCPPTemplateParameter2 = (ICPPTemplateParameter)cPPNameCollector.getName(2).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPTemplateParameter, (Object)iCPPTemplateParameter2);
        IType iType = iCPPField.getType();
        AST2TemplateTests.assertSame((Object)iType, (Object)iCPPTemplateParameter);
        AST2TemplateTests.assertNotNull((Object)iCPPTemplateParameter);
        AST2TemplateTests.assertNotNull((Object)iCPPClassTemplate);
    }

    public void testBasicTemplateInstance_1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template < class T > class A {             \n");
        stringBuffer.append("   T t1;                                   \n");
        stringBuffer.append("   T * t2;                                 \n");
        stringBuffer.append("};                                         \n");
        stringBuffer.append("void f(){                                  \n");
        stringBuffer.append("   A<int> a;                               \n");
        stringBuffer.append("   a.t1; a.t2;                             \n");
        stringBuffer.append("}                                          \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        AST2TemplateTests.assertEquals((int)cPPNameCollector.size(), (int)14);
        ICPPClassTemplate iCPPClassTemplate = (ICPPClassTemplate)cPPNameCollector.getName(1).resolveBinding();
        ICPPTemplateParameter iCPPTemplateParameter = (ICPPTemplateParameter)cPPNameCollector.getName(0).resolveBinding();
        ICPPField iCPPField = (ICPPField)cPPNameCollector.getName(3).resolveBinding();
        ICPPField iCPPField2 = (ICPPField)cPPNameCollector.getName(5).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPField.getType(), (Object)iCPPTemplateParameter);
        AST2TemplateTests.assertSame((Object)((IPointerType)iCPPField2.getType()).getType(), (Object)iCPPTemplateParameter);
        ICPPVariable iCPPVariable = (ICPPVariable)cPPNameCollector.getName(9).resolveBinding();
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(7).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPClassType, (Object)iCPPVariable.getType());
        AST2TemplateTests.assertTrue((boolean)(iCPPClassType instanceof ICPPTemplateInstance));
        AST2TemplateTests.assertSame((Object)((ICPPTemplateInstance)iCPPClassType).getTemplateDefinition(), (Object)iCPPClassTemplate);
        ICPPClassScope iCPPClassScope = (ICPPClassScope)iCPPClassType.getCompositeScope();
        AST2TemplateTests.assertNotSame((Object)iCPPClassScope, (Object)((ICompositeType)iCPPClassTemplate).getCompositeScope());
        ICPPField iCPPField3 = (ICPPField)cPPNameCollector.getName(11).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iCPPField3 instanceof ICPPSpecialization));
        AST2TemplateTests.assertSame((Object)((ICPPSpecialization)iCPPField3).getSpecializedBinding(), (Object)iCPPField);
        AST2TemplateTests.assertSame((Object)iCPPField3.getScope(), (Object)iCPPClassScope);
        IType iType = iCPPField3.getType();
        AST2TemplateTests.assertTrue((boolean)(iType instanceof IBasicType));
        AST2TemplateTests.assertEquals((int)((IBasicType)iType).getType(), (int)3);
        iCPPField3 = (ICPPField)cPPNameCollector.getName(13).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iCPPField3 instanceof ICPPSpecialization));
        AST2TemplateTests.assertSame((Object)((ICPPSpecialization)iCPPField3).getSpecializedBinding(), (Object)iCPPField2);
        AST2TemplateTests.assertSame((Object)iCPPField3.getScope(), (Object)iCPPClassScope);
        iType = iCPPField3.getType();
        AST2TemplateTests.assertTrue((boolean)(iType instanceof IPointerType));
        AST2TemplateTests.assertTrue((boolean)(((IPointerType)iType).getType() instanceof IBasicType));
        AST2TemplateTests.assertEquals((int)((IBasicType)((IPointerType)iType).getType()).getType(), (int)3);
    }

    public void testBasicTemplateInstance_2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template < class T > class A {             \n");
        stringBuffer.append("   T f( T *);                              \n");
        stringBuffer.append("};                                         \n");
        stringBuffer.append("void g(){                                  \n");
        stringBuffer.append("   A<int> a;                               \n");
        stringBuffer.append("   a.f( (int*)0 );                         \n");
        stringBuffer.append("}                                          \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(1).resolveBinding();
        ICPPTemplateParameter iCPPTemplateParameter = (ICPPTemplateParameter)cPPNameCollector.getName(0).resolveBinding();
        ICPPMethod iCPPMethod = (ICPPMethod)cPPNameCollector.getName(3).resolveBinding();
        IFunctionType iFunctionType = iCPPMethod.getType();
        AST2TemplateTests.assertSame((Object)iFunctionType.getReturnType(), (Object)iCPPTemplateParameter);
        AST2TemplateTests.assertSame((Object)((IPointerType)iFunctionType.getParameterTypes()[0]).getType(), (Object)iCPPTemplateParameter);
        ICPPClassType iCPPClassType2 = (ICPPClassType)cPPNameCollector.getName(7).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iCPPClassType2 instanceof ICPPTemplateInstance));
        AST2TemplateTests.assertSame((Object)((ICPPTemplateInstance)iCPPClassType2).getTemplateDefinition(), (Object)iCPPClassType);
        ICPPMethod iCPPMethod2 = (ICPPMethod)cPPNameCollector.getName(11).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iCPPMethod2 instanceof ICPPSpecialization));
        AST2TemplateTests.assertSame((Object)((ICPPSpecialization)iCPPMethod2).getSpecializedBinding(), (Object)iCPPMethod);
        iFunctionType = iCPPMethod2.getType();
        AST2TemplateTests.assertTrue((boolean)(iFunctionType.getReturnType() instanceof IBasicType));
        AST2TemplateTests.assertTrue((boolean)(((IPointerType)iFunctionType.getParameterTypes()[0]).getType() instanceof IBasicType));
    }

    public void testBasicTemplateFunction() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template <class T > void f( T );          \n");
        stringBuffer.append("template <class T > void f( T ) {         \n");
        stringBuffer.append("   T * d;                                 \n");
        stringBuffer.append("}                                         \n");
        stringBuffer.append("void foo() {                              \n");
        stringBuffer.append("   f<int>( 0 );                           \n");
        stringBuffer.append("}                                         \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPFunctionTemplate iCPPFunctionTemplate = (ICPPFunctionTemplate)cPPNameCollector.getName(1).resolveBinding();
        ICPPTemplateParameter iCPPTemplateParameter = (ICPPTemplateParameter)cPPNameCollector.getName(0).resolveBinding();
        IParameter iParameter = (IParameter)cPPNameCollector.getName(3).resolveBinding();
        ICPPTemplateParameter iCPPTemplateParameter2 = (ICPPTemplateParameter)cPPNameCollector.getName(4).resolveBinding();
        ICPPFunction iCPPFunction = (ICPPFunction)cPPNameCollector.getName(5).resolveBinding();
        IParameter iParameter2 = (IParameter)cPPNameCollector.getName(7).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPTemplateParameter, (Object)iCPPTemplateParameter2);
        AST2TemplateTests.assertSame((Object)iCPPFunctionTemplate, (Object)iCPPFunction);
        AST2TemplateTests.assertSame((Object)iParameter, (Object)iParameter2);
        AST2TemplateTests.assertSame((Object)iParameter.getType(), (Object)iCPPTemplateParameter);
        ICPPFunction iCPPFunction2 = (ICPPFunction)cPPNameCollector.getName(11).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iCPPFunction2 instanceof ICPPTemplateInstance));
        AST2TemplateTests.assertSame((Object)((ICPPTemplateInstance)iCPPFunction2).getTemplateDefinition(), (Object)iCPPFunctionTemplate);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPTemplateParameter, 5);
    }

    public void testStackOverflow() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template < class T > class pair {                \n");
        stringBuffer.append("   template < class U > pair( const pair<U> & ); \n");
        stringBuffer.append("};                                               \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        AST2TemplateTests.assertTrue((boolean)(cPPNameCollector.getName(0).resolveBinding() instanceof ICPPTemplateParameter));
        ICPPClassTemplate iCPPClassTemplate = (ICPPClassTemplate)cPPNameCollector.getName(1).resolveBinding();
        ICPPTemplateParameter iCPPTemplateParameter = (ICPPTemplateParameter)cPPNameCollector.getName(2).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(cPPNameCollector.getName(3).resolveBinding() instanceof ICPPFunctionTemplate));
        ICPPTemplateInstance iCPPTemplateInstance = (ICPPTemplateInstance)cPPNameCollector.getName(4).resolveBinding();
        ICPPClassTemplate iCPPClassTemplate2 = (ICPPClassTemplate)cPPNameCollector.getName(5).resolveBinding();
        ICPPTemplateParameter iCPPTemplateParameter2 = (ICPPTemplateParameter)cPPNameCollector.getName(6).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPTemplateParameter, (Object)iCPPTemplateParameter2);
        AST2TemplateTests.assertSame((Object)iCPPClassTemplate, (Object)iCPPClassTemplate2);
        AST2TemplateTests.assertSame((Object)iCPPTemplateInstance.getTemplateDefinition(), (Object)iCPPClassTemplate);
    }

    public void testBasicClassPartialSpecialization() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template < class T > class A {};       \n ");
        stringBuffer.append("template < class T > class A< T* > {}; \n ");
        stringBuffer.append("template < class T > class A< T** > {}; \n ");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPTemplateParameter iCPPTemplateParameter = (ICPPTemplateParameter)cPPNameCollector.getName(0).resolveBinding();
        ICPPClassTemplate iCPPClassTemplate = (ICPPClassTemplate)cPPNameCollector.getName(1).resolveBinding();
        ICPPTemplateParameter iCPPTemplateParameter2 = (ICPPTemplateParameter)cPPNameCollector.getName(2).resolveBinding();
        ICPPClassTemplatePartialSpecialization iCPPClassTemplatePartialSpecialization = (ICPPClassTemplatePartialSpecialization)cPPNameCollector.getName(3).resolveBinding();
        ICPPTemplateParameter iCPPTemplateParameter3 = (ICPPTemplateParameter)cPPNameCollector.getName(5).resolveBinding();
        ICPPClassTemplatePartialSpecialization iCPPClassTemplatePartialSpecialization2 = (ICPPClassTemplatePartialSpecialization)cPPNameCollector.getName(7).resolveBinding();
        ICPPTemplateParameter iCPPTemplateParameter4 = (ICPPTemplateParameter)cPPNameCollector.getName(6).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPClassTemplatePartialSpecialization.getPrimaryClassTemplate(), (Object)iCPPClassTemplate);
        AST2TemplateTests.assertSame((Object)iCPPClassTemplatePartialSpecialization2.getPrimaryClassTemplate(), (Object)iCPPClassTemplate);
        AST2TemplateTests.assertNotSame((Object)iCPPTemplateParameter, (Object)iCPPTemplateParameter2);
        AST2TemplateTests.assertNotSame((Object)iCPPClassTemplate, (Object)iCPPClassTemplatePartialSpecialization);
        AST2TemplateTests.assertNotSame((Object)iCPPClassTemplate, (Object)iCPPClassTemplatePartialSpecialization2);
        AST2TemplateTests.assertNotSame((Object)iCPPClassTemplatePartialSpecialization, (Object)iCPPClassTemplatePartialSpecialization2);
        AST2TemplateTests.assertSame((Object)iCPPTemplateParameter2, (Object)iCPPTemplateParameter3);
        AST2TemplateTests.assertNotSame((Object)iCPPTemplateParameter2, (Object)iCPPTemplateParameter4);
    }

    public void testStackOverflow_2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template < class T > class A { typedef int TYPE; };  \n");
        stringBuffer.append("template < class T > A<T>::TYPE foo( T );            \n");
        stringBuffer.append("template < class T > A<T>::TYPE foo( T );            \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPTemplateParameter iCPPTemplateParameter = (ICPPTemplateParameter)cPPNameCollector.getName(0).resolveBinding();
        ICPPTemplateParameter iCPPTemplateParameter2 = (ICPPTemplateParameter)cPPNameCollector.getName(3).resolveBinding();
        ICPPTemplateParameter iCPPTemplateParameter3 = (ICPPTemplateParameter)cPPNameCollector.getName(12).resolveBinding();
        AST2TemplateTests.assertNotSame((Object)iCPPTemplateParameter, (Object)iCPPTemplateParameter2);
        AST2TemplateTests.assertSame((Object)iCPPTemplateParameter2, (Object)iCPPTemplateParameter3);
        ICPPFunctionTemplate iCPPFunctionTemplate = (ICPPFunctionTemplate)cPPNameCollector.getName(9).resolveBinding();
        ICPPFunctionTemplate iCPPFunctionTemplate2 = (ICPPFunctionTemplate)cPPNameCollector.getName(18).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPFunctionTemplate, (Object)iCPPFunctionTemplate2);
        ITypedef iTypedef = (ITypedef)cPPNameCollector.getName(2).resolveBinding();
        AST2TemplateTests.assertSame((Object)iTypedef, (Object)cPPNameCollector.getName(8).resolveBinding());
        AST2TemplateTests.assertSame((Object)iTypedef, (Object)cPPNameCollector.getName(17).resolveBinding());
        this.assertInstances(cPPNameCollector, (IBinding)iCPPTemplateParameter2, 6);
    }

    public void testTemplateMemberDef() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template < class T > class A {                       \n");
        stringBuffer.append("   void f();                                         \n");
        stringBuffer.append("};                                                   \n");
        stringBuffer.append("template < class T > void A<T>::f() { }              \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPMethod iCPPMethod = (ICPPMethod)cPPNameCollector.getName(2).resolveBinding();
        ICPPMethod iCPPMethod2 = (ICPPMethod)cPPNameCollector.getName(8).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPMethod2, (Object)iCPPMethod);
    }

    public void testTemplateFunctionImplicitInstantiation() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template < class T > void f ( T );           \n");
        stringBuffer.append("void main() {                                \n");
        stringBuffer.append("   f( 1 );                                   \n");
        stringBuffer.append("}                                            \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPFunctionTemplate iCPPFunctionTemplate = (ICPPFunctionTemplate)cPPNameCollector.getName(1).resolveBinding();
        IFunction iFunction = (IFunction)cPPNameCollector.getName(5).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iFunction instanceof ICPPTemplateInstance));
        AST2TemplateTests.assertSame((Object)((ICPPTemplateInstance)iFunction).getTemplateDefinition(), (Object)iCPPFunctionTemplate);
    }

    public void test_14_5_5_2s5_OrderingFunctionTemplates_1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template < class T > void f( T );        \n");
        stringBuffer.append("template < class T > void f( T* );       \n");
        stringBuffer.append("template < class T > void f( const T* ); \n");
        stringBuffer.append("void main() {                            \n");
        stringBuffer.append("   const int *p;                         \n");
        stringBuffer.append("   f( p );                               \n");
        stringBuffer.append("}                                        \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPFunctionTemplate iCPPFunctionTemplate = (ICPPFunctionTemplate)cPPNameCollector.getName(1).resolveBinding();
        ICPPFunctionTemplate iCPPFunctionTemplate2 = (ICPPFunctionTemplate)cPPNameCollector.getName(5).resolveBinding();
        ICPPFunctionTemplate iCPPFunctionTemplate3 = (ICPPFunctionTemplate)cPPNameCollector.getName(9).resolveBinding();
        AST2TemplateTests.assertNotSame((Object)iCPPFunctionTemplate, (Object)iCPPFunctionTemplate2);
        AST2TemplateTests.assertNotSame((Object)iCPPFunctionTemplate2, (Object)iCPPFunctionTemplate3);
        AST2TemplateTests.assertNotSame((Object)iCPPFunctionTemplate3, (Object)iCPPFunctionTemplate);
        IFunction iFunction = (IFunction)cPPNameCollector.getName(14).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iFunction instanceof ICPPTemplateInstance));
        AST2TemplateTests.assertSame((Object)((ICPPTemplateInstance)iFunction).getTemplateDefinition(), (Object)iCPPFunctionTemplate3);
    }

    public void test_14_5_5_2s5_OrderingFunctionTemplates_2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template < class T > void f( T );        \n");
        stringBuffer.append("template < class T > void f( T& );       \n");
        stringBuffer.append("void main() {                            \n");
        stringBuffer.append("   float x;                              \n");
        stringBuffer.append("   f( x );                               \n");
        stringBuffer.append("}                                        \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPFunctionTemplate iCPPFunctionTemplate = (ICPPFunctionTemplate)cPPNameCollector.getName(1).resolveBinding();
        ICPPFunctionTemplate iCPPFunctionTemplate2 = (ICPPFunctionTemplate)cPPNameCollector.getName(5).resolveBinding();
        AST2TemplateTests.assertNotSame((Object)iCPPFunctionTemplate, (Object)iCPPFunctionTemplate2);
        IProblemBinding iProblemBinding = (IProblemBinding)cPPNameCollector.getName(10).resolveBinding();
        AST2TemplateTests.assertEquals((int)iProblemBinding.getID(), (int)4);
    }

    public void testTemplateParameters() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template < class T, template < class X > class U, T *pT > class A {   \n");
        stringBuffer.append("};                                                                    \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPTemplateTypeParameter iCPPTemplateTypeParameter = (ICPPTemplateTypeParameter)cPPNameCollector.getName(0).resolveBinding();
        ICPPTemplateTemplateParameter iCPPTemplateTemplateParameter = (ICPPTemplateTemplateParameter)cPPNameCollector.getName(2).resolveBinding();
        ICPPTemplateNonTypeParameter iCPPTemplateNonTypeParameter = (ICPPTemplateNonTypeParameter)cPPNameCollector.getName(4).resolveBinding();
        ICPPTemplateTypeParameter iCPPTemplateTypeParameter2 = (ICPPTemplateTypeParameter)cPPNameCollector.getName(1).resolveBinding();
        ICPPTemplateParameter[] iCPPTemplateParameterArray = iCPPTemplateTemplateParameter.getTemplateParameters();
        AST2TemplateTests.assertEquals((int)iCPPTemplateParameterArray.length, (int)1);
        AST2TemplateTests.assertSame((Object)iCPPTemplateParameterArray[0], (Object)iCPPTemplateTypeParameter2);
        IPointerType iPointerType = (IPointerType)iCPPTemplateNonTypeParameter.getType();
        AST2TemplateTests.assertSame((Object)iPointerType.getType(), (Object)iCPPTemplateTypeParameter);
    }

    public void testDeferredInstances() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template <class T> class A {        \n");
        stringBuffer.append("   A<T>* a;                         \n");
        stringBuffer.append("   A<T>* a2;                        \n");
        stringBuffer.append("};                                  \n");
        stringBuffer.append("void f(){                           \n");
        stringBuffer.append("   A<int> * b;                      \n");
        stringBuffer.append("   b->a;                            \n");
        stringBuffer.append("}                                   \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPClassTemplate iCPPClassTemplate = (ICPPClassTemplate)cPPNameCollector.getName(1).resolveBinding();
        ICPPTemplateInstance iCPPTemplateInstance = (ICPPTemplateInstance)cPPNameCollector.getName(2).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPTemplateInstance.getTemplateDefinition(), (Object)iCPPClassTemplate);
        ICPPTemplateInstance iCPPTemplateInstance2 = (ICPPTemplateInstance)cPPNameCollector.getName(6).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPTemplateInstance, (Object)iCPPTemplateInstance2);
        ICPPVariable iCPPVariable = (ICPPVariable)cPPNameCollector.getName(5).resolveBinding();
        IPointerType iPointerType = (IPointerType)iCPPVariable.getType();
        AST2TemplateTests.assertSame((Object)iPointerType.getType(), (Object)iCPPTemplateInstance);
        ICPPVariable iCPPVariable2 = (ICPPVariable)cPPNameCollector.getName(13).resolveBinding();
        IType iType = iCPPVariable2.getType();
        AST2TemplateTests.assertTrue((boolean)(iType instanceof IPointerType));
        ICPPVariable iCPPVariable3 = (ICPPVariable)cPPNameCollector.getName(15).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iCPPVariable3 instanceof ICPPSpecialization));
        AST2TemplateTests.assertSame((Object)((ICPPSpecialization)iCPPVariable3).getSpecializedBinding(), (Object)iCPPVariable);
        IType iType2 = iCPPVariable3.getType();
        AST2TemplateTests.assertTrue((boolean)(iType2 instanceof IPointerType));
        AST2TemplateTests.assertSame((Object)((IPointerType)iType2).getType(), (Object)((IPointerType)iType).getType());
    }

    public void test_14_5_4_1s2_MatchingTemplateSpecializations() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template < class T1, class T2, int I > class A                {}; //#1   \n");
        stringBuffer.append("template < class T, int I >            class A < T, T*, I >   {}; //#2   \n");
        stringBuffer.append("template < class T1, class T2, int I > class A < T1*, T2, I > {}; //#3   \n");
        stringBuffer.append("template < class T >                   class A < int, T*, 5 > {}; //#4   \n");
        stringBuffer.append("template < class T1, class T2, int I > class A < T1, T2*, I > {}; //#5   \n");
        stringBuffer.append("A <int, int, 1>   a1;\t\t//uses #1                                    \n");
        stringBuffer.append("A <int, int*, 1>  a2;\t\t//uses #2, T is int, I is 1                  \n");
        stringBuffer.append("A <int, char*, 5> a3;\t\t//uses #4, T is char                         \n");
        stringBuffer.append("A <int, char*, 1> a4;\t\t//uses #5, T is int, T2 is char, I is1       \n");
        stringBuffer.append("A <int*, int*, 2> a5;\t\t//ambiguous, matches #3 & #5.                \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPClassTemplate iCPPClassTemplate = (ICPPClassTemplate)cPPNameCollector.getName(3).resolveBinding();
        ICPPClassTemplate iCPPClassTemplate2 = (ICPPClassTemplate)cPPNameCollector.getName(6).resolveBinding();
        ICPPClassTemplate iCPPClassTemplate3 = (ICPPClassTemplate)cPPNameCollector.getName(14).resolveBinding();
        ICPPClassTemplate iCPPClassTemplate4 = (ICPPClassTemplate)cPPNameCollector.getName(20).resolveBinding();
        ICPPClassTemplate iCPPClassTemplate5 = (ICPPClassTemplate)cPPNameCollector.getName(26).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iCPPClassTemplate3 instanceof ICPPClassTemplatePartialSpecialization));
        AST2TemplateTests.assertSame((Object)((ICPPClassTemplatePartialSpecialization)iCPPClassTemplate3).getPrimaryClassTemplate(), (Object)iCPPClassTemplate);
        ICPPTemplateTypeParameter iCPPTemplateTypeParameter = (ICPPTemplateTypeParameter)cPPNameCollector.getName(11).resolveBinding();
        ICPPTemplateTypeParameter iCPPTemplateTypeParameter2 = (ICPPTemplateTypeParameter)cPPNameCollector.getName(12).resolveBinding();
        ICPPTemplateNonTypeParameter iCPPTemplateNonTypeParameter = (ICPPTemplateNonTypeParameter)cPPNameCollector.getName(13).resolveBinding();
        ICPPTemplateParameter iCPPTemplateParameter = (ICPPTemplateParameter)cPPNameCollector.getName(16).resolveBinding();
        ICPPTemplateParameter iCPPTemplateParameter2 = (ICPPTemplateParameter)cPPNameCollector.getName(17).resolveBinding();
        ICPPTemplateParameter iCPPTemplateParameter3 = (ICPPTemplateParameter)cPPNameCollector.getName(18).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPTemplateTypeParameter, (Object)iCPPTemplateParameter);
        AST2TemplateTests.assertSame((Object)iCPPTemplateTypeParameter2, (Object)iCPPTemplateParameter2);
        AST2TemplateTests.assertSame((Object)iCPPTemplateNonTypeParameter, (Object)iCPPTemplateParameter3);
        ICPPTemplateInstance iCPPTemplateInstance = (ICPPTemplateInstance)cPPNameCollector.getName(31).resolveBinding();
        ICPPTemplateInstance iCPPTemplateInstance2 = (ICPPTemplateInstance)cPPNameCollector.getName(34).resolveBinding();
        ICPPTemplateInstance iCPPTemplateInstance3 = (ICPPTemplateInstance)cPPNameCollector.getName(37).resolveBinding();
        ICPPTemplateInstance iCPPTemplateInstance4 = (ICPPTemplateInstance)cPPNameCollector.getName(40).resolveBinding();
        IProblemBinding iProblemBinding = (IProblemBinding)cPPNameCollector.getName(43).resolveBinding();
        AST2TemplateTests.assertEquals((int)iProblemBinding.getID(), (int)4);
        AST2TemplateTests.assertSame((Object)iCPPTemplateInstance.getTemplateDefinition(), (Object)iCPPClassTemplate);
        AST2TemplateTests.assertSame((Object)iCPPTemplateInstance2.getTemplateDefinition(), (Object)iCPPClassTemplate2);
        AST2TemplateTests.assertSame((Object)iCPPTemplateInstance4.getTemplateDefinition(), (Object)iCPPClassTemplate5);
        AST2TemplateTests.assertSame((Object)iCPPTemplateInstance3.getTemplateDefinition(), (Object)iCPPClassTemplate4);
    }

    public void test14_7_3_FunctionExplicitSpecialization() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template <class T> void f(T);                  \n");
        stringBuffer.append("template <class T> void f(T*);                 \n");
        stringBuffer.append("template <> void f(int);       //ok            \n");
        stringBuffer.append("template <> void f<int>(int*); //ok            \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPFunctionTemplate iCPPFunctionTemplate = (ICPPFunctionTemplate)cPPNameCollector.getName(1).resolveBinding();
        ICPPFunctionTemplate iCPPFunctionTemplate2 = (ICPPFunctionTemplate)cPPNameCollector.getName(5).resolveBinding();
        ICPPSpecialization iCPPSpecialization = (ICPPSpecialization)cPPNameCollector.getName(8).resolveBinding();
        ICPPSpecialization iCPPSpecialization2 = (ICPPSpecialization)cPPNameCollector.getName(10).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPSpecialization.getSpecializedBinding(), (Object)iCPPFunctionTemplate);
        AST2TemplateTests.assertSame((Object)iCPPSpecialization2.getSpecializedBinding(), (Object)iCPPFunctionTemplate2);
    }

    public void test_14_5_5_1_FunctionTemplates_1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> void f(T*);        \n");
        stringBuffer.append("void g(int* p) { f(p); }             \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPFunctionTemplate iCPPFunctionTemplate = (ICPPFunctionTemplate)cPPNameCollector.getName(1).resolveBinding();
        ICPPFunction iCPPFunction = (ICPPFunction)cPPNameCollector.getName(6).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iCPPFunction instanceof ICPPTemplateInstance));
        AST2TemplateTests.assertSame((Object)((ICPPTemplateInstance)iCPPFunction).getTemplateDefinition(), (Object)iCPPFunctionTemplate);
    }

    public void test_14_5_5_1_FunctionTemplates_2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> void f(T);        \n");
        stringBuffer.append("void g(int* p) { f(p); }            \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPFunctionTemplate iCPPFunctionTemplate = (ICPPFunctionTemplate)cPPNameCollector.getName(1).resolveBinding();
        ICPPFunction iCPPFunction = (ICPPFunction)cPPNameCollector.getName(6).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iCPPFunction instanceof ICPPTemplateInstance));
        AST2TemplateTests.assertSame((Object)((ICPPTemplateInstance)iCPPFunction).getTemplateDefinition(), (Object)iCPPFunctionTemplate);
    }

    public void test_14_8_1s2_FunctionTemplates() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class X, class Y> X f(Y);                      \n");
        stringBuffer.append("void g(){                                               \n");
        stringBuffer.append("   int i = f<int>(5); // Y is int                       \n");
        stringBuffer.append("}                                                       \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPFunctionTemplate iCPPFunctionTemplate = (ICPPFunctionTemplate)cPPNameCollector.getName(3).resolveBinding();
        ICPPFunction iCPPFunction = (ICPPFunction)cPPNameCollector.getName(8).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iCPPFunction instanceof ICPPTemplateInstance));
        AST2TemplateTests.assertSame((Object)((ICPPTemplateInstance)iCPPFunction).getTemplateDefinition(), (Object)iCPPFunctionTemplate);
    }

    public void test14_8_3s6_FunctionTemplates() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> void f(T);  \n");
        stringBuffer.append("void g(){                     \n");
        stringBuffer.append("   f(\"Annemarie\");          \n");
        stringBuffer.append("}                             \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPFunctionTemplate iCPPFunctionTemplate = (ICPPFunctionTemplate)cPPNameCollector.getName(1).resolveBinding();
        ICPPFunction iCPPFunction = (ICPPFunction)cPPNameCollector.getName(5).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iCPPFunction instanceof ICPPTemplateInstance));
        AST2TemplateTests.assertSame((Object)((ICPPTemplateInstance)iCPPFunction).getTemplateDefinition(), (Object)iCPPFunctionTemplate);
    }

    public void test14_5_5_2s6_FunctionTemplates() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> void f(T);         // #1\n");
        stringBuffer.append("template<class T> void f(T*, int=1); // #2\n");
        stringBuffer.append("template<class T> void g(T);         // #3\n");
        stringBuffer.append("template<class T> void g(T*, ...);   // #4\n");
        stringBuffer.append("int main() {                              \n");
        stringBuffer.append("   int* ip;                               \n");
        stringBuffer.append("   f(ip);                       //calls #2\n");
        stringBuffer.append("   g(ip);                       //calls #4\n");
        stringBuffer.append("}                                         \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPFunctionTemplate iCPPFunctionTemplate = (ICPPFunctionTemplate)cPPNameCollector.getName(1).resolveBinding();
        ICPPFunctionTemplate iCPPFunctionTemplate2 = (ICPPFunctionTemplate)cPPNameCollector.getName(5).resolveBinding();
        AST2TemplateTests.assertNotSame((Object)iCPPFunctionTemplate, (Object)iCPPFunctionTemplate2);
        ICPPFunctionTemplate iCPPFunctionTemplate3 = (ICPPFunctionTemplate)cPPNameCollector.getName(10).resolveBinding();
        ICPPFunctionTemplate iCPPFunctionTemplate4 = (ICPPFunctionTemplate)cPPNameCollector.getName(14).resolveBinding();
        AST2TemplateTests.assertNotSame((Object)iCPPFunctionTemplate3, (Object)iCPPFunctionTemplate4);
        ICPPFunction iCPPFunction = (ICPPFunction)cPPNameCollector.getName(19).resolveBinding();
        ICPPFunction iCPPFunction2 = (ICPPFunction)cPPNameCollector.getName(21).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iCPPFunction instanceof ICPPTemplateInstance));
        AST2TemplateTests.assertSame((Object)((ICPPTemplateInstance)iCPPFunction).getTemplateDefinition(), (Object)iCPPFunctionTemplate2);
        AST2TemplateTests.assertTrue((boolean)(iCPPFunction2 instanceof ICPPTemplateInstance));
        AST2TemplateTests.assertSame((Object)((ICPPTemplateInstance)iCPPFunction2).getTemplateDefinition(), (Object)iCPPFunctionTemplate4);
    }

    public void test14_6_1s1_LocalNames() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> class X {           \n");
        stringBuffer.append("   X* p;               // meaning X<T>\n");
        stringBuffer.append("   X<T>* p2;                          \n");
        stringBuffer.append("};                                    \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPClassTemplate iCPPClassTemplate = (ICPPClassTemplate)cPPNameCollector.getName(1).resolveBinding();
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(2).resolveBinding();
        ICPPClassType iCPPClassType2 = (ICPPClassType)cPPNameCollector.getName(4).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iCPPClassType instanceof ICPPTemplateInstance));
        AST2TemplateTests.assertSame((Object)((ICPPTemplateInstance)iCPPClassType).getTemplateDefinition(), (Object)iCPPClassTemplate);
        AST2TemplateTests.assertSame((Object)iCPPClassType, (Object)iCPPClassType2);
    }

    public void test14_8s2_() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> T f(T* p){                  \n");
        stringBuffer.append("};                                            \n");
        stringBuffer.append("void g(int a, char* b){                       \n");
        stringBuffer.append("   f(&a);              //call f<int>(int*)    \n");
        stringBuffer.append("   f(&b);              //call f<char*>(char**)\n");
        stringBuffer.append("}                                             \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPFunctionTemplate iCPPFunctionTemplate = (ICPPFunctionTemplate)cPPNameCollector.getName(2).resolveBinding();
        ICPPFunction iCPPFunction = (ICPPFunction)cPPNameCollector.getName(8).resolveBinding();
        ICPPFunction iCPPFunction2 = (ICPPFunction)cPPNameCollector.getName(10).resolveBinding();
        AST2TemplateTests.assertNotSame((Object)iCPPFunction, (Object)iCPPFunction2);
        AST2TemplateTests.assertTrue((boolean)(iCPPFunction instanceof ICPPTemplateInstance));
        AST2TemplateTests.assertSame((Object)((ICPPTemplateInstance)iCPPFunction).getTemplateDefinition(), (Object)iCPPFunctionTemplate);
        AST2TemplateTests.assertTrue((boolean)(iCPPFunction2 instanceof ICPPTemplateInstance));
        AST2TemplateTests.assertSame((Object)((ICPPTemplateInstance)iCPPFunction2).getTemplateDefinition(), (Object)iCPPFunctionTemplate);
        IType iType = iCPPFunction.getType().getReturnType();
        IType iType2 = iCPPFunction2.getType().getReturnType();
        AST2TemplateTests.assertTrue((boolean)(iType instanceof IBasicType));
        AST2TemplateTests.assertEquals((int)((IBasicType)iType).getType(), (int)3);
        AST2TemplateTests.assertTrue((boolean)(iType2 instanceof IPointerType));
        AST2TemplateTests.assertTrue((boolean)(((IPointerType)iType2).getType() instanceof IBasicType));
        AST2TemplateTests.assertEquals((int)((IBasicType)((IPointerType)iType2).getType()).getType(), (int)2);
    }

    public void test14_7_3s14() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> void f(T) {  }                  \n");
        stringBuffer.append("template<class T> inline T g(T) {  }              \n");
        stringBuffer.append("template<> inline void f<>(int) {  } //OK: inline \n");
        stringBuffer.append("template<> int g<>(int) {  }     // OK: not inline\n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPFunctionTemplate iCPPFunctionTemplate = (ICPPFunctionTemplate)cPPNameCollector.getName(1).resolveBinding();
        ICPPFunctionTemplate iCPPFunctionTemplate2 = (ICPPFunctionTemplate)cPPNameCollector.getName(6).resolveBinding();
        ICPPSpecialization iCPPSpecialization = (ICPPSpecialization)cPPNameCollector.getName(9).resolveBinding();
        ICPPSpecialization iCPPSpecialization2 = (ICPPSpecialization)cPPNameCollector.getName(12).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPSpecialization.getSpecializedBinding(), (Object)iCPPFunctionTemplate);
        AST2TemplateTests.assertSame((Object)iCPPSpecialization2.getSpecializedBinding(), (Object)iCPPFunctionTemplate2);
        AST2TemplateTests.assertFalse((boolean)((ICPPFunction)iCPPFunctionTemplate).isInline());
        AST2TemplateTests.assertTrue((boolean)((ICPPFunction)iCPPFunctionTemplate2).isInline());
        AST2TemplateTests.assertTrue((boolean)((ICPPFunction)iCPPSpecialization).isInline());
        AST2TemplateTests.assertFalse((boolean)((ICPPFunction)iCPPSpecialization2).isInline());
    }

    public void test14_7_1s14_InfiniteInstantiation() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> class X {                                       \n");
        stringBuffer.append("   X<T*> a; // implicit generation of X<T> requires               \n");
        stringBuffer.append("            // the implicit instantiation of X<T*> which requires \n");
        stringBuffer.append("            // the implicit instantiation of X<T**> which ...     \n");
        stringBuffer.append("};                                                                \n");
        stringBuffer.append("void f() {                                                        \n");
        stringBuffer.append("   X<int> x;                                                      \n");
        stringBuffer.append("   x.a.a.a.a;                                                     \n");
        stringBuffer.append("}                                                                 \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPClassTemplate iCPPClassTemplate = (ICPPClassTemplate)cPPNameCollector.getName(1).resolveBinding();
        ICPPVariable iCPPVariable = (ICPPVariable)cPPNameCollector.getName(9).resolveBinding();
        IType iType = iCPPVariable.getType();
        AST2TemplateTests.assertTrue((boolean)(iType instanceof ICPPTemplateInstance));
        AST2TemplateTests.assertSame((Object)((ICPPTemplateInstance)iType).getTemplateDefinition(), (Object)iCPPClassTemplate);
        ICPPField iCPPField = (ICPPField)cPPNameCollector.getName(5).resolveBinding();
        ICPPField iCPPField2 = (ICPPField)cPPNameCollector.getName(11).resolveBinding();
        ICPPField iCPPField3 = (ICPPField)cPPNameCollector.getName(12).resolveBinding();
        ICPPField iCPPField4 = (ICPPField)cPPNameCollector.getName(13).resolveBinding();
        ICPPField iCPPField5 = (ICPPField)cPPNameCollector.getName(14).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iCPPField2 instanceof ICPPSpecialization));
        AST2TemplateTests.assertTrue((boolean)(iCPPField3 instanceof ICPPSpecialization));
        AST2TemplateTests.assertTrue((boolean)(iCPPField4 instanceof ICPPSpecialization));
        AST2TemplateTests.assertTrue((boolean)(iCPPField5 instanceof ICPPSpecialization));
        AST2TemplateTests.assertSame((Object)((ICPPSpecialization)iCPPField2).getSpecializedBinding(), (Object)iCPPField);
        AST2TemplateTests.assertSame((Object)((ICPPSpecialization)iCPPField3).getSpecializedBinding(), (Object)iCPPField);
        AST2TemplateTests.assertSame((Object)((ICPPSpecialization)iCPPField4).getSpecializedBinding(), (Object)iCPPField);
        AST2TemplateTests.assertSame((Object)((ICPPSpecialization)iCPPField5).getSpecializedBinding(), (Object)iCPPField);
    }

    public void test14_6_1s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> class Y;         \n");
        stringBuffer.append("template<> class Y<int> {          \n");
        stringBuffer.append("   Y* p; // meaning Y<int>         \n");
        stringBuffer.append("   Y<char>* q; // meaning Y<char>  \n");
        stringBuffer.append("};                                 \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPClassTemplate iCPPClassTemplate = (ICPPClassTemplate)cPPNameCollector.getName(1).resolveBinding();
        ICPPSpecialization iCPPSpecialization = (ICPPSpecialization)cPPNameCollector.getName(2).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iCPPSpecialization instanceof ICPPClassType));
        AST2TemplateTests.assertSame((Object)iCPPSpecialization.getSpecializedBinding(), (Object)iCPPClassTemplate);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(4).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPClassType, (Object)iCPPSpecialization);
        ICPPClassType iCPPClassType2 = (ICPPClassType)cPPNameCollector.getName(6).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iCPPClassType2 instanceof ICPPTemplateInstance));
        AST2TemplateTests.assertSame((Object)((ICPPTemplateInstance)iCPPClassType2).getTemplateDefinition(), (Object)iCPPClassTemplate);
    }

    public void testBug45129() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template < class T, class U > void f ( T (*) ( T, U ) );   \n");
        stringBuffer.append("int g ( int, char );                                       \n");
        stringBuffer.append("void foo () {                                              \n");
        stringBuffer.append("   f( g );                                                 \n");
        stringBuffer.append("}                                                          \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPFunction iCPPFunction = (ICPPFunction)cPPNameCollector.getName(2).resolveBinding();
        ICPPFunction iCPPFunction2 = (ICPPFunction)cPPNameCollector.getName(9).resolveBinding();
        IBinding iBinding = cPPNameCollector.getName(13).resolveBinding();
        IBinding iBinding2 = cPPNameCollector.getName(14).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iBinding instanceof ICPPTemplateInstance));
        AST2TemplateTests.assertSame((Object)((ICPPTemplateInstance)iBinding).getTemplateDefinition(), (Object)iCPPFunction);
        AST2TemplateTests.assertSame((Object)iCPPFunction2, (Object)iBinding2);
    }

    public void testBug76951_1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template <class T, class U = T > U f( T );   \n");
        stringBuffer.append("void g() {                                   \n");
        stringBuffer.append("   f( 1 );                                   \n");
        stringBuffer.append("}                                            \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPTemplateParameter iCPPTemplateParameter = (ICPPTemplateParameter)cPPNameCollector.getName(0).resolveBinding();
        ICPPTemplateParameter iCPPTemplateParameter2 = (ICPPTemplateParameter)cPPNameCollector.getName(2).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPTemplateParameter, (Object)iCPPTemplateParameter2);
        ICPPFunctionTemplate iCPPFunctionTemplate = (ICPPFunctionTemplate)cPPNameCollector.getName(4).resolveBinding();
        ICPPFunction iCPPFunction = (ICPPFunction)cPPNameCollector.getName(8).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iCPPFunction instanceof ICPPTemplateInstance));
        AST2TemplateTests.assertSame((Object)((ICPPTemplateInstance)iCPPFunction).getTemplateDefinition(), (Object)iCPPFunctionTemplate);
        IFunctionType iFunctionType = iCPPFunction.getType();
        AST2TemplateTests.assertTrue((boolean)(iFunctionType.getReturnType() instanceof IBasicType));
        AST2TemplateTests.assertEquals((int)((IBasicType)iFunctionType.getReturnType()).getType(), (int)3);
    }

    public void testBug76951_2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template <class T, class U = T > class A {   \n");
        stringBuffer.append("   U u;                                      \n");
        stringBuffer.append("};                                           \n");
        stringBuffer.append("void f() {                                   \n");
        stringBuffer.append("   A<int> a;                                 \n");
        stringBuffer.append("   a.u;                                      \n");
        stringBuffer.append("}                                            \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPTemplateParameter iCPPTemplateParameter = (ICPPTemplateParameter)cPPNameCollector.getName(0).resolveBinding();
        ICPPTemplateTypeParameter iCPPTemplateTypeParameter = (ICPPTemplateTypeParameter)cPPNameCollector.getName(1).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPTemplateTypeParameter.getDefault(), (Object)iCPPTemplateParameter);
        ICPPClassTemplate iCPPClassTemplate = (ICPPClassTemplate)cPPNameCollector.getName(3).resolveBinding();
        ICPPField iCPPField = (ICPPField)cPPNameCollector.getName(5).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPField.getType(), (Object)iCPPTemplateTypeParameter);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(7).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iCPPClassType instanceof ICPPTemplateInstance));
        AST2TemplateTests.assertSame((Object)((ICPPTemplateInstance)iCPPClassType).getTemplateDefinition(), (Object)iCPPClassTemplate);
        ICPPField iCPPField2 = (ICPPField)cPPNameCollector.getName(11).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iCPPField2 instanceof ICPPSpecialization));
        AST2TemplateTests.assertSame((Object)((ICPPSpecialization)iCPPField2).getSpecializedBinding(), (Object)iCPPField);
        IType iType = iCPPField2.getType();
        AST2TemplateTests.assertTrue((boolean)(iType instanceof IBasicType));
        AST2TemplateTests.assertEquals((int)((IBasicType)iType).getType(), (int)3);
    }

    public void testInstances() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template < class T > class A {               \n");
        stringBuffer.append("   A< int > a;                               \n");
        stringBuffer.append("};                                           \n");
        stringBuffer.append("void f( A<int> p ) { }                       \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPClassTemplate iCPPClassTemplate = (ICPPClassTemplate)cPPNameCollector.getName(1).resolveBinding();
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(2).resolveBinding();
        ICPPClassType iCPPClassType2 = (ICPPClassType)cPPNameCollector.getName(6).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPClassType, (Object)iCPPClassType2);
        AST2TemplateTests.assertTrue((boolean)(iCPPClassType instanceof ICPPTemplateInstance));
        AST2TemplateTests.assertSame((Object)((ICPPTemplateInstance)iCPPClassType).getTemplateDefinition(), (Object)iCPPClassTemplate);
    }

    public void testTemplateParameterDeclarations() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template <class T> void f( T );      \n");
        stringBuffer.append("template <class T> void f( T ) {}    \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPTemplateParameter iCPPTemplateParameter = (ICPPTemplateParameter)cPPNameCollector.getName(4).resolveBinding();
        ICPPTemplateParameter iCPPTemplateParameter2 = (ICPPTemplateParameter)cPPNameCollector.getName(2).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPTemplateParameter, (Object)iCPPTemplateParameter2);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPTemplateParameter, 4);
    }

    public void testDeferredInstantiation() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template < class T > class A {                                \n");
        stringBuffer.append("   int f( A * );                                              \n");
        stringBuffer.append("   A < T > *pA;                                               \n");
        stringBuffer.append("};                                                            \n");
        stringBuffer.append("void f () {                                                   \n");
        stringBuffer.append("   A< int > *a;                                               \n");
        stringBuffer.append("   a->f( a );                                                 \n");
        stringBuffer.append("   a->pA;                                                     \n");
        stringBuffer.append("};                                                            \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPClassTemplate iCPPClassTemplate = (ICPPClassTemplate)cPPNameCollector.getName(1).resolveBinding();
        ICPPMethod iCPPMethod = (ICPPMethod)cPPNameCollector.getName(2).resolveBinding();
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(3).resolveBinding();
        ICPPClassType iCPPClassType2 = (ICPPClassType)cPPNameCollector.getName(5).resolveBinding();
        ICPPField iCPPField = (ICPPField)cPPNameCollector.getName(8).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPClassType, (Object)iCPPClassType2);
        AST2TemplateTests.assertTrue((boolean)(iCPPClassType instanceof ICPPTemplateInstance));
        AST2TemplateTests.assertSame((Object)((ICPPTemplateInstance)iCPPClassType).getTemplateDefinition(), (Object)iCPPClassTemplate);
        ICPPClassType iCPPClassType3 = (ICPPClassType)cPPNameCollector.getName(10).resolveBinding();
        ICPPMethod iCPPMethod2 = (ICPPMethod)cPPNameCollector.getName(14).resolveBinding();
        ICPPField iCPPField2 = (ICPPField)cPPNameCollector.getName(17).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iCPPMethod2 instanceof ICPPSpecialization));
        AST2TemplateTests.assertSame((Object)((ICPPSpecialization)iCPPMethod2).getSpecializedBinding(), (Object)iCPPMethod);
        AST2TemplateTests.assertTrue((boolean)(iCPPField2 instanceof ICPPSpecialization));
        AST2TemplateTests.assertSame((Object)((ICPPSpecialization)iCPPField2).getSpecializedBinding(), (Object)iCPPField);
        IType iType = iCPPField2.getType();
        AST2TemplateTests.assertTrue((boolean)(iType instanceof IPointerType));
        AST2TemplateTests.assertSame((Object)((IPointerType)iType).getType(), (Object)iCPPClassType3);
        IParameter iParameter = iCPPMethod2.getParameters()[0];
        IType iType2 = iParameter.getType();
        AST2TemplateTests.assertTrue((boolean)(iType2 instanceof IPointerType));
        AST2TemplateTests.assertSame((Object)((IPointerType)iType2).getType(), (Object)iCPPClassType3);
    }

    public void test14_5_2s2_MemberSpecializations() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template <class T> struct A {                                 \n");
        stringBuffer.append("   void f(int);                                               \n");
        stringBuffer.append("   template <class T2> void f(T2);                            \n");
        stringBuffer.append("};                                                            \n");
        stringBuffer.append("template <> void A<int>::f(int) { } //nontemplate             \n");
        stringBuffer.append("template <> template <> void A<int>::f<>(int) { } //template  \n");
        stringBuffer.append("int main() {                                                  \n");
        stringBuffer.append("   A<int> ac;                                                 \n");
        stringBuffer.append("   ac.f(1);   //nontemplate                                   \n");
        stringBuffer.append("   ac.f('c'); //template                                      \n");
        stringBuffer.append("   ac.f<>(1); //template                                      \n");
        stringBuffer.append("}                                                             \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPClassTemplate iCPPClassTemplate = (ICPPClassTemplate)cPPNameCollector.getName(1).resolveBinding();
        ICPPMethod iCPPMethod = (ICPPMethod)cPPNameCollector.getName(2).resolveBinding();
        ICPPMethod iCPPMethod2 = (ICPPMethod)cPPNameCollector.getName(5).resolveBinding();
        ICPPMethod iCPPMethod3 = (ICPPMethod)cPPNameCollector.getName(11).resolveBinding();
        AST2TemplateTests.assertNotSame((Object)iCPPMethod, (Object)iCPPMethod3);
        AST2TemplateTests.assertTrue((boolean)(iCPPMethod3 instanceof ICPPSpecialization));
        AST2TemplateTests.assertSame((Object)((ICPPSpecialization)iCPPMethod3).getSpecializedBinding(), (Object)iCPPMethod);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(9).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iCPPClassType instanceof ICPPTemplateInstance));
        AST2TemplateTests.assertSame((Object)((ICPPTemplateInstance)iCPPClassType).getTemplateDefinition(), (Object)iCPPClassTemplate);
        ICPPMethod iCPPMethod4 = (ICPPMethod)cPPNameCollector.getName(16).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iCPPMethod4 instanceof ICPPSpecialization));
        IBinding iBinding = ((ICPPSpecialization)iCPPMethod4).getSpecializedBinding();
        AST2TemplateTests.assertTrue((iBinding instanceof ICPPFunctionTemplate && iBinding instanceof ICPPSpecialization ? 1 : 0) != 0);
        AST2TemplateTests.assertSame((Object)((ICPPSpecialization)iBinding).getSpecializedBinding(), (Object)iCPPMethod2);
        ICPPClassType iCPPClassType2 = (ICPPClassType)cPPNameCollector.getName(14).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPClassType, (Object)iCPPClassType2);
        ICPPClassType iCPPClassType3 = (ICPPClassType)cPPNameCollector.getName(20).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPClassType, (Object)iCPPClassType3);
        IFunction iFunction = (IFunction)cPPNameCollector.getName(24).resolveBinding();
        IFunction iFunction2 = (IFunction)cPPNameCollector.getName(26).resolveBinding();
        IFunction iFunction3 = (IFunction)cPPNameCollector.getName(28).resolveBinding();
        AST2TemplateTests.assertSame((Object)iFunction, (Object)iCPPMethod3);
        AST2TemplateTests.assertTrue((boolean)(iFunction2 instanceof ICPPTemplateInstance));
        AST2TemplateTests.assertSame((Object)((ICPPTemplateInstance)iFunction2).getTemplateDefinition(), (Object)iBinding);
        AST2TemplateTests.assertSame((Object)iFunction3, (Object)iCPPMethod4);
    }

    public void testClassSpecializations() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template <class T> class A { };       \n");
        stringBuffer.append("template <> class A<int> {};          \n");
        stringBuffer.append("A<char> ac;                           \n");
        stringBuffer.append("A<int> ai;                            \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPClassTemplate iCPPClassTemplate = (ICPPClassTemplate)cPPNameCollector.getName(1).resolveBinding();
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(2).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iCPPClassType instanceof ICPPSpecialization));
        AST2TemplateTests.assertSame((Object)((ICPPSpecialization)iCPPClassType).getSpecializedBinding(), (Object)iCPPClassTemplate);
        ICPPClassType iCPPClassType2 = (ICPPClassType)cPPNameCollector.getName(4).resolveBinding();
        ICPPClassType iCPPClassType3 = (ICPPClassType)cPPNameCollector.getName(7).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iCPPClassType2 instanceof ICPPTemplateInstance));
        AST2TemplateTests.assertSame((Object)((ICPPTemplateInstance)iCPPClassType2).getTemplateDefinition(), (Object)iCPPClassTemplate);
        AST2TemplateTests.assertSame((Object)iCPPClassType3, (Object)iCPPClassType);
    }

    public void test14_7_3s5_SpecializationMemberDefinition() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> struct A {                                           \n");
        stringBuffer.append("   void f(T) {  }                                                      \n");
        stringBuffer.append("};                                                                     \n");
        stringBuffer.append("template<> struct A<int> {                                             \n");
        stringBuffer.append("   void f(int);                                                        \n");
        stringBuffer.append("};                                                                     \n");
        stringBuffer.append("void h(){                                                              \n");
        stringBuffer.append("   A<int> a;                                                           \n");
        stringBuffer.append("   a.f(16);   // A<int>::f must be defined somewhere                   \n");
        stringBuffer.append("}                                                                      \n");
        stringBuffer.append("// explicit specialization syntax not used for a member of             \n");
        stringBuffer.append("// explicitly specialized class template specialization                \n");
        stringBuffer.append("void A<int>::f(int) {  }                                               \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPClassTemplate iCPPClassTemplate = (ICPPClassTemplate)cPPNameCollector.getName(1).resolveBinding();
        ICPPMethod iCPPMethod = (ICPPMethod)cPPNameCollector.getName(2).resolveBinding();
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(5).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iCPPClassType instanceof ICPPSpecialization));
        AST2TemplateTests.assertSame((Object)((ICPPSpecialization)iCPPClassType).getSpecializedBinding(), (Object)iCPPClassTemplate);
        ICPPMethod iCPPMethod2 = (ICPPMethod)cPPNameCollector.getName(7).resolveBinding();
        AST2TemplateTests.assertNotSame((Object)iCPPMethod, (Object)iCPPMethod2);
        ICPPClassType iCPPClassType2 = (ICPPClassType)cPPNameCollector.getName(10).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPClassType2, (Object)iCPPClassType);
        ICPPMethod iCPPMethod3 = (ICPPMethod)cPPNameCollector.getName(14).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPMethod3, (Object)iCPPMethod2);
        ICPPClassType iCPPClassType3 = (ICPPClassType)cPPNameCollector.getName(16).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPClassType3, (Object)iCPPClassType);
        ICPPMethod iCPPMethod4 = (ICPPMethod)cPPNameCollector.getName(18).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPMethod4, (Object)iCPPMethod3);
    }

    public void testNestedSpecializations() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class C{};                                                     \n");
        stringBuffer.append("template <class T> class A {                                   \n");
        stringBuffer.append("   template <class T2> class B {                               \n");
        stringBuffer.append("      T f( T2 );                                               \n");
        stringBuffer.append("   };                                                          \n");
        stringBuffer.append("};                                                             \n");
        stringBuffer.append("void g(){                                                      \n");
        stringBuffer.append("   A<int>::B<C> b;                                             \n");
        stringBuffer.append("   C c;                                                        \n");
        stringBuffer.append("   b.f( c );                                                   \n");
        stringBuffer.append("}                                                              \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        ICPPClassTemplate iCPPClassTemplate = (ICPPClassTemplate)cPPNameCollector.getName(2).resolveBinding();
        ICPPClassTemplate iCPPClassTemplate2 = (ICPPClassTemplate)cPPNameCollector.getName(4).resolveBinding();
        ICPPMethod iCPPMethod = (ICPPMethod)cPPNameCollector.getName(6).resolveBinding();
        ICPPClassType iCPPClassType2 = (ICPPClassType)cPPNameCollector.getName(11).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iCPPClassType2 instanceof ICPPTemplateInstance));
        AST2TemplateTests.assertSame((Object)((ICPPTemplateInstance)iCPPClassType2).getTemplateDefinition(), (Object)iCPPClassTemplate);
        ICPPClassType iCPPClassType3 = (ICPPClassType)cPPNameCollector.getName(13).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iCPPClassType3 instanceof ICPPTemplateInstance));
        ICPPClassType iCPPClassType4 = (ICPPClassType)((ICPPTemplateInstance)iCPPClassType3).getTemplateDefinition();
        AST2TemplateTests.assertTrue((boolean)(iCPPClassType4 instanceof ICPPSpecialization));
        AST2TemplateTests.assertSame((Object)((ICPPSpecialization)iCPPClassType4).getSpecializedBinding(), (Object)iCPPClassTemplate2);
        ICPPMethod iCPPMethod2 = (ICPPMethod)cPPNameCollector.getName(20).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iCPPMethod2 instanceof ICPPSpecialization));
        AST2TemplateTests.assertSame((Object)((ICPPSpecialization)iCPPMethod2).getSpecializedBinding(), (Object)iCPPMethod);
        IFunctionType iFunctionType = iCPPMethod2.getType();
        AST2TemplateTests.assertTrue((boolean)(iFunctionType.getReturnType() instanceof IBasicType));
        AST2TemplateTests.assertEquals((int)((IBasicType)iFunctionType.getReturnType()).getType(), (int)3);
        AST2TemplateTests.assertSame((Object)iFunctionType.getParameterTypes()[0], (Object)iCPPClassType);
    }

    public void test14_5_4s7_UsingClassTemplate() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace N {                                                \n");
        stringBuffer.append("   template<class T1, class T2> class A { };                 \n");
        stringBuffer.append("}                                                            \n");
        stringBuffer.append("using N::A;                                                  \n");
        stringBuffer.append("namespace N {                                                \n");
        stringBuffer.append("   template<class T> class A<T, T*> { };                     \n");
        stringBuffer.append("}                                                            \n");
        stringBuffer.append("A<int,int*> a;                                               \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPClassTemplate iCPPClassTemplate = (ICPPClassTemplate)cPPNameCollector.getName(3).resolveBinding();
        ICPPClassTemplatePartialSpecialization iCPPClassTemplatePartialSpecialization = (ICPPClassTemplatePartialSpecialization)cPPNameCollector.getName(9).resolveBinding();
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(13).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iCPPClassType instanceof ICPPTemplateInstance));
        AST2TemplateTests.assertSame((Object)((ICPPTemplateInstance)iCPPClassType).getTemplateDefinition(), (Object)iCPPClassTemplatePartialSpecialization);
        ICPPClassTemplate iCPPClassTemplate2 = (ICPPClassTemplate)cPPNameCollector.getName(14).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iCPPClassTemplate2 instanceof ICPPDelegate));
        AST2TemplateTests.assertSame((Object)((ICPPDelegate)iCPPClassTemplate2).getBinding(), (Object)iCPPClassTemplate);
    }

    public void testTemplateTemplateParameter() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> class A {                      \n");
        stringBuffer.append("   int x;                                        \n");
        stringBuffer.append("};                                               \n");
        stringBuffer.append("template<class T> class A<T*> {                  \n");
        stringBuffer.append("   char x;                                       \n");
        stringBuffer.append("};                                               \n");
        stringBuffer.append("template<template<class U> class V> class C {    \n");
        stringBuffer.append("   V<int> y;                                     \n");
        stringBuffer.append("   V<int*> z;                                    \n");
        stringBuffer.append("};                                               \n");
        stringBuffer.append("void f() {                                       \n");
        stringBuffer.append("   C<A> c;                                       \n");
        stringBuffer.append("   c.y.x;   c.z.x;                               \n");
        stringBuffer.append("}                                                \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPClassTemplate iCPPClassTemplate = (ICPPClassTemplate)cPPNameCollector.getName(1).resolveBinding();
        ICPPField iCPPField = (ICPPField)cPPNameCollector.getName(2).resolveBinding();
        ICPPClassTemplatePartialSpecialization iCPPClassTemplatePartialSpecialization = (ICPPClassTemplatePartialSpecialization)cPPNameCollector.getName(4).resolveBinding();
        ICPPField iCPPField2 = (ICPPField)cPPNameCollector.getName(7).resolveBinding();
        ICPPClassTemplate iCPPClassTemplate2 = (ICPPClassTemplate)cPPNameCollector.getName(10).resolveBinding();
        ICPPField iCPPField3 = (ICPPField)cPPNameCollector.getName(13).resolveBinding();
        ICPPField iCPPField4 = (ICPPField)cPPNameCollector.getName(16).resolveBinding();
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(18).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iCPPClassType instanceof ICPPTemplateInstance));
        AST2TemplateTests.assertSame((Object)((ICPPTemplateInstance)iCPPClassType).getTemplateDefinition(), (Object)iCPPClassTemplate2);
        ICPPField iCPPField5 = (ICPPField)cPPNameCollector.getName(23).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iCPPField5 instanceof ICPPSpecialization));
        AST2TemplateTests.assertSame((Object)((ICPPSpecialization)iCPPField5).getSpecializedBinding(), (Object)iCPPField3);
        IType iType = iCPPField5.getType();
        AST2TemplateTests.assertTrue((boolean)(iType instanceof ICPPTemplateInstance));
        AST2TemplateTests.assertSame((Object)((ICPPTemplateInstance)iType).getTemplateDefinition(), (Object)iCPPClassTemplate);
        ICPPField iCPPField6 = (ICPPField)cPPNameCollector.getName(24).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iCPPField6 instanceof ICPPSpecialization));
        AST2TemplateTests.assertEquals((Object)((ICPPSpecialization)iCPPField6).getSpecializedBinding(), (Object)iCPPField);
        ICPPField iCPPField7 = (ICPPField)cPPNameCollector.getName(26).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iCPPField7 instanceof ICPPSpecialization));
        AST2TemplateTests.assertSame((Object)((ICPPSpecialization)iCPPField7).getSpecializedBinding(), (Object)iCPPField4);
        iType = iCPPField7.getType();
        AST2TemplateTests.assertTrue((boolean)(iType instanceof ICPPTemplateInstance));
        AST2TemplateTests.assertSame((Object)((ICPPTemplateInstance)iType).getTemplateDefinition(), (Object)iCPPClassTemplatePartialSpecialization);
        ICPPField iCPPField8 = (ICPPField)cPPNameCollector.getName(27).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iCPPField8 instanceof ICPPSpecialization));
        AST2TemplateTests.assertEquals((Object)((ICPPSpecialization)iCPPField8).getSpecializedBinding(), (Object)iCPPField2);
    }

    public void _testNestedTypeSpecializations() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template <class T> class A {               \n");
        stringBuffer.append("   typedef T _T;                           \n");
        stringBuffer.append("  _T t;                                    \n");
        stringBuffer.append("};                                         \n");
        stringBuffer.append("void f() {                                 \n");
        stringBuffer.append("   A<int> a;                               \n");
        stringBuffer.append("   a.t;                                    \n");
        stringBuffer.append("}                                          \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPTemplateParameter iCPPTemplateParameter = (ICPPTemplateParameter)cPPNameCollector.getName(0).resolveBinding();
        ITypedef iTypedef = (ITypedef)cPPNameCollector.getName(3).resolveBinding();
        AST2TemplateTests.assertSame((Object)iTypedef.getType(), (Object)iCPPTemplateParameter);
        ICPPField iCPPField = (ICPPField)cPPNameCollector.getName(5).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPField.getType(), (Object)iTypedef);
        ICPPField iCPPField2 = (ICPPField)cPPNameCollector.getName(11).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iCPPField2 instanceof ICPPSpecialization));
        AST2TemplateTests.assertSame((Object)((ICPPSpecialization)iCPPField2).getSpecializedBinding(), (Object)iCPPField);
        IType iType = iCPPField2.getType();
        AST2TemplateTests.assertTrue((boolean)(iType instanceof ITypedef));
        AST2TemplateTests.assertTrue((boolean)(iType instanceof ICPPSpecialization));
        AST2TemplateTests.assertSame((Object)((ICPPSpecialization)iType).getSpecializedBinding(), (Object)iTypedef);
        iType = ((ITypedef)iType).getType();
        AST2TemplateTests.assertTrue((boolean)(iType instanceof IBasicType));
        AST2TemplateTests.assertEquals((int)((IBasicType)iType).getType(), (int)3);
    }

    public void _testNestedClassTypeSpecializations() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template <class T> class A {                          \n");
        stringBuffer.append("   class B { T t; };                                  \n");
        stringBuffer.append("   B b;                                               \n");
        stringBuffer.append("};                                                    \n");
        stringBuffer.append("void f() {                                            \n");
        stringBuffer.append("   A<int> a;                                          \n");
        stringBuffer.append("   a.b.t;                                             \n");
        stringBuffer.append("}                                                     \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPTemplateParameter iCPPTemplateParameter = (ICPPTemplateParameter)cPPNameCollector.getName(0).resolveBinding();
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(2).resolveBinding();
        ICPPField iCPPField = (ICPPField)cPPNameCollector.getName(4).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPField.getType(), (Object)iCPPTemplateParameter);
        ICPPField iCPPField2 = (ICPPField)cPPNameCollector.getName(6).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPField2.getType(), (Object)iCPPClassType);
        ICPPField iCPPField3 = (ICPPField)cPPNameCollector.getName(12).resolveBinding();
        ICPPField iCPPField4 = (ICPPField)cPPNameCollector.getName(13).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iCPPField3 instanceof ICPPSpecialization));
        AST2TemplateTests.assertSame((Object)((ICPPSpecialization)iCPPField3).getSpecializedBinding(), (Object)iCPPField2);
        IType iType = iCPPField3.getType();
        AST2TemplateTests.assertTrue((boolean)(iType instanceof ICPPSpecialization));
        AST2TemplateTests.assertSame((Object)((ICPPSpecialization)iType).getSpecializedBinding(), (Object)iCPPClassType);
        AST2TemplateTests.assertTrue((boolean)(iCPPField4 instanceof ICPPSpecialization));
        AST2TemplateTests.assertSame((Object)((ICPPSpecialization)iCPPField4).getSpecializedBinding(), (Object)iCPPField);
        AST2TemplateTests.assertTrue((boolean)(iCPPField4.getType() instanceof IBasicType));
        AST2TemplateTests.assertEquals((int)((IBasicType)iCPPField4.getType()).getType(), (int)3);
    }

    public void testTemplateParameterQualifiedType_1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template <class T> class A {                     \n");
        stringBuffer.append("   typedef typename T::X _xx;                    \n");
        stringBuffer.append("   _xx s;                                        \n");
        stringBuffer.append("};                                               \n");
        stringBuffer.append("class B {};                                      \n");
        stringBuffer.append("template < class T > class C {                   \n");
        stringBuffer.append("   typedef T X;                                  \n");
        stringBuffer.append("};                                               \n");
        stringBuffer.append("void f() {                                       \n");
        stringBuffer.append("   A< C<B> > a; a.s;                             \n");
        stringBuffer.append("};                                               \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPTemplateTypeParameter iCPPTemplateTypeParameter = (ICPPTemplateTypeParameter)cPPNameCollector.getName(0).resolveBinding();
        ICPPClassTemplate iCPPClassTemplate = (ICPPClassTemplate)cPPNameCollector.getName(1).resolveBinding();
        IBinding iBinding = cPPNameCollector.getName(3).resolveBinding();
        AST2TemplateTests.assertSame((Object)iBinding, (Object)iCPPTemplateTypeParameter);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(4).resolveBinding();
        ITypedef iTypedef = (ITypedef)cPPNameCollector.getName(5).resolveBinding();
        IBinding iBinding2 = cPPNameCollector.getName(6).resolveBinding();
        AST2TemplateTests.assertSame((Object)iTypedef, (Object)iBinding2);
        AST2TemplateTests.assertSame((Object)iTypedef.getType(), (Object)iCPPClassType);
        ICPPField iCPPField = (ICPPField)cPPNameCollector.getName(7).resolveBinding();
        ICPPClassType iCPPClassType2 = (ICPPClassType)cPPNameCollector.getName(8).resolveBinding();
        ITypedef iTypedef2 = (ITypedef)cPPNameCollector.getName(12).resolveBinding();
        ICPPClassType iCPPClassType3 = (ICPPClassType)cPPNameCollector.getName(14).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iCPPClassType3 instanceof ICPPTemplateInstance));
        AST2TemplateTests.assertSame((Object)((ICPPTemplateInstance)iCPPClassType3).getTemplateDefinition(), (Object)iCPPClassTemplate);
        ICPPField iCPPField2 = (ICPPField)cPPNameCollector.getName(21).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iCPPField2 instanceof ICPPSpecialization));
        AST2TemplateTests.assertSame((Object)((ICPPSpecialization)iCPPField2).getSpecializedBinding(), (Object)iCPPField);
        IType iType = iCPPField2.getType();
        iType = ((ITypedef)iType).getType();
        AST2TemplateTests.assertTrue((boolean)(iType instanceof ICPPSpecialization));
        AST2TemplateTests.assertSame((Object)((ICPPSpecialization)iType).getSpecializedBinding(), (Object)iTypedef2);
        iType = ((ITypedef)iType).getType();
        AST2TemplateTests.assertSame((Object)iType, (Object)iCPPClassType2);
    }

    public void testTemplateScopes() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template <class T> class A {               \n");
        stringBuffer.append("   A<T> a;                                 \n");
        stringBuffer.append("   void f();                               \n");
        stringBuffer.append("};                                         \n");
        stringBuffer.append("template <class U> void A<U>::f(){         \n");
        stringBuffer.append("   U u;                                    \n");
        stringBuffer.append("}                                          \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPTemplateParameter iCPPTemplateParameter = (ICPPTemplateParameter)cPPNameCollector.getName(0).resolveBinding();
        ICPPClassTemplate iCPPClassTemplate = (ICPPClassTemplate)cPPNameCollector.getName(1).resolveBinding();
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(2).resolveBinding();
        ICPPTemplateParameter iCPPTemplateParameter2 = (ICPPTemplateParameter)cPPNameCollector.getName(7).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPTemplateParameter2, (Object)iCPPTemplateParameter);
        ICPPClassType iCPPClassType2 = (ICPPClassType)cPPNameCollector.getName(9).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iCPPClassType2 instanceof ICPPTemplateInstance));
        AST2TemplateTests.assertSame((Object)((ICPPTemplateInstance)iCPPClassType2).getTemplateDefinition(), (Object)iCPPClassTemplate);
        AST2TemplateTests.assertSame((Object)iCPPClassType, (Object)iCPPClassType2);
        ICPPTemplateParameter iCPPTemplateParameter3 = (ICPPTemplateParameter)cPPNameCollector.getName(13).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPTemplateParameter2, (Object)iCPPTemplateParameter3);
        AST2TemplateTests.assertSame((Object)iCPPTemplateParameter, (Object)iCPPTemplateParameter2);
    }

    public void testTemplateScopes_2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class A {                              \n");
        stringBuffer.append("   template < class T > void f(T);     \n");
        stringBuffer.append("};                                     \n");
        stringBuffer.append("template <class U> void A::f<>(U){}    \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        ICPPTemplateParameter iCPPTemplateParameter = (ICPPTemplateParameter)cPPNameCollector.getName(1).resolveBinding();
        ICPPFunctionTemplate iCPPFunctionTemplate = (ICPPFunctionTemplate)cPPNameCollector.getName(2).resolveBinding();
        ICPPTemplateParameter iCPPTemplateParameter2 = (ICPPTemplateParameter)cPPNameCollector.getName(3).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPTemplateParameter, (Object)iCPPTemplateParameter2);
        ICPPTemplateParameter iCPPTemplateParameter3 = (ICPPTemplateParameter)cPPNameCollector.getName(5).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPTemplateParameter, (Object)iCPPTemplateParameter3);
        ICPPClassType iCPPClassType2 = (ICPPClassType)cPPNameCollector.getName(7).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPClassType, (Object)iCPPClassType2);
        ICPPMethod iCPPMethod = (ICPPMethod)cPPNameCollector.getName(8).resolveBinding();
        IBinding iBinding = cPPNameCollector.getName(10).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPTemplateParameter3, (Object)iBinding);
        AST2TemplateTests.assertTrue((boolean)(iCPPMethod instanceof ICPPSpecialization));
        AST2TemplateTests.assertSame((Object)((ICPPSpecialization)iCPPMethod).getSpecializedBinding(), (Object)iCPPFunctionTemplate);
    }

    public void test14_7_3s16() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> struct A {                              \n");
        stringBuffer.append("   void f(T);                                             \n");
        stringBuffer.append("   template<class X> void g(T,X);                         \n");
        stringBuffer.append("   void h(T) { }                                          \n");
        stringBuffer.append("};                                                        \n");
        stringBuffer.append("template<> void A<int>::f(int);                           \n");
        stringBuffer.append("template<class T> template<class X> void A<T>::g(T,X) { } \n");
        stringBuffer.append("template<> template<class X> void A<int>::g(int,X);       \n");
        stringBuffer.append("template<> template<> void A<int>::g(int,char);           \n");
        stringBuffer.append("template<> template<> void A<int>::g<char>(int,char);     \n");
        stringBuffer.append("template<> void A<int>::h(int) { }                        \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPTemplateParameter iCPPTemplateParameter = (ICPPTemplateParameter)cPPNameCollector.getName(0).resolveBinding();
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(1).resolveBinding();
        ICPPMethod iCPPMethod = (ICPPMethod)cPPNameCollector.getName(2).resolveBinding();
        ICPPTemplateParameter iCPPTemplateParameter2 = (ICPPTemplateParameter)cPPNameCollector.getName(3).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPTemplateParameter, (Object)iCPPTemplateParameter2);
        ICPPTemplateParameter iCPPTemplateParameter3 = (ICPPTemplateParameter)cPPNameCollector.getName(5).resolveBinding();
        ICPPFunctionTemplate iCPPFunctionTemplate = (ICPPFunctionTemplate)cPPNameCollector.getName(6).resolveBinding();
        ICPPTemplateParameter iCPPTemplateParameter4 = (ICPPTemplateParameter)cPPNameCollector.getName(7).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPTemplateParameter, (Object)iCPPTemplateParameter4);
        ICPPTemplateParameter iCPPTemplateParameter5 = (ICPPTemplateParameter)cPPNameCollector.getName(9).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPTemplateParameter3, (Object)iCPPTemplateParameter5);
        ICPPMethod iCPPMethod2 = (ICPPMethod)cPPNameCollector.getName(11).resolveBinding();
        ICPPTemplateParameter iCPPTemplateParameter6 = (ICPPTemplateParameter)cPPNameCollector.getName(12).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPTemplateParameter, (Object)iCPPTemplateParameter6);
        ICPPClassType iCPPClassType2 = (ICPPClassType)cPPNameCollector.getName(15).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iCPPClassType2 instanceof ICPPTemplateInstance));
        AST2TemplateTests.assertSame((Object)((ICPPTemplateInstance)iCPPClassType2).getTemplateDefinition(), (Object)iCPPClassType);
        ICPPMethod iCPPMethod3 = (ICPPMethod)cPPNameCollector.getName(17).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iCPPMethod3 instanceof ICPPSpecialization));
        AST2TemplateTests.assertSame((Object)((ICPPSpecialization)iCPPMethod3).getSpecializedBinding(), (Object)iCPPMethod);
        ICPPTemplateParameter iCPPTemplateParameter7 = (ICPPTemplateParameter)cPPNameCollector.getName(19).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPTemplateParameter, (Object)iCPPTemplateParameter7);
        ICPPTemplateParameter iCPPTemplateParameter8 = (ICPPTemplateParameter)cPPNameCollector.getName(20).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPTemplateParameter3, (Object)iCPPTemplateParameter8);
        ICPPClassType iCPPClassType3 = (ICPPClassType)cPPNameCollector.getName(22).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iCPPClassType3 instanceof ICPPTemplateInstance));
        AST2TemplateTests.assertSame((Object)((ICPPTemplateInstance)iCPPClassType3).getTemplateDefinition(), (Object)iCPPClassType);
        AST2TemplateTests.assertNotSame((Object)iCPPClassType2, (Object)iCPPClassType3);
        ICPPMethod iCPPMethod4 = (ICPPMethod)cPPNameCollector.getName(25).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPMethod4, (Object)iCPPFunctionTemplate);
        iCPPTemplateParameter7 = (ICPPTemplateParameter)cPPNameCollector.getName(26).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPTemplateParameter, (Object)iCPPTemplateParameter7);
        iCPPTemplateParameter8 = (ICPPTemplateParameter)cPPNameCollector.getName(28).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPTemplateParameter3, (Object)iCPPTemplateParameter8);
        AST2TemplateTests.assertSame((Object)cPPNameCollector.getName(32).resolveBinding(), (Object)iCPPClassType2);
        AST2TemplateTests.assertSame((Object)cPPNameCollector.getName(39).resolveBinding(), (Object)iCPPClassType2);
        AST2TemplateTests.assertSame((Object)cPPNameCollector.getName(45).resolveBinding(), (Object)iCPPClassType2);
        AST2TemplateTests.assertSame((Object)cPPNameCollector.getName(52).resolveBinding(), (Object)iCPPClassType2);
        ICPPMethod iCPPMethod5 = (ICPPMethod)cPPNameCollector.getName(54).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iCPPMethod5 instanceof ICPPSpecialization));
        AST2TemplateTests.assertSame((Object)((ICPPSpecialization)iCPPMethod5).getSpecializedBinding(), (Object)iCPPMethod2);
    }

    public void test14_6_1s6() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace N {                                                 \n");
        stringBuffer.append("   int C;                                                     \n");
        stringBuffer.append("   template<class T> class B {                                \n");
        stringBuffer.append("      void f(T);                                              \n");
        stringBuffer.append("   };                                                         \n");
        stringBuffer.append("}                                                             \n");
        stringBuffer.append("template<class C> void N::B<C>::f(C) {                        \n");
        stringBuffer.append("   C b; // C is the template parameter, not N::C              \n");
        stringBuffer.append("}                                                             \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPTemplateParameter iCPPTemplateParameter = (ICPPTemplateParameter)cPPNameCollector.getName(2).resolveBinding();
        ICPPClassTemplate iCPPClassTemplate = (ICPPClassTemplate)cPPNameCollector.getName(3).resolveBinding();
        ICPPMethod iCPPMethod = (ICPPMethod)cPPNameCollector.getName(4).resolveBinding();
        ICPPTemplateParameter iCPPTemplateParameter2 = (ICPPTemplateParameter)cPPNameCollector.getName(5).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPTemplateParameter, (Object)iCPPTemplateParameter2);
        ICPPTemplateParameter iCPPTemplateParameter3 = (ICPPTemplateParameter)cPPNameCollector.getName(7).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPTemplateParameter3, (Object)iCPPTemplateParameter);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(10).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iCPPClassType instanceof ICPPTemplateInstance));
        AST2TemplateTests.assertSame((Object)((ICPPTemplateInstance)iCPPClassType).getTemplateDefinition(), (Object)iCPPClassTemplate);
        ICPPTemplateParameter iCPPTemplateParameter4 = (ICPPTemplateParameter)cPPNameCollector.getName(12).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPTemplateParameter4, (Object)iCPPTemplateParameter);
        ICPPMethod iCPPMethod2 = (ICPPMethod)cPPNameCollector.getName(13).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPMethod2, (Object)iCPPMethod);
        iCPPTemplateParameter4 = (ICPPTemplateParameter)cPPNameCollector.getName(14).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPTemplateParameter4, (Object)iCPPTemplateParameter);
    }

    public void testBug90689_ExplicitInstantiation() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template <class T> class Array {};                    \n");
        stringBuffer.append("template <class T> void sort( Array<T> & );           \n");
        stringBuffer.append("template void sort<>( Array<int> & );                 \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPClassTemplate iCPPClassTemplate = (ICPPClassTemplate)cPPNameCollector.getName(1).resolveBinding();
        ICPPFunctionTemplate iCPPFunctionTemplate = (ICPPFunctionTemplate)cPPNameCollector.getName(3).resolveBinding();
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(4).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iCPPClassType instanceof ICPPTemplateInstance));
        AST2TemplateTests.assertSame((Object)((ICPPTemplateInstance)iCPPClassType).getTemplateDefinition(), (Object)iCPPClassTemplate);
        ICPPFunction iCPPFunction = (ICPPFunction)cPPNameCollector.getName(8).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iCPPFunction instanceof ICPPTemplateInstance));
        AST2TemplateTests.assertSame((Object)((ICPPTemplateInstance)iCPPFunction).getTemplateDefinition(), (Object)iCPPFunctionTemplate);
        ICPPClassType iCPPClassType2 = (ICPPClassType)cPPNameCollector.getName(10).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iCPPClassType2 instanceof ICPPTemplateInstance));
        AST2TemplateTests.assertSame((Object)((ICPPTemplateInstance)iCPPClassType2).getTemplateDefinition(), (Object)iCPPClassTemplate);
        AST2TemplateTests.assertNotSame((Object)iCPPClassType, (Object)iCPPClassType2);
    }

    public void test14_7_2s2_ExplicitInstantiation() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> class Array { };                              \n");
        stringBuffer.append("template class Array<char>;                                     \n");
        stringBuffer.append("template<class T> void sort(Array<T>& v) {  }                   \n");
        stringBuffer.append("template void sort(Array<char>&); // argument is deduced here   \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPClassTemplate iCPPClassTemplate = (ICPPClassTemplate)cPPNameCollector.getName(1).resolveBinding();
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(2).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iCPPClassType instanceof ICPPTemplateInstance));
        AST2TemplateTests.assertSame((Object)((ICPPTemplateInstance)iCPPClassType).getTemplateDefinition(), (Object)iCPPClassTemplate);
        ICPPFunctionTemplate iCPPFunctionTemplate = (ICPPFunctionTemplate)cPPNameCollector.getName(5).resolveBinding();
        ICPPFunction iCPPFunction = (ICPPFunction)cPPNameCollector.getName(10).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iCPPFunction instanceof ICPPTemplateInstance));
        AST2TemplateTests.assertSame((Object)((ICPPTemplateInstance)iCPPFunction).getTemplateDefinition(), (Object)iCPPFunctionTemplate);
        ICPPClassType iCPPClassType2 = (ICPPClassType)cPPNameCollector.getName(11).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPClassType, (Object)iCPPClassType2);
    }

    public void testBug74204() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template <class T> class A {       \n");
        stringBuffer.append("   A<T>* p;                        \n");
        stringBuffer.append("   void f() { this; }              \n");
        stringBuffer.append("};                                 \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        IField iField = (IField)cPPNameCollector.getName(5).resolveBinding();
        IASTName iASTName = cPPNameCollector.getName(6);
        IASTFunctionDefinition iASTFunctionDefinition = (IASTFunctionDefinition)iASTName.getParent().getParent();
        IASTExpressionStatement iASTExpressionStatement = (IASTExpressionStatement)((IASTCompoundStatement)iASTFunctionDefinition.getBody()).getStatements()[0];
        IType iType = CPPVisitor.getExpressionType((IASTExpression)iASTExpressionStatement.getExpression());
        AST2TemplateTests.assertTrue((boolean)iType.isSameType(iField.getType()));
    }

    public void testDeferredFunctionTemplates() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template <class T > void f( T );               \n");
        stringBuffer.append("template <class T > void g( T t ){             \n");
        stringBuffer.append("   f( t );                                     \n");
        stringBuffer.append("}                                              \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPFunctionTemplate iCPPFunctionTemplate = (ICPPFunctionTemplate)cPPNameCollector.getName(1).resolveBinding();
        ICPPFunction iCPPFunction = (ICPPFunction)cPPNameCollector.getName(8).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iCPPFunction instanceof ICPPTemplateInstance));
        AST2TemplateTests.assertSame((Object)((ICPPTemplateInstance)iCPPFunction).getTemplateDefinition(), (Object)iCPPFunctionTemplate);
    }

    public void testRelaxationForTemplateInheritance() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template < class T > class A {};                          \n");
        stringBuffer.append("template < class T > class B {                            \n");
        stringBuffer.append("   void init( A<T> * );                                   \n");
        stringBuffer.append("};                                                        \n");
        stringBuffer.append("template < class T > class C : public B<T> {              \n");
        stringBuffer.append("   C( A<T> * a ) {                                        \n");
        stringBuffer.append("      init( a );                                          \n");
        stringBuffer.append("   }                                                      \n");
        stringBuffer.append("};                                                        \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPMethod iCPPMethod = (ICPPMethod)cPPNameCollector.getName(4).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPMethod, (Object)cPPNameCollector.getName(19).resolveBinding());
    }

    public void testBug91707() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template <class Tp, class Tr > class iter {                         \n");
        stringBuffer.append("   Tp operator -> () const;                                         \n");
        stringBuffer.append("   Tr operator [] (int) const;                                      \n");
        stringBuffer.append("};                                                                  \n");
        stringBuffer.append("template <class T> class list {                                     \n");
        stringBuffer.append("   typedef iter< T*, T& > iterator;                                 \n");
        stringBuffer.append("   iterator begin();                                                \n");
        stringBuffer.append("   iterator end();                                                  \n");
        stringBuffer.append("};                                                                  \n");
        stringBuffer.append("class Bar { public: int foo; };                                     \n");
        stringBuffer.append("void f() {                                                          \n");
        stringBuffer.append("   list<Bar> bar;                                                   \n");
        stringBuffer.append("   for( list<Bar>::iterator i = bar.begin(); i != bar.end(); ++i ){ \n");
        stringBuffer.append("      i->foo;  i[0].foo;                                            \n");
        stringBuffer.append("   }                                                                \n");
        stringBuffer.append("}                                                                   \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPMethod iCPPMethod = (ICPPMethod)cPPNameCollector.getName(16).resolveBinding();
        ICPPMethod iCPPMethod2 = (ICPPMethod)cPPNameCollector.getName(18).resolveBinding();
        ICPPField iCPPField = (ICPPField)cPPNameCollector.getName(20).resolveBinding();
        IBinding iBinding = cPPNameCollector.getName(33).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iBinding instanceof ICPPSpecialization));
        AST2TemplateTests.assertSame((Object)((ICPPSpecialization)iBinding).getSpecializedBinding(), (Object)iCPPMethod);
        iBinding = cPPNameCollector.getName(36).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iBinding instanceof ICPPSpecialization));
        AST2TemplateTests.assertSame((Object)((ICPPSpecialization)iBinding).getSpecializedBinding(), (Object)iCPPMethod2);
        AST2TemplateTests.assertSame((Object)iCPPField, (Object)cPPNameCollector.getName(39).resolveBinding());
        AST2TemplateTests.assertSame((Object)iCPPField, (Object)cPPNameCollector.getName(41).resolveBinding());
    }

    public void testBug98961() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class B { int i; };                       \n");
        stringBuffer.append("template <class T > class A {             \n");
        stringBuffer.append("   typedef T* _T;                         \n");
        stringBuffer.append("};                                        \n");
        stringBuffer.append("void f(){                                 \n");
        stringBuffer.append("   A<B>::_T t;                            \n");
        stringBuffer.append("   (*t).i;                                \n");
        stringBuffer.append("}                                         \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        ICPPField iCPPField = (ICPPField)cPPNameCollector.getName(1).resolveBinding();
        ITypedef iTypedef = (ITypedef)cPPNameCollector.getName(5).resolveBinding();
        ICPPVariable iCPPVariable = (ICPPVariable)cPPNameCollector.getName(12).resolveBinding();
        IType iType = iCPPVariable.getType();
        AST2TemplateTests.assertTrue((boolean)(iType instanceof ICPPSpecialization));
        AST2TemplateTests.assertSame((Object)((ICPPSpecialization)iType).getSpecializedBinding(), (Object)iTypedef);
        AST2TemplateTests.assertSame((Object)((IPointerType)((ITypedef)iType).getType()).getType(), (Object)iCPPClassType);
        AST2TemplateTests.assertSame((Object)iCPPField, (Object)cPPNameCollector.getName(14).resolveBinding());
    }

    public void testBug98784() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class A {                                 \n");
        stringBuffer.append("   template <class T > void f( T ) {      \n");
        stringBuffer.append("      begin();                            \n");
        stringBuffer.append("   }                                      \n");
        stringBuffer.append("   void begin();                          \n");
        stringBuffer.append("};                                        \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        AST2TemplateTests.assertSame((Object)cPPNameCollector.getName(5).resolveBinding(), (Object)cPPNameCollector.getName(6).resolveBinding());
    }

    public void testBug99254() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template <class T> class A {                  \n");
        stringBuffer.append("   A( T t );                                  \n");
        stringBuffer.append("};                                            \n");
        stringBuffer.append("void f( A<int> a );                           \n");
        stringBuffer.append("void m(){                                     \n");
        stringBuffer.append("   f( A<int>(1) );                            \n");
        stringBuffer.append("}                                             \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPConstructor iCPPConstructor = (ICPPConstructor)cPPNameCollector.getName(2).resolveBinding();
        ICPPFunction iCPPFunction = (ICPPFunction)cPPNameCollector.getName(5).resolveBinding();
        ICPPSpecialization iCPPSpecialization = (ICPPSpecialization)cPPNameCollector.getName(11).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPSpecialization.getSpecializedBinding(), (Object)iCPPConstructor);
        AST2TemplateTests.assertSame((Object)iCPPFunction, (Object)cPPNameCollector.getName(10).resolveBinding());
    }

    public void testBug99254_2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace core {                                \n");
        stringBuffer.append("   template<class T> class A {                  \n");
        stringBuffer.append("      A( T x, T y );                            \n");
        stringBuffer.append("   };                                           \n");
        stringBuffer.append("}                                               \n");
        stringBuffer.append("class B {                                       \n");
        stringBuffer.append("   int add(const core::A<int> &rect );          \n");
        stringBuffer.append("};                                              \n");
        stringBuffer.append("void f( B* b ){                                 \n");
        stringBuffer.append("   b->add( core::A<int>(10, 2) );               \n");
        stringBuffer.append("}                                               \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPConstructor iCPPConstructor = (ICPPConstructor)cPPNameCollector.getName(3).resolveBinding();
        ICPPMethod iCPPMethod = (ICPPMethod)cPPNameCollector.getName(9).resolveBinding();
        ICPPSpecialization iCPPSpecialization = (ICPPSpecialization)cPPNameCollector.getName(20).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPSpecialization.getSpecializedBinding(), (Object)iCPPConstructor);
        AST2TemplateTests.assertSame((Object)iCPPMethod, (Object)cPPNameCollector.getName(19).resolveBinding());
    }

    public void testBug99254_3() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template <class T> class A { A( T ); };         \n");
        stringBuffer.append("typedef signed int s32;                         \n");
        stringBuffer.append("class B {                                       \n");
        stringBuffer.append("   int add(const A<s32> &rect );                \n");
        stringBuffer.append("};                                              \n");
        stringBuffer.append("void f( B* b ){                                 \n");
        stringBuffer.append("   b->add( A<int>(10) );                        \n");
        stringBuffer.append("}                                               \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPConstructor iCPPConstructor = (ICPPConstructor)cPPNameCollector.getName(2).resolveBinding();
        ICPPMethod iCPPMethod = (ICPPMethod)cPPNameCollector.getName(7).resolveBinding();
        ICPPSpecialization iCPPSpecialization = (ICPPSpecialization)cPPNameCollector.getName(17).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPSpecialization.getSpecializedBinding(), (Object)iCPPConstructor);
        AST2TemplateTests.assertSame((Object)iCPPMethod, (Object)cPPNameCollector.getName(16).resolveBinding());
    }

    public void testBug98666() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("A::template B<T> b;", ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPASTQualifiedName iCPPASTQualifiedName = (ICPPASTQualifiedName)cPPNameCollector.getName(0);
        IASTName[] iASTNameArray = iCPPASTQualifiedName.getNames();
        AST2TemplateTests.assertTrue((boolean)(iASTNameArray[1] instanceof ICPPASTTemplateId));
        AST2TemplateTests.assertEquals((String)((ICPPASTTemplateId)iASTNameArray[1]).toString(), (String)"B");
    }

    public void testBug90678() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template <class T> struct A{                          \n");
        stringBuffer.append("   class C {                                          \n");
        stringBuffer.append("      template <class T2> struct B {};                \n");
        stringBuffer.append("   };                                                 \n");
        stringBuffer.append("};                                                    \n");
        stringBuffer.append("template <class T> template <class T2>                \n");
        stringBuffer.append("struct A<T>::C::B<T2*>{};                             \n");
        stringBuffer.append("A<short>::C::B<int*> ab;                              \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPTemplateParameter iCPPTemplateParameter = (ICPPTemplateParameter)cPPNameCollector.getName(0).resolveBinding();
        ICPPTemplateParameter iCPPTemplateParameter2 = (ICPPTemplateParameter)cPPNameCollector.getName(3).resolveBinding();
        ICPPClassTemplate iCPPClassTemplate = (ICPPClassTemplate)cPPNameCollector.getName(4).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPTemplateParameter, (Object)cPPNameCollector.getName(5).resolveBinding());
        AST2TemplateTests.assertSame((Object)iCPPTemplateParameter2, (Object)cPPNameCollector.getName(6).resolveBinding());
        AST2TemplateTests.assertSame((Object)iCPPTemplateParameter, (Object)cPPNameCollector.getName(10).resolveBinding());
        AST2TemplateTests.assertSame((Object)iCPPTemplateParameter2, (Object)cPPNameCollector.getName(14).resolveBinding());
        ICPPClassTemplatePartialSpecialization iCPPClassTemplatePartialSpecialization = (ICPPClassTemplatePartialSpecialization)cPPNameCollector.getName(12).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPClassTemplatePartialSpecialization.getPrimaryClassTemplate(), (Object)iCPPClassTemplate);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(19).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iCPPClassType instanceof ICPPTemplateInstance));
        AST2TemplateTests.assertSame((Object)((ICPPTemplateInstance)iCPPClassType).getSpecializedBinding(), (Object)iCPPClassTemplatePartialSpecialization);
    }

    public void testBug95208() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template <class T> int f(T); // #1\n");
        stringBuffer.append("int f(int);                  // #2\n");
        stringBuffer.append("int k = f(1);           // uses #2\n");
        stringBuffer.append("int l = f<>(1);         // uses #1\n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPFunctionTemplate iCPPFunctionTemplate = (ICPPFunctionTemplate)cPPNameCollector.getName(1).resolveBinding();
        ICPPFunction iCPPFunction = (ICPPFunction)cPPNameCollector.getName(4).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPFunction, (Object)cPPNameCollector.getName(7).resolveBinding());
        IBinding iBinding = cPPNameCollector.getName(9).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iBinding instanceof ICPPTemplateInstance));
        AST2TemplateTests.assertSame((Object)((ICPPTemplateInstance)iBinding).getSpecializedBinding(), (Object)iCPPFunctionTemplate);
        AST2TemplateTests.assertSame((Object)iCPPFunctionTemplate, (Object)cPPNameCollector.getName(10).resolveBinding());
        iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        iCPPFunctionTemplate = (ICPPFunctionTemplate)cPPNameCollector.getName(1).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPFunctionTemplate, (Object)cPPNameCollector.getName(10).resolveBinding());
    }

    public void testBug103578() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template <class T, int someConst = 0 >  class A {};      \n");
        stringBuffer.append("int f() {                                                \n");
        stringBuffer.append("   const int local = 10;                                 \n");
        stringBuffer.append("   A<int, local> broken;                                 \n");
        stringBuffer.append("};                                                       \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, true);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPClassTemplate iCPPClassTemplate = (ICPPClassTemplate)cPPNameCollector.getName(2).resolveBinding();
        IVariable iVariable = (IVariable)cPPNameCollector.getName(4).resolveBinding();
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(5).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iCPPClassType instanceof ICPPTemplateInstance));
        AST2TemplateTests.assertSame((Object)((ICPPTemplateInstance)iCPPClassType).getTemplateDefinition(), (Object)iCPPClassTemplate);
        AST2TemplateTests.assertSame((Object)iVariable, (Object)cPPNameCollector.getName(7).resolveBinding());
    }

    public void testBug103715() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template <class T> class A : public T {};   \n");
        stringBuffer.append("class B { int base; };                      \n");
        stringBuffer.append("void f() {                                  \n");
        stringBuffer.append("   A< B > a;                                \n");
        stringBuffer.append("   a.base;                                  \n");
        stringBuffer.append("}                                           \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, true);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPField iCPPField = (ICPPField)cPPNameCollector.getName(4).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPField, (Object)cPPNameCollector.getName(11).resolveBinding());
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(3).resolveBinding();
        ICPPClassType iCPPClassType2 = (ICPPClassType)cPPNameCollector.getName(6).resolveBinding();
        ICPPBase[] iCPPBaseArray = iCPPClassType2.getBases();
        AST2TemplateTests.assertEquals((int)iCPPBaseArray.length, (int)1);
        AST2TemplateTests.assertSame((Object)iCPPBaseArray[0].getBaseClass(), (Object)iCPPClassType);
    }

    public void testBug74276() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template < class T > class complex;         \n");
        stringBuffer.append("template <> class complex <float>;          \n");
        stringBuffer.append("template < class T > class complex{         \n");
        stringBuffer.append("};                                          \n");
        stringBuffer.append("template <> class complex< float > {        \n");
        stringBuffer.append("   void f( float );                         \n");
        stringBuffer.append("};                                          \n");
        stringBuffer.append("void complex<float>::f(float){              \n");
        stringBuffer.append("}                                           \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, true);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPClassTemplate iCPPClassTemplate = (ICPPClassTemplate)cPPNameCollector.getName(1).resolveBinding();
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(2).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iCPPClassType instanceof ICPPSpecialization));
        AST2TemplateTests.assertSame((Object)((ICPPSpecialization)iCPPClassType).getSpecializedBinding(), (Object)iCPPClassTemplate);
        AST2TemplateTests.assertSame((Object)iCPPClassTemplate, (Object)cPPNameCollector.getName(5).resolveBinding());
        AST2TemplateTests.assertSame((Object)iCPPClassType, (Object)cPPNameCollector.getName(6).resolveBinding());
        ICPPMethod iCPPMethod = (ICPPMethod)cPPNameCollector.getName(8).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPMethod, (Object)cPPNameCollector.getName(10).resolveBinding());
    }

    public void testBug105852() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template< class T1, int q > class C {};      \n");
        stringBuffer.append("template< class T1, class T2> class A {};    \n");
        stringBuffer.append("template< class T1, class T2, int q1, int q2>\n");
        stringBuffer.append("class A< C<T1, q1>, C<T2, q2> > {};          \n");
        stringBuffer.append("class N {};                                  \n");
        stringBuffer.append("typedef A<C<N,1>, C<N,1> > myType;            \n");
        stringBuffer.append("void m(){                                    \n");
        stringBuffer.append("   myType t;                                 \n");
        stringBuffer.append("}                                            \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, true);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ITypedef iTypedef = (ITypedef)cPPNameCollector.getName(31).resolveBinding();
        ICPPClassType iCPPClassType = (ICPPClassType)iTypedef.getType();
        ICPPSpecialization iCPPSpecialization = (ICPPSpecialization)cPPNameCollector.getName(10).resolveBinding();
        AST2TemplateTests.assertTrue((boolean)(iCPPClassType instanceof ICPPTemplateInstance));
        AST2TemplateTests.assertSame((Object)((ICPPTemplateInstance)iCPPClassType).getTemplateDefinition(), (Object)iCPPSpecialization);
    }

    public void testBug105769() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template< class T > class A : public T {};      \n");
        stringBuffer.append("class C { public: int c; };                     \n");
        stringBuffer.append("class B : public A<C> { };                      \n");
        stringBuffer.append("void main(){                                    \n");
        stringBuffer.append("   B k;                                         \n");
        stringBuffer.append("   k.c;                                         \n");
        stringBuffer.append("}                                               \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, true);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPVariable iCPPVariable = (ICPPVariable)cPPNameCollector.getName(13).resolveBinding();
        AST2TemplateTests.assertSame((Object)iCPPVariable, (Object)cPPNameCollector.getName(4).resolveBinding());
    }
}

