/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests.ast2;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.cdt.core.dom.ICodeReaderFactory;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclarationStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IASTReturnStatement;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.ILabel;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IQualifierType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.c.CASTVisitor;
import org.eclipse.cdt.core.dom.ast.cpp.CPPASTVisitor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPDelegate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDeclaration;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.NullLogService;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.internal.core.dom.parser.c.ANSICParserExtensionConfiguration;
import org.eclipse.cdt.internal.core.dom.parser.c.CVisitor;
import org.eclipse.cdt.internal.core.dom.parser.c.GCCParserExtensionConfiguration;
import org.eclipse.cdt.internal.core.dom.parser.c.GNUCSourceParser;
import org.eclipse.cdt.internal.core.dom.parser.c.ICParserExtensionConfiguration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ANSICPPParserExtensionConfiguration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.GNUCPPSourceParser;
import org.eclipse.cdt.internal.core.dom.parser.cpp.GPPParserExtensionConfiguration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPParserExtensionConfiguration;
import org.eclipse.cdt.internal.core.parser.ParserException;
import org.eclipse.cdt.internal.core.parser.scanner2.DOMScanner;
import org.eclipse.cdt.internal.core.parser.scanner2.FileCodeReaderFactory;
import org.eclipse.cdt.internal.core.parser.scanner2.GCCScannerExtensionConfiguration;
import org.eclipse.cdt.internal.core.parser.scanner2.GPPScannerExtensionConfiguration;
import org.eclipse.cdt.internal.core.parser.scanner2.IScannerExtensionConfiguration;

public class CompleteParser2Tests
extends TestCase {
    private static final NullLogService NULL_LOG = new NullLogService();

    protected void assertInstances(CPPNameCollector cPPNameCollector, IBinding iBinding, int n) throws Exception {
        int n2 = 0;
        int n3 = 0;
        while (n3 < cPPNameCollector.size()) {
            if (cPPNameCollector.getName(n3).resolveBinding() == iBinding) {
                ++n2;
            }
            ++n3;
        }
        CompleteParser2Tests.assertEquals((int)n2, (int)n);
    }

    protected void assertInstances(CNameCollector cNameCollector, IBinding iBinding, int n) throws Exception {
        int n2 = 0;
        int n3 = 0;
        while (n3 < cNameCollector.size()) {
            if (cNameCollector.getName(n3).resolveBinding() == iBinding) {
                ++n2;
            }
            ++n3;
        }
        CompleteParser2Tests.assertEquals((int)n2, (int)n);
    }

    protected IASTTranslationUnit parse(String string, boolean bl, ParserLanguage parserLanguage) throws Exception {
        return this.parse(string, bl, parserLanguage, false);
    }

    protected IASTTranslationUnit parse(String string, boolean bl) throws Exception {
        return this.parse(string, bl, ParserLanguage.CPP);
    }

    protected IASTTranslationUnit parse(String string) throws Exception {
        return this.parse(string, true, ParserLanguage.CPP);
    }

    protected IASTTranslationUnit parse(String string, boolean bl, ParserLanguage parserLanguage, boolean bl2) throws Exception {
        Object object;
        CodeReader codeReader = new CodeReader(string.toCharArray());
        ScannerInfo scannerInfo = new ScannerInfo();
        Object object2 = null;
        object2 = parserLanguage == ParserLanguage.C ? new GCCScannerExtensionConfiguration() : new GPPScannerExtensionConfiguration();
        GNUCPPSourceParser gNUCPPSourceParser = null;
        DOMScanner dOMScanner = new DOMScanner(codeReader, (IScannerInfo)scannerInfo, ParserMode.COMPLETE_PARSE, parserLanguage, (IParserLogService)NULL_LOG, (IScannerExtensionConfiguration)object2, (ICodeReaderFactory)FileCodeReaderFactory.getInstance());
        if (parserLanguage == ParserLanguage.CPP) {
            object = null;
            object = bl2 ? new GPPParserExtensionConfiguration() : new ANSICPPParserExtensionConfiguration();
            gNUCPPSourceParser = new GNUCPPSourceParser((IScanner)dOMScanner, ParserMode.COMPLETE_PARSE, (IParserLogService)NULL_LOG, (ICPPParserExtensionConfiguration)object);
        } else {
            object = null;
            object = bl2 ? new GCCParserExtensionConfiguration() : new ANSICParserExtensionConfiguration();
            gNUCPPSourceParser = new GNUCSourceParser((IScanner)dOMScanner, ParserMode.COMPLETE_PARSE, (IParserLogService)NULL_LOG, (ICParserExtensionConfiguration)object);
        }
        object = gNUCPPSourceParser.parse();
        if (gNUCPPSourceParser.encounteredError() && bl) {
            throw new ParserException("FAILURE");
        }
        if (bl) {
            if (parserLanguage == ParserLanguage.C) {
                IASTProblem[] iASTProblemArray = CVisitor.getProblems((IASTTranslationUnit)object);
                CompleteParser2Tests.assertEquals((int)iASTProblemArray.length, (int)0);
            } else if (parserLanguage == ParserLanguage.CPP) {
                IASTProblem[] iASTProblemArray = CPPVisitor.getProblems((IASTTranslationUnit)object);
                CompleteParser2Tests.assertEquals((int)iASTProblemArray.length, (int)0);
            }
        }
        return object;
    }

    public void testEmptyCompilationUnit() throws Exception {
        this.parse("// no real code ");
    }

    public void testSimpleNamespace() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("namespace A { }");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)1);
        CompleteParser2Tests.assertTrue((boolean)(cPPNameCollector.getName(0).resolveBinding() instanceof ICPPNamespace));
    }

    public void testMultipleNamespaceDefinitions() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("namespace A { } namespace A { }");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)2);
        ICPPNamespace iCPPNamespace = (ICPPNamespace)cPPNameCollector.getName(0).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iCPPNamespace, 2);
    }

    public void testNestedNamespaceDefinitions() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("namespace A { namespace B { } }");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)2);
        ICPPNamespace iCPPNamespace = (ICPPNamespace)cPPNameCollector.getName(0).resolveBinding();
        ICPPNamespace iCPPNamespace2 = (ICPPNamespace)cPPNameCollector.getName(1).resolveBinding();
        CompleteParser2Tests.assertSame((Object)iCPPNamespace.getNamespaceScope(), (Object)iCPPNamespace2.getNamespaceScope().getParent());
    }

    public void testEmptyClassDeclaration() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("class A { };");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)1);
        CompleteParser2Tests.assertTrue((boolean)(cPPNameCollector.getName(0).resolveBinding() instanceof ICPPClassType));
    }

    public void testSimpleSubclass() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("class A { };  class B : public A { };");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)3);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        ICPPClassType iCPPClassType2 = (ICPPClassType)cPPNameCollector.getName(1).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType, 2);
        CompleteParser2Tests.assertEquals((int)iCPPClassType2.getBases().length, (int)1);
        ICPPBase iCPPBase = iCPPClassType2.getBases()[0];
        CompleteParser2Tests.assertSame((Object)iCPPBase.getBaseClass(), (Object)iCPPClassType);
        CompleteParser2Tests.assertEquals((int)iCPPBase.getVisibility(), (int)1);
        CompleteParser2Tests.assertFalse((boolean)iCPPBase.isVirtual());
    }

    public void testNestedSubclass() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("namespace N { class A { }; } class B : protected virtual N::A { };");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)6);
        ICPPNamespace iCPPNamespace = (ICPPNamespace)cPPNameCollector.getName(0).resolveBinding();
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(1).resolveBinding();
        ICPPClassType iCPPClassType2 = (ICPPClassType)cPPNameCollector.getName(2).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iCPPNamespace, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType, 3);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType2, 1);
        CompleteParser2Tests.assertSame((Object)iCPPClassType.getScope(), (Object)iCPPNamespace.getNamespaceScope());
        ICPPBase iCPPBase = iCPPClassType2.getBases()[0];
        CompleteParser2Tests.assertSame((Object)iCPPBase.getBaseClass(), (Object)iCPPClassType);
        CompleteParser2Tests.assertTrue((boolean)iCPPBase.isVirtual());
        CompleteParser2Tests.assertEquals((int)iCPPBase.getVisibility(), (int)2);
    }

    public void testSimpleVariable() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x;");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)1);
        IVariable iVariable = (IVariable)cPPNameCollector.getName(0).resolveBinding();
        CompleteParser2Tests.assertTrue((boolean)(iVariable.getType() instanceof IBasicType));
        IBasicType iBasicType = (IBasicType)iVariable.getType();
        CompleteParser2Tests.assertEquals((int)iBasicType.getType(), (int)3);
    }

    public void testSimpleClassReferenceVariable() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("class A { }; A x;");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)3);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        IVariable iVariable = (IVariable)cPPNameCollector.getName(2).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType, 2);
        CompleteParser2Tests.assertSame((Object)iVariable.getType(), (Object)iCPPClassType);
    }

    public void testNestedClassReferenceVariable() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("namespace N { class A { }; } N::A x;");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)6);
        ICPPNamespace iCPPNamespace = (ICPPNamespace)cPPNameCollector.getName(0).resolveBinding();
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(1).resolveBinding();
        IVariable iVariable = (IVariable)cPPNameCollector.getName(5).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iCPPNamespace, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType, 3);
        CompleteParser2Tests.assertSame((Object)iVariable.getType(), (Object)iCPPClassType);
        CompleteParser2Tests.assertSame((Object)iCPPClassType.getScope(), (Object)iCPPNamespace.getNamespaceScope());
    }

    public void testMultipleDeclaratorsVariable() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("class A { }; A x, y, z;");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)5);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        IVariable iVariable = (IVariable)cPPNameCollector.getName(2).resolveBinding();
        IVariable iVariable2 = (IVariable)cPPNameCollector.getName(3).resolveBinding();
        IVariable iVariable3 = (IVariable)cPPNameCollector.getName(4).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType, 2);
        CompleteParser2Tests.assertSame((Object)iCPPClassType, (Object)iVariable.getType());
        CompleteParser2Tests.assertSame((Object)iVariable.getType(), (Object)iVariable2.getType());
        CompleteParser2Tests.assertSame((Object)iVariable2.getType(), (Object)iVariable3.getType());
    }

    public void testSimpleField() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("class A { double x; };");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)2);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        ICPPField iCPPField = (ICPPField)cPPNameCollector.getName(1).resolveBinding();
        CompleteParser2Tests.assertSame((Object)iCPPField.getScope(), (Object)iCPPClassType.getCompositeScope());
        IField[] iFieldArray = iCPPClassType.getFields();
        CompleteParser2Tests.assertEquals((int)iFieldArray.length, (int)1);
        CompleteParser2Tests.assertSame((Object)iFieldArray[0], (Object)iCPPField);
    }

    public void testUsingClauses() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("namespace A { namespace B { int x;  class C { static int y = 5; }; } } \n using namespace A::B;\n using A::B::x;using A::B::C;using A::B::C::y;");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)21);
        ICPPNamespace iCPPNamespace = (ICPPNamespace)cPPNameCollector.getName(0).resolveBinding();
        ICPPNamespace iCPPNamespace2 = (ICPPNamespace)cPPNameCollector.getName(1).resolveBinding();
        IVariable iVariable = (IVariable)cPPNameCollector.getName(2).resolveBinding();
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(3).resolveBinding();
        ICPPField iCPPField = (ICPPField)cPPNameCollector.getName(4).resolveBinding();
        ICPPUsingDeclaration iCPPUsingDeclaration = (ICPPUsingDeclaration)cPPNameCollector.getName(11).resolveBinding();
        ICPPUsingDeclaration iCPPUsingDeclaration2 = (ICPPUsingDeclaration)cPPNameCollector.getName(15).resolveBinding();
        ICPPUsingDeclaration iCPPUsingDeclaration3 = (ICPPUsingDeclaration)cPPNameCollector.getName(20).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iCPPNamespace, 5);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPNamespace2, 6);
        this.assertInstances(cPPNameCollector, (IBinding)iVariable, 1);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPField, 1);
        ICPPDelegate[] iCPPDelegateArray = iCPPUsingDeclaration.getDelegates();
        CompleteParser2Tests.assertSame((Object)iCPPDelegateArray[0].getBinding(), (Object)iVariable);
        CompleteParser2Tests.assertSame((Object)iCPPUsingDeclaration2.getDelegates()[0].getBinding(), (Object)iCPPClassType);
        CompleteParser2Tests.assertSame((Object)iCPPUsingDeclaration3.getDelegates()[0].getBinding(), (Object)iCPPField);
    }

    public void testEnumerations() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("namespace A { enum E { e1, e2, e3 }; E varE;}");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)7);
        ICPPNamespace iCPPNamespace = (ICPPNamespace)cPPNameCollector.getName(0).resolveBinding();
        IEnumeration iEnumeration = (IEnumeration)cPPNameCollector.getName(1).resolveBinding();
        IEnumerator iEnumerator = (IEnumerator)cPPNameCollector.getName(2).resolveBinding();
        IEnumerator iEnumerator2 = (IEnumerator)cPPNameCollector.getName(3).resolveBinding();
        IEnumerator iEnumerator3 = (IEnumerator)cPPNameCollector.getName(4).resolveBinding();
        IVariable iVariable = (IVariable)cPPNameCollector.getName(6).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iEnumeration, 2);
        CompleteParser2Tests.assertSame((Object)iEnumeration.getScope(), (Object)iCPPNamespace.getNamespaceScope());
        CompleteParser2Tests.assertSame((Object)iEnumerator.getScope(), (Object)iCPPNamespace.getNamespaceScope());
        CompleteParser2Tests.assertNotNull((Object)iEnumerator2);
        CompleteParser2Tests.assertNotNull((Object)iEnumerator3);
        CompleteParser2Tests.assertNotNull((Object)iVariable);
    }

    public void testSimpleFunction() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("void foo( void );");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)2);
        IFunction iFunction = (IFunction)cPPNameCollector.getName(0).resolveBinding();
        IParameter iParameter = (IParameter)cPPNameCollector.getName(1).resolveBinding();
        CompleteParser2Tests.assertEquals((int)iFunction.getParameters().length, (int)1);
        CompleteParser2Tests.assertSame((Object)iFunction.getParameters()[0], (Object)iParameter);
        CompleteParser2Tests.assertSame((Object)iParameter.getScope(), (Object)iFunction.getFunctionScope());
    }

    public void testSimpleFunctionWithTypes() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("class A { public: \n class B { }; }; const A::B &  foo( A * myParam );");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)8);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        ICPPClassType iCPPClassType2 = (ICPPClassType)cPPNameCollector.getName(1).resolveBinding();
        IFunction iFunction = (IFunction)cPPNameCollector.getName(5).resolveBinding();
        IParameter iParameter = (IParameter)cPPNameCollector.getName(7).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType, 3);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType2, 3);
        IFunctionType iFunctionType = iFunction.getType();
        CompleteParser2Tests.assertTrue((boolean)(iFunctionType.getReturnType() instanceof ICPPReferenceType));
        ICPPReferenceType iCPPReferenceType = (ICPPReferenceType)iFunctionType.getReturnType();
        CompleteParser2Tests.assertTrue((boolean)(iCPPReferenceType.getType() instanceof IQualifierType));
        CompleteParser2Tests.assertSame((Object)((IQualifierType)iCPPReferenceType.getType()).getType(), (Object)iCPPClassType2);
        IType iType = iFunctionType.getParameterTypes()[0];
        CompleteParser2Tests.assertTrue((boolean)iParameter.getType().isSameType(iType));
        CompleteParser2Tests.assertTrue((boolean)(iType instanceof IPointerType));
        CompleteParser2Tests.assertSame((Object)((IPointerType)iType).getType(), (Object)iCPPClassType);
    }

    public void testSimpleMethod() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("class A { void foo(); };");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)2);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        ICPPMethod iCPPMethod = (ICPPMethod)cPPNameCollector.getName(1).resolveBinding();
        CompleteParser2Tests.assertSame((Object)iCPPMethod.getScope(), (Object)iCPPClassType.getCompositeScope());
    }

    public void testSimpleMethodWithTypes() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("class U { }; class A { U foo( U areDumb ); };");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)6);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        ICPPClassType iCPPClassType2 = (ICPPClassType)cPPNameCollector.getName(1).resolveBinding();
        ICPPMethod iCPPMethod = (ICPPMethod)cPPNameCollector.getName(3).resolveBinding();
        IParameter iParameter = (IParameter)cPPNameCollector.getName(5).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType, 3);
        CompleteParser2Tests.assertSame((Object)iCPPMethod.getScope(), (Object)iCPPClassType2.getCompositeScope());
        IFunctionType iFunctionType = iCPPMethod.getType();
        CompleteParser2Tests.assertSame((Object)iFunctionType.getReturnType(), (Object)iCPPClassType);
        CompleteParser2Tests.assertSame((Object)iParameter.getType(), (Object)iCPPClassType);
    }

    public void testUsingDeclarationWithFunctionsAndMethods() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("namespace N { int foo(void); } class A { static int bar(void); }; using N::foo; using ::A::bar;");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)12);
        ICPPNamespace iCPPNamespace = (ICPPNamespace)cPPNameCollector.getName(0).resolveBinding();
        IFunction iFunction = (IFunction)cPPNameCollector.getName(1).resolveBinding();
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(3).resolveBinding();
        ICPPMethod iCPPMethod = (ICPPMethod)cPPNameCollector.getName(4).resolveBinding();
        ICPPUsingDeclaration iCPPUsingDeclaration = (ICPPUsingDeclaration)cPPNameCollector.getName(8).resolveBinding();
        ICPPUsingDeclaration iCPPUsingDeclaration2 = (ICPPUsingDeclaration)cPPNameCollector.getName(11).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iCPPNamespace, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iFunction, 1);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPMethod, 1);
        CompleteParser2Tests.assertSame((Object)iCPPUsingDeclaration.getDelegates()[0].getBinding(), (Object)iFunction);
        CompleteParser2Tests.assertSame((Object)iCPPUsingDeclaration2.getDelegates()[0].getBinding(), (Object)iCPPMethod);
    }

    public void testLinkageSpec() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("extern \"C\" { int foo(); }");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)1);
        IFunction iFunction = (IFunction)cPPNameCollector.getName(0).resolveBinding();
        CompleteParser2Tests.assertNotNull((Object)iFunction);
    }

    public void testBogdansExample() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("namespace A { namespace B {\tenum e1{e_1,e_2};\tint x;\tclass C\t{\tstatic int y = 5;\t}; }} ");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)8);
        ICPPNamespace iCPPNamespace = (ICPPNamespace)cPPNameCollector.getName(0).resolveBinding();
        ICPPNamespace iCPPNamespace2 = (ICPPNamespace)cPPNameCollector.getName(1).resolveBinding();
        IEnumeration iEnumeration = (IEnumeration)cPPNameCollector.getName(2).resolveBinding();
        IEnumerator iEnumerator = (IEnumerator)cPPNameCollector.getName(3).resolveBinding();
        IEnumerator iEnumerator2 = (IEnumerator)cPPNameCollector.getName(4).resolveBinding();
        IVariable iVariable = (IVariable)cPPNameCollector.getName(5).resolveBinding();
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(6).resolveBinding();
        ICPPField iCPPField = (ICPPField)cPPNameCollector.getName(7).resolveBinding();
        CompleteParser2Tests.assertSame((Object)iCPPNamespace2.getScope(), (Object)iCPPNamespace.getNamespaceScope());
        CompleteParser2Tests.assertSame((Object)iEnumeration.getScope(), (Object)iCPPNamespace2.getNamespaceScope());
        CompleteParser2Tests.assertSame((Object)iEnumerator.getScope(), (Object)iCPPNamespace2.getNamespaceScope());
        CompleteParser2Tests.assertSame((Object)iEnumerator2.getType(), (Object)iEnumeration);
        CompleteParser2Tests.assertNotNull((Object)iVariable);
        CompleteParser2Tests.assertNotNull((Object)iCPPClassType);
        CompleteParser2Tests.assertNotNull((Object)iCPPField);
    }

    public void testAndrewsExample() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("namespace N{ class A {}; }\tusing namespace N;\tclass B: public A{};");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)5);
        ICPPNamespace iCPPNamespace = (ICPPNamespace)cPPNameCollector.getName(0).resolveBinding();
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(1).resolveBinding();
        ICPPClassType iCPPClassType2 = (ICPPClassType)cPPNameCollector.getName(3).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iCPPNamespace, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType, 2);
        ICPPBase iCPPBase = iCPPClassType2.getBases()[0];
        CompleteParser2Tests.assertSame((Object)iCPPBase.getBaseClass(), (Object)iCPPClassType);
    }

    public void testSimpleTypedef() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("typedef int myInt;\n myInt var;");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)3);
        ITypedef iTypedef = (ITypedef)cPPNameCollector.getName(0).resolveBinding();
        IVariable iVariable = (IVariable)cPPNameCollector.getName(2).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iTypedef, 2);
        CompleteParser2Tests.assertTrue((boolean)(iTypedef.getType() instanceof IBasicType));
        CompleteParser2Tests.assertSame((Object)iVariable.getType(), (Object)iTypedef);
    }

    public void testComplexTypedef() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("class A{ }; typedef A ** A_DOUBLEPTR;");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)3);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        ITypedef iTypedef = (ITypedef)cPPNameCollector.getName(2).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType, 2);
        CompleteParser2Tests.assertTrue((boolean)(iTypedef.getType() instanceof IPointerType));
        IPointerType iPointerType = (IPointerType)iTypedef.getType();
        CompleteParser2Tests.assertTrue((boolean)(iPointerType.getType() instanceof IPointerType));
        iPointerType = (IPointerType)iPointerType.getType();
        CompleteParser2Tests.assertSame((Object)iPointerType.getType(), (Object)iCPPClassType);
    }

    protected void assertQualifiedName(String[] stringArray, String[] stringArray2) {
        CompleteParser2Tests.assertNotNull((Object)stringArray);
        CompleteParser2Tests.assertNotNull((Object)stringArray2);
        CompleteParser2Tests.assertEquals((int)stringArray.length, (int)stringArray2.length);
        int n = 0;
        while (n < stringArray.length) {
            CompleteParser2Tests.assertEquals((String)stringArray[n], (String)stringArray2[n]);
            ++n;
        }
    }

    public void testBug40842() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class A {} a;\n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(((Object)stringWriter).toString());
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[0];
        IASTCompositeTypeSpecifier iASTCompositeTypeSpecifier = (IASTCompositeTypeSpecifier)iASTSimpleDeclaration.getDeclSpecifier();
        ICPPClassType iCPPClassType = (ICPPClassType)iASTCompositeTypeSpecifier.getName().resolveBinding();
        IVariable iVariable = (IVariable)iASTSimpleDeclaration.getDeclarators()[0].getName().resolveBinding();
        CompleteParser2Tests.assertSame((Object)iVariable.getType(), (Object)iCPPClassType);
    }

    public void testNestedClassname() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("namespace A { } \n class A::B { };");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPNamespace iCPPNamespace = (ICPPNamespace)cPPNameCollector.getName(0).resolveBinding();
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(1).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iCPPNamespace, 2);
        CompleteParser2Tests.assertEquals((Object)iCPPClassType.getScope(), (Object)iCPPNamespace.getNamespaceScope());
    }

    public void testForwardDeclaration() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("class forward;");
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[0];
        CompleteParser2Tests.assertEquals((int)iASTSimpleDeclaration.getDeclarators().length, (int)0);
        IASTElaboratedTypeSpecifier iASTElaboratedTypeSpecifier = (IASTElaboratedTypeSpecifier)iASTSimpleDeclaration.getDeclSpecifier();
        ICPPClassType iCPPClassType = (ICPPClassType)iASTElaboratedTypeSpecifier.getName().resolveBinding();
        CompleteParser2Tests.assertNotNull((Object)iCPPClassType);
    }

    public void testElaboratedType() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("class A; class A * a;");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)3);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        IVariable iVariable = (IVariable)cPPNameCollector.getName(2).resolveBinding();
        IPointerType iPointerType = (IPointerType)iVariable.getType();
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType, 2);
        CompleteParser2Tests.assertSame((Object)iPointerType.getType(), (Object)iCPPClassType);
    }

    public void testForewardDeclarationWithUsage() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("class A; A * anA;class A { };");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)4);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        IVariable iVariable = (IVariable)cPPNameCollector.getName(2).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType, 3);
        IPointerType iPointerType = (IPointerType)iVariable.getType();
        CompleteParser2Tests.assertSame((Object)iPointerType.getType(), (Object)iCPPClassType);
    }

    public void testASM() throws Exception {
        this.parse("asm ( \"blah blah blah\" );");
    }

    public void testOverride() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("void foo();\n void foo( int );\n");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)3);
        IFunction iFunction = (IFunction)cPPNameCollector.getName(0).resolveBinding();
        IFunction iFunction2 = (IFunction)cPPNameCollector.getName(1).resolveBinding();
        CompleteParser2Tests.assertNotSame((Object)iFunction, (Object)iFunction2);
    }

    public void testSimpleExpression() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x; int y = x;");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)3);
        IVariable iVariable = (IVariable)cPPNameCollector.getName(0).resolveBinding();
        IVariable iVariable2 = (IVariable)cPPNameCollector.getName(1).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iVariable, 2);
        CompleteParser2Tests.assertNotNull((Object)iVariable2);
    }

    public void testParameterExpressions() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x = 5; void foo( int sub = x ) { }");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)4);
        IVariable iVariable = (IVariable)cPPNameCollector.getName(0).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iVariable, 2);
    }

    public void testNestedNamespaceExpression() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("namespace A { int x = 666; } int y  = A::x;");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)6);
        ICPPNamespace iCPPNamespace = (ICPPNamespace)cPPNameCollector.getName(0).resolveBinding();
        IVariable iVariable = (IVariable)cPPNameCollector.getName(1).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iCPPNamespace, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iVariable, 3);
    }

    public void testConstructorChain() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x = 5;\n class A \n{ public : \n int a; \n A() : a( x ) { } };");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)6);
        IVariable iVariable = (IVariable)cPPNameCollector.getName(0).resolveBinding();
        ICPPField iCPPField = (ICPPField)cPPNameCollector.getName(2).resolveBinding();
        ICPPConstructor iCPPConstructor = (ICPPConstructor)cPPNameCollector.getName(3).resolveBinding();
        CompleteParser2Tests.assertNotNull((Object)iCPPConstructor);
        this.assertInstances(cPPNameCollector, (IBinding)iVariable, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPField, 2);
    }

    public void testArrayModExpression() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("const int x = 5; int y [ x ]; ");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)3);
        IVariable iVariable = (IVariable)cPPNameCollector.getName(0).resolveBinding();
        IVariable iVariable2 = (IVariable)cPPNameCollector.getName(1).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iVariable, 2);
        CompleteParser2Tests.assertTrue((boolean)(iVariable2.getType() instanceof IArrayType));
        CompleteParser2Tests.assertTrue((boolean)(((IArrayType)iVariable2.getType()).getType() instanceof IBasicType));
    }

    public void testPointerVariable() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("class A { }; A * anA;");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)3);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        IVariable iVariable = (IVariable)cPPNameCollector.getName(2).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType, 2);
        CompleteParser2Tests.assertTrue((boolean)(iVariable.getType() instanceof IPointerType));
        CompleteParser2Tests.assertSame((Object)((IPointerType)iVariable.getType()).getType(), (Object)iCPPClassType);
    }

    public void testExceptionSpecification() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("class A { }; void foo( void ) throw ( A );");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)4);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType, 2);
    }

    public void testNewExpressions() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("typedef int A; int B; int C; int D; int P; int*p = new  (P) (A)[B][C][D];");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)11);
        ITypedef iTypedef = (ITypedef)cPPNameCollector.getName(0).resolveBinding();
        IVariable iVariable = (IVariable)cPPNameCollector.getName(1).resolveBinding();
        IVariable iVariable2 = (IVariable)cPPNameCollector.getName(2).resolveBinding();
        IVariable iVariable3 = (IVariable)cPPNameCollector.getName(3).resolveBinding();
        IVariable iVariable4 = (IVariable)cPPNameCollector.getName(4).resolveBinding();
        IVariable iVariable5 = (IVariable)cPPNameCollector.getName(5).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iTypedef, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iVariable, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iVariable2, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iVariable3, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iVariable4, 2);
        CompleteParser2Tests.assertTrue((boolean)(iVariable5.getType() instanceof IPointerType));
    }

    public void testBug41520() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int f() { const int x = 666; const int y( x ); }");
        IASTCompoundStatement iASTCompoundStatement = (IASTCompoundStatement)((IASTFunctionDefinition)iASTTranslationUnit.getDeclarations()[0]).getBody();
        IASTDeclarationStatement iASTDeclarationStatement = (IASTDeclarationStatement)iASTCompoundStatement.getStatements()[1];
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTDeclarationStatement.getDeclaration();
        IASTDeclarator iASTDeclarator = iASTSimpleDeclaration.getDeclarators()[0];
        CompleteParser2Tests.assertFalse((boolean)(iASTDeclarator instanceof IASTFunctionDeclarator));
        CompleteParser2Tests.assertNotNull((Object)iASTDeclarator.getInitializer());
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)4);
        IVariable iVariable = (IVariable)cPPNameCollector.getName(1).resolveBinding();
        IVariable iVariable2 = (IVariable)cPPNameCollector.getName(2).resolveBinding();
        CompleteParser2Tests.assertNotNull((Object)iVariable2);
        this.assertInstances(cPPNameCollector, (IBinding)iVariable, 2);
    }

    public void testNewXReferences() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("const int max = 5;\n int * x = new int[max];");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)3);
        IVariable iVariable = (IVariable)cPPNameCollector.getName(0).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iVariable, 2);
    }

    public void testQualifiedNameReferences() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("class A{ class B{ class C { public: int cMethod(); }; }; }; \n  int A::B::C::cMethod() {}; \n");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)9);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        ICPPClassType iCPPClassType2 = (ICPPClassType)cPPNameCollector.getName(1).resolveBinding();
        ICPPClassType iCPPClassType3 = (ICPPClassType)cPPNameCollector.getName(2).resolveBinding();
        ICPPMethod iCPPMethod = (ICPPMethod)cPPNameCollector.getName(3).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType2, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType3, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPMethod, 3);
        CompleteParser2Tests.assertEquals((int)iCPPMethod.getVisibility(), (int)1);
        CompleteParser2Tests.assertSame((Object)iCPPMethod.getScope(), (Object)iCPPClassType3.getCompositeScope());
        CompleteParser2Tests.assertSame((Object)iCPPClassType3.getScope(), (Object)iCPPClassType2.getCompositeScope());
        CompleteParser2Tests.assertSame((Object)iCPPClassType2.getScope(), (Object)iCPPClassType.getCompositeScope());
    }

    public void testIsConstructor() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("class A{ public: A(); }; \n  A::A() {}; \n");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)5);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        ICPPConstructor iCPPConstructor = (ICPPConstructor)cPPNameCollector.getName(1).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPConstructor, 3);
    }

    public void testIsDestructor() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("class A{ public: ~A(); }; \n  A::~A() {}; \n");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)5);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        ICPPMethod iCPPMethod = (ICPPMethod)cPPNameCollector.getName(1).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPMethod, 3);
    }

    public void testBug41445() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("class A { }; namespace N { class B : public A { struct A {}; }; }");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)5);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        ICPPNamespace iCPPNamespace = (ICPPNamespace)cPPNameCollector.getName(1).resolveBinding();
        ICPPClassType iCPPClassType2 = (ICPPClassType)cPPNameCollector.getName(2).resolveBinding();
        ICPPClassType iCPPClassType3 = (ICPPClassType)cPPNameCollector.getName(4).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType, 2);
        CompleteParser2Tests.assertNotSame((Object)iCPPClassType, (Object)iCPPClassType3);
        CompleteParser2Tests.assertSame((Object)iCPPClassType3.getScope(), (Object)iCPPClassType2.getCompositeScope());
        CompleteParser2Tests.assertSame((Object)iCPPClassType2.getScope(), (Object)iCPPNamespace.getNamespaceScope());
        CompleteParser2Tests.assertSame((Object)iCPPClassType2.getBases()[0].getBaseClass(), (Object)iCPPClassType);
    }

    public void testSimpleFunctionBody() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("class A { int f1(); }; const int x = 4; int f() { return x; } int A::f1() { return x; }");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)9);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        ICPPMethod iCPPMethod = (ICPPMethod)cPPNameCollector.getName(1).resolveBinding();
        IVariable iVariable = (IVariable)cPPNameCollector.getName(2).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPMethod, 3);
        this.assertInstances(cPPNameCollector, (IBinding)iVariable, 3);
    }

    public void testSimpleForLoop() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("const int FIVE = 5;  void f() {  int x = 0; for( int i = 0; i < FIVE; ++i ) { x += i; }  }");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)9);
        IVariable iVariable = (IVariable)cPPNameCollector.getName(0).resolveBinding();
        IVariable iVariable2 = (IVariable)cPPNameCollector.getName(2).resolveBinding();
        IVariable iVariable3 = (IVariable)cPPNameCollector.getName(3).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iVariable, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iVariable2, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iVariable3, 4);
    }

    public void testBug42541() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("union{ int v; char a; } id;");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)4);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        ICPPField iCPPField = (ICPPField)cPPNameCollector.getName(1).resolveBinding();
        ICPPField iCPPField2 = (ICPPField)cPPNameCollector.getName(2).resolveBinding();
        IVariable iVariable = (IVariable)cPPNameCollector.getName(3).resolveBinding();
        CompleteParser2Tests.assertEquals((int)iCPPClassType.getKey(), (int)2);
        CompleteParser2Tests.assertSame((Object)iCPPField.getScope(), (Object)iCPPClassType.getCompositeScope());
        CompleteParser2Tests.assertSame((Object)iCPPField2.getScope(), (Object)iCPPClassType.getCompositeScope());
        CompleteParser2Tests.assertSame((Object)iVariable.getType(), (Object)iCPPClassType);
    }

    public void testSimpleIfStatement() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("const bool T = true; int foo() { if( T ) { return 5; } else if( ! T ) return 20; else { return 10; } }");
        IASTFunctionDefinition iASTFunctionDefinition = (IASTFunctionDefinition)iASTTranslationUnit.getDeclarations()[1];
        IASTCompoundStatement iASTCompoundStatement = (IASTCompoundStatement)iASTFunctionDefinition.getBody();
        IASTIfStatement iASTIfStatement = (IASTIfStatement)iASTCompoundStatement.getStatements()[0];
        CompleteParser2Tests.assertTrue((boolean)(iASTIfStatement.getConditionExpression() instanceof IASTIdExpression));
        CompleteParser2Tests.assertTrue((boolean)(iASTIfStatement.getThenClause() instanceof IASTCompoundStatement));
        CompleteParser2Tests.assertTrue((boolean)(iASTIfStatement.getElseClause() instanceof IASTIfStatement));
        iASTIfStatement = (IASTIfStatement)iASTIfStatement.getElseClause();
        CompleteParser2Tests.assertTrue((boolean)(iASTIfStatement.getConditionExpression() instanceof IASTUnaryExpression));
        CompleteParser2Tests.assertTrue((boolean)(iASTIfStatement.getThenClause() instanceof IASTReturnStatement));
        CompleteParser2Tests.assertTrue((boolean)(iASTIfStatement.getElseClause() instanceof IASTCompoundStatement));
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)4);
        IVariable iVariable = (IVariable)cPPNameCollector.getName(0).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iVariable, 3);
    }

    public void testSimpleWhileStatement() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("const bool T = true; void foo() { int x = 0; while( T ) {  ++x;  if( x == 100 ) break; } }");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)6);
        IVariable iVariable = (IVariable)cPPNameCollector.getName(0).resolveBinding();
        IVariable iVariable2 = (IVariable)cPPNameCollector.getName(2).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iVariable, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iVariable2, 3);
    }

    public void testSimpleSwitchStatement() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("const int x = 5; const int y = 10; void foo() {                       \twhile( true ) {                       switch( x ) {                         case 1: break;                     case 2: goto blah;                 case y: continue;                  default: break;                 }                               }                                  blah : ;                        }                                  ");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)7);
        IVariable iVariable = (IVariable)cPPNameCollector.getName(0).resolveBinding();
        IVariable iVariable2 = (IVariable)cPPNameCollector.getName(1).resolveBinding();
        ILabel iLabel = (ILabel)cPPNameCollector.getName(4).resolveBinding();
        CompleteParser2Tests.assertNotNull((Object)iLabel);
        this.assertInstances(cPPNameCollector, (IBinding)iVariable, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iVariable2, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iLabel, 2);
    }

    public void testSimpleDoStatement() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("const int x = 3; int counter = 0; void foo() { do { ++counter; } while( counter != x ); } ");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)6);
        IVariable iVariable = (IVariable)cPPNameCollector.getName(0).resolveBinding();
        IVariable iVariable2 = (IVariable)cPPNameCollector.getName(1).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iVariable, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iVariable2, 3);
    }

    public void testThrowStatement() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("class A { }; void foo() throw ( A ) { throw A; throw; } ");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)4);
        ICompositeType iCompositeType = (ICompositeType)cPPNameCollector.getName(0).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iCompositeType, 3);
    }

    public void testScoping() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("void foo() { int x = 3; if( x == 1 ) { int x = 4; } else int x = 2; }");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)5);
        IVariable iVariable = (IVariable)cPPNameCollector.getName(1).resolveBinding();
        IVariable iVariable2 = (IVariable)cPPNameCollector.getName(3).resolveBinding();
        IVariable iVariable3 = (IVariable)cPPNameCollector.getName(4).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iVariable, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iVariable2, 1);
        this.assertInstances(cPPNameCollector, (IBinding)iVariable3, 1);
    }

    public void testEnumeratorReferences() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("enum E { e1, e2, e3 }; E anE = e1;");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)7);
        IEnumeration iEnumeration = (IEnumeration)cPPNameCollector.getName(0).resolveBinding();
        IEnumerator iEnumerator = (IEnumerator)cPPNameCollector.getName(1).resolveBinding();
        IEnumerator iEnumerator2 = (IEnumerator)cPPNameCollector.getName(2).resolveBinding();
        IEnumerator iEnumerator3 = (IEnumerator)cPPNameCollector.getName(3).resolveBinding();
        IVariable iVariable = (IVariable)cPPNameCollector.getName(5).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iEnumeration, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iEnumerator, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iEnumerator2, 1);
        this.assertInstances(cPPNameCollector, (IBinding)iEnumerator3, 1);
        this.assertInstances(cPPNameCollector, (IBinding)iVariable, 1);
    }

    public void testBug42840() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("void foo(); void foo() { } class SearchMe { };");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)3);
        IFunction iFunction = (IFunction)cPPNameCollector.getName(0).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iFunction, 2);
    }

    public void testBug42872() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("struct B {}; struct D : B {}; void foo(D* dp) { B* bp = dynamic_cast<B*>(dp); }");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)10);
        ICompositeType iCompositeType = (ICompositeType)cPPNameCollector.getName(0).resolveBinding();
        ICompositeType iCompositeType2 = (ICompositeType)cPPNameCollector.getName(1).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iCompositeType, 4);
        this.assertInstances(cPPNameCollector, (IBinding)iCompositeType2, 2);
    }

    public void testBug43503A() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("class SD_01 { void f_SD_01() {}}; int main(){ SD_01 * a = new SD_01(); a->f_SD_01();\t} ");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)8);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        ICPPMethod iCPPMethod = (ICPPMethod)cPPNameCollector.getName(1).resolveBinding();
        ICPPConstructor iCPPConstructor = iCPPClassType.getConstructors()[0];
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPConstructor, 1);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPMethod, 2);
    }

    public void testBug42979() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class OperatorOverload{\n");
        ((Writer)stringWriter).write("public:\n");
        ((Writer)stringWriter).write("  bool operator==( const class OperatorOverload& that )\n");
        ((Writer)stringWriter).write("  { return true; }\n");
        ((Writer)stringWriter).write("  bool operator!=( const class OperatorOverload& that );\n");
        ((Writer)stringWriter).write("}; \n");
        ((Writer)stringWriter).write("bool OperatorOverload::operator!=( const class OperatorOverload& that )\n");
        ((Writer)stringWriter).write("{ return false; }\n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(((Object)stringWriter).toString());
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)12);
        ICompositeType iCompositeType = (ICompositeType)cPPNameCollector.getName(0).resolveBinding();
        ICPPMethod iCPPMethod = (ICPPMethod)cPPNameCollector.getName(1).resolveBinding();
        ICPPMethod iCPPMethod2 = (ICPPMethod)cPPNameCollector.getName(4).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iCompositeType, 5);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPMethod, 1);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPMethod2, 3);
    }

    public void testBug43373() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("class A { static int x; }; int A::x = 5;");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)5);
        ICompositeType iCompositeType = (ICompositeType)cPPNameCollector.getName(0).resolveBinding();
        ICPPField iCPPField = (ICPPField)cPPNameCollector.getName(1).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iCompositeType, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPField, 3);
    }

    public void testBug39504() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("const int w = 2; int x[ 5 ]; int y = sizeof ( x[w] );");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)5);
        IVariable iVariable = (IVariable)cPPNameCollector.getName(0).resolveBinding();
        IVariable iVariable2 = (IVariable)cPPNameCollector.getName(1).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iVariable, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iVariable2, 2);
    }

    public void testBug43375() throws Exception {
        this.parse("extern int x;");
    }

    public void testBug43503() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class SD_02 {                ");
        stringBuffer.append("\tpublic:                    ");
        stringBuffer.append("   void f_SD_02();           ");
        stringBuffer.append(" };                          ");
        stringBuffer.append("class SD_01 {              \n");
        stringBuffer.append(" public:                   \n");
        stringBuffer.append("   SD_02 *next;            \n");
        stringBuffer.append("   void f_SD_01();         \n");
        stringBuffer.append("};                         \n");
        stringBuffer.append("int main(){                \n");
        stringBuffer.append("   SD_01 a = new SD_01();  \n");
        stringBuffer.append("   a->f_SD_01();           \n");
        stringBuffer.append("}                          \n");
        stringBuffer.append("void SD_01::f_SD_01()      \n");
        stringBuffer.append("{                          \n");
        stringBuffer.append("   next->f_SD_02();        \n");
        stringBuffer.append("}                          \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString());
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)17);
        ICompositeType iCompositeType = (ICompositeType)cPPNameCollector.getName(0).resolveBinding();
        ICPPMethod iCPPMethod = (ICPPMethod)cPPNameCollector.getName(1).resolveBinding();
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(2).resolveBinding();
        ICPPField iCPPField = (ICPPField)cPPNameCollector.getName(4).resolveBinding();
        ICPPMethod iCPPMethod2 = (ICPPMethod)cPPNameCollector.getName(5).resolveBinding();
        ICPPConstructor iCPPConstructor = iCPPClassType.getConstructors()[0];
        this.assertInstances(cPPNameCollector, (IBinding)iCompositeType, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPMethod, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType, 3);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPConstructor, 1);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPField, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPMethod2, 4);
    }

    public void testBug43679_A() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("struct Sample { int size() const; }; extern const Sample * getSample(); int trouble() {  return getSample()->size(); } ");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)7);
        ICompositeType iCompositeType = (ICompositeType)cPPNameCollector.getName(0).resolveBinding();
        ICPPMethod iCPPMethod = (ICPPMethod)cPPNameCollector.getName(1).resolveBinding();
        IFunction iFunction = (IFunction)cPPNameCollector.getName(3).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iCompositeType, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPMethod, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iFunction, 2);
    }

    public void testBug43679_B() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("struct Sample{int size() const; }; struct Sample; ");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)3);
        ICompositeType iCompositeType = (ICompositeType)cPPNameCollector.getName(0).resolveBinding();
        ICPPMethod iCPPMethod = (ICPPMethod)cPPNameCollector.getName(1).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iCompositeType, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPMethod, 1);
    }

    public void testBug43951() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("class B{ B(); ~B(); }; B::B(){} B::~B(){}");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)9);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        ICPPConstructor iCPPConstructor = (ICPPConstructor)cPPNameCollector.getName(1).resolveBinding();
        ICPPMethod iCPPMethod = (ICPPMethod)cPPNameCollector.getName(2).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType, 3);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPConstructor, 3);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPMethod, 3);
    }

    public void testBug44342() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("class A { void f(){} void f(int){} }; int main(){ A * a = new A(); a->f();} ");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)10);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        ICPPMethod iCPPMethod = (ICPPMethod)cPPNameCollector.getName(1).resolveBinding();
        ICPPMethod iCPPMethod2 = (ICPPMethod)cPPNameCollector.getName(2).resolveBinding();
        ICPPConstructor iCPPConstructor = iCPPClassType.getConstructors()[0];
        IVariable iVariable = (IVariable)cPPNameCollector.getName(6).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPMethod, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPMethod2, 1);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPConstructor, 1);
        this.assertInstances(cPPNameCollector, (IBinding)iVariable, 2);
    }

    public void testCDesignatedInitializers() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct Inner { int a,b,c; };");
        stringBuffer.append("struct A { int x; int y[]; struct Inner innerArray[]; int z []; };");
        stringBuffer.append("struct A myA = { .x = 4, .y[3] = 4, .y[4] = 3, .innerArray[0].a = 3, .innerArray[1].b = 5, .innerArray[2].c=6, .z = { 1,4,5} };");
        this.parse(stringBuffer.toString(), true, ParserLanguage.C);
    }

    public void testBug39551A() throws Exception {
        this.parse("extern float _Complex conjf (float _Complex);", true, ParserLanguage.C);
    }

    public void testBug39551B() throws Exception {
        this.parse("_Imaginary double id = 99.99 * 1i;", true, ParserLanguage.C);
    }

    public void testCBool() throws Exception {
        this.parse("_Bool x;", true, ParserLanguage.C);
    }

    public void testCBoolAsParameter() throws Exception {
        this.parse("void f( _Bool b ) {} _Bool g( _Bool b ) {} void main(){   _Bool b;     f(b);\tf( g( (_Bool) 1 )  );}", true, ParserLanguage.C);
    }

    public void testBug44510() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int initialize(); int initialize( char ){} int initialize(){ return 1; } void main(){ int i = initialize(); }");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)7);
        IFunction iFunction = (IFunction)cPPNameCollector.getName(0).resolveBinding();
        IFunction iFunction2 = (IFunction)cPPNameCollector.getName(1).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iFunction, 3);
        this.assertInstances(cPPNameCollector, (IBinding)iFunction2, 1);
    }

    public void testBug44925() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class MyClass { };");
        stringBuffer.append("class MyClass myObj1;");
        stringBuffer.append("enum MyEnum { Item1 };");
        stringBuffer.append("enum MyEnum myObj2;");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString());
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)7);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        IVariable iVariable = (IVariable)cPPNameCollector.getName(2).resolveBinding();
        IEnumeration iEnumeration = (IEnumeration)cPPNameCollector.getName(3).resolveBinding();
        IEnumerator iEnumerator = (IEnumerator)cPPNameCollector.getName(4).resolveBinding();
        IVariable iVariable2 = (IVariable)cPPNameCollector.getName(6).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iEnumeration, 2);
        CompleteParser2Tests.assertSame((Object)iVariable.getType(), (Object)iCPPClassType);
        CompleteParser2Tests.assertSame((Object)iVariable2.getType(), (Object)iEnumeration);
        CompleteParser2Tests.assertSame((Object)iEnumerator.getType(), (Object)iEnumeration);
    }

    public void testBug44838() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class A { int myX; A( int x ); };\n");
        stringBuffer.append("A::A( int x ) : myX( x ) { if( x == 5 ) myX++; }\n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString());
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)12);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        ICPPField iCPPField = (ICPPField)cPPNameCollector.getName(1).resolveBinding();
        ICPPConstructor iCPPConstructor = (ICPPConstructor)cPPNameCollector.getName(2).resolveBinding();
        IParameter iParameter = (IParameter)cPPNameCollector.getName(3).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPField, 3);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPConstructor, 3);
        this.assertInstances(cPPNameCollector, (IBinding)iParameter, 4);
    }

    public void testBug46165() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class A { int myX; A( int x ); };\n");
        stringBuffer.append("A::A( int x ) : myX( x ) { if( x == 5 ) myX++; }\n");
        this.parse(stringBuffer.toString());
    }

    public void testBug47624() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct s { }; \n");
        stringBuffer.append("void f ( int s ) { \n");
        stringBuffer.append("   struct s sInstance; \n");
        stringBuffer.append("}\n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString());
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)5);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        IParameter iParameter = (IParameter)cPPNameCollector.getName(2).resolveBinding();
        IVariable iVariable = (IVariable)cPPNameCollector.getName(4).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iParameter, 1);
        CompleteParser2Tests.assertSame((Object)iVariable.getType(), (Object)iCPPClassType);
    }

    public void testQualifiedLookup() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace N {");
        stringBuffer.append("   void f () {} \n");
        stringBuffer.append("   class A { }; \n");
        stringBuffer.append("}");
        stringBuffer.append("void main() { N::A * a = new N::A();  a->f(); } ");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString());
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)13);
        ICPPNamespace iCPPNamespace = (ICPPNamespace)cPPNameCollector.getName(0).resolveBinding();
        IFunction iFunction = (IFunction)cPPNameCollector.getName(1).resolveBinding();
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(2).resolveBinding();
        ICPPConstructor iCPPConstructor = iCPPClassType.getConstructors()[0];
        IProblemBinding iProblemBinding = (IProblemBinding)cPPNameCollector.getName(12).resolveBinding();
        CompleteParser2Tests.assertEquals((int)iProblemBinding.getID(), (int)1);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPNamespace, 3);
        this.assertInstances(cPPNameCollector, (IBinding)iFunction, 1);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType, 3);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPConstructor, 2);
    }

    public void testBug43110() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void x( int y, ... );\n");
        stringBuffer.append("void y( int x... );\n");
        stringBuffer.append("void z(...);");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString());
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)5);
        IFunction iFunction = (IFunction)cPPNameCollector.getName(0).resolveBinding();
        IFunction iFunction2 = (IFunction)cPPNameCollector.getName(2).resolveBinding();
        IFunction iFunction3 = (IFunction)cPPNameCollector.getName(4).resolveBinding();
        CompleteParser2Tests.assertNotNull((Object)iFunction);
        CompleteParser2Tests.assertNotNull((Object)iFunction2);
        CompleteParser2Tests.assertNotNull((Object)iFunction3);
    }

    public void testBug43110_XRef() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void foo( ... ) {}\n");
        stringBuffer.append("void main( ){ foo( 1 ); }\n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString());
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)3);
        IFunction iFunction = (IFunction)cPPNameCollector.getName(0).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iFunction, 2);
    }

    public void testErrorHandling_1() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("A anA; int x = c; class A {}; A * anotherA = &anA; int b;", false);
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)9);
        IProblemBinding iProblemBinding = (IProblemBinding)cPPNameCollector.getName(0).resolveBinding();
        IVariable iVariable = (IVariable)cPPNameCollector.getName(1).resolveBinding();
        CompleteParser2Tests.assertNotNull((Object)cPPNameCollector.getName(2).resolveBinding());
        IProblemBinding iProblemBinding2 = (IProblemBinding)cPPNameCollector.getName(3).resolveBinding();
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(4).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iVariable, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType, 2);
        CompleteParser2Tests.assertNotNull((Object)iProblemBinding);
        CompleteParser2Tests.assertNotNull((Object)iProblemBinding2);
        CompleteParser2Tests.assertSame((Object)iVariable.getType(), (Object)iProblemBinding);
    }

    public void testBug44340() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("class A{ int getX() {return x[1];} int x[10];};");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)4);
        ICPPField iCPPField = (ICPPField)cPPNameCollector.getName(2).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iCPPField, 2);
    }

    public void testBug47628() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("void h(char) { }\n");
        ((Writer)stringWriter).write("void h(unsigned char) { }\n");
        ((Writer)stringWriter).write("void h(signed char) { }  // not shown in outline, parsed as char\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug47636() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("void f( char [] ); \n");
        ((Writer)stringWriter).write("void f( char * ){} \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(((Object)stringWriter).toString());
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)4);
        IFunction iFunction = (IFunction)cPPNameCollector.getName(0).resolveBinding();
        IParameter iParameter = (IParameter)cPPNameCollector.getName(1).resolveBinding();
        IFunction iFunction2 = (IFunction)cPPNameCollector.getName(2).resolveBinding();
        IParameter iParameter2 = (IParameter)cPPNameCollector.getName(3).resolveBinding();
        CompleteParser2Tests.assertSame((Object)iFunction, (Object)iFunction2);
        CompleteParser2Tests.assertSame((Object)iParameter, (Object)iParameter2);
    }

    public void testBug45697() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write(" int f( bool ); \n");
        ((Writer)stringWriter).write(" int f( char ){ } ");
        IASTTranslationUnit iASTTranslationUnit = this.parse(((Object)stringWriter).toString());
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)4);
        IFunction iFunction = (IFunction)cPPNameCollector.getName(0).resolveBinding();
        IParameter iParameter = (IParameter)cPPNameCollector.getName(1).resolveBinding();
        IFunction iFunction2 = (IFunction)cPPNameCollector.getName(2).resolveBinding();
        IParameter iParameter2 = (IParameter)cPPNameCollector.getName(3).resolveBinding();
        CompleteParser2Tests.assertNotSame((Object)iFunction, (Object)iFunction2);
        CompleteParser2Tests.assertNotSame((Object)iParameter, (Object)iParameter2);
    }

    public void testBug54639() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("typedef enum _A { } A, *pA; ");
        IASTTranslationUnit iASTTranslationUnit = this.parse(((Object)stringWriter).toString());
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)3);
        IEnumeration iEnumeration = (IEnumeration)cPPNameCollector.getName(0).resolveBinding();
        ITypedef iTypedef = (ITypedef)cPPNameCollector.getName(1).resolveBinding();
        ITypedef iTypedef2 = (ITypedef)cPPNameCollector.getName(2).resolveBinding();
        CompleteParser2Tests.assertNotNull((Object)iEnumeration);
        CompleteParser2Tests.assertSame((Object)iTypedef.getType(), (Object)iEnumeration);
        CompleteParser2Tests.assertTrue((boolean)(iTypedef2.getType() instanceof IPointerType));
        CompleteParser2Tests.assertSame((Object)((IPointerType)iTypedef2.getType()).getType(), (Object)iEnumeration);
    }

    public void testBug55163() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("void foo() { \n");
        ((Writer)stringWriter).write("   int i, n; \n");
        ((Writer)stringWriter).write("   double di; \n");
        ((Writer)stringWriter).write("   for( i = n - 1, di = (double)( i + i ); i > 0; i-- ){ } \n");
        ((Writer)stringWriter).write("}\n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(((Object)stringWriter).toString());
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)11);
        IVariable iVariable = (IVariable)cPPNameCollector.getName(1).resolveBinding();
        IVariable iVariable2 = (IVariable)cPPNameCollector.getName(2).resolveBinding();
        IVariable iVariable3 = (IVariable)cPPNameCollector.getName(3).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iVariable, 6);
        this.assertInstances(cPPNameCollector, (IBinding)iVariable2, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iVariable3, 2);
    }

    public void testBug55673() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("struct Example { int i;  int ( * pfi ) ( int ); }; ");
        this.parse(((Object)stringWriter).toString());
        IASTTranslationUnit iASTTranslationUnit = this.parse(((Object)stringWriter).toString());
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)4);
        ICPPField iCPPField = (ICPPField)cPPNameCollector.getName(2).resolveBinding();
        CompleteParser2Tests.assertNotNull((Object)iCPPField);
        CompleteParser2Tests.assertTrue((boolean)(iCPPField.getType() instanceof IPointerType));
        CompleteParser2Tests.assertTrue((boolean)(((IPointerType)iCPPField.getType()).getType() instanceof IFunctionType));
    }

    public void testBug54531() throws Exception {
        this.parse("typedef enum _A {} A, *pA;");
    }

    public void testBug56516() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("typedef struct blah sb;");
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)2);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        ITypedef iTypedef = (ITypedef)cPPNameCollector.getName(1).resolveBinding();
        CompleteParser2Tests.assertSame((Object)iTypedef.getType(), (Object)iCPPClassType);
    }

    public void testBug53786() throws Exception {
        this.parse("struct Example {  struct Data * data; };");
    }

    public void testBug54029() throws Exception {
        this.parse("typedef int T; T i;");
    }

    public void testBug47625() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("struct s { int num; }; ");
        ((Writer)stringWriter).write("namespace ns{ ");
        ((Writer)stringWriter).write("   struct s { double num; };");
        ((Writer)stringWriter).write("   s inner = { 3.14 };");
        ((Writer)stringWriter).write("   ::s outer = { 42 };");
        ((Writer)stringWriter).write("}");
        IASTTranslationUnit iASTTranslationUnit = this.parse(((Object)stringWriter).toString());
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)10);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        ICPPClassType iCPPClassType2 = (ICPPClassType)cPPNameCollector.getName(3).resolveBinding();
        ICPPClassType iCPPClassType3 = (ICPPClassType)cPPNameCollector.getName(5).resolveBinding();
        ICPPClassType iCPPClassType4 = (ICPPClassType)cPPNameCollector.getName(8).resolveBinding();
        CompleteParser2Tests.assertSame((Object)iCPPClassType, (Object)iCPPClassType4);
        CompleteParser2Tests.assertSame((Object)iCPPClassType2, (Object)iCPPClassType3);
    }

    public void testBug57754() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("struct X {          ");
        ((Writer)stringWriter).write("   typedef int T;   ");
        ((Writer)stringWriter).write("   void f( T );     ");
        ((Writer)stringWriter).write("};                  ");
        ((Writer)stringWriter).write("void X::f( T ) { }  ");
        IASTTranslationUnit iASTTranslationUnit = this.parse(((Object)stringWriter).toString());
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)10);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        ITypedef iTypedef = (ITypedef)cPPNameCollector.getName(1).resolveBinding();
        ICPPMethod iCPPMethod = (ICPPMethod)cPPNameCollector.getName(2).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iTypedef, 3);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPMethod, 3);
    }

    public void testBug57800() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class G2 { int j; };");
        ((Writer)stringWriter).write("typedef G2 AltG2;");
        ((Writer)stringWriter).write("class AltG3 : AltG2 {  int x;};");
        IASTTranslationUnit iASTTranslationUnit = this.parse(((Object)stringWriter).toString());
        CPPNameCollector cPPNameCollector = new CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        CompleteParser2Tests.assertEquals((int)cPPNameCollector.size(), (int)7);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        ITypedef iTypedef = (ITypedef)cPPNameCollector.getName(3).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iTypedef, 2);
    }

    public void testBug46246() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("struct A {                 ");
        ((Writer)stringWriter).write("   struct B { int ab; } b; ");
        ((Writer)stringWriter).write("   int a;                  ");
        ((Writer)stringWriter).write("};                         ");
        ((Writer)stringWriter).write("struct A a1;               ");
        ((Writer)stringWriter).write("struct B b1;               ");
        IASTTranslationUnit iASTTranslationUnit = this.parse(((Object)stringWriter).toString(), true, ParserLanguage.C);
        CNameCollector cNameCollector = new CNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cNameCollector);
        CompleteParser2Tests.assertEquals((int)cNameCollector.size(), (int)9);
        ICompositeType iCompositeType = (ICompositeType)cNameCollector.getName(0).resolveBinding();
        ICompositeType iCompositeType2 = (ICompositeType)cNameCollector.getName(1).resolveBinding();
        this.assertInstances(cNameCollector, (IBinding)iCompositeType, 2);
        this.assertInstances(cNameCollector, (IBinding)iCompositeType2, 2);
    }

    public void testBug45235() throws Exception {
        this.parse("class A { friend class B; friend void f(); }; ");
    }

    public void testBug57791() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write(" void f() {                  ");
        ((Writer)stringWriter).write("    struct astruct astruct;  ");
        ((Writer)stringWriter).write("    astruct.foo++;           ");
        ((Writer)stringWriter).write(" }");
        this.parse(((Object)stringWriter).toString(), true, ParserLanguage.C);
    }

    public void testBug44249() throws Exception {
        this.parse("class SD_01 { public:\n\tvoid SD_01::f_SD_01();};");
    }

    public void testBug59149() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class A{ friend class B; friend class B; };");
        ((Writer)stringWriter).write("class B{ };");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug59302() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class A { class N{}; };         ");
        ((Writer)stringWriter).write("class B { friend class A::N; }; ");
        this.parse(((Object)stringWriter).toString());
    }

    public void testULong() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#ifndef ASMINCLUDE\n");
        ((Writer)stringWriter).write("typedef unsigned short         ushort;\n");
        ((Writer)stringWriter).write("typedef volatile unsigned long semaphore;\n");
        ((Writer)stringWriter).write("typedef unsigned long          ulong;\n");
        ((Writer)stringWriter).write("#ifndef _NO_LONGLONG\n");
        ((Writer)stringWriter).write("typedef long long              longlong;\n");
        ((Writer)stringWriter).write("typedef unsigned long long     ulonglong;\n");
        ((Writer)stringWriter).write("#endif  /* _NO_LONGLONG */\n");
        ((Writer)stringWriter).write("#endif  /*  ASMINCLUDE  */\n");
        ((Writer)stringWriter).write("typedef struct section_type_ {\n");
        ((Writer)stringWriter).write("ulong source;\n");
        ((Writer)stringWriter).write("ulong dest;\n");
        ((Writer)stringWriter).write("ulong bytes;\n");
        ((Writer)stringWriter).write("} section_type;\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug47926() throws Exception {
        this.parse("void f() {} class A {}; void main() { A * a = new A(); a->f();\t}", false);
    }

    public void testBug50984_ASTMethod_getOwnerClassSpecifier_ClassCastException() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template < typename _OutIter >                                 ");
        ((Writer)stringWriter).write("class num_put {                                                ");
        ((Writer)stringWriter).write("   typedef _OutIter iter_type;                                 ");
        ((Writer)stringWriter).write("   template< typename _ValueT >                                ");
        ((Writer)stringWriter).write("    iter_type _M_convert_float( iter_type );                   ");
        ((Writer)stringWriter).write("};                                                             ");
        ((Writer)stringWriter).write("template < typename _OutIter >                                 ");
        ((Writer)stringWriter).write("template < typename _ValueT  >                                 ");
        ((Writer)stringWriter).write("_OutIter num_put<_OutIter>::_M_convert_float( _OutIter ) { }   ");
        this.parse(((Object)stringWriter).toString());
    }

    public void testGloballyQualifiedUsingDeclaration() throws Exception {
        this.parse("int iii; namespace N { using ::iii; }");
    }

    public void test57513_new() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class A{ A(); A( int ); };   \n");
        ((Writer)stringWriter).write(" void f() {                  \n");
        ((Writer)stringWriter).write("    A * a1 = new A;          \n");
        ((Writer)stringWriter).write("    A * a2 = new(1)A();      \n");
        ((Writer)stringWriter).write("    A * a3 = new A( 1 );     \n");
        ((Writer)stringWriter).write("}                            \n");
        this.parse(((Object)stringWriter).toString());
    }

    public void test57513_NoConstructor() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class A{  };   \n");
        ((Writer)stringWriter).write(" void f() {                  \n");
        ((Writer)stringWriter).write("    A * a1 = new A;          \n");
        ((Writer)stringWriter).write("}                            \n");
        this.parse(((Object)stringWriter).toString());
    }

    public void test57513_ctorinit() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class A{ A(); A( A * ); };   \n");
        ((Writer)stringWriter).write("class B : public A { B(); }; \n");
        ((Writer)stringWriter).write("B::B():A( new A ){}          \n");
        this.parse(((Object)stringWriter).toString());
    }

    public void test575513_qualified() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("namespace Foo{                     ");
        ((Writer)stringWriter).write("   class Bar{ public : Bar(); };   ");
        ((Writer)stringWriter).write("}                                  ");
        ((Writer)stringWriter).write("void main(){                       ");
        ((Writer)stringWriter).write("  Foo::Bar * bar = new Foo::Bar(); ");
        ((Writer)stringWriter).write("}                                  ");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug60944() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("typedef int OurInt;\n");
        ((Writer)stringWriter).write("class A { int x; };\n");
        ((Writer)stringWriter).write("typedef A AnotherA;\n");
        ((Writer)stringWriter).write("typedef AnotherA SecondA;\n");
        ((Writer)stringWriter).write("typedef OurInt AnotherInt;\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testDestructorReference() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class ABC {\n");
        ((Writer)stringWriter).write(" public:\n");
        ((Writer)stringWriter).write(" ~ABC(){ }\n");
        ((Writer)stringWriter).write("};\n");
        ((Writer)stringWriter).write("int main() { ABC * abc = new ABC();\n");
        ((Writer)stringWriter).write("abc->~ABC();\n");
        ((Writer)stringWriter).write("}\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug39676_tough() throws Exception {
        this.parse("int widths[] = { [0 ... 9] = 1, [10 ... 99] = 2, [100] = 3 };", true, ParserLanguage.C, true);
    }

    public void testBug60939() throws Exception {
        int n = 0;
        while (n < 2) {
            StringWriter stringWriter = new StringWriter();
            ((Writer)stringWriter).write("namespace ABC { class DEF { }; }\n");
            if (n == 0) {
                ((Writer)stringWriter).write("using namespace ABC;\n");
            } else {
                ((Writer)stringWriter).write("using ABC::DEF;\n");
            }
            ((Writer)stringWriter).write("class GHI : public DEF { };");
            this.parse(((Object)stringWriter).toString());
            ++n;
        }
    }

    public void testBug64010() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write(" #define ONE\telse if (0) { } \n");
        ((Writer)stringWriter).write(" #define TEN\tONE ONE ONE ONE ONE ONE ONE ONE ONE ONE \n ");
        ((Writer)stringWriter).write(" #define HUN\tTEN TEN TEN TEN TEN TEN TEN TEN TEN TEN \n ");
        ((Writer)stringWriter).write(" #define THOU\tHUN HUN HUN HUN HUN HUN HUN HUN HUN HUN \n");
        ((Writer)stringWriter).write("void foo()                                                ");
        ((Writer)stringWriter).write("{                                                         ");
        ((Writer)stringWriter).write("   if (0) { }                                             ");
        ((Writer)stringWriter).write("   /* 5,000 else if's.  */                               ");
        ((Writer)stringWriter).write("   THOU THOU THOU THOU THOU ");
        ((Writer)stringWriter).write("}                                                         ");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug64271() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("typedef int DWORD;\n");
        ((Writer)stringWriter).write("typedef char BYTE;\n");
        ((Writer)stringWriter).write("#define MAKEFOURCC(ch0, ch1, ch2, ch3)                              \\\n");
        ((Writer)stringWriter).write("((DWORD)(BYTE)(ch0) | ((DWORD)(BYTE)(ch1) << 8) |       \\\n");
        ((Writer)stringWriter).write("((DWORD)(BYTE)(ch2) << 16) | ((DWORD)(BYTE)(ch3) << 24 ))\n");
        ((Writer)stringWriter).write("enum e {\n");
        ((Writer)stringWriter).write("blah1 = 5,\n");
        ((Writer)stringWriter).write("blah2 = MAKEFOURCC('a', 'b', 'c', 'd'),\n");
        ((Writer)stringWriter).write("blah3\n");
        ((Writer)stringWriter).write("};\n");
        ((Writer)stringWriter).write("e mye = blah;\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug47752() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class BBC\n");
        ((Writer)stringWriter).write("{\n");
        ((Writer)stringWriter).write("int x;\n");
        ((Writer)stringWriter).write("};\n");
        ((Writer)stringWriter).write("void func( BBC bar )\n");
        ((Writer)stringWriter).write("try\n");
        ((Writer)stringWriter).write("{\n");
        ((Writer)stringWriter).write("}\n");
        ((Writer)stringWriter).write("catch ( BBC error )\n");
        ((Writer)stringWriter).write("{\n");
        ((Writer)stringWriter).write("\t\t  //... error handling code ...\n");
        ((Writer)stringWriter).write("}\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug61972() throws Exception {
        this.parse("#define DEF1(A1) A1\n#define DEF2     DEF1(DEF2)\nDEF2;", false);
    }

    public void testBug65569() throws Exception {
        this.parse("class Sample;\nstruct Sample { /* ... */ };");
    }

    public void testBug64268() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#define BODY \\\n");
        ((Writer)stringWriter).write("for (;;) {\t \\\n");
        ((Writer)stringWriter).write("/* this multi-line comment messes \\\n");
        ((Writer)stringWriter).write("up the parser.  */ }\n");
        ((Writer)stringWriter).write("\tvoid abc() {\n");
        ((Writer)stringWriter).write("BODY\n");
        ((Writer)stringWriter).write("}\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug67622() throws Exception {
        this.parse("const char * x = __FILE__;");
    }

    public void testBug67680() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template < class T> class Base {};                  \n");
        ((Writer)stringWriter).write("class Derived : public Base, Base<int>, foo {};     \n");
        this.parse(((Object)stringWriter).toString(), false);
    }

    public void testTypeIDSignature() throws Exception {
        this.parse("int * v = (int*)0;");
    }

    public void testUnaryAmperCast() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("void f( char * );              \r\n ");
        ((Writer)stringWriter).write("void f( char   );              \n ");
        ((Writer)stringWriter).write("void main() {                  \n ");
        ((Writer)stringWriter).write("   char * t = new char [ 5 ];  \n ");
        ((Writer)stringWriter).write("   f( &t[1] );                 \n ");
        ((Writer)stringWriter).write("}                              \n ");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug68235() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write(" struct xTag { int x; };               ");
        ((Writer)stringWriter).write(" typedef xTag xType;                   ");
        ((Writer)stringWriter).write(" typedef struct yTag { int x; } yType; ");
        ((Writer)stringWriter).write(" class C1 { xType x; yType y; };       ");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug60407() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("struct ZZZ { int x, y, z; };\r\n");
        ((Writer)stringWriter).write("typedef struct ZZZ _FILE;\n");
        ((Writer)stringWriter).write("typedef _FILE FILE;\n");
        ((Writer)stringWriter).write("static void static_function(FILE * lcd){}\n");
        ((Writer)stringWriter).write("int\tmain(int argc, char **argv) {\n");
        ((Writer)stringWriter).write("FILE * file = 0;\n");
        ((Writer)stringWriter).write("static_function( file );\n");
        ((Writer)stringWriter).write("return 0;\n");
        ((Writer)stringWriter).write("}\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug68623() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class A {                         \n");
        ((Writer)stringWriter).write("   A();                           \n");
        ((Writer)stringWriter).write("   class sub{};                   \n");
        ((Writer)stringWriter).write("   sub * x;                       \n");
        ((Writer)stringWriter).write("};                                \n");
        ((Writer)stringWriter).write("A::A() : x( (sub *) 0 ) {}        \n");
        this.parse(((Object)stringWriter).toString());
        stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class A {                         \n");
        ((Writer)stringWriter).write("   A() : x (0) {}                 \n");
        ((Writer)stringWriter).write("   int x;                         \n");
        ((Writer)stringWriter).write("};                                \n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug69798() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("enum Flags { FLAG1, FLAG2 };                          \n");
        ((Writer)stringWriter).write("int f() { int a, b;  b = ( a ? FLAG1 : 0 ) | FLAG2; } \n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug69662() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class A { operator float * (); };  \n");
        ((Writer)stringWriter).write("A::operator float * () { }         \n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug68528() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("namespace N526026\n");
        ((Writer)stringWriter).write("{\n");
        ((Writer)stringWriter).write("template <typename T>\n");
        ((Writer)stringWriter).write("class T526026\n");
        ((Writer)stringWriter).write("{\n");
        ((Writer)stringWriter).write("typedef int diff;\n");
        ((Writer)stringWriter).write("};\n");
        ((Writer)stringWriter).write("\n");
        ((Writer)stringWriter).write("template<typename T>\n");
        ((Writer)stringWriter).write("inline T526026< T >\n");
        ((Writer)stringWriter).write("operator+(typename T526026<T>::diff d, const T526026<T> & x )\n");
        ((Writer)stringWriter).write("{ return T526026< T >(); }\n");
        ((Writer)stringWriter).write("}\n");
        this.parse(((Object)stringWriter).toString(), false);
    }

    public void testBug71094() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("using namespace DOESNOTEXIST;\n");
        ((Writer)stringWriter).write("class A { int x; };\n");
        this.parse(((Object)stringWriter).toString(), false);
    }

    public void testPredefinedSymbol_bug70928() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#define __cdecl __attribute__ ((__cdecl__))\n");
        ((Writer)stringWriter).write("typedef int size_t; \n int __cdecl foo(); \n");
        this.parse(((Object)stringWriter).toString(), true, ParserLanguage.CPP, true);
    }

    public void testPredefinedSymbol_bug70928_infinite_loop_test1() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#define __cdecl __attribute__ ((__cdecl__))\n");
        ((Writer)stringWriter).write("typedef int size_t; \n int __cdecl foo(); \n");
        this.parse(((Object)stringWriter).toString(), false, ParserLanguage.CPP, false);
        this.parse(((Object)stringWriter).toString(), false, ParserLanguage.C, false);
    }

    public void testPredefinedSymbol_bug70928_infinite_loop_test2() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("int x __attribute__ ((aligned (16))) = 0;\n");
        this.parse(((Object)stringWriter).toString(), false, ParserLanguage.CPP, false);
        this.parse(((Object)stringWriter).toString(), false, ParserLanguage.C, false);
    }

    public void testBug102376() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("int func1 (void) __attribute__((,id2,id (,,),,,));\n");
        ((Writer)stringWriter).write("int func2 (void) __attribute__((id,id (id)));\n");
        ((Writer)stringWriter).write("int func3 (void) __attribute__((id,id (3)));\n");
        ((Writer)stringWriter).write("int func4 (void) __attribute__((id,id (1+2)));\n");
        ((Writer)stringWriter).write("void (****f1)(void) __attribute__((noreturn));\n");
        ((Writer)stringWriter).write("void fatal1 () __attribute__ ((noreturn));\n");
        ((Writer)stringWriter).write("int square1 (int) __attribute__ ((pure));\n");
        ((Writer)stringWriter).write("extern int\n");
        ((Writer)stringWriter).write("my_printf1 (void *my_object, const char *my_format, ...)\n");
        ((Writer)stringWriter).write("__attribute__ ((format (printf, 2, 3)));\n");
        ((Writer)stringWriter).write("extern char *\n");
        ((Writer)stringWriter).write("my_dgettext1 (char *my_domain, const char *my_format)\n");
        ((Writer)stringWriter).write("__attribute__ ((format_arg (2)));\n");
        ((Writer)stringWriter).write("extern void *\n");
        ((Writer)stringWriter).write("my_memcpy1 (void *dest, const void *src, size_t len)\n");
        ((Writer)stringWriter).write("__attribute__((nonnull (1, 2)));\n");
        ((Writer)stringWriter).write("extern void *\n");
        ((Writer)stringWriter).write("my_memcpy2 (void *dest, const void *src, size_t len)\n");
        ((Writer)stringWriter).write("__attribute__((nonnull));\n");
        ((Writer)stringWriter).write("extern void foobar3 (void) __attribute__ ((section (\"bar\")));\n");
        ((Writer)stringWriter).write("int old_fn () __attribute__ ((deprecated));\n");
        ((Writer)stringWriter).write("void f5 () __attribute__ ((weak, alias (\"__f\")));\n");
        ((Writer)stringWriter).write("void __attribute__ ((visibility (\"protected\")))\n");
        ((Writer)stringWriter).write("f6 () { /* Do something. */; }\n");
        ((Writer)stringWriter).write("int i2 __attribute__ ((visibility (\"hidden\")));\n");
        ((Writer)stringWriter).write("void f7 () __attribute__ ((interrupt (\"IRQ\")));\n");
        ((Writer)stringWriter).write("void *alt_stack9;\n");
        ((Writer)stringWriter).write("void f8 () __attribute__ ((interrupt_handler,\n");
        ((Writer)stringWriter).write("sp_switch (\"alt_stack\")));\n");
        ((Writer)stringWriter).write("int x1 __attribute__ ((aligned (16))) = 0;\n");
        ((Writer)stringWriter).write("struct foo11 { int x[2] __attribute__ ((aligned (8))); };\n");
        ((Writer)stringWriter).write("short array12[3] __attribute__ ((aligned));\n");
        ((Writer)stringWriter).write("extern int old_var14 __attribute__ ((deprecated));\n");
        ((Writer)stringWriter).write("struct foo13\n");
        ((Writer)stringWriter).write("{\n");
        ((Writer)stringWriter).write("char a15;\n");
        ((Writer)stringWriter).write("int x16[2] __attribute__ ((packed));\n");
        ((Writer)stringWriter).write("};\n");
        ((Writer)stringWriter).write("struct duart15 a16 __attribute__ ((section (\"DUART_A\"))) = { 0 };\n");
        ((Writer)stringWriter).write("struct duart15 b17 __attribute__ ((section (\"DUART_B\"))) = { 0 };\n");
        ((Writer)stringWriter).write("char stack18[10000] __attribute__ ((section (\"STACK\"))) = { 0 };\n");
        ((Writer)stringWriter).write("int init_data19 __attribute__ ((section (\"INITDATA\"))) = 0;\n");
        ((Writer)stringWriter).write("int foo20 __attribute__((section (\"shared\"), shared)) = 0;\n");
        ((Writer)stringWriter).write("int foo21 __attribute__ ((vector_size (16)));\n");
        ((Writer)stringWriter).write("struct S22 { int a23; };\n");
        ((Writer)stringWriter).write("struct S24  __attribute__ ((vector_size (16))) foo;\n");
        ((Writer)stringWriter).write("struct S25 { short f27[3]; } __attribute__ ((aligned (8)));\n");
        ((Writer)stringWriter).write("typedef int more_aligned_int __attribute__ ((aligned (8)));\n");
        ((Writer)stringWriter).write("struct S26 { short f28[3]; } __attribute__ ((aligned));\n");
        ((Writer)stringWriter).write("\n");
        ((Writer)stringWriter).write("struct my_unpacked_struct29\n");
        ((Writer)stringWriter).write("{\n");
        ((Writer)stringWriter).write("char c;\n");
        ((Writer)stringWriter).write("int i;\n");
        ((Writer)stringWriter).write("};\n");
        ((Writer)stringWriter).write("          \n");
        ((Writer)stringWriter).write("struct my_packed_struct __attribute__ ((__packed__))\n");
        ((Writer)stringWriter).write("{\n");
        ((Writer)stringWriter).write("char c;\n");
        ((Writer)stringWriter).write("int  i;\n");
        ((Writer)stringWriter).write("struct my_unpacked_struct29 s;\n");
        ((Writer)stringWriter).write("};\n");
        ((Writer)stringWriter).write("\n");
        ((Writer)stringWriter).write("typedef union\n");
        ((Writer)stringWriter).write("{\n");
        ((Writer)stringWriter).write("int *__ip;\n");
        ((Writer)stringWriter).write("union wait *__up;\n");
        ((Writer)stringWriter).write("} wait_status_ptr_t __attribute__ ((__transparent_union__));\n");
        ((Writer)stringWriter).write("\n");
        ((Writer)stringWriter).write("typedef int T1 __attribute__ ((deprecated));\n");
        ((Writer)stringWriter).write("typedef short __attribute__((__may_alias__)) short_a;\n");
        ((Writer)stringWriter).write("extern const unsigned short int ** __ctype_b_loc (void) __attribute__ ((__const));");
        this.parse(((Object)stringWriter).toString(), true, ParserLanguage.C, true);
        this.parse(((Object)stringWriter).toString(), true, ParserLanguage.CPP, true);
    }

    public void testBug73652() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("#define DoSuperMethodA IDoSuperMethodA\n");
        stringWriter.write("#define IDoSuperMethodA(a,b,c) IIntuition->IDoSuperMethodA(a,b,c)\n");
        stringWriter.write("void hang(void)\n");
        stringWriter.write("{\n");
        stringWriter.write("DoSuperMethodA(0,0,0);\n");
        stringWriter.write("}\n");
        this.parse(stringWriter.toString(), false);
    }

    public void testBug73428() throws Exception {
        this.parse("namespace {  }");
        this.parse("namespace {  };");
        this.parse("namespace {  int abc; };");
        this.parse("namespace {  int abc; }");
    }

    public void testBug73615() throws Exception {
        int n = 0;
        while (n < 2) {
            StringWriter stringWriter = new StringWriter();
            if (n == 0) {
                stringWriter.write("class B;\n");
            }
            stringWriter.write("class A { A( B * ); };\n");
            if (n == 0) {
                this.parse(stringWriter.toString());
            } else {
                this.parse(stringWriter.toString(), false);
            }
            ++n;
        }
    }

    public void testBug74180() throws Exception {
        this.parse("enum DHCPFOBoolean { false, true } additionalHB, more_payload; \n", true, ParserLanguage.C);
    }

    public void testBug72691() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("typedef int * PINT; \n");
        stringWriter.write("typedef int * PINT; \n");
        stringWriter.write("PINT pint;          \n");
        this.parse(stringWriter.toString());
    }

    public void testBug72691_2() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("typedef int * PINT;    \n");
        stringWriter.write("namespace N {          \n");
        stringWriter.write("   typedef int * PINT; \n");
        stringWriter.write("}                      \n");
        stringWriter.write("using namespace N;     \n");
        stringWriter.write("PINT pint;             \n");
        this.parse(stringWriter.toString());
    }

    public void testBug74328() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("int\n");
        ((Writer)stringWriter).write("main(int argc, char **argv) {\n");
        ((Writer)stringWriter).write("\tchar *sign;\n");
        ((Writer)stringWriter).write("sign = \"\"; // IProblem generated here, syntax error\n");
        ((Writer)stringWriter).write("return argc;\n");
        ((Writer)stringWriter).write("}\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug71733() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("void foo( int );\n");
        ((Writer)stringWriter).write("#define BLAH() \\\n");
        ((Writer)stringWriter).write("  foo ( /*  slash / is misinterpreted as end of comment */ \\\n");
        ((Writer)stringWriter).write("    4 );\n");
        ((Writer)stringWriter).write("int f() { BLAH() }\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug69526() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("unsigned inkernel;\n");
        ((Writer)stringWriter).write("#define lock_kernel() (inkernel |= 0x01)");
        ((Writer)stringWriter).write("int main(int argc, char **argv) {");
        ((Writer)stringWriter).write("lock_kernel();");
        ((Writer)stringWriter).write("}");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug69454() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#define CATCH_ALL_EXCEPTIONS()                         \\\n");
        ((Writer)stringWriter).write("   catch( Exception &ex ) { handleException( ex ); }   \\\n");
        ((Writer)stringWriter).write("   catch( ... )           { handleException();    }      \n");
        ((Writer)stringWriter).write("class Exception;                                         \n");
        ((Writer)stringWriter).write("void handleException( Exception & ex ) {}                \n");
        ((Writer)stringWriter).write("void handleException() {}                                \n");
        ((Writer)stringWriter).write("void f() {                                               \n");
        ((Writer)stringWriter).write("   try { int i; }                                        \n");
        ((Writer)stringWriter).write("   CATCH_ALL_EXCEPTIONS();                               \n");
        ((Writer)stringWriter).write("}                                                        \n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug72692A() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("extern double pow(double, double);\n");
        ((Writer)stringWriter).write("extern double pow2(double, double){}\n");
        ((Writer)stringWriter).write("namespace DS {\n");
        ((Writer)stringWriter).write("using ::pow;\n");
        ((Writer)stringWriter).write("using ::pow2;\n");
        ((Writer)stringWriter).write("}\n");
        ((Writer)stringWriter).write("using DS::pow;\n");
        ((Writer)stringWriter).write("using DS::pow2;\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug72692B() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("extern double pow(double, double);\n");
        ((Writer)stringWriter).write("namespace DS {\n");
        ((Writer)stringWriter).write("using ::pow;\n");
        ((Writer)stringWriter).write("inline float pow(float __x, float __y)\n");
        ((Writer)stringWriter).write("{ return ::pow(static_cast<double>(__x), static_cast<double>(__y)); }\n");
        ((Writer)stringWriter).write("}\n");
        ((Writer)stringWriter).write("using namespace DS;\n");
        ((Writer)stringWriter).write("float foo() { double d1 = 3.0, d2 = 4.0; return pow(d1, d2); }");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug72692C() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("extern double pow(double, double){}\n");
        ((Writer)stringWriter).write("namespace DS {\n");
        ((Writer)stringWriter).write("using ::pow;\n");
        ((Writer)stringWriter).write("}\n");
        ((Writer)stringWriter).write("using DS::pow;\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug74575A() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("double pow(double, double);\n");
        ((Writer)stringWriter).write("float pow(float __x, float __y)\n");
        ((Writer)stringWriter).write("{ return 0; }\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug75338() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class Thrown { };\n");
        ((Writer)stringWriter).write("void foo() throw( Thrown );");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug74847() throws Exception {
        String string = "class A : public FOO {};";
        this.parse(string, false);
    }

    public void testBug76696() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write(" void f(){       \n");
        ((Writer)stringWriter).write("    if( A a) {   \n");
        ((Writer)stringWriter).write("    } else {     \n");
        ((Writer)stringWriter).write("    }\t           \n");
        ((Writer)stringWriter).write(" }               \n");
        this.parse(((Object)stringWriter).toString(), false);
    }

    public void testBug74069() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("int f() {                \n");
        ((Writer)stringWriter).write("   int a, b, c;          \n");
        ((Writer)stringWriter).write("   if( a < b )           \n");
        ((Writer)stringWriter).write("      if( b < c )        \n");
        ((Writer)stringWriter).write("         return b;       \n");
        ((Writer)stringWriter).write("      else if ( a < c )  \n");
        ((Writer)stringWriter).write("         return c;       \n");
        ((Writer)stringWriter).write("      else               \n");
        ((Writer)stringWriter).write("         return a;       \n");
        ((Writer)stringWriter).write("   else if( a < c )      \n");
        ((Writer)stringWriter).write("      return a;          \n");
        ((Writer)stringWriter).write("   else if( b < c )      \n");
        ((Writer)stringWriter).write("      return c;          \n");
        ((Writer)stringWriter).write("   else                  \n");
        ((Writer)stringWriter).write("      return b;          \n");
        ((Writer)stringWriter).write("}                        \n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug77805() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#if X // Do something only if X is true\n");
        ((Writer)stringWriter).write("/* some statements */\n");
        ((Writer)stringWriter).write("#endif\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug77821() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("typedef struct { /* ... */ }TYPE;\n");
        ((Writer)stringWriter).write("void ptrArith(const TYPE* pType) {\n");
        ((Writer)stringWriter).write("TYPE *temp = 0;\n");
        ((Writer)stringWriter).write("temp = (TYPE*)(pType + 1); /* Parser error is here */\n}\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug77009() throws Exception {
        this.parse("int foo(volatile int &);\n");
    }

    public void testBug77281() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("void fun2(float a, float b) {}\n");
        ((Writer)stringWriter).write("int main() { fun2(0.24f, 0.25f); }\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug77921() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("void f()\n{\n");
        ((Writer)stringWriter).write("static float v0[] = { -1.0f, -1.0f,  1.0f };\n}\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug71317A() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("void f();\n");
        ((Writer)stringWriter).write("namespace NS {\n");
        ((Writer)stringWriter).write("using ::f;\n");
        ((Writer)stringWriter).write("using ::f;\n}");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug71317B() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("void f();\n");
        ((Writer)stringWriter).write("namespace NS {\n");
        ((Writer)stringWriter).write("void f();\n");
        ((Writer)stringWriter).write("using ::f;\n}");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug77097() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#define SOME_MACRO() { \\\r\n");
        ((Writer)stringWriter).write("printf(\"Hello World\"); \\\r\n");
        ((Writer)stringWriter).write("printf(\"Good morning\"); \\\r\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug77276() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#if (!defined(OS_LIBMODE_R) && !defined(OS_LIBMODE_RP) && \\\r\n");
        ((Writer)stringWriter).write("!defined(OS_LIBMODE_T))\r\n");
        ((Writer)stringWriter).write("#define OS_LIBMODE_DP\r\n");
        ((Writer)stringWriter).write("#endif\r\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug78165() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("struct Node {\n");
        ((Writer)stringWriter).write("struct Node* Next; // OK: Refers to Node at global scope\n");
        ((Writer)stringWriter).write("struct Data* Data; // OK: Declares type Data at global scope and member Data\n");
        ((Writer)stringWriter).write("};\n");
        ((Writer)stringWriter).write("struct Data {\n");
        ((Writer)stringWriter).write("struct Node* Node; // OK: Refers to Node at global scope\n");
        ((Writer)stringWriter).write("friend struct Glob; // OK: Refers to (as yet) undeclared Glob at global scope.\n");
        ((Writer)stringWriter).write("};\n");
        ((Writer)stringWriter).write("struct Base {\n");
        ((Writer)stringWriter).write("struct Data; // OK: Declares nested Data\n");
        ((Writer)stringWriter).write("struct ::Data* thatData; // OK: Refers to ::Data\n");
        ((Writer)stringWriter).write("struct Base::Data* thisData; // OK: Refers to nested Data\n");
        ((Writer)stringWriter).write("friend class ::Data; // OK: global Data is a friend\n");
        ((Writer)stringWriter).write("friend class Data; // OK: nested Data is a friend\n");
        ((Writer)stringWriter).write("struct Data { /* ... */ }; // Defines nested Data\n");
        ((Writer)stringWriter).write("struct Data; // OK: Redeclares nested Data\n");
        ((Writer)stringWriter).write("};\n");
        ((Writer)stringWriter).write("struct Data; // OK: Redeclares Data at global scope\n");
        ((Writer)stringWriter).write("struct Base::Data* pBase; // OK: refers to nested Data\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug103560() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#define A( a, b ) a ## b               \n");
        ((Writer)stringWriter).write("#define FOOBAR 1                       \n");
        ((Writer)stringWriter).write("int i = A( FOO, BAR );                 \n");
        this.parse(((Object)stringWriter).toString());
    }

    private static class CPPNameCollector
    extends CPPASTVisitor {
        public List nameList;

        private CPPNameCollector() {
            this.shouldVisitNames = true;
            this.nameList = new ArrayList();
        }

        public int visit(IASTName iASTName) {
            this.nameList.add(iASTName);
            return 3;
        }

        public IASTName getName(int n) {
            if (n < 0 || n >= this.nameList.size()) {
                return null;
            }
            return (IASTName)this.nameList.get(n);
        }

        public int size() {
            return this.nameList.size();
        }
    }

    protected static class CNameCollector
    extends CASTVisitor {
        public List nameList;

        protected CNameCollector() {
            this.shouldVisitNames = true;
            this.nameList = new ArrayList();
        }

        public int visit(IASTName iASTName) {
            this.nameList.add(iASTName);
            return 3;
        }

        public IASTName getName(int n) {
            if (n < 0 || n >= this.nameList.size()) {
                return null;
            }
            return (IASTName)this.nameList.get(n);
        }

        public int size() {
            return this.nameList.size();
        }
    }
}

