/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests.ast2;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import junit.framework.TestCase;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.testplugin.CProjectHelper;
import org.eclipse.cdt.core.testplugin.FileManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class DOMFileBasePluginTest
extends TestCase {
    static NullProgressMonitor monitor;
    static IWorkspace workspace;
    static IProject project;
    static FileManager fileManager;
    static int numProjects;
    static Class className;
    static ICProject cPrj;

    static {
        numProjects = 0;
    }

    private void initialize(Class clazz) {
        if (CCorePlugin.getDefault() != null && CCorePlugin.getDefault().getCoreModel() != null) {
            monitor = new NullProgressMonitor();
            workspace = ResourcesPlugin.getWorkspace();
            try {
                cPrj = CProjectHelper.createCCProject("ParserTestProject", "bin");
                project = cPrj.getProject();
                if (className == null || !className.equals(clazz)) {
                    className = clazz;
                    ++numProjects;
                }
            }
            catch (CoreException coreException) {}
            if (project == null) {
                throw new NullPointerException("Unable to create project");
            }
            fileManager = new FileManager();
        }
    }

    public DOMFileBasePluginTest(String string, Class clazz) {
        super(string);
        this.initialize(clazz);
    }

    public void cleanupProject() throws Exception {
        --numProjects;
        try {
            if (numProjects == 0) {
                project.delete(true, false, (IProgressMonitor)monitor);
                project = null;
            }
        }
        catch (Throwable throwable) {}
    }

    protected void tearDown() throws Exception {
        if (project == null || !project.exists()) {
            return;
        }
        IResource[] iResourceArray = project.members();
        int n = 0;
        while (n < iResourceArray.length) {
            if (!iResourceArray[n].getName().equals(".project") && !iResourceArray[n].getName().equals(".cdtproject")) {
                try {
                    iResourceArray[n].delete(false, (IProgressMonitor)monitor);
                }
                catch (Throwable throwable) {}
            }
            ++n;
        }
    }

    protected IFolder importFolder(String string) throws Exception {
        IFolder iFolder = project.getProject().getFolder(string);
        if (!iFolder.exists()) {
            iFolder.create(false, false, (IProgressMonitor)monitor);
        }
        return iFolder;
    }

    public IFile importFile(String string, String string2) throws Exception {
        IFile iFile = project.getProject().getFile(string);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes());
        if (iFile.exists()) {
            iFile.setContents((InputStream)byteArrayInputStream, false, false, (IProgressMonitor)monitor);
        } else {
            iFile.create((InputStream)byteArrayInputStream, false, (IProgressMonitor)monitor);
        }
        fileManager.addFile(iFile);
        return iFile;
    }
}

