/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests.ast2;

import java.util.Collections;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.CDOM;
import org.eclipse.cdt.core.dom.IParserConfiguration;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIncludeStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.parser.ExtendedScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.tests.ast2.AST2FileBasePluginTest;
import org.eclipse.cdt.internal.core.dom.SavedCodeReaderFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.content.IContentType;

public class DOMLocationInclusionTests
extends AST2FileBasePluginTest {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    static /* synthetic */ Class class$0;

    public void testBug97967() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#ifndef _INCLUDE_H_\n");
        stringBuffer.append("#define _INCLUDE_H_\n");
        stringBuffer.append("typedef void (*vfp)();\n");
        stringBuffer.append("typedef int (*ifp)();\n");
        stringBuffer.append("struct Include {\n");
        stringBuffer.append("int i;\n");
        stringBuffer.append("};\n");
        stringBuffer.append("#endif /*_INCLUDE_H_*/\n");
        String[] stringArray = new String[]{this.importFile("macro.h", "#define JEDEN 1\n#define DVA 2\n#define TRI 3\n").getLocation().toOSString()};
        String[] stringArray2 = new String[]{this.importFile("include.h", stringBuffer.toString()).getLocation().toOSString()};
        ExtendedScannerInfo extendedScannerInfo = new ExtendedScannerInfo(Collections.EMPTY_MAP, EMPTY_STRING_ARRAY, stringArray, stringArray2);
        String string = "int main() { return BEAST * sizeof( Include ); } ";
        ParserLanguage parserLanguage = ParserLanguage.C;
        while (parserLanguage != null) {
            String string2 = parserLanguage == ParserLanguage.CPP ? "main.cc" : "main.c";
            IFile iFile = this.importFile(string2, string);
            IASTTranslationUnit iASTTranslationUnit = this.parse(iFile, (IScannerInfo)extendedScannerInfo);
            IASTFunctionDefinition iASTFunctionDefinition = (IASTFunctionDefinition)iASTTranslationUnit.getDeclarations()[3];
            IASTFileLocation iASTFileLocation = iASTFunctionDefinition.getFileLocation();
            DOMLocationInclusionTests.assertEquals((int)iASTFileLocation.getNodeOffset(), (int)string.indexOf("int main() { return BEAST * sizeof( Include ); }"));
            DOMLocationInclusionTests.assertEquals((int)iASTFileLocation.getNodeLength(), (int)"int main() { return BEAST * sizeof( Include ); }".length());
            Object object = parserLanguage = parserLanguage == ParserLanguage.C ? ParserLanguage.CPP : null;
        }
    }

    public void testBug101875() throws Exception {
        int n = 0;
        while (n < 4) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("#ifndef _BLAH_H_\n");
            stringBuffer.append("#endif");
            if (n > 1) {
                stringBuffer.append(" /* _BLAH_H_ */");
            }
            if (n % 2 == 1) {
                stringBuffer.append("\n");
            }
            this.importFile("blah.h", stringBuffer.toString());
            stringBuffer = new StringBuffer();
            stringBuffer.append("#include \"blah.h\"\n");
            stringBuffer.append("/**\n");
            stringBuffer.append(" * A type used by test functions.\n");
            stringBuffer.append("*/\n");
            stringBuffer.append("int SomeStructure;\n");
            String string = stringBuffer.toString();
            ParserLanguage parserLanguage = ParserLanguage.C;
            while (parserLanguage != null) {
                String string2 = parserLanguage == ParserLanguage.CPP ? "blah.cc" : "blah.c";
                IFile iFile = this.importFile(string2, string);
                IASTTranslationUnit iASTTranslationUnit = this.parse(iFile);
                IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[0];
                this.assertSoleFileLocation((IASTNode)iASTSimpleDeclaration.getDeclarators()[0], string2, string.indexOf("SomeStructure"), "SomeStructure".length());
                Object object = parserLanguage = parserLanguage == ParserLanguage.C ? ParserLanguage.CPP : null;
            }
            ++n;
        }
    }

    public DOMLocationInclusionTests(String string) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.parser.tests.ast2.DOMLocationInclusionTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(string, clazz);
    }

    protected IASTTranslationUnit parse(IFile iFile) throws Exception {
        SavedCodeReaderFactory.getInstance().getCodeReaderCache().flush();
        return CDOM.getInstance().getTranslationUnit(iFile);
    }

    protected IASTTranslationUnit parse(IFile iFile, IScannerInfo iScannerInfo) throws Exception {
        SavedCodeReaderFactory.getInstance().getCodeReaderCache().flush();
        return CDOM.getInstance().getTranslationUnit(iFile, CDOM.getInstance().getCodeReaderFactory(0), (IParserConfiguration)new ParserConfiguration(iScannerInfo, iFile));
    }

    private void assertSoleFileLocation(IASTNode iASTNode, String string, int n, int n2) {
        IASTNodeLocation[] iASTNodeLocationArray = iASTNode.getNodeLocations();
        DOMLocationInclusionTests.assertEquals((int)iASTNodeLocationArray.length, (int)1);
        IASTFileLocation iASTFileLocation = (IASTFileLocation)iASTNodeLocationArray[0];
        DOMLocationInclusionTests.assertTrue((boolean)iASTFileLocation.getFileName().endsWith(string));
        DOMLocationInclusionTests.assertEquals((int)n, (int)iASTFileLocation.getNodeOffset());
        DOMLocationInclusionTests.assertEquals((int)n2, (int)iASTFileLocation.getNodeLength());
    }

    public void testSimpleInclusion() throws Exception {
        String string = "int FOO;";
        String string2 = "int bar;\n#include \"foo.h\"\n";
        this.importFile("foo.h", string);
        ParserLanguage parserLanguage = ParserLanguage.C;
        while (parserLanguage != null) {
            String string3 = parserLanguage == ParserLanguage.CPP ? "code.cc" : "code.c";
            IFile iFile = this.importFile(string3, string2);
            IASTTranslationUnit iASTTranslationUnit = this.parse(iFile);
            IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
            DOMLocationInclusionTests.assertEquals((int)iASTDeclarationArray.length, (int)2);
            IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTDeclarationArray[0];
            IASTSimpleDeclaration iASTSimpleDeclaration2 = (IASTSimpleDeclaration)iASTDeclarationArray[1];
            this.assertSoleFileLocation((IASTNode)iASTSimpleDeclaration, string3, string2.indexOf("int"), string2.indexOf(";") + 1);
            this.assertSoleFileLocation((IASTNode)iASTSimpleDeclaration2, "foo.h", string.indexOf("int"), string.indexOf(";") + 1);
            IASTPreprocessorIncludeStatement[] iASTPreprocessorIncludeStatementArray = iASTTranslationUnit.getIncludeDirectives();
            DOMLocationInclusionTests.assertNotNull((Object)iASTPreprocessorIncludeStatementArray);
            DOMLocationInclusionTests.assertEquals((int)iASTPreprocessorIncludeStatementArray.length, (int)1);
            this.assertSoleFileLocation((IASTNode)iASTPreprocessorIncludeStatementArray[0], string3, string2.indexOf("#inc"), string2.indexOf(".h\"\n") + ".h\"".length() - string2.indexOf("#inc"));
            Object object = parserLanguage = parserLanguage == ParserLanguage.C ? ParserLanguage.CPP : null;
        }
    }

    public void testSimpleInclusion2() throws Exception {
        String string = "int FOO;";
        String string2 = "int bar;\n#include \"foo.h\"\nfloat byob;\n";
        this.importFile("foo.h", string);
        ParserLanguage parserLanguage = ParserLanguage.C;
        while (parserLanguage != null) {
            String string3 = parserLanguage == ParserLanguage.CPP ? "code.cc" : "code.c";
            IFile iFile = this.importFile(string3, string2);
            IASTTranslationUnit iASTTranslationUnit = this.parse(iFile);
            IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
            DOMLocationInclusionTests.assertEquals((int)iASTDeclarationArray.length, (int)3);
            IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTDeclarationArray[0];
            IASTSimpleDeclaration iASTSimpleDeclaration2 = (IASTSimpleDeclaration)iASTDeclarationArray[1];
            IASTSimpleDeclaration iASTSimpleDeclaration3 = (IASTSimpleDeclaration)iASTDeclarationArray[2];
            this.assertSoleFileLocation((IASTNode)iASTSimpleDeclaration, string3, string2.indexOf("int"), string2.indexOf("r;") + 2 - string2.indexOf("int"));
            this.assertSoleFileLocation((IASTNode)iASTSimpleDeclaration2, "foo.h", string.indexOf("int"), string.indexOf(";") + 1 - string.indexOf("int"));
            this.assertSoleFileLocation((IASTNode)iASTSimpleDeclaration3, string3, string2.indexOf("float"), string2.indexOf("b;") + 2 - string2.indexOf("float"));
            IASTPreprocessorIncludeStatement[] iASTPreprocessorIncludeStatementArray = iASTTranslationUnit.getIncludeDirectives();
            DOMLocationInclusionTests.assertNotNull((Object)iASTPreprocessorIncludeStatementArray);
            DOMLocationInclusionTests.assertEquals((int)iASTPreprocessorIncludeStatementArray.length, (int)1);
            this.assertSoleFileLocation((IASTNode)iASTPreprocessorIncludeStatementArray[0], string3, string2.indexOf("#inc"), string2.indexOf(".h\"\n") + ".h\"".length() - string2.indexOf("#inc"));
            Object object = parserLanguage = parserLanguage == ParserLanguage.C ? ParserLanguage.CPP : null;
        }
    }

    public void testMacrosInIncludeFile() throws Exception {
        String string = "#define X 4\n\n#include \"blarg.h\"\n\n#define POST_INCLUDE\n\n";
        String string2 = "#ifndef _BLARG_H_\r\n#define _BLARG_H_\r\n// macro\r\n#define PRINT(s,m)  printf(s,m)\r\n#endif //_BLARG_H_\r\n";
        this.importFile("blarg.h", string2);
        ParserLanguage parserLanguage = ParserLanguage.C;
        while (parserLanguage != null) {
            String string3 = parserLanguage == ParserLanguage.CPP ? "blah.cc" : "blah.c";
            IFile iFile = this.importFile(string3, string);
            IASTTranslationUnit iASTTranslationUnit = this.parse(iFile);
            DOMLocationInclusionTests.assertEquals((int)iASTTranslationUnit.getDeclarations().length, (int)0);
            IASTPreprocessorMacroDefinition[] iASTPreprocessorMacroDefinitionArray = iASTTranslationUnit.getMacroDefinitions();
            DOMLocationInclusionTests.assertNotNull((Object)iASTPreprocessorMacroDefinitionArray);
            DOMLocationInclusionTests.assertEquals((int)iASTPreprocessorMacroDefinitionArray.length, (int)4);
            this.assertSoleFileLocation((IASTNode)iASTPreprocessorMacroDefinitionArray[0], string3, string.indexOf("#define"), string.indexOf("4") + 1 - string.indexOf("#define"));
            this.assertSoleFileLocation((IASTNode)iASTPreprocessorMacroDefinitionArray[0].getName(), string3, string.indexOf("X"), 1);
            this.assertSoleFileLocation((IASTNode)iASTPreprocessorMacroDefinitionArray[1], "blarg.h", string2.indexOf("#define _BLARG_H_"), "#define _BLARG_H_\r".length());
            this.assertSoleFileLocation((IASTNode)iASTPreprocessorMacroDefinitionArray[1].getName(), "blarg.h", string2.indexOf("e _BLARG_H_") + 2, "_BLARG_H_".length());
            this.assertSoleFileLocation((IASTNode)iASTPreprocessorMacroDefinitionArray[2], "blarg.h", string2.indexOf("#define PRINT(s,m)  printf(s,m)\r"), "#define PRINT(s,m)  printf(s,m)".length());
            this.assertSoleFileLocation((IASTNode)iASTPreprocessorMacroDefinitionArray[2].getName(), "blarg.h", string2.indexOf("PRINT"), "PRINT".length());
            this.assertSoleFileLocation((IASTNode)iASTPreprocessorMacroDefinitionArray[3], string3, string.indexOf("#define POST_INCLUDE"), "#define POST_INCLUDE".length());
            this.assertSoleFileLocation((IASTNode)iASTPreprocessorMacroDefinitionArray[3].getName(), string3, string.indexOf("POST_INCLUDE"), "POST_INCLUDE".length());
            Object object = parserLanguage = parserLanguage == ParserLanguage.C ? ParserLanguage.CPP : null;
        }
    }

    public void testBug84451() throws Exception {
        String string = "int x;\n";
        String string2 = "int y;\n";
        String string3 = "#include \"header1.h\"\n#include \"header2.h\"\nint z;\n";
        this.importFile("header1.h", string);
        this.importFile("header2.h", string2);
        ParserLanguage parserLanguage = ParserLanguage.C;
        while (parserLanguage != null) {
            String string4 = parserLanguage == ParserLanguage.CPP ? "source.cc" : "source.c";
            IFile iFile = this.importFile(string4, string3);
            IASTTranslationUnit iASTTranslationUnit = this.parse(iFile);
            IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
            IASTPreprocessorIncludeStatement[] iASTPreprocessorIncludeStatementArray = iASTTranslationUnit.getIncludeDirectives();
            this.assertSoleFileLocation((IASTNode)iASTPreprocessorIncludeStatementArray[0], string4, string3.indexOf("#include \"header1.h\""), "#include \"header1.h\"".length());
            this.assertSoleFileLocation((IASTNode)iASTDeclarationArray[0], "header1.h", 0, "int x;".length());
            this.assertSoleFileLocation((IASTNode)iASTDeclarationArray[1], "header2.h", 0, "int y;".length());
            this.assertSoleFileLocation((IASTNode)iASTPreprocessorIncludeStatementArray[1], string4, string3.indexOf("#include \"header2.h\""), "#include \"header2.h\"".length());
            this.assertSoleFileLocation((IASTNode)iASTDeclarationArray[2], string4, string3.indexOf("int z;"), "int z;".length());
            IASTTranslationUnit.IDependencyTree iDependencyTree = iASTTranslationUnit.getDependencyTree();
            DOMLocationInclusionTests.assertEquals((int)iDependencyTree.getInclusions().length, (int)2);
            Object object = parserLanguage = parserLanguage == ParserLanguage.C ? ParserLanguage.CPP : null;
        }
    }

    public void testMacrosInIncludeFile2() throws Exception {
        String string = "#define X 4\n\n#include \"blarg.h\"\n\n#define POST_INCLUDE\n#include \"second.h\"\n#define POST_SECOND\n";
        String string2 = "#ifndef _BLARG_H_\r\n#define _BLARG_H_\r\n//macro\r\n#define PRINT(s,m) printf(s,m)\r\n#endif //_BLARG_H_\r\n";
        String string3 = "#ifndef _SECOND_H_ \n#define _SECOND_H_\n#endif\n";
        this.importFile("blarg.h", string2);
        this.importFile("second.h", string3);
        ParserLanguage parserLanguage = ParserLanguage.C;
        while (parserLanguage != null) {
            String string4 = parserLanguage == ParserLanguage.CPP ? "blah.cc" : "blah.c";
            IFile iFile = this.importFile(string4, string);
            IASTTranslationUnit iASTTranslationUnit = this.parse(iFile);
            DOMLocationInclusionTests.assertEquals((int)iASTTranslationUnit.getDeclarations().length, (int)0);
            IASTPreprocessorMacroDefinition[] iASTPreprocessorMacroDefinitionArray = iASTTranslationUnit.getMacroDefinitions();
            DOMLocationInclusionTests.assertNotNull((Object)iASTPreprocessorMacroDefinitionArray);
            DOMLocationInclusionTests.assertEquals((int)iASTPreprocessorMacroDefinitionArray.length, (int)6);
            this.assertSoleFileLocation((IASTNode)iASTPreprocessorMacroDefinitionArray[0], string4, string.indexOf("#define"), string.indexOf("4") + 1 - string.indexOf("#define"));
            this.assertSoleFileLocation((IASTNode)iASTPreprocessorMacroDefinitionArray[0].getName(), string4, string.indexOf("X"), 1);
            this.assertSoleFileLocation((IASTNode)iASTPreprocessorMacroDefinitionArray[1], "blarg.h", string2.indexOf("#define _BLARG_H_"), "#define _BLARG_H_\r".length());
            this.assertSoleFileLocation((IASTNode)iASTPreprocessorMacroDefinitionArray[1].getName(), "blarg.h", string2.indexOf("e _BLARG_H_") + 2, "_BLARG_H_".length());
            this.assertSoleFileLocation((IASTNode)iASTPreprocessorMacroDefinitionArray[2], "blarg.h", string2.indexOf("#define PRINT(s,m) printf(s,m)\r"), "#define PRINT(s,m) printf(s,m)".length());
            this.assertSoleFileLocation((IASTNode)iASTPreprocessorMacroDefinitionArray[2].getName(), "blarg.h", string2.indexOf("PRINT"), "PRINT".length());
            this.assertSoleFileLocation((IASTNode)iASTPreprocessorMacroDefinitionArray[3], string4, string.indexOf("#define POST_INCLUDE"), "#define POST_INCLUDE".length());
            this.assertSoleFileLocation((IASTNode)iASTPreprocessorMacroDefinitionArray[3].getName(), string4, string.indexOf("POST_INCLUDE"), "POST_INCLUDE".length());
            this.assertSoleFileLocation((IASTNode)iASTPreprocessorMacroDefinitionArray[4], "second.h", string3.indexOf("#define _SECOND_H_"), "#define _SECOND_H_".length());
            this.assertSoleFileLocation((IASTNode)iASTPreprocessorMacroDefinitionArray[5], string4, string.indexOf("#define POST_SECOND"), "#define POST_SECOND".length());
            Object object = parserLanguage = parserLanguage == ParserLanguage.C ? ParserLanguage.CPP : null;
        }
    }

    public void testBug90851() throws Exception {
        IFile iFile = this.importFile("macro.h", "#define BEAST 666\n");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#ifndef _INCLUDE_H_\n");
        stringBuffer.append("#define _INCLUDE_H_\n");
        stringBuffer.append("typedef void (*vfp)();\n");
        stringBuffer.append("typedef int (*ifp)();\n");
        stringBuffer.append("struct Include {\n");
        stringBuffer.append("int i;\n");
        stringBuffer.append("};\n");
        stringBuffer.append("#endif /*_INCLUDE_H_*/\n");
        String string = stringBuffer.toString();
        IFile iFile2 = this.importFile("include.h", string);
        String[] stringArray = new String[]{iFile.getLocation().toOSString()};
        String[] stringArray2 = new String[]{iFile2.getLocation().toOSString()};
        ExtendedScannerInfo extendedScannerInfo = new ExtendedScannerInfo(Collections.EMPTY_MAP, EMPTY_STRING_ARRAY, stringArray, stringArray2);
        ParserLanguage parserLanguage = ParserLanguage.C;
        while (parserLanguage != null) {
            String string2 = parserLanguage == ParserLanguage.CPP ? "main.cc" : "main.c";
            IFile iFile3 = this.importFile(string2, "int main() { return BEAST * sizeof( Include ); } ");
            IASTTranslationUnit iASTTranslationUnit = this.parse(iFile3, (IScannerInfo)extendedScannerInfo);
            IASTPreprocessorMacroDefinition[] iASTPreprocessorMacroDefinitionArray = iASTTranslationUnit.getMacroDefinitions();
            DOMLocationInclusionTests.assertEquals((int)iASTPreprocessorMacroDefinitionArray.length, (int)2);
            IASTPreprocessorMacroDefinition iASTPreprocessorMacroDefinition = iASTPreprocessorMacroDefinitionArray[0];
            DOMLocationInclusionTests.assertEquals((String)iASTPreprocessorMacroDefinition.getName().toString(), (String)"BEAST");
            IASTPreprocessorMacroDefinition iASTPreprocessorMacroDefinition2 = iASTPreprocessorMacroDefinitionArray[1];
            IASTNodeLocation[] iASTNodeLocationArray = iASTPreprocessorMacroDefinition2.getName().getNodeLocations();
            DOMLocationInclusionTests.assertEquals((int)iASTNodeLocationArray.length, (int)1);
            IASTFileLocation iASTFileLocation = iASTPreprocessorMacroDefinition2.getName().getFileLocation();
            DOMLocationInclusionTests.assertNotNull((Object)iASTFileLocation);
            DOMLocationInclusionTests.assertEquals((String)iFile2.getLocation().toOSString(), (String)iASTFileLocation.getFileName());
            DOMLocationInclusionTests.assertEquals((int)(string.indexOf("#define _INCLUDE_H_") + "#define ".length()), (int)iASTFileLocation.getNodeOffset());
            DOMLocationInclusionTests.assertEquals((int)"_INCLUDE_H_".length(), (int)iASTFileLocation.getNodeLength());
            Object object = parserLanguage = parserLanguage == ParserLanguage.C ? ParserLanguage.CPP : null;
        }
    }

    public void testIProblemLocation() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#include <not_found.h>\n");
        stringBuffer.append("int x,y,z;");
        String string = stringBuffer.toString();
        ParserLanguage parserLanguage = ParserLanguage.C;
        while (parserLanguage != null) {
            String string2 = parserLanguage == ParserLanguage.CPP ? "blah.cc" : "blah.c";
            IFile iFile = this.importFile(string2, string);
            IASTTranslationUnit iASTTranslationUnit = this.parse(iFile);
            IASTProblem[] iASTProblemArray = iASTTranslationUnit.getPreprocessorProblems();
            DOMLocationInclusionTests.assertEquals((int)iASTProblemArray.length, (int)1);
            IASTNodeLocation[] iASTNodeLocationArray = iASTProblemArray[0].getNodeLocations();
            DOMLocationInclusionTests.assertEquals((int)iASTNodeLocationArray.length, (int)1);
            IASTFileLocation iASTFileLocation = (IASTFileLocation)iASTNodeLocationArray[0];
            DOMLocationInclusionTests.assertEquals((int)string.indexOf("#include"), (int)iASTFileLocation.getNodeOffset());
            DOMLocationInclusionTests.assertEquals((int)"#include <not_found.h>\n".length(), (int)iASTFileLocation.getNodeLength());
            Object object = parserLanguage = parserLanguage == ParserLanguage.C ? ParserLanguage.CPP : null;
        }
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.parser.tests.ast2.DOMLocationInclusionTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite testSuite = new TestSuite((Class)clazz);
        testSuite.addTest((Test)new DOMLocationInclusionTests("cleanupProject"));
        return testSuite;
    }

    public void testBug97603() throws Exception {
        IFile iFile = this.importFile("macro.h", "#define JEDEN 1\n#define DVA 2\n#define TRI 3\n");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#ifndef _INCLUDE_H_\n");
        stringBuffer.append("#define _INCLUDE_H_\n");
        stringBuffer.append("typedef void (*vfp)();\n");
        stringBuffer.append("typedef int (*ifp)();\n");
        stringBuffer.append("struct Include {\n");
        stringBuffer.append("int i;\n");
        stringBuffer.append("};\n");
        stringBuffer.append("#endif /*_INCLUDE_H_*/\n");
        String string = stringBuffer.toString();
        IFile iFile2 = this.importFile("include.h", string);
        String[] stringArray = new String[]{iFile.getLocation().toOSString()};
        String[] stringArray2 = new String[]{iFile2.getLocation().toOSString()};
        ExtendedScannerInfo extendedScannerInfo = new ExtendedScannerInfo(Collections.EMPTY_MAP, EMPTY_STRING_ARRAY, stringArray, stringArray2);
        ParserLanguage parserLanguage = ParserLanguage.C;
        while (parserLanguage != null) {
            String string2 = parserLanguage == ParserLanguage.CPP ? "main.cc" : "main.c";
            IFile iFile3 = this.importFile(string2, "int main() { return BEAST * sizeof( Include ); } ");
            IASTTranslationUnit iASTTranslationUnit = this.parse(iFile3, (IScannerInfo)extendedScannerInfo);
            IASTPreprocessorMacroDefinition[] iASTPreprocessorMacroDefinitionArray = iASTTranslationUnit.getMacroDefinitions();
            DOMLocationInclusionTests.assertEquals((int)iASTPreprocessorMacroDefinitionArray.length, (int)4);
            IASTPreprocessorMacroDefinition iASTPreprocessorMacroDefinition = iASTPreprocessorMacroDefinitionArray[0];
            DOMLocationInclusionTests.assertEquals((String)iASTPreprocessorMacroDefinition.getName().toString(), (String)"JEDEN");
            IASTPreprocessorMacroDefinition iASTPreprocessorMacroDefinition2 = iASTPreprocessorMacroDefinitionArray[3];
            IASTNodeLocation[] iASTNodeLocationArray = iASTPreprocessorMacroDefinition2.getName().getNodeLocations();
            DOMLocationInclusionTests.assertEquals((int)iASTNodeLocationArray.length, (int)1);
            IASTFileLocation iASTFileLocation = iASTPreprocessorMacroDefinition2.getName().getFileLocation();
            DOMLocationInclusionTests.assertNotNull((Object)iASTFileLocation);
            DOMLocationInclusionTests.assertEquals((String)iFile2.getLocation().toOSString(), (String)iASTFileLocation.getFileName());
            DOMLocationInclusionTests.assertEquals((int)(string.indexOf("#define _INCLUDE_H_") + "#define ".length()), (int)iASTFileLocation.getNodeOffset());
            DOMLocationInclusionTests.assertEquals((int)"_INCLUDE_H_".length(), (int)iASTFileLocation.getNodeLength());
            int n = 0;
            while (n < iASTPreprocessorMacroDefinitionArray.length) {
                DOMLocationInclusionTests.assertNotNull((Object)iASTPreprocessorMacroDefinitionArray[n].getName().getFileLocation());
                ++n;
            }
            Object object = parserLanguage = parserLanguage == ParserLanguage.C ? ParserLanguage.CPP : null;
        }
    }

    public class ParserConfiguration
    implements IParserConfiguration {
        private final IScannerInfo info;
        private final String dialect;

        public ParserConfiguration(IScannerInfo iScannerInfo, IFile iFile) {
            this.info = iScannerInfo;
            String string = iFile.getLocation().toOSString();
            IProject iProject = iFile.getProject();
            String string2 = null;
            IContentType iContentType = CCorePlugin.getContentType((IProject)iProject, (String)string);
            if (iContentType != null) {
                string2 = iContentType.getId();
            }
            this.dialect = string2 != null ? ("org.eclipse.cdt.core.cSource".equals(string2) ? "GNUC" : "GNUC++") : "GNUC++";
        }

        public IScannerInfo getScannerInfo() {
            return this.info;
        }

        public String getParserDialect() {
            return this.dialect;
        }
    }
}

