/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests.ast2;

import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTCastExpression;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTConditionalExpression;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarationStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTExpressionStatement;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTFunctionStyleMacroParameter;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTInitializerExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTNullStatement;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorEndifStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorFunctionStyleMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIfndefStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorObjectStyleMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorUndefStatement;
import org.eclipse.cdt.core.dom.ast.IASTReturnStatement;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStandardFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionTryBlockDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTLinkageSpecification;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNewExpression;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.tests.ast2.AST2BaseTest;
import org.eclipse.cdt.internal.core.parser.ParserException;

public class DOMLocationTests
extends AST2BaseTest {
    private static final String _TEXT_ = "<text>";

    public void testBaseCase() throws ParserException {
        ParserLanguage parserLanguage = ParserLanguage.C;
        while (parserLanguage != null) {
            IASTTranslationUnit iASTTranslationUnit = this.parse("int x;", parserLanguage);
            IASTDeclaration iASTDeclaration = iASTTranslationUnit.getDeclarations()[0];
            IASTNodeLocation[] iASTNodeLocationArray = iASTDeclaration.getNodeLocations();
            DOMLocationTests.assertNotNull((Object)iASTNodeLocationArray);
            DOMLocationTests.assertEquals((int)iASTNodeLocationArray.length, (int)1);
            DOMLocationTests.assertTrue((boolean)(iASTNodeLocationArray[0] instanceof IASTFileLocation));
            IASTFileLocation iASTFileLocation = (IASTFileLocation)iASTNodeLocationArray[0];
            DOMLocationTests.assertEquals((String)iASTFileLocation.getFileName(), (String)_TEXT_);
            DOMLocationTests.assertEquals((int)iASTFileLocation.getNodeOffset(), (int)0);
            DOMLocationTests.assertEquals((int)iASTFileLocation.getNodeLength(), (int)6);
            IASTNodeLocation[] iASTNodeLocationArray2 = iASTTranslationUnit.getNodeLocations();
            DOMLocationTests.assertEquals((int)iASTNodeLocationArray2.length, (int)iASTNodeLocationArray.length);
            DOMLocationTests.assertEquals((String)iASTFileLocation.getFileName(), (String)((IASTFileLocation)iASTNodeLocationArray2[0]).getFileName());
            DOMLocationTests.assertEquals((int)iASTFileLocation.getNodeOffset(), (int)iASTNodeLocationArray2[0].getNodeOffset());
            DOMLocationTests.assertEquals((int)iASTFileLocation.getNodeLength(), (int)iASTNodeLocationArray2[0].getNodeLength());
            Object object = parserLanguage = parserLanguage == ParserLanguage.C ? ParserLanguage.CPP : null;
        }
    }

    public void testSimpleDeclaration() throws ParserException {
        String string = "int xLen5, * yLength8, zLength16( int );";
        ParserLanguage parserLanguage = ParserLanguage.C;
        while (parserLanguage != null) {
            IASTTranslationUnit iASTTranslationUnit = this.parse(string, parserLanguage);
            IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
            DOMLocationTests.assertEquals((int)iASTDeclarationArray.length, (int)1);
            IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTDeclarationArray[0];
            IASTNodeLocation[] iASTNodeLocationArray = iASTSimpleDeclaration.getNodeLocations();
            DOMLocationTests.assertNotNull((Object)iASTNodeLocationArray);
            DOMLocationTests.assertEquals((int)iASTNodeLocationArray.length, (int)1);
            DOMLocationTests.assertTrue((boolean)(iASTNodeLocationArray[0] instanceof IASTFileLocation));
            IASTFileLocation iASTFileLocation = (IASTFileLocation)iASTNodeLocationArray[0];
            DOMLocationTests.assertEquals((String)iASTFileLocation.getFileName(), (String)_TEXT_);
            DOMLocationTests.assertEquals((int)iASTFileLocation.getNodeOffset(), (int)0);
            DOMLocationTests.assertEquals((int)iASTFileLocation.getNodeLength(), (int)(string.indexOf(";") + 1));
            IASTDeclarator[] iASTDeclaratorArray = iASTSimpleDeclaration.getDeclarators();
            DOMLocationTests.assertEquals((int)iASTDeclaratorArray.length, (int)3);
            int n = 0;
            while (n < 3) {
                IASTDeclarator iASTDeclarator = iASTDeclaratorArray[n];
                switch (n) {
                    case 0: {
                        this.assertSoleLocation((IASTNode)iASTDeclarator, string.indexOf("xLen5"), "xLen5".length());
                        break;
                    }
                    case 1: {
                        this.assertSoleLocation((IASTNode)iASTDeclarator, string.indexOf("* yLength8"), "* yLength8".length());
                        break;
                    }
                    case 2: {
                        this.assertSoleLocation((IASTNode)iASTDeclarator, string.indexOf("zLength16( int )"), "zLength16( int )".length());
                    }
                }
                ++n;
            }
            Object object = parserLanguage = parserLanguage == ParserLanguage.C ? ParserLanguage.CPP : null;
        }
    }

    public void testSimpleObjectStyleMacroDefinition() throws Exception {
        String string = "/* hi */\n#define FOOT 0x01\n\n";
        ParserLanguage parserLanguage = ParserLanguage.C;
        while (parserLanguage != null) {
            IASTTranslationUnit iASTTranslationUnit = this.parse(string, parserLanguage);
            IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
            DOMLocationTests.assertEquals((int)iASTDeclarationArray.length, (int)0);
            IASTPreprocessorMacroDefinition[] iASTPreprocessorMacroDefinitionArray = iASTTranslationUnit.getMacroDefinitions();
            DOMLocationTests.assertNotNull((Object)iASTPreprocessorMacroDefinitionArray);
            DOMLocationTests.assertEquals((int)iASTPreprocessorMacroDefinitionArray.length, (int)1);
            this.assertSoleLocation((IASTNode)iASTPreprocessorMacroDefinitionArray[0], string.indexOf("#"), string.indexOf("0x01") + 4 - string.indexOf("#"));
            DOMLocationTests.assertTrue((boolean)(iASTPreprocessorMacroDefinitionArray[0] instanceof IASTPreprocessorObjectStyleMacroDefinition));
            DOMLocationTests.assertEquals((String)iASTPreprocessorMacroDefinitionArray[0].getName().toString(), (String)"FOOT");
            DOMLocationTests.assertEquals((String)iASTPreprocessorMacroDefinitionArray[0].getExpansion(), (String)"0x01");
            Object object = parserLanguage = parserLanguage == ParserLanguage.C ? ParserLanguage.CPP : null;
        }
    }

    public void testSimpleFunctionStyleMacroDefinition() throws Exception {
        String string = "#define FOOBAH( WOOBAH ) JOHN##WOOBAH\n\n";
        ParserLanguage parserLanguage = ParserLanguage.C;
        while (parserLanguage != null) {
            IASTTranslationUnit iASTTranslationUnit = this.parse(string, parserLanguage);
            IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
            DOMLocationTests.assertEquals((int)iASTDeclarationArray.length, (int)0);
            IASTPreprocessorMacroDefinition[] iASTPreprocessorMacroDefinitionArray = iASTTranslationUnit.getMacroDefinitions();
            DOMLocationTests.assertNotNull((Object)iASTPreprocessorMacroDefinitionArray);
            DOMLocationTests.assertEquals((int)iASTPreprocessorMacroDefinitionArray.length, (int)1);
            DOMLocationTests.assertTrue((boolean)(iASTPreprocessorMacroDefinitionArray[0] instanceof IASTPreprocessorFunctionStyleMacroDefinition));
            this.assertSoleLocation((IASTNode)iASTPreprocessorMacroDefinitionArray[0], string.indexOf("#define"), string.indexOf("##WOOBAH") + 8 - string.indexOf("#define"));
            DOMLocationTests.assertEquals((String)iASTPreprocessorMacroDefinitionArray[0].getName().toString(), (String)"FOOBAH");
            DOMLocationTests.assertEquals((String)iASTPreprocessorMacroDefinitionArray[0].getExpansion(), (String)"JOHN##WOOBAH");
            IASTFunctionStyleMacroParameter[] iASTFunctionStyleMacroParameterArray = ((IASTPreprocessorFunctionStyleMacroDefinition)iASTPreprocessorMacroDefinitionArray[0]).getParameters();
            DOMLocationTests.assertNotNull((Object)iASTFunctionStyleMacroParameterArray);
            DOMLocationTests.assertEquals((int)iASTFunctionStyleMacroParameterArray.length, (int)1);
            DOMLocationTests.assertEquals((String)iASTFunctionStyleMacroParameterArray[0].getParameter(), (String)"WOOBAH");
            Object object = parserLanguage = parserLanguage == ParserLanguage.C ? ParserLanguage.CPP : null;
        }
    }

    private void assertSoleLocation(IASTNode iASTNode, int n, int n2) {
        IASTNodeLocation[] iASTNodeLocationArray = iASTNode.getNodeLocations();
        DOMLocationTests.assertEquals((int)1, (int)iASTNodeLocationArray.length);
        IASTNodeLocation iASTNodeLocation = iASTNodeLocationArray[0];
        DOMLocationTests.assertEquals((int)n, (int)iASTNodeLocation.getNodeOffset());
        DOMLocationTests.assertEquals((int)n2, (int)iASTNodeLocation.getNodeLength());
    }

    public void testBug83664() throws Exception {
        String string = "int foo(x) int x; {\n \treturn x;\n   }\n";
        IASTTranslationUnit iASTTranslationUnit = this.parse(string, ParserLanguage.C, true);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        DOMLocationTests.assertEquals((int)iASTDeclarationArray.length, (int)1);
        IASTFunctionDefinition iASTFunctionDefinition = (IASTFunctionDefinition)iASTDeclarationArray[0];
        IASTFunctionDeclarator iASTFunctionDeclarator = iASTFunctionDefinition.getDeclarator();
        this.assertSoleLocation((IASTNode)iASTFunctionDeclarator, string.indexOf("foo"), string.indexOf("int x;") + 6 - string.indexOf("foo"));
        IASTCompoundStatement iASTCompoundStatement = (IASTCompoundStatement)iASTFunctionDefinition.getBody();
        DOMLocationTests.assertEquals((int)iASTCompoundStatement.getStatements().length, (int)1);
        IASTReturnStatement iASTReturnStatement = (IASTReturnStatement)iASTCompoundStatement.getStatements()[0];
        IASTIdExpression iASTIdExpression = (IASTIdExpression)iASTReturnStatement.getReturnValue();
        this.assertSoleLocation((IASTNode)iASTIdExpression, string.indexOf("return ") + "return ".length(), 1);
    }

    public void testBug84343() throws Exception {
        String string = "class A {}; int f() {\nA * b = 0;\nreturn b;}";
        IASTTranslationUnit iASTTranslationUnit = this.parse(string, ParserLanguage.CPP);
        IASTFunctionDefinition iASTFunctionDefinition = (IASTFunctionDefinition)iASTTranslationUnit.getDeclarations()[1];
        IASTDeclarationStatement iASTDeclarationStatement = (IASTDeclarationStatement)((IASTCompoundStatement)iASTFunctionDefinition.getBody()).getStatements()[0];
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTDeclarationStatement.getDeclaration();
        ICPPASTNamedTypeSpecifier iCPPASTNamedTypeSpecifier = (ICPPASTNamedTypeSpecifier)iASTSimpleDeclaration.getDeclSpecifier();
        this.assertSoleLocation((IASTNode)iCPPASTNamedTypeSpecifier, string.indexOf("\nA") + 1, 1);
    }

    public void testBug84366() throws Exception {
        String string = "enum hue { red, blue, green };";
        IASTTranslationUnit iASTTranslationUnit = this.parse(string, ParserLanguage.CPP);
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[0];
        IASTEnumerationSpecifier iASTEnumerationSpecifier = (IASTEnumerationSpecifier)iASTSimpleDeclaration.getDeclSpecifier();
        IASTEnumerationSpecifier.IASTEnumerator iASTEnumerator = iASTEnumerationSpecifier.getEnumerators()[0];
        this.assertSoleLocation((IASTNode)iASTEnumerator, string.indexOf("red"), "red".length());
    }

    public void testBug84375() throws Exception {
        String string = "class D { public: int x; };\nclass C : public virtual D {};";
        IASTTranslationUnit iASTTranslationUnit = this.parse(string, ParserLanguage.CPP);
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[1];
        ICPPASTCompositeTypeSpecifier iCPPASTCompositeTypeSpecifier = (ICPPASTCompositeTypeSpecifier)iASTSimpleDeclaration.getDeclSpecifier();
        ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier[] iCPPASTBaseSpecifierArray = iCPPASTCompositeTypeSpecifier.getBaseSpecifiers();
        this.assertSoleLocation((IASTNode)iCPPASTBaseSpecifierArray[0], string.indexOf("public virtual D"), "public virtual D".length());
    }

    public void testBug84357() throws Exception {
        String string = "class X {\tint a;\n};\nint X::  * pmi = &X::a;";
        IASTTranslationUnit iASTTranslationUnit = this.parse(string, ParserLanguage.CPP);
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[1];
        IASTDeclarator iASTDeclarator = iASTSimpleDeclaration.getDeclarators()[0];
        IASTPointerOperator iASTPointerOperator = iASTDeclarator.getPointerOperators()[0];
        this.assertSoleLocation((IASTNode)iASTPointerOperator, string.indexOf("X::  *"), "X::  *".length());
    }

    public void testBug84367() throws Exception {
        String string = "void foo(   int   );";
        ParserLanguage parserLanguage = ParserLanguage.C;
        while (parserLanguage != null) {
            IASTTranslationUnit iASTTranslationUnit = this.parse(string, parserLanguage);
            IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[0];
            IASTStandardFunctionDeclarator iASTStandardFunctionDeclarator = (IASTStandardFunctionDeclarator)iASTSimpleDeclaration.getDeclarators()[0];
            IASTParameterDeclaration iASTParameterDeclaration = iASTStandardFunctionDeclarator.getParameters()[0];
            this.assertSoleLocation((IASTNode)iASTParameterDeclaration, string.indexOf("int"), 3);
            Object object = parserLanguage = parserLanguage == ParserLanguage.C ? ParserLanguage.CPP : null;
        }
    }

    public void testElaboratedTypeSpecifier() throws ParserException {
        String string = "/* blah */ struct A anA; /* blah */";
        ParserLanguage parserLanguage = ParserLanguage.C;
        while (parserLanguage != null) {
            IASTTranslationUnit iASTTranslationUnit = this.parse(string, parserLanguage);
            IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[0];
            IASTElaboratedTypeSpecifier iASTElaboratedTypeSpecifier = (IASTElaboratedTypeSpecifier)iASTSimpleDeclaration.getDeclSpecifier();
            this.assertSoleLocation((IASTNode)iASTElaboratedTypeSpecifier, string.indexOf("struct"), "struct A".length());
            Object object = parserLanguage = parserLanguage == ParserLanguage.C ? ParserLanguage.CPP : null;
        }
    }

    public void testBug83852() throws Exception {
        String string = "/* blah */ typedef short jc;  int x = 4;  jc myJc = (jc)x; ";
        ParserLanguage parserLanguage = ParserLanguage.C;
        while (parserLanguage != null) {
            IASTSimpleDeclaration iASTSimpleDeclaration;
            IASTTranslationUnit iASTTranslationUnit = this.parse(string, parserLanguage);
            IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
            DOMLocationTests.assertEquals((int)3, (int)iASTDeclarationArray.length);
            int n = 0;
            while (n < 3) {
                iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTDeclarationArray[n];
                int n2 = 0;
                int n3 = 0;
                switch (n) {
                    case 0: {
                        n2 = string.indexOf("typedef");
                        n3 = "typedef short jc;".length();
                        break;
                    }
                    case 1: {
                        n2 = string.indexOf("int x = 4;");
                        n3 = "int x = 4;".length();
                        break;
                    }
                    case 2: {
                        n2 = string.indexOf("jc myJc = (jc)x;");
                        n3 = "jc myJc = (jc)x;".length();
                    }
                }
                this.assertSoleLocation((IASTNode)iASTSimpleDeclaration, n2, n3);
                ++n;
            }
            IASTInitializerExpression iASTInitializerExpression = (IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[2]).getDeclarators()[0].getInitializer();
            iASTSimpleDeclaration = (IASTCastExpression)iASTInitializerExpression.getExpression();
            IASTTypeId iASTTypeId = iASTSimpleDeclaration.getTypeId();
            this.assertSoleLocation((IASTNode)iASTTypeId, string.indexOf("(jc)") + 1, "jc".length());
            Object object = parserLanguage = parserLanguage == ParserLanguage.C ? ParserLanguage.CPP : null;
        }
    }

    public void testBug83853() throws ParserException {
        String string = "int f() {return (1?0:1);\t}";
        ParserLanguage parserLanguage = ParserLanguage.C;
        while (parserLanguage != null) {
            IASTTranslationUnit iASTTranslationUnit = this.parse(string, parserLanguage);
            IASTFunctionDefinition iASTFunctionDefinition = (IASTFunctionDefinition)iASTTranslationUnit.getDeclarations()[0];
            IASTCompoundStatement iASTCompoundStatement = (IASTCompoundStatement)iASTFunctionDefinition.getBody();
            IASTReturnStatement iASTReturnStatement = (IASTReturnStatement)iASTCompoundStatement.getStatements()[0];
            IASTUnaryExpression iASTUnaryExpression = (IASTUnaryExpression)iASTReturnStatement.getReturnValue();
            DOMLocationTests.assertEquals((int)iASTUnaryExpression.getOperator(), (int)11);
            IASTConditionalExpression iASTConditionalExpression = (IASTConditionalExpression)iASTUnaryExpression.getOperand();
            this.assertSoleLocation((IASTNode)iASTConditionalExpression, string.indexOf("1?0:1"), "1?0:1".length());
            Object object = parserLanguage = parserLanguage == ParserLanguage.C ? ParserLanguage.CPP : null;
        }
    }

    public void testBug84374() throws Exception {
        String string = "class P1 { public: int x; };\nclass P2 { public: int x; };\nclass B : public P1, public P2 {};\nvoid main() {\nB * b = new B();\n}";
        IASTTranslationUnit iASTTranslationUnit = this.parse(string, ParserLanguage.CPP);
        IASTFunctionDefinition iASTFunctionDefinition = (IASTFunctionDefinition)iASTTranslationUnit.getDeclarations()[3];
        IASTCompoundStatement iASTCompoundStatement = (IASTCompoundStatement)iASTFunctionDefinition.getBody();
        IASTDeclarationStatement iASTDeclarationStatement = (IASTDeclarationStatement)iASTCompoundStatement.getStatements()[0];
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTDeclarationStatement.getDeclaration();
        IASTInitializerExpression iASTInitializerExpression = (IASTInitializerExpression)iASTSimpleDeclaration.getDeclarators()[0].getInitializer();
        this.assertSoleLocation((IASTNode)iASTInitializerExpression, string.indexOf("new B()"), "new B()".length());
        ICPPASTNewExpression iCPPASTNewExpression = (ICPPASTNewExpression)iASTInitializerExpression.getExpression();
        this.assertSoleLocation((IASTNode)iCPPASTNewExpression, string.indexOf("new B()"), "new B()".length());
    }

    public void testBug83737() throws Exception {
        String string = "void f() {  if( a == 0 ) g( a ); else if( a < 0 ) g( a >> 1 ); else if( a > 0 ) g( *(&a + 2) ); }";
        ParserLanguage parserLanguage = ParserLanguage.C;
        while (parserLanguage != null) {
            IASTTranslationUnit iASTTranslationUnit = this.parse(string, parserLanguage);
            IASTFunctionDefinition iASTFunctionDefinition = (IASTFunctionDefinition)iASTTranslationUnit.getDeclarations()[0];
            IASTCompoundStatement iASTCompoundStatement = (IASTCompoundStatement)iASTFunctionDefinition.getBody();
            IASTIfStatement iASTIfStatement = (IASTIfStatement)iASTCompoundStatement.getStatements()[0];
            IASTIfStatement iASTIfStatement2 = (IASTIfStatement)iASTIfStatement.getElseClause();
            IASTIfStatement iASTIfStatement3 = (IASTIfStatement)iASTIfStatement2.getElseClause();
            DOMLocationTests.assertNull((Object)iASTIfStatement3.getElseClause());
            int n = string.indexOf("if( a == 0 )");
            int n2 = "if( a == 0 ) g( a ); else if( a < 0 ) g( a >> 1 ); else if( a > 0 ) g( *(&a + 2) );".length();
            int n3 = n + n2;
            int n4 = string.indexOf("if( a < 0 )");
            int n5 = string.indexOf("if( a > 0 )");
            this.assertSoleLocation((IASTNode)iASTIfStatement, n, n2);
            this.assertSoleLocation((IASTNode)iASTIfStatement2, n4, n3 - n4);
            this.assertSoleLocation((IASTNode)iASTIfStatement3, n5, n3 - n5);
            Object object = parserLanguage = parserLanguage == ParserLanguage.C ? ParserLanguage.CPP : null;
        }
    }

    public void testBug84467() throws Exception {
        String string = "class D { };\n D d1;\n const D d2;\n void foo() {\n typeid(d1) == typeid(d2);\n }";
        IASTTranslationUnit iASTTranslationUnit = this.parse(string, ParserLanguage.CPP);
        IASTBinaryExpression iASTBinaryExpression = (IASTBinaryExpression)((IASTExpressionStatement)((IASTCompoundStatement)((IASTFunctionDefinition)iASTTranslationUnit.getDeclarations()[3]).getBody()).getStatements()[0]).getExpression();
        IASTUnaryExpression iASTUnaryExpression = (IASTUnaryExpression)((IASTBinaryExpression)((IASTExpressionStatement)((IASTCompoundStatement)((IASTFunctionDefinition)iASTTranslationUnit.getDeclarations()[3]).getBody()).getStatements()[0]).getExpression()).getOperand1();
        this.assertSoleLocation((IASTNode)iASTBinaryExpression, string.indexOf("typeid(d1) == typeid(d2)"), "typeid(d1) == typeid(d2)".length());
        this.assertSoleLocation((IASTNode)iASTUnaryExpression, string.indexOf("typeid(d1)"), "typeid(d1)".length());
        iASTUnaryExpression = (IASTUnaryExpression)((IASTBinaryExpression)((IASTExpressionStatement)((IASTCompoundStatement)((IASTFunctionDefinition)iASTTranslationUnit.getDeclarations()[3]).getBody()).getStatements()[0]).getExpression()).getOperand2();
        this.assertSoleLocation((IASTNode)iASTUnaryExpression, string.indexOf("typeid(d2)"), "typeid(d2)".length());
    }

    public void testBug84576() throws Exception {
        String string = "namespace A {\n extern \"C\" int g();\n }";
        IASTTranslationUnit iASTTranslationUnit = this.parse(string, ParserLanguage.CPP);
        ICPPASTLinkageSpecification iCPPASTLinkageSpecification = (ICPPASTLinkageSpecification)((ICPPASTNamespaceDefinition)iASTTranslationUnit.getDeclarations()[0]).getDeclarations()[0];
        this.assertSoleLocation((IASTNode)iCPPASTLinkageSpecification, string.indexOf("extern \"C\""), "extern \"C\" int g();".length());
    }

    public void testSimplePreprocessorStatements() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#ifndef _APPLE_H_\n");
        stringBuffer.append("#define _APPLE_H_\n");
        stringBuffer.append("#undef _APPLE_H_\n");
        stringBuffer.append("#endif\n");
        String string = stringBuffer.toString();
        ParserLanguage parserLanguage = ParserLanguage.C;
        while (parserLanguage != null) {
            IASTTranslationUnit iASTTranslationUnit = this.parse(string, parserLanguage);
            DOMLocationTests.assertEquals((int)iASTTranslationUnit.getDeclarations().length, (int)0);
            IASTPreprocessorStatement[] iASTPreprocessorStatementArray = iASTTranslationUnit.getAllPreprocessorStatements();
            DOMLocationTests.assertEquals((int)iASTPreprocessorStatementArray.length, (int)4);
            IASTPreprocessorIfndefStatement iASTPreprocessorIfndefStatement = (IASTPreprocessorIfndefStatement)iASTPreprocessorStatementArray[0];
            DOMLocationTests.assertTrue((boolean)iASTPreprocessorIfndefStatement.taken());
            this.assertSoleLocation((IASTNode)iASTPreprocessorIfndefStatement, string.indexOf("#ifndef _APPLE_H_"), "#ifndef _APPLE_H_".length());
            IASTPreprocessorObjectStyleMacroDefinition iASTPreprocessorObjectStyleMacroDefinition = (IASTPreprocessorObjectStyleMacroDefinition)iASTPreprocessorStatementArray[1];
            this.assertSoleLocation((IASTNode)iASTPreprocessorObjectStyleMacroDefinition, string.indexOf("#define _APPLE_H_"), "#define _APPLE_H_".length());
            IASTPreprocessorUndefStatement iASTPreprocessorUndefStatement = (IASTPreprocessorUndefStatement)iASTPreprocessorStatementArray[2];
            this.assertSoleLocation((IASTNode)iASTPreprocessorUndefStatement, string.indexOf("#undef _APPLE_H_"), "#undef _APPLE_H_".length());
            IASTPreprocessorEndifStatement iASTPreprocessorEndifStatement = (IASTPreprocessorEndifStatement)iASTPreprocessorStatementArray[3];
            this.assertSoleLocation((IASTNode)iASTPreprocessorEndifStatement, string.indexOf("#endif"), "#endif".length());
            Object object = parserLanguage = parserLanguage == ParserLanguage.C ? ParserLanguage.CPP : null;
        }
    }

    public void testBug85820() throws Exception {
        String string = "int *p = (int []){2, 4};";
        IASTTranslationUnit iASTTranslationUnit = this.parse(string, ParserLanguage.C);
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[0];
        IASTDeclarator iASTDeclarator = iASTSimpleDeclaration.getDeclarators()[0];
        this.assertSoleLocation((IASTNode)iASTDeclarator, string.indexOf("*p = (int []){2, 4}"), "*p = (int []){2, 4}".length());
    }

    public void testBug86323() throws Exception {
        String string = "void f() { int i=0;\tfor (; i<10; i++) {\t} }";
        ParserLanguage parserLanguage = ParserLanguage.C;
        while (parserLanguage != null) {
            IASTTranslationUnit iASTTranslationUnit = this.parse(string, parserLanguage);
            IASTForStatement iASTForStatement = (IASTForStatement)((IASTCompoundStatement)((IASTFunctionDefinition)iASTTranslationUnit.getDeclarations()[0]).getBody()).getStatements()[1];
            DOMLocationTests.assertTrue((boolean)(iASTForStatement.getInitializerStatement() instanceof IASTNullStatement));
            Object object = parserLanguage = parserLanguage == ParserLanguage.C ? ParserLanguage.CPP : null;
        }
    }

    public void testBug86698_1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct C;\n");
        stringBuffer.append("void no_opt(C*);\n");
        stringBuffer.append("struct C {\n");
        stringBuffer.append("int c;\n");
        stringBuffer.append("C() : c(0) { no_opt(this); }\n");
        stringBuffer.append("};\n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        ICPPASTFunctionDeclarator iCPPASTFunctionDeclarator = (ICPPASTFunctionDeclarator)((IASTFunctionDefinition)((ICPPASTCompositeTypeSpecifier)((IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[2]).getDeclSpecifier()).getMembers()[1]).getDeclarator();
        this.assertSoleLocation((IASTNode)iCPPASTFunctionDeclarator, stringBuffer.toString().indexOf("C() : c(0)"), "C() : c(0)".length());
    }

    public void testBug86698_2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void foo() {\n");
        stringBuffer.append("int f(int);\n");
        stringBuffer.append("class C {\n");
        stringBuffer.append("int i;\n");
        stringBuffer.append("double d;\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("C(int, double);\n");
        stringBuffer.append("};\n");
        stringBuffer.append("C::C(int ii, double id)\n");
        stringBuffer.append("try\n");
        stringBuffer.append(": i(f(ii)), d(id)\n");
        stringBuffer.append("{\n }\n");
        stringBuffer.append("catch (...)\n");
        stringBuffer.append("{\n }\n");
        stringBuffer.append("}\n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        ICPPASTFunctionTryBlockDeclarator iCPPASTFunctionTryBlockDeclarator = (ICPPASTFunctionTryBlockDeclarator)((IASTFunctionDefinition)((IASTDeclarationStatement)((IASTCompoundStatement)((IASTFunctionDefinition)iASTTranslationUnit.getDeclarations()[0]).getBody()).getStatements()[2]).getDeclaration()).getDeclarator();
        this.assertSoleLocation((IASTNode)iCPPASTFunctionTryBlockDeclarator, stringBuffer.toString().indexOf("C::C(int ii, double id)\ntry\n: i(f(ii)), d(id)"), "C::C(int ii, double id)\ntry\n: i(f(ii)), d(id)".length());
    }
}

