/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.testplugin.util;

import java.util.Iterator;
import org.eclipse.cdt.core.testplugin.util.AccessibilityTestPass;
import org.eclipse.cdt.core.testplugin.util.FailureDialog;
import org.eclipse.cdt.core.testplugin.util.FocusTestPass;
import org.eclipse.cdt.core.testplugin.util.IDialogTestPass;
import org.eclipse.cdt.core.testplugin.util.SizingTestPass;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class VerifyDialog
extends TitleAreaDialog {
    private int SIZING_WIDTH = 400;
    static int TEST_TYPE;
    public static final int TEST_SIZING = 0;
    public static final int TEST_FOCUS = 1;
    public static final int TEST_ACCESS = 2;
    private IDialogTestPass[] _dialogTests = new IDialogTestPass[3];
    private Dialog _testDialog;
    private Point _testDialogSize;
    private Label _queryLabel;
    Button _yesButton;
    private Button _noButton;
    private Button[] _checkList;
    private String _failureText;

    public VerifyDialog(Shell shell) {
        super(shell);
        if (TEST_TYPE > 2 && TEST_TYPE < 0) {
            TEST_TYPE = 0;
        }
        this._failureText = "";
        this._dialogTests[0] = new SizingTestPass();
        this._dialogTests[1] = new FocusTestPass();
        this._dialogTests[2] = new AccessibilityTestPass();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Dialog Verification");
        this.setShellStyle(0);
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this._yesButton = this.createButton(composite, 2, IDialogConstants.YES_LABEL, true);
        this._noButton = this.createButton(composite, 3, IDialogConstants.NO_LABEL, false);
    }

    protected void buttonPressed(int n) {
        if (2 == n) {
            this.setReturnCode(2);
            if (this._testDialog.getShell() != null) {
                this._testDialog.close();
            }
            this.close();
        } else if (3 == n) {
            this.handleFailure();
        }
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        Composite composite3 = new Composite(composite2, 0);
        composite3.setSize(this.SIZING_WIDTH, -1);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        gridLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite3.setLayout((Layout)gridLayout);
        composite3.setLayoutData((Object)new GridData(1808));
        this.createTestSelectionGroup(composite3);
        this.createCheckListGroup(composite3);
        this._queryLabel = new Label(composite3, 0);
        this._queryLabel.setLayoutData((Object)new GridData(768));
        this.initializeTest();
        return composite3;
    }

    private void createTestSelectionGroup(Composite composite) {
        Group group = new Group(composite, 32);
        group.setText("Testing:");
        group.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(768);
        group.setLayoutData((Object)gridData);
        int n = 0;
        while (n < this._dialogTests.length) {
            Button button = new Button((Composite)group, 16);
            button.setText(this._dialogTests[n].label());
            final int n2 = this._dialogTests[n].getID();
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    TEST_TYPE = n2;
                    VerifyDialog.this.initializeTest();
                    VerifyDialog.this._yesButton.setEnabled(true);
                }
            });
            if (TEST_TYPE == this._dialogTests[n].getID()) {
                button.setSelection(true);
            }
            ++n;
        }
    }

    private void createCheckListGroup(Composite composite) {
        int n;
        Group group = new Group(composite, 32);
        group.setText("Verify that:");
        group.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(768);
        group.setLayoutData((Object)gridData);
        int n2 = 0;
        int n3 = 0;
        while (n3 < this._dialogTests.length) {
            n = this._dialogTests[n3].checkListTexts().size();
            if (n > n2) {
                n2 = n;
            }
            ++n3;
        }
        this._checkList = new Button[n2];
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                VerifyDialog.this.checkYesEnable();
            }
        };
        n = 0;
        while (n < n2) {
            this._checkList[n] = new Button((Composite)group, 32);
            this._checkList[n].addSelectionListener((SelectionListener)selectionAdapter);
            gridData = new GridData(256);
            gridData.grabExcessHorizontalSpace = true;
            this._checkList[n].setLayoutData((Object)gridData);
            ++n;
        }
    }

    void checkYesEnable() {
        boolean bl = true;
        int n = 0;
        while (n < this._checkList.length) {
            if (!this._checkList[n].getSelection()) {
                bl = false;
            }
            ++n;
        }
        this._yesButton.setEnabled(bl);
    }

    void initializeTest() {
        IDialogTestPass iDialogTestPass = this._dialogTests[TEST_TYPE];
        this.setTitle(iDialogTestPass.title());
        this.setMessage(iDialogTestPass.description());
        Iterator iterator = iDialogTestPass.checkListTexts().iterator();
        int n = 0;
        while (n < this._checkList.length) {
            if (iterator.hasNext()) {
                this._checkList[n].setText(iterator.next().toString());
                this._checkList[n].setVisible(true);
                this._checkList[n].update();
            } else {
                this._checkList[n].setVisible(false);
                this._checkList[n].update();
            }
            this._checkList[n].setSelection(true);
            ++n;
        }
        this._queryLabel.setText(iDialogTestPass.queryText());
    }

    public String getFailureText() {
        return this._failureText;
    }

    public int open() {
        this._failureText = "Testing dialog is required, use VerifyDialog::open(Dialog)";
        return 3;
    }

    public int open(Dialog dialog) {
        if (this.getShell() == null) {
            this.create();
        }
        this.getShell().setLocation(0, 0);
        this.getShell().setSize(Math.max(this.SIZING_WIDTH, this.getShell().getSize().x), this.getShell().getSize().y);
        this._testDialog = dialog;
        if (this._testDialog.getShell() == null) {
            this._testDialog.create();
        }
        this._testDialogSize = this._testDialog.getShell().getSize();
        this.openNewTestDialog();
        return super.open();
    }

    private void openNewTestDialog() {
        if (this._testDialog.getShell() == null) {
            this._testDialog.create();
        }
        this._testDialog.setBlockOnOpen(false);
        this._testDialog.getShell().setLocation(this.getShell().getSize().x + 1, 0);
        this._testDialog.getShell().setSize(this._testDialogSize);
        this._testDialog.getShell().addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent shellEvent) {
                shellEvent.doit = false;
            }
        });
        this._testDialog.open();
    }

    private void handleFailure() {
        IDialogTestPass iDialogTestPass = this._dialogTests[TEST_TYPE];
        StringBuffer stringBuffer = new StringBuffer();
        String string = iDialogTestPass.label();
        string = String.valueOf(string.substring(0, string.indexOf("&"))) + string.substring(string.indexOf("&") + 1);
        stringBuffer.append(string).append(" failed on the ").append(SWT.getPlatform()).append(" platform:\n");
        String[] stringArray = iDialogTestPass.failureTexts();
        int n = 0;
        while (n < iDialogTestPass.checkListTexts().size()) {
            if (!this._checkList[n].getSelection()) {
                stringBuffer.append("- ").append(stringArray[n]).append("\n");
            }
            ++n;
        }
        FailureDialog failureDialog = new FailureDialog(this.getShell());
        failureDialog.create();
        failureDialog.setText(stringBuffer.toString());
        if (failureDialog.open() == 0) {
            this._failureText = failureDialog.toString();
            this.setReturnCode(3);
            if (this._testDialog.getShell() != null) {
                this._testDialog.close();
            }
            this.close();
        }
    }

    protected void handleShellCloseEvent() {
        this.handleFailure();
    }
}

