/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.tests;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import junit.framework.TestCase;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.testplugin.CProjectHelper;
import org.eclipse.cdt.core.testplugin.FileManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public abstract class BaseTestFramework
extends TestCase {
    protected static NullProgressMonitor monitor;
    protected static IWorkspace workspace;
    protected static IProject project;
    protected static ICProject cproject;
    protected static FileManager fileManager;
    protected static boolean indexDisabled;

    static {
        indexDisabled = false;
    }

    public void disableIndexing() {
    }

    public BaseTestFramework() {
        if (CCorePlugin.getDefault() != null && CCorePlugin.getDefault().getCoreModel() != null) {
            monitor = new NullProgressMonitor();
            workspace = ResourcesPlugin.getWorkspace();
            try {
                cproject = CProjectHelper.createCCProject("RegressionTestProject", "bin");
                project = cproject.getProject();
            }
            catch (CoreException coreException) {}
            if (project == null) {
                BaseTestFramework.fail((String)"Unable to create project");
            }
            fileManager = new FileManager();
        }
    }

    public BaseTestFramework(String string) {
        super(string);
        if (CCorePlugin.getDefault() != null && CCorePlugin.getDefault().getCoreModel() != null) {
            monitor = new NullProgressMonitor();
            workspace = ResourcesPlugin.getWorkspace();
            try {
                cproject = CProjectHelper.createCCProject("RegressionTestProject", "bin");
                project = cproject.getProject();
            }
            catch (CoreException coreException) {}
            if (project == null) {
                BaseTestFramework.fail((String)"Unable to create project");
            }
            fileManager = new FileManager();
        }
    }

    public void cleanupProject() throws Exception {
        try {
            project.delete(true, false, (IProgressMonitor)monitor);
            project = null;
        }
        catch (Throwable throwable) {}
    }

    protected void tearDown() throws Exception {
        if (project == null || !project.exists()) {
            return;
        }
        IResource[] iResourceArray = project.members();
        int n = 0;
        while (n < iResourceArray.length) {
            if (!iResourceArray[n].getName().equals(".project") && !iResourceArray[n].getName().equals(".cdtproject")) {
                try {
                    iResourceArray[n].delete(false, (IProgressMonitor)monitor);
                }
                catch (Throwable throwable) {}
            }
            ++n;
        }
    }

    protected IFile importFile(String string, String string2) throws Exception {
        IFile iFile = project.getProject().getFile(string);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes());
        if (iFile.exists()) {
            iFile.setContents((InputStream)byteArrayInputStream, false, false, (IProgressMonitor)monitor);
        } else {
            iFile.create((InputStream)byteArrayInputStream, false, (IProgressMonitor)monitor);
        }
        fileManager.addFile(iFile);
        return iFile;
    }
}

