/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.pdom.tests;

import java.io.File;
import junit.framework.TestCase;
import org.eclipse.cdt.core.testplugin.CTestPlugin;
import org.eclipse.cdt.internal.core.pdom.db.BTree;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeComparator;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeVisitor;
import org.eclipse.cdt.internal.core.pdom.db.IString;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class DBTest
extends TestCase {
    protected IPath getTestDir() {
        IPath iPath = CTestPlugin.getDefault().getStateLocation().append("tests/");
        File file = iPath.toFile();
        if (!file.exists()) {
            file.mkdir();
        }
        return iPath;
    }

    public void test1() throws Exception {
        File file = this.getTestDir().append("test1.dat").toFile();
        file.delete();
        Database database = new Database(file.getCanonicalPath());
        DBTest.assertEquals((int)0, (int)database.getVersion());
        int n = database.malloc(42);
        DBTest.assertEquals((int)-48, (int)database.getInt(n - 4));
        database.free(n);
        DBTest.assertEquals((int)48, (int)database.getInt(n - 4));
        DBTest.assertEquals((int)(n - 4), (int)database.getInt(12));
        DBTest.assertEquals((int)(n - 4 + 48), (int)database.getInt(4084));
    }

    public void test2() throws Exception {
        File file = this.getTestDir().append("test2.dat").toFile();
        file.delete();
        Database database = new Database(file.getCanonicalPath());
        int n = database.malloc(42);
        int n2 = database.malloc(42);
        database.free(n);
        database.free(n2);
        DBTest.assertEquals((int)(n2 - 4), (int)database.getInt(12));
        DBTest.assertEquals((int)0, (int)database.getInt(n2));
        DBTest.assertEquals((int)(n - 4), (int)database.getInt(n2 + 4));
        DBTest.assertEquals((int)(n2 - 4), (int)database.getInt(n));
        DBTest.assertEquals((int)0, (int)database.getInt(n + 4));
    }

    public void test3() throws Exception {
        File file = this.getTestDir().append("test2.dat").toFile();
        file.delete();
        Database database = new Database(file.getCanonicalPath());
        int n = database.malloc(42);
        database.free(n);
        int n2 = database.malloc(42);
        DBTest.assertEquals((int)n2, (int)n);
    }

    public void testStrings() throws Exception {
        String string;
        File file = this.getTestDir().append("testStrings.dat").toFile();
        file.delete();
        final Database database = new Database(file.getCanonicalPath());
        String[] stringArray = new String[]{"ARLENE", "BRET", "CINDY", "DENNIS", "EMILY", "FRANKLIN", "GERT", "HARVEY", "IRENE", "JOSE", "KATRINA", "LEE", "MARIA", "NATE", "OPHELIA", "PHILIPPE", "RITA", "STAN", "TAMMY", "VINCE", "WILMA", "ALPHA", "BETA"};
        BTree bTree = new BTree(database, 4100);
        int n = 0;
        while (n < stringArray.length) {
            string = stringArray[n];
            int n2 = database.malloc(8);
            database.putInt(n2 + 0, n);
            IString iString = database.newString(string);
            database.putInt(n2 + 4, iString.getRecord());
            bTree.insert(n2, new IBTreeComparator(){

                public int compare(int n, int n2) throws CoreException {
                    IString iString = database.getString(database.getInt(n + 4));
                    IString iString2 = database.getString(database.getInt(n2 + 4));
                    return iString.compare(iString2);
                }
            });
            ++n;
        }
        n = 0;
        while (n < stringArray.length) {
            string = stringArray[n];
            FindVisitor findVisitor = new FindVisitor(database, string);
            bTree.accept((IBTreeVisitor)findVisitor);
            int n3 = findVisitor.getRecord();
            DBTest.assertTrue((n3 != 0 ? 1 : 0) != 0);
            DBTest.assertEquals((int)n, (int)database.getInt(n3));
            IString iString = database.getString(database.getInt(n3 + 4));
            DBTest.assertTrue((boolean)iString.equals(string));
            ++n;
        }
    }

    private static class FindVisitor
    implements IBTreeVisitor {
        private Database db;
        private String key;
        private int record;

        public FindVisitor(Database database, String string) {
            this.db = database;
            this.key = string;
        }

        public int compare(int n) throws CoreException {
            return this.db.getString(this.db.getInt(n + 4)).compare(this.key);
        }

        public boolean visit(int n) throws CoreException {
            this.record = n;
            return false;
        }

        public int getRecord() {
            return this.record;
        }
    }
}

