/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.optional.junit.FormatterElement;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitResultFormatter;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class EclipseTestRunner
implements TestListener {
    public static final int SUCCESS = 0;
    public static final int FAILURES = 1;
    public static final int ERRORS = 2;
    private static final String SUITE_METHODNAME = "suite";
    private boolean debug = false;
    private TestResult fTestResult;
    private String fTestPluginName;
    private Test fSuite;
    private static Vector fgFromCmdLine = new Vector();
    private Vector formatters = new Vector();
    private boolean fHaltOnError = false;
    private boolean fHaltOnFailure = false;
    private JUnitTest fJunitTest;
    private PrintStream fSystemError;
    private PrintStream fSystemOut;
    private Exception fException;
    private int fRetCode = 0;
    static /* synthetic */ Class class$0;

    public static void main(String[] stringArray) throws IOException {
        System.exit(EclipseTestRunner.run(stringArray));
    }

    public static int run(String[] stringArray) throws IOException {
        Object object;
        String string = null;
        String string2 = null;
        boolean bl = false;
        boolean bl2 = false;
        Properties properties = new Properties();
        int n = 0;
        if (stringArray.length > 0 && !stringArray[0].startsWith("-")) {
            string = stringArray[0];
            ++n;
        }
        int n2 = n;
        while (n2 < stringArray.length) {
            if (stringArray[n2].toLowerCase().equals("-classname")) {
                if (n2 < stringArray.length - 1) {
                    string = stringArray[n2 + 1];
                }
                ++n2;
            } else if (stringArray[n2].toLowerCase().equals("-testpluginname")) {
                if (n2 < stringArray.length - 1) {
                    string2 = stringArray[n2 + 1];
                }
                ++n2;
            } else if (stringArray[n2].startsWith("haltOnError=")) {
                bl = Project.toBoolean((String)stringArray[n2].substring(12));
            } else if (stringArray[n2].startsWith("haltOnFailure=")) {
                bl2 = Project.toBoolean((String)stringArray[n2].substring(14));
            } else if (stringArray[n2].startsWith("formatter=")) {
                try {
                    EclipseTestRunner.createAndStoreFormatter(stringArray[n2].substring(10));
                }
                catch (BuildException buildException) {
                    System.err.println(buildException.getMessage());
                    return 2;
                }
            } else if (stringArray[n2].startsWith("propsfile=")) {
                object = new FileInputStream(stringArray[n2].substring(10));
                properties.load((InputStream)object);
                ((FileInputStream)object).close();
            } else if (stringArray[n2].equals("-testlistener")) {
                System.err.println("The -testlistener option is no longer supported\nuse the formatter= option instead");
                return 2;
            }
            ++n2;
        }
        if (string == null) {
            throw new IllegalArgumentException("Test class name not specified");
        }
        JUnitTest jUnitTest = new JUnitTest(string);
        object = System.getProperties();
        Object object2 = ((Hashtable)object).keys();
        while (object2.hasMoreElements()) {
            Object k = object2.nextElement();
            properties.put(k, ((Hashtable)object).get(k));
        }
        jUnitTest.setProperties((Hashtable)properties);
        object2 = new EclipseTestRunner(jUnitTest, string2, bl, bl2);
        EclipseTestRunner.transferFormatters((EclipseTestRunner)object2);
        ((EclipseTestRunner)object2).run();
        return ((EclipseTestRunner)object2).getRetCode();
    }

    public EclipseTestRunner(JUnitTest jUnitTest, String string, boolean bl, boolean bl2) {
        this.fJunitTest = jUnitTest;
        this.fTestPluginName = string;
        this.fHaltOnError = bl;
        this.fHaltOnFailure = bl2;
        try {
            this.fSuite = this.getTest(jUnitTest.getName());
        }
        catch (Exception exception) {
            this.fRetCode = 2;
            this.fException = exception;
        }
    }

    protected Test getTest(String string) throws TestFailedException {
        if (string.length() <= 0) {
            this.clearStatus();
            return null;
        }
        Class clazz = null;
        try {
            clazz = this.loadSuiteClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string2;
            if (classNotFoundException.getCause() != null) {
                this.runFailed(classNotFoundException.getCause());
            }
            if ((string2 = classNotFoundException.getMessage()) == null) {
                string2 = string;
            }
            this.runFailed("Class not found \"" + string2 + "\"");
            return null;
        }
        catch (Exception exception) {
            this.runFailed(exception);
            return null;
        }
        Method method = null;
        try {
            method = clazz.getMethod(SUITE_METHODNAME, new Class[0]);
        }
        catch (Exception exception) {
            this.clearStatus();
            return new TestSuite(clazz);
        }
        Test test = null;
        try {
            test = (Test)method.invoke(null, (Object[])new Class[0]);
            if (test == null) {
                return test;
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            this.runFailed("Failed to invoke suite():" + invocationTargetException.getTargetException().toString());
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            this.runFailed("Failed to invoke suite():" + illegalAccessException.toString());
            return null;
        }
        this.clearStatus();
        return test;
    }

    protected void runFailed(String string) throws TestFailedException {
        System.err.println(string);
        throw new TestFailedException(string);
    }

    protected void runFailed(Throwable throwable) throws TestFailedException {
        throwable.printStackTrace();
        throw new TestFailedException(throwable);
    }

    protected void clearStatus() {
    }

    protected Class loadSuiteClass(String string) throws ClassNotFoundException {
        if (this.fTestPluginName == null) {
            return Class.forName(string);
        }
        Bundle bundle = Platform.getBundle((String)this.fTestPluginName);
        if (bundle == null) {
            throw new ClassNotFoundException(string, new Exception("Could not find plugin \"" + this.fTestPluginName + "\""));
        }
        return bundle.loadClass(string);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block10: {
            long l;
            block9: {
                this.fTestResult = new TestResult();
                this.fTestResult.addListener((TestListener)this);
                int n = 0;
                while (true) {
                    if (n >= this.formatters.size()) {
                        l = System.currentTimeMillis();
                        this.fireStartTestSuite();
                        if (this.fException != null) {
                            break;
                        }
                        break block9;
                    }
                    this.fTestResult.addListener((TestListener)this.formatters.elementAt(n));
                    ++n;
                }
                int n2 = 0;
                while (true) {
                    if (n2 >= this.formatters.size()) {
                        this.fJunitTest.setCounts(1L, 0L, 1L);
                        this.fJunitTest.setRunTime(0L);
                        break block10;
                    }
                    ((TestListener)this.formatters.elementAt(n2)).addError(null, (Throwable)this.fException);
                    ++n2;
                }
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.fSystemError = new PrintStream(byteArrayOutputStream);
            ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
            this.fSystemOut = new PrintStream(byteArrayOutputStream2);
            try {
                this.fSuite.run(this.fTestResult);
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.fSystemError.close();
                this.fSystemError = null;
                this.fSystemOut.close();
                this.fSystemOut = null;
                this.sendOutAndErr(new String(byteArrayOutputStream2.toByteArray()), new String(byteArrayOutputStream.toByteArray()));
                this.fJunitTest.setCounts((long)this.fTestResult.runCount(), (long)this.fTestResult.failureCount(), (long)this.fTestResult.errorCount());
                this.fJunitTest.setRunTime(System.currentTimeMillis() - l);
                throw throwable;
            }
            {
                Object var5_8 = null;
                this.fSystemError.close();
                this.fSystemError = null;
                this.fSystemOut.close();
                this.fSystemOut = null;
                this.sendOutAndErr(new String(byteArrayOutputStream2.toByteArray()), new String(byteArrayOutputStream.toByteArray()));
            }
            this.fJunitTest.setCounts((long)this.fTestResult.runCount(), (long)this.fTestResult.failureCount(), (long)this.fTestResult.errorCount());
            this.fJunitTest.setRunTime(System.currentTimeMillis() - l);
        }
        this.fireEndTestSuite();
        if (this.fRetCode == 0 && this.fTestResult.errorCount() == 0) {
            if (this.fTestResult.failureCount() == 0) return;
            this.fRetCode = 1;
            return;
        }
        this.fRetCode = 2;
    }

    public int getRetCode() {
        return this.fRetCode;
    }

    public void startTest(Test test) {
    }

    public void endTest(Test test) {
    }

    public void addFailure(Test test, AssertionFailedError assertionFailedError) {
        if (this.fHaltOnFailure) {
            this.fTestResult.stop();
        }
    }

    public void addError(Test test, Throwable throwable) {
        if (this.fHaltOnError) {
            this.fTestResult.stop();
        }
    }

    private void fireStartTestSuite() {
        int n = 0;
        while (n < this.formatters.size()) {
            ((JUnitResultFormatter)this.formatters.elementAt(n)).startTestSuite(this.fJunitTest);
            ++n;
        }
    }

    private void fireEndTestSuite() {
        int n = 0;
        while (n < this.formatters.size()) {
            ((JUnitResultFormatter)this.formatters.elementAt(n)).endTestSuite(this.fJunitTest);
            ++n;
        }
    }

    public void addFormatter(JUnitResultFormatter jUnitResultFormatter) {
        this.formatters.addElement(jUnitResultFormatter);
    }

    private static void createAndStoreFormatter(String string) throws BuildException {
        new FormatterElement();
        String string2 = null;
        File file = null;
        int n = string.indexOf(44);
        if (n == -1) {
            string2 = string;
        } else {
            string2 = string.substring(0, n);
            file = new File(string.substring(n + 1));
        }
        fgFromCmdLine.addElement(EclipseTestRunner.createFormatter(string2, file));
    }

    private static void transferFormatters(EclipseTestRunner eclipseTestRunner) {
        int n = 0;
        while (n < fgFromCmdLine.size()) {
            eclipseTestRunner.addFormatter((JUnitResultFormatter)fgFromCmdLine.elementAt(n));
            ++n;
        }
    }

    private static JUnitResultFormatter createFormatter(String string, File file) throws BuildException {
        OutputStream outputStream = System.out;
        if (string == null) {
            throw new BuildException("you must specify type or classname");
        }
        Class<?> clazz = null;
        try {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.test.EclipseTestRunner");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            clazz = clazz2.getClassLoader().loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new BuildException((Throwable)classNotFoundException);
        }
        Object var4_5 = null;
        try {
            var4_5 = clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new BuildException((Throwable)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new BuildException((Throwable)illegalAccessException);
        }
        if (!(var4_5 instanceof JUnitResultFormatter)) {
            throw new BuildException(String.valueOf(string) + " is not a JUnitResultFormatter");
        }
        JUnitResultFormatter jUnitResultFormatter = var4_5;
        if (file != null) {
            try {
                outputStream = new FileOutputStream(file);
            }
            catch (IOException iOException) {
                throw new BuildException((Throwable)iOException);
            }
        }
        jUnitResultFormatter.setOutput(outputStream);
        return jUnitResultFormatter;
    }

    private void sendOutAndErr(String string, String string2) {
        int n = 0;
        while (n < this.formatters.size()) {
            JUnitResultFormatter jUnitResultFormatter = (JUnitResultFormatter)this.formatters.elementAt(n);
            jUnitResultFormatter.setSystemOutput(string);
            jUnitResultFormatter.setSystemError(string2);
            ++n;
        }
    }

    protected void handleOutput(String string) {
        if (this.fSystemOut != null) {
            this.fSystemOut.println(string);
        }
    }

    protected void handleErrorOutput(String string) {
        if (this.fSystemError != null) {
            this.fSystemError.println(string);
        }
    }

    class TestFailedException
    extends Exception {
        private static final long serialVersionUID = 6009335074727417445L;

        TestFailedException(String string) {
            super(string);
        }

        TestFailedException(Throwable throwable) {
            super(throwable);
        }
    }
}

