/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.testplugin;

import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;

public class Main {
    protected boolean debug = false;
    protected String bootLocation = null;
    protected String application;
    protected URL pluginPathLocation;
    protected String location;
    protected boolean uninstall = false;
    protected String uninstallCookie;
    protected String devClassPath = null;
    protected boolean inDevelopmentMode = false;
    private static String endSplash = null;
    private static final String APPLICATION = "-application";
    private static final String BOOT = "-boot";
    private static final String DEBUG = "-debug";
    private static final String DEV = "-dev";
    private static final String ENDSPLASH = "-endsplash";
    private static final String UNINSTALL = "-uninstall";
    private static final String PI_BOOT = "org.eclipse.core.boot";
    private static final String BOOTLOADER = "org.eclipse.core.boot.BootLoader";
    private static final String UPDATELOADER = "org.eclipse.core.internal.boot.LaunchInfo";
    private static final String PROJECT_NAME = "Eclipse Core Boot";
    private static boolean inVAJ;
    private static boolean inVAME;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        try {
            Class.forName("com.ibm.uvm.lang.ProjectClassLoader");
            inVAJ = true;
        }
        catch (Exception exception) {
            inVAJ = false;
        }
        try {
            Class.forName("com.ibm.eclipse.core.VAME");
            inVAME = true;
        }
        catch (Exception exception) {
            inVAME = false;
        }
    }

    protected Object basicRun(String[] stringArray) throws Exception {
        Class clazz = this.getBootLoader(this.bootLocation);
        Class[] classArray = new Class[4];
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz2;
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("java.net.URL");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz3;
        Class<?> clazz4 = class$0;
        if (clazz4 == null) {
            try {
                clazz4 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[2] = clazz4;
        Class<?> clazz5 = class$2;
        if (clazz5 == null) {
            try {
                clazz5 = class$2 = Class.forName("[Ljava.lang.String;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[3] = clazz5;
        Method method = clazz.getDeclaredMethod("run", classArray);
        try {
            return method.invoke((Object)clazz, this.application, this.pluginPathLocation, this.location, stringArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof Error) {
                throw (Error)invocationTargetException.getTargetException();
            }
            throw invocationTargetException;
        }
    }

    private String[] getArrayFromList(String string) {
        if (string == null || string.trim().equals("")) {
            return new String[0];
        }
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.equals("")) continue;
            vector.addElement(string2);
        }
        return vector.isEmpty() ? new String[]{} : vector.toArray(new String[0]);
    }

    public Class getBootLoader(String string) throws Exception {
        URLClassLoader uRLClassLoader = new URLClassLoader(this.getBootPath(string), null);
        return uRLClassLoader.loadClass(BOOTLOADER);
    }

    protected URL[] getDevPath(URL uRL) throws MalformedURLException {
        URL uRL2;
        String string = uRL.toExternalForm();
        if (!this.inDevelopmentMode) {
            URL uRL3 = new URL(String.valueOf(string) + "boot.jar");
            return new URL[]{uRL3};
        }
        String[] stringArray = this.getArrayFromList(this.devClassPath);
        ArrayList<URL> arrayList = new ArrayList<URL>(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            String string2 = String.valueOf(string) + stringArray[n];
            char c = string2.charAt(string2.length() - 1);
            uRL2 = string2.endsWith(".jar") || c == '/' || c == '\\' ? new URL(string2) : new URL(String.valueOf(string2) + "/");
            if (new File(uRL2.getFile()).exists()) {
                arrayList.add(uRL2);
            }
            ++n;
        }
        uRL2 = new URL(String.valueOf(string) + "boot.jar");
        if (new File(uRL2.getFile()).exists()) {
            arrayList.add(uRL2);
        }
        return arrayList.toArray(new URL[arrayList.size()]);
    }

    protected URL[] getBootPath(String string) throws MalformedURLException {
        int n;
        URL uRL = null;
        if (string != null) {
            uRL = new URL(string);
            if (this.debug) {
                System.out.println("Boot URL: " + uRL.toExternalForm());
            }
            return new URL[]{uRL};
        }
        URL[] uRLArray = null;
        uRL = this.getClass().getProtectionDomain().getCodeSource().getLocation();
        String string2 = uRL.getFile();
        if (string2.endsWith(".jar")) {
            string2 = string2.substring(0, string2.lastIndexOf("/"));
        } else if (string2.endsWith("/")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if (inVAJ || inVAME) {
            n = string2.lastIndexOf("/");
            string2 = string2.substring(0, n + 1);
            string2 = String.valueOf(string2) + PROJECT_NAME + "/";
            uRL = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), string2);
            uRLArray = new URL[]{uRL};
        } else {
            string2 = this.searchForPlugins(string2);
            string2 = this.searchForBoot(string2);
            uRL = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), string2);
            uRLArray = this.getDevPath(uRL);
        }
        if (this.debug) {
            System.out.println("Boot URL:");
            n = 0;
            while (n < uRLArray.length) {
                System.out.println("    " + uRLArray[n].toExternalForm());
                ++n;
            }
        }
        return uRLArray;
    }

    protected String searchForPlugins(String string) {
        File file = new File(string);
        while (file != null) {
            File file2 = new File(file, "plugins");
            if (file2.exists()) {
                return file2.toString();
            }
            File file3 = file = (file = file.getParentFile()) == null || file.length() == 1L ? null : file;
        }
        return "";
    }

    protected String searchForBoot(String string) {
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                return file.getName().startsWith(Main.PI_BOOT);
            }
        };
        File[] fileArray = new File(string).listFiles(fileFilter);
        String string2 = null;
        String string3 = null;
        int n = 0;
        while (n < fileArray.length) {
            String string4 = fileArray[n].getName();
            int n2 = string4.lastIndexOf(95);
            if (n2 == -1) {
                string2 = fileArray[n].getAbsolutePath();
                n = fileArray.length;
            } else if (n2 > 0) {
                String string5 = string4.substring(n2 + 1);
                if (string3 == null) {
                    string2 = fileArray[n].getAbsolutePath();
                    string3 = string5;
                } else if (string3.compareTo(string5) == -1) {
                    string2 = fileArray[n].getAbsolutePath();
                    string3 = string5;
                }
            }
            ++n;
        }
        if (string2 == null) {
            throw new RuntimeException("Could not find bootstrap code. Check location of boot plug-in or specify -boot.");
        }
        return String.valueOf(string2.replace(File.separatorChar, '/')) + "/";
    }

    public Class getUpdateLoader(String string) throws Exception {
        URLClassLoader uRLClassLoader = new URLClassLoader(this.getBootPath(string), null);
        return uRLClassLoader.loadClass(UPDATELOADER);
    }

    public static void main(String[] stringArray) {
        Object object = null;
        try {
            object = new Main().run(stringArray);
        }
        catch (Throwable throwable) {
            Main.endSplash();
            System.out.println("Exception launching the Eclipse Platform:");
            throwable.printStackTrace();
        }
        int n = object instanceof Integer ? (Integer)object : 0;
        System.exit(n);
    }

    public static void endSplash() {
        if (endSplash == null) {
            return;
        }
        try {
            Runtime.getRuntime().exec(endSplash);
        }
        catch (Exception exception) {}
    }

    public static void main(String string) throws Exception {
        Vector<Object> vector = new Vector<Object>(5);
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreElements()) {
            vector.addElement(stringTokenizer.nextElement());
        }
        Main.main(vector.toArray(new String[vector.size()]));
    }

    protected String[] processCommandLine(String[] stringArray) throws Exception {
        int n;
        int[] nArray = new int[100];
        nArray[0] = -1;
        int n2 = 0;
        int n3 = 0;
        while (n3 < stringArray.length) {
            n = 0;
            if (stringArray[n3].equalsIgnoreCase(DEBUG)) {
                this.debug = true;
            } else if (stringArray[n3].equalsIgnoreCase(DEV) && (n3 + 1 == stringArray.length || n3 + 1 < stringArray.length && stringArray[n3 + 1].startsWith("-"))) {
                this.inDevelopmentMode = true;
            } else if (n != 0) {
                nArray[n2++] = n3;
            } else if (n3 != stringArray.length - 1 && !stringArray[n3 + 1].startsWith("-")) {
                String string = stringArray[++n3];
                if (stringArray[n3 - 1].equalsIgnoreCase(BOOT)) {
                    this.bootLocation = string;
                    n = 1;
                }
                if (stringArray[n3 - 1].equalsIgnoreCase(DEV)) {
                    this.inDevelopmentMode = true;
                    this.devClassPath = string;
                } else {
                    if (stringArray[n3 - 1].equalsIgnoreCase(APPLICATION)) {
                        this.application = string;
                        n = 1;
                    }
                    if (stringArray[n3 - 1].equalsIgnoreCase(ENDSPLASH)) {
                        endSplash = string;
                    } else {
                        if (stringArray[n3 - 1].equalsIgnoreCase(UNINSTALL)) {
                            this.uninstall = true;
                            this.uninstallCookie = string;
                            n = 1;
                        }
                        if (n != 0) {
                            nArray[n2++] = n3 - 1;
                            nArray[n2++] = n3;
                        }
                    }
                }
            }
            ++n3;
        }
        if (n2 == 0) {
            return stringArray;
        }
        String[] stringArray2 = new String[stringArray.length - n2];
        n2 = 0;
        n = 0;
        int n4 = 0;
        while (n4 < stringArray.length) {
            if (n4 == nArray[n2]) {
                ++n2;
            } else {
                stringArray2[n++] = stringArray[n4];
            }
            ++n4;
        }
        return stringArray2;
    }

    public Object run(String[] stringArray) throws Exception {
        String[] stringArray2 = this.processCommandLine(stringArray);
        if (this.uninstall) {
            return this.updateRun(UNINSTALL, this.uninstallCookie, stringArray2);
        }
        return this.basicRun(stringArray2);
    }

    protected Object updateRun(String string, String string2, String[] stringArray) throws Exception {
        Class clazz = this.getUpdateLoader(this.bootLocation);
        Class[] classArray = new Class[4];
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz2;
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz3;
        Class<?> clazz4 = class$0;
        if (clazz4 == null) {
            try {
                clazz4 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[2] = clazz4;
        Class<?> clazz5 = class$2;
        if (clazz5 == null) {
            try {
                clazz5 = class$2 = Class.forName("[Ljava.lang.String;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[3] = clazz5;
        Method method = clazz.getDeclaredMethod("run", classArray);
        try {
            return method.invoke((Object)clazz, string, string2, this.location, stringArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof Error) {
                throw (Error)invocationTargetException.getTargetException();
            }
            throw invocationTargetException;
        }
    }
}

