/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.tests.DOMAST;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import org.eclipse.cdt.ui.tests.DOMAST.FindIASTNameTarget;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IFindReplaceTargetExtension;
import org.eclipse.jface.text.IFindReplaceTargetExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.texteditor.TextEditorPlugin;
import org.eclipse.ui.texteditor.IEditorStatusLine;

class FindIASTNameDialog
extends Dialog {
    private static final String REGULAR_EXPRESSIONS_LABEL = "Regular expressions";
    private static final String WHOLE_WORD_LABEL = "Whole Word";
    private static final String CASE_SENSITIVE_LABEL = "Case Sensitive";
    private static final String OPTIONS_LABEL = "Options";
    private static final String BLANK_STRING = "";
    private static final String NAME_NOT_FOUND = "Name not found.";
    private static final String FIND_NEXT_LABEL = "Find Next";
    private static final String FIND_IASTNAME_LABEL = "Find IASTName:";
    private static final int HISTORY_SIZE = 5;
    protected boolean searchTextChanged = false;
    private Point fLocation;
    private Point fIncrementalBaseLocation;
    private boolean fWrapInit;
    private boolean fCaseInit;
    private boolean fWholeWordInit;
    private boolean fForwardInit;
    private boolean fGlobalInit;
    private boolean fIncrementalInit;
    private boolean fNeedsInitialFindBeforeReplace;
    boolean fIsRegExInit;
    private List fFindHistory;
    private IRegion fOldScope;
    private IFindReplaceTarget fTarget;
    private Shell fParentShell = null;
    private Shell fActiveShell;
    private final ActivationListener fActivationListener = new ActivationListener();
    private final ModifyListener fFindModifyListener = new FindModifyListener();
    private Label fStatusLabel;
    private Button fForwardRadioButton;
    private Button fGlobalRadioButton;
    private Button fSelectedRangeRadioButton;
    private Button fCaseCheckBox;
    private Button fWrapCheckBox;
    private Button fWholeWordCheckBox;
    private Button fIncrementalCheckBox;
    private Button fIsRegExCheckBox;
    private Button fFindNextButton;
    Combo fFindField;
    Combo fReplaceField;
    private Rectangle fDialogPositionInit;
    private IDialogSettings fDialogSettings;
    private boolean fIsTargetSupportingRegEx;
    private boolean fUseSelectedLines;
    private boolean fGiveFocusToFindField = true;
    static /* synthetic */ Class class$0;

    public FindIASTNameDialog(Shell shell, IFindReplaceTarget iFindReplaceTarget) {
        super(shell);
        this.updateTarget(iFindReplaceTarget, false);
        this.fDialogPositionInit = null;
        this.fFindHistory = new ArrayList(4);
        this.fWrapInit = false;
        this.fCaseInit = false;
        this.fIsRegExInit = false;
        this.fWholeWordInit = false;
        this.fIncrementalInit = false;
        this.fGlobalInit = true;
        this.fForwardInit = true;
        this.readConfiguration();
        this.setShellStyle(2144);
        this.setBlockOnOpen(false);
    }

    public Shell getParentShell() {
        return super.getParentShell();
    }

    private boolean okToUse(Control control) {
        return control != null && !control.isDisposed();
    }

    public void create() {
        super.create();
        Shell shell = this.getShell();
        shell.addShellListener((ShellListener)this.fActivationListener);
        if (this.fLocation != null) {
            shell.setLocation(this.fLocation);
        }
        this.fFindField.removeModifyListener(this.fFindModifyListener);
        this.updateCombo(this.fFindField, this.fFindHistory);
        this.fFindField.addModifyListener(this.fFindModifyListener);
        this.initFindStringFromSelection();
        if (this.fDialogPositionInit != null) {
            shell.setBounds(this.fDialogPositionInit);
        }
        shell.setText(FIND_IASTNAME_LABEL);
    }

    private Composite createButtonSection(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        this.fFindNextButton = this.makeButton(composite2, FIND_NEXT_LABEL, 102, true, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (FindIASTNameDialog.this.fTarget instanceof FindIASTNameTarget && FindIASTNameDialog.this.searchTextChanged) {
                    ((FindIASTNameTarget)FindIASTNameDialog.this.fTarget).clearMatchingNames();
                    FindIASTNameDialog.this.searchTextChanged = false;
                }
                if (FindIASTNameDialog.this.isIncrementalSearch() && !FindIASTNameDialog.this.isRegExSearchAvailableAndChecked()) {
                    FindIASTNameDialog.this.initIncrementalBaseLocation();
                }
                FindIASTNameDialog.this.fNeedsInitialFindBeforeReplace = false;
                FindIASTNameDialog.this.performSearch();
                FindIASTNameDialog.this.updateFindHistory();
                FindIASTNameDialog.this.fFindNextButton.setFocus();
            }
        });
        this.setGridData((Control)this.fFindNextButton, 4, true, 4, false);
        return composite2;
    }

    private Composite createConfigPanel(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        Composite composite3 = this.createDirectionGroup(composite2);
        this.setGridData((Control)composite3, 4, true, 4, false);
        Composite composite4 = this.createOptionsGroup(composite2);
        this.setGridData((Control)composite4, 4, true, 4, false);
        GridData gridData = (GridData)composite4.getLayoutData();
        gridData.horizontalSpan = 2;
        composite4.setLayoutData((Object)gridData);
        return composite2;
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.makeColumnsEqualWidth = true;
        composite2.setLayout((Layout)gridLayout);
        Composite composite3 = this.createInputPanel(composite2);
        this.setGridData((Control)composite3, 4, true, 2, false);
        Composite composite4 = this.createConfigPanel(composite2);
        this.setGridData((Control)composite4, 4, true, 2, true);
        Composite composite5 = this.createButtonSection(composite2);
        this.setGridData((Control)composite5, 4, true, 2, false);
        Composite composite6 = this.createStatusAndCloseButton(composite2);
        this.setGridData((Control)composite6, 4, true, 2, false);
        this.updateButtonState();
        FindIASTNameDialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    private Composite createDirectionGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        Group group = new Group(composite2, 16);
        group.setText("Direction");
        GridLayout gridLayout2 = new GridLayout();
        group.setLayout((Layout)gridLayout2);
        group.setLayoutData((Object)new GridData(1808));
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (FindIASTNameDialog.this.isIncrementalSearch() && !FindIASTNameDialog.this.isRegExSearchAvailableAndChecked()) {
                    FindIASTNameDialog.this.initIncrementalBaseLocation();
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        };
        this.fForwardRadioButton = new Button((Composite)group, 16400);
        this.fForwardRadioButton.setText("Forward");
        this.setGridData((Control)this.fForwardRadioButton, 1, false, 2, false);
        this.fForwardRadioButton.addSelectionListener(selectionListener);
        Button button = new Button((Composite)group, 16400);
        button.setText("Backward");
        this.setGridData((Control)button, 1, false, 2, false);
        button.addSelectionListener(selectionListener);
        button.setSelection(!this.fForwardInit);
        this.fForwardRadioButton.setSelection(this.fForwardInit);
        return composite2;
    }

    private void useSelectedLines(boolean bl) {
        if (this.isIncrementalSearch() && !this.isRegExSearchAvailableAndChecked()) {
            this.initIncrementalBaseLocation();
        }
        if (this.fTarget == null || !(this.fTarget instanceof IFindReplaceTargetExtension)) {
            return;
        }
        IFindReplaceTargetExtension iFindReplaceTargetExtension = (IFindReplaceTargetExtension)this.fTarget;
        if (bl) {
            IRegion iRegion;
            if (this.fOldScope == null) {
                Point point = iFindReplaceTargetExtension.getLineSelection();
                iRegion = new Region(point.x, point.y);
            } else {
                iRegion = this.fOldScope;
                this.fOldScope = null;
            }
            int n = this.isForwardSearch() ? iRegion.getOffset() : iRegion.getOffset() + iRegion.getLength();
            iFindReplaceTargetExtension.setSelection(n, 0);
            iFindReplaceTargetExtension.setScope(iRegion);
        } else {
            this.fOldScope = iFindReplaceTargetExtension.getScope();
            iFindReplaceTargetExtension.setScope(null);
        }
    }

    private Composite createInputPanel(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 16384);
        label.setText("Find Name:");
        this.setGridData((Control)label, 1, false, 2, false);
        this.fFindField = new Combo(composite2, 2052);
        this.setGridData((Control)this.fFindField, 4, true, 2, false);
        this.fFindField.addModifyListener(this.fFindModifyListener);
        return composite2;
    }

    private Composite createOptionsGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        Group group = new Group(composite2, 32);
        group.setText(OPTIONS_LABEL);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 2;
        gridLayout2.makeColumnsEqualWidth = true;
        group.setLayout((Layout)gridLayout2);
        group.setLayoutData((Object)new GridData(1808));
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FindIASTNameDialog.this.storeSettings();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        };
        this.fCaseCheckBox = new Button((Composite)group, 16416);
        this.fCaseCheckBox.setText(CASE_SENSITIVE_LABEL);
        this.setGridData((Control)this.fCaseCheckBox, 1, false, 2, false);
        this.fCaseCheckBox.setSelection(this.fCaseInit);
        this.fCaseCheckBox.addSelectionListener(selectionListener);
        this.fWholeWordCheckBox = new Button((Composite)group, 16416);
        this.fWholeWordCheckBox.setText(WHOLE_WORD_LABEL);
        this.setGridData((Control)this.fWholeWordCheckBox, 1, false, 2, false);
        this.fWholeWordCheckBox.setSelection(this.fWholeWordInit);
        this.fWholeWordCheckBox.addSelectionListener(selectionListener);
        this.fIsRegExCheckBox = new Button((Composite)group, 16416);
        this.fIsRegExCheckBox.setText(REGULAR_EXPRESSIONS_LABEL);
        this.setGridData((Control)this.fIsRegExCheckBox, 1, false, 2, false);
        ((GridData)this.fIsRegExCheckBox.getLayoutData()).horizontalSpan = 2;
        this.fIsRegExCheckBox.setSelection(this.fIsRegExInit);
        this.fIsRegExCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FindIASTNameDialog.this.fIsRegExCheckBox.getSelection();
                if (FindIASTNameDialog.this.fTarget instanceof FindIASTNameTarget) {
                    ((FindIASTNameTarget)FindIASTNameDialog.this.fTarget).clearMatchingNames();
                }
                FindIASTNameDialog.this.updateButtonState();
                FindIASTNameDialog.this.storeSettings();
            }
        });
        this.fWholeWordCheckBox.setEnabled(!this.isRegExSearchAvailableAndChecked());
        this.fWholeWordCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (FindIASTNameDialog.this.fTarget instanceof FindIASTNameTarget) {
                    ((FindIASTNameTarget)FindIASTNameDialog.this.fTarget).clearMatchingNames();
                }
                FindIASTNameDialog.this.updateButtonState();
            }
        });
        return composite2;
    }

    private Composite createStatusAndCloseButton(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        this.fStatusLabel = new Label(composite2, 16384);
        this.setGridData((Control)this.fStatusLabel, 4, true, 2, false);
        String string = "Close";
        Button button = this.createButton(composite2, 101, string, false);
        this.setGridData((Control)button, 3, false, 3, false);
        return composite2;
    }

    protected void buttonPressed(int n) {
        if (n == 101) {
            this.close();
        }
    }

    private int findIndex(String string, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        if (bl) {
            if (bl3) {
                int n2 = this.findAndSelect(n, string, true, bl2, bl4, bl5);
                if (n2 == -1) {
                    if (this.okToUse((Control)this.getShell()) && !this.isIncrementalSearch()) {
                        this.getShell().getDisplay().beep();
                    }
                    n2 = this.findAndSelect(-1, string, true, bl2, bl4, bl5);
                }
                return n2;
            }
            return this.findAndSelect(n, string, true, bl2, bl4, bl5);
        }
        if (bl3) {
            int n3 = this.findAndSelect(n - 1, string, false, bl2, bl4, bl5);
            if (n3 == -1) {
                if (this.okToUse((Control)this.getShell()) && !this.isIncrementalSearch()) {
                    this.getShell().getDisplay().beep();
                }
                n3 = this.findAndSelect(-1, string, false, bl2, bl4, bl5);
            }
            return n3;
        }
        return this.findAndSelect(n - 1, string, false, bl2, bl4, bl5);
    }

    private int findAndSelect(int n, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (this.fTarget instanceof IFindReplaceTargetExtension3) {
            return ((IFindReplaceTargetExtension3)this.fTarget).findAndSelect(n, string, bl, bl2, bl3, bl4);
        }
        return this.fTarget.findAndSelect(n, string, bl, bl2, bl3);
    }

    Point replaceSelection(String string, boolean bl) {
        if (this.fTarget instanceof IFindReplaceTargetExtension3) {
            ((IFindReplaceTargetExtension3)this.fTarget).replaceSelection(string, bl);
        } else {
            this.fTarget.replaceSelection(string);
        }
        return this.fTarget.getSelection();
    }

    private boolean findNext(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        if (this.fTarget == null) {
            return false;
        }
        Point point = null;
        point = bl5 ? this.fIncrementalBaseLocation : this.fTarget.getSelection();
        int n = point.x;
        if (bl && !this.fNeedsInitialFindBeforeReplace || !bl && this.fNeedsInitialFindBeforeReplace) {
            n += point.y;
        }
        this.fNeedsInitialFindBeforeReplace = false;
        int n2 = this.findIndex(string, n, bl, bl2, bl3, bl4, bl6);
        return n2 != -1;
    }

    private Rectangle getDialogBoundaries() {
        if (this.okToUse((Control)this.getShell())) {
            return this.getShell().getBounds();
        }
        return this.fDialogPositionInit;
    }

    private List getFindHistory() {
        return this.fFindHistory;
    }

    private String getFindString() {
        if (this.okToUse((Control)this.fFindField)) {
            return this.fFindField.getText();
        }
        return BLANK_STRING;
    }

    private String getSelectionString() {
        String string = this.fTarget.getSelectionText();
        if (string != null && string.length() > 0) {
            int[] nArray = TextUtilities.indexOf((String[])TextUtilities.DELIMITERS, (String)string, (int)0);
            if (nArray[0] > 0) {
                return string.substring(0, nArray[0]);
            }
            if (nArray[0] == -1) {
                return string;
            }
        }
        return null;
    }

    public boolean close() {
        this.handleDialogClose();
        return super.close();
    }

    private void handleDialogClose() {
        if (this.okToUse((Control)this.fFindField)) {
            this.fFindField.removeModifyListener(this.fFindModifyListener);
        }
        if (this.fParentShell != null) {
            this.fParentShell.removeShellListener((ShellListener)this.fActivationListener);
            this.fParentShell = null;
        }
        this.getShell().removeShellListener((ShellListener)this.fActivationListener);
        this.storeSettings();
        if (this.fTarget != null && this.fTarget instanceof IFindReplaceTargetExtension) {
            ((IFindReplaceTargetExtension)this.fTarget).endSession();
        }
        this.fActiveShell = null;
        this.fTarget = null;
    }

    private void writeSelection() {
        if (this.fTarget == null) {
            return;
        }
        String string = this.fTarget.getSelectionText();
        if (string == null) {
            string = BLANK_STRING;
        }
        IDialogSettings iDialogSettings = this.getDialogSettings();
        iDialogSettings.put("selection", string);
    }

    private void storeSettings() {
        this.fDialogPositionInit = this.getDialogBoundaries();
        this.fWrapInit = this.isWrapSearch();
        this.fWholeWordInit = this.isWholeWordSetting();
        this.fCaseInit = this.isCaseSensitiveSearch();
        this.fIsRegExInit = this.isRegExSearch();
        this.fIncrementalInit = this.isIncrementalSearch();
        this.fForwardInit = this.isForwardSearch();
        this.writeConfiguration();
    }

    private void initFindStringFromSelection() {
        if (this.fTarget != null && this.okToUse((Control)this.fFindField)) {
            String string = this.getSelectionString();
            this.fFindField.removeModifyListener(this.fFindModifyListener);
            if (string != null) {
                this.fFindField.setText(string);
                if (!string.equals(this.fTarget.getSelectionText())) {
                    this.useSelectedLines(true);
                    this.fGlobalRadioButton.setSelection(false);
                    this.fSelectedRangeRadioButton.setSelection(true);
                    this.fUseSelectedLines = true;
                }
            } else if (BLANK_STRING.equals(this.fFindField.getText())) {
                if (this.fFindHistory.size() > 0) {
                    this.fFindField.setText((String)this.fFindHistory.get(0));
                } else {
                    this.fFindField.setText(BLANK_STRING);
                }
            }
            this.fFindField.setSelection(new Point(0, this.fFindField.getText().length()));
            this.fFindField.addModifyListener(this.fFindModifyListener);
        }
    }

    private void initIncrementalBaseLocation() {
        this.fIncrementalBaseLocation = this.fTarget != null && this.isIncrementalSearch() && !this.isRegExSearchAvailableAndChecked() ? this.fTarget.getSelection() : new Point(0, 0);
    }

    private boolean isCaseSensitiveSearch() {
        if (this.okToUse((Control)this.fCaseCheckBox)) {
            return this.fCaseCheckBox.getSelection();
        }
        return this.fCaseInit;
    }

    private boolean isRegExSearch() {
        if (this.okToUse((Control)this.fIsRegExCheckBox)) {
            return this.fIsRegExCheckBox.getSelection();
        }
        return this.fIsRegExInit;
    }

    private boolean isRegExSearchAvailableAndChecked() {
        if (this.okToUse((Control)this.fIsRegExCheckBox)) {
            return this.fIsTargetSupportingRegEx && this.fIsRegExCheckBox.getSelection();
        }
        return this.fIsRegExInit;
    }

    private boolean isForwardSearch() {
        if (this.okToUse((Control)this.fForwardRadioButton)) {
            return this.fForwardRadioButton.getSelection();
        }
        return this.fForwardInit;
    }

    private boolean isWholeWordSetting() {
        if (this.okToUse((Control)this.fWholeWordCheckBox)) {
            return this.fWholeWordCheckBox.getSelection();
        }
        return this.fWholeWordInit;
    }

    private boolean isWholeWordSearch() {
        return this.isWholeWordSetting() && !this.isRegExSearchAvailableAndChecked() && (!this.okToUse((Control)this.fWholeWordCheckBox) || this.fWholeWordCheckBox.isEnabled());
    }

    private boolean isWrapSearch() {
        if (this.okToUse((Control)this.fWrapCheckBox)) {
            return this.fWrapCheckBox.getSelection();
        }
        return this.fWrapInit;
    }

    private boolean isIncrementalSearch() {
        if (this.okToUse((Control)this.fIncrementalCheckBox)) {
            return this.fIncrementalCheckBox.getSelection();
        }
        return this.fIncrementalInit;
    }

    private Button makeButton(Composite composite, String string, int n, boolean bl, SelectionListener selectionListener) {
        Button button = this.createButton(composite, n, string, bl);
        button.addSelectionListener(selectionListener);
        return button;
    }

    private IEditorStatusLine getStatusLineManager() {
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow == null) {
            return null;
        }
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
        if (iWorkbenchPage == null) {
            return null;
        }
        IEditorPart iEditorPart = iWorkbenchPage.getActiveEditor();
        if (iEditorPart == null) {
            return null;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.IEditorStatusLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IEditorStatusLine)iEditorPart.getAdapter((Class)clazz);
    }

    private void statusMessage(boolean bl, String string) {
        this.fStatusLabel.setText(string);
        if (bl) {
            this.fStatusLabel.setForeground(JFaceColors.getErrorText((Display)this.fStatusLabel.getDisplay()));
        } else {
            this.fStatusLabel.setForeground(null);
        }
        IEditorStatusLine iEditorStatusLine = this.getStatusLineManager();
        if (iEditorStatusLine != null) {
            iEditorStatusLine.setMessage(bl, string, null);
        }
        if (bl) {
            this.getShell().getDisplay().beep();
        }
    }

    private void statusError(String string) {
        this.statusMessage(true, string);
    }

    private void statusMessage(String string) {
        this.statusMessage(false, string);
    }

    private void performSearch() {
        this.performSearch(this.isIncrementalSearch() && !this.isRegExSearchAvailableAndChecked());
    }

    private void performSearch(boolean bl) {
        String string;
        if (bl) {
            this.initIncrementalBaseLocation();
        }
        if ((string = this.getFindString()) != null && string.length() > 0) {
            try {
                boolean bl2 = this.findNext(string, this.isForwardSearch(), this.isCaseSensitiveSearch(), this.isWrapSearch(), this.isWholeWordSearch(), this.isIncrementalSearch() && !this.isRegExSearchAvailableAndChecked(), this.isRegExSearchAvailableAndChecked());
                if (bl2) {
                    this.statusMessage(BLANK_STRING);
                } else {
                    this.statusMessage(NAME_NOT_FOUND);
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                this.statusError(patternSyntaxException.getLocalizedMessage());
            }
            catch (IllegalStateException illegalStateException) {}
        }
        this.writeSelection();
        this.updateButtonState();
    }

    private void setGridData(Control control, int n, boolean bl, int n2, boolean bl2) {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = n;
        gridData.grabExcessHorizontalSpace = bl;
        gridData.verticalAlignment = n2;
        gridData.grabExcessVerticalSpace = bl2;
        control.setLayoutData((Object)gridData);
    }

    private void updateButtonState() {
        if (this.okToUse((Control)this.getShell()) && this.okToUse((Control)this.fFindNextButton)) {
            boolean bl = this.fTarget != null && (this.fActiveShell == this.fParentShell || this.fActiveShell == this.getShell());
            String string = this.getFindString();
            boolean bl2 = string != null && string.length() > 0;
            boolean bl3 = this.isWord(string) && !this.isRegExSearchAvailableAndChecked();
            this.fWholeWordCheckBox.setEnabled(bl3);
            this.fFindNextButton.setEnabled(bl && bl2);
        }
    }

    private boolean isWord(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        int n = 0;
        while (n < string.length()) {
            if (!Character.isJavaIdentifierPart(string.charAt(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private void updateCombo(Combo combo, List list) {
        combo.removeAll();
        int n = 0;
        while (n < list.size()) {
            combo.add(list.get(n).toString());
            ++n;
        }
    }

    private void updateFindHistory() {
        if (this.okToUse((Control)this.fFindField)) {
            this.fFindField.removeModifyListener(this.fFindModifyListener);
            this.updateHistory(this.fFindField, this.fFindHistory);
            this.fFindField.addModifyListener(this.fFindModifyListener);
        }
    }

    private void updateHistory(Combo combo, List list) {
        String string = combo.getText();
        int n = list.indexOf(string);
        if (n != 0) {
            if (n != -1) {
                list.remove(n);
            }
            list.add(0, string);
            this.updateCombo(combo, list);
            combo.setText(string);
        }
    }

    public void updateTarget(IFindReplaceTarget iFindReplaceTarget, boolean bl) {
        this.fNeedsInitialFindBeforeReplace = true;
        if (iFindReplaceTarget != this.fTarget) {
            if (this.fTarget != null && this.fTarget instanceof IFindReplaceTargetExtension) {
                ((IFindReplaceTargetExtension)this.fTarget).endSession();
            }
            this.fTarget = iFindReplaceTarget;
            if (iFindReplaceTarget != null) {
                this.fIsTargetSupportingRegEx = iFindReplaceTarget instanceof IFindReplaceTargetExtension3;
            }
            if (this.fTarget != null && this.fTarget instanceof IFindReplaceTargetExtension) {
                ((IFindReplaceTargetExtension)this.fTarget).beginSession();
                this.fGlobalInit = true;
                this.fGlobalRadioButton.setSelection(this.fGlobalInit);
                this.fSelectedRangeRadioButton.setSelection(!this.fGlobalInit);
                boolean bl2 = this.fUseSelectedLines = !this.fGlobalInit;
            }
        }
        if (this.okToUse((Control)this.fIsRegExCheckBox)) {
            this.fIsRegExCheckBox.setEnabled(this.fIsTargetSupportingRegEx);
        }
        if (this.okToUse((Control)this.fWholeWordCheckBox)) {
            this.fWholeWordCheckBox.setEnabled(!this.isRegExSearchAvailableAndChecked());
        }
        if (this.okToUse((Control)this.fIncrementalCheckBox)) {
            this.fIncrementalCheckBox.setEnabled(!this.isRegExSearchAvailableAndChecked());
        }
        this.fGiveFocusToFindField = true;
    }

    public void setParentShell(Shell shell) {
        if (shell != this.fParentShell) {
            if (this.fParentShell != null) {
                this.fParentShell.removeShellListener((ShellListener)this.fActivationListener);
            }
            this.fParentShell = shell;
            this.fParentShell.addShellListener((ShellListener)this.fActivationListener);
        }
        this.fActiveShell = shell;
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings iDialogSettings = TextEditorPlugin.getDefault().getDialogSettings();
        this.fDialogSettings = iDialogSettings.getSection(((Object)((Object)this)).getClass().getName());
        if (this.fDialogSettings == null) {
            this.fDialogSettings = iDialogSettings.addNewSection(((Object)((Object)this)).getClass().getName());
        }
        return this.fDialogSettings;
    }

    private void readConfiguration() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        try {
            int n = iDialogSettings.getInt("x");
            int n2 = iDialogSettings.getInt("y");
            this.fLocation = new Point(n, n2);
        }
        catch (NumberFormatException numberFormatException) {
            this.fLocation = null;
        }
        this.fWrapInit = iDialogSettings.getBoolean("wrap");
        this.fCaseInit = iDialogSettings.getBoolean("casesensitive");
        this.fWholeWordInit = iDialogSettings.getBoolean("wholeword");
        this.fIncrementalInit = iDialogSettings.getBoolean("incremental");
        this.fIsRegExInit = iDialogSettings.getBoolean("isRegEx");
        String[] stringArray = iDialogSettings.getArray("findhistory");
        if (stringArray != null) {
            List list = this.getFindHistory();
            list.clear();
            int n = 0;
            while (n < stringArray.length) {
                list.add(stringArray[n]);
                ++n;
            }
        }
    }

    private void writeConfiguration() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        Point point = this.getShell().getLocation();
        iDialogSettings.put("x", point.x);
        iDialogSettings.put("y", point.y);
        iDialogSettings.put("wrap", this.fWrapInit);
        iDialogSettings.put("casesensitive", this.fCaseInit);
        iDialogSettings.put("wholeword", this.fWholeWordInit);
        iDialogSettings.put("incremental", this.fIncrementalInit);
        iDialogSettings.put("isRegEx", this.fIsRegExInit);
        List list = this.getFindHistory();
        while (list.size() > 8) {
            list.remove(8);
        }
        String[] stringArray = new String[list.size()];
        list.toArray(stringArray);
        iDialogSettings.put("findhistory", stringArray);
    }

    class ActivationListener
    extends ShellAdapter {
        ActivationListener() {
        }

        public void shellActivated(ShellEvent shellEvent) {
            String string = FindIASTNameDialog.this.fFindField.getText();
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(FindIASTNameDialog.this.fFindHistory);
            FindIASTNameDialog.this.readConfiguration();
            FindIASTNameDialog.this.fFindField.removeModifyListener(FindIASTNameDialog.this.fFindModifyListener);
            FindIASTNameDialog.this.updateCombo(FindIASTNameDialog.this.fFindField, FindIASTNameDialog.this.fFindHistory);
            if (!FindIASTNameDialog.this.fFindHistory.equals(arrayList) && !FindIASTNameDialog.this.fFindHistory.isEmpty()) {
                FindIASTNameDialog.this.fFindField.setText((String)FindIASTNameDialog.this.fFindHistory.get(0));
            } else {
                FindIASTNameDialog.this.fFindField.setText(string);
            }
            if (this.findFieldHadFocus()) {
                FindIASTNameDialog.this.fFindField.setSelection(new Point(0, FindIASTNameDialog.this.fFindField.getText().length()));
            }
            FindIASTNameDialog.this.fFindField.addModifyListener(FindIASTNameDialog.this.fFindModifyListener);
            FindIASTNameDialog.this.fActiveShell = (Shell)shellEvent.widget;
            FindIASTNameDialog.this.updateButtonState();
            if (this.findFieldHadFocus() && FindIASTNameDialog.this.getShell() == FindIASTNameDialog.this.fActiveShell && !FindIASTNameDialog.this.fFindField.isDisposed()) {
                FindIASTNameDialog.this.fFindField.setFocus();
            }
        }

        private boolean findFieldHadFocus() {
            return FindIASTNameDialog.this.fGiveFocusToFindField || FindIASTNameDialog.this.okToUse((Control)FindIASTNameDialog.this.fFindField) && FindIASTNameDialog.this.fFindField.isFocusControl();
        }

        public void shellDeactivated(ShellEvent shellEvent) {
            FindIASTNameDialog.this.fGiveFocusToFindField = FindIASTNameDialog.this.fFindField.isFocusControl();
            FindIASTNameDialog.this.storeSettings();
            FindIASTNameDialog.this.fUseSelectedLines = false;
            if (FindIASTNameDialog.this.fTarget != null && FindIASTNameDialog.this.fTarget instanceof IFindReplaceTargetExtension) {
                ((IFindReplaceTargetExtension)FindIASTNameDialog.this.fTarget).setScope(null);
            }
            FindIASTNameDialog.this.fOldScope = null;
            FindIASTNameDialog.this.fActiveShell = null;
            FindIASTNameDialog.this.updateButtonState();
        }
    }

    private class FindModifyListener
    implements ModifyListener {
        private FindModifyListener() {
        }

        public void modifyText(ModifyEvent modifyEvent) {
            FindIASTNameDialog.this.searchTextChanged = true;
            if (FindIASTNameDialog.this.isIncrementalSearch() && !FindIASTNameDialog.this.isRegExSearchAvailableAndChecked()) {
                if (FindIASTNameDialog.this.fFindField.getText().equals(FindIASTNameDialog.BLANK_STRING) && FindIASTNameDialog.this.fTarget != null) {
                    int n = ((FindIASTNameDialog)FindIASTNameDialog.this).fIncrementalBaseLocation.x;
                    if (FindIASTNameDialog.this.isForwardSearch() && !FindIASTNameDialog.this.fNeedsInitialFindBeforeReplace || !FindIASTNameDialog.this.isForwardSearch() && FindIASTNameDialog.this.fNeedsInitialFindBeforeReplace) {
                        n += ((FindIASTNameDialog)FindIASTNameDialog.this).fIncrementalBaseLocation.y;
                    }
                    FindIASTNameDialog.this.fNeedsInitialFindBeforeReplace = false;
                    FindIASTNameDialog.this.findAndSelect(n, FindIASTNameDialog.BLANK_STRING, FindIASTNameDialog.this.isForwardSearch(), FindIASTNameDialog.this.isCaseSensitiveSearch(), FindIASTNameDialog.this.isWholeWordSearch(), FindIASTNameDialog.this.isRegExSearchAvailableAndChecked());
                } else {
                    FindIASTNameDialog.this.performSearch(false);
                }
            }
            FindIASTNameDialog.this.updateButtonState();
        }
    }
}

