/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.tests.chelp;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.testplugin.CProjectHelper;
import org.eclipse.cdt.internal.ui.CHelpProviderManager;
import org.eclipse.cdt.internal.ui.text.CHelpBookDescriptor;
import org.eclipse.cdt.ui.ICHelpResourceDescriptor;
import org.eclipse.cdt.ui.IFunctionSummary;
import org.eclipse.cdt.ui.tests.chelp.CHelpProviderTester;
import org.eclipse.cdt.ui.tests.chelp.CHelpTestInfoProvider;
import org.eclipse.cdt.ui.text.ICHelpInvocationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class CHelpTest
extends TestCase {
    public static final String TEST_EXTENSION_ID_PREFIX = "org.eclipse.cdt.ui.tests.chelp.extension";
    private static final String C_PROJECT_NAME = "cHelpTestProject";
    private static final String CC_PROJECT_NAME = "ccHelpTestProject";
    private static final String BIN_DIR_NAME = "bin";
    private ICProject fCProject = null;
    private ICProject fCCProject = null;
    private ICHelpInvocationContext fDefaultCCHelpContext = null;
    private ICHelpInvocationContext fDefaultCHelpContext = null;
    static /* synthetic */ Class class$0;

    private ICHelpInvocationContext getDefaultCCHelpContext() throws CoreException {
        if (this.fDefaultCCHelpContext == null) {
            final IProject iProject = this.getCCProject().getProject();
            this.fDefaultCCHelpContext = new ICHelpInvocationContext(){

                public IProject getProject() {
                    return iProject;
                }

                public ITranslationUnit getTranslationUnit() {
                    return null;
                }
            };
        }
        return this.fDefaultCCHelpContext;
    }

    private ICHelpInvocationContext getDefaultCHelpContext() throws CoreException {
        if (this.fDefaultCHelpContext == null) {
            final IProject iProject = this.getCProject().getProject();
            this.fDefaultCHelpContext = new ICHelpInvocationContext(){

                public IProject getProject() {
                    return iProject;
                }

                public ITranslationUnit getTranslationUnit() {
                    return null;
                }
            };
        }
        return this.fDefaultCHelpContext;
    }

    private ICProject getCProject() throws CoreException {
        if (this.fCProject == null) {
            this.fCProject = CProjectHelper.createCProject((String)C_PROJECT_NAME, (String)BIN_DIR_NAME);
        }
        return this.fCProject;
    }

    private ICProject getCCProject() throws CoreException {
        if (this.fCCProject == null) {
            this.fCCProject = CProjectHelper.createCCProject((String)CC_PROJECT_NAME, (String)BIN_DIR_NAME);
        }
        return this.fCCProject;
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.ui.tests.chelp.CHelpTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public void testCHelpProviderManagerGeneral() {
        CHelpProviderManager cHelpProviderManager = CHelpProviderManager.getDefault();
        if (cHelpProviderManager == null) {
            CHelpTest.fail((String)"manager not created");
        }
        if (cHelpProviderManager != CHelpProviderManager.getDefault()) {
            CHelpTest.fail((String)"getDefault returned an other instance of manager");
        }
        try {
            ICHelpInvocationContext iCHelpInvocationContext = this.getDefaultCHelpContext();
            ICHelpInvocationContext iCHelpInvocationContext2 = this.getDefaultCCHelpContext();
            String string = "dummyName";
            CHelpProviderManager.getDefault().getMatchingFunctions(iCHelpInvocationContext, string);
            CHelpProviderManager.getDefault().getMatchingFunctions(iCHelpInvocationContext2, string);
            CHelpProviderManager.getDefault().getFunctionInfo(iCHelpInvocationContext, string);
            CHelpProviderManager.getDefault().getFunctionInfo(iCHelpInvocationContext2, string);
            CHelpProviderManager.getDefault().getHelpResources(iCHelpInvocationContext, string);
            CHelpProviderManager.getDefault().getHelpResources(iCHelpInvocationContext2, string);
            IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.cdt.ui", "CHelpProvider");
            int n = 0;
            int n2 = 0;
            while (n2 < iConfigurationElementArray.length) {
                String string2 = iConfigurationElementArray[n2].getAttribute("id");
                if (string2.startsWith(TEST_EXTENSION_ID_PREFIX)) {
                    ++n;
                }
                ++n2;
            }
            CHelpTest.assertTrue((String)("number of provider instances created (" + CHelpTestInfoProvider.getNumProviders() + ") is not equal to number of extensions (" + n + ")"), (n == CHelpTestInfoProvider.getNumProviders() ? 1 : 0) != 0);
        }
        catch (CoreException coreException) {
            CHelpTest.fail((String)("CoreException occured: " + coreException.getMessage()));
        }
    }

    public void testGetMatchingFunctions() {
        if (!CHelpProviderTester.getDefault().onlyTestInfoProvidersAvailable()) {
            return;
        }
        try {
            ICHelpInvocationContext iCHelpInvocationContext = this.getDefaultCHelpContext();
            ICHelpInvocationContext iCHelpInvocationContext2 = this.getDefaultCCHelpContext();
            String string = "dummyName";
            IFunctionSummary[] iFunctionSummaryArray = CHelpProviderManager.getDefault().getMatchingFunctions(iCHelpInvocationContext, string);
            CHelpProviderTester.getDefault().checkMatchingFunctions(iFunctionSummaryArray, iCHelpInvocationContext, string);
            iFunctionSummaryArray = CHelpProviderManager.getDefault().getMatchingFunctions(iCHelpInvocationContext2, string);
            CHelpProviderTester.getDefault().checkMatchingFunctions(iFunctionSummaryArray, iCHelpInvocationContext2, string);
        }
        catch (CoreException coreException) {
            CHelpTest.fail((String)("CoreException occured: " + coreException.getMessage()));
        }
    }

    public void testGetFunctionInfo() {
        if (!CHelpProviderTester.getDefault().onlyTestInfoProvidersAvailable()) {
            return;
        }
        try {
            ICHelpInvocationContext iCHelpInvocationContext = this.getDefaultCHelpContext();
            ICHelpInvocationContext iCHelpInvocationContext2 = this.getDefaultCCHelpContext();
            String string = "dummyName";
            IFunctionSummary iFunctionSummary = CHelpProviderManager.getDefault().getFunctionInfo(iCHelpInvocationContext, string);
            CHelpProviderTester.getDefault().checkFunctionInfo(iFunctionSummary, iCHelpInvocationContext, string);
            iFunctionSummary = CHelpProviderManager.getDefault().getFunctionInfo(iCHelpInvocationContext2, string);
            CHelpProviderTester.getDefault().checkFunctionInfo(iFunctionSummary, iCHelpInvocationContext2, string);
        }
        catch (CoreException coreException) {
            CHelpTest.fail((String)("CoreException occured: " + coreException.getMessage()));
        }
    }

    public void testGetHelpResources() {
        if (!CHelpProviderTester.getDefault().onlyTestInfoProvidersAvailable()) {
            return;
        }
        try {
            ICHelpInvocationContext iCHelpInvocationContext = this.getDefaultCHelpContext();
            ICHelpInvocationContext iCHelpInvocationContext2 = this.getDefaultCCHelpContext();
            String string = "dummyName";
            ICHelpResourceDescriptor[] iCHelpResourceDescriptorArray = CHelpProviderManager.getDefault().getHelpResources(iCHelpInvocationContext, string);
            CHelpProviderTester.getDefault().checkHelpResources(iCHelpResourceDescriptorArray, iCHelpInvocationContext, string);
            iCHelpResourceDescriptorArray = CHelpProviderManager.getDefault().getHelpResources(iCHelpInvocationContext2, string);
            CHelpProviderTester.getDefault().checkHelpResources(iCHelpResourceDescriptorArray, iCHelpInvocationContext2, string);
        }
        catch (CoreException coreException) {
            CHelpTest.fail((String)("CoreException occured: " + coreException.getMessage()));
        }
    }

    public void testCHelpBookDescriptors() {
        CHelpProviderManager cHelpProviderManager = CHelpProviderManager.getDefault();
        try {
            int n;
            CHelpBookDescriptor cHelpBookDescriptor;
            CHelpBookDescriptor[] cHelpBookDescriptorArray = cHelpProviderManager.getCHelpBookDescriptors(this.getDefaultCCHelpContext());
            CHelpBookDescriptor[] cHelpBookDescriptorArray2 = cHelpProviderManager.getCHelpBookDescriptors(this.getDefaultCHelpContext());
            CHelpTest.assertTrue((String)("CC book descriptors length (" + cHelpBookDescriptorArray.length + ") is less than C book descriptors length (" + cHelpBookDescriptorArray2.length + ")"), (cHelpBookDescriptorArray.length >= cHelpBookDescriptorArray2.length ? 1 : 0) != 0);
            int n2 = 0;
            while (n2 < cHelpBookDescriptorArray2.length) {
                cHelpBookDescriptor = cHelpBookDescriptorArray2[n2];
                CHelpTest.assertTrue((String)("book \"" + cHelpBookDescriptor.getCHelpBook().getTitle() + "\" of type HELP_TYPE_CPP in book descriptors for C project \"" + this.getDefaultCHelpContext().getProject().getName() + "\""), (cHelpBookDescriptor.getCHelpBook().getCHelpType() != 2 ? 1 : 0) != 0);
                n = 0;
                while (n < cHelpBookDescriptorArray.length) {
                    if (cHelpBookDescriptorArray[n].getCHelpBook().getTitle().equals(cHelpBookDescriptor.getCHelpBook().getTitle())) break;
                    ++n;
                }
                CHelpTest.assertTrue((String)("book \"" + cHelpBookDescriptor.getCHelpBook().getTitle() + "\" was not found in CC books"), (n < cHelpBookDescriptorArray.length ? 1 : 0) != 0);
                ++n2;
            }
            n2 = 0;
            while (n2 < cHelpBookDescriptorArray.length) {
                cHelpBookDescriptor = cHelpBookDescriptorArray[n2];
                n = 0;
                while (n < cHelpBookDescriptorArray2.length) {
                    if (cHelpBookDescriptorArray2[n].getCHelpBook().getTitle().equals(cHelpBookDescriptor.getCHelpBook().getTitle())) break;
                    ++n;
                }
                CHelpTest.assertTrue((String)("book \"" + cHelpBookDescriptor.getCHelpBook().getTitle() + "\" of type HELP_TYPE_C was not found in C books"), (n < cHelpBookDescriptorArray2.length || cHelpBookDescriptor.getCHelpBook().getCHelpType() == 2 ? 1 : 0) != 0);
                ++n2;
            }
        }
        catch (CoreException coreException) {
            CHelpTest.fail((String)("CoreException occured: " + coreException.getMessage()));
        }
    }
}

