/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.tests.text;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.internal.ui.text.NumberRule;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;

public class NumberRuleTest
extends TestCase {
    private static final Object NUMBER = "number";
    private RuleBasedScanner fScanner;
    private Document fDocument;
    static /* synthetic */ Class class$0;

    public NumberRuleTest(String string) {
        super(string);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.ui.tests.text.NumberRuleTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.fScanner = new RuleBasedScanner(){};
        this.fScanner.setRules(new IRule[]{new NumberRule((IToken)new Token(NUMBER))});
        this.fDocument = new Document();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testIntegers() {
        this.assertNumber("0");
        this.assertNumber("-1");
        this.assertNumber("+1");
        this.assertNumber("123456789");
        this.assertNumber("-123456789");
        this.assertNumber("+123456789");
        this.assertNumber("0xaffe");
        this.assertNumber("-0xaffe");
        this.assertNumber("+0xaffe");
        this.assertNumber("0Xaffe");
        this.assertNumber("+0XaFFe");
        this.assertNumber("0xabcdefABCDEF");
        this.assertNumber("0x0123456789");
    }

    public void testFloats() {
        this.assertNumber("0.");
        this.assertNumber(".0");
        this.assertNumber("-.0");
        this.assertNumber("+.0");
        this.assertNumber("-0.");
        this.assertNumber("+0.");
        this.assertNumber("0.123456789");
        this.assertNumber("-0.123456789");
        this.assertNumber("+12345.6789");
        this.assertNumber("1e5");
        this.assertNumber("1E5");
        this.assertNumber("1.e5");
        this.assertNumber("-1e5");
        this.assertNumber("-.1e5");
        this.assertNumber("1e-5");
        this.assertNumber("1e+55");
    }

    public void testNonNumbers() {
        this.assertNoNumber("-");
        this.assertNoNumber("+");
        this.assertNoNumber(".");
        this.assertNoNumber("-.");
        this.assertNoNumber("+.");
        this.assertNoNumber("x");
        this.assertNoNumber(".x");
        this.assertNoNumber("-x");
        this.assertNoNumber("e");
        this.assertNoNumber(".e");
        this.assertNoNumber("-e");
        this.assertNoNumber("+e");
    }

    private void assertNumber(String string) {
        this.fDocument.set(string);
        this.fScanner.setRange((IDocument)this.fDocument, 0, this.fDocument.getLength());
        IToken iToken = this.fScanner.nextToken();
        NumberRuleTest.assertSame((Object)NUMBER, (Object)iToken.getData());
        NumberRuleTest.assertEquals((int)string.length(), (int)this.fScanner.getTokenLength());
    }

    private void assertNoNumber(String string) {
        this.fDocument.set(string);
        this.fScanner.setRange((IDocument)this.fDocument, 0, this.fDocument.getLength());
        IToken iToken = this.fScanner.nextToken();
        NumberRuleTest.assertNotSame((Object)NUMBER, (Object)iToken.getData());
    }
}

