/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.tests.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.internal.ui.text.CPartitionScanner;
import org.eclipse.cdt.internal.ui.text.FastCPartitionScanner;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IToken;

public class PartitionTokenScannerTest
extends TestCase {
    private IPartitionTokenScanner fReference;
    private IPartitionTokenScanner fTestee;
    static /* synthetic */ Class class$0;

    public PartitionTokenScannerTest(String string) {
        super(string);
    }

    protected void setUp() {
        this.fReference = new CPartitionScanner();
        this.fTestee = new FastCPartitionScanner();
    }

    private IDocument getDocument(String string, String string2) {
        try {
            InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuffer stringBuffer = new StringBuffer();
            String string3 = bufferedReader.readLine();
            while (string3 != null) {
                stringBuffer.append(string3);
                stringBuffer.append(string2);
                string3 = bufferedReader.readLine();
            }
            return new Document(stringBuffer.toString());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static IDocument getRandomDocument(int n) {
        char[] cArray = new char[]{'/', '*', '\'', '\"', '\r', '\n', '\\'};
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            int n3 = (int)(Math.random() * (double)cArray.length);
            stringBuffer.append(cArray[n3]);
            ++n2;
        }
        return new Document(stringBuffer.toString());
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.ui.tests.text.PartitionTokenScannerTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public void testTestCaseLF() {
        this.testConformance(this.getDocument("TestCase.txt", "\n"));
    }

    public void testTestCaseCRLF() {
        this.testConformance(this.getDocument("TestCase.txt", "\r\n"));
    }

    public void testTestCaseCR() {
        this.testConformance(this.getDocument("TestCase.txt", "\r"));
    }

    public void testTestCase2LF() {
        this.testConformance(this.getDocument("TestCase2.txt", "\n"));
    }

    public void testTestCase2CRLF() {
        this.testConformance(this.getDocument("TestCase2.txt", "\r\n"));
    }

    public void testTestCase2CR() {
        this.testConformance(this.getDocument("TestCase2.txt", "\r"));
    }

    public void testPerformance() {
        IDocument iDocument = this.getDocument("TestCase.txt", "\n");
        this.getTime(this.fReference, iDocument, 5000);
        this.getTime(this.fTestee, iDocument, 5000);
    }

    private long getTime(IPartitionTokenScanner iPartitionTokenScanner, IDocument iDocument, int n) {
        long l = System.currentTimeMillis();
        int n2 = 0;
        while (n2 < n) {
            PartitionTokenScannerTest.testPerformance(iPartitionTokenScanner, iDocument);
            ++n2;
        }
        long l2 = System.currentTimeMillis();
        return l2 - l;
    }

    private void testConformance(IDocument iDocument) {
        IToken iToken;
        StringBuffer stringBuffer = new StringBuffer();
        this.fReference.setRange(iDocument, 0, iDocument.getLength());
        this.fTestee.setRange(iDocument, 0, iDocument.getLength());
        do {
            stringBuffer.setLength(0);
            iToken = this.fReference.nextToken();
            IToken iToken2 = this.fTestee.nextToken();
            this.assertTokenEquals(iToken, iToken2);
            int n = this.fReference.getTokenOffset();
            int n2 = this.fTestee.getTokenOffset();
            stringBuffer.append(", offset = " + n);
            stringBuffer.append(", " + PartitionTokenScannerTest.extractString(iDocument, n));
            PartitionTokenScannerTest.assertEquals((String)stringBuffer.toString(), (int)n, (int)n2);
            int n3 = this.fReference.getTokenLength();
            int n4 = this.fTestee.getTokenLength();
            if (n3 != n4) {
                while (n3 < n4) {
                    IToken iToken3 = this.fReference.nextToken();
                    n3 += this.fReference.getTokenLength();
                    if (iToken == iToken3) continue;
                    PartitionTokenScannerTest.assertEquals((String)stringBuffer.toString(), (Object)iToken, (Object)iToken3);
                }
            }
            stringBuffer.append(", length = " + n3);
            PartitionTokenScannerTest.assertEquals((String)stringBuffer.toString(), (int)n3, (int)n4);
        } while (!iToken.isEOF());
    }

    private static void testPerformance(IPartitionTokenScanner iPartitionTokenScanner, IDocument iDocument) {
        IToken iToken;
        iPartitionTokenScanner.setRange(iDocument, 0, iDocument.getLength());
        do {
            iToken = iPartitionTokenScanner.nextToken();
            iPartitionTokenScanner.getTokenOffset();
            iPartitionTokenScanner.getTokenLength();
        } while (!iToken.isEOF());
    }

    private void assertTokenEquals(IToken iToken, IToken iToken2) {
        PartitionTokenScannerTest.assertEquals((boolean)iToken.isEOF(), (boolean)iToken2.isEOF());
        PartitionTokenScannerTest.assertEquals((boolean)iToken.isOther(), (boolean)iToken2.isOther());
        PartitionTokenScannerTest.assertEquals((boolean)iToken.isUndefined(), (boolean)iToken2.isUndefined());
        PartitionTokenScannerTest.assertEquals((boolean)iToken.isWhitespace(), (boolean)iToken2.isWhitespace());
    }

    private static String extractString(IDocument iDocument, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            IRegion iRegion = iDocument.getLineInformationOfOffset(n);
            String string = iDocument.get(iRegion.getOffset(), iRegion.getLength());
            int n2 = n - iRegion.getOffset();
            if (n2 > string.length()) {
                n2 = string.length();
            }
            stringBuffer.append("line = " + iDocument.getLineOfOffset(n) + ": [");
            stringBuffer.append(string.substring(0, n2));
            stringBuffer.append("<POS>");
            stringBuffer.append(string.substring(n2));
            stringBuffer.append(']');
        }
        catch (BadLocationException badLocationException) {}
        return stringBuffer.toString();
    }

    private static String escape(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '\t': {
                    stringBuffer.append("\\t");
                    break;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    break;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }
}

