/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.tests.text.contentassist;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.testplugin.CProjectHelper;
import org.eclipse.cdt.core.testplugin.FileManager;
import org.eclipse.cdt.internal.ui.CHelpProviderManager;
import org.eclipse.cdt.internal.ui.text.CHelpBookDescriptor;
import org.eclipse.cdt.ui.text.ICHelpInvocationContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

public class ContentAssistTests
extends TestCase {
    static NullProgressMonitor monitor;
    static IWorkspace workspace;
    static IProject project;
    static FileManager fileManager;
    static boolean disabledHelpContributions;
    static /* synthetic */ Class class$0;

    static {
        disabledHelpContributions = false;
    }

    public ContentAssistTests() {
        monitor = new NullProgressMonitor();
        workspace = ResourcesPlugin.getWorkspace();
        try {
            ICProject iCProject = CProjectHelper.createCCProject((String)"ContentAssistTestProject", (String)"bin");
            project = iCProject.getProject();
        }
        catch (CoreException coreException) {}
        if (project == null) {
            ContentAssistTests.fail((String)"Unable to create project");
        }
        fileManager = new FileManager();
    }

    public ContentAssistTests(String string) {
        super(string);
        monitor = new NullProgressMonitor();
        workspace = ResourcesPlugin.getWorkspace();
        try {
            ICProject iCProject = CProjectHelper.createCCProject((String)"ContentAssistTestProject", (String)"bin");
            project = iCProject.getProject();
        }
        catch (CoreException coreException) {}
        if (project == null) {
            ContentAssistTests.fail((String)"Unable to create project");
        }
        fileManager = new FileManager();
    }

    private void disableContributions() {
        CHelpBookDescriptor[] cHelpBookDescriptorArray = CHelpProviderManager.getDefault().getCHelpBookDescriptors(new ICHelpInvocationContext(){

            public IProject getProject() {
                return project;
            }

            public ITranslationUnit getTranslationUnit() {
                return null;
            }
        });
        int n = 0;
        while (n < cHelpBookDescriptorArray.length) {
            if (cHelpBookDescriptorArray[n] != null) {
                cHelpBookDescriptorArray[n].enable(false);
            }
            ++n;
        }
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.ui.tests.text.contentassist.ContentAssistTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite testSuite = new TestSuite((Class)clazz);
        testSuite.addTest((Test)new ContentAssistTests("cleanupProject"));
        return testSuite;
    }

    public void cleanupProject() throws Exception {
        try {
            project.delete(true, false, (IProgressMonitor)monitor);
            project = null;
        }
        catch (Throwable throwable) {}
    }

    protected void tearDown() throws Exception {
        if (project == null || !project.exists()) {
            return;
        }
        IResource[] iResourceArray = project.members();
        int n = 0;
        while (n < iResourceArray.length) {
            if (!iResourceArray[n].getName().equals(".project") && !iResourceArray[n].getName().equals(".cdtproject")) {
                try {
                    iResourceArray[n].delete(false, (IProgressMonitor)monitor);
                }
                catch (Throwable throwable) {}
            }
            ++n;
        }
    }

    protected IFile importFile(String string, String string2) throws Exception {
        IFile iFile = project.getProject().getFile(string);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes());
        if (iFile.exists()) {
            iFile.setContents((InputStream)byteArrayInputStream, false, false, (IProgressMonitor)monitor);
        } else {
            iFile.create((InputStream)byteArrayInputStream, false, (IProgressMonitor)monitor);
        }
        fileManager.addFile(iFile);
        return iFile;
    }

    protected ICompletionProposal[] getResults(IFile iFile, int n) throws Exception {
        if (!disabledHelpContributions) {
            this.disableContributions();
        }
        ITranslationUnit iTranslationUnit = (ITranslationUnit)CoreModel.getDefault().create(iFile);
        iTranslationUnit.getBuffer().getContents();
        try {
            iTranslationUnit.getWorkingCopy();
        }
        catch (CModelException cModelException) {
            ContentAssistTests.fail((String)"Failed to get working copy");
        }
        return new ICompletionProposal[0];
    }

    public void testBug69334() throws Exception {
        this.importFile("test.h", "class Test{ public : Test( int ); }; \n");
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("#include \"test.h\"                \n");
        stringWriter.write("Test::Test( int i ) { return; }    \n");
        stringWriter.write("int main() {                       \n");
        stringWriter.write("   int veryLongName = 1;           \n");
        stringWriter.write("   Test * ptest = new Test( very   \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("test.cpp", string);
        ICompletionProposal[] iCompletionProposalArray = this.getResults(iFile, string.indexOf("very ") + 4);
        ContentAssistTests.assertEquals((int)iCompletionProposalArray.length, (int)1);
        ContentAssistTests.assertEquals((String)iCompletionProposalArray[0].getDisplayString(), (String)"veryLongName : int");
    }

    public void testBug72824() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Strategy {                             \n");
        stringWriter.write("public :                                     \n");
        stringWriter.write("   enum _Ability { IDIOT, NORMAL, CHEAT } ;  \n");
        stringWriter.write("   Strategy( _Ability a ) { }                \n");
        stringWriter.write("};                                           \n");
        stringWriter.write("int main(){                                  \n");
        String string = stringWriter.toString();
        String string2 = String.valueOf(string) + "   Strategy *p[3] = { new Strategy( Str \n";
        IFile iFile = this.importFile("strategy.cpp", string2);
        ICompletionProposal[] iCompletionProposalArray = this.getResults(iFile, string2.indexOf("Str ") + 3);
        ContentAssistTests.assertEquals((int)iCompletionProposalArray.length, (int)1);
        ContentAssistTests.assertEquals((String)iCompletionProposalArray[0].getDisplayString(), (String)"Strategy");
        string2 = String.valueOf(string) + "   Strategy *p[3] = { new Strategy( Strategy:: \n";
        iFile = this.importFile("strategy.cpp", string2);
        iCompletionProposalArray = this.getResults(iFile, string2.indexOf("::") + 2);
        ContentAssistTests.assertEquals((int)iCompletionProposalArray.length, (int)3);
        ContentAssistTests.assertEquals((String)iCompletionProposalArray[0].getDisplayString(), (String)"CHEAT");
        ContentAssistTests.assertEquals((String)iCompletionProposalArray[1].getDisplayString(), (String)"IDIOT");
        ContentAssistTests.assertEquals((String)iCompletionProposalArray[2].getDisplayString(), (String)"NORMAL");
    }

    public void testBug72559() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("void foo(){               \n");
        stringWriter.write("   int var;               \n");
        stringWriter.write("   {                      \n");
        stringWriter.write("      float var;          \n");
        stringWriter.write("      v                   \n");
        stringWriter.write("   }                      \n");
        stringWriter.write("}                         \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        ICompletionProposal[] iCompletionProposalArray = this.getResults(iFile, string.indexOf("v ") + 1);
        ContentAssistTests.assertEquals((int)iCompletionProposalArray.length, (int)4);
        ContentAssistTests.assertEquals((String)iCompletionProposalArray[0].getDisplayString(), (String)"var : float");
        ContentAssistTests.assertEquals((String)iCompletionProposalArray[1].getDisplayString(), (String)"virtual");
        ContentAssistTests.assertEquals((String)iCompletionProposalArray[2].getDisplayString(), (String)"void");
        ContentAssistTests.assertEquals((String)iCompletionProposalArray[3].getDisplayString(), (String)"volatile");
    }
}

