/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.tests.text.contentassist2;

import java.io.FileInputStream;
import java.io.InputStream;
import junit.framework.TestCase;
import org.eclipse.cdt.core.dom.ast.ASTCompletionNode;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.ast.IASTCompletionNode;
import org.eclipse.cdt.core.testplugin.CProjectHelper;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.text.contentassist.CCompletionProcessor2;
import org.eclipse.cdt.ui.testplugin.CTestPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public abstract class CompletionProposalsBaseTest
extends TestCase {
    protected static final String EMPTY_STRING = "";
    private final String projectName = "TestProject1";
    private final String projectType = "bin";
    private ICProject fCProject;
    private IFile fCFile;
    private IFile fHeaderFile;
    private NullProgressMonitor monitor;
    private ITranslationUnit tu = null;
    private String buffer = "";
    private Document document = null;

    public CompletionProposalsBaseTest(String string) {
        super(string);
    }

    protected abstract String getFileName();

    protected abstract String getFileFullPath();

    protected abstract String getHeaderFileName();

    protected abstract String getHeaderFileFullPath();

    protected abstract int getCompletionPosition();

    protected abstract String getExpectedScopeClassName();

    protected abstract String getExpectedContextClassName();

    protected abstract String getExpectedPrefix();

    protected abstract IASTCompletionNode.CompletionKind getExpectedKind();

    protected abstract String[] getExpectedResultsValues();

    protected String getFunctionOrConstructorName() {
        return EMPTY_STRING;
    }

    protected void setUp() throws Exception {
        this.monitor = new NullProgressMonitor();
        this.fCProject = CProjectHelper.createCProject((String)"TestProject1", (String)"bin");
        this.fHeaderFile = this.fCProject.getProject().getFile(this.getHeaderFileName());
        String string = this.getFileName();
        this.fCFile = this.fCProject.getProject().getFile(string);
        if (!this.fCFile.exists() && !this.fHeaderFile.exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(CTestPlugin.getDefault().getFileInPlugin((IPath)new Path(this.getHeaderFileFullPath())));
                this.fHeaderFile.create((InputStream)fileInputStream, false, (IProgressMonitor)this.monitor);
                FileInputStream fileInputStream2 = new FileInputStream(CTestPlugin.getDefault().getFileInPlugin((IPath)new Path(this.getFileFullPath())));
                this.fCFile.create((InputStream)fileInputStream2, false, (IProgressMonitor)this.monitor);
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
        }
        if (!this.fCProject.getProject().hasNature("org.eclipse.cdt.core.ccnature")) {
            CompletionProposalsBaseTest.addNatureToProject(this.fCProject.getProject(), "org.eclipse.cdt.core.ccnature", null);
        }
    }

    private static void addNatureToProject(IProject iProject, String string, IProgressMonitor iProgressMonitor) throws CoreException {
        IProjectDescription iProjectDescription = iProject.getDescription();
        String[] stringArray = iProjectDescription.getNatureIds();
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[stringArray.length] = string;
        iProjectDescription.setNatureIds(stringArray2);
        iProject.setDescription(iProjectDescription, iProgressMonitor);
    }

    protected void tearDown() {
        CProjectHelper.delete((ICProject)this.fCProject);
    }

    public void testCompletionProposals() throws Exception {
        ICompletionProposal iCompletionProposal;
        ITranslationUnit iTranslationUnit = (ITranslationUnit)CoreModel.getDefault().create(this.fCFile);
        this.buffer = iTranslationUnit.getBuffer().getContents();
        IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        FileEditorInput fileEditorInput = new FileEditorInput(this.fCFile);
        IEditorPart iEditorPart = iWorkbenchPage.openEditor((IEditorInput)fileEditorInput, "org.eclipse.cdt.ui.editor.CEditor");
        CEditor cEditor = (CEditor)iEditorPart;
        cEditor.getAction("ContentAssistProposal");
        CCompletionProcessor2 cCompletionProcessor2 = new CCompletionProcessor2(iEditorPart);
        ICompletionProposal[] iCompletionProposalArray = cCompletionProcessor2.computeCompletionProposals((ITextViewer)cEditor.getCSourceViewer(), this.getCompletionPosition());
        CompletionProposalsBaseTest.assertTrue((iCompletionProposalArray != null ? 1 : 0) != 0);
        if (CTestPlugin.getDefault().isDebugging()) {
            int n = 0;
            while (n < iCompletionProposalArray.length) {
                iCompletionProposal = iCompletionProposalArray[n];
                System.out.println("Result: " + iCompletionProposal.getDisplayString());
                ++n;
            }
        }
        ASTCompletionNode aSTCompletionNode = cCompletionProcessor2.getCurrentCompletionNode();
        iCompletionProposal = aSTCompletionNode.getNames();
        IASTName cfr_ignored_0 = iCompletionProposal[0];
        CompletionProposalsBaseTest.assertNotNull((Object)aSTCompletionNode);
        String string = aSTCompletionNode.getPrefix();
        CompletionProposalsBaseTest.assertEquals((String)string, (String)this.getExpectedPrefix());
        String[] stringArray = this.getExpectedResultsValues();
        boolean bl = true;
        int n = 0;
        while (n < stringArray.length) {
            boolean bl2 = false;
            int n2 = 0;
            while (n2 < iCompletionProposalArray.length) {
                ICompletionProposal iCompletionProposal2 = iCompletionProposalArray[n2];
                String string2 = iCompletionProposal2.getDisplayString();
                if (stringArray[n].equals(string2)) {
                    bl2 = true;
                    if (!CTestPlugin.getDefault().isDebugging()) break;
                    System.out.println("Lookup success for " + stringArray[n]);
                    break;
                }
                ++n2;
            }
            if (!bl2) {
                bl = false;
                if (CTestPlugin.getDefault().isDebugging()) {
                    System.out.println("Lookup failed for " + stringArray[n]);
                }
            }
            ++n;
        }
        CompletionProposalsBaseTest.assertTrue((String)"Not enough results!", (iCompletionProposalArray.length >= stringArray.length ? 1 : 0) != 0);
        CompletionProposalsBaseTest.assertTrue((String)"Some expected results were not found!", (boolean)bl);
    }

    public String getBuffer() {
        return this.buffer;
    }

    public Document getDocument() {
        return this.document;
    }

    public ITranslationUnit getTranslationUnit() {
        return this.tu;
    }
}

