/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.tests.text.selectiontests;

import java.io.File;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.CCProjectNature;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.testplugin.CProjectHelper;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.make.core.MakeProjectNature;
import org.eclipse.cdt.make.core.scannerconfig.ScannerConfigNature;
import org.eclipse.cdt.make.internal.core.scannerconfig2.PerProjectSICollector;
import org.eclipse.cdt.ui.tests.text.selectiontests.BaseSelectionTestsIndexer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;

public class CPPSelectionTestsCTagsIndexer
extends BaseSelectionTestsIndexer {
    private static final String INDEX_TAG = "3931153591.index";
    IFile file;
    NullProgressMonitor monitor;
    static final String sourceIndexerID = "org.eclipse.cdt.core.ctagsindexer";
    static /* synthetic */ Class class$0;

    public CPPSelectionTestsCTagsIndexer(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.project = this.createProject("CPPSelectionTestsCTagsIndexerProject");
        IPath iPath = CCorePlugin.getDefault().getStateLocation();
        File file = new File(iPath.append(INDEX_TAG).toOSString());
        if (file.exists()) {
            file.delete();
        }
        if (this.project == null) {
            CPPSelectionTestsCTagsIndexer.fail((String)"Unable to create project");
        }
        ResourcesPlugin.getWorkspace().newProjectDescription(this.project.getName());
        CCProjectNature.addCCNature((IProject)this.project, (IProgressMonitor)this.monitor);
        MakeProjectNature.addNature((IProject)this.project, (IProgressMonitor)new NullProgressMonitor());
        ScannerConfigNature.addScannerConfigNature((IProject)this.project);
        PerProjectSICollector.calculateCompilerBuiltins((IProject)this.project);
        this.resetIndexer(sourceIndexerID);
    }

    protected void tearDown() {
        try {
            super.tearDown();
        }
        catch (Exception exception) {}
        if (this.project.exists()) {
            try {
                System.gc();
                System.runFinalization();
                this.project.delete(true, (IProgressMonitor)this.monitor);
            }
            catch (CoreException coreException) {
                CPPSelectionTestsCTagsIndexer.fail((String)this.getMessage(coreException.getStatus()));
            }
        }
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.ui.tests.text.selectiontests.CPPSelectionTestsCTagsIndexer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite testSuite = new TestSuite(clazz.getName());
        testSuite.addTest((Test)new CPPSelectionTestsCTagsIndexer("testBug78354"));
        testSuite.addTest((Test)new CPPSelectionTestsCTagsIndexer("testSimpleOpenDeclaration"));
        testSuite.addTest((Test)new CPPSelectionTestsCTagsIndexer("testSimpleOpenDeclaration2"));
        testSuite.addTest((Test)new CPPSelectionTestsCTagsIndexer("testBasicDefinition"));
        testSuite.addTest((Test)new CPPSelectionTestsCTagsIndexer("testCPPSpecDeclsDefs"));
        testSuite.addTest((Test)new CPPSelectionTestsCTagsIndexer("testNoDefinitions"));
        testSuite.addTest((Test)new CPPSelectionTestsCTagsIndexer("testOpenFileDiffDir"));
        testSuite.addTest((Test)new CPPSelectionTestsCTagsIndexer("testBug101287"));
        testSuite.addTest((Test)new CPPSelectionTestsCTagsIndexer("testBug103697"));
        testSuite.addTest((Test)new CPPSelectionTestsCTagsIndexer("testBug76043"));
        return testSuite;
    }

    private IProject createProject(String string) throws CoreException {
        ICProject iCProject = CProjectHelper.createCCProject((String)string, (String)"bin");
        return iCProject.getProject();
    }

    public void testSimpleOpenDeclaration() throws Exception {
        String string = "char c; /* comment */ \n // comment \nint x;\n";
        this.importFile("test.h", string);
        String string2 = "#include \"test.h\"\nint foo() { \n return x;\n}\n";
        IFile iFile = this.importFile("test.cpp", string2);
        int n = string2.indexOf("x;\n}\n");
        IASTNode iASTNode = this.testCtrl_F3(iFile, n);
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)string.indexOf("x;\n"));
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)"x".length());
        IASTNode iASTNode2 = this.testF3(iFile, n);
        if (iASTNode2 instanceof IASTName) {
            // empty if block
        }
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)string.indexOf("x;\n"));
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)"x".length());
    }

    public void testSimpleOpenDeclaration2() throws Exception {
        String string = "int x;\r\n // comment \r\nint y;\r\n /* comment */ \r\n int z;\r\n";
        this.importFile("testSimpleOpenDeclaration2.h", string);
        String string2 = "#include \"testSimpleOpenDeclaration2.h\"\r\nint foo() { \r\n return y;\r\n}\r\n";
        IFile iFile = this.importFile("testSimpleOpenDeclaration2.cpp", string2);
        int n = string2.indexOf("y;");
        IASTNode iASTNode = this.testCtrl_F3(iFile, n);
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)string.indexOf("y;"));
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)"y".length());
        IASTNode iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)string.indexOf("y;"));
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)"y".length());
    }

    public void testBasicDefinition() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("extern int MyInt;       // MyInt is in another file\n");
        stringBuffer.append("extern const int MyConst;   // MyConst is in another file\n");
        stringBuffer.append("void MyFunc(int);       // often used in header files\n");
        stringBuffer.append("struct MyStruct;        // often used in header files\n");
        stringBuffer.append("typedef int NewInt;     // a normal typedef statement\n");
        stringBuffer.append("int MyInt;\n");
        stringBuffer.append("extern const int MyConst = 42;\n");
        stringBuffer.append("void MyFunc(int a) { cout << a << endl; }\n");
        stringBuffer.append("struct MyStruct { int Member1; int Member2; };\n");
        String string = stringBuffer.toString();
        IFile iFile = this.importFile("testBasicDefinition.c", string);
        int n = string.indexOf("MyInt;\n") + 2;
        IASTNode iASTNode = this.testCtrl_F3(iFile, n);
        IASTNode iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"MyInt");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)11);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)5);
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"MyInt");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)276);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)5);
        n = string.indexOf("MyConst = 42") + 2;
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"MyConst");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)69);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)7);
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"MyConst");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)300);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)7);
        n = string.indexOf("MyFunc(int a)") + 2;
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"MyFunc");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)115);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)6);
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"MyFunc");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)319);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)6);
        n = string.indexOf("MyStruct {") + 2;
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"MyStruct");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)171);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)8);
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"MyStruct");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)363);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)8);
    }

    public void testCPPSpecDeclsDefs() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int a; // defines a\n");
        stringBuffer.append("extern const int c = 1; // defines c\n");
        stringBuffer.append("int f(int x) { return x+a; } // defines f and defines x\n");
        stringBuffer.append("struct S { int a; int b; }; // defines S, S::a, and S::b\n");
        stringBuffer.append("struct X { // defines X\n");
        stringBuffer.append("int x; // defines nonstatic data member x\n");
        stringBuffer.append("};\n");
        stringBuffer.append("enum { up, down }; // defines up and down\n");
        stringBuffer.append("struct X anX; // defines anX\n");
        stringBuffer.append("extern int a; // declares a\n");
        stringBuffer.append("extern const int c; // declares c\n");
        stringBuffer.append("int f(int); // declares f\n");
        stringBuffer.append("struct S; // declares S\n");
        stringBuffer.append("typedef int Int; // declares Int\n");
        stringBuffer.append("extern struct X anotherX; // declares anotherX\n");
        String string = stringBuffer.toString();
        IFile iFile = this.importFile("testCPPSpecDeclsDefs.c", string);
        int n = string.indexOf("a; // defines a");
        IASTNode iASTNode = this.testCtrl_F3(iFile, n);
        IASTNode iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"a");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)4);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"a");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)4);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("c = 1; // defines c");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"c");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)37);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"c");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)37);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("f(int x) { return x+a; } // defines f and defines x");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"f");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)61);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"f");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)61);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("x) { return x+a; } // defines f and defines x");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"x");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)67);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"x");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)67);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("x+a; } // defines f and defines x");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"x");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)67);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"x");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)67);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("x+a; } // defines f and defines x");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"x");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)67);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"x");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)67);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("a; } // defines f and defines x");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"a");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)4);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"a");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)4);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("S { int a; int b; }; // defines S, S::a, and S::b");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"S");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)120);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"S");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)120);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("a; int b; }; // defines S, S::a, and S::b");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"a");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)128);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"a");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)128);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("b; }; // defines S, S::a, and S::b");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"b");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)135);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"b");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)135);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("X { // defines X");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"X");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)177);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"X");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)177);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("x; // defines nonstatic data member x");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"x");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)198);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"x");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)198);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("up, down }; // defines up and down");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"up");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)246);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)2);
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"up");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)246);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)2);
        n = string.indexOf("down }; // defines up and down");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"down");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)250);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)4);
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"down");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)250);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)4);
        n = string.indexOf("X anX; // defines anX");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"X");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)177);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"X");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)177);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("anX; // defines anX");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"anX");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)290);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)3);
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"anX");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)290);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)3);
        n = string.indexOf("a; // declares a");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"a");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)4);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"a");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)4);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("c; // declares c");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"c");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)37);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"c");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)37);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("f(int); // declares f");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"f");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)61);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"f");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)61);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("S; // declares S");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"S");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)120);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"S");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)120);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("Int; // declares Int");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"Int");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)434);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)3);
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"Int");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)434);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)3);
        n = string.indexOf("X anotherX; // declares anotherX");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"X");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)177);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"X");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)177);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("anotherX; // declares anotherX");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        try {
            CPPSelectionTestsCTagsIndexer.assertNull((Object)iASTNode);
            CPPSelectionTestsCTagsIndexer.assertTrue((boolean)false);
        }
        catch (AssertionFailedError assertionFailedError) {}
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"anotherX");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)471);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)8);
    }

    public void testNoDefinitions() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("extern int a1; // declares a\n");
        stringBuffer.append("extern const int c1; // declares c\n");
        stringBuffer.append("int f1(int); // declares f\n");
        stringBuffer.append("struct S1; // declares S\n");
        stringBuffer.append("typedef int Int; // declares Int\n");
        String string = stringBuffer.toString();
        IFile iFile = this.importFile("testNoDefinitions.c", string);
        int n = string.indexOf("a1; // declares a");
        IASTNode iASTNode = this.testCtrl_F3(iFile, n);
        IASTNode iASTNode2 = this.testF3(iFile, n);
        try {
            CPPSelectionTestsCTagsIndexer.assertNull((Object)iASTNode);
            CPPSelectionTestsCTagsIndexer.assertTrue((boolean)false);
        }
        catch (AssertionFailedError assertionFailedError) {}
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"a1");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)11);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)2);
        n = string.indexOf("c1; // declares c");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        try {
            CPPSelectionTestsCTagsIndexer.assertNull((Object)iASTNode);
            CPPSelectionTestsCTagsIndexer.assertTrue((boolean)false);
        }
        catch (AssertionFailedError assertionFailedError) {}
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"c1");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)46);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)2);
        n = string.indexOf("f1(int); // declares f");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsCTagsIndexer.assertNull((Object)iASTNode);
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"f1");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)68);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)2);
        n = string.indexOf("S1; // declares S");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        try {
            CPPSelectionTestsCTagsIndexer.assertNull((Object)iASTNode);
            CPPSelectionTestsCTagsIndexer.assertTrue((boolean)false);
        }
        catch (AssertionFailedError assertionFailedError) {}
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"S1");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)98);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)2);
        n = string.indexOf("Int; // declares Int");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"Int");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)128);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)3);
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"Int");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)128);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)3);
    }

    public void testOpenFileDiffDir() throws Exception {
        this.importFolder("test");
        String string = "int x;\r\n // comment \r\n int y; /* comment */ \r\n int z; \r\n";
        this.importFile("test/test.h", string);
        String string2 = "#include \"test\\test.h\"\r\nint foo() { \r\n return y;\r\n}\n";
        IFile iFile = this.importFile("test.cpp", string2);
        int n = string2.indexOf("y;");
        IASTNode iASTNode = this.testCtrl_F3(iFile, n);
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)string.indexOf("y;"));
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)"y".length());
        IASTNode iASTNode2 = this.testF3(iFile, n);
        if (iASTNode2 instanceof IASTName) {
            // empty if block
        }
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)string.indexOf("y;"));
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)"y".length());
    }

    public void testBug101287() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int abc;\n");
        stringBuffer.append("int main(int argc, char **argv) {\n");
        stringBuffer.append("abc\n");
        stringBuffer.append("}\n");
        String string = stringBuffer.toString();
        IFile iFile = this.importFile("testBug101287.c", string);
        int n = string.indexOf("abc\n");
        ISelection iSelection = this.testF3Selection(iFile, n);
        if (iSelection instanceof TextSelection) {
            CPPSelectionTestsCTagsIndexer.assertEquals((int)((TextSelection)iSelection).getOffset(), (int)string.indexOf("int abc;\n"));
            CPPSelectionTestsCTagsIndexer.assertEquals((int)((TextSelection)iSelection).getLength(), (int)"int abc;\n".length());
        }
    }

    public void testBug78354() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("typedef int TestTypeOne;\n");
        stringBuffer.append("typedef int TestTypeTwo;\n");
        stringBuffer.append("main()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("TestTypeOne myFirstLink = 5;\n");
        stringBuffer.append("TestTypeTwo mySecondLink = 6;\n");
        stringBuffer.append("return 0;\n");
        stringBuffer.append("}\n");
        String string = stringBuffer.toString();
        IFile iFile = this.importFileWithLink("testBug78354.cpp", string);
        int n = string.indexOf("TestTypeOne myFirstLink = 5;");
        IASTNode iASTNode = this.testF3(iFile, n);
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"TestTypeOne");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)12);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)11);
    }

    public void testBug103697() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int x;\n");
        stringBuffer.append("int foo() {\n");
        stringBuffer.append(" return x;\n");
        stringBuffer.append("}\n");
        String string = stringBuffer.toString();
        IFile iFile = this.importFileWithLink("testBug103697.cpp", string);
        int n = string.indexOf("return x;\n") + "return ".length();
        IASTNode iASTNode = this.testCtrl_F3(iFile, n);
        IASTNode iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"x");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)4);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"x");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)4);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
    }

    public void testBug76043() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int x;\n");
        stringBuffer.append("int foo() {\n");
        stringBuffer.append(" return x;\n");
        stringBuffer.append("}\n");
        String string = stringBuffer.toString();
        IFile iFile = this.importFileInsideLinkedFolder("testBug76043.c", string, "folder");
        CPPSelectionTestsCTagsIndexer.assertFalse((boolean)iFile.isLinked());
        int n = string.indexOf("return x;\n") + "return ".length();
        IASTNode iASTNode = this.testCtrl_F3(iFile, n);
        IASTNode iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"x");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)4);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        CPPSelectionTestsCTagsIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsCTagsIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"x");
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)4);
        CPPSelectionTestsCTagsIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
    }
}

