/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.tests.text.selectiontests;

import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.CCProjectNature;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.testplugin.CProjectHelper;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.make.core.MakeProjectNature;
import org.eclipse.cdt.make.core.scannerconfig.ScannerConfigNature;
import org.eclipse.cdt.make.internal.core.scannerconfig2.PerProjectSICollector;
import org.eclipse.cdt.ui.tests.text.selectiontests.BaseSelectionTestsIndexer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class CPPSelectionTestsDOMIndexer
extends BaseSelectionTestsIndexer {
    private static final String INDEX_TAG = "1196338025.index";
    IFile file;
    NullProgressMonitor monitor;
    static final String sourceIndexerID = "org.eclipse.cdt.core.domsourceindexer";
    static /* synthetic */ Class class$0;

    public CPPSelectionTestsDOMIndexer(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.project = this.createProject("CPPSelectionTestsDOMIndexerProject");
        IPath iPath = CCorePlugin.getDefault().getStateLocation();
        File file = new File(iPath.append(INDEX_TAG).toOSString());
        if (file.exists()) {
            file.delete();
        }
        if (this.project == null) {
            CPPSelectionTestsDOMIndexer.fail((String)"Unable to create project");
        }
        ResourcesPlugin.getWorkspace().newProjectDescription(this.project.getName());
        CCProjectNature.addCCNature((IProject)this.project, (IProgressMonitor)this.monitor);
        MakeProjectNature.addNature((IProject)this.project, (IProgressMonitor)new NullProgressMonitor());
        ScannerConfigNature.addScannerConfigNature((IProject)this.project);
        PerProjectSICollector.calculateCompilerBuiltins((IProject)this.project);
        this.resetIndexer(sourceIndexerID);
    }

    protected void tearDown() {
        try {
            super.tearDown();
        }
        catch (Exception exception) {}
        if (this.project.exists()) {
            try {
                System.gc();
                System.runFinalization();
                this.project.delete(true, (IProgressMonitor)this.monitor);
            }
            catch (CoreException coreException) {
                CPPSelectionTestsDOMIndexer.fail((String)this.getMessage(coreException.getStatus()));
            }
        }
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.ui.tests.text.selectiontests.CPPSelectionTestsDOMIndexer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite testSuite = new TestSuite(clazz.getName());
        testSuite.addTest((Test)new CPPSelectionTestsDOMIndexer("testBug78354"));
        testSuite.addTest((Test)new CPPSelectionTestsDOMIndexer("testBug93281"));
        testSuite.addTest((Test)new CPPSelectionTestsDOMIndexer("testBasicDefinition"));
        testSuite.addTest((Test)new CPPSelectionTestsDOMIndexer("testBug95224"));
        testSuite.addTest((Test)new CPPSelectionTestsDOMIndexer("testBasicTemplateInstance"));
        testSuite.addTest((Test)new CPPSelectionTestsDOMIndexer("testBug86829A"));
        testSuite.addTest((Test)new CPPSelectionTestsDOMIndexer("testBug86829B"));
        testSuite.addTest((Test)new CPPSelectionTestsDOMIndexer("testCPPSpecDeclsDefs"));
        testSuite.addTest((Test)new CPPSelectionTestsDOMIndexer("testBug95225"));
        testSuite.addTest((Test)new CPPSelectionTestsDOMIndexer("testNoDefinitions"));
        testSuite.addTest((Test)new CPPSelectionTestsDOMIndexer("testBug95202"));
        testSuite.addTest((Test)new CPPSelectionTestsDOMIndexer("testBug95229"));
        testSuite.addTest((Test)new CPPSelectionTestsDOMIndexer("testBug101287"));
        testSuite.addTest((Test)new CPPSelectionTestsDOMIndexer("testBug102258"));
        testSuite.addTest((Test)new CPPSelectionTestsDOMIndexer("testBug103323"));
        testSuite.addTest((Test)new CPPSelectionTestsDOMIndexer("testBug103697"));
        testSuite.addTest((Test)new CPPSelectionTestsDOMIndexer("testBug76043"));
        testSuite.addTest((Test)new CPPSelectionTestsDOMIndexer("testBug108202"));
        return testSuite;
    }

    private IProject createProject(String string) throws CoreException {
        ICProject iCProject = CProjectHelper.createCCProject((String)string, (String)"bin");
        return iCProject.getProject();
    }

    public void testBug93281() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class Point{                         \n");
        stringBuffer.append("public:                              \n");
        stringBuffer.append("Point(): xCoord(0){}                 \n");
        stringBuffer.append("Point& operator=(const Point &rhs){return *this;}    // line A\n");
        stringBuffer.append("void* operator new [ ] (unsigned int);\n");
        stringBuffer.append("private:                             \n");
        stringBuffer.append("int xCoord;                          \n");
        stringBuffer.append("};                                   \n");
        stringBuffer.append("static const Point zero;\n");
        stringBuffer.append("int main(int argc, char **argv) {        \n");
        stringBuffer.append("Point *p2 = new Point();         \n");
        stringBuffer.append("p2->    operator // /* operator */ // F3 in the middle \n");
        stringBuffer.append("//of \"operator\" should work\n");
        stringBuffer.append("// \\n");
        stringBuffer.append("/* */\n");
        stringBuffer.append("=(zero);           // line B\n");
        stringBuffer.append("p2->operator /* oh yeah */ new // F3 in the middle of \"operator\"\n");
        stringBuffer.append("// should work\n");
        stringBuffer.append("//\n");
        stringBuffer.append("[ /* sweet */ ] //\n");
        stringBuffer.append("(2);\n");
        stringBuffer.append("return (0);                          \n");
        stringBuffer.append("}\n");
        String string = stringBuffer.toString();
        IFile iFile = this.importFile("test93281.cpp", string);
        int n = string.indexOf("p2->operator") + 6;
        IASTNode iASTNode = this.testF3(iFile, n);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"operator new[]");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)183);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)16);
        n = string.indexOf("p2->    operator") + 11;
        iASTNode = this.testF3(iFile, n);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"operator =");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)121);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)9);
    }

    public void testBasicDefinition() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("extern int MyInt;       // MyInt is in another file\n");
        stringBuffer.append("extern const int MyConst;   // MyConst is in another file\n");
        stringBuffer.append("void MyFunc(int);       // often used in header files\n");
        stringBuffer.append("struct MyStruct;        // often used in header files\n");
        stringBuffer.append("typedef int NewInt;     // a normal typedef statement\n");
        stringBuffer.append("class MyClass;          // often used in header files\n");
        stringBuffer.append("int MyInt;\n");
        stringBuffer.append("extern const int MyConst = 42;\n");
        stringBuffer.append("void MyFunc(int a) { cout << a << endl; }\n");
        stringBuffer.append("struct MyStruct { int Member1; int Member2; };\n");
        stringBuffer.append("class MyClass { int MemberVar; };\n");
        String string = stringBuffer.toString();
        IFile iFile = this.importFile("testBasicDefinition.cpp", string);
        int n = string.indexOf("MyInt;\n") + 2;
        IASTNode iASTNode = this.testCtrl_F3(iFile, n);
        IASTNode iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"MyInt");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)11);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)5);
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"MyInt");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)330);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)5);
        n = string.indexOf("MyConst = 42") + 2;
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"MyConst");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)69);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)7);
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"MyConst");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)354);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)7);
        n = string.indexOf("MyFunc(int a)") + 2;
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"MyFunc");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)115);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)6);
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"MyFunc");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)373);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)6);
        n = string.indexOf("MyStruct {") + 2;
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"MyStruct");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)171);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)8);
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"MyStruct");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)417);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)8);
        n = string.indexOf("MyClass {") + 2;
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"MyClass");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)278);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)7);
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"MyClass");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)463);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)7);
    }

    public void testBug95224() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class A{\n");
        ((Writer)stringWriter).write("A();\n");
        ((Writer)stringWriter).write("A(const A&); // open definition on A finds class A\n");
        ((Writer)stringWriter).write("~A(); // open definition on A finds nothing\n");
        ((Writer)stringWriter).write("};\n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("testBug95224.cpp", string);
        int n = string.indexOf("A(); // open definition ");
        IASTNode iASTNode = this.testCtrl_F3(iFile, n);
        IASTNode iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"~A");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)65);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)2);
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"A");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)6);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
    }

    public void testBasicTemplateInstance() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("namespace N{                               \n");
        ((Writer)stringWriter).write("   template < class T > class AAA { T _t; };\n");
        ((Writer)stringWriter).write("};                                         \n");
        ((Writer)stringWriter).write("N::AAA<int> a;                             \n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("testBasicTemplateInstance.cpp", string);
        int n = string.indexOf("AAA<int>");
        IASTNode iASTNode = this.testCtrl_F3(iFile, n, 3);
        IASTNode iASTNode2 = this.testF3(iFile, n, 3);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"AAA");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)74);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)3);
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"AAA");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)74);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)3);
        IASTNode iASTNode3 = this.testCtrl_F3(iFile, n, 8);
        IASTNode iASTNode4 = this.testF3(iFile, n, 8);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode3 instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode4 instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode4).toString(), (String)"AAA");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode4).getOffset(), (int)74);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode4).getLength(), (int)3);
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode3).toString(), (String)"AAA");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode3).getOffset(), (int)74);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode3).getLength(), (int)3);
    }

    public void testBug86829A() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class X {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("X(int); // openReferences fails to find the constructor in g()\n");
        stringBuffer.append("};\n");
        stringBuffer.append("X f(X);\n");
        stringBuffer.append("void g()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("X b = f(X(2)); // openDeclarations on X(int) finds the class and not \n");
        stringBuffer.append("}\n");
        String string = stringBuffer.toString();
        IFile iFile = this.importFile("testBug86829A.cpp", string);
        int n = string.indexOf("X(2)");
        IASTNode iASTNode = this.testF3(iFile, n);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"X");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)18);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
    }

    public void testBug86829B() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class X {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("operator int();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("class Y {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("operator X();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("Y a;\n");
        stringBuffer.append("int c = X(a); // OK: a.operator X().operator int()\n");
        String string = stringBuffer.toString();
        IFile iFile = this.importFile("testBug86829B.cpp", string);
        int n = string.indexOf("X(a);");
        IASTNode iASTNode = this.testCtrl_F3(iFile, n);
        IASTNode iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"X");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)6);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"X");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)6);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
    }

    public void testCPPSpecDeclsDefs() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int a; // defines a\n");
        stringBuffer.append("extern const int c = 1; // defines c\n");
        stringBuffer.append("int f(int x) { return x+a; } // defines f and defines x\n");
        stringBuffer.append("struct S { int a; int b; }; // defines S, S::a, and S::b\n");
        stringBuffer.append("struct X { // defines X\n");
        stringBuffer.append("int x; // defines nonstatic data member x\n");
        stringBuffer.append("static int y; // declares static data member y\n");
        stringBuffer.append("X(): x(0) { } // defines a constructor of X\n");
        stringBuffer.append("};\n");
        stringBuffer.append("int X::y = 1; // defines X::y\n");
        stringBuffer.append("enum { up, down }; // defines up and down\n");
        stringBuffer.append("namespace N { int d; } // defines N and N::d\n");
        stringBuffer.append("namespace N1 = N; // defines N1\n");
        stringBuffer.append("X anX; // defines anX\n");
        stringBuffer.append("extern int a; // declares a\n");
        stringBuffer.append("extern const int c; // declares c\n");
        stringBuffer.append("int f(int); // declares f\n");
        stringBuffer.append("struct S; // declares S\n");
        stringBuffer.append("typedef int Int; // declares Int\n");
        stringBuffer.append("extern X anotherX; // declares anotherX\n");
        stringBuffer.append("using N::d; // declares N::d\n");
        String string = stringBuffer.toString();
        IFile iFile = this.importFile("testCPPSpecDeclsDefs.cpp", string);
        int n = string.indexOf("a; // defines a");
        IASTNode iASTNode = this.testCtrl_F3(iFile, n);
        IASTNode iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"a");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)4);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"a");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)4);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("c = 1; // defines c");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"c");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)37);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"c");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)37);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("f(int x) { return x+a; } // defines f and defines x");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"f");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)61);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"f");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)61);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("x) { return x+a; } // defines f and defines x");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"x");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)67);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"x");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)67);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("x+a; } // defines f and defines x");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"x");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)67);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"x");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)67);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("x+a; } // defines f and defines x");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"x");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)67);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"x");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)67);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("a; } // defines f and defines x");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"a");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)4);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"a");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)4);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("S { int a; int b; }; // defines S, S::a, and S::b");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"S");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)120);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"S");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)120);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("a; int b; }; // defines S, S::a, and S::b");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"a");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)128);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"a");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)128);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("b; }; // defines S, S::a, and S::b");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"b");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)135);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"b");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)135);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("X { // defines X");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"X");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)177);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"X");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)177);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("x; // defines nonstatic data member x");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"x");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)198);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"x");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)198);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("y; // declares static data member y");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"y");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)247);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"y");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)337);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("X(): x(0) { } // defines a constructor of X");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"X");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)283);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"X");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)283);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("x(0) { } // defines a constructor of X");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"x");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)198);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"x");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)198);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("X::y = 1; // defines X::y");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"X");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)177);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"X");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)177);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("y = 1; // defines X::y");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"y");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)247);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"y");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)337);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("up, down }; // defines up and down");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"up");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)367);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)2);
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"up");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)367);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)2);
        n = string.indexOf("down }; // defines up and down");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"down");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)371);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)4);
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"down");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)371);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)4);
        n = string.indexOf("N { int d; } // defines N and N::d");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"N");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)412);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"N");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)412);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("d; } // defines N and N::d");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"d");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)420);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"d");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)420);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("N1 = N; // defines N1");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"N1");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)457);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)2);
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"N1");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)457);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)2);
        n = string.indexOf("N; // defines N1");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"N");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)412);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"N");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)412);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("X anX; // defines anX");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"X");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)177);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"X");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)177);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("anX; // defines anX");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"anX");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)481);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)3);
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"anX");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)481);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)3);
        n = string.indexOf("a; // declares a");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"a");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)4);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"a");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)4);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("c; // declares c");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"c");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)37);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"c");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)37);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("f(int); // declares f");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"f");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)61);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"f");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)61);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("S; // declares S");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"S");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)120);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"S");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)120);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("Int; // declares Int");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        try {
            CPPSelectionTestsDOMIndexer.assertNull((Object)iASTNode);
            CPPSelectionTestsDOMIndexer.assertTrue((boolean)false);
        }
        catch (AssertionFailedError assertionFailedError) {}
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"Int");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)625);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)3);
        n = string.indexOf("X anotherX; // declares anotherX");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"X");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)177);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"X");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)177);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("anotherX; // declares anotherX");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        try {
            CPPSelectionTestsDOMIndexer.assertNull((Object)iASTNode);
            CPPSelectionTestsDOMIndexer.assertTrue((boolean)false);
        }
        catch (AssertionFailedError assertionFailedError) {}
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"anotherX");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)655);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)8);
        n = string.indexOf("N::d; // declares N::d");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"N");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)412);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"N");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)412);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("d; // declares N::d");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"d");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)420);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"d");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)420);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
    }

    public void testBug95225() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class Overflow {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("Overflow(char,double,double);\n");
        stringBuffer.append("};\n");
        stringBuffer.append("void f(double x)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("throw Overflow('+',x,3.45e107);\n");
        stringBuffer.append("}\n");
        stringBuffer.append("int foo() {\n");
        stringBuffer.append("try {\n");
        stringBuffer.append("f(1.2);\n");
        stringBuffer.append("}\n");
        stringBuffer.append("catch(Overflow& oo) {\n");
        stringBuffer.append("\t\t\t\t// handle exceptions of type Overflow here\n");
        stringBuffer.append("}\n");
        stringBuffer.append("}\n");
        String string = stringBuffer.toString();
        IFile iFile = this.importFile("testBug95225.cpp", string);
        int n = string.indexOf("rflow('+',x,3.45e107);");
        IASTNode iASTNode = this.testCtrl_F3(iFile, n);
        IASTNode iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"Overflow");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)25);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)8);
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"Overflow");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)6);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)8);
        n = string.indexOf("x,3.45e107);");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"x");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)72);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"x");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)72);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
    }

    public void testNoDefinitions() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("extern int a1; // declares a\n");
        stringBuffer.append("extern const int c1; // declares c\n");
        stringBuffer.append("int f1(int); // declares f\n");
        stringBuffer.append("struct S1; // declares S\n");
        stringBuffer.append("typedef int Int; // declares Int\n");
        String string = stringBuffer.toString();
        IFile iFile = this.importFile("testNoDefinitions.cpp", string);
        int n = string.indexOf("a1; // declares a");
        IASTNode iASTNode = this.testCtrl_F3(iFile, n);
        IASTNode iASTNode2 = this.testF3(iFile, n);
        try {
            CPPSelectionTestsDOMIndexer.assertNull((Object)iASTNode);
            CPPSelectionTestsDOMIndexer.assertTrue((boolean)false);
        }
        catch (AssertionFailedError assertionFailedError) {}
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"a1");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)11);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)2);
        n = string.indexOf("c1; // declares c");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        try {
            CPPSelectionTestsDOMIndexer.assertNull((Object)iASTNode);
            CPPSelectionTestsDOMIndexer.assertTrue((boolean)false);
        }
        catch (AssertionFailedError assertionFailedError) {}
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"c1");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)46);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)2);
        n = string.indexOf("f1(int); // declares f");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsDOMIndexer.assertNull((Object)iASTNode);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"f1");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)68);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)2);
        n = string.indexOf("S1; // declares S");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsDOMIndexer.assertNull((Object)iASTNode);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"S1");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)98);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)2);
        n = string.indexOf("Int; // declares Int");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        try {
            CPPSelectionTestsDOMIndexer.assertNull((Object)iASTNode);
            CPPSelectionTestsDOMIndexer.assertTrue((boolean)false);
        }
        catch (AssertionFailedError assertionFailedError) {}
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"Int");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)128);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)3);
    }

    public void testBug95202() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct A { }; // implicitlydeclared A::operator=\n");
        stringBuffer.append("struct B : A {\n");
        stringBuffer.append("B& operator=(const B &);\n");
        stringBuffer.append("};\n");
        stringBuffer.append("B& B::operator=(const B& s) {\n");
        stringBuffer.append("this->B::operator=(s); // wellformed\n");
        stringBuffer.append("return *this;\n");
        stringBuffer.append("}\n");
        String string = stringBuffer.toString();
        IFile iFile = this.importFile("testBug95202.cpp", string);
        int n = string.indexOf("s); // wellformed");
        IASTNode iASTNode = this.testCtrl_F3(iFile, n);
        IASTNode iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"s");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)117);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"s");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)117);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
    }

    public void testBug95229() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct A {\n");
        stringBuffer.append("operator short(); // F3 on operator causes an infinite loop\n");
        stringBuffer.append("} a;\n");
        stringBuffer.append("int f(int);\n");
        stringBuffer.append("int f(float);\n");
        stringBuffer.append("int i = f(a); // Calls f(int), because short -> int is\n");
        String string = stringBuffer.toString();
        IFile iFile = this.importFile("testBug95229.cpp", string);
        int n = string.indexOf("rator short(); // F3");
        IASTNode iASTNode = this.testCtrl_F3(iFile, n);
        IASTNode iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsDOMIndexer.assertNull((Object)iASTNode);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"operator short");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)11);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)14);
    }

    public void testBug101287() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int abc;\n");
        stringBuffer.append("int main(int argc, char **argv) {\n");
        stringBuffer.append("abc\n");
        stringBuffer.append("}\n");
        String string = stringBuffer.toString();
        IFile iFile = this.importFile("testBug101287.c", string);
        int n = string.indexOf("abc\n");
        this.testCtrl_F3(iFile, n);
        IASTNode iASTNode = this.testF3(iFile, n);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"abc");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)4);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)3);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"abc");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)4);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)3);
    }

    public void testBug102258() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct RTBindingEnd\n");
        stringBuffer.append("{\n");
        stringBuffer.append("int          index;\n");
        stringBuffer.append("};\n");
        this.importFile("testBug102258.h", stringBuffer.toString());
        stringBuffer = new StringBuffer();
        stringBuffer.append("#include \"testBug102258.h\"\n");
        stringBuffer.append("void f(RTBindingEnd & end) {\n");
        stringBuffer.append("}\n");
        String string = stringBuffer.toString();
        IFile iFile = this.importFile("testBug102258.cpp", string);
        int n = string.indexOf("RTBindingEnd");
        this.testCtrl_F3(iFile, n);
        IASTNode iASTNode = this.testF3(iFile, n);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"RTBindingEnd");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)7);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)12);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"RTBindingEnd");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)7);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)12);
    }

    public void testBug103323() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace foo {\n");
        stringBuffer.append("int g() {\n");
        stringBuffer.append("return 0;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("}\n");
        stringBuffer.append("int f() {\n");
        stringBuffer.append("return foo::g();\n");
        stringBuffer.append("}\n");
        String string = stringBuffer.toString();
        IFile iFile = this.importFile("testBug103323.cpp", string);
        int n = string.indexOf("g();\n");
        int n2 = "g()".length();
        this.testSimple_Ctrl_G_Selection(iFile, n, n2, 1);
    }

    public void testBug78354() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("typedef int TestTypeOne;\n");
        stringBuffer.append("typedef int TestTypeTwo;\n");
        stringBuffer.append("main()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("TestTypeOne myFirstLink = 5;\n");
        stringBuffer.append("TestTypeTwo mySecondLink = 6;\n");
        stringBuffer.append("return 0;\n");
        stringBuffer.append("}\n");
        String string = stringBuffer.toString();
        IFile iFile = this.importFileWithLink("testBug78354.cpp", string);
        int n = string.indexOf("TestTypeOne myFirstLink = 5;");
        IASTNode iASTNode = this.testF3(iFile, n);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"TestTypeOne");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)12);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)11);
    }

    public void testBug103697() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int x;\n");
        stringBuffer.append("int foo() {\n");
        stringBuffer.append(" return x;\n");
        stringBuffer.append("}\n");
        String string = stringBuffer.toString();
        IFile iFile = this.importFileWithLink("testBug103697.cpp", string);
        int n = string.indexOf("return x;\n") + "return ".length();
        IASTNode iASTNode = this.testCtrl_F3(iFile, n);
        IASTNode iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"x");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)4);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"x");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)4);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
    }

    public void testBug76043() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int x;\n");
        stringBuffer.append("int foo() {\n");
        stringBuffer.append(" return x;\n");
        stringBuffer.append("}\n");
        String string = stringBuffer.toString();
        IFile iFile = this.importFileInsideLinkedFolder("testBug76043.c", string, "folder");
        CPPSelectionTestsDOMIndexer.assertFalse((boolean)iFile.isLinked());
        int n = string.indexOf("return x;\n") + "return ".length();
        IASTNode iASTNode = this.testCtrl_F3(iFile, n);
        IASTNode iASTNode2 = this.testF3(iFile, n);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"x");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)4);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"x");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)4);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
    }

    public void testBug108202() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class __attribute__((visibility(\"default\"))) FooClass\n");
        stringBuffer.append("{\n");
        stringBuffer.append("int foo();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("int FooClass::foo() {\n");
        stringBuffer.append("return 0;\n");
        stringBuffer.append("}\n");
        String string = stringBuffer.toString();
        IFile iFile = this.importFile("testBug108202.cpp", string);
        int n = string.indexOf("foo();\n");
        IASTNode iASTNode = this.testCtrl_F3(iFile, n);
        this.testF3(iFile, n);
        CPPSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CPPSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"foo");
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)84);
        CPPSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)3);
    }
}

