/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.tests.text.selectiontests;

import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.testplugin.CProjectHelper;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.make.core.MakeProjectNature;
import org.eclipse.cdt.make.core.scannerconfig.ScannerConfigNature;
import org.eclipse.cdt.make.internal.core.scannerconfig2.PerProjectSICollector;
import org.eclipse.cdt.ui.tests.text.selectiontests.BaseSelectionTestsIndexer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class CSelectionTestsDOMIndexer
extends BaseSelectionTestsIndexer {
    private static final String INDEX_TAG = "1161844423.index";
    IFile file;
    NullProgressMonitor monitor;
    static final String sourceIndexerID = "org.eclipse.cdt.core.domsourceindexer";
    static /* synthetic */ Class class$0;

    public CSelectionTestsDOMIndexer(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.project = this.createProject("CSelectionTestsDOMIndexerProject");
        IPath iPath = CCorePlugin.getDefault().getStateLocation();
        File file = new File(iPath.append(INDEX_TAG).toOSString());
        if (file.exists()) {
            file.delete();
        }
        if (this.project == null) {
            CSelectionTestsDOMIndexer.fail((String)"Unable to create project");
        }
        ResourcesPlugin.getWorkspace().newProjectDescription(this.project.getName());
        MakeProjectNature.addNature((IProject)this.project, (IProgressMonitor)new NullProgressMonitor());
        ScannerConfigNature.addScannerConfigNature((IProject)this.project);
        PerProjectSICollector.calculateCompilerBuiltins((IProject)this.project);
        this.resetIndexer(sourceIndexerID);
    }

    protected void tearDown() {
        try {
            super.tearDown();
        }
        catch (Exception exception) {}
        if (this.project.exists()) {
            try {
                System.gc();
                System.runFinalization();
                this.project.delete(true, (IProgressMonitor)this.monitor);
            }
            catch (CoreException coreException) {
                CSelectionTestsDOMIndexer.fail((String)this.getMessage(coreException.getStatus()));
            }
        }
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.ui.tests.text.selectiontests.CSelectionTestsDOMIndexer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite testSuite = new TestSuite(clazz.getName());
        testSuite.addTest((Test)new CSelectionTestsDOMIndexer("testBug78354"));
        testSuite.addTest((Test)new CSelectionTestsDOMIndexer("testSimpleOpenDeclaration"));
        testSuite.addTest((Test)new CSelectionTestsDOMIndexer("testSimpleOpenDeclaration2"));
        testSuite.addTest((Test)new CSelectionTestsDOMIndexer("testBasicDefinition"));
        testSuite.addTest((Test)new CSelectionTestsDOMIndexer("testCPPSpecDeclsDefs"));
        testSuite.addTest((Test)new CSelectionTestsDOMIndexer("testNoDefinitions"));
        testSuite.addTest((Test)new CSelectionTestsDOMIndexer("testOpenFileDiffDir"));
        testSuite.addTest((Test)new CSelectionTestsDOMIndexer("testBug101287"));
        testSuite.addTest((Test)new CSelectionTestsDOMIndexer("testBug103697"));
        testSuite.addTest((Test)new CSelectionTestsDOMIndexer("testBug76043"));
        return testSuite;
    }

    private IProject createProject(String string) throws CoreException {
        ICProject iCProject = CProjectHelper.createCCProject((String)string, (String)"bin");
        return iCProject.getProject();
    }

    public void testSimpleOpenDeclaration() throws Exception {
        String string = "int x() { return 1; }";
        this.importFile("test.h", string);
        String string2 = "int foo() { \n return x();\n}\n";
        IFile iFile = this.importFile("test.c", string2);
        int n = string2.indexOf("x();\n}\n");
        IASTNode iASTNode = this.testCtrl_F3(iFile, n);
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)string.indexOf("x"));
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)"x".length());
        IASTNode iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)string.indexOf("x"));
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)"x".length());
    }

    public void testSimpleOpenDeclaration2() throws Exception {
        String string = "int x;\r\n // comment \r\n int y() { return 1; } /* comment */ \r\n int z; \r\n";
        this.importFile("testSimpleOpenDeclaration2.h", string);
        String string2 = "int foo() { \n return y();\n}\n";
        IFile iFile = this.importFile("testSimpleOpenDeclaration2.c", string2);
        int n = string2.indexOf("y();\n}\n");
        IASTNode iASTNode = this.testCtrl_F3(iFile, n);
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)string.indexOf("y"));
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)"y".length());
        IASTNode iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)string.indexOf("y"));
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)"y".length());
    }

    public void testBasicDefinition() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("extern int MyInt;       // MyInt is in another file\n");
        stringBuffer.append("extern const int MyConst;   // MyConst is in another file\n");
        stringBuffer.append("void MyFunc(int);       // often used in header files\n");
        stringBuffer.append("struct MyStruct;        // often used in header files\n");
        stringBuffer.append("typedef int NewInt;     // a normal typedef statement\n");
        stringBuffer.append("int MyInt;\n");
        stringBuffer.append("extern const int MyConst = 42;\n");
        stringBuffer.append("void MyFunc(int a) { cout << a << endl; }\n");
        stringBuffer.append("struct MyStruct { int Member1; int Member2; };\n");
        String string = stringBuffer.toString();
        IFile iFile = this.importFile("testBasicDefinition.c", string);
        int n = string.indexOf("MyInt;\n") + 2;
        IASTNode iASTNode = this.testCtrl_F3(iFile, n);
        IASTNode iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"MyInt");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)11);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)5);
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"MyInt");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)276);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)5);
        n = string.indexOf("MyConst = 42") + 2;
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"MyConst");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)69);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)7);
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"MyConst");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)300);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)7);
        n = string.indexOf("MyFunc(int a)") + 2;
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"MyFunc");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)115);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)6);
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"MyFunc");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)319);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)6);
        n = string.indexOf("MyStruct {") + 2;
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"MyStruct");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)171);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)8);
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"MyStruct");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)363);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)8);
    }

    public void testCPPSpecDeclsDefs() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int a; // defines a\n");
        stringBuffer.append("extern const int c = 1; // defines c\n");
        stringBuffer.append("int f(int x) { return x+a; } // defines f and defines x\n");
        stringBuffer.append("struct S { int a; int b; }; // defines S, S::a, and S::b\n");
        stringBuffer.append("struct X { // defines X\n");
        stringBuffer.append("int x; // defines nonstatic data member x\n");
        stringBuffer.append("};\n");
        stringBuffer.append("enum { up, down }; // defines up and down\n");
        stringBuffer.append("struct X anX; // defines anX\n");
        stringBuffer.append("extern int a; // declares a\n");
        stringBuffer.append("extern const int c; // declares c\n");
        stringBuffer.append("int f(int); // declares f\n");
        stringBuffer.append("struct S; // declares S\n");
        stringBuffer.append("typedef int Int; // declares Int\n");
        stringBuffer.append("extern struct X anotherX; // declares anotherX\n");
        String string = stringBuffer.toString();
        IFile iFile = this.importFile("testCPPSpecDeclsDefs.c", string);
        int n = string.indexOf("a; // defines a");
        IASTNode iASTNode = this.testCtrl_F3(iFile, n);
        IASTNode iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"a");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)4);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"a");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)4);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("c = 1; // defines c");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"c");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)37);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"c");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)37);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("f(int x) { return x+a; } // defines f and defines x");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"f");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)61);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"f");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)61);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("x) { return x+a; } // defines f and defines x");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"x");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)67);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"x");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)67);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("x+a; } // defines f and defines x");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"x");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)67);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"x");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)67);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("x+a; } // defines f and defines x");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"x");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)67);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"x");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)67);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("a; } // defines f and defines x");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"a");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)4);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"a");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)4);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("S { int a; int b; }; // defines S, S::a, and S::b");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"S");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)120);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"S");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)120);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("a; int b; }; // defines S, S::a, and S::b");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"a");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)128);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"a");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)128);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("b; }; // defines S, S::a, and S::b");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"b");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)135);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"b");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)135);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("X { // defines X");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"X");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)177);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"X");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)177);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("x; // defines nonstatic data member x");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"x");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)198);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"x");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)198);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("up, down }; // defines up and down");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"up");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)246);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)2);
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"up");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)246);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)2);
        n = string.indexOf("down }; // defines up and down");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"down");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)250);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)4);
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"down");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)250);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)4);
        n = string.indexOf("X anX; // defines anX");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"X");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)177);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"X");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)177);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("anX; // defines anX");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"anX");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)290);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)3);
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"anX");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)290);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)3);
        n = string.indexOf("a; // declares a");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"a");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)4);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"a");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)4);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("c; // declares c");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"c");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)37);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"c");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)37);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("f(int); // declares f");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"f");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)61);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"f");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)61);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("S; // declares S");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"S");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)120);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"S");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)120);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("Int; // declares Int");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"Int");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)434);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)3);
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"Int");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)434);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)3);
        n = string.indexOf("X anotherX; // declares anotherX");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"X");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)177);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"X");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)177);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("anotherX; // declares anotherX");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsDOMIndexer.assertNull((Object)iASTNode);
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"anotherX");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)471);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)8);
    }

    public void testNoDefinitions() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("extern int a1; // declares a\n");
        stringBuffer.append("extern const int c1; // declares c\n");
        stringBuffer.append("int f1(int); // declares f\n");
        stringBuffer.append("struct S1; // declares S\n");
        stringBuffer.append("typedef int Int; // declares Int\n");
        String string = stringBuffer.toString();
        IFile iFile = this.importFile("testNoDefinitions.c", string);
        int n = string.indexOf("a1; // declares a");
        IASTNode iASTNode = this.testCtrl_F3(iFile, n);
        IASTNode iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsDOMIndexer.assertNull((Object)iASTNode);
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"a1");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)11);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)2);
        n = string.indexOf("c1; // declares c");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsDOMIndexer.assertNull((Object)iASTNode);
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"c1");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)46);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)2);
        n = string.indexOf("f1(int); // declares f");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsDOMIndexer.assertNull((Object)iASTNode);
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"f1");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)68);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)2);
        n = string.indexOf("S1; // declares S");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsDOMIndexer.assertNull((Object)iASTNode);
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"S1");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)98);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)2);
        n = string.indexOf("Int; // declares Int");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"Int");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)128);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)3);
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"Int");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)128);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)3);
    }

    public void testOpenFileDiffDir() throws Exception {
        this.importFolder("test");
        String string = "int x;\r\n // comment \r\n int y(){ return 1; } /* comment */ \r\n int z; \r\n";
        this.importFile("test/test.h", string);
        String string2 = "int foo() { \n return y();\n}\n";
        IFile iFile = this.importFile("test.c", string2);
        int n = string2.indexOf("y();\n}\n");
        IASTNode iASTNode = this.testCtrl_F3(iFile, n);
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)string.indexOf("y"));
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)"y".length());
        IASTNode iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)string.indexOf("y"));
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)"y".length());
    }

    public void testBug101287() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int abc;\n");
        stringBuffer.append("int main(int argc, char **argv) {\n");
        stringBuffer.append("abc\n");
        stringBuffer.append("}\n");
        String string = stringBuffer.toString();
        IFile iFile = this.importFile("testBug101287.c", string);
        int n = string.indexOf("abc\n");
        this.testCtrl_F3(iFile, n);
        IASTNode iASTNode = this.testF3(iFile, n);
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"abc");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)4);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)3);
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"abc");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)4);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)3);
    }

    public void testBug103697() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int x;\n");
        stringBuffer.append("int foo() {\n");
        stringBuffer.append(" return x;\n");
        stringBuffer.append("}\n");
        String string = stringBuffer.toString();
        IFile iFile = this.importFileWithLink("testBug103697.cpp", string);
        int n = string.indexOf("return x;\n") + "return ".length();
        IASTNode iASTNode = this.testCtrl_F3(iFile, n);
        IASTNode iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"x");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)4);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"x");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)4);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
    }

    public void testBug76043() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int x;\n");
        stringBuffer.append("int foo() {\n");
        stringBuffer.append(" return x;\n");
        stringBuffer.append("}\n");
        String string = stringBuffer.toString();
        IFile iFile = this.importFileInsideLinkedFolder("testBug76043.c", string, "folder");
        CSelectionTestsDOMIndexer.assertFalse((boolean)iFile.isLinked());
        int n = string.indexOf("return x;\n") + "return ".length();
        IASTNode iASTNode = this.testCtrl_F3(iFile, n);
        IASTNode iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"x");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)4);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"x");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)4);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
    }

    public void testBug78354() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("typedef int TestTypeOne;\n");
        stringBuffer.append("typedef int TestTypeTwo;\n");
        stringBuffer.append("main()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("TestTypeOne myFirstLink = 5;\n");
        stringBuffer.append("TestTypeTwo mySecondLink = 6;\n");
        stringBuffer.append("return 0;\n");
        stringBuffer.append("}\n");
        String string = stringBuffer.toString();
        IFile iFile = this.importFileWithLink("testBug78354.cpp", string);
        int n = string.indexOf("TestTypeOne myFirstLink = 5;");
        IASTNode iASTNode = this.testF3(iFile, n);
        CSelectionTestsDOMIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsDOMIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"TestTypeOne");
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)12);
        CSelectionTestsDOMIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)11);
    }
}

