/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.tests.text.selectiontests;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.testplugin.CProjectHelper;
import org.eclipse.cdt.core.testplugin.FileManager;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.parser.ParserException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class CSelectionTestsNoIndexer
extends TestCase {
    private static final String INDEX_FILE_ID = "2324852323";
    static NullProgressMonitor monitor;
    static IWorkspace workspace;
    static IProject project;
    static ICProject cPrj;
    static FileManager fileManager;
    static boolean disabledHelpContributions;
    static /* synthetic */ Class class$0;

    static {
        disabledHelpContributions = false;
    }

    public CSelectionTestsNoIndexer() {
        monitor = new NullProgressMonitor();
        workspace = ResourcesPlugin.getWorkspace();
        try {
            cPrj = CProjectHelper.createCProject((String)"CSelectionTestsNoIndexerProject", (String)"bin");
            project = cPrj.getProject();
            IPath iPath = CCorePlugin.getDefault().getStateLocation();
            File file = new File(iPath.append("2324852323.index").toOSString());
            if (file.exists()) {
                file.delete();
            }
        }
        catch (CoreException coreException) {}
        if (project == null) {
            CSelectionTestsNoIndexer.fail((String)"Unable to create project");
        }
        fileManager = new FileManager();
    }

    public CSelectionTestsNoIndexer(String string) {
        super(string);
        monitor = new NullProgressMonitor();
        workspace = ResourcesPlugin.getWorkspace();
        try {
            cPrj = CProjectHelper.createCProject((String)"CSelectionTestsNoIndexerProject", (String)"bin");
            project = cPrj.getProject();
            IPath iPath = CCorePlugin.getDefault().getStateLocation();
            File file = new File(iPath.append("2324852323.index").toOSString());
            if (file.exists()) {
                file.delete();
            }
        }
        catch (CoreException coreException) {}
        if (project == null) {
            CSelectionTestsNoIndexer.fail((String)"Unable to create project");
        }
        fileManager = new FileManager();
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.ui.tests.text.selectiontests.CSelectionTestsNoIndexer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite testSuite = new TestSuite((Class)clazz);
        testSuite.addTest((Test)new CSelectionTestsNoIndexer("cleanupProject"));
        return testSuite;
    }

    public void cleanupProject() throws Exception {
        try {
            project.delete(true, false, (IProgressMonitor)monitor);
            project = null;
        }
        catch (Throwable throwable) {}
    }

    protected void tearDown() throws Exception {
        if (project == null || !project.exists()) {
            return;
        }
        IResource[] iResourceArray = project.members();
        int n = 0;
        while (n < iResourceArray.length) {
            if (!iResourceArray[n].getName().equals(".project") && !iResourceArray[n].getName().equals(".cdtproject")) {
                try {
                    iResourceArray[n].delete(false, (IProgressMonitor)monitor);
                }
                catch (Throwable throwable) {}
            }
            ++n;
        }
    }

    protected IFile importFile(String string, String string2) throws Exception {
        IFile iFile = project.getProject().getFile(string);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes());
        if (iFile.exists()) {
            iFile.setContents((InputStream)byteArrayInputStream, false, false, (IProgressMonitor)monitor);
        } else {
            iFile.create((InputStream)byteArrayInputStream, false, (IProgressMonitor)monitor);
        }
        fileManager.addFile(iFile);
        return iFile;
    }

    protected IFile importFileWithLink(String string, String string2) throws Exception {
        IFile iFile = project.getProject().getFile(string);
        Path path = new Path(String.valueOf(project.getLocation().removeLastSegments(1).toOSString()) + File.separator + string);
        File file = new File(path.toOSString());
        if (!file.exists()) {
            file.createNewFile();
        }
        iFile.createLink((IPath)path, 16, null);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes());
        if (iFile.exists()) {
            iFile.setContents((InputStream)byteArrayInputStream, false, false, (IProgressMonitor)monitor);
        } else {
            iFile.create((InputStream)byteArrayInputStream, false, (IProgressMonitor)monitor);
        }
        fileManager.addFile(iFile);
        return iFile;
    }

    protected IFile importFileInsideLinkedFolder(String string, String string2, String string3) throws Exception {
        IFolder iFolder = project.getFolder(string3);
        Path path = new Path(String.valueOf(project.getLocation().toOSString()) + File.separator + string3 + "_this_is_linked");
        IFolder iFolder2 = project.getFolder(String.valueOf(string3) + "_this_is_linked");
        if (!iFolder2.exists()) {
            iFolder2.create(true, true, (IProgressMonitor)monitor);
        }
        iFolder.createLink((IPath)path, 0, (IProgressMonitor)monitor);
        iFolder2.delete(true, false, (IProgressMonitor)monitor);
        IFile iFile = iFolder.getFile(string);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes());
        if (iFile.exists()) {
            iFile.setContents((InputStream)byteArrayInputStream, false, false, (IProgressMonitor)monitor);
        } else {
            iFile.create((InputStream)byteArrayInputStream, false, (IProgressMonitor)monitor);
        }
        fileManager.addFile(iFile);
        return iFile;
    }

    protected IFile importFileWithLink(String string, String string2, IFolder iFolder) throws Exception {
        if (!iFolder.exists()) {
            iFolder.create(true, true, null);
        }
        IFile iFile = project.getProject().getFile(string);
        Path path = new Path(String.valueOf(iFolder.getLocation().toOSString()) + File.separator + string);
        File file = new File(path.toOSString());
        if (!file.exists()) {
            file.createNewFile();
        }
        iFile.createLink((IPath)path, 16, null);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes());
        if (iFile.exists()) {
            iFile.setContents((InputStream)byteArrayInputStream, false, false, (IProgressMonitor)monitor);
        } else {
            iFile.create((InputStream)byteArrayInputStream, false, (IProgressMonitor)monitor);
        }
        fileManager.addFile(iFile);
        return iFile;
    }

    protected IFolder importFolder(String string) throws Exception {
        IFolder iFolder = project.getProject().getFolder(string);
        if (!iFolder.exists()) {
            iFolder.create(false, false, (IProgressMonitor)monitor);
        }
        return iFolder;
    }

    protected IASTNode testF3(IFile iFile, int n) throws ParserException, CoreException {
        return this.testF3(iFile, n, 0);
    }

    protected IASTNode testF3(IFile iFile, int n, int n2) throws ParserException, CoreException {
        this.disableIndex();
        if (n < 0) {
            throw new ParserException("offset can not be less than 0 and was " + n);
        }
        IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart iEditorPart = null;
        try {
            iEditorPart = iWorkbenchPage.openEditor((IEditorInput)new FileEditorInput(iFile), "org.eclipse.cdt.ui.editor.CEditor");
        }
        catch (PartInitException partInitException) {
            CSelectionTestsNoIndexer.assertFalse((boolean)true);
        }
        if (iEditorPart instanceof AbstractTextEditor) {
            ((AbstractTextEditor)iEditorPart).getSelectionProvider().setSelection((ISelection)new TextSelection(n, n2));
            IAction iAction = ((AbstractTextEditor)iEditorPart).getAction("OpenDeclarations");
            iAction.run();
            ISelection iSelection = ((AbstractTextEditor)iEditorPart).getSelectionProvider().getSelection();
            if (iSelection instanceof TextSelection) {
                ITextSelection iTextSelection = (ITextSelection)iSelection;
                ITranslationUnit iTranslationUnit = (ITranslationUnit)CoreModel.getDefault().create(iFile);
                IASTTranslationUnit iASTTranslationUnit = iTranslationUnit.getLanguage().getASTTranslationUnit(iTranslationUnit, 0);
                IASTName[] iASTNameArray = iTranslationUnit.getLanguage().getSelectedNames(iASTTranslationUnit, iTextSelection.getOffset(), iTextSelection.getLength());
                if (iASTNameArray == null || iASTNameArray.length == 0) {
                    return null;
                }
                return iASTNameArray[0];
            }
        }
        return null;
    }

    protected IASTNode testCtrl_F3(IFile iFile, int n) throws ParserException, CoreException {
        return this.testCtrl_F3(iFile, n, 0);
    }

    protected IASTNode testCtrl_F3(IFile iFile, int n, int n2) throws ParserException, CoreException {
        this.disableIndex();
        if (n < 0) {
            throw new ParserException("offset can not be less than 0 and was " + n);
        }
        IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart iEditorPart = null;
        try {
            iEditorPart = iWorkbenchPage.openEditor((IEditorInput)new FileEditorInput(iFile), "org.eclipse.cdt.ui.editor.CEditor");
        }
        catch (PartInitException partInitException) {
            CSelectionTestsNoIndexer.assertFalse((boolean)true);
        }
        if (iEditorPart instanceof AbstractTextEditor) {
            ((AbstractTextEditor)iEditorPart).getSelectionProvider().setSelection((ISelection)new TextSelection(n, n2));
            IAction iAction = ((AbstractTextEditor)iEditorPart).getAction("OpenDefinition");
            iAction.run();
            ISelection iSelection = ((AbstractTextEditor)iEditorPart).getSelectionProvider().getSelection();
            if (iSelection instanceof TextSelection) {
                ITextSelection iTextSelection = (ITextSelection)iSelection;
                ITranslationUnit iTranslationUnit = (ITranslationUnit)CoreModel.getDefault().create(iFile);
                IASTTranslationUnit iASTTranslationUnit = iTranslationUnit.getLanguage().getASTTranslationUnit(iTranslationUnit, 0);
                IASTName[] iASTNameArray = iTranslationUnit.getLanguage().getSelectedNames(iASTTranslationUnit, iTextSelection.getOffset(), iTextSelection.getLength());
                if (iASTNameArray == null || iASTNameArray.length == 0) {
                    return null;
                }
                return iASTNameArray[0];
            }
        }
        return null;
    }

    private void disableIndex() {
        IPath iPath = CCorePlugin.getDefault().getStateLocation();
        File file = new File(iPath.append("2324852323.index").toOSString());
        if (file.exists()) {
            file.delete();
        }
    }

    public void testBasicDefinition() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("extern int MyInt;       // MyInt is in another file\n");
        stringBuffer.append("extern const int MyConst;   // MyConst is in another file\n");
        stringBuffer.append("void MyFunc(int);       // often used in header files\n");
        stringBuffer.append("struct MyStruct;        // often used in header files\n");
        stringBuffer.append("typedef int NewInt;     // a normal typedef statement\n");
        stringBuffer.append("int MyInt;\n");
        stringBuffer.append("extern const int MyConst = 42;\n");
        stringBuffer.append("void MyFunc(int a) { cout << a << endl; }\n");
        stringBuffer.append("struct MyStruct { int Member1; int Member2; };\n");
        String string = stringBuffer.toString();
        IFile iFile = this.importFile("testBasicDefinition.c", string);
        int n = string.indexOf("MyInt;\n") + 2;
        IASTNode iASTNode = this.testCtrl_F3(iFile, n);
        IASTNode iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"MyInt");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)11);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)5);
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"MyInt");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)276);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)5);
        n = string.indexOf("MyConst = 42") + 2;
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"MyConst");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)69);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)7);
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"MyConst");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)300);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)7);
        n = string.indexOf("MyFunc(int a)") + 2;
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"MyFunc");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)115);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)6);
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"MyFunc");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)319);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)6);
        n = string.indexOf("MyStruct {") + 2;
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"MyStruct");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)171);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)8);
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"MyStruct");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)363);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)8);
    }

    public void testCPPSpecDeclsDefs() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int a; // defines a\n");
        stringBuffer.append("extern const int c = 1; // defines c\n");
        stringBuffer.append("int f(int x) { return x+a; } // defines f and defines x\n");
        stringBuffer.append("struct S { int a; int b; }; // defines S, S::a, and S::b\n");
        stringBuffer.append("struct X { // defines X\n");
        stringBuffer.append("int x; // defines nonstatic data member x\n");
        stringBuffer.append("};\n");
        stringBuffer.append("enum { up, down }; // defines up and down\n");
        stringBuffer.append("struct X anX; // defines anX\n");
        stringBuffer.append("extern int a; // declares a\n");
        stringBuffer.append("extern const int c; // declares c\n");
        stringBuffer.append("int f(int); // declares f\n");
        stringBuffer.append("struct S; // declares S\n");
        stringBuffer.append("typedef int Int; // declares Int\n");
        stringBuffer.append("extern struct X anotherX; // declares anotherX\n");
        String string = stringBuffer.toString();
        IFile iFile = this.importFile("testCPPSpecDeclsDefs.c", string);
        int n = string.indexOf("a; // defines a");
        IASTNode iASTNode = this.testCtrl_F3(iFile, n);
        IASTNode iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"a");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)4);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"a");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)4);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("c = 1; // defines c");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"c");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)37);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"c");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)37);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("f(int x) { return x+a; } // defines f and defines x");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"f");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)61);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"f");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)61);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("x) { return x+a; } // defines f and defines x");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"x");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)67);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"x");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)67);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("x+a; } // defines f and defines x");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"x");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)67);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"x");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)67);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("x+a; } // defines f and defines x");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"x");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)67);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"x");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)67);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("a; } // defines f and defines x");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"a");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)4);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"a");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)4);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("S { int a; int b; }; // defines S, S::a, and S::b");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"S");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)120);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"S");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)120);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("a; int b; }; // defines S, S::a, and S::b");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"a");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)128);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"a");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)128);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("b; }; // defines S, S::a, and S::b");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"b");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)135);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"b");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)135);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("X { // defines X");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"X");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)177);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"X");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)177);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("x; // defines nonstatic data member x");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"x");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)198);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"x");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)198);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("up, down }; // defines up and down");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"up");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)246);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)2);
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"up");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)246);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)2);
        n = string.indexOf("down }; // defines up and down");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"down");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)250);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)4);
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"down");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)250);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)4);
        n = string.indexOf("X anX; // defines anX");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"X");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)177);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"X");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)177);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("anX; // defines anX");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"anX");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)290);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)3);
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"anX");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)290);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)3);
        n = string.indexOf("a; // declares a");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"a");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)4);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"a");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)4);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("c; // declares c");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"c");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)37);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"c");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)37);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("f(int); // declares f");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"f");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)61);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"f");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)61);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("S; // declares S");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"S");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)120);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"S");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)120);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("Int; // declares Int");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"Int");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)434);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)3);
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"Int");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)434);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)3);
        n = string.indexOf("X anotherX; // declares anotherX");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"X");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)177);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"X");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)177);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("anotherX; // declares anotherX");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsNoIndexer.assertNull((Object)iASTNode);
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"anotherX");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)471);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)8);
    }

    public void testNoDefinitions() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("extern int a1; // declares a\n");
        stringBuffer.append("extern const int c1; // declares c\n");
        stringBuffer.append("int f1(int); // declares f\n");
        stringBuffer.append("struct S1; // declares S\n");
        stringBuffer.append("typedef int Int; // declares Int\n");
        String string = stringBuffer.toString();
        IFile iFile = this.importFile("testNoDefinitions.c", string);
        int n = string.indexOf("a1; // declares a");
        IASTNode iASTNode = this.testCtrl_F3(iFile, n);
        IASTNode iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsNoIndexer.assertNull((Object)iASTNode);
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"a1");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)11);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)2);
        n = string.indexOf("c1; // declares c");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsNoIndexer.assertNull((Object)iASTNode);
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"c1");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)46);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)2);
        n = string.indexOf("f1(int); // declares f");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsNoIndexer.assertNull((Object)iASTNode);
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"f1");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)68);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)2);
        n = string.indexOf("S1; // declares S");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsNoIndexer.assertNull((Object)iASTNode);
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"S1");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)98);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)2);
        n = string.indexOf("Int; // declares Int");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"Int");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)128);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)3);
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"Int");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)128);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)3);
    }

    public void testBug103697() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int x;\n");
        stringBuffer.append("int foo() {\n");
        stringBuffer.append(" return x;\n");
        stringBuffer.append("}\n");
        String string = stringBuffer.toString();
        IFile iFile = this.importFileWithLink("testBug103697.cpp", string);
        int n = string.indexOf("return x;\n") + "return ".length();
        IASTNode iASTNode = this.testCtrl_F3(iFile, n);
        IASTNode iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"x");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)4);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"x");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)4);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
    }

    public void testBug76043() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int x;\n");
        stringBuffer.append("int foo() {\n");
        stringBuffer.append(" return x;\n");
        stringBuffer.append("}\n");
        String string = stringBuffer.toString();
        IFile iFile = this.importFileInsideLinkedFolder("testBug76043.c", string, "folder");
        CSelectionTestsNoIndexer.assertFalse((boolean)iFile.isLinked());
        int n = string.indexOf("return x;\n") + "return ".length();
        IASTNode iASTNode = this.testCtrl_F3(iFile, n);
        IASTNode iASTNode2 = this.testF3(iFile, n);
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"x");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)4);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"x");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)4);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
    }

    public void testBug78354() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("typedef int TestTypeOne;\n");
        stringBuffer.append("typedef int TestTypeTwo;\n");
        stringBuffer.append("main()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("TestTypeOne myFirstLink = 5;\n");
        stringBuffer.append("TestTypeTwo mySecondLink = 6;\n");
        stringBuffer.append("return 0;\n");
        stringBuffer.append("}\n");
        String string = stringBuffer.toString();
        IFile iFile = this.importFileWithLink("testBug78354.cpp", string);
        int n = string.indexOf("TestTypeOne myFirstLink = 5;");
        IASTNode iASTNode = this.testF3(iFile, n);
        CSelectionTestsNoIndexer.assertTrue((boolean)(iASTNode instanceof IASTName));
        CSelectionTestsNoIndexer.assertEquals((String)((IASTName)iASTNode).toString(), (String)"TestTypeOne");
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)12);
        CSelectionTestsNoIndexer.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)11);
    }
}

