/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.core.tests;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.CCProjectNature;
import org.eclipse.cdt.managedbuilder.buildmodel.BuildDescriptionManager;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildDescription;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildIOType;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildResource;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildStep;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IAdditionalInput;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOutputType;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.BuildDescription;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.BuildIOType;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.BuildResource;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.BuildStep;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.DbgUtil;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.testplugin.ManagedBuildTestHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class BuildDescriptionModelTests
extends TestCase {
    private static final String PREFIX = "BuildDescription_";
    private static final String PROJ_PATH = "testBuildDescriptionProjects";
    private CompositeCleaner fCompositeCleaner = new CompositeCleaner();
    private Runnable fCleaner = this.fCompositeCleaner;
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.managedbuilder.core.tests.BuildDescriptionModelTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public void testDes_Model() {
        IProject iProject = this.createProject("BuildDescription_1", "test30_2.tar");
        IFile iFile = ManagedBuildTestHelper.createFile(iProject, "a.asm");
        ManagedBuildTestHelper.createFile(iProject, "b.asm");
        ManagedBuildTestHelper.createFile(iProject, "c.cpp");
        ManagedBuildTestHelper.createFile(iProject, "d.cpp");
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
        IManagedProject iManagedProject = iManagedBuildInfo.getManagedProject();
        IConfiguration iConfiguration = iManagedProject.getConfigurations()[0];
        iConfiguration.setArtifactExtension("tmp");
        iConfiguration.getName();
        BuildDescription buildDescription = new BuildDescription(iConfiguration);
        BuildResource buildResource = buildDescription.createResource("a.asm");
        BuildDescriptionModelTests.assertNotNull((String)"failed to create resource a.asm", (Object)buildResource);
        if (buildResource != buildDescription.createResource((IResource)iFile)) {
            BuildDescriptionModelTests.fail((String)"new build resource created for the same resource");
        }
        if (buildResource != buildDescription.createResource("a.asm")) {
            BuildDescriptionModelTests.fail((String)"new build resource created for the same resource");
        }
        if (buildResource != buildDescription.createResource(iFile.getLocation(), iFile.getFullPath())) {
            BuildDescriptionModelTests.fail((String)"new build resource created for the same resource");
        }
        BuildDescriptionModelTests.assertEquals((Object)buildResource.getProducerIOType(), null);
        BuildDescriptionModelTests.assertEquals((int)buildResource.getDependentIOTypes().length, (int)0);
        BuildStep buildStep = (BuildStep)buildDescription.getInputStep();
        BuildDescriptionModelTests.assertEquals((String)"input step has inputs", (int)buildStep.getInputIOTypes().length, (int)0);
        BuildDescriptionModelTests.assertEquals((String)"initial input step has outputs", (int)buildStep.getOutputIOTypes().length, (int)0);
        BuildIOType buildIOType = buildStep.createIOType(false, true, null);
        if (buildIOType == null) {
            BuildDescriptionModelTests.fail((String)"failed to create output type");
        }
        BuildDescriptionModelTests.assertEquals((Object)buildIOType.getStep(), (Object)buildStep);
        buildIOType.addResource(buildResource);
        BuildDescriptionModelTests.assertEquals((Object)buildResource.getProducerIOType(), (Object)buildIOType);
        BuildDescriptionModelTests.assertEquals((int)buildResource.getDependentIOTypes().length, (int)0);
        BuildDescriptionModelTests.assertEquals((String)"input step has inputs", (int)buildStep.getInputIOTypes().length, (int)0);
        BuildDescriptionModelTests.assertEquals((int)buildStep.getOutputIOTypes().length, (int)1);
        BuildDescriptionModelTests.assertEquals((Object)buildStep.getOutputIOTypes()[0], (Object)buildIOType);
        BuildDescriptionModelTests.assertEquals((int)buildIOType.getResources().length, (int)1);
        BuildDescriptionModelTests.assertEquals((Object)buildIOType.getResources()[0], (Object)buildResource);
        BuildResource buildResource2 = buildDescription.createResource("b.asm");
        BuildDescriptionModelTests.assertEquals((Object)buildResource2.getProducerIOType(), null);
        BuildDescriptionModelTests.assertEquals((int)buildResource2.getDependentIOTypes().length, (int)0);
        buildIOType.addResource(buildResource2);
        BuildDescriptionModelTests.assertEquals((Object)buildResource2.getProducerIOType(), (Object)buildIOType);
        BuildDescriptionModelTests.assertEquals((int)buildResource2.getDependentIOTypes().length, (int)0);
        BuildDescriptionModelTests.assertEquals((String)"input step has inputs", (int)buildStep.getInputIOTypes().length, (int)0);
        BuildDescriptionModelTests.assertEquals((int)buildStep.getOutputIOTypes().length, (int)1);
        BuildDescriptionModelTests.assertEquals((Object)buildStep.getOutputIOTypes()[0], (Object)buildIOType);
        BuildDescriptionModelTests.assertEquals((int)buildIOType.getResources().length, (int)2);
        BuildStep buildStep2 = buildDescription.createStep(null, null);
        BuildDescriptionModelTests.assertEquals((String)"new step has inputs", (int)buildStep.getInputIOTypes().length, (int)0);
        BuildDescriptionModelTests.assertEquals((String)"new step has outputs", (int)buildStep.getOutputIOTypes().length, (int)1);
        BuildIOType buildIOType2 = buildStep2.createIOType(true, true, null);
        if (buildIOType2 == null) {
            BuildDescriptionModelTests.fail((String)"failed to create in type");
        }
        BuildDescriptionModelTests.assertEquals((Object)buildIOType2.getStep(), (Object)buildStep2);
        BuildDescriptionModelTests.assertEquals((Object)buildResource.getProducerIOType(), (Object)buildIOType);
        BuildDescriptionModelTests.assertEquals((int)buildResource.getDependentIOTypes().length, (int)0);
        buildIOType2.addResource(buildResource);
        BuildDescriptionModelTests.assertEquals((Object)buildResource.getProducerIOType(), (Object)buildIOType);
        BuildDescriptionModelTests.assertEquals((int)buildResource.getDependentIOTypes().length, (int)1);
        BuildDescriptionModelTests.assertEquals((Object)buildResource.getDependentIOTypes()[0], (Object)buildIOType2);
        BuildDescriptionModelTests.assertEquals((String)"input step has inputs", (int)buildStep.getInputIOTypes().length, (int)0);
        BuildDescriptionModelTests.assertEquals((int)buildStep.getOutputIOTypes().length, (int)1);
        BuildDescriptionModelTests.assertEquals((Object)buildStep.getOutputIOTypes()[0], (Object)buildIOType);
        BuildDescriptionModelTests.assertEquals((int)buildIOType2.getResources().length, (int)1);
        BuildDescriptionModelTests.assertEquals((Object)buildIOType2.getResources()[0], (Object)buildResource);
        BuildDescriptionModelTests.assertEquals((Object)buildResource2.getProducerIOType(), (Object)buildIOType);
        BuildDescriptionModelTests.assertEquals((int)buildResource2.getDependentIOTypes().length, (int)0);
        buildIOType2.addResource(buildResource2);
        BuildDescriptionModelTests.assertEquals((Object)buildResource2.getProducerIOType(), (Object)buildIOType);
        BuildDescriptionModelTests.assertEquals((int)buildResource2.getDependentIOTypes().length, (int)1);
        BuildDescriptionModelTests.assertEquals((Object)buildResource2.getDependentIOTypes()[0], (Object)buildIOType2);
        BuildDescriptionModelTests.assertEquals((String)"input step has inputs", (int)buildStep.getInputIOTypes().length, (int)0);
        BuildDescriptionModelTests.assertEquals((int)buildStep.getOutputIOTypes().length, (int)1);
        BuildDescriptionModelTests.assertEquals((Object)buildStep.getOutputIOTypes()[0], (Object)buildIOType);
        BuildDescriptionModelTests.assertEquals((int)buildIOType.getResources().length, (int)2);
    }

    public void testDesTest30_2_asm_only() {
        IProject iProject = this.createProject("BuildDescription_1", "test30_2.tar");
        ManagedBuildTestHelper.createFile(iProject, "a.asm");
        ManagedBuildTestHelper.createFile(iProject, "b.asm");
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
        IManagedProject iManagedProject = iManagedBuildInfo.getManagedProject();
        IConfiguration iConfiguration = iManagedProject.getConfigurations()[0];
        iConfiguration.setArtifactExtension("tmp");
        iConfiguration.getName();
        BuildDescription buildDescription = new BuildDescription(iConfiguration);
        IBuildDescription iBuildDescription = null;
        try {
            iBuildDescription = BuildDescriptionManager.createBuildDescription((IConfiguration)iConfiguration, null, (int)3);
        }
        catch (CoreException coreException) {
            BuildDescriptionModelTests.fail((String)("build description creation failed: " + coreException.getLocalizedMessage()));
        }
        this.doTestBuildDescription(iBuildDescription, (IBuildDescription)buildDescription);
    }

    public void testDesTest30_2_empty() {
        IProject iProject = this.createProject("BuildDescription_1", "test30_2.tar");
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
        IManagedProject iManagedProject = iManagedBuildInfo.getManagedProject();
        IConfiguration iConfiguration = iManagedProject.getConfigurations()[0];
        iConfiguration.setArtifactExtension("tmp");
        iConfiguration.getName();
        BuildDescription buildDescription = new BuildDescription(iConfiguration);
        IBuildDescription iBuildDescription = null;
        try {
            iBuildDescription = BuildDescriptionManager.createBuildDescription((IConfiguration)iConfiguration, null, (int)3);
        }
        catch (CoreException coreException) {
            BuildDescriptionModelTests.fail((String)("build description creation failed: " + coreException.getLocalizedMessage()));
        }
        this.doTestBuildDescription(iBuildDescription, (IBuildDescription)buildDescription);
    }

    public void testDesDesTest30_2_cpp_only() {
        IProject iProject = this.createProject("BuildDescription_1", "test30_2.tar");
        ManagedBuildTestHelper.createFile(iProject, "c.cpp");
        ManagedBuildTestHelper.createFile(iProject, "d.cpp");
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
        IManagedProject iManagedProject = iManagedBuildInfo.getManagedProject();
        IConfiguration iConfiguration = iManagedProject.getConfigurations()[0];
        iConfiguration.setArtifactExtension("tmp");
        String string = iConfiguration.getName();
        BuildDescription buildDescription = new BuildDescription(iConfiguration);
        BuildStep buildStep = (BuildStep)buildDescription.getInputStep();
        BuildIOType buildIOType = buildStep.createIOType(false, false, null);
        buildIOType.addResource(buildDescription.createResource("c.cpp"));
        buildIOType.addResource(buildDescription.createResource("d.cpp"));
        buildStep = buildDescription.createStep(null, null);
        buildIOType = buildStep.createIOType(true, true, null);
        buildIOType.addResource(buildDescription.createResource("c.cpp"));
        buildIOType.addResource(buildDescription.createResource("d.cpp"));
        buildIOType = buildStep.createIOType(false, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string) + "/new.tar"));
        buildStep = buildDescription.createStep(null, null);
        buildIOType = buildStep.createIOType(true, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string) + "/new.tar"));
        buildIOType = buildStep.createIOType(false, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string) + "/new.log"));
        buildStep = buildDescription.createStep(null, null);
        buildIOType = buildStep.createIOType(true, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string) + "/new.log"));
        buildIOType = buildStep.createIOType(false, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string) + "/" + iConfiguration.getArtifactName() + ".tmp"));
        buildStep = (BuildStep)buildDescription.getOutputStep();
        buildIOType = buildStep.createIOType(true, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string) + "/" + iConfiguration.getArtifactName() + ".tmp"));
        IBuildDescription iBuildDescription = null;
        try {
            iBuildDescription = BuildDescriptionManager.createBuildDescription((IConfiguration)iConfiguration, null, (int)3);
        }
        catch (CoreException coreException) {
            BuildDescriptionModelTests.fail((String)("build description creation failed: " + coreException.getLocalizedMessage()));
        }
        this.doTestBuildDescription(iBuildDescription, (IBuildDescription)buildDescription);
    }

    public void testDesTest30_1() {
        IProject iProject = this.loadProject("test30_1");
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
        IConfiguration iConfiguration = iManagedBuildInfo.getDefaultConfiguration();
        String string = String.valueOf(iConfiguration.getName()) + "/";
        BuildDescription buildDescription = new BuildDescription(iConfiguration);
        BuildStep buildStep = (BuildStep)buildDescription.getOutputStep();
        BuildIOType buildIOType = buildStep.createIOType(true, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string) + "Test30_1.so.4.5.6"));
        buildIOType = buildStep.createIOType(true, false, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string) + "CDT.jpeg"));
        buildStep = buildDescription.createStep(null, null);
        buildIOType = buildStep.createIOType(false, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string) + "CDT.jpeg"));
        buildIOType = buildStep.createIOType(true, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string) + "CDT.bmp"));
        buildStep = buildDescription.createStep(null, null);
        buildIOType = buildStep.createIOType(false, false, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string) + "f1.c"));
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string) + "f2.c"));
        buildIOType = buildStep.createIOType(false, false, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string) + "test_ar.h"));
        buildIOType = buildStep.createIOType(false, false, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string) + "CDT.bmp"));
        buildIOType = buildStep.createIOType(true, false, null);
        buildIOType.addResource(buildDescription.createResource("test.tar"));
        buildStep = buildDescription.createStep(null, null);
        buildIOType = buildStep.createIOType(false, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string) + "Test30_1.so.4.5.6"));
        buildIOType = buildStep.createIOType(true, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string) + "test30_1.so.1.2.3"));
        buildStep = buildDescription.createStep(null, null);
        buildIOType = buildStep.createIOType(false, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string) + "test30_1.so.1.2.3"));
        buildIOType = buildStep.createIOType(true, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string) + "f1.o"));
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string) + "f2.o"));
        buildStep = buildDescription.createStep(null, null);
        buildIOType = buildStep.createIOType(false, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string) + "f1.o"));
        buildIOType = buildStep.createIOType(true, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string) + "f1.oprestripped"));
        buildStep = buildDescription.createStep(null, null);
        buildIOType = buildStep.createIOType(false, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string) + "f2.o"));
        buildIOType = buildStep.createIOType(true, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string) + "f2.oprestripped"));
        buildStep = buildDescription.createStep(null, null);
        buildIOType = buildStep.createIOType(false, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string) + "f1.oprestripped"));
        buildIOType = buildStep.createIOType(true, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string) + "f1.c"));
        buildStep = buildDescription.createStep(null, null);
        buildIOType = buildStep.createIOType(false, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string) + "f2.oprestripped"));
        buildIOType = buildStep.createIOType(true, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string) + "f2.c"));
        buildStep = (BuildStep)buildDescription.getInputStep();
        buildIOType = buildStep.createIOType(false, true, null);
        buildIOType.addResource(buildDescription.createResource("test.tar"));
        IBuildDescription iBuildDescription = null;
        try {
            iBuildDescription = BuildDescriptionManager.createBuildDescription((IConfiguration)iConfiguration, null, (int)3);
        }
        catch (CoreException coreException) {
            BuildDescriptionModelTests.fail((String)("build description creation failed: " + coreException.getLocalizedMessage()));
        }
        this.doTestBuildDescription(iBuildDescription, (IBuildDescription)buildDescription);
    }

    public void testDesTest30_2() {
        IProject iProject = this.createProject("BuildDescription_1", "test30_2.tar");
        ManagedBuildTestHelper.createFile(iProject, "a.asm");
        ManagedBuildTestHelper.createFile(iProject, "b.asm");
        ManagedBuildTestHelper.createFile(iProject, "c.cpp");
        ManagedBuildTestHelper.createFile(iProject, "d.cpp");
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
        IManagedProject iManagedProject = iManagedBuildInfo.getManagedProject();
        IConfiguration iConfiguration = iManagedProject.getConfigurations()[0];
        iConfiguration.setArtifactExtension("tmp");
        String string = iConfiguration.getName();
        BuildDescription buildDescription = new BuildDescription(iConfiguration);
        BuildStep buildStep = (BuildStep)buildDescription.getInputStep();
        BuildIOType buildIOType = buildStep.createIOType(false, false, null);
        buildIOType.addResource(buildDescription.createResource("a.asm"));
        buildIOType.addResource(buildDescription.createResource("b.asm"));
        buildIOType = buildStep.createIOType(false, false, null);
        buildIOType.addResource(buildDescription.createResource("c.cpp"));
        buildIOType.addResource(buildDescription.createResource("d.cpp"));
        buildStep = buildDescription.createStep(null, null);
        buildIOType = buildStep.createIOType(true, true, null);
        buildIOType.addResource(buildDescription.createResource("c.cpp"));
        buildIOType.addResource(buildDescription.createResource("d.cpp"));
        buildIOType = buildStep.createIOType(true, false, null);
        buildIOType.addResource(buildDescription.createResource("a.asm"));
        buildIOType.addResource(buildDescription.createResource("b.asm"));
        buildIOType = buildStep.createIOType(false, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string) + "/new.tar"));
        buildStep = buildDescription.createStep(null, null);
        buildIOType = buildStep.createIOType(true, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string) + "/new.tar"));
        buildIOType = buildStep.createIOType(false, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string) + "/new.log"));
        buildStep = buildDescription.createStep(null, null);
        buildIOType = buildStep.createIOType(true, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string) + "/new.log"));
        buildIOType = buildStep.createIOType(false, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string) + "/" + iConfiguration.getArtifactName() + ".tmp"));
        buildStep = (BuildStep)buildDescription.getOutputStep();
        buildIOType = buildStep.createIOType(true, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string) + "/" + iConfiguration.getArtifactName() + ".tmp"));
        IBuildDescription iBuildDescription = null;
        try {
            iBuildDescription = BuildDescriptionManager.createBuildDescription((IConfiguration)iConfiguration, null, (int)3);
        }
        catch (CoreException coreException) {
            BuildDescriptionModelTests.fail((String)("build description creation failed: " + coreException.getLocalizedMessage()));
        }
        this.doTestBuildDescription(iBuildDescription, (IBuildDescription)buildDescription);
    }

    private void doTestStep(IBuildStep iBuildStep, IBuildStep iBuildStep2, boolean bl) {
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        this.stepsMatch(iBuildStep, iBuildStep2, hashMap, hashMap2, true);
        HashMap hashMap3 = bl ? hashMap2 : hashMap;
        Iterator iterator = hashMap3.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.doTestType((IBuildIOType)entry.getKey(), (IBuildIOType)entry.getValue());
        }
    }

    private void doTestType(IBuildIOType iBuildIOType, IBuildIOType iBuildIOType2) {
        HashMap hashMap = new HashMap();
        this.typesMatch(iBuildIOType, iBuildIOType2, hashMap, true);
        Iterator iterator = hashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.doTestResource((IBuildResource)entry.getKey(), (IBuildResource)entry.getValue(), !iBuildIOType.isInput());
        }
    }

    private void doTestResource(IBuildResource iBuildResource, IBuildResource iBuildResource2, boolean bl) {
        HashMap hashMap = new HashMap();
        this.doTestResourceMatch(iBuildResource, iBuildResource2, hashMap);
        if (!bl) {
            this.typesMatch(iBuildResource.getProducerIOType(), iBuildResource2.getProducerIOType(), null, true);
            this.doTestStep(iBuildResource.getProducerIOType().getStep(), iBuildResource2.getProducerIOType().getStep(), bl);
        } else {
            HashSet<IBuildStep> hashSet = new HashSet<IBuildStep>();
            Iterator iterator = hashMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                IBuildIOType iBuildIOType = (IBuildIOType)entry.getKey();
                IBuildStep iBuildStep = iBuildIOType.getStep();
                if (!hashSet.add(iBuildStep)) continue;
                IBuildIOType iBuildIOType2 = (IBuildIOType)entry.getValue();
                this.typesMatch(iBuildIOType, iBuildIOType2, null, true);
                this.doTestStep(iBuildStep, iBuildIOType2.getStep(), bl);
            }
        }
    }

    private void doTestResourceMatch(IBuildResource iBuildResource, IBuildResource iBuildResource2, Map map) {
        this.doTrace("matching resource " + DbgUtil.resourceName((IBuildResource)iBuildResource));
        if (!iBuildResource.getLocation().equals((Object)iBuildResource2.getLocation())) {
            this.doFail("different resource locsations", iBuildResource, iBuildResource2);
        }
        IBuildIOType iBuildIOType = iBuildResource.getProducerIOType();
        IBuildIOType iBuildIOType2 = iBuildResource2.getProducerIOType();
        this.typesMatch(iBuildIOType, iBuildIOType2, null, true);
        IBuildIOType[] iBuildIOTypeArray = iBuildResource.getDependentIOTypes();
        IBuildIOType[] iBuildIOTypeArray2 = iBuildResource2.getDependentIOTypes();
        if (iBuildIOTypeArray.length != iBuildIOTypeArray2.length) {
            this.doFail("resources do not match: different number of output types", iBuildResource, iBuildResource2);
        }
        int n = 0;
        while (n < iBuildIOTypeArray.length) {
            IBuildIOType iBuildIOType3;
            IBuildIOType iBuildIOType4 = this.getCorType(iBuildIOTypeArray[n], iBuildIOTypeArray2);
            if (iBuildIOType4 == null) {
                this.doFail("resources not match: no cor dep type found", iBuildResource, iBuildResource2);
            }
            if ((iBuildIOType3 = map.put(iBuildIOTypeArray[n], iBuildIOType4)) != null) {
                this.doFail("there was corresponding type", iBuildResource, iBuildResource2);
            }
            ++n;
        }
        this.doTrace("end matching resource");
    }

    private boolean stepsMatch(IBuildStep iBuildStep, IBuildStep iBuildStep2, Map map, Map map2, boolean bl) {
        return this.stepsMatch(iBuildStep, iBuildStep2, map, map2, true, bl);
    }

    private boolean stepsMatch(IBuildStep iBuildStep, IBuildStep iBuildStep2, Map map, Map map2, boolean bl, boolean bl2) {
        IBuildIOType iBuildIOType;
        IBuildIOType[] iBuildIOTypeArray = iBuildStep.getInputIOTypes();
        IBuildIOType[] iBuildIOTypeArray2 = iBuildStep2.getInputIOTypes();
        this.doTrace("matching step " + DbgUtil.stepName((IBuildStep)iBuildStep));
        if (iBuildIOTypeArray.length != iBuildIOTypeArray2.length) {
            if (bl2) {
                this.doFail("steps do not match: different number of input types", iBuildStep, iBuildStep2);
            }
            return false;
        }
        int n = 0;
        while (n < iBuildIOTypeArray.length) {
            iBuildIOType = this.getCorType(iBuildIOTypeArray[n], iBuildIOTypeArray2, null, bl);
            if (iBuildIOType == null) {
                if (bl2) {
                    this.doFail("steps not match, no corresponding input type found", iBuildStep, iBuildStep2);
                }
                return false;
            }
            IBuildIOType iBuildIOType2 = map.put(iBuildIOTypeArray[n], iBuildIOType);
            if (iBuildIOType2 != null) {
                if (bl2) {
                    this.doFail("there was already corresponding input type", iBuildStep, iBuildStep2);
                }
                return false;
            }
            ++n;
        }
        IBuildIOType[] iBuildIOTypeArray3 = iBuildStep.getOutputIOTypes();
        if (iBuildIOTypeArray3.length != ((IBuildIOType)(iBuildIOType = iBuildStep2.getOutputIOTypes())).length) {
            if (bl2) {
                this.doFail("steps do not match: different number of output types", iBuildStep, iBuildStep2);
            }
            return false;
        }
        int n2 = 0;
        while (n2 < iBuildIOTypeArray3.length) {
            IBuildIOType iBuildIOType3 = this.getCorType(iBuildIOTypeArray3[n2], (IBuildIOType[])iBuildIOType, null, bl);
            if (iBuildIOType3 == null) {
                if (bl2) {
                    this.doFail("steps not match, no corresponding output type found", iBuildStep, iBuildStep2);
                }
                return false;
            }
            IBuildIOType iBuildIOType4 = map2.put(iBuildIOTypeArray3[n2], iBuildIOType3);
            if (iBuildIOType4 != null) {
                if (bl2) {
                    this.doFail("there was already corresponding output type", iBuildStep, iBuildStep2);
                }
                return false;
            }
            ++n2;
        }
        this.doTrace("end matching step");
        return true;
    }

    private IBuildIOType getCorType(IBuildIOType iBuildIOType, IBuildIOType[] iBuildIOTypeArray) {
        return this.getCorType(iBuildIOType, iBuildIOTypeArray, null, true);
    }

    private IBuildIOType getCorType(IBuildIOType iBuildIOType, IBuildIOType[] iBuildIOTypeArray, Map map, boolean bl) {
        int n = 0;
        while (n < iBuildIOTypeArray.length) {
            if (this.typesMatch(iBuildIOType, iBuildIOTypeArray[n], map, bl, false)) {
                return iBuildIOTypeArray[n];
            }
            if (map != null) {
                map.clear();
            }
            ++n;
        }
        return null;
    }

    private boolean typesMatch(IBuildIOType iBuildIOType, IBuildIOType iBuildIOType2, Map map, boolean bl) {
        return this.typesMatch(iBuildIOType, iBuildIOType2, map, true, bl);
    }

    private boolean typesMatch(IBuildIOType iBuildIOType, IBuildIOType iBuildIOType2, Map map, boolean bl, boolean bl2) {
        IBuildResource[] iBuildResourceArray;
        if (iBuildIOType.isInput() != iBuildIOType2.isInput()) {
            if (bl2) {
                this.doFail("types have different I/O property", iBuildIOType, iBuildIOType2);
            }
            return false;
        }
        IBuildResource[] iBuildResourceArray2 = iBuildIOType.getResources();
        if (iBuildResourceArray2.length != (iBuildResourceArray = iBuildIOType2.getResources()).length) {
            return false;
        }
        if (this.resourcesMatch(iBuildResourceArray2, iBuildResourceArray, map)) {
            HashMap hashMap = new HashMap();
            HashMap hashMap2 = new HashMap();
            if (!bl) {
                return true;
            }
            return this.stepsMatch(iBuildIOType.getStep(), iBuildIOType2.getStep(), hashMap, hashMap2, false, bl2);
        }
        if (bl2) {
            this.doFail("resources not match", iBuildIOType, iBuildIOType2);
        }
        return false;
    }

    private boolean resourcesMatch(IBuildResource[] iBuildResourceArray, IBuildResource[] iBuildResourceArray2, Map map) {
        if (iBuildResourceArray.length != iBuildResourceArray2.length) {
            return false;
        }
        int n = 0;
        while (n < iBuildResourceArray.length) {
            IPath iPath = iBuildResourceArray[n].getLocation();
            int n2 = 0;
            while (n2 < iBuildResourceArray2.length) {
                if (iBuildResourceArray2[n2].getLocation().equals((Object)iPath)) {
                    if (map == null) break;
                    map.put(iBuildResourceArray[n], iBuildResourceArray2[n2]);
                    break;
                }
                ++n2;
            }
            if (n2 == iBuildResourceArray2.length) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private void doFail(String string, IBuildIOType iBuildIOType, IBuildIOType iBuildIOType2) {
        this.doFail(String.valueOf(string) + "\nType:\n" + DbgUtil.dumpType((IBuildIOType)iBuildIOType) + "\noType:\n" + DbgUtil.dumpType((IBuildIOType)iBuildIOType2));
    }

    private void doFail(String string, IBuildResource iBuildResource, IBuildResource iBuildResource2) {
        this.doFail(String.valueOf(string) + "\nRc:\n" + DbgUtil.dumpResource((IBuildResource)iBuildResource) + "\noRc:\n" + DbgUtil.dumpResource((IBuildResource)iBuildResource2));
    }

    private void doFail(String string, IBuildStep iBuildStep, IBuildStep iBuildStep2) {
        this.doFail(String.valueOf(string) + "\nStep:\n" + DbgUtil.dumpStep((IBuildStep)iBuildStep) + "\noStep:\n" + DbgUtil.dumpStep((IBuildStep)iBuildStep2));
    }

    private void doFail(String string) {
        this.doTrace(string);
        BuildDescriptionModelTests.fail((String)string);
    }

    private void doTrace(String string) {
        if (DbgUtil.DEBUG) {
            DbgUtil.trace((String)string);
        }
    }

    private void doTestBuildDescription(IBuildDescription iBuildDescription, IBuildDescription iBuildDescription2) {
        BuildDescriptionModelTests.assertEquals((Object)iBuildDescription.getConfiguration(), (Object)iBuildDescription2.getConfiguration());
        BuildDescriptionModelTests.assertNotNull((Object)iBuildDescription.getConfiguration());
        iBuildDescription.getConfiguration().getOwner().getProject();
        IBuildStep iBuildStep = iBuildDescription.getInputStep();
        IBuildStep iBuildStep2 = iBuildDescription.getOutputStep();
        if (iBuildStep.getInputIOTypes().length != 0) {
            this.doFail("input step contains inputs, " + DbgUtil.dumpStep((IBuildStep)iBuildStep));
        }
        if (iBuildStep2.getOutputIOTypes().length != 0) {
            this.doFail("output step contains outputs, " + DbgUtil.dumpStep((IBuildStep)iBuildStep2));
        }
        IBuildStep iBuildStep3 = iBuildDescription2.getInputStep();
        IBuildStep iBuildStep4 = iBuildDescription2.getOutputStep();
        this.doTrace("*****testing down to up..");
        this.doTestStep(iBuildStep, iBuildStep3, true);
        this.doTrace("*****down to up passed");
        this.doTrace("*****testing up to down..");
        this.doTestStep(iBuildStep2, iBuildStep4, false);
        this.doTrace("*****up to down passed");
    }

    protected void tearDown() throws Exception {
        this.fCleaner.run();
        if (DbgUtil.DEBUG) {
            DbgUtil.flush();
        }
    }

    private IProject createProject(String string, String string2) {
        IProject iProject = ManagedBuildTestHelper.createProject(string, string2);
        if (iProject != null) {
            this.fCompositeCleaner.addRunnable(new ProjectCleaner(iProject));
        }
        return iProject;
    }

    private IProject loadProject(String string) {
        IProject iProject = ManagedBuildTestHelper.loadProject(string, PROJ_PATH);
        if (iProject != null) {
            this.fCompositeCleaner.addRunnable(new ProjectCleaner(iProject));
        }
        return iProject;
    }

    public void testDes_gnu30_exe() {
        IProject iProject = this.createProject("BuildDescription_1", "cdt.managedbuild.target.gnu30.exe");
        try {
            CCProjectNature.addCCNature((IProject)iProject, null);
        }
        catch (CoreException coreException) {
            BuildDescriptionModelTests.fail((String)"fail to add CC nature");
        }
        ManagedBuildTestHelper.createFile(iProject, "a.c");
        ManagedBuildTestHelper.createFile(iProject, "b.c");
        ManagedBuildTestHelper.createFile(iProject, "c.cpp");
        ManagedBuildTestHelper.createFile(iProject, "d.cpp");
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
        IManagedProject iManagedProject = iManagedBuildInfo.getManagedProject();
        IConfiguration iConfiguration = iManagedProject.getConfigurations()[0];
        String string = iConfiguration.getArtifactName();
        String string2 = iConfiguration.getArtifactExtension();
        if (string2 != null && string2.length() > 0) {
            string = String.valueOf(string) + "." + string2;
        }
        String string3 = iConfiguration.getName();
        BuildDescription buildDescription = new BuildDescription(iConfiguration);
        BuildStep buildStep = (BuildStep)buildDescription.getInputStep();
        BuildIOType buildIOType = buildStep.createIOType(false, false, null);
        buildIOType.addResource(buildDescription.createResource("c.cpp"));
        buildIOType.addResource(buildDescription.createResource("d.cpp"));
        buildIOType = buildStep.createIOType(false, false, null);
        buildIOType.addResource(buildDescription.createResource("a.c"));
        buildIOType.addResource(buildDescription.createResource("b.c"));
        buildStep = buildDescription.createStep(null, null);
        buildIOType = buildStep.createIOType(true, false, null);
        buildIOType.addResource(buildDescription.createResource("a.c"));
        buildIOType = buildStep.createIOType(false, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/a.o"));
        buildStep = buildDescription.createStep(null, null);
        buildIOType = buildStep.createIOType(true, false, null);
        buildIOType.addResource(buildDescription.createResource("b.c"));
        buildIOType = buildStep.createIOType(false, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/b.o"));
        buildStep = buildDescription.createStep(null, null);
        buildIOType = buildStep.createIOType(true, false, null);
        buildIOType.addResource(buildDescription.createResource("c.cpp"));
        buildIOType = buildStep.createIOType(false, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/c.o"));
        buildStep = buildDescription.createStep(null, null);
        buildIOType = buildStep.createIOType(true, false, null);
        buildIOType.addResource(buildDescription.createResource("d.cpp"));
        buildIOType = buildStep.createIOType(false, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/d.o"));
        buildStep = buildDescription.createStep(null, null);
        buildIOType = buildStep.createIOType(true, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/a.o"));
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/b.o"));
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/c.o"));
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/d.o"));
        buildIOType = buildStep.createIOType(false, false, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/" + string));
        buildStep = (BuildStep)buildDescription.getOutputStep();
        buildIOType = buildStep.createIOType(true, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/" + string));
        IBuildDescription iBuildDescription = null;
        try {
            iBuildDescription = BuildDescriptionManager.createBuildDescription((IConfiguration)iConfiguration, null, (int)3);
        }
        catch (CoreException coreException) {
            BuildDescriptionModelTests.fail((String)("build description creation failed: " + coreException.getLocalizedMessage()));
        }
        this.doTestBuildDescription(iBuildDescription, (IBuildDescription)buildDescription);
    }

    public void testDesTestgnu21_exe() {
        IProject iProject = this.createProject("BuildDescription_1", "cdt.managedbuild.target.testgnu21.exe");
        try {
            CCProjectNature.addCCNature((IProject)iProject, null);
        }
        catch (CoreException coreException) {
            BuildDescriptionModelTests.fail((String)"fail to add CC nature");
        }
        ManagedBuildTestHelper.createFile(iProject, "a.c");
        ManagedBuildTestHelper.createFile(iProject, "b.c");
        ManagedBuildTestHelper.createFile(iProject, "c.cpp");
        ManagedBuildTestHelper.createFile(iProject, "d.cpp");
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
        IManagedProject iManagedProject = iManagedBuildInfo.getManagedProject();
        IConfiguration iConfiguration = iManagedProject.getConfigurations()[0];
        String string = iConfiguration.getArtifactName();
        String string2 = iConfiguration.getArtifactExtension();
        if (string2 != null && string2.length() > 0) {
            string = String.valueOf(string) + "." + string2;
        }
        String string3 = iConfiguration.getName();
        BuildDescription buildDescription = new BuildDescription(iConfiguration);
        BuildStep buildStep = (BuildStep)buildDescription.getInputStep();
        BuildIOType buildIOType = buildStep.createIOType(false, false, null);
        buildIOType.addResource(buildDescription.createResource("c.cpp"));
        buildIOType.addResource(buildDescription.createResource("d.cpp"));
        buildIOType = buildStep.createIOType(false, false, null);
        buildIOType.addResource(buildDescription.createResource("a.c"));
        buildIOType.addResource(buildDescription.createResource("b.c"));
        buildStep = buildDescription.createStep(null, null);
        buildIOType = buildStep.createIOType(true, false, null);
        buildIOType.addResource(buildDescription.createResource("a.c"));
        buildIOType = buildStep.createIOType(false, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/a.o"));
        buildStep = buildDescription.createStep(null, null);
        buildIOType = buildStep.createIOType(true, false, null);
        buildIOType.addResource(buildDescription.createResource("b.c"));
        buildIOType = buildStep.createIOType(false, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/b.o"));
        buildStep = buildDescription.createStep(null, null);
        buildIOType = buildStep.createIOType(true, false, null);
        buildIOType.addResource(buildDescription.createResource("c.cpp"));
        buildIOType = buildStep.createIOType(false, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/c.o"));
        buildStep = buildDescription.createStep(null, null);
        buildIOType = buildStep.createIOType(true, false, null);
        buildIOType.addResource(buildDescription.createResource("d.cpp"));
        buildIOType = buildStep.createIOType(false, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/d.o"));
        buildStep = buildDescription.createStep(null, null);
        buildIOType = buildStep.createIOType(true, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/a.o"));
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/b.o"));
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/c.o"));
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/d.o"));
        buildIOType = buildStep.createIOType(false, false, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/" + string));
        buildStep = (BuildStep)buildDescription.getOutputStep();
        buildIOType = buildStep.createIOType(true, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/" + string));
        IBuildDescription iBuildDescription = null;
        try {
            iBuildDescription = BuildDescriptionManager.createBuildDescription((IConfiguration)iConfiguration, null, (int)3);
        }
        catch (CoreException coreException) {
            BuildDescriptionModelTests.fail((String)("build description creation failed: " + coreException.getLocalizedMessage()));
        }
        this.doTestBuildDescription(iBuildDescription, (IBuildDescription)buildDescription);
    }

    public void testDesRcCfg() {
        IProject iProject = this.createProject("BuildDescription_1", "cdt.managedbuild.target.gnu30.exe");
        try {
            CCProjectNature.addCCNature((IProject)iProject, null);
        }
        catch (CoreException coreException) {
            BuildDescriptionModelTests.fail((String)"fail to add CC nature");
        }
        IFile iFile = ManagedBuildTestHelper.createFile(iProject, "a.c");
        ManagedBuildTestHelper.createFile(iProject, "b.c");
        IFile iFile2 = ManagedBuildTestHelper.createFile(iProject, "c.cpp");
        ManagedBuildTestHelper.createFile(iProject, "d.cpp");
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
        IManagedProject iManagedProject = iManagedBuildInfo.getManagedProject();
        IConfiguration iConfiguration = iManagedProject.getConfigurations()[0];
        String string = iConfiguration.getArtifactName();
        String string2 = iConfiguration.getArtifactExtension();
        if (string2 != null && string2.length() > 0) {
            string = String.valueOf(string) + "." + string2;
        }
        String string3 = iConfiguration.getName();
        IResourceConfiguration iResourceConfiguration = iConfiguration.createResourceConfiguration(iFile);
        BuildDescriptionModelTests.assertNotNull((Object)iResourceConfiguration);
        iResourceConfiguration = iConfiguration.createResourceConfiguration(iFile2);
        BuildDescriptionModelTests.assertNotNull((Object)iResourceConfiguration);
        BuildDescription buildDescription = new BuildDescription(iConfiguration);
        BuildStep buildStep = (BuildStep)buildDescription.getInputStep();
        BuildIOType buildIOType = buildStep.createIOType(false, false, null);
        buildIOType.addResource(buildDescription.createResource("c.cpp"));
        buildIOType.addResource(buildDescription.createResource("d.cpp"));
        buildIOType = buildStep.createIOType(false, false, null);
        buildIOType.addResource(buildDescription.createResource("a.c"));
        buildIOType.addResource(buildDescription.createResource("b.c"));
        buildStep = buildDescription.createStep(null, null);
        buildIOType = buildStep.createIOType(true, false, null);
        buildIOType.addResource(buildDescription.createResource("a.c"));
        buildIOType = buildStep.createIOType(false, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/a.o"));
        buildStep = buildDescription.createStep(null, null);
        buildIOType = buildStep.createIOType(true, false, null);
        buildIOType.addResource(buildDescription.createResource("b.c"));
        buildIOType = buildStep.createIOType(false, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/b.o"));
        buildStep = buildDescription.createStep(null, null);
        buildIOType = buildStep.createIOType(true, false, null);
        buildIOType.addResource(buildDescription.createResource("c.cpp"));
        buildIOType = buildStep.createIOType(false, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/c.o"));
        buildStep = buildDescription.createStep(null, null);
        buildIOType = buildStep.createIOType(true, false, null);
        buildIOType.addResource(buildDescription.createResource("d.cpp"));
        buildIOType = buildStep.createIOType(false, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/d.o"));
        buildStep = buildDescription.createStep(null, null);
        buildIOType = buildStep.createIOType(true, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/a.o"));
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/b.o"));
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/c.o"));
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/d.o"));
        buildIOType = buildStep.createIOType(false, false, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/" + string));
        buildStep = (BuildStep)buildDescription.getOutputStep();
        buildIOType = buildStep.createIOType(true, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/" + string));
        IBuildDescription iBuildDescription = null;
        try {
            iBuildDescription = BuildDescriptionManager.createBuildDescription((IConfiguration)iConfiguration, null, (int)3);
        }
        catch (CoreException coreException) {
            BuildDescriptionModelTests.fail((String)("build description creation failed: " + coreException.getLocalizedMessage()));
        }
        this.doTestBuildDescription(iBuildDescription, (IBuildDescription)buildDescription);
    }

    public void testDesRcbs() {
        IProject iProject = this.createProject("BuildDescription_1", "cdt.managedbuild.target.gnu30.exe");
        try {
            CCProjectNature.addCCNature((IProject)iProject, null);
        }
        catch (CoreException coreException) {
            BuildDescriptionModelTests.fail((String)"fail to add CC nature");
        }
        ManagedBuildTestHelper.createFile(iProject, "a.c");
        ManagedBuildTestHelper.createFile(iProject, "b.c");
        IFile iFile = ManagedBuildTestHelper.createFile(iProject, "c.cpp");
        ManagedBuildTestHelper.createFile(iProject, "d.cpp");
        IFile iFile2 = ManagedBuildTestHelper.createFile(iProject, "e.r");
        ManagedBuildTestHelper.createFile(iProject, "f.r");
        ManagedBuildTestHelper.createFile(iProject, "dir1/g.r");
        ManagedBuildTestHelper.createFile(iProject, "dir2/h.r");
        ManagedBuildTestHelper.createFile(iProject, "dir2/i.r");
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
        IManagedProject iManagedProject = iManagedBuildInfo.getManagedProject();
        IConfiguration iConfiguration = iManagedProject.getConfigurations()[0];
        String string = iConfiguration.getArtifactName();
        String string2 = iConfiguration.getArtifactExtension();
        if (string2 != null && string2.length() > 0) {
            string = String.valueOf(string) + "." + string2;
        }
        String string3 = iConfiguration.getName();
        String string4 = String.valueOf(string3) + "/";
        ManagedBuildTestHelper.createRcbsTool(iConfiguration, iFile, "f.r;dir1/g.r;dir2/h.r", "q.o;w.o;e.o", "a;b;c");
        ManagedBuildTestHelper.createRcbsTool(iConfiguration, iFile2, "f.r;dir1/g.r;dir2/h.r;dir2/i.r", "z.cpp;x.c", "d;e;f");
        BuildDescription buildDescription = new BuildDescription(iConfiguration);
        BuildStep buildStep = (BuildStep)buildDescription.getInputStep();
        BuildIOType buildIOType = buildStep.createIOType(false, false, null);
        buildIOType.addResource(buildDescription.createResource("c.cpp"));
        buildIOType.addResource(buildDescription.createResource("d.cpp"));
        buildIOType = buildStep.createIOType(false, false, null);
        buildIOType.addResource(buildDescription.createResource("a.c"));
        buildIOType.addResource(buildDescription.createResource("b.c"));
        buildIOType = buildStep.createIOType(false, false, null);
        buildIOType.addResource(buildDescription.createResource("e.r"));
        buildIOType.addResource(buildDescription.createResource("f.r"));
        buildIOType.addResource(buildDescription.createResource("dir1/g.r"));
        buildIOType.addResource(buildDescription.createResource("dir2/h.r"));
        buildIOType.addResource(buildDescription.createResource("dir2/i.r"));
        buildStep = buildDescription.createStep(null, null);
        buildIOType = buildStep.createIOType(true, false, null);
        buildIOType.addResource(buildDescription.createResource("a.c"));
        buildIOType = buildStep.createIOType(false, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/a.o"));
        buildStep = buildDescription.createStep(null, null);
        buildIOType = buildStep.createIOType(true, false, null);
        buildIOType.addResource(buildDescription.createResource("b.c"));
        buildIOType = buildStep.createIOType(false, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/b.o"));
        buildStep = buildDescription.createStep(null, null);
        buildIOType = buildStep.createIOType(true, false, null);
        buildIOType.addResource(buildDescription.createResource("c.cpp"));
        buildIOType = buildStep.createIOType(true, false, null);
        buildIOType.addResource(buildDescription.createResource("f.r"));
        buildIOType.addResource(buildDescription.createResource("dir1/g.r"));
        buildIOType.addResource(buildDescription.createResource("dir2/h.r"));
        buildIOType = buildStep.createIOType(false, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/q.o"));
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/w.o"));
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/e.o"));
        buildStep = buildDescription.createStep(null, null);
        buildIOType = buildStep.createIOType(true, false, null);
        buildIOType.addResource(buildDescription.createResource("d.cpp"));
        buildIOType = buildStep.createIOType(false, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/d.o"));
        buildStep = buildDescription.createStep(null, null);
        buildIOType = buildStep.createIOType(true, false, null);
        buildIOType.addResource(buildDescription.createResource("e.r"));
        buildIOType = buildStep.createIOType(true, false, null);
        buildIOType.addResource(buildDescription.createResource("f.r"));
        buildIOType.addResource(buildDescription.createResource("dir1/g.r"));
        buildIOType.addResource(buildDescription.createResource("dir2/h.r"));
        buildIOType.addResource(buildDescription.createResource("dir2/i.r"));
        buildIOType = buildStep.createIOType(false, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string4) + "z.cpp"));
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string4) + "x.c"));
        buildStep = buildDescription.createStep(null, null);
        buildIOType = buildStep.createIOType(true, false, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string4) + "z.cpp"));
        buildIOType = buildStep.createIOType(false, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/z.o"));
        buildStep = buildDescription.createStep(null, null);
        buildIOType = buildStep.createIOType(true, false, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string4) + "x.c"));
        buildIOType = buildStep.createIOType(false, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/x.o"));
        buildStep = buildDescription.createStep(null, null);
        buildIOType = buildStep.createIOType(true, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/a.o"));
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/b.o"));
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/d.o"));
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/q.o"));
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/w.o"));
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/e.o"));
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/z.o"));
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/x.o"));
        buildIOType = buildStep.createIOType(false, false, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/" + string));
        buildStep = (BuildStep)buildDescription.getOutputStep();
        buildIOType = buildStep.createIOType(true, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/" + string));
        IBuildDescription iBuildDescription = null;
        try {
            iBuildDescription = BuildDescriptionManager.createBuildDescription((IConfiguration)iConfiguration, null, (int)3);
        }
        catch (CoreException coreException) {
            BuildDescriptionModelTests.fail((String)("build description creation failed: " + coreException.getLocalizedMessage()));
        }
        this.doTestBuildDescription(iBuildDescription, (IBuildDescription)buildDescription);
    }

    public void testDesAddlInVarUserObjs() {
        IProject iProject = this.createProject("BuildDescription_1", "cdt.managedbuild.target.gnu30.exe");
        try {
            CCProjectNature.addCCNature((IProject)iProject, null);
        }
        catch (CoreException coreException) {
            BuildDescriptionModelTests.fail((String)"fail to add CC nature");
        }
        ManagedBuildTestHelper.createFile(iProject, "a.c");
        ManagedBuildTestHelper.createFile(iProject, "b.c");
        IFile iFile = ManagedBuildTestHelper.createFile(iProject, "c.cpp");
        ManagedBuildTestHelper.createFile(iProject, "d.cpp");
        IFile iFile2 = ManagedBuildTestHelper.createFile(iProject, "e.r");
        ManagedBuildTestHelper.createFile(iProject, "f.r");
        ManagedBuildTestHelper.createFile(iProject, "dir1/g.r");
        ManagedBuildTestHelper.createFile(iProject, "dir2/h.r");
        ManagedBuildTestHelper.createFile(iProject, "dir2/i.r");
        ManagedBuildTestHelper.createFile(iProject, "o1.o");
        ManagedBuildTestHelper.createFile(iProject, "dir3/o2.o");
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
        IManagedProject iManagedProject = iManagedBuildInfo.getManagedProject();
        IConfiguration iConfiguration = iManagedProject.getConfigurations()[0];
        String string = iConfiguration.getArtifactName();
        String string2 = iConfiguration.getArtifactExtension();
        if (string2 != null && string2.length() > 0) {
            string = String.valueOf(string) + "." + string2;
        }
        String string3 = iConfiguration.getName();
        String string4 = String.valueOf(string3) + "/";
        ManagedBuildTestHelper.setObjs(iConfiguration, new String[]{"o1.o", "dir3/o2.o", "dir4/d/o3.o"});
        ManagedBuildTestHelper.createRcbsTool(iConfiguration, iFile, "f.r;dir1/g.r;dir2/h.r", "q.o;w.o;e.o", "a;b;c");
        ManagedBuildTestHelper.createRcbsTool(iConfiguration, iFile2, "f.r;dir1/g.r;dir2/h.r;dir2/i.r", "z.cpp;x.c", "d;e;f");
        BuildDescription buildDescription = new BuildDescription(iConfiguration);
        BuildStep buildStep = (BuildStep)buildDescription.getInputStep();
        BuildIOType buildIOType = buildStep.createIOType(false, false, null);
        buildIOType.addResource(buildDescription.createResource("c.cpp"));
        buildIOType.addResource(buildDescription.createResource("d.cpp"));
        buildIOType = buildStep.createIOType(false, false, null);
        buildIOType.addResource(buildDescription.createResource("a.c"));
        buildIOType.addResource(buildDescription.createResource("b.c"));
        buildIOType = buildStep.createIOType(false, false, null);
        buildIOType.addResource(buildDescription.createResource("e.r"));
        buildIOType.addResource(buildDescription.createResource("f.r"));
        buildIOType.addResource(buildDescription.createResource("dir1/g.r"));
        buildIOType.addResource(buildDescription.createResource("dir2/h.r"));
        buildIOType.addResource(buildDescription.createResource("dir2/i.r"));
        buildIOType = buildStep.createIOType(false, false, null);
        buildIOType.addResource(buildDescription.createResource("o1.o"));
        buildIOType.addResource(buildDescription.createResource("dir3/o2.o"));
        buildIOType.addResource(buildDescription.createResource("dir4/d/o3.o"));
        buildStep = buildDescription.createStep(null, null);
        buildIOType = buildStep.createIOType(true, false, null);
        buildIOType.addResource(buildDescription.createResource("a.c"));
        buildIOType = buildStep.createIOType(false, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/a.o"));
        buildStep = buildDescription.createStep(null, null);
        buildIOType = buildStep.createIOType(true, false, null);
        buildIOType.addResource(buildDescription.createResource("b.c"));
        buildIOType = buildStep.createIOType(false, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/b.o"));
        buildStep = buildDescription.createStep(null, null);
        buildIOType = buildStep.createIOType(true, false, null);
        buildIOType.addResource(buildDescription.createResource("c.cpp"));
        buildIOType = buildStep.createIOType(true, false, null);
        buildIOType.addResource(buildDescription.createResource("f.r"));
        buildIOType.addResource(buildDescription.createResource("dir1/g.r"));
        buildIOType.addResource(buildDescription.createResource("dir2/h.r"));
        buildIOType = buildStep.createIOType(false, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/q.o"));
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/w.o"));
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/e.o"));
        buildStep = buildDescription.createStep(null, null);
        buildIOType = buildStep.createIOType(true, false, null);
        buildIOType.addResource(buildDescription.createResource("d.cpp"));
        buildIOType = buildStep.createIOType(false, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/d.o"));
        buildStep = buildDescription.createStep(null, null);
        buildIOType = buildStep.createIOType(true, false, null);
        buildIOType.addResource(buildDescription.createResource("e.r"));
        buildIOType = buildStep.createIOType(true, false, null);
        buildIOType.addResource(buildDescription.createResource("f.r"));
        buildIOType.addResource(buildDescription.createResource("dir1/g.r"));
        buildIOType.addResource(buildDescription.createResource("dir2/h.r"));
        buildIOType.addResource(buildDescription.createResource("dir2/i.r"));
        buildIOType = buildStep.createIOType(false, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string4) + "z.cpp"));
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string4) + "x.c"));
        buildStep = buildDescription.createStep(null, null);
        buildIOType = buildStep.createIOType(true, false, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string4) + "z.cpp"));
        buildIOType = buildStep.createIOType(false, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/z.o"));
        buildStep = buildDescription.createStep(null, null);
        buildIOType = buildStep.createIOType(true, false, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string4) + "x.c"));
        buildIOType = buildStep.createIOType(false, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/x.o"));
        buildStep = buildDescription.createStep(null, null);
        buildIOType = buildStep.createIOType(true, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/a.o"));
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/b.o"));
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/d.o"));
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/q.o"));
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/w.o"));
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/e.o"));
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/z.o"));
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/x.o"));
        buildIOType.addResource(buildDescription.createResource("o1.o"));
        buildIOType.addResource(buildDescription.createResource("dir3/o2.o"));
        buildIOType.addResource(buildDescription.createResource("dir4/d/o3.o"));
        buildIOType = buildStep.createIOType(false, false, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/" + string));
        buildStep = (BuildStep)buildDescription.getOutputStep();
        buildIOType = buildStep.createIOType(true, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/" + string));
        IBuildDescription iBuildDescription = null;
        try {
            iBuildDescription = BuildDescriptionManager.createBuildDescription((IConfiguration)iConfiguration, null, (int)3);
        }
        catch (CoreException coreException) {
            BuildDescriptionModelTests.fail((String)("build description creation failed: " + coreException.getLocalizedMessage()));
        }
        this.doTestBuildDescription(iBuildDescription, (IBuildDescription)buildDescription);
    }

    public void testDesAddlInVar() {
        IProject iProject = this.createProject("BuildDescription_1", "cdt.managedbuild.target.bdm.exe");
        try {
            CCProjectNature.addCCNature((IProject)iProject, null);
        }
        catch (CoreException coreException) {
            BuildDescriptionModelTests.fail((String)"fail to add CC nature");
        }
        ManagedBuildTestHelper.createFile(iProject, "a.c");
        ManagedBuildTestHelper.createFile(iProject, "b.c");
        ManagedBuildTestHelper.createFile(iProject, "c.cpp");
        ManagedBuildTestHelper.createFile(iProject, "d.cpp");
        ManagedBuildTestHelper.createFile(iProject, "e.s1");
        ManagedBuildTestHelper.createFile(iProject, "dir/f.s1");
        ManagedBuildTestHelper.createFile(iProject, "g.s2");
        ManagedBuildTestHelper.createFile(iProject, "dir/h.s2");
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
        IManagedProject iManagedProject = iManagedBuildInfo.getManagedProject();
        IConfiguration iConfiguration = iManagedProject.getConfigurations()[0];
        String string = iConfiguration.getArtifactName();
        String string2 = iConfiguration.getArtifactExtension();
        if (string2 != null && string2.length() > 0) {
            string = String.valueOf(string) + "." + string2;
        }
        String string3 = iConfiguration.getName();
        String string4 = String.valueOf(string3) + "/";
        BuildDescription buildDescription = new BuildDescription(iConfiguration);
        BuildStep buildStep = (BuildStep)buildDescription.getInputStep();
        BuildIOType buildIOType = buildStep.createIOType(false, false, null);
        buildIOType.addResource(buildDescription.createResource("c.cpp"));
        buildIOType.addResource(buildDescription.createResource("d.cpp"));
        buildIOType = buildStep.createIOType(false, false, null);
        buildIOType.addResource(buildDescription.createResource("a.c"));
        buildIOType.addResource(buildDescription.createResource("b.c"));
        buildIOType = buildStep.createIOType(false, false, null);
        buildIOType.addResource(buildDescription.createResource("e.s1"));
        buildIOType.addResource(buildDescription.createResource("dir/f.s1"));
        buildIOType = buildStep.createIOType(false, false, null);
        buildIOType.addResource(buildDescription.createResource("g.s2"));
        buildIOType.addResource(buildDescription.createResource("dir/h.s2"));
        buildStep = buildDescription.createStep(null, null);
        buildIOType = buildStep.createIOType(true, false, null);
        buildIOType.addResource(buildDescription.createResource("e.s1"));
        buildIOType = buildStep.createIOType(false, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string4) + "e.o1"));
        buildStep = buildDescription.createStep(null, null);
        buildIOType = buildStep.createIOType(true, false, null);
        buildIOType.addResource(buildDescription.createResource("dir/f.s1"));
        buildIOType = buildStep.createIOType(false, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string4) + "dir/f.o1"));
        buildStep = buildDescription.createStep(null, null);
        buildIOType = buildStep.createIOType(true, false, null);
        buildIOType.addResource(buildDescription.createResource("g.s2"));
        buildIOType = buildStep.createIOType(true, false, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string4) + "e.o1"));
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string4) + "dir/f.o1"));
        buildIOType = buildStep.createIOType(false, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string4) + "g.o"));
        buildStep = buildDescription.createStep(null, null);
        buildIOType = buildStep.createIOType(true, false, null);
        buildIOType.addResource(buildDescription.createResource("dir/h.s2"));
        buildIOType = buildStep.createIOType(true, false, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string4) + "e.o1"));
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string4) + "dir/f.o1"));
        buildIOType = buildStep.createIOType(false, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string4) + "dir/h.o"));
        buildStep = buildDescription.createStep(null, null);
        buildIOType = buildStep.createIOType(true, false, null);
        buildIOType.addResource(buildDescription.createResource("a.c"));
        buildIOType = buildStep.createIOType(false, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/a.o"));
        buildStep = buildDescription.createStep(null, null);
        buildIOType = buildStep.createIOType(true, false, null);
        buildIOType.addResource(buildDescription.createResource("b.c"));
        buildIOType = buildStep.createIOType(false, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/b.o"));
        buildStep = buildDescription.createStep(null, null);
        buildIOType = buildStep.createIOType(true, false, null);
        buildIOType.addResource(buildDescription.createResource("c.cpp"));
        buildIOType = buildStep.createIOType(false, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/c.o"));
        buildStep = buildDescription.createStep(null, null);
        buildIOType = buildStep.createIOType(true, false, null);
        buildIOType.addResource(buildDescription.createResource("d.cpp"));
        buildIOType = buildStep.createIOType(false, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/d.o"));
        buildStep = buildDescription.createStep(null, null);
        buildIOType = buildStep.createIOType(true, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/a.o"));
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/b.o"));
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/c.o"));
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/d.o"));
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string4) + "g.o"));
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string4) + "dir/h.o"));
        buildIOType = buildStep.createIOType(false, false, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/" + string));
        buildStep = (BuildStep)buildDescription.getOutputStep();
        buildIOType = buildStep.createIOType(true, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/" + string));
        IBuildDescription iBuildDescription = null;
        try {
            iBuildDescription = BuildDescriptionManager.createBuildDescription((IConfiguration)iConfiguration, null, (int)3);
        }
        catch (CoreException coreException) {
            BuildDescriptionModelTests.fail((String)("build description creation failed: " + coreException.getLocalizedMessage()));
        }
        this.doTestBuildDescription(iBuildDescription, (IBuildDescription)buildDescription);
    }

    public void testDes_gnu30_exe_objsInProj() {
        IProject iProject = this.createProject("BuildDescription_1", "cdt.managedbuild.target.gnu30.exe");
        try {
            CCProjectNature.addCCNature((IProject)iProject, null);
        }
        catch (CoreException coreException) {
            BuildDescriptionModelTests.fail((String)"fail to add CC nature");
        }
        ManagedBuildTestHelper.createFile(iProject, "a.c");
        ManagedBuildTestHelper.createFile(iProject, "b.c");
        ManagedBuildTestHelper.createFile(iProject, "c.cpp");
        ManagedBuildTestHelper.createFile(iProject, "d.cpp");
        ManagedBuildTestHelper.createFile(iProject, "e.o");
        ManagedBuildTestHelper.createFile(iProject, "dir/f.o");
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
        IManagedProject iManagedProject = iManagedBuildInfo.getManagedProject();
        IConfiguration iConfiguration = iManagedProject.getConfigurations()[0];
        String string = iConfiguration.getArtifactName();
        String string2 = iConfiguration.getArtifactExtension();
        if (string2 != null && string2.length() > 0) {
            string = String.valueOf(string) + "." + string2;
        }
        String string3 = iConfiguration.getName();
        BuildDescription buildDescription = new BuildDescription(iConfiguration);
        BuildStep buildStep = (BuildStep)buildDescription.getInputStep();
        BuildIOType buildIOType = buildStep.createIOType(false, false, null);
        buildIOType.addResource(buildDescription.createResource("c.cpp"));
        buildIOType.addResource(buildDescription.createResource("d.cpp"));
        buildIOType = buildStep.createIOType(false, false, null);
        buildIOType.addResource(buildDescription.createResource("a.c"));
        buildIOType.addResource(buildDescription.createResource("b.c"));
        buildStep = buildDescription.createStep(null, null);
        buildIOType = buildStep.createIOType(true, false, null);
        buildIOType.addResource(buildDescription.createResource("a.c"));
        buildIOType = buildStep.createIOType(false, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/a.o"));
        buildStep = buildDescription.createStep(null, null);
        buildIOType = buildStep.createIOType(true, false, null);
        buildIOType.addResource(buildDescription.createResource("b.c"));
        buildIOType = buildStep.createIOType(false, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/b.o"));
        buildStep = buildDescription.createStep(null, null);
        buildIOType = buildStep.createIOType(true, false, null);
        buildIOType.addResource(buildDescription.createResource("c.cpp"));
        buildIOType = buildStep.createIOType(false, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/c.o"));
        buildStep = buildDescription.createStep(null, null);
        buildIOType = buildStep.createIOType(true, false, null);
        buildIOType.addResource(buildDescription.createResource("d.cpp"));
        buildIOType = buildStep.createIOType(false, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/d.o"));
        buildStep = buildDescription.createStep(null, null);
        buildIOType = buildStep.createIOType(true, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/a.o"));
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/b.o"));
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/c.o"));
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/d.o"));
        buildIOType = buildStep.createIOType(false, false, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/" + string));
        buildStep = (BuildStep)buildDescription.getOutputStep();
        buildIOType = buildStep.createIOType(true, true, null);
        buildIOType.addResource(buildDescription.createResource(String.valueOf(string3) + "/" + string));
        IBuildDescription iBuildDescription = null;
        try {
            iBuildDescription = BuildDescriptionManager.createBuildDescription((IConfiguration)iConfiguration, null, (int)3);
        }
        catch (CoreException coreException) {
            BuildDescriptionModelTests.fail((String)("build description creation failed: " + coreException.getLocalizedMessage()));
        }
        this.doTestBuildDescription(iBuildDescription, (IBuildDescription)buildDescription);
    }

    public void testDesRebuildState() {
        IOption iOption;
        IHoldsOptions iHoldsOptions;
        IProject iProject = this.createProject("BuildDescription_1", "cdt.managedbuild.target.gnu30.exe");
        try {
            CCProjectNature.addCCNature((IProject)iProject, null);
        }
        catch (CoreException coreException) {
            BuildDescriptionModelTests.fail((String)"fail to add CC nature");
        }
        ManagedBuildTestHelper.createFile(iProject, "a.c");
        ManagedBuildTestHelper.createFile(iProject, "b.c");
        ManagedBuildTestHelper.createFile(iProject, "c.cpp");
        ManagedBuildTestHelper.createFile(iProject, "d.cpp");
        ManagedBuildTestHelper.createFile(iProject, "e.o");
        ManagedBuildTestHelper.createFile(iProject, "dir/f.o");
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
        IManagedProject iManagedProject = iManagedBuildInfo.getManagedProject();
        IConfiguration iConfiguration = iManagedProject.getConfigurations()[0];
        iConfiguration.setRebuildState(false);
        BuildDescriptionModelTests.assertFalse((boolean)iConfiguration.needsRebuild());
        ITool iTool = ((Configuration)iConfiguration).calculateTargetTool();
        iConfiguration.setArtifactName("asdafasdfasdfasdfasdf");
        BuildDescriptionModelTests.assertTrue((boolean)iTool.needsRebuild());
        BuildDescriptionModelTests.assertTrue((boolean)iConfiguration.needsRebuild());
        iTool.setRebuildState(false);
        BuildDescriptionModelTests.assertFalse((boolean)iTool.needsRebuild());
        BuildDescriptionModelTests.assertFalse((boolean)iConfiguration.needsRebuild());
        iConfiguration.setBuildArguments("-fgsdfg -sdfg -sdfg -sfdg");
        BuildDescriptionModelTests.assertFalse((boolean)iConfiguration.needsRebuild());
        iConfiguration.setBuildCommand("fdgsdfbvvcbsdfvcx");
        BuildDescriptionModelTests.assertFalse((boolean)iConfiguration.needsRebuild());
        iConfiguration.setCleanCommand("sadgvfcxvsdfgvxc");
        BuildDescriptionModelTests.assertFalse((boolean)iConfiguration.needsRebuild());
        iConfiguration.setDescription("sfgsdfgsdfcxbvxcbxcvb");
        BuildDescriptionModelTests.assertFalse((boolean)iConfiguration.needsRebuild());
        iConfiguration.setErrorParserIds("fgdsfgsdfgsdfgsdfgsdfgdfs;sdfg;sdfg;sdg;g;sdg");
        BuildDescriptionModelTests.assertFalse((boolean)iConfiguration.needsRebuild());
        iConfiguration.setName("sdfgsdfgsdfgsdfgsdfgdsfgsdf");
        BuildDescriptionModelTests.assertFalse((boolean)iTool.needsRebuild());
        BuildDescriptionModelTests.assertFalse((boolean)iConfiguration.needsRebuild());
        iConfiguration.setPostannouncebuildStep("sdfasdfasdfsdfadfasf");
        BuildDescriptionModelTests.assertFalse((boolean)iConfiguration.needsRebuild());
        iConfiguration.setPostbuildStep("asdf;asdf;asdf;asdf;asdf");
        BuildDescriptionModelTests.assertFalse((boolean)iConfiguration.needsRebuild());
        iConfiguration.setPreannouncebuildStep("sdfgsdgsdhnbvxcvbxcv");
        BuildDescriptionModelTests.assertFalse((boolean)iConfiguration.needsRebuild());
        iConfiguration.setPrebuildStep("sdfg;sdfg;sdfg;sdfgvnbcvbn");
        BuildDescriptionModelTests.assertFalse((boolean)iConfiguration.needsRebuild());
        ITool[] iToolArray = iConfiguration.getFilteredTools();
        ITool iTool2 = null;
        int n = 0;
        while (n < iToolArray.length) {
            iTool2 = iToolArray[n];
            if (iTool2 != iTool) break;
            ++n;
        }
        iConfiguration.setToolCommand(iTool2, "sdgsdcxvzcxvzxc");
        BuildDescriptionModelTests.assertTrue((boolean)iTool2.needsRebuild());
        BuildDescriptionModelTests.assertTrue((boolean)iConfiguration.needsRebuild());
        iTool2.setRebuildState(false);
        BuildDescriptionModelTests.assertFalse((boolean)iTool2.needsRebuild());
        BuildDescriptionModelTests.assertFalse((boolean)iConfiguration.needsRebuild());
        iConfiguration.setArtifactExtension("adsfasdfasdfasdfasdf");
        BuildDescriptionModelTests.assertTrue((boolean)iTool.needsRebuild());
        BuildDescriptionModelTests.assertTrue((boolean)iConfiguration.needsRebuild());
        iTool.setRebuildState(false);
        BuildDescriptionModelTests.assertFalse((boolean)iTool.needsRebuild());
        BuildDescriptionModelTests.assertFalse((boolean)iConfiguration.needsRebuild());
        IBuildObject[] iBuildObjectArray = ManagedBuildTestHelper.getOption(iConfiguration, 0);
        if (iBuildObjectArray != null) {
            iHoldsOptions = (IHoldsOptions)iBuildObjectArray[0];
            iOption = (IOption)iBuildObjectArray[1];
            BuildDescriptionModelTests.assertFalse((boolean)iHoldsOptions.needsRebuild());
            BuildDescriptionModelTests.assertFalse((boolean)iConfiguration.needsRebuild());
            try {
                iConfiguration.setOption(iHoldsOptions, iOption, !iOption.getBooleanValue());
            }
            catch (BuildException buildException) {
                BuildDescriptionModelTests.fail((String)("failed to set the option: " + buildException.getLocalizedMessage()));
            }
            BuildDescriptionModelTests.assertTrue((boolean)iHoldsOptions.needsRebuild());
            BuildDescriptionModelTests.assertTrue((boolean)iConfiguration.needsRebuild());
            iHoldsOptions.setRebuildState(false);
            BuildDescriptionModelTests.assertFalse((boolean)iHoldsOptions.needsRebuild());
            BuildDescriptionModelTests.assertFalse((boolean)iConfiguration.needsRebuild());
        }
        if ((iBuildObjectArray = ManagedBuildTestHelper.getOption(iConfiguration, 1)) != null) {
            iHoldsOptions = (IHoldsOptions)iBuildObjectArray[0];
            iOption = (IOption)iBuildObjectArray[1];
            BuildDescriptionModelTests.assertFalse((boolean)iHoldsOptions.needsRebuild());
            BuildDescriptionModelTests.assertFalse((boolean)iConfiguration.needsRebuild());
            try {
                iConfiguration.setOption(iHoldsOptions, iOption, "sdfgsdfcvsdfgvxcsdf");
            }
            catch (BuildException buildException) {
                BuildDescriptionModelTests.fail((String)("failed to set the option: " + buildException.getLocalizedMessage()));
            }
            BuildDescriptionModelTests.assertTrue((boolean)iHoldsOptions.needsRebuild());
            BuildDescriptionModelTests.assertTrue((boolean)iConfiguration.needsRebuild());
            iHoldsOptions.setRebuildState(false);
            BuildDescriptionModelTests.assertFalse((boolean)iHoldsOptions.needsRebuild());
            BuildDescriptionModelTests.assertFalse((boolean)iConfiguration.needsRebuild());
        }
        if ((iBuildObjectArray = ManagedBuildTestHelper.getOption(iConfiguration, 2)) != null) {
            iHoldsOptions = (IHoldsOptions)iBuildObjectArray[0];
            iOption = (IOption)iBuildObjectArray[1];
            BuildDescriptionModelTests.assertFalse((boolean)iHoldsOptions.needsRebuild());
            BuildDescriptionModelTests.assertFalse((boolean)iConfiguration.needsRebuild());
            try {
                iConfiguration.setOption(iHoldsOptions, iOption, "sdfgsdfcvsdfgvxcfdgvsdf");
            }
            catch (BuildException buildException) {
                BuildDescriptionModelTests.fail((String)("failed to set the option: " + buildException.getLocalizedMessage()));
            }
            BuildDescriptionModelTests.assertTrue((boolean)iHoldsOptions.needsRebuild());
            BuildDescriptionModelTests.assertTrue((boolean)iConfiguration.needsRebuild());
            iHoldsOptions.setRebuildState(false);
            BuildDescriptionModelTests.assertFalse((boolean)iHoldsOptions.needsRebuild());
            BuildDescriptionModelTests.assertFalse((boolean)iConfiguration.needsRebuild());
        }
        if ((iBuildObjectArray = ManagedBuildTestHelper.getOption(iConfiguration, 3)) != null) {
            iHoldsOptions = (IHoldsOptions)iBuildObjectArray[0];
            iOption = (IOption)iBuildObjectArray[1];
            BuildDescriptionModelTests.assertFalse((boolean)iHoldsOptions.needsRebuild());
            BuildDescriptionModelTests.assertFalse((boolean)iConfiguration.needsRebuild());
            try {
                iConfiguration.setOption(iHoldsOptions, iOption, new String[]{"sdfgsd", "fcvsdfgvxcfdgvsdf"});
            }
            catch (BuildException buildException) {
                BuildDescriptionModelTests.fail((String)("failed to set the option: " + buildException.getLocalizedMessage()));
            }
            BuildDescriptionModelTests.assertTrue((boolean)iHoldsOptions.needsRebuild());
            BuildDescriptionModelTests.assertTrue((boolean)iConfiguration.needsRebuild());
            iHoldsOptions.setRebuildState(false);
            BuildDescriptionModelTests.assertFalse((boolean)iHoldsOptions.needsRebuild());
            BuildDescriptionModelTests.assertFalse((boolean)iConfiguration.needsRebuild());
        }
        if ((iBuildObjectArray = ManagedBuildTestHelper.getOption(iConfiguration, 4)) != null) {
            iHoldsOptions = (IHoldsOptions)iBuildObjectArray[0];
            iOption = (IOption)iBuildObjectArray[1];
            BuildDescriptionModelTests.assertFalse((boolean)iHoldsOptions.needsRebuild());
            BuildDescriptionModelTests.assertFalse((boolean)iConfiguration.needsRebuild());
            try {
                iConfiguration.setOption(iHoldsOptions, iOption, new String[]{"sdfgsd", "fcvsdfgvxcfdgvsdf"});
            }
            catch (BuildException buildException) {
                BuildDescriptionModelTests.fail((String)("failed to set the option: " + buildException.getLocalizedMessage()));
            }
            BuildDescriptionModelTests.assertTrue((boolean)iHoldsOptions.needsRebuild());
            BuildDescriptionModelTests.assertTrue((boolean)iConfiguration.needsRebuild());
            iHoldsOptions.setRebuildState(false);
            BuildDescriptionModelTests.assertFalse((boolean)iHoldsOptions.needsRebuild());
            BuildDescriptionModelTests.assertFalse((boolean)iConfiguration.needsRebuild());
        }
        if ((iBuildObjectArray = ManagedBuildTestHelper.getOption(iConfiguration, 5)) != null) {
            iHoldsOptions = (IHoldsOptions)iBuildObjectArray[0];
            iOption = (IOption)iBuildObjectArray[1];
            BuildDescriptionModelTests.assertFalse((boolean)iHoldsOptions.needsRebuild());
            BuildDescriptionModelTests.assertFalse((boolean)iConfiguration.needsRebuild());
            try {
                iConfiguration.setOption(iHoldsOptions, iOption, new String[]{"sdfgsd", "fcvsdfgvxcfdgvsdf"});
            }
            catch (BuildException buildException) {
                BuildDescriptionModelTests.fail((String)("failed to set the option: " + buildException.getLocalizedMessage()));
            }
            BuildDescriptionModelTests.assertTrue((boolean)iHoldsOptions.needsRebuild());
            BuildDescriptionModelTests.assertTrue((boolean)iConfiguration.needsRebuild());
            iHoldsOptions.setRebuildState(false);
            BuildDescriptionModelTests.assertFalse((boolean)iHoldsOptions.needsRebuild());
            BuildDescriptionModelTests.assertFalse((boolean)iConfiguration.needsRebuild());
        }
        if ((iBuildObjectArray = ManagedBuildTestHelper.getOption(iConfiguration, 6)) != null) {
            iHoldsOptions = (IHoldsOptions)iBuildObjectArray[0];
            iOption = (IOption)iBuildObjectArray[1];
            BuildDescriptionModelTests.assertFalse((boolean)iHoldsOptions.needsRebuild());
            BuildDescriptionModelTests.assertFalse((boolean)iConfiguration.needsRebuild());
            try {
                iConfiguration.setOption(iHoldsOptions, iOption, new String[]{"sdfgsd", "fcvsdfgvxcfdgvsdf"});
            }
            catch (BuildException buildException) {
                BuildDescriptionModelTests.fail((String)("failed to set the option: " + buildException.getLocalizedMessage()));
            }
            BuildDescriptionModelTests.assertTrue((boolean)iHoldsOptions.needsRebuild());
            BuildDescriptionModelTests.assertTrue((boolean)iConfiguration.needsRebuild());
            iHoldsOptions.setRebuildState(false);
            BuildDescriptionModelTests.assertFalse((boolean)iHoldsOptions.needsRebuild());
            BuildDescriptionModelTests.assertFalse((boolean)iConfiguration.needsRebuild());
        }
        if ((iBuildObjectArray = ManagedBuildTestHelper.getOption(iConfiguration, 7)) != null) {
            iHoldsOptions = (IHoldsOptions)iBuildObjectArray[0];
            iOption = (IOption)iBuildObjectArray[1];
            BuildDescriptionModelTests.assertFalse((boolean)iHoldsOptions.needsRebuild());
            BuildDescriptionModelTests.assertFalse((boolean)iConfiguration.needsRebuild());
            try {
                iConfiguration.setOption(iHoldsOptions, iOption, new String[]{"sdfgsd", "fcvsdfgvxcfdgvsdf"});
            }
            catch (BuildException buildException) {
                BuildDescriptionModelTests.fail((String)("failed to set the option: " + buildException.getLocalizedMessage()));
            }
            BuildDescriptionModelTests.assertTrue((boolean)iHoldsOptions.needsRebuild());
            BuildDescriptionModelTests.assertTrue((boolean)iConfiguration.needsRebuild());
            iHoldsOptions.setRebuildState(false);
            BuildDescriptionModelTests.assertFalse((boolean)iHoldsOptions.needsRebuild());
            BuildDescriptionModelTests.assertFalse((boolean)iConfiguration.needsRebuild());
        }
        iHoldsOptions = iConfiguration.getToolChain();
        iHoldsOptions.setRebuildState(true);
        BuildDescriptionModelTests.assertTrue((boolean)iHoldsOptions.needsRebuild());
        BuildDescriptionModelTests.assertTrue((boolean)iConfiguration.needsRebuild());
        iHoldsOptions.setRebuildState(false);
        BuildDescriptionModelTests.assertFalse((boolean)iHoldsOptions.needsRebuild());
        BuildDescriptionModelTests.assertFalse((boolean)iConfiguration.needsRebuild());
        int n2 = 0;
        while (n2 < iToolArray.length) {
            this.doTestTool(iToolArray[n2]);
            ++n2;
        }
        IResourceConfiguration[] iResourceConfigurationArray = iConfiguration.getResourceConfigurations();
        int n3 = 0;
        while (n3 < iResourceConfigurationArray.length) {
            IResourceConfiguration iResourceConfiguration = iResourceConfigurationArray[n3];
            BuildDescriptionModelTests.assertFalse((boolean)iResourceConfiguration.needsRebuild());
            BuildDescriptionModelTests.assertFalse((boolean)iConfiguration.needsRebuild());
            iResourceConfiguration.setRebuildState(true);
            BuildDescriptionModelTests.assertTrue((boolean)iResourceConfiguration.needsRebuild());
            BuildDescriptionModelTests.assertTrue((boolean)iConfiguration.needsRebuild());
            iResourceConfiguration.setRebuildState(false);
            BuildDescriptionModelTests.assertFalse((boolean)iResourceConfiguration.needsRebuild());
            BuildDescriptionModelTests.assertFalse((boolean)iConfiguration.needsRebuild());
            iResourceConfiguration.setExclude(!iResourceConfiguration.isExcluded());
            BuildDescriptionModelTests.assertTrue((boolean)iResourceConfiguration.needsRebuild());
            BuildDescriptionModelTests.assertTrue((boolean)iConfiguration.needsRebuild());
            iResourceConfiguration.setRebuildState(false);
            BuildDescriptionModelTests.assertFalse((boolean)iResourceConfiguration.needsRebuild());
            BuildDescriptionModelTests.assertFalse((boolean)iConfiguration.needsRebuild());
            iResourceConfiguration.setExclude(iResourceConfiguration.isExcluded());
            BuildDescriptionModelTests.assertFalse((boolean)iResourceConfiguration.needsRebuild());
            BuildDescriptionModelTests.assertFalse((boolean)iConfiguration.needsRebuild());
            int n4 = iResourceConfiguration.getRcbsApplicability() + 1;
            if (n4 > 4) {
                n4 = 1;
            }
            iResourceConfiguration.setRcbsApplicability(n4);
            BuildDescriptionModelTests.assertTrue((boolean)iResourceConfiguration.needsRebuild());
            BuildDescriptionModelTests.assertTrue((boolean)iConfiguration.needsRebuild());
            iResourceConfiguration.setRebuildState(false);
            BuildDescriptionModelTests.assertFalse((boolean)iResourceConfiguration.needsRebuild());
            BuildDescriptionModelTests.assertFalse((boolean)iConfiguration.needsRebuild());
            iResourceConfiguration.setRcbsApplicability(iResourceConfiguration.getRcbsApplicability());
            BuildDescriptionModelTests.assertFalse((boolean)iResourceConfiguration.needsRebuild());
            BuildDescriptionModelTests.assertFalse((boolean)iConfiguration.needsRebuild());
            ITool iTool3 = iResourceConfiguration.getToolsToInvoke()[0];
            BuildDescriptionModelTests.assertFalse((boolean)iTool3.needsRebuild());
            iResourceConfiguration.setToolCommand(iTool3, "sdsdcdsffewffdvcx");
            BuildDescriptionModelTests.assertTrue((boolean)iTool3.needsRebuild());
            BuildDescriptionModelTests.assertTrue((boolean)iResourceConfiguration.needsRebuild());
            BuildDescriptionModelTests.assertTrue((boolean)iConfiguration.needsRebuild());
            iTool3.setRebuildState(false);
            BuildDescriptionModelTests.assertFalse((boolean)iTool3.needsRebuild());
            BuildDescriptionModelTests.assertFalse((boolean)iResourceConfiguration.needsRebuild());
            BuildDescriptionModelTests.assertFalse((boolean)iConfiguration.needsRebuild());
            iResourceConfiguration.setToolCommand(iTool3, iTool3.getToolCommand());
            BuildDescriptionModelTests.assertFalse((boolean)iTool3.needsRebuild());
            BuildDescriptionModelTests.assertFalse((boolean)iResourceConfiguration.needsRebuild());
            BuildDescriptionModelTests.assertFalse((boolean)iConfiguration.needsRebuild());
            ++n3;
        }
    }

    private void doTestTool(ITool iTool) {
        IAdditionalInput[] iAdditionalInputArray;
        IBuildObject iBuildObject = iTool.getParent();
        IConfiguration iConfiguration = iBuildObject instanceof IResourceConfiguration ? ((IResourceConfiguration)iBuildObject).getParent() : ((IToolChain)iBuildObject).getParent();
        iConfiguration.setRebuildState(false);
        BuildDescriptionModelTests.assertFalse((boolean)iTool.needsRebuild());
        iTool.setRebuildState(true);
        BuildDescriptionModelTests.assertTrue((boolean)iTool.needsRebuild());
        BuildDescriptionModelTests.assertTrue((boolean)iConfiguration.needsRebuild());
        iConfiguration.setRebuildState(false);
        BuildDescriptionModelTests.assertFalse((boolean)iTool.needsRebuild());
        BuildDescriptionModelTests.assertFalse((boolean)iConfiguration.needsRebuild());
        iTool.setRebuildState(true);
        BuildDescriptionModelTests.assertTrue((boolean)iTool.needsRebuild());
        BuildDescriptionModelTests.assertTrue((boolean)iConfiguration.needsRebuild());
        iTool.setRebuildState(false);
        BuildDescriptionModelTests.assertFalse((boolean)iTool.needsRebuild());
        BuildDescriptionModelTests.assertFalse((boolean)iConfiguration.needsRebuild());
        iTool.setCommandLinePattern("asdfasdfasdfasdfasdfasdsdfghdsfg");
        BuildDescriptionModelTests.assertTrue((boolean)iTool.needsRebuild());
        BuildDescriptionModelTests.assertTrue((boolean)iConfiguration.needsRebuild());
        iTool.setRebuildState(false);
        BuildDescriptionModelTests.assertFalse((boolean)iTool.needsRebuild());
        BuildDescriptionModelTests.assertFalse((boolean)iConfiguration.needsRebuild());
        iTool.setOutputFlag("asdfasdfasdfasdgsdf");
        BuildDescriptionModelTests.assertTrue((boolean)iTool.needsRebuild());
        BuildDescriptionModelTests.assertTrue((boolean)iConfiguration.needsRebuild());
        iTool.setRebuildState(false);
        BuildDescriptionModelTests.assertFalse((boolean)iTool.needsRebuild());
        BuildDescriptionModelTests.assertFalse((boolean)iConfiguration.needsRebuild());
        iTool.setOutputPrefix("afgsdfgfadcvwerfdvsdczxv");
        BuildDescriptionModelTests.assertTrue((boolean)iTool.needsRebuild());
        BuildDescriptionModelTests.assertTrue((boolean)iConfiguration.needsRebuild());
        iTool.setRebuildState(false);
        BuildDescriptionModelTests.assertFalse((boolean)iTool.needsRebuild());
        BuildDescriptionModelTests.assertFalse((boolean)iConfiguration.needsRebuild());
        iTool.setRebuildState(true);
        BuildDescriptionModelTests.assertTrue((boolean)iTool.needsRebuild());
        BuildDescriptionModelTests.assertTrue((boolean)iConfiguration.needsRebuild());
        iTool.setRebuildState(false);
        BuildDescriptionModelTests.assertFalse((boolean)iTool.needsRebuild());
        BuildDescriptionModelTests.assertFalse((boolean)iConfiguration.needsRebuild());
        iTool.setToolCommand("dfacvzxcgrsedfxcvsdfcgv");
        BuildDescriptionModelTests.assertTrue((boolean)iTool.needsRebuild());
        BuildDescriptionModelTests.assertTrue((boolean)iConfiguration.needsRebuild());
        iTool.setRebuildState(false);
        BuildDescriptionModelTests.assertFalse((boolean)iTool.needsRebuild());
        BuildDescriptionModelTests.assertFalse((boolean)iConfiguration.needsRebuild());
        IInputType[] iInputTypeArray = iTool.getInputTypes();
        int n = 0;
        while (n < iInputTypeArray.length) {
            IInputType iInputType = iInputTypeArray[n];
            if (!iInputType.isExtensionElement()) {
                iInputType.setAssignToOptionId("qwertyuiop");
                BuildDescriptionModelTests.assertTrue((boolean)iTool.needsRebuild());
                BuildDescriptionModelTests.assertTrue((boolean)iConfiguration.needsRebuild());
                iTool.setRebuildState(false);
                BuildDescriptionModelTests.assertFalse((boolean)iTool.needsRebuild());
                BuildDescriptionModelTests.assertFalse((boolean)iConfiguration.needsRebuild());
                iInputType.setBuildVariable("asdfghjkl");
                BuildDescriptionModelTests.assertTrue((boolean)iTool.needsRebuild());
                BuildDescriptionModelTests.assertTrue((boolean)iConfiguration.needsRebuild());
                iTool.setRebuildState(false);
                BuildDescriptionModelTests.assertFalse((boolean)iTool.needsRebuild());
                BuildDescriptionModelTests.assertFalse((boolean)iConfiguration.needsRebuild());
                iInputType.setMultipleOfType(!iInputType.getMultipleOfType());
                BuildDescriptionModelTests.assertTrue((boolean)iTool.needsRebuild());
                BuildDescriptionModelTests.assertTrue((boolean)iConfiguration.needsRebuild());
                iTool.setRebuildState(false);
                BuildDescriptionModelTests.assertFalse((boolean)iTool.needsRebuild());
                BuildDescriptionModelTests.assertFalse((boolean)iConfiguration.needsRebuild());
                iInputType.setOptionId("zxcvbnm");
                BuildDescriptionModelTests.assertTrue((boolean)iTool.needsRebuild());
                BuildDescriptionModelTests.assertTrue((boolean)iConfiguration.needsRebuild());
                iTool.setRebuildState(false);
                BuildDescriptionModelTests.assertFalse((boolean)iTool.needsRebuild());
                BuildDescriptionModelTests.assertFalse((boolean)iConfiguration.needsRebuild());
                iInputType.setPrimaryInput(!iInputType.getPrimaryInput());
                BuildDescriptionModelTests.assertTrue((boolean)iTool.needsRebuild());
                BuildDescriptionModelTests.assertTrue((boolean)iConfiguration.needsRebuild());
                iTool.setRebuildState(false);
                BuildDescriptionModelTests.assertFalse((boolean)iTool.needsRebuild());
                BuildDescriptionModelTests.assertFalse((boolean)iConfiguration.needsRebuild());
                iAdditionalInputArray = iInputType.getAdditionalInputs();
                int n2 = 0;
                while (n2 < iAdditionalInputArray.length) {
                    IAdditionalInput iAdditionalInput = iAdditionalInputArray[n2];
                    iAdditionalInput.setPaths("as;sd;fgl;fg;qw;er;ty;ui;op");
                    BuildDescriptionModelTests.assertTrue((boolean)iTool.needsRebuild());
                    BuildDescriptionModelTests.assertTrue((boolean)iConfiguration.needsRebuild());
                    iTool.setRebuildState(false);
                    BuildDescriptionModelTests.assertFalse((boolean)iTool.needsRebuild());
                    BuildDescriptionModelTests.assertFalse((boolean)iConfiguration.needsRebuild());
                    ++n2;
                }
            }
            ++n;
        }
        IOutputType[] iOutputTypeArray = iTool.getOutputTypes();
        int n3 = 0;
        while (n3 < iOutputTypeArray.length) {
            iAdditionalInputArray = iOutputTypeArray[n3];
            if (!iAdditionalInputArray.isExtensionElement()) {
                iAdditionalInputArray.setBuildVariable("qwertyuiop");
                BuildDescriptionModelTests.assertTrue((boolean)iTool.needsRebuild());
                BuildDescriptionModelTests.assertTrue((boolean)iConfiguration.needsRebuild());
                iTool.setRebuildState(false);
                BuildDescriptionModelTests.assertFalse((boolean)iTool.needsRebuild());
                BuildDescriptionModelTests.assertFalse((boolean)iConfiguration.needsRebuild());
                iAdditionalInputArray.setMultipleOfType(!iAdditionalInputArray.getMultipleOfType());
                BuildDescriptionModelTests.assertTrue((boolean)iTool.needsRebuild());
                BuildDescriptionModelTests.assertTrue((boolean)iConfiguration.needsRebuild());
                iTool.setRebuildState(false);
                BuildDescriptionModelTests.assertFalse((boolean)iTool.needsRebuild());
                BuildDescriptionModelTests.assertFalse((boolean)iConfiguration.needsRebuild());
                iAdditionalInputArray.setNamePattern("qwerytuuioioyuioghjgfd");
                BuildDescriptionModelTests.assertTrue((boolean)iTool.needsRebuild());
                BuildDescriptionModelTests.assertTrue((boolean)iConfiguration.needsRebuild());
                iTool.setRebuildState(false);
                BuildDescriptionModelTests.assertFalse((boolean)iTool.needsRebuild());
                BuildDescriptionModelTests.assertFalse((boolean)iConfiguration.needsRebuild());
                iAdditionalInputArray.setOptionId("asdfghjklkxcvx");
                BuildDescriptionModelTests.assertTrue((boolean)iTool.needsRebuild());
                BuildDescriptionModelTests.assertTrue((boolean)iConfiguration.needsRebuild());
                iTool.setRebuildState(false);
                BuildDescriptionModelTests.assertFalse((boolean)iTool.needsRebuild());
                BuildDescriptionModelTests.assertFalse((boolean)iConfiguration.needsRebuild());
                iAdditionalInputArray.setOutputNames("asdf;dfgh;hj;jk;ghjk;fgg;sdaf;asdf");
                BuildDescriptionModelTests.assertTrue((boolean)iTool.needsRebuild());
                BuildDescriptionModelTests.assertTrue((boolean)iConfiguration.needsRebuild());
                iTool.setRebuildState(false);
                BuildDescriptionModelTests.assertFalse((boolean)iTool.needsRebuild());
                BuildDescriptionModelTests.assertFalse((boolean)iConfiguration.needsRebuild());
                iAdditionalInputArray.setOutputPrefix("asdfscvbdfgsdfgsdfvcx");
                BuildDescriptionModelTests.assertTrue((boolean)iTool.needsRebuild());
                BuildDescriptionModelTests.assertTrue((boolean)iConfiguration.needsRebuild());
                iTool.setRebuildState(false);
                BuildDescriptionModelTests.assertFalse((boolean)iTool.needsRebuild());
                BuildDescriptionModelTests.assertFalse((boolean)iConfiguration.needsRebuild());
                iAdditionalInputArray.setPrimaryOutput(!iAdditionalInputArray.getPrimaryOutput());
                BuildDescriptionModelTests.assertTrue((boolean)iTool.needsRebuild());
                BuildDescriptionModelTests.assertTrue((boolean)iConfiguration.needsRebuild());
                iTool.setRebuildState(false);
                BuildDescriptionModelTests.assertFalse((boolean)iTool.needsRebuild());
                BuildDescriptionModelTests.assertFalse((boolean)iConfiguration.needsRebuild());
            }
            ++n3;
        }
    }

    public void testDesRebuildStateInDescription() {
        IProject iProject = this.createProject("BuildDescription_1", "cdt.managedbuild.target.bdm.exe");
        try {
            CCProjectNature.addCCNature((IProject)iProject, null);
        }
        catch (CoreException coreException) {
            BuildDescriptionModelTests.fail((String)"fail to add CC nature");
        }
        ManagedBuildTestHelper.createFile(iProject, "a.c");
        ManagedBuildTestHelper.createFile(iProject, "b.c");
        ManagedBuildTestHelper.createFile(iProject, "c.cpp");
        ManagedBuildTestHelper.createFile(iProject, "d/d.cpp");
        ManagedBuildTestHelper.createFile(iProject, "d2/e.s2");
        ManagedBuildTestHelper.createFile(iProject, "f.s2");
        ManagedBuildTestHelper.createFile(iProject, "e.o");
        ManagedBuildTestHelper.createFile(iProject, "dir/f.o");
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
        IManagedProject iManagedProject = iManagedBuildInfo.getManagedProject();
        Configuration configuration = (Configuration)iManagedProject.getConfigurations()[0];
        String string = String.valueOf(configuration.getName()) + "/";
        configuration.setRebuildState(false);
        IBuildDescription iBuildDescription = null;
        try {
            iBuildDescription = BuildDescriptionManager.createBuildDescription((IConfiguration)configuration, null, (int)3);
        }
        catch (CoreException coreException) {
            BuildDescriptionModelTests.fail((String)("build description creation failed: " + coreException.getLocalizedMessage()));
        }
        IBuildResource[] iBuildResourceArray = BuildDescriptionManager.filterGeneratedBuildResources((IBuildResource[])iBuildDescription.getResources(), (int)2);
        BuildDescriptionModelTests.assertEquals((int)iBuildResourceArray.length, (int)0);
        iBuildResourceArray = BuildDescriptionManager.filterGeneratedBuildResources((IBuildResource[])iBuildDescription.getResources(), (int)1);
        BuildDescriptionModelTests.assertEquals((int)iBuildResourceArray.length, (int)0);
        iBuildResourceArray = BuildDescriptionManager.filterGeneratedBuildResources((IBuildResource[])iBuildDescription.getResources(), (int)3);
        BuildDescriptionModelTests.assertEquals((int)iBuildResourceArray.length, (int)0);
        ITool iTool = configuration.calculateTargetTool();
        iTool.setToolCommand("fgdfgcvbcbv");
        try {
            iBuildDescription = BuildDescriptionManager.createBuildDescription((IConfiguration)configuration, null, (int)3);
        }
        catch (CoreException coreException) {
            BuildDescriptionModelTests.fail((String)("build description creation failed: " + coreException.getLocalizedMessage()));
        }
        iBuildResourceArray = BuildDescriptionManager.filterGeneratedBuildResources((IBuildResource[])iBuildDescription.getResources(), (int)2);
        IBuildResource[] iBuildResourceArray2 = iBuildDescription.getOutputStep().getInputResources();
        BuildDescriptionModelTests.assertEquals((int)iBuildResourceArray.length, (int)1);
        BuildDescriptionModelTests.assertEquals((int)iBuildResourceArray2.length, (int)1);
        if (iBuildResourceArray[0] != iBuildResourceArray2[0]) {
            BuildDescriptionModelTests.fail((String)"rebuild resources do not match");
        }
        IBuildResource iBuildResource = iBuildResourceArray2[0];
        iBuildResourceArray = BuildDescriptionManager.filterGeneratedBuildResources((IBuildResource[])iBuildDescription.getResources(), (int)1);
        BuildDescriptionModelTests.assertEquals((int)iBuildResourceArray.length, (int)0);
        iBuildResourceArray = BuildDescriptionManager.filterGeneratedBuildResources((IBuildResource[])iBuildDescription.getResources(), (int)3);
        BuildDescriptionModelTests.assertEquals((int)iBuildResourceArray.length, (int)1);
        BuildDescriptionModelTests.assertEquals((int)iBuildResourceArray2.length, (int)1);
        if (iBuildResourceArray[0] != iBuildResourceArray2[0]) {
            BuildDescriptionModelTests.fail((String)"rebuild resources do not match");
        }
        configuration.setRebuildState(false);
        iTool = this.getToolForInExt((IConfiguration)configuration, "cpp");
        iTool.setToolCommand("sdfgzxcvzxcvzxv");
        try {
            iBuildDescription = BuildDescriptionManager.createBuildDescription((IConfiguration)configuration, null, (int)3);
        }
        catch (CoreException coreException) {
            BuildDescriptionModelTests.fail((String)("build description creation failed: " + coreException.getLocalizedMessage()));
        }
        iBuildResourceArray = BuildDescriptionManager.filterGeneratedBuildResources((IBuildResource[])iBuildDescription.getResources(), (int)2);
        iBuildResourceArray2 = iBuildDescription.getOutputStep().getInputResources();
        BuildDescriptionModelTests.assertEquals((int)iBuildResourceArray2.length, (int)1);
        iBuildResource = iBuildResourceArray2[0];
        iBuildResourceArray2 = new IBuildResource[5];
        iBuildResourceArray2[0] = this.getResourceForProjPath(iBuildDescription, String.valueOf(string) + "c.o");
        BuildDescriptionModelTests.assertNotNull((Object)iBuildResourceArray2[0]);
        iBuildResourceArray2[1] = this.getResourceForProjPath(iBuildDescription, String.valueOf(string) + "d/d.o");
        BuildDescriptionModelTests.assertNotNull((Object)iBuildResourceArray2[1]);
        iBuildResourceArray2[2] = iBuildResource;
        iBuildResourceArray2[3] = this.getResourceForProjPath(iBuildDescription, String.valueOf(string) + "a.o");
        BuildDescriptionModelTests.assertNotNull((Object)iBuildResourceArray2[0]);
        iBuildResourceArray2[4] = this.getResourceForProjPath(iBuildDescription, String.valueOf(string) + "b.o");
        BuildDescriptionModelTests.assertNotNull((Object)iBuildResourceArray2[1]);
        BuildDescriptionModelTests.assertEquals((int)iBuildResourceArray.length, (int)5);
        BuildDescriptionModelTests.assertEquals((int)iBuildResourceArray2.length, (int)5);
        if (!this.resourcesEqual(iBuildResourceArray, iBuildResourceArray2)) {
            BuildDescriptionModelTests.fail((String)"rebuild resources do not match");
        }
        iBuildResourceArray = BuildDescriptionManager.filterGeneratedBuildResources((IBuildResource[])iBuildDescription.getResources(), (int)1);
        BuildDescriptionModelTests.assertEquals((int)iBuildResourceArray.length, (int)0);
        iBuildResourceArray = BuildDescriptionManager.filterGeneratedBuildResources((IBuildResource[])iBuildDescription.getResources(), (int)3);
        BuildDescriptionModelTests.assertEquals((int)iBuildResourceArray.length, (int)5);
        if (!this.resourcesEqual(iBuildResourceArray, iBuildResourceArray2)) {
            BuildDescriptionModelTests.fail((String)"rebuild resources do not match");
        }
        configuration.setRebuildState(false);
        iTool = this.getToolForInExt((IConfiguration)configuration, "s2");
        iTool.setToolCommand("sdfgzxcvzxcvzxv");
        try {
            iBuildDescription = BuildDescriptionManager.createBuildDescription((IConfiguration)configuration, null, (int)3);
        }
        catch (CoreException coreException) {
            BuildDescriptionModelTests.fail((String)("build description creation failed: " + coreException.getLocalizedMessage()));
        }
        iBuildResourceArray = BuildDescriptionManager.filterGeneratedBuildResources((IBuildResource[])iBuildDescription.getResources(), (int)2);
        iBuildResourceArray2 = iBuildDescription.getOutputStep().getInputResources();
        BuildDescriptionModelTests.assertEquals((int)iBuildResourceArray2.length, (int)1);
        iBuildResource = iBuildResourceArray2[0];
        iBuildResourceArray2 = new IBuildResource[3];
        iBuildResourceArray2[0] = this.getResourceForProjPath(iBuildDescription, String.valueOf(string) + "d2/e.o");
        BuildDescriptionModelTests.assertNotNull((Object)iBuildResourceArray2[0]);
        iBuildResourceArray2[1] = this.getResourceForProjPath(iBuildDescription, String.valueOf(string) + "f.o");
        BuildDescriptionModelTests.assertNotNull((Object)iBuildResourceArray2[1]);
        iBuildResourceArray2[2] = iBuildResource;
        BuildDescriptionModelTests.assertEquals((int)iBuildResourceArray.length, (int)3);
        BuildDescriptionModelTests.assertEquals((int)iBuildResourceArray2.length, (int)3);
        if (!this.resourcesEqual(iBuildResourceArray, iBuildResourceArray2)) {
            BuildDescriptionModelTests.fail((String)"rebuild resources do not match");
        }
        iBuildResourceArray = BuildDescriptionManager.filterGeneratedBuildResources((IBuildResource[])iBuildDescription.getResources(), (int)1);
        BuildDescriptionModelTests.assertEquals((int)iBuildResourceArray.length, (int)0);
        iBuildResourceArray = BuildDescriptionManager.filterGeneratedBuildResources((IBuildResource[])iBuildDescription.getResources(), (int)3);
        BuildDescriptionModelTests.assertEquals((int)iBuildResourceArray.length, (int)3);
        if (!this.resourcesEqual(iBuildResourceArray, iBuildResourceArray2)) {
            BuildDescriptionModelTests.fail((String)"rebuild resources do not match");
        }
        configuration.setRebuildState(false);
    }

    private IBuildResource getResourceForProjPath(IBuildDescription iBuildDescription, String string) {
        return this.getResourceForProjPath(iBuildDescription, (IPath)new Path(string));
    }

    private IBuildResource getResourceForProjPath(IBuildDescription iBuildDescription, IPath iPath) {
        IPath iPath2 = iBuildDescription.getConfiguration().getOwner().getProject().getLocation().append(iPath);
        return iBuildDescription.getBuildResource(iPath2);
    }

    private ITool getToolForInExt(IConfiguration iConfiguration, String string) {
        ITool[] iToolArray = iConfiguration.getFilteredTools();
        int n = 0;
        while (n < iToolArray.length) {
            if (iToolArray[n].buildsFileType(string)) {
                return iToolArray[n];
            }
            ++n;
        }
        return null;
    }

    private boolean resourcesEqual(IBuildResource[] iBuildResourceArray, IBuildResource[] iBuildResourceArray2) {
        if (iBuildResourceArray.length != iBuildResourceArray2.length) {
            return false;
        }
        int n = 0;
        while (n < iBuildResourceArray.length) {
            int n2 = 0;
            while (n2 < iBuildResourceArray2.length) {
                if (iBuildResourceArray2[n2] == iBuildResourceArray[n]) break;
                ++n2;
            }
            if (n2 == iBuildResourceArray2.length) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private class CompositeCleaner
    implements Runnable {
        private List fRunnables = new ArrayList();

        private CompositeCleaner() {
        }

        public void addRunnable(Runnable runnable) {
            this.fRunnables.add(runnable);
        }

        public void run() {
            Iterator iterator = this.fRunnables.iterator();
            while (iterator.hasNext()) {
                Runnable runnable = (Runnable)iterator.next();
                runnable.run();
            }
            this.fRunnables.clear();
        }
    }

    private class ProjectCleaner
    implements Runnable {
        List fProjList = new ArrayList();

        public ProjectCleaner() {
        }

        public ProjectCleaner(String string) {
            this.addProject(string);
        }

        public ProjectCleaner(IProject iProject) {
            this.addProject(iProject);
        }

        public void addProject(IProject iProject) {
            this.addProject(iProject.getName());
        }

        public void addProject(String string) {
            this.fProjList.add(string);
        }

        public void run() {
            Iterator iterator = this.fProjList.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                ManagedBuildTestHelper.removeProject(string);
            }
            this.fProjList.clear();
        }
    }
}

