/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.core.tests;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedOutputNameProvider;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.makegen.IManagedDependencyGenerator;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class DefaultFortranDependencyCalculator
implements IManagedDependencyGenerator,
IManagedOutputNameProvider {
    public static final String MODULE_EXTENSION = "mod";

    private String[] findUsedModuleNames(File file) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(bufferedInputStream));
            StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
            streamTokenizer.commentChar(33);
            streamTokenizer.eolIsSignificant(false);
            streamTokenizer.slashSlashComments(false);
            streamTokenizer.slashStarComments(false);
            streamTokenizer.wordChars(95, 95);
            while (streamTokenizer.nextToken() != -1) {
                if (streamTokenizer.ttype != -3 || !streamTokenizer.sval.equalsIgnoreCase("use")) continue;
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == -3) {
                    arrayList.add(streamTokenizer.sval);
                    continue;
                }
                streamTokenizer.pushBack();
            }
        }
        catch (Exception exception) {
            return new String[0];
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private String[] findModuleNames(File file) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(bufferedInputStream));
            StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
            streamTokenizer.commentChar(33);
            streamTokenizer.eolIsSignificant(false);
            streamTokenizer.slashSlashComments(false);
            streamTokenizer.slashStarComments(false);
            streamTokenizer.wordChars(95, 95);
            while (streamTokenizer.nextToken() != -1) {
                if (streamTokenizer.ttype != -3 || !streamTokenizer.sval.equalsIgnoreCase("module")) continue;
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == -3) {
                    arrayList.add(streamTokenizer.sval);
                    continue;
                }
                streamTokenizer.pushBack();
            }
        }
        catch (Exception exception) {
            return new String[0];
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private boolean isFortranFile(ITool iTool, IResource iResource) {
        String string = iResource.getFileExtension();
        if (string != null) {
            if (string.equalsIgnoreCase("f")) {
                return true;
            }
            if (string.equalsIgnoreCase("for")) {
                return true;
            }
            if (string.equalsIgnoreCase("f90")) {
                return true;
            }
        }
        return false;
    }

    private IResource[] FindModulesInResources(IProject iProject, ITool iTool, IResource iResource, IResource[] iResourceArray, String string, String[] stringArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < iResourceArray.length) {
            if (!iResourceArray[n].equals((Object)iResource)) {
                IResource[] iResourceArray2;
                if (iResourceArray[n].getType() == 1) {
                    String[] stringArray2;
                    iResourceArray2 = iResourceArray[n].getLocation().toFile();
                    if (this.isFortranFile(iTool, iResourceArray[n]) && (stringArray2 = this.findModuleNames((File)iResourceArray2)) != null) {
                        int n2 = 0;
                        while (n2 < stringArray.length) {
                            boolean bl = false;
                            int n3 = 0;
                            while (n3 < stringArray2.length) {
                                if (stringArray[n2].equalsIgnoreCase(stringArray2[n3])) {
                                    IPath iPath = Path.fromOSString((String)(String.valueOf(string) + '/' + stringArray2[n3] + "." + MODULE_EXTENSION));
                                    arrayList.add(iProject.getFile(iPath));
                                    arrayList.add(iResourceArray[n]);
                                    bl = true;
                                    break;
                                }
                                ++n3;
                            }
                            if (!bl) {
                                ++n2;
                                continue;
                            }
                            break;
                        }
                    }
                } else if (iResourceArray[n].getType() == 2) {
                    try {
                        iResourceArray2 = this.FindModulesInResources(iProject, iTool, iResource, ((IFolder)iResourceArray[n]).members(), string, stringArray);
                        if (iResourceArray2 != null) {
                            int n4 = 0;
                            while (n4 < iResourceArray2.length) {
                                arrayList.add(iResourceArray2[n4]);
                                ++n4;
                            }
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            ++n;
        }
        return arrayList.toArray(new IResource[arrayList.size()]);
    }

    public IResource[] findDependencies(IResource iResource, IProject iProject) {
        String[] stringArray;
        ITool iTool;
        IConfiguration iConfiguration;
        ArrayList<IResource> arrayList;
        block9: {
            File file;
            block8: {
                arrayList = new ArrayList<IResource>();
                IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
                iConfiguration = iManagedBuildInfo.getDefaultConfiguration();
                iTool = null;
                ITool[] iToolArray = iConfiguration.getTools();
                int n = 0;
                while (n < iToolArray.length) {
                    if (iToolArray[n].getName().equals("Fortran (ifort) Compiler for Win32")) {
                        iTool = iToolArray[n];
                        break;
                    }
                    ++n;
                }
                file = iResource.getLocation().toFile();
                if (this.isFortranFile(iTool, iResource)) break block8;
                return null;
            }
            stringArray = this.findUsedModuleNames(file);
            if (stringArray.length != 0) break block9;
            return null;
        }
        try {
            IResource[] iResourceArray = iProject.members();
            IResource[] iResourceArray2 = this.FindModulesInResources(iProject, iTool, iResource, iResourceArray, iConfiguration.getName(), stringArray);
            if (iResourceArray2 != null) {
                int n = 0;
                while (n < iResourceArray2.length) {
                    arrayList.add(iResourceArray2[n]);
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            return null;
        }
        return arrayList.toArray(new IResource[arrayList.size()]);
    }

    public int getCalculatorType() {
        return 3;
    }

    public String getDependencyCommand(IResource iResource, IManagedBuildInfo iManagedBuildInfo) {
        return null;
    }

    public IPath[] getOutputNames(ITool iTool, IPath[] iPathArray) {
        String[] stringArray;
        ArrayList<IPath> arrayList = new ArrayList<IPath>();
        if (iPathArray.length > 0 && (stringArray = this.findModuleNames(iPathArray[0].toFile())) != null) {
            int n = 0;
            while (n < stringArray.length) {
                IPath iPath = Path.fromOSString((String)("./" + stringArray[n] + "." + MODULE_EXTENSION));
                arrayList.add(iPath);
                ++n;
            }
        }
        return arrayList.toArray(new IPath[arrayList.size()]);
    }
}

