/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.core.tests;

import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.ITargetPlatform;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.Builder;
import org.eclipse.core.runtime.IConfigurationElement;

public class ManagedBuildCoreTests
extends TestCase {
    private static final boolean boolVal = true;
    private static IProjectType exeType;
    private static IProjectType libType;
    private static IProjectType dllType;
    static /* synthetic */ Class class$0;

    public ManagedBuildCoreTests(String string) {
        super(string);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.managedbuilder.core.tests.ManagedBuildCoreTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite testSuite = new TestSuite(clazz.getName());
        testSuite.addTest((Test)new ManagedBuildCoreTests("testLoadManifest"));
        return testSuite;
    }

    public void testLoadManifest() throws Exception {
        ManagedBuildManager.getDefinedProjectTypes();
        exeType = ManagedBuildManager.getProjectType((String)"cdt.managedbuild.target.testgnu21.exe");
        this.checkExeProjectType(exeType);
        dllType = ManagedBuildManager.getProjectType((String)"cdt.managedbuild.target.testgnu21.so");
        this.checkSoProjectType(dllType);
        libType = ManagedBuildManager.getProjectType((String)"cdt.managedbuild.target.testgnu21.lib");
        this.checkLibProjectType(libType);
    }

    private void checkExeProjectType(IProjectType iProjectType) throws BuildException {
        int n = 2;
        String[] stringArray = new String[]{"Dbg", "Rel"};
        String string = "rm -rf";
        String string2 = "org.eclipse.cdt.core.MakeErrorParser;org.eclipse.cdt.core.GCCErrorParser;org.eclipse.cdt.core.GLDErrorParser;org.eclipse.cdt.core.GASErrorParser";
        String string3 = "solaris,linux,hpux,aix,qnx";
        int n2 = 5;
        Object[] objectArray = new String[]{"all"};
        String string4 = "org.eclipse.cdt.core.ELF";
        String string5 = "org.eclipse.cdt.core.PE";
        String[] stringArray2 = new String[]{"Dbg Platform", "Rel Platform"};
        String string6 = "make";
        String string7 = "-k";
        String[] stringArray3 = new String[]{"Dbg Builder", "Rel Builder"};
        String string8 = "org.eclipse.cdt.managedbuilder.makegen.gnu.GnuMakefileGenerator";
        String[] stringArray4 = new String[]{"cdt.managedbuild.tool.testgnu.c.compiler.exe.debug", "cdt.managedbuild.tool.testgnu.c.compiler.exe.release"};
        String string9 = "cdt.managedbuild.tool.testgnu.c.compiler";
        String string10 = "-o";
        String string11 = "gcc";
        Object[] objectArray2 = new String[]{"c"};
        Object[] objectArray3 = new String[]{"h"};
        Object[] objectArray4 = new String[]{"o"};
        String string12 = "testgnu.c.compiler.category.preprocessor";
        String[] stringArray5 = new String[]{"testgnu.c.compiler.exe.debug.option.optimization.level", "testgnu.c.compiler.exe.release.option.optimization.level"};
        String[] stringArray6 = new String[]{"testgnu.c.optimization.level.none", "testgnu.c.optimization.level.most"};
        String string13 = "Posix.Optimize.None, Posix.Optimize.Optimize, Posix.Optimize.More, Posix.Optimize.Most";
        int n3 = 4;
        String[] stringArray7 = new String[]{"-O0", "-O3"};
        String string14 = "testgnu.c.compiler.option.debugging.other";
        String string15 = "Posix.Debug.Other";
        String string16 = "testgnu.c.compiler.option.debugging.gprof";
        String string17 = "Posix.Debug.gprof";
        String string18 = "-pg";
        boolean bl = false;
        int n4 = 5;
        int n5 = 0;
        int n6 = 0;
        ManagedBuildCoreTests.assertNotNull((Object)iProjectType);
        ManagedBuildCoreTests.assertTrue((boolean)iProjectType.isTestProjectType());
        ManagedBuildCoreTests.assertFalse((boolean)iProjectType.isAbstract());
        IConfiguration[] iConfigurationArray = iProjectType.getConfigurations();
        ManagedBuildCoreTests.assertNotNull((Object)iConfigurationArray);
        ManagedBuildCoreTests.assertEquals((int)n, (int)iConfigurationArray.length);
        int n7 = 0;
        while (n7 < iConfigurationArray.length) {
            ManagedBuildCoreTests.assertEquals((String)iConfigurationArray[n7].getName(), (String)stringArray[n7]);
            ManagedBuildCoreTests.assertEquals((String)string, (String)iConfigurationArray[n7].getCleanCommand());
            ManagedBuildCoreTests.assertEquals((String)string2, (String)iConfigurationArray[n7].getErrorParserIds());
            IToolChain iToolChain = iConfigurationArray[n7].getToolChain();
            ITargetPlatform iTargetPlatform = iToolChain.getTargetPlatform();
            ArrayList<String> arrayList = new ArrayList<String>();
            String[] stringArray8 = string3.split(",");
            int n8 = 0;
            while (n8 < stringArray8.length) {
                arrayList.add(stringArray8[n8].trim());
                ++n8;
            }
            ManagedBuildCoreTests.assertTrue((boolean)Arrays.equals(iTargetPlatform.getOSList(), arrayList.toArray(new String[n2])));
            ManagedBuildCoreTests.assertTrue((boolean)Arrays.equals(iTargetPlatform.getArchList(), objectArray));
            String[] stringArray9 = iTargetPlatform.getBinaryParserList();
            ManagedBuildCoreTests.assertEquals((int)stringArray9.length, (int)2);
            ManagedBuildCoreTests.assertEquals((String)stringArray9[0], (String)string4);
            ManagedBuildCoreTests.assertEquals((String)stringArray9[1], (String)string5);
            ManagedBuildCoreTests.assertEquals((String)iTargetPlatform.getName(), (String)stringArray2[n7]);
            IBuilder iBuilder = iToolChain.getBuilder();
            ManagedBuildCoreTests.assertEquals((String)iBuilder.getCommand(), (String)string6);
            ManagedBuildCoreTests.assertEquals((String)iBuilder.getArguments(), (String)string7);
            ManagedBuildCoreTests.assertEquals((String)iBuilder.getName(), (String)stringArray3[n7]);
            IConfigurationElement iConfigurationElement = ((Builder)iBuilder).getBuildFileGeneratorElement();
            if (iConfigurationElement != null) {
                ManagedBuildCoreTests.assertEquals((String)iConfigurationElement.getAttribute("buildfileGenerator"), (String)string8);
            }
            ITool[] iToolArray = iToolChain.getTools();
            ManagedBuildCoreTests.assertEquals((int)iToolArray.length, (int)n4);
            ITool iTool = iToolArray[n5];
            ITool iTool2 = iTool.getSuperClass();
            ManagedBuildCoreTests.assertEquals((String)iTool.getId(), (String)stringArray4[n7]);
            ManagedBuildCoreTests.assertEquals((String)iTool2.getId(), (String)string9);
            ManagedBuildCoreTests.assertEquals((int)iTool.getNatureFilter(), (int)n6);
            ManagedBuildCoreTests.assertTrue((boolean)Arrays.equals(iTool2.getAllInputExtensions(), objectArray2));
            ManagedBuildCoreTests.assertEquals((String)iTool2.getOutputFlag(), (String)string10);
            ManagedBuildCoreTests.assertEquals((String)iTool2.getToolCommand(), (String)string11);
            ManagedBuildCoreTests.assertTrue((boolean)Arrays.equals(iTool2.getAllDependencyExtensions(), objectArray3));
            ManagedBuildCoreTests.assertTrue((boolean)Arrays.equals(iTool2.getOutputsAttribute(), objectArray4));
            ManagedBuildCoreTests.assertTrue((boolean)iTool2.isAbstract());
            IOptionCategory[] iOptionCategoryArray = iTool2.getChildCategories();
            ManagedBuildCoreTests.assertEquals((String)iOptionCategoryArray[0].getId(), (String)string12);
            IOption iOption = iTool.getOptionById(stringArray5[n7]);
            ManagedBuildCoreTests.assertTrue((boolean)iOption.isExtensionElement());
            String string19 = (String)iOption.getDefaultValue();
            ManagedBuildCoreTests.assertEquals((int)iOption.getValueType(), (int)1);
            ManagedBuildCoreTests.assertEquals((String)string19, (String)stringArray6[n7]);
            String string20 = iOption.getEnumCommand(string19);
            ManagedBuildCoreTests.assertEquals((String)string20, (String)stringArray7[n7]);
            ArrayList<String> arrayList2 = new ArrayList<String>();
            iOption.getApplicableValues();
            String[] stringArray10 = string13.split(",");
            n8 = 0;
            while (n8 < stringArray10.length) {
                arrayList2.add(stringArray10[n8].trim());
                ++n8;
            }
            ManagedBuildCoreTests.assertTrue((boolean)Arrays.equals(iOption.getApplicableValues(), arrayList2.toArray(new String[n3])));
            iOption = iTool.getOptionById(string14);
            ManagedBuildCoreTests.assertTrue((boolean)iOption.isExtensionElement());
            ManagedBuildCoreTests.assertEquals((int)iOption.getValueType(), (int)2);
            ManagedBuildCoreTests.assertEquals((String)iOption.getName(), (String)string15);
            iOption = iTool.getOptionById(string16);
            ManagedBuildCoreTests.assertTrue((boolean)iOption.isExtensionElement());
            ManagedBuildCoreTests.assertEquals((int)iOption.getValueType(), (int)0);
            boolean bl2 = iOption.getBooleanValue();
            ManagedBuildCoreTests.assertEquals((boolean)bl2, (boolean)bl);
            ManagedBuildCoreTests.assertEquals((String)iOption.getName(), (String)string17);
            ManagedBuildCoreTests.assertEquals((String)iOption.getCommand(), (String)string18);
            ++n7;
        }
    }

    private void checkSoProjectType(IProjectType iProjectType) throws BuildException {
        int n = 2;
        String[] stringArray = new String[]{"Debug", "Release"};
        String string = "rm -rf";
        String string2 = "org.eclipse.cdt.core.MakeErrorParser;org.eclipse.cdt.core.GCCErrorParser;org.eclipse.cdt.core.GLDErrorParser;org.eclipse.cdt.core.GASErrorParser";
        String string3 = "so";
        String string4 = "solaris,linux,hpux,aix,qnx";
        int n2 = 5;
        Object[] objectArray = new String[]{"all"};
        String string5 = "org.eclipse.cdt.core.ELF";
        String[] stringArray2 = new String[]{"so Debug Platform", "so Release Platform"};
        String string6 = "make";
        String string7 = "-k";
        String[] stringArray3 = new String[]{"so Debug Builder", "so Release Builder"};
        String string8 = "org.eclipse.cdt.managedbuilder.core.GCCManagedMakePerProjectProfile";
        String[] stringArray4 = new String[]{"so Debug ToolChain", "so Release ToolChain"};
        String[] stringArray5 = new String[]{"cdt.managedbuild.tool.testgnu.c.linker.so.debug", "cdt.managedbuild.tool.testgnu.c.linker.so.release"};
        String string9 = "cdt.managedbuild.tool.testgnu.c.linker";
        String string10 = "lib";
        Object[] objectArray2 = new String[]{""};
        String string11 = "-o";
        String string12 = "gcc";
        Object[] objectArray3 = new String[]{"o"};
        Object[] objectArray4 = new String[]{""};
        String string13 = "testgnu.c.link.category.general";
        String string14 = "testgnu.c.link.option.libs";
        String string15 = "testgnu.c.link.option.paths";
        String string16 = "testgnu.c.link.option.userobjs";
        String string17 = "-l";
        String string18 = "-L";
        String string19 = "testgnu.c.link.option.defname";
        String string20 = "Posix.Linker.Defname";
        String string21 = "-Wl,--output-def=";
        String string22 = "testgnu.c.link.option.nostart";
        String string23 = "Posix.Linker.NoStartFiles";
        String string24 = "-nostartfiles";
        boolean bl = false;
        String string25 = "testgnu.c.link.option.shared";
        String string26 = "Posix.Linker.Shared";
        String string27 = "-shared";
        boolean bl2 = false;
        int n3 = 5;
        int n4 = 2;
        int n5 = 0;
        ManagedBuildCoreTests.assertNotNull((Object)iProjectType);
        ManagedBuildCoreTests.assertTrue((boolean)iProjectType.isTestProjectType());
        ManagedBuildCoreTests.assertFalse((boolean)iProjectType.isAbstract());
        IConfiguration[] iConfigurationArray = iProjectType.getConfigurations();
        ManagedBuildCoreTests.assertNotNull((Object)iConfigurationArray);
        ManagedBuildCoreTests.assertEquals((int)n, (int)iConfigurationArray.length);
        int n6 = 0;
        while (n6 < iConfigurationArray.length) {
            ManagedBuildCoreTests.assertEquals((String)iConfigurationArray[n6].getName(), (String)stringArray[n6]);
            ManagedBuildCoreTests.assertEquals((String)string, (String)iConfigurationArray[n6].getCleanCommand());
            ManagedBuildCoreTests.assertEquals((String)string2, (String)iConfigurationArray[n6].getErrorParserIds());
            ManagedBuildCoreTests.assertEquals((String)iConfigurationArray[n6].getArtifactExtension(), (String)string3);
            IToolChain iToolChain = iConfigurationArray[n6].getToolChain();
            ManagedBuildCoreTests.assertEquals((String)iToolChain.getName(), (String)stringArray4[n6]);
            ArrayList<String> arrayList = new ArrayList<String>();
            String[] stringArray6 = string4.split(",");
            int n7 = 0;
            while (n7 < stringArray6.length) {
                arrayList.add(stringArray6[n7].trim());
                ++n7;
            }
            ManagedBuildCoreTests.assertEquals((String)string2, (String)iConfigurationArray[n6].getErrorParserIds());
            ManagedBuildCoreTests.assertTrue((boolean)Arrays.equals(iToolChain.getOSList(), arrayList.toArray(new String[n2])));
            ManagedBuildCoreTests.assertTrue((boolean)Arrays.equals(iToolChain.getArchList(), objectArray));
            ManagedBuildCoreTests.assertEquals((String)string8, (String)iToolChain.getScannerConfigDiscoveryProfileId());
            ITargetPlatform iTargetPlatform = iToolChain.getTargetPlatform();
            ManagedBuildCoreTests.assertTrue((boolean)Arrays.equals(iTargetPlatform.getOSList(), arrayList.toArray(new String[n2])));
            ManagedBuildCoreTests.assertTrue((boolean)Arrays.equals(iTargetPlatform.getArchList(), objectArray));
            String[] stringArray7 = iTargetPlatform.getBinaryParserList();
            ManagedBuildCoreTests.assertEquals((int)stringArray7.length, (int)1);
            ManagedBuildCoreTests.assertEquals((String)stringArray7[0], (String)string5);
            ManagedBuildCoreTests.assertEquals((String)iTargetPlatform.getName(), (String)stringArray2[n6]);
            IBuilder iBuilder = iToolChain.getBuilder();
            ManagedBuildCoreTests.assertEquals((String)iBuilder.getCommand(), (String)string6);
            ManagedBuildCoreTests.assertEquals((String)iBuilder.getArguments(), (String)string7);
            ManagedBuildCoreTests.assertEquals((String)iBuilder.getName(), (String)stringArray3[n6]);
            ITool[] iToolArray = iToolChain.getTools();
            ManagedBuildCoreTests.assertEquals((int)iToolArray.length, (int)n3);
            ITool iTool = iToolArray[n4];
            ITool iTool2 = iTool.getSuperClass();
            ManagedBuildCoreTests.assertEquals((String)iTool.getId(), (String)stringArray5[n6]);
            ManagedBuildCoreTests.assertEquals((String)iTool2.getId(), (String)string9);
            ManagedBuildCoreTests.assertEquals((int)iTool.getNatureFilter(), (int)n5);
            ManagedBuildCoreTests.assertEquals((String)iTool.getOutputPrefix(), (String)string10);
            ManagedBuildCoreTests.assertTrue((boolean)Arrays.equals(iTool2.getOutputsAttribute(), objectArray2));
            ManagedBuildCoreTests.assertTrue((boolean)Arrays.equals(iTool2.getAllInputExtensions(), objectArray3));
            ManagedBuildCoreTests.assertEquals((String)iTool2.getOutputFlag(), (String)string11);
            ManagedBuildCoreTests.assertEquals((String)iTool2.getToolCommand(), (String)string12);
            ManagedBuildCoreTests.assertTrue((boolean)Arrays.equals(iTool2.getOutputsAttribute(), objectArray4));
            IOptionCategory[] iOptionCategoryArray = iTool2.getChildCategories();
            ManagedBuildCoreTests.assertEquals((String)iOptionCategoryArray[0].getId(), (String)string13);
            IOption iOption = iTool.getOptionById(string14);
            ManagedBuildCoreTests.assertTrue((boolean)iOption.isExtensionElement());
            String cfr_ignored_0 = (String)iOption.getDefaultValue();
            ManagedBuildCoreTests.assertEquals((int)iOption.getValueType(), (int)6);
            ManagedBuildCoreTests.assertEquals((String)iOption.getCommand(), (String)string17);
            ManagedBuildCoreTests.assertEquals((int)iOption.getBrowseType(), (int)1);
            iOption = iTool.getOptionById(string15);
            ManagedBuildCoreTests.assertTrue((boolean)iOption.isExtensionElement());
            String cfr_ignored_1 = (String)iOption.getDefaultValue();
            ManagedBuildCoreTests.assertEquals((int)iOption.getValueType(), (int)3);
            ManagedBuildCoreTests.assertEquals((String)iOption.getCommand(), (String)string18);
            ManagedBuildCoreTests.assertEquals((int)iOption.getBrowseType(), (int)2);
            iOption = iTool.getOptionById(string16);
            ManagedBuildCoreTests.assertTrue((boolean)iOption.isExtensionElement());
            String cfr_ignored_2 = (String)iOption.getDefaultValue();
            ManagedBuildCoreTests.assertEquals((int)iOption.getValueType(), (int)7);
            ManagedBuildCoreTests.assertEquals((int)iOption.getBrowseType(), (int)1);
            iOption = iTool.getOptionById(string19);
            ManagedBuildCoreTests.assertTrue((boolean)iOption.isExtensionElement());
            ManagedBuildCoreTests.assertEquals((int)iOption.getValueType(), (int)2);
            ManagedBuildCoreTests.assertEquals((String)iOption.getName(), (String)string20);
            ManagedBuildCoreTests.assertEquals((String)iOption.getCommand(), (String)string21);
            iOption = iTool.getOptionById(string22);
            ManagedBuildCoreTests.assertTrue((boolean)iOption.isExtensionElement());
            ManagedBuildCoreTests.assertEquals((int)iOption.getValueType(), (int)0);
            boolean bl3 = iOption.getBooleanValue();
            ManagedBuildCoreTests.assertEquals((boolean)bl3, (boolean)bl);
            ManagedBuildCoreTests.assertEquals((String)iOption.getName(), (String)string23);
            ManagedBuildCoreTests.assertEquals((String)iOption.getCommand(), (String)string24);
            iOption = iTool.getOptionById(string25);
            ManagedBuildCoreTests.assertTrue((boolean)iOption.isExtensionElement());
            ManagedBuildCoreTests.assertEquals((int)iOption.getValueType(), (int)0);
            boolean bl4 = iOption.getBooleanValue();
            ManagedBuildCoreTests.assertEquals((boolean)bl4, (boolean)bl2);
            ManagedBuildCoreTests.assertEquals((String)iOption.getName(), (String)string26);
            ManagedBuildCoreTests.assertEquals((String)iOption.getCommand(), (String)string27);
            ++n6;
        }
    }

    private void checkLibProjectType(IProjectType iProjectType) throws BuildException {
        int n = 2;
        String[] stringArray = new String[]{"Dbg", "Rel"};
        String string = "rm -rf";
        String string2 = "org.eclipse.cdt.core.MakeErrorParser;org.eclipse.cdt.core.GCCErrorParser;org.eclipse.cdt.core.GLDErrorParser;org.eclipse.cdt.core.GASErrorParser";
        String string3 = "a";
        String string4 = "solaris,linux,hpux,aix,qnx";
        int n2 = 5;
        Object[] objectArray = new String[]{"all"};
        String string5 = "org.eclipse.cdt.core.ELF";
        String[] stringArray2 = new String[]{"Dbg P", "Rel P"};
        String string6 = "make";
        String string7 = "-k";
        String[] stringArray3 = new String[]{"Dbg B", "Rel B"};
        String string8 = "org.eclipse.cdt.managedbuilder.core.GCCManagedMakePerProjectProfile";
        String[] stringArray4 = new String[]{"cdt.managedbuild.tool.testgnu.cpp.compiler.lib.debug", "cdt.managedbuild.tool.testgnu.cpp.compiler.lib.release"};
        String string9 = "cdt.managedbuild.tool.testgnu.cpp.compiler";
        String string10 = "-o";
        String string11 = "g++";
        Object[] objectArray2 = new String[]{"c", "C", "cc", "cxx", "cpp"};
        Object[] objectArray3 = new String[]{"h", "H", "hpp"};
        Object[] objectArray4 = new String[]{"o"};
        String string12 = "testgnu.cpp.compiler.category.preprocessor";
        String[] stringArray5 = new String[]{"testgnu.cpp.compiler.lib.debug.option.optimization.level", "testgnu.cpp.compiler.lib.release.option.optimization.level"};
        String[] stringArray6 = new String[]{"testgnu.cpp.compiler.optimization.level.none", "testgnu.cpp.compiler.optimization.level.most"};
        String string13 = "Posix.Optimize.None, Posix.Optimize.Optimize, Posix.Optimize.More, Posix.Optimize.Most";
        int n3 = 4;
        String[] stringArray7 = new String[]{"-O0", "-O3"};
        String string14 = "testgnu.cpp.compiler.option.other.other";
        String string15 = "OtherFlags";
        String string16 = "testgnu.cpp.compiler.option.other.verbose";
        String string17 = "Posix.Verbose";
        String string18 = "-v";
        boolean bl = false;
        int n4 = 4;
        int n5 = 1;
        int n6 = 1;
        ManagedBuildCoreTests.assertNotNull((Object)iProjectType);
        ManagedBuildCoreTests.assertTrue((boolean)iProjectType.isTestProjectType());
        ManagedBuildCoreTests.assertFalse((boolean)iProjectType.isAbstract());
        IConfiguration[] iConfigurationArray = iProjectType.getConfigurations();
        ManagedBuildCoreTests.assertNotNull((Object)iConfigurationArray);
        ManagedBuildCoreTests.assertEquals((int)n, (int)iConfigurationArray.length);
        int n7 = 0;
        while (n7 < iConfigurationArray.length) {
            ManagedBuildCoreTests.assertEquals((String)iConfigurationArray[n7].getName(), (String)stringArray[n7]);
            ManagedBuildCoreTests.assertEquals((String)string, (String)iConfigurationArray[n7].getCleanCommand());
            ManagedBuildCoreTests.assertEquals((String)string2, (String)iConfigurationArray[n7].getErrorParserIds());
            ManagedBuildCoreTests.assertEquals((String)iConfigurationArray[n7].getArtifactExtension(), (String)string3);
            IToolChain iToolChain = iConfigurationArray[n7].getToolChain();
            ArrayList<String> arrayList = new ArrayList<String>();
            String[] stringArray8 = string4.split(",");
            int n8 = 0;
            while (n8 < stringArray8.length) {
                arrayList.add(stringArray8[n8].trim());
                ++n8;
            }
            ManagedBuildCoreTests.assertEquals((String)string2, (String)iConfigurationArray[n7].getErrorParserIds());
            ManagedBuildCoreTests.assertTrue((boolean)Arrays.equals(iToolChain.getOSList(), arrayList.toArray(new String[n2])));
            ManagedBuildCoreTests.assertTrue((boolean)Arrays.equals(iToolChain.getArchList(), objectArray));
            ManagedBuildCoreTests.assertEquals((String)string8, (String)iToolChain.getScannerConfigDiscoveryProfileId());
            ITargetPlatform iTargetPlatform = iToolChain.getTargetPlatform();
            ManagedBuildCoreTests.assertTrue((boolean)Arrays.equals(iTargetPlatform.getOSList(), arrayList.toArray(new String[n2])));
            ManagedBuildCoreTests.assertTrue((boolean)Arrays.equals(iTargetPlatform.getArchList(), objectArray));
            String[] stringArray9 = iTargetPlatform.getBinaryParserList();
            ManagedBuildCoreTests.assertEquals((int)stringArray9.length, (int)1);
            ManagedBuildCoreTests.assertEquals((String)stringArray9[0], (String)string5);
            ManagedBuildCoreTests.assertEquals((String)iTargetPlatform.getName(), (String)stringArray2[n7]);
            IBuilder iBuilder = iToolChain.getBuilder();
            ManagedBuildCoreTests.assertEquals((String)iBuilder.getCommand(), (String)string6);
            ManagedBuildCoreTests.assertEquals((String)iBuilder.getArguments(), (String)string7);
            ManagedBuildCoreTests.assertEquals((String)iBuilder.getName(), (String)stringArray3[n7]);
            ITool[] iToolArray = iToolChain.getTools();
            ManagedBuildCoreTests.assertEquals((int)iToolArray.length, (int)n4);
            ITool iTool = iToolArray[n5];
            ITool iTool2 = iTool.getSuperClass();
            ManagedBuildCoreTests.assertEquals((String)iTool.getId(), (String)stringArray4[n7]);
            ManagedBuildCoreTests.assertEquals((String)iTool2.getId(), (String)string9);
            ManagedBuildCoreTests.assertEquals((int)iTool.getNatureFilter(), (int)n6);
            ManagedBuildCoreTests.assertTrue((boolean)Arrays.equals(iTool2.getAllInputExtensions(), objectArray2));
            ManagedBuildCoreTests.assertEquals((String)iTool2.getOutputFlag(), (String)string10);
            ManagedBuildCoreTests.assertEquals((String)iTool2.getToolCommand(), (String)string11);
            ManagedBuildCoreTests.assertTrue((boolean)Arrays.equals(iTool2.getAllDependencyExtensions(), objectArray3));
            ManagedBuildCoreTests.assertTrue((boolean)Arrays.equals(iTool2.getOutputsAttribute(), objectArray4));
            IOptionCategory[] iOptionCategoryArray = iTool2.getChildCategories();
            ManagedBuildCoreTests.assertEquals((String)iOptionCategoryArray[0].getId(), (String)string12);
            IOption iOption = iTool.getOptionById(stringArray5[n7]);
            ManagedBuildCoreTests.assertTrue((boolean)iOption.isExtensionElement());
            String string19 = (String)iOption.getDefaultValue();
            ManagedBuildCoreTests.assertEquals((int)iOption.getValueType(), (int)1);
            ManagedBuildCoreTests.assertEquals((String)string19, (String)stringArray6[n7]);
            String string20 = iOption.getEnumCommand(string19);
            ManagedBuildCoreTests.assertEquals((String)string20, (String)stringArray7[n7]);
            ArrayList<String> arrayList2 = new ArrayList<String>();
            iOption.getApplicableValues();
            String[] stringArray10 = string13.split(",");
            n8 = 0;
            while (n8 < stringArray10.length) {
                arrayList2.add(stringArray10[n8].trim());
                ++n8;
            }
            ManagedBuildCoreTests.assertTrue((boolean)Arrays.equals(iOption.getApplicableValues(), arrayList2.toArray(new String[n3])));
            iOption = iTool.getOptionById(string14);
            ManagedBuildCoreTests.assertTrue((boolean)iOption.isExtensionElement());
            ManagedBuildCoreTests.assertEquals((int)iOption.getValueType(), (int)2);
            ManagedBuildCoreTests.assertEquals((String)iOption.getName(), (String)string15);
            iOption = iTool.getOptionById(string16);
            ManagedBuildCoreTests.assertTrue((boolean)iOption.isExtensionElement());
            ManagedBuildCoreTests.assertEquals((int)iOption.getValueType(), (int)0);
            boolean bl2 = iOption.getBooleanValue();
            ManagedBuildCoreTests.assertEquals((boolean)bl2, (boolean)bl);
            ManagedBuildCoreTests.assertEquals((String)iOption.getName(), (String)string17);
            ManagedBuildCoreTests.assertEquals((String)iOption.getCommand(), (String)string18);
            ++n7;
        }
    }
}

