/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.core.tests;

import java.net.URL;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedOptionValueHandler;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.core.ManagedCProjectNature;
import org.eclipse.cdt.managedbuilder.core.ManagedOptionValueHandler;
import org.eclipse.cdt.managedbuilder.core.tests.TestValueHandler;
import org.eclipse.cdt.managedbuilder.testplugin.CTestPlugin;
import org.eclipse.cdt.managedbuilder.testplugin.ManagedBuildTestHelper;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class ManagedBuildCoreTests_SharedToolOptions
extends TestCase {
    private final String projectName = "test30_sto";
    private final String projectID = "test30_sto.dummy";
    private final String configID = "test30_sto.dummy.config";
    private final String configName = "Configuration for test30_sto";
    private boolean testExtensionElements = true;
    private boolean testIsSetup = false;
    private IProjectType testProject;
    private IConfiguration testConfig;
    private IToolChain testToolChain;
    private ITool[] testTools;
    private IOptionCategory[] testCategoryTop;
    private IOption[] testOptionTop;
    private Object[][] testCategory;
    private Object[][] testOption;
    private IconComparator iconComparator = new IconComparator();
    private ValueHandlerComparator valueHandlerComparator = new ValueHandlerComparator();
    static /* synthetic */ Class class$0;

    public ManagedBuildCoreTests_SharedToolOptions(String string) {
        super(string);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.managedbuilder.core.tests.ManagedBuildCoreTests_SharedToolOptions");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite testSuite = new TestSuite(clazz.getName());
        testSuite.addTest((Test)new ManagedBuildCoreTests_SharedToolOptions("testIcons"));
        testSuite.addTest((Test)new ManagedBuildCoreTests_SharedToolOptions("testValueHandlers"));
        testSuite.addTest((Test)new ManagedBuildCoreTests_SharedToolOptions("testOptions"));
        testSuite.addTest((Test)new ManagedBuildCoreTests_SharedToolOptions("testConfiguration"));
        return testSuite;
    }

    private void assertCorrectId(String string, String string2) {
        if (this.testExtensionElements) {
            ManagedBuildCoreTests_SharedToolOptions.assertTrue((boolean)string.equals(string2));
        } else {
            ManagedBuildCoreTests_SharedToolOptions.assertTrue((boolean)string.startsWith(String.valueOf(string2) + "."));
        }
    }

    private IProject createProject(String string) throws CoreException {
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        final IProject iProject = iWorkspaceRoot.getProject(string);
        IProject iProject2 = null;
        if (!iProject.exists()) {
            IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
            IWorkspaceDescription iWorkspaceDescription = iWorkspace.getDescription();
            iWorkspaceDescription.setAutoBuilding(false);
            iWorkspace.setDescription(iWorkspaceDescription);
            IProjectDescription iProjectDescription = iWorkspace.newProjectDescription(iProject.getName());
            iProject2 = CCorePlugin.getDefault().createCProject(iProjectDescription, iProject, (IProgressMonitor)new NullProgressMonitor(), ManagedBuilderCorePlugin.MANAGED_MAKE_PROJECT_ID);
        } else {
            IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                    iProject.refreshLocal(2, iProgressMonitor);
                }
            };
            NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
            iWorkspace.run(iWorkspaceRunnable, (ISchedulingRule)iWorkspaceRoot, 1, (IProgressMonitor)nullProgressMonitor);
            iProject2 = iProject;
        }
        if (!iProject2.isOpen()) {
            iProject2.open((IProgressMonitor)new NullProgressMonitor());
        }
        return iProject2;
    }

    private void setupDefaultProject() throws Exception {
        this.testExtensionElements = true;
        this.testProject = ManagedBuildManager.getProjectType((String)"test30_sto.dummy");
        ManagedBuildCoreTests_SharedToolOptions.assertNotNull((Object)this.testProject);
        ManagedBuildCoreTests_SharedToolOptions.assertTrue((boolean)this.testProject.isTestProjectType());
        ManagedBuildCoreTests_SharedToolOptions.assertFalse((boolean)this.testProject.isAbstract());
        this.setupConfiguration();
        ManagedBuildCoreTests_SharedToolOptions.assertTrue((boolean)this.testConfig.isExtensionElement());
    }

    private void setupConfiguration() throws Exception {
        IConfiguration[] iConfigurationArray = this.testProject.getConfigurations();
        ManagedBuildCoreTests_SharedToolOptions.assertNotNull((Object)iConfigurationArray);
        ManagedBuildCoreTests_SharedToolOptions.assertEquals((int)iConfigurationArray.length, (int)1);
        this.testConfig = iConfigurationArray[0];
        ManagedBuildCoreTests_SharedToolOptions.assertEquals((String)this.testConfig.getId(), (String)"test30_sto.dummy.config");
        ManagedBuildCoreTests_SharedToolOptions.assertEquals((String)this.testConfig.getName(), (String)"Configuration for test30_sto");
    }

    private void setupProject() throws Exception {
        IProjectDescription iProjectDescription;
        this.testExtensionElements = false;
        IProject iProject = null;
        try {
            iProject = this.createProject("test30_sto");
            ManagedBuildTestHelper.addManagedBuildNature(iProject);
            iProjectDescription = iProject.getDescription();
            if (iProjectDescription != null) {
                ManagedBuildCoreTests_SharedToolOptions.assertTrue((boolean)iProjectDescription.hasNature(ManagedCProjectNature.MNG_NATURE_ID));
            }
        }
        catch (CoreException coreException) {
            ManagedBuildCoreTests_SharedToolOptions.fail((String)("Test failed on project creation: " + coreException.getLocalizedMessage()));
        }
        ManagedBuildManager.getDefinedProjectTypes();
        iProjectDescription = ManagedBuildManager.getProjectType((String)"test30_sto.dummy");
        ManagedBuildCoreTests_SharedToolOptions.assertNotNull((Object)iProjectDescription);
        IManagedProject iManagedProject = ManagedBuildManager.createManagedProject((IResource)iProject, (IProjectType)iProjectDescription);
        ManagedBuildCoreTests_SharedToolOptions.assertEquals((String)iManagedProject.getName(), (String)iProjectDescription.getName());
        ManagedBuildCoreTests_SharedToolOptions.assertFalse((boolean)iManagedProject.equals(iProjectDescription));
        ManagedBuildManager.setNewProjectVersion((IProject)iProject);
        this.testProject = iManagedProject.getProjectType();
        IConfiguration iConfiguration = this.testProject.getConfiguration("test30_sto.dummy.config");
        this.testConfig = iManagedProject.createConfiguration(iConfiguration, "test30_sto.dummy.config.12345678");
    }

    private void setupTestEnvironment() throws Exception {
        String string = "test30_sto.dummy.toolchain";
        String string2 = "Toolchain for test30_sto";
        int n = 4;
        String string3 = "test30_sto.dummy.tool.";
        int n2 = 1;
        String string4 = "test30_sto.dummy.category.";
        int n3 = 5;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        this.testToolChain = this.testConfig.getToolChain();
        ManagedBuildCoreTests_SharedToolOptions.assertNotNull((Object)this.testToolChain);
        ManagedBuildCoreTests_SharedToolOptions.assertEquals((String)this.testToolChain.getName(), (String)string2);
        this.assertCorrectId(this.testToolChain.getId(), string);
        this.testTools = this.testToolChain.getTools();
        ManagedBuildCoreTests_SharedToolOptions.assertNotNull((Object)this.testTools);
        ManagedBuildCoreTests_SharedToolOptions.assertEquals((int)this.testTools.length, (int)n);
        int n7 = n2;
        n6 = n;
        int n8 = 0;
        while (n8 < n6) {
            this.assertCorrectId(this.testTools[n8].getId(), String.valueOf(string3) + n7);
            ++n7;
            ++n8;
        }
        this.testCategoryTop = this.testToolChain.getChildCategories();
        this.testOptionTop = this.testToolChain.getOptions();
        if (this.testCategoryTop != null) {
            int n9 = n3;
            n4 = this.testCategoryTop.length;
            n8 = 0;
            while (n8 < n4) {
                String string5 = this.testCategoryTop[n8].getId();
                ManagedBuildCoreTests_SharedToolOptions.assertEquals((String)string5, (String)(String.valueOf(string4) + n9));
                ++n8;
                ++n9;
            }
        }
        if (this.testOptionTop != null) {
            n5 = this.testOptionTop.length;
        }
        this.testCategory = new Object[this.testTools.length + n4][];
        this.testOption = new Object[this.testTools.length + n5][];
        n8 = 0;
        while (n8 < n6) {
            this.testCategory[n8] = this.testTools[n8].getChildCategories();
            this.testOption[n8] = this.testTools[n8].getOptions();
            if (this.testCategory[n8] == null) {
                this.testCategory[n8] = new Object[0];
            }
            if (this.testOption[n8] == null) {
                this.testOption[n8] = new Object[0];
            }
            ++n8;
        }
        n8 = 0;
        while (n8 < n4) {
            this.testCategory[n6 + n8] = new Object[1];
            this.testCategory[n6 + n8][0] = this.testCategoryTop[n8];
            ++n8;
        }
        n8 = 0;
        while (n8 < n5) {
            this.testOption[n6 + n8] = new Object[1];
            this.testOption[n6 + n8][0] = this.testOptionTop[n8];
            ++n8;
        }
    }

    public void testIcons() throws Exception {
        if (!this.testIsSetup) {
            this.setupDefaultProject();
            this.setupTestEnvironment();
        }
        CTestPlugin cTestPlugin = CTestPlugin.getDefault();
        URL uRL = Platform.asLocalURL((URL)cTestPlugin.find((IPath)new Path("icons/one.gif"), null));
        URL uRL2 = Platform.asLocalURL((URL)cTestPlugin.find((IPath)new Path("icons/two.gif"), null));
        this.assertToolIcon(this.testTools[0], uRL);
        this.assertToolIcon(this.testTools[1], null);
        this.assertToolIcon(this.testTools[2], uRL2);
        int n = 0;
        while (n < this.testCategory.length) {
            int n2 = 0;
            while (n2 < this.testCategory[n].length) {
                URL uRL3 = ((IOptionCategory)this.testCategory[n][n2]).getIconPath();
                switch (this.iconComparator.Compare(n + 1, n2 + 1)) {
                    case 0: {
                        ManagedBuildCoreTests_SharedToolOptions.assertEquals((Object)uRL3, null);
                        break;
                    }
                    case 1: {
                        ManagedBuildCoreTests_SharedToolOptions.assertEquals((Object)uRL3, (Object)uRL);
                        break;
                    }
                    case 2: {
                        ManagedBuildCoreTests_SharedToolOptions.assertEquals((Object)uRL3, (Object)uRL2);
                    }
                }
                ++n2;
            }
            ++n;
        }
    }

    private void assertToolIcon(ITool iTool, URL uRL) {
        ManagedBuildCoreTests_SharedToolOptions.assertTrue((boolean)(iTool instanceof IOptionCategory));
        IOptionCategory iOptionCategory = (IOptionCategory)iTool;
        ManagedBuildCoreTests_SharedToolOptions.assertEquals((Object)iOptionCategory.getIconPath(), (Object)uRL);
    }

    public void testValueHandlers() throws Exception {
        if (!this.testIsSetup) {
            this.setupDefaultProject();
            this.setupTestEnvironment();
        }
        int n = 0;
        while (n < this.testOption.length) {
            int n2 = 0;
            while (n2 < this.testOption[n].length) {
                IOption iOption = (IOption)this.testOption[n][n2];
                IManagedOptionValueHandler iManagedOptionValueHandler = iOption.getValueHandler();
                String string = iOption.getValueHandlerExtraArgument();
                switch (this.valueHandlerComparator.Compare(n + 1, n2 + 1)) {
                    case 0: {
                        ManagedBuildCoreTests_SharedToolOptions.assertEquals((Object)ManagedOptionValueHandler.getManagedOptionValueHandler(), (Object)iManagedOptionValueHandler);
                        break;
                    }
                    case 1: {
                        ManagedBuildCoreTests_SharedToolOptions.assertTrue((boolean)(iManagedOptionValueHandler instanceof TestValueHandler));
                        ManagedBuildCoreTests_SharedToolOptions.assertEquals((String)this.valueHandlerComparator.getArg(), (String)string);
                    }
                }
                ++n2;
            }
            ++n;
        }
    }

    public void testOptions() throws Exception {
        if (!this.testIsSetup) {
            this.setupDefaultProject();
            this.setupTestEnvironment();
        }
        int n = 0;
        while (n < this.testCategory.length) {
            int n2 = 0;
            while (n2 < this.testCategory[n].length) {
                Object[][] objectArray = ((IOptionCategory)this.testCategory[n][n2]).getOptions(this.testConfig);
                int n3 = 0;
                while (n3 < objectArray[0].length) {
                    if (objectArray[n3][0] == null) {
                        ManagedBuildCoreTests_SharedToolOptions.assertNull((Object)objectArray[n3][1]);
                        break;
                    }
                    switch (n) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: {
                            ManagedBuildCoreTests_SharedToolOptions.assertTrue((boolean)(objectArray[n3][0] instanceof ITool));
                            ManagedBuildCoreTests_SharedToolOptions.assertEquals((Object)objectArray[n3][0], (Object)this.testTools[n]);
                            break;
                        }
                        default: {
                            ManagedBuildCoreTests_SharedToolOptions.assertTrue((boolean)(objectArray[n3][0] instanceof IToolChain));
                            ManagedBuildCoreTests_SharedToolOptions.assertEquals((Object)objectArray[n3][0], (Object)this.testToolChain);
                        }
                    }
                    boolean bl = false;
                    int n4 = 0;
                    while (n4 < this.testOption[n].length) {
                        if (this.testOption[n][n4] == objectArray[n3][1]) {
                            bl = true;
                            break;
                        }
                        ++n4;
                    }
                    ManagedBuildCoreTests_SharedToolOptions.assertTrue((boolean)bl);
                    ManagedBuildCoreTests_SharedToolOptions.assertEquals((Object)((IOption)objectArray[n3][1]).getCategory(), (Object)this.testCategory[n][n2]);
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
    }

    public void testConfiguration() throws Exception {
        this.setupProject();
        this.setupTestEnvironment();
        this.testIsSetup = true;
        this.testIcons();
        this.testValueHandlers();
        this.testOptions();
    }

    class IconComparator {
        static final int None = 0;
        static final int One = 1;
        static final int Two = 2;
        int[] One_i = new int[]{3, 2, 4, 7};
        int[] One_j = new int[]{1, 2, 1, 1};
        int[] Two_i = new int[]{2, 6};
        int[] Two_j = new int[]{1, 1};

        IconComparator() {
            ManagedBuildCoreTests_SharedToolOptions.assertEquals((int)this.One_i.length, (int)this.One_j.length);
            ManagedBuildCoreTests_SharedToolOptions.assertEquals((int)this.Two_i.length, (int)this.Two_j.length);
        }

        int Compare(int n, int n2) {
            int n3 = 0;
            while (n3 < this.One_i.length) {
                if (n == this.One_i[n3] && n2 == this.One_j[n3]) {
                    return 1;
                }
                ++n3;
            }
            n3 = 0;
            while (n3 < this.Two_i.length) {
                if (n == this.Two_i[n3] && n2 == this.Two_j[n3]) {
                    return 2;
                }
                ++n3;
            }
            return 0;
        }
    }

    class ValueHandlerComparator {
        static final int MBS = 0;
        static final int TEST = 1;
        int[] Test_i = new int[]{2, 2, 3, 5, 7};
        int[] Test_j = new int[]{1, 4, 2, 1, 1};
        String[] Test_arg = new String[]{"Option2.1.1", "Option2.2.2", "Option3.1.2", "Option5.1", "Option7.1"};
        String last_arg;

        ValueHandlerComparator() {
            ManagedBuildCoreTests_SharedToolOptions.assertEquals((int)this.Test_i.length, (int)this.Test_j.length);
            ManagedBuildCoreTests_SharedToolOptions.assertEquals((int)this.Test_i.length, (int)this.Test_arg.length);
            this.last_arg = "";
        }

        int Compare(int n, int n2) {
            int n3 = 0;
            while (n3 < this.Test_i.length) {
                if (n == this.Test_i[n3] && n2 == this.Test_j[n3]) {
                    this.last_arg = this.Test_arg[n3];
                    return 1;
                }
                ++n3;
            }
            this.last_arg = "";
            return 0;
        }

        String getArg() {
            return this.last_arg;
        }
    }
}

