/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.core.tests;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.projectconverter.UpdateManagedProjectManager;
import org.eclipse.cdt.managedbuilder.testplugin.CTestPlugin;
import org.eclipse.cdt.managedbuilder.testplugin.ManagedBuildTestHelper;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.dialogs.IOverwriteQuery;

public class ManagedBuildDependencyCalculatorTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public ManagedBuildDependencyCalculatorTests(String string) {
        super(string);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.managedbuilder.core.tests.ManagedBuildDependencyCalculatorTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite testSuite = new TestSuite(clazz.getName());
        testSuite.addTest((Test)new ManagedBuildDependencyCalculatorTests("test1DepCalc2"));
        testSuite.addTest((Test)new ManagedBuildDependencyCalculatorTests("test1DepCalc3"));
        testSuite.addTest((Test)new ManagedBuildDependencyCalculatorTests("test1DepCalcPreBuild"));
        return testSuite;
    }

    private IProject[] createProject(String string, IPath iPath, String string2, boolean bl) {
        ArrayList<IProject> arrayList = null;
        if (bl) {
            File file = CTestPlugin.getFileInPlugin((IPath)new Path("resources/depCalcProjects/" + string));
            if (file == null) {
                ManagedBuildDependencyCalculatorTests.fail((String)("Test project directory " + string + " is missing."));
                return null;
            }
            File[] fileArray = file.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return !file.isDirectory();
                }
            });
            arrayList = new ArrayList(fileArray.length);
            int n = 0;
            while (n < fileArray.length) {
                try {
                    IProject iProject;
                    String string3 = fileArray[n].getName();
                    if (string3.endsWith(".zip") && (string3 = string3.substring(0, string3.length() - ".zip".length())).length() != 0 && (iProject = ManagedBuildTestHelper.createProject(string3, fileArray[n], iPath, string2)) != null) {
                        arrayList.add(iProject);
                    }
                }
                catch (Exception exception) {}
                ++n;
            }
            if (arrayList.size() == 0) {
                ManagedBuildDependencyCalculatorTests.fail((String)("No projects found in test project directory " + file.getName() + ".  The .zip file may be missing or corrupt."));
                return null;
            }
        } else {
            try {
                IProject iProject = ManagedBuildTestHelper.createProject(string, null, iPath, string2);
                if (iProject != null) {
                    arrayList = new ArrayList<IProject>(1);
                }
                arrayList.add(iProject);
            }
            catch (Exception exception) {}
        }
        return arrayList.toArray(new IProject[arrayList.size()]);
    }

    private IProject[] createProjects(String string, IPath iPath, String string2, boolean bl) {
        IOverwriteQuery iOverwriteQuery = new IOverwriteQuery(){

            public String queryOverwrite(String string) {
                return "ALL";
            }
        };
        new IOverwriteQuery(){

            public String queryOverwrite(String string) {
                return "NOALL";
            }
        };
        UpdateManagedProjectManager.setBackupFileOverwriteQuery((IOverwriteQuery)iOverwriteQuery);
        UpdateManagedProjectManager.setUpdateProjectQuery((IOverwriteQuery)iOverwriteQuery);
        IProject[] iProjectArray = this.createProject(string, iPath, string2, bl);
        return iProjectArray;
    }

    private void buildProjectsWorker(IProject[] iProjectArray, IPath[] iPathArray, boolean bl) {
        if (iProjectArray == null || iProjectArray.length == 0) {
            return;
        }
        boolean bl2 = true;
        int n = 0;
        while (n < iProjectArray.length) {
            IProject iProject = iProjectArray[n];
            IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
            boolean bl3 = UpdateManagedProjectManager.isCompatibleProject((IManagedBuildInfo)iManagedBuildInfo);
            ManagedBuildDependencyCalculatorTests.assertTrue((boolean)bl3);
            if (bl3) {
                try {
                    iProject.build(10, null);
                }
                catch (CoreException coreException) {
                    ManagedBuildDependencyCalculatorTests.fail((String)coreException.getStatus().getMessage());
                }
                catch (OperationCanceledException operationCanceledException) {
                    ManagedBuildDependencyCalculatorTests.fail((String)("the project \"" + iProject.getName() + "\" build was cancelled, exception message: " + operationCanceledException.getMessage()));
                }
                if (iPathArray != null && iPathArray.length > 0 && n == 0) {
                    String string = iManagedBuildInfo.getDefaultConfiguration().getName();
                    IPath iPath = Path.fromOSString((String)string);
                    bl2 = bl ? ManagedBuildTestHelper.compareBenchmarks(iProject, iPath, iPathArray) : ManagedBuildTestHelper.verifyFilesDoNotExist(iProject, iPath, iPathArray);
                }
            }
            ++n;
        }
        if (bl2) {
            n = 0;
            while (n < iProjectArray.length) {
                ManagedBuildTestHelper.removeProject(iProjectArray[n].getName());
                ++n;
            }
        }
    }

    private void buildProjects(IProject[] iProjectArray, IPath[] iPathArray) {
        this.buildProjectsWorker(iProjectArray, iPathArray, true);
    }

    public void test1DepCalc2() {
        IPath[] iPathArray = new IPath[]{Path.fromOSString((String)"makefile"), Path.fromOSString((String)"objects.mk"), Path.fromOSString((String)"sources.mk"), Path.fromOSString((String)"subdir.mk"), Path.fromOSString((String)"Sources/subdir.mk"), Path.fromOSString((String)"Sources/func1.d"), Path.fromOSString((String)"Sources/func2.d"), Path.fromOSString((String)"Sources/func4.d"), Path.fromOSString((String)"Sources/sub sources/func 3.d"), Path.fromOSString((String)"Sources/sub sources/subdir.mk")};
        IProject[] iProjectArray = this.createProjects("test1DepCalc2", null, null, true);
        this.buildProjects(iProjectArray, iPathArray);
    }

    public void test1DepCalc3() {
        IPath[] iPathArray = new IPath[]{Path.fromOSString((String)"makefile"), Path.fromOSString((String)"objects.mk"), Path.fromOSString((String)"sources.mk"), Path.fromOSString((String)"subdir.mk"), Path.fromOSString((String)"Sources/subdir.mk"), Path.fromOSString((String)"Sources/func1.d"), Path.fromOSString((String)"Sources/func2.d"), Path.fromOSString((String)"Sources/func4.d"), Path.fromOSString((String)"Sources/sub sources/func 3.d"), Path.fromOSString((String)"Sources/sub sources/subdir.mk")};
        IProject[] iProjectArray = this.createProjects("test1DepCalc3", null, null, true);
        this.buildProjects(iProjectArray, iPathArray);
    }

    public void test1DepCalcPreBuild() {
        IPath[] iPathArray = new IPath[]{Path.fromOSString((String)"makefile"), Path.fromOSString((String)"objects.mk"), Path.fromOSString((String)"sources.mk"), Path.fromOSString((String)"subdir.mk"), Path.fromOSString((String)"Sources/subdir.mk"), Path.fromOSString((String)"Sources/func1.d"), Path.fromOSString((String)"Sources/func2.d"), Path.fromOSString((String)"Sources/func4.d"), Path.fromOSString((String)"Sources/sub sources/func 3.d"), Path.fromOSString((String)"Sources/sub sources/subdir.mk")};
        IProject[] iProjectArray = this.createProjects("test1DepCalcPreBuild", null, null, true);
        this.buildProjects(iProjectArray, iPathArray);
    }
}

