/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.core.tests;

import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineInfo;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.makegen.IManagedBuilderMakefileGenerator;
import org.eclipse.cdt.managedbuilder.testplugin.ManagedBuildTestHelper;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class ManagedCommandLineGeneratorTest
extends TestCase {
    private static String[] testCommandLinePatterns;
    private static String COMMAND_VAL;
    private static String FLAGS_VAL;
    private static String[] FLAGS_ARRAY_VAL;
    private static String OUTPUT_FLAG_VAL;
    private static String OUTPUT_PREFIX_VAL;
    private static String OUTPUT_VAL;
    private static String INPUTS_VAL;
    private static String[] INPUTS_ARRAY_VAL;
    private static String[] commandLineEtalonesForPatterns;
    private static String[] commandLineEtalonesForParameters;
    static /* synthetic */ Class class$0;

    static {
        String[] stringArray = new String[8];
        stringArray[1] = "${COMMAND}";
        stringArray[2] = "${COMMAND} ${FLAGS}";
        stringArray[3] = "${COMMAND} ${FLAGS} ${OUTPUT_FLAG}";
        stringArray[4] = "${COMMAND} ${FLAGS} ${OUTPUT_FLAG}${OUTPUT_PREFIX}";
        stringArray[5] = "${COMMAND} ${FLAGS} ${OUTPUT_FLAG}${OUTPUT_PREFIX}${OUTPUT}";
        stringArray[6] = "${COMMAND} ${FLAGS} ${OUTPUT_FLAG}${OUTPUT_PREFIX}${OUTPUT} ${INPUTS}";
        stringArray[7] = "${command} ${flags} ${output_flag}${output_prefix}${output} ${WRONG_VAR_NAME}";
        testCommandLinePatterns = stringArray;
        COMMAND_VAL = "[command]";
        FLAGS_VAL = "[flags]";
        FLAGS_ARRAY_VAL = FLAGS_VAL.split("\\s");
        OUTPUT_FLAG_VAL = "[outputFlag]";
        OUTPUT_PREFIX_VAL = "[outputPrefix]";
        OUTPUT_VAL = "[output]";
        INPUTS_VAL = "[inputs]";
        INPUTS_ARRAY_VAL = INPUTS_VAL.split("\\s");
        commandLineEtalonesForPatterns = new String[]{String.valueOf(COMMAND_VAL) + " " + FLAGS_VAL + " " + OUTPUT_FLAG_VAL + OUTPUT_PREFIX_VAL + "\"" + OUTPUT_VAL + "\"" + " " + "\"" + INPUTS_VAL + "\"", COMMAND_VAL, String.valueOf(COMMAND_VAL) + " " + FLAGS_VAL, String.valueOf(COMMAND_VAL) + " " + FLAGS_VAL + " " + OUTPUT_FLAG_VAL, String.valueOf(COMMAND_VAL) + " " + FLAGS_VAL + " " + OUTPUT_FLAG_VAL + OUTPUT_PREFIX_VAL, String.valueOf(COMMAND_VAL) + " " + FLAGS_VAL + " " + OUTPUT_FLAG_VAL + OUTPUT_PREFIX_VAL + "\"" + OUTPUT_VAL + "\"", String.valueOf(COMMAND_VAL) + " " + FLAGS_VAL + " " + OUTPUT_FLAG_VAL + OUTPUT_PREFIX_VAL + "\"" + OUTPUT_VAL + "\"" + " " + "\"" + INPUTS_VAL + "\"", String.valueOf(COMMAND_VAL) + " " + FLAGS_VAL + " " + OUTPUT_FLAG_VAL + OUTPUT_PREFIX_VAL + "\"" + OUTPUT_VAL + "\"" + " " + "${WRONG_VAR_NAME}"};
        commandLineEtalonesForParameters = new String[]{String.valueOf(FLAGS_VAL) + " " + OUTPUT_FLAG_VAL + OUTPUT_PREFIX_VAL + OUTPUT_VAL + " " + INPUTS_VAL, String.valueOf(COMMAND_VAL) + "  " + OUTPUT_FLAG_VAL + OUTPUT_PREFIX_VAL + OUTPUT_VAL + " " + INPUTS_VAL, String.valueOf(COMMAND_VAL) + " " + FLAGS_VAL + " " + OUTPUT_PREFIX_VAL + OUTPUT_VAL + " " + INPUTS_VAL, String.valueOf(COMMAND_VAL) + " " + FLAGS_VAL + " " + OUTPUT_FLAG_VAL + OUTPUT_VAL + " " + INPUTS_VAL, String.valueOf(COMMAND_VAL) + " " + FLAGS_VAL + " " + OUTPUT_FLAG_VAL + OUTPUT_PREFIX_VAL + " " + INPUTS_VAL, String.valueOf(COMMAND_VAL) + " " + FLAGS_VAL + " " + OUTPUT_FLAG_VAL + OUTPUT_PREFIX_VAL + OUTPUT_VAL + " "};
    }

    public ManagedCommandLineGeneratorTest(String string) {
        super(string);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.managedbuilder.core.tests.ManagedCommandLineGeneratorTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite testSuite = new TestSuite(clazz.getName());
        testSuite.addTest((Test)new ManagedCommandLineGeneratorTest("testGetCommandLineGenerator"));
        testSuite.addTest((Test)new ManagedCommandLineGeneratorTest("testGenerateCommandLineInfoPatterns"));
        testSuite.addTest((Test)new ManagedCommandLineGeneratorTest("testCustomGenerator"));
        testSuite.addTest((Test)new ManagedCommandLineGeneratorTest("testDollarValue"));
        return testSuite;
    }

    public final void testGetCommandLineGenerator() {
        ManagedCommandLineGenerator managedCommandLineGenerator = ManagedCommandLineGenerator.getCommandLineGenerator();
        ManagedCommandLineGeneratorTest.assertNotNull((Object)managedCommandLineGenerator);
    }

    public final void testGenerateCommandLineInfoPatterns() {
        ManagedCommandLineGenerator managedCommandLineGenerator = ManagedCommandLineGenerator.getCommandLineGenerator();
        IManagedCommandLineInfo iManagedCommandLineInfo = null;
        int n = 0;
        while (n < testCommandLinePatterns.length) {
            iManagedCommandLineInfo = managedCommandLineGenerator.generateCommandLineInfo(null, COMMAND_VAL, FLAGS_ARRAY_VAL, OUTPUT_FLAG_VAL, OUTPUT_PREFIX_VAL, OUTPUT_VAL, INPUTS_ARRAY_VAL, testCommandLinePatterns[n]);
            ManagedCommandLineGeneratorTest.assertNotNull((Object)iManagedCommandLineInfo);
            if (n < commandLineEtalonesForPatterns.length) {
                ManagedCommandLineGeneratorTest.assertEquals((String)iManagedCommandLineInfo.getCommandLine(), (String)commandLineEtalonesForPatterns[n]);
            }
            ++n;
        }
    }

    public final void testGenerateCommandLineInfoParameters() {
        ManagedCommandLineGenerator managedCommandLineGenerator = ManagedCommandLineGenerator.getCommandLineGenerator();
        IManagedCommandLineInfo iManagedCommandLineInfo = managedCommandLineGenerator.generateCommandLineInfo(null, null, FLAGS_ARRAY_VAL, OUTPUT_FLAG_VAL, OUTPUT_PREFIX_VAL, OUTPUT_VAL, INPUTS_ARRAY_VAL, null);
        ManagedCommandLineGeneratorTest.assertNotNull((Object)iManagedCommandLineInfo);
        ManagedCommandLineGeneratorTest.assertEquals((String)iManagedCommandLineInfo.getCommandLine(), (String)commandLineEtalonesForParameters[0]);
        iManagedCommandLineInfo = managedCommandLineGenerator.generateCommandLineInfo(null, COMMAND_VAL, null, OUTPUT_FLAG_VAL, OUTPUT_PREFIX_VAL, OUTPUT_VAL, INPUTS_ARRAY_VAL, null);
        ManagedCommandLineGeneratorTest.assertNotNull((Object)iManagedCommandLineInfo);
        ManagedCommandLineGeneratorTest.assertEquals((String)iManagedCommandLineInfo.getCommandLine(), (String)commandLineEtalonesForParameters[1]);
        iManagedCommandLineInfo = managedCommandLineGenerator.generateCommandLineInfo(null, COMMAND_VAL, FLAGS_ARRAY_VAL, null, OUTPUT_PREFIX_VAL, OUTPUT_VAL, INPUTS_ARRAY_VAL, null);
        ManagedCommandLineGeneratorTest.assertNotNull((Object)iManagedCommandLineInfo);
        ManagedCommandLineGeneratorTest.assertEquals((String)iManagedCommandLineInfo.getCommandLine(), (String)commandLineEtalonesForParameters[2]);
        iManagedCommandLineInfo = managedCommandLineGenerator.generateCommandLineInfo(null, COMMAND_VAL, FLAGS_ARRAY_VAL, OUTPUT_FLAG_VAL, null, OUTPUT_VAL, INPUTS_ARRAY_VAL, null);
        ManagedCommandLineGeneratorTest.assertNotNull((Object)iManagedCommandLineInfo);
        ManagedCommandLineGeneratorTest.assertEquals((String)iManagedCommandLineInfo.getCommandLine(), (String)commandLineEtalonesForParameters[3]);
        iManagedCommandLineInfo = managedCommandLineGenerator.generateCommandLineInfo(null, COMMAND_VAL, FLAGS_ARRAY_VAL, OUTPUT_FLAG_VAL, OUTPUT_PREFIX_VAL, null, INPUTS_ARRAY_VAL, null);
        ManagedCommandLineGeneratorTest.assertNotNull((Object)iManagedCommandLineInfo);
        ManagedCommandLineGeneratorTest.assertEquals((String)iManagedCommandLineInfo.getCommandLine(), (String)commandLineEtalonesForParameters[4]);
        iManagedCommandLineInfo = managedCommandLineGenerator.generateCommandLineInfo(null, COMMAND_VAL, FLAGS_ARRAY_VAL, OUTPUT_FLAG_VAL, OUTPUT_PREFIX_VAL, OUTPUT_VAL, null, null);
        ManagedCommandLineGeneratorTest.assertNotNull((Object)iManagedCommandLineInfo);
        ManagedCommandLineGeneratorTest.assertEquals((String)iManagedCommandLineInfo.getCommandLine().trim(), (String)commandLineEtalonesForParameters[5].trim());
    }

    public final void testCustomGenerator() {
        IProjectType iProjectType = ManagedBuildManager.getProjectType((String)"cdt.managedbuild.test.java.attrs");
        ManagedCommandLineGeneratorTest.assertNotNull((Object)iProjectType);
        IConfiguration[] iConfigurationArray = iProjectType.getConfigurations();
        ManagedCommandLineGeneratorTest.assertEquals((int)1, (int)iConfigurationArray.length);
        IConfiguration iConfiguration = iProjectType.getConfiguration("cdt.managedbuild.test.java.attrs.config");
        ManagedCommandLineGeneratorTest.assertNotNull((Object)iConfiguration);
        ITool[] iToolArray = iConfiguration.getTools();
        ManagedCommandLineGeneratorTest.assertEquals((int)1, (int)iToolArray.length);
        ITool iTool = iConfiguration.getTool("cdt.managedbuild.test.java.attrs.tool");
        ManagedCommandLineGeneratorTest.assertNotNull((Object)iTool);
        IOption[] iOptionArray = iTool.getOptions();
        ManagedCommandLineGeneratorTest.assertEquals((int)20, (int)iOptionArray.length);
        IOption iOption = iTool.getOption("testgnu.c.compiler.option.preprocessor.def.symbols.test");
        ManagedCommandLineGeneratorTest.assertNotNull((Object)iOption);
        Object object = iOption.getValue();
        ManagedCommandLineGeneratorTest.assertTrue((boolean)(object instanceof ArrayList));
        ArrayList arrayList = (ArrayList)object;
        ManagedCommandLineGeneratorTest.assertEquals((Object)"foo", arrayList.get(0));
        ManagedCommandLineGeneratorTest.assertEquals((Object)"bar", arrayList.get(1));
        IManagedCommandLineGenerator iManagedCommandLineGenerator = iTool.getCommandLineGenerator();
        String[] stringArray = new String[]{"-a", "-b", "-c"};
        String[] stringArray2 = new String[]{"xy.cpp", "ab.cpp", "lt.cpp", "c.cpp"};
        IManagedCommandLineInfo iManagedCommandLineInfo = iManagedCommandLineGenerator.generateCommandLineInfo(iTool, "MyName", stringArray, "-of", "opre", "TheOutput.exe", stringArray2, "[COMMAND] [FLAGS]");
        ManagedCommandLineGeneratorTest.assertEquals((String)"compiler.gnu.cMyName", (String)iManagedCommandLineInfo.getCommandName());
        ManagedCommandLineGeneratorTest.assertEquals((String)"-c -b -a", (String)iManagedCommandLineInfo.getFlags());
        ManagedCommandLineGeneratorTest.assertEquals((String)"ab.cpp c.cpp foo.cpp lt.cpp xy.cpp", (String)iManagedCommandLineInfo.getInputs());
        ManagedCommandLineGeneratorTest.assertEquals((String)"-0h", (String)iManagedCommandLineInfo.getOutputFlag());
        ManagedCommandLineGeneratorTest.assertEquals((String)"", (String)iManagedCommandLineInfo.getOutputPrefix());
        ManagedCommandLineGeneratorTest.assertEquals((String)"Testme", (String)iManagedCommandLineInfo.getOutput());
        ManagedCommandLineGeneratorTest.assertEquals((String)"[COMMAND] [FLAGS]", (String)iManagedCommandLineInfo.getCommandLinePattern());
        ManagedCommandLineGeneratorTest.assertEquals((String)"This is a test command line", (String)iManagedCommandLineInfo.getCommandLine());
        IManagedBuilderMakefileGenerator iManagedBuilderMakefileGenerator = ManagedBuildManager.getBuildfileGenerator((IConfiguration)iConfiguration);
        String string = iManagedBuilderMakefileGenerator.getMakefileName();
        ManagedCommandLineGeneratorTest.assertEquals((String)"TestBuildFile.mak", (String)string);
    }

    public final void testDollarValue() {
        try {
            IProject iProject = ManagedBuildTestHelper.createProject("CDV", null, null, "cdt.test.dollarValue.ProjectType");
            IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
            IConfiguration iConfiguration = iManagedBuildInfo.getDefaultConfiguration();
            ITool[] iToolArray = iConfiguration.getToolsBySuperClassId("cdt.test.dollarValue.Tool");
            ManagedCommandLineGeneratorTest.assertEquals((int)iToolArray.length, (int)1);
            ITool iTool = iToolArray[0];
            IOption iOption = iTool.getOptionBySuperClassId("cdt.test.dollarValue.option1");
            IOption iOption2 = iTool.getOptionBySuperClassId("cdt.test.dollarValue.option2");
            IOption iOption3 = iTool.getOptionBySuperClassId("cdt.test.dollarValue.option3");
            IOption iOption4 = iTool.getOptionBySuperClassId("cdt.test.dollarValue.option4");
            IOption iOption5 = iTool.getOptionBySuperClassId("cdt.test.dollarValue.option5");
            IOption iOption6 = iTool.getOptionBySuperClassId("cdt.test.dollarValue.option6");
            iOption = iConfiguration.setOption((IHoldsOptions)iTool, iOption, "OPT1VALUE");
            iOption2 = iConfiguration.setOption((IHoldsOptions)iTool, iOption2, "");
            iOption3 = iConfiguration.setOption((IHoldsOptions)iTool, iOption3, "X");
            iOption4 = iConfiguration.setOption((IHoldsOptions)iTool, iOption4, "opt4");
            String string = iTool.getToolCommandFlagsString(null, null);
            ManagedCommandLineGeneratorTest.assertEquals((String)"-opt1 OPT1VALUE X ${opt4}", (String)string);
            iOption = iConfiguration.setOption((IHoldsOptions)iTool, iOption, "");
            iOption2 = iConfiguration.setOption((IHoldsOptions)iTool, iOption2, "Opt2");
            iOption3 = iConfiguration.setOption((IHoldsOptions)iTool, iOption3, "All work and no play...");
            iOption4 = iConfiguration.setOption((IHoldsOptions)iTool, iOption4, "123456789");
            iOption5 = iConfiguration.setOption((IHoldsOptions)iTool, iOption5, "DollarValue");
            string = iTool.getToolCommandFlagsString(null, null);
            ManagedCommandLineGeneratorTest.assertEquals((String)"-opt2Opt2suffix All work and no play... ${123456789} DollarValueDollarValue", (String)string);
            iOption = iConfiguration.setOption((IHoldsOptions)iTool, iOption, "0");
            iOption2 = iConfiguration.setOption((IHoldsOptions)iTool, iOption2, "LongValue");
            iOption3 = iConfiguration.setOption((IHoldsOptions)iTool, iOption3, "");
            iOption4 = iConfiguration.setOption((IHoldsOptions)iTool, iOption4, "");
            iOption5 = iConfiguration.setOption((IHoldsOptions)iTool, iOption5, "$");
            iOption6 = iConfiguration.setOption((IHoldsOptions)iTool, iOption6, "%%");
            string = iTool.getToolCommandFlagsString(null, null);
            ManagedCommandLineGeneratorTest.assertEquals((String)"-opt1 0 -opt2LongValuesuffix $$ x%%yy%%z", (String)string);
            iOption = iConfiguration.setOption((IHoldsOptions)iTool, iOption, "1");
            iOption2 = iConfiguration.setOption((IHoldsOptions)iTool, iOption2, "2");
            iOption3 = iConfiguration.setOption((IHoldsOptions)iTool, iOption3, "3");
            iOption4 = iConfiguration.setOption((IHoldsOptions)iTool, iOption4, "4");
            iOption5 = iConfiguration.setOption((IHoldsOptions)iTool, iOption5, "");
            iOption6 = iConfiguration.setOption((IHoldsOptions)iTool, iOption6, "");
            string = iTool.getToolCommandFlagsString(null, null);
            ManagedCommandLineGeneratorTest.assertEquals((String)"-opt1 1 -opt22suffix 3 ${4}", (String)string);
            ManagedBuildTestHelper.removeProject("CDV");
        }
        catch (Exception exception) {
            ManagedCommandLineGeneratorTest.fail((String)("Test failed on project creation: " + exception.getLocalizedMessage()));
        }
    }
}

