/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.core.tests;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedOptionValueHandler;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionApplicability;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.testplugin.ManagedBuildTestHelper;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class OptionEnablementTests
extends TestCase
implements IManagedOptionValueHandler,
IOptionApplicability {
    private static boolean fEnUiVisible;
    private static boolean fEnUiEnabled;
    private static boolean fEnCmdUsed;
    private static boolean fHandleValueCalled;
    private static final String[] thisEnumIds;
    private static final String[] thisStrings;
    static /* synthetic */ Class class$0;

    static {
        thisEnumIds = new String[]{"testgnu.enablement.c.optimization.level.optimize", "testgnu.enablement.c.optimization.level.more"};
        thisStrings = new String[]{"start 1.2.3 stop"};
    }

    public boolean handleValue(IBuildObject iBuildObject, IHoldsOptions iHoldsOptions, IOption iOption, String string, int n) {
        return false;
    }

    public boolean isDefaultValue(IBuildObject iBuildObject, IHoldsOptions iHoldsOptions, IOption iOption, String string) {
        return false;
    }

    public boolean isEnumValueAppropriate(IBuildObject iBuildObject, IHoldsOptions iHoldsOptions, IOption iOption, String string, String string2) {
        return false;
    }

    public boolean isOptionUsedInCommandLine(IBuildObject iBuildObject, IHoldsOptions iHoldsOptions, IOption iOption) {
        return fEnCmdUsed;
    }

    public boolean isOptionVisible(IBuildObject iBuildObject, IHoldsOptions iHoldsOptions, IOption iOption) {
        return fEnUiVisible;
    }

    public boolean isOptionEnabled(IBuildObject iBuildObject, IHoldsOptions iHoldsOptions, IOption iOption) {
        return fEnUiEnabled;
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.managedbuilder.core.tests.OptionEnablementTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    private void resetValueHandler() {
        fHandleValueCalled = false;
    }

    private void setEnablement(boolean bl, boolean bl2, boolean bl3) {
        fEnUiVisible = bl2;
        fEnUiEnabled = bl3;
        fEnCmdUsed = bl;
    }

    public void testEnablement() {
        this.resetValueHandler();
        IProject iProject = ManagedBuildTestHelper.createProject("en", "cdt.managedbuild.target.enablement.exe");
        ManagedBuildTestHelper.createFile(iProject, "a.c");
        ManagedBuildTestHelper.createFile(iProject, "b.c");
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
        IConfiguration iConfiguration = iManagedBuildInfo.getManagedProject().getConfigurations()[0];
        OptionEnablementTests.assertFalse((boolean)fHandleValueCalled);
        this.doTestEnablement((IBuildObject)iConfiguration);
        this.doEnumAllValues((IBuildObject)iConfiguration);
        ManagedBuildTestHelper.removeProject("en");
    }

    private void doEnumAllValues(IBuildObject iBuildObject) {
        ITool iTool = this.getTool(iBuildObject, "enablement.this.child_1.2.3");
        ITool iTool2 = this.getTool(iBuildObject, "enablement.other");
        iTool.getParent();
        iTool2.getParent();
        int n = 0;
        while (n < thisStrings.length) {
            String string = thisStrings[n];
            this.setOption(iBuildObject, (IHoldsOptions)iTool, "this.string", string);
            this.doTestEnablement(iBuildObject);
            ++n;
        }
        this.setOption(iBuildObject, (IHoldsOptions)iTool, "this.boolean", false);
        this.doTestEnablement(iBuildObject);
        this.setOption(iBuildObject, (IHoldsOptions)iTool, "this.boolean", true);
        this.doTestEnablement(iBuildObject);
    }

    private ITool getTool(IBuildObject iBuildObject, String string) {
        Object var3_3 = null;
        IConfiguration iConfiguration = null;
        ITool iTool = null;
        if (iBuildObject instanceof IResourceConfiguration) {
            iConfiguration = var3_3.getParent();
            ITool[] iToolArray = var3_3.getTools();
            int n = 0;
            while (n < iToolArray.length) {
                ITool iTool2 = iToolArray[n];
                while (iTool2 != null) {
                    if (iTool2.getId().equals(string)) {
                        iTool = iToolArray[n];
                        break;
                    }
                    iTool2 = iTool2.getSuperClass();
                }
                ++n;
            }
        } else if (iBuildObject instanceof IConfiguration) {
            iConfiguration = (IConfiguration)iBuildObject;
            iTool = iConfiguration.getToolsBySuperClassId(string)[0];
        } else {
            OptionEnablementTests.fail((String)"wrong argument");
        }
        return iTool;
    }

    private IOption setOption(IBuildObject iBuildObject, IHoldsOptions iHoldsOptions, String string, boolean bl) {
        return this.setOption(iBuildObject, iHoldsOptions, iHoldsOptions.getOptionBySuperClassId(string), bl);
    }

    private IOption setOption(IBuildObject iBuildObject, IHoldsOptions iHoldsOptions, IOption iOption, boolean bl) {
        try {
            if (iBuildObject instanceof IConfiguration) {
                return ((IConfiguration)iBuildObject).setOption(iHoldsOptions, iOption, bl);
            }
            if (iBuildObject instanceof IResourceConfiguration) {
                return ((IResourceConfiguration)iBuildObject).setOption(iHoldsOptions, iOption, bl);
            }
        }
        catch (BuildException buildException) {
            OptionEnablementTests.fail((String)buildException.getLocalizedMessage());
        }
        OptionEnablementTests.fail((String)"wrong arg");
        return null;
    }

    private IOption setOption(IBuildObject iBuildObject, IHoldsOptions iHoldsOptions, String string, String string2) {
        return this.setOption(iBuildObject, iHoldsOptions, iHoldsOptions.getOptionBySuperClassId(string), string2);
    }

    private IOption setOption(IBuildObject iBuildObject, IHoldsOptions iHoldsOptions, IOption iOption, String string) {
        try {
            if (iBuildObject instanceof IConfiguration) {
                return ((IConfiguration)iBuildObject).setOption(iHoldsOptions, iOption, string);
            }
            if (iBuildObject instanceof IResourceConfiguration) {
                return ((IResourceConfiguration)iBuildObject).setOption(iHoldsOptions, iOption, string);
            }
        }
        catch (BuildException buildException) {
            OptionEnablementTests.fail((String)buildException.getLocalizedMessage());
        }
        OptionEnablementTests.fail((String)"wrong arg");
        return null;
    }

    private IOption setOption(IBuildObject iBuildObject, IHoldsOptions iHoldsOptions, String string, String[] stringArray) {
        return this.setOption(iBuildObject, iHoldsOptions, iHoldsOptions.getOptionBySuperClassId(string), stringArray);
    }

    private IOption setOption(IBuildObject iBuildObject, IHoldsOptions iHoldsOptions, IOption iOption, String[] stringArray) {
        try {
            if (iBuildObject instanceof IConfiguration) {
                return ((IConfiguration)iBuildObject).setOption(iHoldsOptions, iOption, stringArray);
            }
            if (iBuildObject instanceof IResourceConfiguration) {
                return ((IResourceConfiguration)iBuildObject).setOption(iHoldsOptions, iOption, stringArray);
            }
        }
        catch (BuildException buildException) {
            OptionEnablementTests.fail((String)buildException.getLocalizedMessage());
        }
        OptionEnablementTests.fail((String)"wrong arg");
        return null;
    }

    private void doTestEnablement(IBuildObject iBuildObject) {
        ITool iTool = this.getTool(iBuildObject, "enablement.this.child_1.2.3");
        ITool iTool2 = this.getTool(iBuildObject, "enablement.other");
        ITool iTool3 = this.getTool(iBuildObject, "enablement.this.child.2_1.2.3");
        IOption iOption = iTool.getOptionBySuperClassId("this.boolean");
        IOption iOption2 = iTool.getOptionBySuperClassId("this.string");
        IOption iOption3 = iTool.getOptionBySuperClassId("this.enum");
        IOption iOption4 = iTool2.getOptionBySuperClassId("other.string");
        iTool2.getOptionBySuperClassId("other.boolean");
        try {
            IOption iOption5 = iTool.getOptionBySuperClassId("enablement.command.c1");
            OptionEnablementTests.assertEquals((String)iOption5.getCommand(), (String)"c1");
            OptionEnablementTests.assertEquals((String)iOption5.getCommandFalse(), (String)"cmdF");
            OptionEnablementTests.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.command.c2");
            OptionEnablementTests.assertEquals((String)iOption5.getCommand(), (String)"c2");
            OptionEnablementTests.assertEquals((String)iOption5.getCommandFalse(), (String)"cmdF");
            OptionEnablementTests.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.commandFalse.c1");
            OptionEnablementTests.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)iOption5.getCommandFalse(), (String)"c1");
            OptionEnablementTests.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.commandFalse.c2");
            OptionEnablementTests.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)iOption5.getCommandFalse(), (String)"c2");
            OptionEnablementTests.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.command.c1.commandFalse.cF1");
            OptionEnablementTests.assertEquals((String)iOption5.getCommand(), (String)"c1");
            OptionEnablementTests.assertEquals((String)iOption5.getCommandFalse(), (String)"cF1");
            OptionEnablementTests.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.command.cmd.commandFalse.cmdF");
            OptionEnablementTests.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)iOption5.getCommandFalse(), (String)"cmdF");
            OptionEnablementTests.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.command.c1.commandFalse.cmdF");
            OptionEnablementTests.assertEquals((String)iOption5.getCommand(), (String)"c1");
            OptionEnablementTests.assertEquals((String)iOption5.getCommandFalse(), (String)"cmdF");
            OptionEnablementTests.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.command.cmd.commandFalse.cF1");
            OptionEnablementTests.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)iOption5.getCommandFalse(), (String)"cF1");
            OptionEnablementTests.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.ui.en");
            OptionEnablementTests.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)iOption5.getCommandFalse(), (String)"cF1");
            OptionEnablementTests.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.ui.vis");
            OptionEnablementTests.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)iOption5.getCommandFalse(), (String)"cF1");
            OptionEnablementTests.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.cmd.us");
            OptionEnablementTests.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)iOption5.getCommandFalse(), (String)"cmdF");
            OptionEnablementTests.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.cmdUs.or.uiVis");
            OptionEnablementTests.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)iOption5.getCommandFalse(), (String)"cF1");
            OptionEnablementTests.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.uiEn.or.uiVis");
            OptionEnablementTests.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)iOption5.getCommandFalse(), (String)"cF1");
            OptionEnablementTests.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.all");
            OptionEnablementTests.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)iOption5.getCommandFalse(), (String)"cF1");
            OptionEnablementTests.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.all.ac.vh");
            OptionEnablementTests.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)iOption5.getCommandFalse(), (String)"cF1");
            this.setEnablement(false, false, false);
            OptionEnablementTests.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            this.setEnablement(false, true, false);
            OptionEnablementTests.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            this.setEnablement(false, false, true);
            OptionEnablementTests.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            this.setEnablement(true, false, false);
            OptionEnablementTests.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            this.setEnablement(false, false, false);
            iOption5 = iTool.getOptionBySuperClassId("enablement.all.cF1.ac.vh");
            OptionEnablementTests.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)iOption5.getCommandFalse(), (String)"cF1");
            OptionEnablementTests.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            this.setEnablement(true, false, true);
            iOption5 = iTool.getOptionBySuperClassId("enablement.all.cF.cmdF");
            OptionEnablementTests.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)iOption5.getCommandFalse(), (String)"cmdF");
            OptionEnablementTests.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.all.cF.cF1");
            OptionEnablementTests.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)iOption5.getCommandFalse(), (String)"cF1");
            OptionEnablementTests.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("this.boolean");
            OptionEnablementTests.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)iOption5.getCommandFalse(), (String)"cmdF");
            OptionEnablementTests.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.checkOpt.all.Q.this.boolean.True");
            OptionEnablementTests.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)iOption5.getCommandFalse(), (String)"cmdF");
            OptionEnablementTests.assertEquals((boolean)iOption.getBooleanValue(), (boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertEquals((boolean)iOption.getBooleanValue(), (boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertEquals((boolean)iOption.getBooleanValue(), (boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.checkOpt.all.Q.this.boolean.False");
            OptionEnablementTests.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)iOption5.getCommandFalse(), (String)"cmdF");
            OptionEnablementTests.assertEquals((!iOption.getBooleanValue() ? 1 : 0) != 0, (boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertEquals((!iOption.getBooleanValue() ? 1 : 0) != 0, (boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertEquals((!iOption.getBooleanValue() ? 1 : 0) != 0, (boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.checkOpt.all.Q.this.string.Q.empty");
            OptionEnablementTests.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)iOption5.getCommandFalse(), (String)"cmdF");
            OptionEnablementTests.assertEquals((boolean)iOption2.getStringValue().equals(""), (boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertEquals((boolean)iOption2.getStringValue().equals(""), (boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertEquals((boolean)iOption2.getStringValue().equals(""), (boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.checkOpt.all.Q.this.string.Q.test a b c");
            OptionEnablementTests.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)iOption5.getCommandFalse(), (String)"cmdF");
            OptionEnablementTests.assertEquals((boolean)iOption2.getStringValue().equals("test a b c"), (boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertEquals((boolean)iOption2.getStringValue().equals("test a b c"), (boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertEquals((boolean)iOption2.getStringValue().equals("test a b c"), (boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.checkOpt.all.Q.this.enum.Q.testgnu.enablement.c.optimization.level.optimize");
            OptionEnablementTests.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)iOption5.getCommandFalse(), (String)"cmdF");
            String string = iOption3.getEnumeratedId(iOption3.getStringValue());
            if (string == null) {
                string = "";
            }
            OptionEnablementTests.assertEquals((boolean)string.equals("testgnu.enablement.c.optimization.level.optimize"), (boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertEquals((boolean)string.equals("testgnu.enablement.c.optimization.level.optimize"), (boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertEquals((boolean)string.equals("testgnu.enablement.c.optimization.level.optimize"), (boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.checkOpt.all.Q.this.Q.true");
            OptionEnablementTests.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)iOption5.getCommandFalse(), (String)"cmdF");
            OptionEnablementTests.assertEquals((boolean)iOption5.getBooleanValue(), (boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertEquals((boolean)iOption5.getBooleanValue(), (boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertEquals((boolean)iOption5.getBooleanValue(), (boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.checkOpt.all.Q.this.string.Q.start ${ParentVersion} stop");
            OptionEnablementTests.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)iOption5.getCommandFalse(), (String)"cmdF");
            OptionEnablementTests.assertEquals((boolean)iOption2.getStringValue().equals("start 1.2.3 stop"), (boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertEquals((boolean)iOption2.getStringValue().equals("start 1.2.3 stop"), (boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertEquals((boolean)iOption2.getStringValue().equals("start 1.2.3 stop"), (boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.checkOpt.all.Q.this.string.Q.other.string");
            OptionEnablementTests.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)iOption5.getCommandFalse(), (String)"cmdF");
            OptionEnablementTests.assertEquals((boolean)iOption2.getStringValue().equals(iOption4.getStringValue()), (boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertEquals((boolean)iOption2.getStringValue().equals(iOption4.getStringValue()), (boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertEquals((boolean)iOption2.getStringValue().equals(iOption4.getStringValue()), (boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.checkOpt.all.Q.this.string.Q.other.string");
            OptionEnablementTests.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)iOption5.getCommandFalse(), (String)"cmdF");
            OptionEnablementTests.assertEquals((boolean)iOption2.getStringValue().equals(iOption4.getStringValue()), (boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertEquals((boolean)iOption2.getStringValue().equals(iOption4.getStringValue()), (boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertEquals((boolean)iOption2.getStringValue().equals(iOption4.getStringValue()), (boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.checkString");
            OptionEnablementTests.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)iOption5.getCommandFalse(), (String)"cmdF");
            OptionEnablementTests.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.checkString.2");
            OptionEnablementTests.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)iOption5.getCommandFalse(), (String)"cmdF");
            OptionEnablementTests.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.checkString.3");
            OptionEnablementTests.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)iOption5.getCommandFalse(), (String)"cmdF");
            OptionEnablementTests.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.checkFalse.false");
            OptionEnablementTests.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)iOption5.getCommandFalse(), (String)"cmdF");
            OptionEnablementTests.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.checkNot.false");
            OptionEnablementTests.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)iOption5.getCommandFalse(), (String)"cmdF");
            OptionEnablementTests.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.checkOr.true");
            OptionEnablementTests.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)iOption5.getCommandFalse(), (String)"cmdF");
            OptionEnablementTests.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.checkAnd.false");
            OptionEnablementTests.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)iOption5.getCommandFalse(), (String)"cmdF");
            OptionEnablementTests.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.checkHolder.true.1.false.2");
            OptionEnablementTests.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)iOption5.getCommandFalse(), (String)"cmdF");
            OptionEnablementTests.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            OptionEnablementTests.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool3.getOptionBySuperClassId("enablement.checkHolder.true.1.false.2");
            OptionEnablementTests.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)iOption5.getCommandFalse(), (String)"cmdF");
            OptionEnablementTests.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool3, iOption5));
            OptionEnablementTests.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool3, iOption5));
            OptionEnablementTests.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool3, iOption5));
        }
        catch (BuildException buildException) {
            OptionEnablementTests.fail((String)buildException.getLocalizedMessage());
        }
    }
}

