/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.refactoring.tests;

import org.eclipse.cdt.internal.refactoring.CRefactoringArgument;
import org.eclipse.cdt.internal.refactoring.CRenameProcessor;
import org.eclipse.cdt.internal.refactoring.CRenameRefactoring;
import org.eclipse.cdt.refactoring.CRefactory;
import org.eclipse.cdt.refactoring.tests.RefactoringTests;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;

public class RenameTests
extends RefactoringTests {
    public RenameTests(String string) {
        super(string);
    }

    public RenameTests() {
    }

    public Change getRefactorChanges(IFile iFile, int n, String string) throws Exception {
        CRenameRefactoring cRenameRefactoring = this.createRefactoring(iFile, n, string);
        RefactoringStatus refactoringStatus = this.checkConditions(cRenameRefactoring);
        if (!refactoringStatus.hasError()) {
            Change change = cRenameRefactoring.createChange((IProgressMonitor)new NullProgressMonitor());
            return change;
        }
        RenameTests.fail((String)("Input check on " + string + " failed. " + refactoringStatus.getEntryMatchingSeverity(3)));
        return null;
    }

    private CRenameRefactoring createRefactoring(IFile iFile, int n, String string) {
        CRefactoringArgument cRefactoringArgument = (CRefactoringArgument)CRefactory.createArgument((IFile)iFile, (int)n, null);
        CRenameProcessor cRenameProcessor = new CRenameProcessor(CRefactory.getInstance(), cRefactoringArgument);
        cRenameProcessor.setReplacementText(string);
        cRenameProcessor.setSelectedOptions(-1);
        cRenameProcessor.setScope(2);
        return new CRenameRefactoring(cRenameProcessor);
    }

    public String[] getRefactorMessages(IFile iFile, int n, String string) throws Exception {
        CRenameRefactoring cRenameRefactoring = this.createRefactoring(iFile, n, string);
        RefactoringStatus refactoringStatus = this.checkConditions(cRenameRefactoring);
        if (!refactoringStatus.hasWarning()) {
            RenameTests.fail((String)("Input check on " + string + " passed. There should have been warnings or errors. "));
            return null;
        }
        RefactoringStatusEntry[] refactoringStatusEntryArray = refactoringStatus.getEntries();
        String[] stringArray = new String[refactoringStatusEntryArray.length];
        int n2 = 0;
        while (n2 < refactoringStatusEntryArray.length) {
            RefactoringStatusEntry refactoringStatusEntry = refactoringStatusEntryArray[n2];
            stringArray[n2] = refactoringStatusEntry.getMessage();
            ++n2;
        }
        return stringArray;
    }

    public RefactoringStatus checkConditions(IFile iFile, int n, String string) throws Exception {
        CRenameRefactoring cRenameRefactoring = this.createRefactoring(iFile, n, string);
        return this.checkConditions(cRenameRefactoring);
    }

    private RefactoringStatus checkConditions(CRenameRefactoring cRenameRefactoring) throws CoreException {
        RefactoringStatus refactoringStatus = cRenameRefactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
        if (!refactoringStatus.hasError()) {
            refactoringStatus = cRenameRefactoring.checkFinalConditions((IProgressMonitor)new NullProgressMonitor());
        }
        return refactoringStatus;
    }

    public int getRefactorSeverity(IFile iFile, int n, String string) throws Exception {
        CRenameRefactoring cRenameRefactoring = this.createRefactoring(iFile, n, string);
        RefactoringStatus refactoringStatus = this.checkConditions(cRenameRefactoring);
        return refactoringStatus.getSeverity();
    }

    protected int countOccurrences(String string, String string2) {
        int n = string.indexOf(string2);
        int n2 = 0;
        while (n >= 0) {
            ++n2;
            n = string.indexOf(string2, n + string2.length());
        }
        return n2;
    }
}

