/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.refactoring.tests;

import java.io.StringWriter;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.tests.FailingTest;
import org.eclipse.cdt.refactoring.tests.RefactoringTests;
import org.eclipse.cdt.refactoring.tests.RenameTests;
import org.eclipse.core.resources.IFile;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class RenameVariableTests
extends RenameTests {
    static /* synthetic */ Class class$0;

    public RenameVariableTests(String string) {
        super(string);
    }

    public static Test suite() {
        return RenameVariableTests.suite(true);
    }

    public static Test suite(boolean bl) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.refactoring.tests.RenameVariableTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite testSuite = new TestSuite((Class)clazz);
        testSuite.addTest((Test)new FailingTest((Test)new RenameVariableTests("failReferenceViaMacro3"), 90956));
        if (bl) {
            testSuite.addTest((Test)new RefactoringTests("cleanupProject"));
        }
        return testSuite;
    }

    public void testLocalNameConflicts() throws Exception {
        this.createCppFwdDecls("cpp_fwd.hh");
        this.createCppDefs("cpp_def.hh");
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("#include \"cpp_fwd.hh\"   \n");
        stringWriter.write("#include \"cpp_def.hh\"   \n");
        stringWriter.write("void f(int par1) {         \n");
        stringWriter.write("  int v1, x1;              \n");
        stringWriter.write("  {                       \n");
        stringWriter.write("     int w1; v1++;        \n");
        stringWriter.write("  }                       \n");
        stringWriter.write("}                         \n");
        stringWriter.write("void class_def::method(int par2) { \n");
        stringWriter.write("  int v2;                  \n");
        stringWriter.write("  {                        \n");
        stringWriter.write("     int w2; v2++;         \n");
        stringWriter.write("  }                        \n");
        stringWriter.write("}                          \n");
        stringWriter.write("static void class_def::static_method(int par3) { \n");
        stringWriter.write("  int v3;                  \n");
        stringWriter.write("  {                        \n");
        stringWriter.write("     int w3; v3++;         \n");
        stringWriter.write("  }                        \n");
        stringWriter.write("}                          \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("test.cpp", string);
        int n = string.indexOf("v1");
        int n2 = string.indexOf("v2");
        int n3 = string.indexOf("v3");
        RefactoringStatus refactoringStatus = this.checkConditions(iFile, n, "w1");
        this.assertRefactoringError(refactoringStatus, "'w1' will be shadowed by a local variable.");
        refactoringStatus = this.checkConditions(iFile, string.indexOf("w1"), "v1");
        this.assertRefactoringError(refactoringStatus, "'v1' will shadow a local variable.");
        refactoringStatus = this.checkConditions(iFile, string.indexOf("x1"), "v1");
        this.assertRefactoringError(refactoringStatus, "'v1' will redeclare a local variable.");
        refactoringStatus = this.checkConditions(iFile, n, "par1");
        this.assertRefactoringError(refactoringStatus, "'par1' will shadow a parameter.");
        refactoringStatus = this.checkConditions(iFile, n, "extern_var");
        this.assertRefactoringError(refactoringStatus, "'extern_var' will shadow a global variable.");
        refactoringStatus = this.checkConditions(iFile, n, "var_def");
        this.assertRefactoringError(refactoringStatus, "'var_def' will shadow a global variable.");
        refactoringStatus = this.checkConditions(iFile, n, "enum_item");
        this.assertRefactoringError(refactoringStatus, "'enum_item' will shadow an enumerator.");
        refactoringStatus = this.checkConditions(iFile, n2, "w2");
        this.assertRefactoringError(refactoringStatus, "'w2' will be shadowed by a local variable.");
        refactoringStatus = this.checkConditions(iFile, n2, "par2");
        this.assertRefactoringError(refactoringStatus, "'par2' will shadow a parameter.");
        refactoringStatus = this.checkConditions(iFile, n2, "extern_var");
        this.assertRefactoringError(refactoringStatus, "'extern_var' will shadow a global variable.");
        refactoringStatus = this.checkConditions(iFile, n2, "var_def");
        this.assertRefactoringError(refactoringStatus, "'var_def' will shadow a global variable.");
        refactoringStatus = this.checkConditions(iFile, n2, "enum_item");
        this.assertRefactoringError(refactoringStatus, "'enum_item' will shadow an enumerator.");
        refactoringStatus = this.checkConditions(iFile, n3, "w3");
        this.assertRefactoringError(refactoringStatus, "'w3' will be shadowed by a local variable.");
        refactoringStatus = this.checkConditions(iFile, n3, "par3");
        this.assertRefactoringError(refactoringStatus, "'par3' will shadow a parameter.");
        refactoringStatus = this.checkConditions(iFile, n3, "extern_var");
        this.assertRefactoringError(refactoringStatus, "'extern_var' will shadow a global variable.");
        refactoringStatus = this.checkConditions(iFile, n3, "var_def");
        this.assertRefactoringError(refactoringStatus, "'var_def' will shadow a global variable.");
        refactoringStatus = this.checkConditions(iFile, n3, "enum_item");
        this.assertRefactoringError(refactoringStatus, "'enum_item' will shadow an enumerator.");
        refactoringStatus = this.checkConditions(iFile, n, "member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "method");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "static_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "static_method");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "member");
        this.assertRefactoringError(refactoringStatus, "'member' will shadow a field.");
        refactoringStatus = this.checkConditions(iFile, n2, "method");
        this.assertRefactoringError(refactoringStatus, "'method' will shadow a method.");
        refactoringStatus = this.checkConditions(iFile, n2, "static_member");
        this.assertRefactoringError(refactoringStatus, "'static_member' will shadow a field.");
        refactoringStatus = this.checkConditions(iFile, n2, "static_method");
        this.assertRefactoringError(refactoringStatus, "'static_method' will shadow a method.");
        refactoringStatus = this.checkConditions(iFile, n3, "static_member");
        this.assertRefactoringError(refactoringStatus, "'static_member' will shadow a field.");
        refactoringStatus = this.checkConditions(iFile, n3, "static_method");
        this.assertRefactoringError(refactoringStatus, "'static_method' will shadow a method.");
        refactoringStatus = this.checkConditions(iFile, n, "func_proto");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "func_proto_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "func_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "func_def_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "func_proto");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "func_proto_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "func_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "func_def_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "func_proto");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "func_proto_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "func_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "func_def_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "class_fwd");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "struct_fwd");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "union_fwd");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "class_def");
        this.assertRefactoringError(refactoringStatus, "'class_def' will shadow a constructor.");
        refactoringStatus = this.checkConditions(iFile, n, "struct_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "union_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "enum_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "typedef_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "namespace_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "st_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "un_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "class_fwd");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "struct_fwd");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "union_fwd");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "class_def");
        this.assertRefactoringError(refactoringStatus, "'class_def' will shadow a constructor.");
        refactoringStatus = this.checkConditions(iFile, n2, "struct_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "union_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "enum_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "typedef_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "namespace_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "st_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "un_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "class_fwd");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "struct_fwd");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "union_fwd");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "class_def");
        this.assertRefactoringError(refactoringStatus, "'class_def' will shadow a constructor.");
        refactoringStatus = this.checkConditions(iFile, n3, "struct_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "union_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "enum_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "typedef_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "namespace_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "st_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "un_member");
        this.assertRefactoringOk(refactoringStatus);
    }

    public void testLocalNameConflictsPlainC() throws Exception {
        this.createCFwdDecls("c_fwd.h");
        this.createCDefs("c_def.h");
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("#include \"c_fwd.h\"   \n");
        stringWriter.write("#include \"c_def.h\"   \n");
        stringWriter.write("void f(int par1) {     \n");
        stringWriter.write("  int v1, x1, w1;      \n");
        stringWriter.write("  w1++; v1++;          \n");
        stringWriter.write("}                      \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("test.c", string);
        int n = string.indexOf("v1");
        RefactoringStatus refactoringStatus = this.checkConditions(iFile, n, "w1");
        this.assertRefactoringError(refactoringStatus, "'w1' will redeclare a local variable.");
        refactoringStatus = this.checkConditions(iFile, string.indexOf("w1"), "v1");
        this.assertRefactoringError(refactoringStatus, "'v1' will redeclare a local variable.");
        refactoringStatus = this.checkConditions(iFile, string.indexOf("x1"), "v1");
        this.assertRefactoringError(refactoringStatus, "'v1' will redeclare a local variable.");
        refactoringStatus = this.checkConditions(iFile, n, "par1");
        this.assertRefactoringError(refactoringStatus, "'par1' will shadow a parameter.");
        refactoringStatus = this.checkConditions(iFile, n, "extern_var");
        this.assertRefactoringError(refactoringStatus, "'extern_var' will shadow a global variable.");
        refactoringStatus = this.checkConditions(iFile, n, "var_def");
        this.assertRefactoringError(refactoringStatus, "'var_def' will shadow a global variable.");
        refactoringStatus = this.checkConditions(iFile, n, "enum_item");
        this.assertRefactoringError(refactoringStatus, "'enum_item' will shadow an enumerator.");
        refactoringStatus = this.checkConditions(iFile, n, "func_proto");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "func_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "struct_fwd");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "union_fwd");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "struct_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "union_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "enum_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "typedef_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "st_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "un_member");
        this.assertRefactoringOk(refactoringStatus);
    }

    public void testParameterNameConflicts() throws Exception {
        this.createCppFwdDecls("cpp_fwd.hh");
        this.createCppDefs("cpp_def.hh");
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("#include \"cpp_fwd.hh\"   \n");
        stringWriter.write("#include \"cpp_def.hh\"   \n");
        stringWriter.write("void f(int par1, int v1) {\n");
        stringWriter.write("  {                       \n");
        stringWriter.write("     int w1; v1++;        \n");
        stringWriter.write("  }                       \n");
        stringWriter.write("}                         \n");
        stringWriter.write("void class_def::method(int par2, int v2) { \n");
        stringWriter.write("  {                        \n");
        stringWriter.write("     int w2; v2++;         \n");
        stringWriter.write("  }                        \n");
        stringWriter.write("}                          \n");
        stringWriter.write("static void class_def::static_method(int par3, int v3) { \n");
        stringWriter.write("  {                        \n");
        stringWriter.write("     int w3; v3++;         \n");
        stringWriter.write("  }                        \n");
        stringWriter.write("}                          \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("test.cpp", string);
        int n = string.indexOf("v1");
        int n2 = string.indexOf("v2");
        int n3 = string.indexOf("v3");
        RefactoringStatus refactoringStatus = this.checkConditions(iFile, n, "w1");
        this.assertRefactoringError(refactoringStatus, "'w1' will be shadowed by a local variable.");
        refactoringStatus = this.checkConditions(iFile, string.indexOf("w1"), "v1");
        this.assertRefactoringError(refactoringStatus, "'v1' will shadow a parameter.");
        refactoringStatus = this.checkConditions(iFile, string.indexOf("par1"), "v1");
        this.assertRefactoringError(refactoringStatus, "'v1' will redeclare a parameter.");
        refactoringStatus = this.checkConditions(iFile, n, "par1");
        this.assertRefactoringError(refactoringStatus, "'par1' will redeclare a parameter.");
        refactoringStatus = this.checkConditions(iFile, n, "extern_var");
        this.assertRefactoringError(refactoringStatus, "'extern_var' will shadow a global variable.");
        refactoringStatus = this.checkConditions(iFile, n, "var_def");
        this.assertRefactoringError(refactoringStatus, "'var_def' will shadow a global variable.");
        refactoringStatus = this.checkConditions(iFile, n, "enum_item");
        this.assertRefactoringError(refactoringStatus, "'enum_item' will shadow an enumerator.");
        refactoringStatus = this.checkConditions(iFile, n2, "w2");
        this.assertRefactoringError(refactoringStatus, "'w2' will be shadowed by a local variable.");
        refactoringStatus = this.checkConditions(iFile, n2, "par2");
        this.assertRefactoringError(refactoringStatus, "'par2' will redeclare a parameter.");
        refactoringStatus = this.checkConditions(iFile, n2, "extern_var");
        this.assertRefactoringError(refactoringStatus, "'extern_var' will shadow a global variable.");
        refactoringStatus = this.checkConditions(iFile, n2, "var_def");
        this.assertRefactoringError(refactoringStatus, "'var_def' will shadow a global variable.");
        refactoringStatus = this.checkConditions(iFile, n2, "enum_item");
        this.assertRefactoringError(refactoringStatus, "'enum_item' will shadow an enumerator.");
        refactoringStatus = this.checkConditions(iFile, n3, "w3");
        this.assertRefactoringError(refactoringStatus, "'w3' will be shadowed by a local variable.");
        refactoringStatus = this.checkConditions(iFile, n3, "par3");
        this.assertRefactoringError(refactoringStatus, "'par3' will redeclare a parameter.");
        refactoringStatus = this.checkConditions(iFile, n3, "extern_var");
        this.assertRefactoringError(refactoringStatus, "'extern_var' will shadow a global variable.");
        refactoringStatus = this.checkConditions(iFile, n3, "var_def");
        this.assertRefactoringError(refactoringStatus, "'var_def' will shadow a global variable.");
        refactoringStatus = this.checkConditions(iFile, n3, "enum_item");
        this.assertRefactoringError(refactoringStatus, "'enum_item' will shadow an enumerator.");
        refactoringStatus = this.checkConditions(iFile, n, "member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "method");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "static_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "static_method");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "member");
        this.assertRefactoringError(refactoringStatus, "'member' will shadow a field.");
        refactoringStatus = this.checkConditions(iFile, n2, "method");
        this.assertRefactoringError(refactoringStatus, "'method' will shadow a method.");
        refactoringStatus = this.checkConditions(iFile, n2, "static_member");
        this.assertRefactoringError(refactoringStatus, "'static_member' will shadow a field.");
        refactoringStatus = this.checkConditions(iFile, n2, "static_method");
        this.assertRefactoringError(refactoringStatus, "'static_method' will shadow a method.");
        refactoringStatus = this.checkConditions(iFile, n3, "static_member");
        this.assertRefactoringError(refactoringStatus, "'static_member' will shadow a field.");
        refactoringStatus = this.checkConditions(iFile, n3, "static_method");
        this.assertRefactoringError(refactoringStatus, "'static_method' will shadow a method.");
        refactoringStatus = this.checkConditions(iFile, n, "func_proto");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "func_proto_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "func_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "func_def_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "func_proto");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "func_proto_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "func_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "func_def_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "func_proto");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "func_proto_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "func_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "func_def_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "class_fwd");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "struct_fwd");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "union_fwd");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "class_def");
        this.assertRefactoringError(refactoringStatus, "'class_def' will shadow a constructor.");
        refactoringStatus = this.checkConditions(iFile, n, "struct_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "union_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "enum_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "typedef_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "namespace_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "st_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "un_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "class_fwd");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "struct_fwd");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "union_fwd");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "class_def");
        this.assertRefactoringError(refactoringStatus, "'class_def' will shadow a constructor.");
        refactoringStatus = this.checkConditions(iFile, n2, "struct_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "union_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "enum_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "typedef_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "namespace_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "st_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "un_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "class_fwd");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "struct_fwd");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "union_fwd");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "class_def");
        this.assertRefactoringError(refactoringStatus, "'class_def' will shadow a constructor.");
        refactoringStatus = this.checkConditions(iFile, n3, "struct_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "union_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "enum_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "typedef_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "namespace_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "st_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "un_member");
        this.assertRefactoringOk(refactoringStatus);
    }

    public void testParameterNameConflictsPlainC() throws Exception {
        this.createCFwdDecls("c_fwd.h");
        this.createCDefs("c_def.h");
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("#include \"c_fwd.h\"   \n");
        stringWriter.write("#include \"c_def.h\"   \n");
        stringWriter.write("void f(int par1, int v1) {\n");
        stringWriter.write("     int w1; v1++;        \n");
        stringWriter.write("}                         \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("test.c", string);
        int n = string.indexOf("v1");
        RefactoringStatus refactoringStatus = this.checkConditions(iFile, n, "w1");
        this.assertRefactoringError(refactoringStatus, "'w1' will be shadowed by a local variable.");
        refactoringStatus = this.checkConditions(iFile, string.indexOf("w1"), "v1");
        this.assertRefactoringError(refactoringStatus, "'v1' will shadow a parameter.");
        refactoringStatus = this.checkConditions(iFile, string.indexOf("par1"), "v1");
        this.assertRefactoringError(refactoringStatus, "'v1' will redeclare a parameter.");
        refactoringStatus = this.checkConditions(iFile, n, "par1");
        this.assertRefactoringError(refactoringStatus, "'par1' will redeclare a parameter.");
        refactoringStatus = this.checkConditions(iFile, n, "extern_var");
        this.assertRefactoringError(refactoringStatus, "'extern_var' will shadow a global variable.");
        refactoringStatus = this.checkConditions(iFile, n, "var_def");
        this.assertRefactoringError(refactoringStatus, "'var_def' will shadow a global variable.");
        refactoringStatus = this.checkConditions(iFile, n, "enum_item");
        this.assertRefactoringError(refactoringStatus, "'enum_item' will shadow an enumerator.");
        refactoringStatus = this.checkConditions(iFile, n, "func_proto");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "func_proto_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "func_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "func_def_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "struct_fwd");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "union_fwd");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "struct_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "union_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "enum_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "typedef_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "st_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "un_member");
        this.assertRefactoringOk(refactoringStatus);
    }

    public void testVaribleNameConflicts() throws Exception {
        this.createCppFwdDecls("cpp_fwd.hh");
        this.createCppDefs("cpp_def.hh");
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("#include \"cpp_fwd.hh\"   \n");
        stringWriter.write("#include \"cpp_def.hh\"   \n");
        stringWriter.write("int v1, v2, v3;           \n");
        stringWriter.write("static int s1;            \n");
        stringWriter.write("static int s2;            \n");
        stringWriter.write("void f(int par1){         \n");
        stringWriter.write("  {                       \n");
        stringWriter.write("     int w1; v1++;        \n");
        stringWriter.write("  }                       \n");
        stringWriter.write("}                         \n");
        stringWriter.write("void class_def::method(int par2) { \n");
        stringWriter.write("  {                        \n");
        stringWriter.write("     int w2; v2++;         \n");
        stringWriter.write("  }                        \n");
        stringWriter.write("}                          \n");
        stringWriter.write("static void class_def::static_method(int par3) { \n");
        stringWriter.write("  {                        \n");
        stringWriter.write("     int w3; v3++;         \n");
        stringWriter.write("  }                        \n");
        stringWriter.write("}                          \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("test.cpp", string);
        stringWriter = new StringWriter();
        stringWriter.write("static int static_other_file;     \n");
        this.importFile("other.cpp", stringWriter.toString());
        int n = string.indexOf("v1");
        int n2 = string.indexOf("v2");
        int n3 = string.indexOf("v3");
        RefactoringStatus refactoringStatus = this.checkConditions(iFile, n, "w1");
        this.assertRefactoringError(refactoringStatus, "'w1' will be shadowed by a local variable.");
        refactoringStatus = this.checkConditions(iFile, string.indexOf("w1"), "v1");
        this.assertRefactoringError(refactoringStatus, "'v1' will shadow a global variable.");
        refactoringStatus = this.checkConditions(iFile, string.indexOf("par1"), "v1");
        this.assertRefactoringError(refactoringStatus, "'v1' will shadow a global variable.");
        refactoringStatus = this.checkConditions(iFile, n, "par1");
        this.assertRefactoringError(refactoringStatus, "'par1' will be shadowed by a parameter.");
        refactoringStatus = this.checkConditions(iFile, n, "extern_var");
        this.assertRefactoringError(refactoringStatus, "'extern_var' will redeclare a global variable.");
        refactoringStatus = this.checkConditions(iFile, n, "var_def");
        this.assertRefactoringError(refactoringStatus, "'var_def' will redeclare a global variable.");
        refactoringStatus = this.checkConditions(iFile, n, "enum_item");
        this.assertRefactoringError(refactoringStatus, "'enum_item' will redeclare an enumerator.");
        refactoringStatus = this.checkConditions(iFile, n2, "w2");
        this.assertRefactoringError(refactoringStatus, "'w2' will be shadowed by a local variable.");
        refactoringStatus = this.checkConditions(iFile, n2, "par2");
        this.assertRefactoringError(refactoringStatus, "'par2' will be shadowed by a parameter.");
        refactoringStatus = this.checkConditions(iFile, n2, "extern_var");
        this.assertRefactoringError(refactoringStatus, "'extern_var' will redeclare a global variable.");
        refactoringStatus = this.checkConditions(iFile, n2, "var_def");
        this.assertRefactoringError(refactoringStatus, "'var_def' will redeclare a global variable.");
        refactoringStatus = this.checkConditions(iFile, n2, "enum_item");
        this.assertRefactoringError(refactoringStatus, "'enum_item' will redeclare an enumerator.");
        refactoringStatus = this.checkConditions(iFile, n3, "w3");
        this.assertRefactoringError(refactoringStatus, "'w3' will be shadowed by a local variable.");
        refactoringStatus = this.checkConditions(iFile, n3, "par3");
        this.assertRefactoringError(refactoringStatus, "'par3' will be shadowed by a parameter.");
        refactoringStatus = this.checkConditions(iFile, n3, "extern_var");
        this.assertRefactoringError(refactoringStatus, "'extern_var' will redeclare a global variable.");
        refactoringStatus = this.checkConditions(iFile, n3, "var_def");
        this.assertRefactoringError(refactoringStatus, "'var_def' will redeclare a global variable.");
        refactoringStatus = this.checkConditions(iFile, n3, "enum_item");
        this.assertRefactoringError(refactoringStatus, "'enum_item' will redeclare an enumerator.");
        refactoringStatus = this.checkConditions(iFile, n, "member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "method");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "static_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "static_method");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "member");
        this.assertRefactoringError(refactoringStatus, "'member' will be shadowed by a field.");
        refactoringStatus = this.checkConditions(iFile, n2, "method");
        this.assertRefactoringError(refactoringStatus, "'method' will be shadowed by a method.");
        refactoringStatus = this.checkConditions(iFile, n2, "static_member");
        this.assertRefactoringError(refactoringStatus, "'static_member' will be shadowed by a field.");
        refactoringStatus = this.checkConditions(iFile, n2, "static_method");
        this.assertRefactoringError(refactoringStatus, "'static_method' will be shadowed by a method.");
        refactoringStatus = this.checkConditions(iFile, n3, "static_member");
        this.assertRefactoringError(refactoringStatus, "'static_member' will be shadowed by a field.");
        refactoringStatus = this.checkConditions(iFile, n3, "static_method");
        this.assertRefactoringError(refactoringStatus, "'static_method' will be shadowed by a method.");
        refactoringStatus = this.checkConditions(iFile, n, "func_proto");
        this.assertRefactoringError(refactoringStatus, "'func_proto' will redeclare a global function.");
        refactoringStatus = this.checkConditions(iFile, n, "func_proto_ov");
        this.assertRefactoringError(refactoringStatus, "'func_proto_ov' will redeclare a global function.");
        refactoringStatus = this.checkConditions(iFile, n, "func_def");
        this.assertRefactoringError(refactoringStatus, "'func_def' will redeclare a global function.");
        refactoringStatus = this.checkConditions(iFile, n, "func_def_ov");
        this.assertRefactoringError(refactoringStatus, "'func_def_ov' will redeclare a global function.");
        refactoringStatus = this.checkConditions(iFile, n2, "func_proto");
        this.assertRefactoringError(refactoringStatus, "'func_proto' will redeclare a global function.");
        refactoringStatus = this.checkConditions(iFile, n2, "func_proto_ov");
        this.assertRefactoringError(refactoringStatus, "'func_proto_ov' will redeclare a global function.");
        refactoringStatus = this.checkConditions(iFile, n2, "func_def");
        this.assertRefactoringError(refactoringStatus, "'func_def' will redeclare a global function.");
        refactoringStatus = this.checkConditions(iFile, n2, "func_def_ov");
        this.assertRefactoringError(refactoringStatus, "'func_def_ov' will redeclare a global function.");
        refactoringStatus = this.checkConditions(iFile, n3, "func_proto");
        this.assertRefactoringError(refactoringStatus, "'func_proto' will redeclare a global function.");
        refactoringStatus = this.checkConditions(iFile, n3, "func_proto_ov");
        this.assertRefactoringError(refactoringStatus, "'func_proto_ov' will redeclare a global function.");
        refactoringStatus = this.checkConditions(iFile, n3, "func_def");
        this.assertRefactoringError(refactoringStatus, "'func_def' will redeclare a global function.");
        refactoringStatus = this.checkConditions(iFile, n3, "func_def_ov");
        this.assertRefactoringError(refactoringStatus, "'func_def_ov' will redeclare a global function.");
        refactoringStatus = this.checkConditions(iFile, n, "class_fwd");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "struct_fwd");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "union_fwd");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "class_def");
        this.assertRefactoringError(refactoringStatus, "'class_def' will be shadowed by a constructor.");
        refactoringStatus = this.checkConditions(iFile, n, "struct_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "union_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "enum_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "typedef_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "namespace_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "st_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "un_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "class_fwd");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "struct_fwd");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "union_fwd");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "class_def");
        this.assertRefactoringError(refactoringStatus, "'class_def' will be shadowed by a constructor.");
        refactoringStatus = this.checkConditions(iFile, n2, "struct_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "union_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "enum_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "typedef_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "namespace_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "st_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "un_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "class_fwd");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "struct_fwd");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "union_fwd");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "class_def");
        this.assertRefactoringError(refactoringStatus, "'class_def' will be shadowed by a constructor.");
        refactoringStatus = this.checkConditions(iFile, n3, "struct_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "union_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "enum_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "typedef_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "namespace_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "st_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "un_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, string.indexOf("s1"), "s2");
        this.assertRefactoringError(refactoringStatus, "'s2' will redeclare a file static variable.");
        refactoringStatus = this.checkConditions(iFile, string.indexOf("s1"), "static_other_file");
        this.assertRefactoringOk(refactoringStatus);
    }

    public void testVaribleNameConflictsPlainC() throws Exception {
        this.createCFwdDecls("c_fwd.h");
        this.createCDefs("c_def.h");
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("#include \"c_fwd.h\"   \n");
        stringWriter.write("#include \"c_def.h\"   \n");
        stringWriter.write("int v1;                \n");
        stringWriter.write("static int s2;            \n");
        stringWriter.write("void f(int par1){         \n");
        stringWriter.write("     int w1; v1++;        \n");
        stringWriter.write("}                         \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("test.c", string);
        stringWriter = new StringWriter();
        stringWriter.write("static int static_other_file;     \n");
        this.importFile("other.c", stringWriter.toString());
        int n = string.indexOf("v1");
        RefactoringStatus refactoringStatus = this.checkConditions(iFile, n, "w1");
        this.assertRefactoringError(refactoringStatus, "'w1' will be shadowed by a local variable.");
        refactoringStatus = this.checkConditions(iFile, string.indexOf("w1"), "v1");
        this.assertRefactoringError(refactoringStatus, "'v1' will shadow a global variable.");
        refactoringStatus = this.checkConditions(iFile, string.indexOf("par1"), "v1");
        this.assertRefactoringError(refactoringStatus, "'v1' will shadow a global variable.");
        refactoringStatus = this.checkConditions(iFile, n, "par1");
        this.assertRefactoringError(refactoringStatus, "'par1' will be shadowed by a parameter.");
        refactoringStatus = this.checkConditions(iFile, n, "extern_var");
        this.assertRefactoringError(refactoringStatus, "'extern_var' will redeclare a global variable.");
        refactoringStatus = this.checkConditions(iFile, n, "var_def");
        this.assertRefactoringError(refactoringStatus, "'var_def' will redeclare a global variable.");
        refactoringStatus = this.checkConditions(iFile, n, "enum_item");
        this.assertRefactoringError(refactoringStatus, "'enum_item' will redeclare an enumerator.");
        refactoringStatus = this.checkConditions(iFile, n, "func_proto");
        this.assertRefactoringError(refactoringStatus, "'func_proto' will redeclare a global function.");
        refactoringStatus = this.checkConditions(iFile, n, "func_def");
        this.assertRefactoringError(refactoringStatus, "'func_def' will redeclare a global function.");
        refactoringStatus = this.checkConditions(iFile, n, "struct_fwd");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "union_fwd");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "struct_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "union_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "enum_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "typedef_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "st_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "un_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, string.indexOf("s1"), "s2");
        this.assertRefactoringError(refactoringStatus, "'s2' will redeclare a file static variable.");
        refactoringStatus = this.checkConditions(iFile, string.indexOf("s1"), "static_other_file");
        this.assertRefactoringOk(refactoringStatus);
    }

    public void testEnumeratorNameConflicts() throws Exception {
        this.createCppFwdDecls("cpp_fwd.hh");
        this.createCppDefs("cpp_def.hh");
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("#include \"cpp_fwd.hh\"   \n");
        stringWriter.write("#include \"cpp_def.hh\"   \n");
        stringWriter.write("enum E {v1, v2, v3};      \n");
        stringWriter.write("static int s1;            \n");
        stringWriter.write("static int s2;            \n");
        stringWriter.write("void f(int par1){         \n");
        stringWriter.write("  {                       \n");
        stringWriter.write("     int w1=v1;           \n");
        stringWriter.write("  }                       \n");
        stringWriter.write("}                         \n");
        stringWriter.write("void class_def::method(int par2) { \n");
        stringWriter.write("  {                        \n");
        stringWriter.write("     int w2=v2;            \n");
        stringWriter.write("  }                        \n");
        stringWriter.write("}                          \n");
        stringWriter.write("static void class_def::static_method(int par3) { \n");
        stringWriter.write("  {                        \n");
        stringWriter.write("     int w3=v3;            \n");
        stringWriter.write("  }                        \n");
        stringWriter.write("}                          \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("test.cpp", string);
        stringWriter = new StringWriter();
        stringWriter.write("static int static_other_file;     \n");
        this.importFile("other.cpp", stringWriter.toString());
        int n = string.indexOf("v1");
        int n2 = string.indexOf("v2");
        int n3 = string.indexOf("v3");
        RefactoringStatus refactoringStatus = this.checkConditions(iFile, n, "w1");
        this.assertRefactoringError(refactoringStatus, "'w1' will be shadowed by a local variable.");
        refactoringStatus = this.checkConditions(iFile, string.indexOf("w1"), "v1");
        this.assertRefactoringError(refactoringStatus, "'v1' will shadow an enumerator.");
        refactoringStatus = this.checkConditions(iFile, string.indexOf("par1"), "v1");
        this.assertRefactoringError(refactoringStatus, "'v1' will shadow an enumerator.");
        refactoringStatus = this.checkConditions(iFile, n, "par1");
        this.assertRefactoringError(refactoringStatus, "'par1' will be shadowed by a parameter.");
        refactoringStatus = this.checkConditions(iFile, n, "extern_var");
        this.assertRefactoringError(refactoringStatus, "'extern_var' will redeclare a global variable.");
        refactoringStatus = this.checkConditions(iFile, n, "var_def");
        this.assertRefactoringError(refactoringStatus, "'var_def' will redeclare a global variable.");
        refactoringStatus = this.checkConditions(iFile, n, "enum_item");
        this.assertRefactoringError(refactoringStatus, "'enum_item' will redeclare an enumerator.");
        refactoringStatus = this.checkConditions(iFile, n2, "w2");
        this.assertRefactoringError(refactoringStatus, "'w2' will be shadowed by a local variable.");
        refactoringStatus = this.checkConditions(iFile, n2, "par2");
        this.assertRefactoringError(refactoringStatus, "'par2' will be shadowed by a parameter.");
        refactoringStatus = this.checkConditions(iFile, n2, "extern_var");
        this.assertRefactoringError(refactoringStatus, "'extern_var' will redeclare a global variable.");
        refactoringStatus = this.checkConditions(iFile, n2, "var_def");
        this.assertRefactoringError(refactoringStatus, "'var_def' will redeclare a global variable.");
        refactoringStatus = this.checkConditions(iFile, n2, "enum_item");
        this.assertRefactoringError(refactoringStatus, "'enum_item' will redeclare an enumerator.");
        refactoringStatus = this.checkConditions(iFile, n3, "w3");
        this.assertRefactoringError(refactoringStatus, "'w3' will be shadowed by a local variable.");
        refactoringStatus = this.checkConditions(iFile, n3, "par3");
        this.assertRefactoringError(refactoringStatus, "'par3' will be shadowed by a parameter.");
        refactoringStatus = this.checkConditions(iFile, n3, "extern_var");
        this.assertRefactoringError(refactoringStatus, "'extern_var' will redeclare a global variable.");
        refactoringStatus = this.checkConditions(iFile, n3, "var_def");
        this.assertRefactoringError(refactoringStatus, "'var_def' will redeclare a global variable.");
        refactoringStatus = this.checkConditions(iFile, n3, "enum_item");
        this.assertRefactoringError(refactoringStatus, "'enum_item' will redeclare an enumerator.");
        refactoringStatus = this.checkConditions(iFile, n, "member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "method");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "static_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "static_method");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "member");
        this.assertRefactoringError(refactoringStatus, "'member' will be shadowed by a field.");
        refactoringStatus = this.checkConditions(iFile, n2, "method");
        this.assertRefactoringError(refactoringStatus, "'method' will be shadowed by a method.");
        refactoringStatus = this.checkConditions(iFile, n2, "static_member");
        this.assertRefactoringError(refactoringStatus, "'static_member' will be shadowed by a field.");
        refactoringStatus = this.checkConditions(iFile, n2, "static_method");
        this.assertRefactoringError(refactoringStatus, "'static_method' will be shadowed by a method.");
        refactoringStatus = this.checkConditions(iFile, n3, "static_member");
        this.assertRefactoringError(refactoringStatus, "'static_member' will be shadowed by a field.");
        refactoringStatus = this.checkConditions(iFile, n3, "static_method");
        this.assertRefactoringError(refactoringStatus, "'static_method' will be shadowed by a method.");
        refactoringStatus = this.checkConditions(iFile, n, "func_proto");
        this.assertRefactoringError(refactoringStatus, "'func_proto' will redeclare a global function.");
        refactoringStatus = this.checkConditions(iFile, n, "func_proto_ov");
        this.assertRefactoringError(refactoringStatus, "'func_proto_ov' will redeclare a global function.");
        refactoringStatus = this.checkConditions(iFile, n, "func_def");
        this.assertRefactoringError(refactoringStatus, "'func_def' will redeclare a global function.");
        refactoringStatus = this.checkConditions(iFile, n, "func_def_ov");
        this.assertRefactoringError(refactoringStatus, "'func_def_ov' will redeclare a global function.");
        refactoringStatus = this.checkConditions(iFile, n2, "func_proto");
        this.assertRefactoringError(refactoringStatus, "'func_proto' will redeclare a global function.");
        refactoringStatus = this.checkConditions(iFile, n2, "func_proto_ov");
        this.assertRefactoringError(refactoringStatus, "'func_proto_ov' will redeclare a global function.");
        refactoringStatus = this.checkConditions(iFile, n2, "func_def");
        this.assertRefactoringError(refactoringStatus, "'func_def' will redeclare a global function.");
        refactoringStatus = this.checkConditions(iFile, n2, "func_def_ov");
        this.assertRefactoringError(refactoringStatus, "'func_def_ov' will redeclare a global function.");
        refactoringStatus = this.checkConditions(iFile, n3, "func_proto");
        this.assertRefactoringError(refactoringStatus, "'func_proto' will redeclare a global function.");
        refactoringStatus = this.checkConditions(iFile, n3, "func_proto_ov");
        this.assertRefactoringError(refactoringStatus, "'func_proto_ov' will redeclare a global function.");
        refactoringStatus = this.checkConditions(iFile, n3, "func_def");
        this.assertRefactoringError(refactoringStatus, "'func_def' will redeclare a global function.");
        refactoringStatus = this.checkConditions(iFile, n3, "func_def_ov");
        this.assertRefactoringError(refactoringStatus, "'func_def_ov' will redeclare a global function.");
        refactoringStatus = this.checkConditions(iFile, n, "class_fwd");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "struct_fwd");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "union_fwd");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "class_def");
        this.assertRefactoringError(refactoringStatus, "'class_def' will be shadowed by a constructor.");
        refactoringStatus = this.checkConditions(iFile, n, "struct_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "union_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "enum_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "typedef_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "namespace_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "st_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "un_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "class_fwd");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "struct_fwd");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "union_fwd");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "class_def");
        this.assertRefactoringError(refactoringStatus, "'class_def' will be shadowed by a constructor.");
        refactoringStatus = this.checkConditions(iFile, n2, "struct_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "union_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "enum_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "typedef_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "namespace_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "st_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "un_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "class_fwd");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "struct_fwd");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "union_fwd");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "class_def");
        this.assertRefactoringError(refactoringStatus, "'class_def' will be shadowed by a constructor.");
        refactoringStatus = this.checkConditions(iFile, n3, "struct_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "union_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "enum_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "typedef_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "namespace_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "st_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "un_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, string.indexOf("s1"), "s2");
        this.assertRefactoringError(refactoringStatus, "'s2' will redeclare a file static variable.");
        refactoringStatus = this.checkConditions(iFile, string.indexOf("s1"), "static_other_file");
        this.assertRefactoringOk(refactoringStatus);
    }

    public void testEnumeratorNameConflictsPlainC() throws Exception {
        this.createCFwdDecls("c_fwd.h");
        this.createCDefs("c_def.h");
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("#include \"c_fwd.h\"   \n");
        stringWriter.write("#include \"c_def.h\"   \n");
        stringWriter.write("enum E {v1, v2, v3};      \n");
        stringWriter.write("static int s1;            \n");
        stringWriter.write("static int s2;            \n");
        stringWriter.write("void f(int par1){         \n");
        stringWriter.write("     int w1=v1;           \n");
        stringWriter.write("}                         \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("test.c", string);
        stringWriter = new StringWriter();
        stringWriter.write("static int static_other_file;     \n");
        this.importFile("other.cpp", stringWriter.toString());
        int n = string.indexOf("v1");
        RefactoringStatus refactoringStatus = this.checkConditions(iFile, n, "w1");
        this.assertRefactoringError(refactoringStatus, "'w1' will be shadowed by a local variable.");
        refactoringStatus = this.checkConditions(iFile, string.indexOf("w1"), "v1");
        this.assertRefactoringError(refactoringStatus, "'v1' will shadow an enumerator.");
        refactoringStatus = this.checkConditions(iFile, string.indexOf("par1"), "v1");
        this.assertRefactoringError(refactoringStatus, "'v1' will shadow an enumerator.");
        refactoringStatus = this.checkConditions(iFile, n, "par1");
        this.assertRefactoringError(refactoringStatus, "'par1' will be shadowed by a parameter.");
        refactoringStatus = this.checkConditions(iFile, n, "extern_var");
        this.assertRefactoringError(refactoringStatus, "'extern_var' will redeclare a global variable.");
        refactoringStatus = this.checkConditions(iFile, n, "var_def");
        this.assertRefactoringError(refactoringStatus, "'var_def' will redeclare a global variable.");
        refactoringStatus = this.checkConditions(iFile, n, "enum_item");
        this.assertRefactoringError(refactoringStatus, "'enum_item' will redeclare an enumerator.");
        refactoringStatus = this.checkConditions(iFile, n, "func_proto");
        this.assertRefactoringError(refactoringStatus, "'func_proto' will redeclare a global function.");
        refactoringStatus = this.checkConditions(iFile, n, "func_def");
        this.assertRefactoringError(refactoringStatus, "'func_def' will redeclare a global function.");
        refactoringStatus = this.checkConditions(iFile, n, "struct_fwd");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "union_fwd");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "struct_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "union_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "enum_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "typedef_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "st_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "un_member");
        this.assertRefactoringOk(refactoringStatus);
    }

    public void testMemberNameConflicts1() throws Exception {
        this.createCppFwdDecls("cpp_fwd.hh");
        this.createCppDefs("cpp_def.hh");
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("#include \"cpp_fwd.hh\"   \n");
        stringWriter.write("#include \"cpp_def.hh\"   \n");
        stringWriter.write("class Dummy {             \n");
        stringWriter.write("  int v1, v2, v3;         \n");
        stringWriter.write("  int member;         \n");
        stringWriter.write("  int method(int);           \n");
        stringWriter.write("  static int static_method(int);           \n");
        stringWriter.write("  static int static_member;         \n");
        stringWriter.write("};                        \n");
        stringWriter.write("void Dummy::method(int par1) { \n");
        stringWriter.write("  {                        \n");
        stringWriter.write("     int w1; v1++;       \n");
        stringWriter.write("  }                        \n");
        stringWriter.write("}                          \n");
        stringWriter.write("static void Dummy::static_method(int par2) { \n");
        stringWriter.write("  {                        \n");
        stringWriter.write("     int w2; v2++;       \n");
        stringWriter.write("  }                        \n");
        stringWriter.write("}                          \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("test.cpp", string);
        int n = string.indexOf("v1");
        int n2 = string.indexOf("v2");
        int n3 = string.indexOf("v3");
        RefactoringStatus refactoringStatus = this.checkConditions(iFile, n, "w1");
        this.assertRefactoringError(refactoringStatus, "'w1' will be shadowed by a local variable.");
        refactoringStatus = this.checkConditions(iFile, string.indexOf("w1"), "v1");
        this.assertRefactoringError(refactoringStatus, "'v1' will shadow a field.");
        refactoringStatus = this.checkConditions(iFile, string.indexOf("par1"), "v1");
        this.assertRefactoringError(refactoringStatus, "'v1' will shadow a field.");
        refactoringStatus = this.checkConditions(iFile, n, "par1");
        this.assertRefactoringError(refactoringStatus, "'par1' will be shadowed by a parameter.");
        refactoringStatus = this.checkConditions(iFile, n, "extern_var");
        this.assertRefactoringError(refactoringStatus, "'extern_var' will shadow a global variable.");
        refactoringStatus = this.checkConditions(iFile, n, "var_def");
        this.assertRefactoringError(refactoringStatus, "'var_def' will shadow a global variable.");
        refactoringStatus = this.checkConditions(iFile, n, "enum_item");
        this.assertRefactoringError(refactoringStatus, "'enum_item' will shadow an enumerator.");
        refactoringStatus = this.checkConditions(iFile, n2, "w2");
        this.assertRefactoringError(refactoringStatus, "'w2' will be shadowed by a local variable.");
        refactoringStatus = this.checkConditions(iFile, n2, "par2");
        this.assertRefactoringError(refactoringStatus, "'par2' will be shadowed by a parameter.");
        refactoringStatus = this.checkConditions(iFile, n2, "extern_var");
        this.assertRefactoringError(refactoringStatus, "'extern_var' will shadow a global variable.");
        refactoringStatus = this.checkConditions(iFile, n2, "var_def");
        this.assertRefactoringError(refactoringStatus, "'var_def' will shadow a global variable.");
        refactoringStatus = this.checkConditions(iFile, n2, "enum_item");
        this.assertRefactoringError(refactoringStatus, "'enum_item' will shadow an enumerator.");
        refactoringStatus = this.checkConditions(iFile, n2, "member");
        this.assertRefactoringError(refactoringStatus, "'member' will redeclare a field.");
        refactoringStatus = this.checkConditions(iFile, n2, "method");
        this.assertRefactoringError(refactoringStatus, "'method' will redeclare a method.");
        refactoringStatus = this.checkConditions(iFile, n2, "static_member");
        this.assertRefactoringError(refactoringStatus, "'static_member' will redeclare a field.");
        refactoringStatus = this.checkConditions(iFile, n2, "static_method");
        this.assertRefactoringError(refactoringStatus, "'static_method' will redeclare a method.");
        refactoringStatus = this.checkConditions(iFile, n3, "static_member");
        this.assertRefactoringError(refactoringStatus, "'static_member' will redeclare a field.");
        refactoringStatus = this.checkConditions(iFile, n3, "static_method");
        this.assertRefactoringError(refactoringStatus, "'static_method' will redeclare a method.");
    }

    public void testMemberNameConflicts2() throws Exception {
        this.createCppFwdDecls("cpp_fwd.hh");
        this.createCppDefs("cpp_def.hh");
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("#include \"cpp_fwd.hh\"   \n");
        stringWriter.write("#include \"cpp_def.hh\"   \n");
        stringWriter.write("class Dummy {             \n");
        stringWriter.write("  int v1, v2, v3;         \n");
        stringWriter.write("};                        \n");
        stringWriter.write("Dummy d;                  \n");
        stringWriter.write("void f(int par1){         \n");
        stringWriter.write("  {                       \n");
        stringWriter.write("     int w1; d.v1++;        \n");
        stringWriter.write("  }                       \n");
        stringWriter.write("}                         \n");
        stringWriter.write("void class_def::method(int par2) { \n");
        stringWriter.write("  {                        \n");
        stringWriter.write("     int w2; d.v2++;       \n");
        stringWriter.write("  }                        \n");
        stringWriter.write("}                          \n");
        stringWriter.write("static void class_def::static_method(int par3) { \n");
        stringWriter.write("  {                        \n");
        stringWriter.write("     int w3; d.v3++;       \n");
        stringWriter.write("  }                        \n");
        stringWriter.write("}                          \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("test.cpp", string);
        int n = string.indexOf("v1");
        int n2 = string.indexOf("v2");
        int n3 = string.indexOf("v3");
        RefactoringStatus refactoringStatus = this.checkConditions(iFile, n, "w1");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "par1");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "extern_var");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "var_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "enum_item");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "w2");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "par2");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "extern_var");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "var_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "enum_item");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "w3");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "par3");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "extern_var");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "var_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "enum_item");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "method");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "static_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "static_method");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "method");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "static_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "static_method");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "static_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "static_method");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "func_proto");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "func_proto_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "func_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "func_def_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "func_proto");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "func_proto_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "func_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "func_def_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "func_proto");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "func_proto_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "func_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "func_def_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "class_fwd");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "struct_fwd");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "union_fwd");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "class_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "struct_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "union_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "enum_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "typedef_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "namespace_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "st_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "un_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "class_fwd");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "struct_fwd");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "union_fwd");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "class_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "struct_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "union_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "enum_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "typedef_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "namespace_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "st_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "un_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "class_fwd");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "struct_fwd");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "union_fwd");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "class_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "struct_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "union_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "enum_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "typedef_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "namespace_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "st_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "un_member");
        this.assertRefactoringOk(refactoringStatus);
    }

    public void testReferenceViaMacro() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("#define PASSON(x) (x)         \n");
        stringWriter.write("#define INC(x) PASSON(/*pc*/x)++         \n");
        stringWriter.write("void f() {                 \n");
        stringWriter.write("   int v1;                  \n");
        stringWriter.write("   INC(/*comment*/ v1);                 \n");
        stringWriter.write("}                          \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("test.cpp", string);
        int n = string.indexOf("v1");
        int n2 = string.indexOf("v1", n + 1);
        Change change = this.getRefactorChanges(iFile, n2, "z");
        this.assertTotalChanges(2, change);
        this.assertChange(change, iFile, n, 2, "z");
        this.assertChange(change, iFile, n2, 2, "z");
    }

    public void testReferenceViaMacro2() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("#define INC(x,y) x+=y      \n");
        stringWriter.write("void f() {                 \n");
        stringWriter.write("   int v1,v2;              \n");
        stringWriter.write("   INC(v2,v1);             \n");
        stringWriter.write("}                          \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("test.cpp", string);
        int n = string.indexOf("v1");
        int n2 = string.indexOf("v1", n + 1);
        Change change = this.getRefactorChanges(iFile, n2, "z");
        this.assertTotalChanges(2, change);
        this.assertChange(change, iFile, n, 2, "z");
        this.assertChange(change, iFile, n2, 2, "z");
    }

    public void failReferenceViaMacro3() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("#define INC(x,y) x+=y      \n");
        stringWriter.write("void f() {                 \n");
        stringWriter.write("   int v1,v2;              \n");
        stringWriter.write("   INC(v1,v1);             \n");
        stringWriter.write("}                          \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("test.cpp", string);
        int n = string.indexOf("v1");
        Change change = this.getRefactorChanges(iFile, n, "z");
        this.assertTotalChanges(3, change);
        this.assertChange(change, iFile, n, 2, "z");
        n = string.indexOf("v1", n + 1);
        this.assertChange(change, iFile, n, 2, "z");
        n = string.indexOf("v1", n + 1);
        this.assertChange(change, iFile, n, 2, "z");
    }

    public void testReferenceViaMacro4() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("#define INC(x)   v2++      \n");
        stringWriter.write("void f() {                 \n");
        stringWriter.write("   int v1;                 \n");
        stringWriter.write("   INC(v1);                \n");
        stringWriter.write("}                          \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("test.cpp", string);
        int n = string.indexOf("v1");
        Change change = this.getRefactorChanges(iFile, n, "z");
        this.assertTotalChanges(1, 1, 0, change);
        this.assertChange(change, iFile, n, 2, "z");
    }

    public void testReferenceViaMacro5() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("#define INC(x)   v1++      \n");
        stringWriter.write("void f() {                 \n");
        stringWriter.write("   int v1,v2;              \n");
        stringWriter.write("   INC(v2);                \n");
        stringWriter.write("}                          \n");
        stringWriter.write("void f2() {                 \n");
        stringWriter.write("   int v12;                  \n");
        stringWriter.write("   INC(v12);                  \n");
        stringWriter.write("}                          \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("test.cpp", string);
        int n = string.indexOf("v1");
        n = string.indexOf("v1", n + 1);
        Change change = this.getRefactorChanges(iFile, n, "z");
        this.assertTotalChanges(1, change);
        this.assertChange(change, iFile, n, 2, "z");
    }

    public void testBug72646() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class C2: public C1 {     \n");
        stringWriter.write("  C2(int x, int y);       \n");
        stringWriter.write("  int y;                  \n");
        stringWriter.write("};                        \n");
        stringWriter.write("C2::C2(int x, int y)      \n");
        stringWriter.write("   :C1(x), y(y) {}        \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("test.cpp", string);
        int n = string.indexOf("y");
        n = string.indexOf("y", n + 1);
        Change change = this.getRefactorChanges(iFile, n, "z");
        this.assertTotalChanges(2, change);
        this.assertChange(change, iFile, n, 1, "z");
        n = string.indexOf("y", n + 1);
        n = string.indexOf("y", n + 1);
        this.assertChange(change, iFile, n, 1, "z");
    }
}

