/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.wizards;

import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jface.wizard.IWizardPage;

public final class MBSCustomPageData {
    private Set natureSet = null;
    private Set toolchainSet = null;
    private Set projectTypeSet = null;
    private IWizardPage wizardPage = null;
    private Runnable operation = null;
    private String id = null;
    private boolean isStock = false;

    public MBSCustomPageData(String id, IWizardPage wizardPage, Runnable operation, boolean isStock) {
        this.id = id;
        this.wizardPage = wizardPage;
        this.operation = operation;
        this.isStock = isStock;
    }

    public String getID() {
        return this.id;
    }

    public IWizardPage getWizardPage() {
        return this.wizardPage;
    }

    public boolean isStockPage() {
        return this.isStock;
    }

    public boolean shouldBeVisibleForNature(String nature) {
        if (this.natureSet == null) {
            return true;
        }
        return this.hasNature(nature);
    }

    private boolean hasNature(String nature) {
        return this.natureSet.contains(nature);
    }

    public String[] getNatures() {
        Object[] objArray = this.natureSet.toArray();
        String[] strArray = new String[objArray.length];
        int k = 0;
        while (k < objArray.length) {
            strArray[k] = objArray[k].toString();
            ++k;
        }
        return strArray;
    }

    public boolean shouldBeVisibleForToolchain(String id, String version) {
        if (this.toolchainSet.size() == 0) {
            return true;
        }
        Iterator iterator = this.toolchainSet.iterator();
        while (iterator.hasNext()) {
            ToolchainData tcd = (ToolchainData)iterator.next();
            if (!tcd.getId().equals(id)) continue;
            if (tcd.getVersionsSupported() == null) {
                return true;
            }
            int k = 0;
            while (k < tcd.getVersionsSupported().length) {
                if (tcd.getVersionsSupported()[k].equals(version)) {
                    return true;
                }
                ++k;
            }
        }
        return false;
    }

    public ToolchainData[] getToolchains() {
        if (this.toolchainSet == null) {
            return null;
        }
        ToolchainData[] tcd = new ToolchainData[this.toolchainSet.size()];
        Iterator iterator = this.toolchainSet.iterator();
        int k = 0;
        while (iterator.hasNext()) {
            tcd[k++] = (ToolchainData)iterator.next();
        }
        if (tcd.length > 0) {
            return tcd;
        }
        return null;
    }

    public String[] getProjectTypes() {
        if (this.projectTypeSet == null || this.projectTypeSet.size() == 0) {
            return null;
        }
        Object[] objArray = this.projectTypeSet.toArray();
        String[] strArray = new String[objArray.length];
        int k = 0;
        while (k < objArray.length) {
            strArray[k] = objArray[k].toString();
            ++k;
        }
        return strArray;
    }

    public void addNature(String nature) {
        if (nature == null) {
            return;
        }
        if (this.natureSet == null) {
            this.natureSet = new TreeSet();
        }
        this.natureSet.add(nature);
    }

    public void addToolchain(String toolchainID, String[] versionsSupported) {
        if (toolchainID == null) {
            return;
        }
        if (this.toolchainSet == null) {
            this.toolchainSet = new TreeSet();
        }
        ToolchainData toolchainData = new ToolchainData();
        toolchainData.setId(toolchainID);
        toolchainData.setVersionsSupported(versionsSupported);
        this.toolchainSet.add(toolchainData);
    }

    public boolean shouldBeVisibleForProjectType(String projectType) {
        if (this.projectTypeSet == null) {
            return true;
        }
        return this.projectTypeSet.contains(projectType);
    }

    public void addProjectType(String projectType) {
        if (projectType == null) {
            return;
        }
        if (this.projectTypeSet == null) {
            this.projectTypeSet = new TreeSet();
        }
        this.projectTypeSet.add(projectType);
    }

    public Runnable getOperation() {
        return this.operation;
    }

    public class ToolchainData {
        private String id = null;
        private String[] versionsSupported = null;

        public void setId(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public void setVersionsSupported(String[] versionsSupported) {
            this.versionsSupported = versionsSupported;
        }

        public String[] getVersionsSupported() {
            return this.versionsSupported;
        }
    }
}

