/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.model.util;

import org.eclipse.cdt.internal.core.CharOperation;

public final class Signature {
    public static final char C_BOOLEAN = 'Z';
    public static final char C_BYTE = 'B';
    public static final char C_CHAR = 'C';
    public static final char C_DOUBLE = 'D';
    public static final char C_FLOAT = 'F';
    public static final char C_INT = 'I';
    public static final char C_SEMICOLON = ';';
    public static final char C_COLON = ':';
    public static final char C_LONG = 'J';
    public static final char C_SHORT = 'S';
    public static final char C_VOID = 'V';
    public static final char C_CONST = 'K';
    public static final char C_TYPE_VARIABLE = 'T';
    public static final char C_STAR = '*';
    public static final char C_DOT = '.';
    public static final char C_DOLLAR = '$';
    public static final char C_ARRAY = '[';
    public static final char C_RESOLVED = 'L';
    public static final char C_UNRESOLVED = 'Q';
    public static final char C_NAME_END = ';';
    public static final char C_PARAM_START = '(';
    public static final char C_PARAM_END = ')';
    public static final char C_GENERIC_START = '<';
    public static final char C_GENERIC_END = '>';
    public static final String SIG_BOOLEAN = "Z";
    public static final String SIG_BYTE = "B";
    public static final String SIG_CHAR = "C";
    public static final String SIG_DOUBLE = "D";
    public static final String SIG_FLOAT = "F";
    public static final String SIG_INT = "I";
    public static final String SIG_LONG = "J";
    public static final String SIG_SHORT = "S";
    public static final String SIG_VOID = "V";
    public static int CLASS_TYPE_SIGNATURE = 1;
    public static int BASE_TYPE_SIGNATURE = 2;
    public static int TYPE_VARIABLE_SIGNATURE = 3;
    public static int ARRAY_TYPE_SIGNATURE = 4;
    private static final char[] BOOLEAN = new char[]{'b', 'o', 'o', 'l', 'e', 'a', 'n'};
    private static final char[] BYTE = new char[]{'b', 'y', 't', 'e'};
    private static final char[] CHAR = new char[]{'c', 'h', 'a', 'r'};
    private static final char[] DOUBLE = new char[]{'d', 'o', 'u', 'b', 'l', 'e'};
    private static final char[] FLOAT = new char[]{'f', 'l', 'o', 'a', 't'};
    private static final char[] INT = new char[]{'i', 'n', 't'};
    private static final char[] LONG = new char[]{'l', 'o', 'n', 'g'};
    private static final char[] SHORT = new char[]{'s', 'h', 'o', 'r', 't'};
    private static final char[] VOID = new char[]{'v', 'o', 'i', 'd'};
    private static final char[] CONST = new char[]{'c', 'o', 'n', 's', 't'};
    private static final String EMPTY = new String(CharOperation.NO_CHAR);

    private Signature() {
    }

    private static boolean checkPrimitiveType(char[] primitiveTypeName, char[] typeName) {
        return CharOperation.fragmentEquals(primitiveTypeName, typeName, 0, true) && (typeName.length == primitiveTypeName.length || Character.isWhitespace(typeName[primitiveTypeName.length]) || typeName[primitiveTypeName.length] == '[' || typeName[primitiveTypeName.length] == '.');
    }

    public static char[] createArraySignature(char[] typeSignature, int arrayCount) {
        if (arrayCount == 0) {
            return typeSignature;
        }
        int sigLength = typeSignature.length;
        char[] result = new char[arrayCount + sigLength];
        int i = 0;
        while (i < arrayCount) {
            result[i] = 91;
            ++i;
        }
        System.arraycopy(typeSignature, 0, result, arrayCount, sigLength);
        return result;
    }

    public static String createArraySignature(String typeSignature, int arrayCount) {
        return new String(Signature.createArraySignature(typeSignature.toCharArray(), arrayCount));
    }

    public static char[] createMethodSignature(char[][] parameterTypes, char[] returnType) {
        int parameterTypesLength = parameterTypes.length;
        int parameterLength = 0;
        int i = 0;
        while (i < parameterTypesLength) {
            parameterLength += parameterTypes[i].length;
            ++i;
        }
        int returnTypeLength = returnType.length;
        char[] result = new char[1 + parameterLength + 1 + returnTypeLength];
        result[0] = 40;
        int index = 1;
        int i2 = 0;
        while (i2 < parameterTypesLength) {
            char[] parameterType = parameterTypes[i2];
            int length = parameterType.length;
            System.arraycopy(parameterType, 0, result, index, length);
            index += length;
            ++i2;
        }
        result[index] = 41;
        System.arraycopy(returnType, 0, result, index + 1, returnTypeLength);
        return result;
    }

    public static String createMethodSignature(String[] parameterTypes, String returnType) {
        int parameterTypesLenth = parameterTypes.length;
        char[][] parameters = new char[parameterTypesLenth][];
        int i = 0;
        while (i < parameterTypesLenth) {
            parameters[i] = parameterTypes[i].toCharArray();
            ++i;
        }
        return new String(Signature.createMethodSignature(parameters, returnType.toCharArray()));
    }

    public static String createTypeSignature(char[] typeName, boolean isResolved) {
        return new String(Signature.createCharArrayTypeSignature(typeName, isResolved));
    }

    public static char[] createCharArrayTypeSignature(char[] typeName, boolean isResolved) {
        char[] sig;
        if (typeName == null) {
            throw new IllegalArgumentException("null");
        }
        int length = typeName.length;
        if (length == 0) {
            throw new IllegalArgumentException(new String(typeName));
        }
        int arrayCount = CharOperation.occurencesOf('[', typeName);
        switch (typeName[0]) {
            case 'b': {
                if (Signature.checkPrimitiveType(BOOLEAN, typeName)) {
                    sig = new char[arrayCount + 1];
                    sig[arrayCount] = 90;
                    break;
                }
                if (Signature.checkPrimitiveType(BYTE, typeName)) {
                    sig = new char[arrayCount + 1];
                    sig[arrayCount] = 66;
                    break;
                }
            }
            case 'c': {
                if (Signature.checkPrimitiveType(CHAR, typeName)) {
                    sig = new char[arrayCount + 1];
                    sig[arrayCount] = 67;
                    break;
                }
            }
            case 'd': {
                if (Signature.checkPrimitiveType(DOUBLE, typeName)) {
                    sig = new char[arrayCount + 1];
                    sig[arrayCount] = 68;
                    break;
                }
            }
            case 'f': {
                if (Signature.checkPrimitiveType(FLOAT, typeName)) {
                    sig = new char[arrayCount + 1];
                    sig[arrayCount] = 70;
                    break;
                }
            }
            case 'i': {
                if (Signature.checkPrimitiveType(INT, typeName)) {
                    sig = new char[arrayCount + 1];
                    sig[arrayCount] = 73;
                    break;
                }
            }
            case 'l': {
                if (Signature.checkPrimitiveType(LONG, typeName)) {
                    sig = new char[arrayCount + 1];
                    sig[arrayCount] = 74;
                    break;
                }
            }
            case 's': {
                if (Signature.checkPrimitiveType(SHORT, typeName)) {
                    sig = new char[arrayCount + 1];
                    sig[arrayCount] = 83;
                    break;
                }
            }
            case 'v': {
                if (Signature.checkPrimitiveType(VOID, typeName)) {
                    sig = new char[arrayCount + 1];
                    sig[arrayCount] = 86;
                    break;
                }
            }
            default: {
                int sigLength = arrayCount + 1 + length + 1;
                sig = new char[sigLength];
                int sigIndex = arrayCount + 1;
                int startID = 0;
                int index = 0;
                while (index < length) {
                    char currentChar = typeName[index];
                    switch (currentChar) {
                        case '.': {
                            if (startID == -1) {
                                throw new IllegalArgumentException(new String(typeName));
                            }
                            if (startID < index) {
                                sig = CharOperation.append(sig, sigIndex, typeName, startID, index);
                                sigIndex += index - startID;
                            }
                            sig[sigIndex++] = 46;
                            startID = ++index;
                            break;
                        }
                        case '[': {
                            if (startID != -1) {
                                if (startID < index) {
                                    sig = CharOperation.append(sig, sigIndex, typeName, startID, index);
                                    sigIndex += index - startID;
                                }
                                startID = -1;
                            }
                            ++index;
                            break;
                        }
                        default: {
                            if (startID != -1 && CharOperation.isWhitespace(currentChar)) {
                                if (startID < index) {
                                    sig = CharOperation.append(sig, sigIndex, typeName, startID, index);
                                    sigIndex += index - startID;
                                }
                                startID = index + 1;
                            }
                            ++index;
                        }
                    }
                }
                if (startID != -1 && startID < index) {
                    sig = CharOperation.append(sig, sigIndex, typeName, startID, index);
                    sigIndex += index - startID;
                }
                sig[arrayCount] = isResolved ? 76 : 81;
                sig[sigIndex++] = 59;
                if (sigLength <= sigIndex) break;
                char[] cArray = sig;
                sig = new char[sigIndex];
                System.arraycopy(cArray, 0, sig, 0, sigIndex);
            }
        }
        int i = 0;
        while (i < arrayCount) {
            sig[i] = 91;
            ++i;
        }
        return sig;
    }

    public static String createTypeSignature(String typeName, boolean isResolved) {
        return Signature.createTypeSignature(typeName == null ? null : typeName.toCharArray(), isResolved);
    }

    public static int getArrayCount(char[] typeSignature) throws IllegalArgumentException {
        try {
            int count = 0;
            while (typeSignature[count] == '[') {
                ++count;
            }
            return count;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException();
        }
    }

    public static int getArrayCount(String typeSignature) throws IllegalArgumentException {
        return Signature.getArrayCount(typeSignature.toCharArray());
    }

    public static char[] getElementType(char[] typeSignature) throws IllegalArgumentException {
        int count = Signature.getArrayCount(typeSignature);
        if (count == 0) {
            return typeSignature;
        }
        int length = typeSignature.length;
        char[] result = new char[length - count];
        System.arraycopy(typeSignature, count, result, 0, length - count);
        return result;
    }

    public static String getElementType(String typeSignature) throws IllegalArgumentException {
        return new String(Signature.getElementType(typeSignature.toCharArray()));
    }

    public static int getParameterCount(char[] methodSignature) throws IllegalArgumentException {
        try {
            int count = 0;
            int i = CharOperation.indexOf('(', methodSignature);
            if (i < 0) {
                throw new IllegalArgumentException();
            }
            ++i;
            while (true) {
                if (methodSignature[i] == ')') {
                    return count;
                }
                int e = Signature.scanTypeSignature(methodSignature, i);
                if (e < 0) {
                    throw new IllegalArgumentException();
                }
                i = e + 1;
                ++count;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException();
        }
    }

    public static int getTypeSignatureKind(char[] typeSignature) {
        if (typeSignature.length < 1) {
            throw new IllegalArgumentException();
        }
        char c = typeSignature[0];
        switch (c) {
            case '[': {
                return ARRAY_TYPE_SIGNATURE;
            }
            case 'L': 
            case 'Q': {
                return CLASS_TYPE_SIGNATURE;
            }
            case 'T': {
                return TYPE_VARIABLE_SIGNATURE;
            }
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'V': 
            case 'Z': {
                return BASE_TYPE_SIGNATURE;
            }
        }
        throw new IllegalArgumentException();
    }

    public static int getTypeSignatureKind(String typeSignature) {
        if (typeSignature.length() < 1) {
            throw new IllegalArgumentException();
        }
        char c = typeSignature.charAt(0);
        switch (c) {
            case '[': {
                return ARRAY_TYPE_SIGNATURE;
            }
            case 'L': 
            case 'Q': {
                return CLASS_TYPE_SIGNATURE;
            }
            case 'T': {
                return TYPE_VARIABLE_SIGNATURE;
            }
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'V': 
            case 'Z': {
                return BASE_TYPE_SIGNATURE;
            }
        }
        throw new IllegalArgumentException();
    }

    private static int scanTypeSignature(char[] string, int start) {
        if (start >= string.length) {
            throw new IllegalArgumentException();
        }
        char c = string[start];
        switch (c) {
            case '[': {
                return Signature.scanArrayTypeSignature(string, start);
            }
            case 'L': 
            case 'Q': {
                return Signature.scanClassTypeSignature(string, start);
            }
            case 'T': {
                return Signature.scanTypeVariableSignature(string, start);
            }
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'V': 
            case 'Z': {
                return Signature.scanBaseTypeSignature(string, start);
            }
        }
        throw new IllegalArgumentException();
    }

    private static int scanBaseTypeSignature(char[] string, int start) {
        if (start >= string.length) {
            throw new IllegalArgumentException();
        }
        char c = string[start];
        if ("BCDFIJSVZ".indexOf(c) >= 0) {
            return start;
        }
        throw new IllegalArgumentException();
    }

    private static int scanArrayTypeSignature(char[] string, int start) {
        if (start >= string.length - 1) {
            throw new IllegalArgumentException();
        }
        char c = string[start];
        if (c != '[') {
            throw new IllegalArgumentException();
        }
        return Signature.scanTypeSignature(string, start + 1);
    }

    private static int scanTypeVariableSignature(char[] string, int start) {
        if (start >= string.length - 2) {
            throw new IllegalArgumentException();
        }
        char c = string[start];
        if (c != 'T') {
            throw new IllegalArgumentException();
        }
        int id = Signature.scanIdentifier(string, start + 1);
        c = string[id + 1];
        if (c == ';') {
            return id + 1;
        }
        throw new IllegalArgumentException();
    }

    private static int scanIdentifier(char[] string, int start) {
        if (start >= string.length) {
            throw new IllegalArgumentException();
        }
        int p = start;
        do {
            char c;
            if ((c = string[p]) != '<' && c != '>' && c != ':' && c != ';' && c != '.' && c != '/') continue;
            return p - 1;
        } while (++p != string.length);
        return p - 1;
    }

    private static int scanClassTypeSignature(char[] string, int start) {
        if (start >= string.length - 2) {
            throw new IllegalArgumentException();
        }
        char c = string[start];
        if (c != 'L' && c != 'Q') {
            return -1;
        }
        int p = start + 1;
        while (true) {
            if (p >= string.length) {
                throw new IllegalArgumentException();
            }
            c = string[p];
            if (c == ';') {
                return p;
            }
            if (c == '<') {
                int e;
                p = e = Signature.scanTypeArgumentSignatures(string, p);
            } else if (c == '.' || c == '/') {
                int id;
                p = id = Signature.scanIdentifier(string, p + 1);
            }
            ++p;
        }
    }

    private static int scanTypeArgumentSignatures(char[] string, int start) {
        if (start >= string.length - 1) {
            throw new IllegalArgumentException();
        }
        char c = string[start];
        if (c != '<') {
            throw new IllegalArgumentException();
        }
        int p = start + 1;
        while (true) {
            if (p >= string.length) {
                throw new IllegalArgumentException();
            }
            c = string[p];
            if (c == '>') {
                return p;
            }
            int e = Signature.scanTypeArgumentSignature(string, p);
            p = e + 1;
        }
    }

    private static int scanTypeArgumentSignature(char[] string, int start) {
        if (start >= string.length) {
            throw new IllegalArgumentException();
        }
        char c = string[start];
        if (c == '*') {
            return start;
        }
        if (c == '+' || c == '-') {
            return Signature.scanTypeSignature(string, start + 1);
        }
        return Signature.scanTypeSignature(string, start);
    }

    public static int getParameterCount(String methodSignature) throws IllegalArgumentException {
        return Signature.getParameterCount(methodSignature.toCharArray());
    }

    public static char[][] getParameterTypes(char[] methodSignature) throws IllegalArgumentException {
        try {
            int count = Signature.getParameterCount(methodSignature);
            char[][] result = new char[count][];
            if (count == 0) {
                return result;
            }
            int i = CharOperation.indexOf('(', methodSignature);
            if (i < 0) {
                throw new IllegalArgumentException();
            }
            ++i;
            int t = 0;
            while (true) {
                if (methodSignature[i] == ')') {
                    return result;
                }
                int e = Signature.scanTypeSignature(methodSignature, i);
                if (e < 0) {
                    throw new IllegalArgumentException();
                }
                result[t] = CharOperation.subarray(methodSignature, i, e + 1);
                ++t;
                i = e + 1;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException();
        }
    }

    public static String[] getParameterTypes(String methodSignature) throws IllegalArgumentException {
        char[][] parameterTypes = Signature.getParameterTypes(methodSignature.toCharArray());
        int length = parameterTypes.length;
        String[] result = new String[length];
        int i = 0;
        while (i < length) {
            result[i] = new String(parameterTypes[i]);
            ++i;
        }
        return result;
    }

    public static String getTypeVariable(String formalTypeParameterSignature) throws IllegalArgumentException {
        return new String(Signature.getTypeVariable(formalTypeParameterSignature.toCharArray()));
    }

    public static char[] getTypeVariable(char[] formalTypeParameterSignature) throws IllegalArgumentException {
        int p = CharOperation.indexOf(':', formalTypeParameterSignature);
        if (p < 0) {
            throw new IllegalArgumentException();
        }
        return CharOperation.subarray(formalTypeParameterSignature, 0, p);
    }

    public static char[][] getTypeParameterBounds(char[] formalTypeParameterSignature) throws IllegalArgumentException {
        int p1 = CharOperation.indexOf(':', formalTypeParameterSignature);
        if (p1 < 0) {
            throw new IllegalArgumentException();
        }
        if (p1 == formalTypeParameterSignature.length - 1) {
            return CharOperation.NO_CHAR_CHAR;
        }
        int p2 = CharOperation.indexOf(':', formalTypeParameterSignature, p1 + 1);
        if (p2 < 0) {
            char[] classBound = CharOperation.subarray(formalTypeParameterSignature, p1 + 1, formalTypeParameterSignature.length);
            return new char[][]{classBound};
        }
        char[] classBound = p2 == p1 + 1 ? (char[])null : CharOperation.subarray(formalTypeParameterSignature, p1 + 1, p2);
        char[][] interfaceBounds = CharOperation.splitOn(':', formalTypeParameterSignature, p2 + 1, formalTypeParameterSignature.length);
        if (classBound == null) {
            return interfaceBounds;
        }
        int resultLength = interfaceBounds.length + 1;
        char[][] result = new char[resultLength][];
        result[0] = classBound;
        System.arraycopy(interfaceBounds, 0, result, 1, interfaceBounds.length);
        return result;
    }

    public static String[] getTypeParameterBounds(String formalTypeParameterSignature) throws IllegalArgumentException {
        char[][] bounds = Signature.getTypeParameterBounds(formalTypeParameterSignature.toCharArray());
        int length = bounds.length;
        String[] result = new String[length];
        int i = 0;
        while (i < length) {
            result[i] = new String(bounds[i]);
            ++i;
        }
        return result;
    }

    public static char[] getQualifier(char[] name) {
        int lastDot = CharOperation.lastIndexOf('.', name);
        if (lastDot == -1) {
            return CharOperation.NO_CHAR;
        }
        return CharOperation.subarray(name, 0, lastDot);
    }

    public static String getQualifier(String name) {
        int lastDot = name.lastIndexOf(46);
        if (lastDot == -1) {
            return EMPTY;
        }
        return name.substring(0, lastDot);
    }

    public static char[] getReturnType(char[] methodSignature) throws IllegalArgumentException {
        int i = CharOperation.lastIndexOf(')', methodSignature);
        if (i == -1) {
            throw new IllegalArgumentException();
        }
        int j = CharOperation.indexOf('^', methodSignature);
        int last = j == -1 ? methodSignature.length : j;
        return CharOperation.subarray(methodSignature, i + 1, last);
    }

    public static String getReturnType(String methodSignature) throws IllegalArgumentException {
        return new String(Signature.getReturnType(methodSignature.toCharArray()));
    }

    public static char[] getSimpleName(char[] name) {
        int lastDot = CharOperation.lastIndexOf('.', name);
        if (lastDot == -1) {
            return name;
        }
        return CharOperation.subarray(name, lastDot + 1, name.length);
    }

    public static String getSimpleName(String name) {
        int lastDot = name.lastIndexOf(46);
        if (lastDot == -1) {
            return name;
        }
        return name.substring(lastDot + 1, name.length());
    }

    public static char[][] getSimpleNames(char[] name) {
        if (name.length == 0) {
            return CharOperation.NO_CHAR_CHAR;
        }
        int dot = CharOperation.indexOf('.', name);
        if (dot == -1) {
            return new char[][]{name};
        }
        int n = 1;
        while ((dot = CharOperation.indexOf('.', name, dot + 1)) != -1) {
            ++n;
        }
        char[][] result = new char[n + 1][];
        int segStart = 0;
        int i = 0;
        while (i < n) {
            dot = CharOperation.indexOf('.', name, segStart);
            result[i] = CharOperation.subarray(name, segStart, dot);
            segStart = dot + 1;
            ++i;
        }
        result[n] = CharOperation.subarray(name, segStart, name.length);
        return result;
    }

    public static String[] getSimpleNames(String name) {
        char[][] simpleNames = Signature.getSimpleNames(name.toCharArray());
        int length = simpleNames.length;
        String[] result = new String[length];
        int i = 0;
        while (i < length) {
            result[i] = new String(simpleNames[i]);
            ++i;
        }
        return result;
    }

    public static char[] toCharArray(char[] methodSignature, char[] methodName, char[][] parameterNames, boolean fullyQualifyTypeNames, boolean includeReturnType) {
        int firstParen = CharOperation.indexOf('(', methodSignature);
        if (firstParen == -1) {
            throw new IllegalArgumentException();
        }
        StringBuffer buffer = new StringBuffer(methodSignature.length + 10);
        if (includeReturnType) {
            char[] rts = Signature.getReturnType(methodSignature);
            Signature.appendTypeSignature(rts, 0, fullyQualifyTypeNames, buffer);
            buffer.append(' ');
        }
        if (methodName != null) {
            buffer.append(methodName);
        }
        buffer.append('(');
        char[][] pts = Signature.getParameterTypes(methodSignature);
        int i = 0;
        while (i < pts.length) {
            Signature.appendTypeSignature(pts[i], 0, fullyQualifyTypeNames, buffer);
            if (parameterNames != null) {
                buffer.append(' ');
                buffer.append(parameterNames[i]);
            }
            if (i != pts.length - 1) {
                buffer.append(',');
                buffer.append(' ');
            }
            ++i;
        }
        buffer.append(')');
        char[] result = new char[buffer.length()];
        buffer.getChars(0, buffer.length(), result, 0);
        return result;
    }

    public static char[] toCharArray(char[] signature) throws IllegalArgumentException {
        int sigLength = signature.length;
        if (sigLength == 0 || signature[0] == '(' || signature[0] == '<') {
            return Signature.toCharArray(signature, CharOperation.NO_CHAR, null, true, true);
        }
        StringBuffer buffer = new StringBuffer(signature.length + 10);
        Signature.appendTypeSignature(signature, 0, true, buffer);
        char[] result = new char[buffer.length()];
        buffer.getChars(0, buffer.length(), result, 0);
        return result;
    }

    private static int appendTypeSignature(char[] string, int start, boolean fullyQualifyTypeNames, StringBuffer buffer) {
        if (start >= string.length) {
            throw new IllegalArgumentException();
        }
        char c = string[start];
        switch (c) {
            case '[': {
                return Signature.appendArrayTypeSignature(string, start, fullyQualifyTypeNames, buffer);
            }
            case 'L': 
            case 'Q': {
                return Signature.appendClassTypeSignature(string, start, fullyQualifyTypeNames, buffer);
            }
            case 'T': {
                int e = Signature.scanTypeVariableSignature(string, start);
                buffer.append(CharOperation.subarray(string, start + 1, e));
                return e;
            }
            case 'Z': {
                buffer.append(BOOLEAN);
                return start;
            }
            case 'B': {
                buffer.append(BYTE);
                return start;
            }
            case 'C': {
                buffer.append(CHAR);
                return start;
            }
            case 'D': {
                buffer.append(DOUBLE);
                return start;
            }
            case 'F': {
                buffer.append(FLOAT);
                return start;
            }
            case 'I': {
                buffer.append(INT);
                return start;
            }
            case 'J': {
                buffer.append(LONG);
                return start;
            }
            case 'S': {
                buffer.append(SHORT);
                return start;
            }
            case 'V': {
                buffer.append(VOID);
                return start;
            }
            case 'K': {
                buffer.append(CONST);
                return start;
            }
        }
        throw new IllegalArgumentException();
    }

    private static int appendArrayTypeSignature(char[] string, int start, boolean fullyQualifyTypeNames, StringBuffer buffer) {
        if (start >= string.length - 1) {
            throw new IllegalArgumentException();
        }
        char c = string[start];
        if (c != '[') {
            throw new IllegalArgumentException();
        }
        int e = Signature.appendTypeSignature(string, start + 1, fullyQualifyTypeNames, buffer);
        buffer.append('[');
        buffer.append(']');
        return e;
    }

    private static int appendClassTypeSignature(char[] string, int start, boolean fullyQualifyTypeNames, StringBuffer buffer) {
        boolean removePackageQualifiers;
        if (start >= string.length - 2) {
            throw new IllegalArgumentException();
        }
        char c = string[start];
        if (c != 'L' && c != 'Q') {
            throw new IllegalArgumentException();
        }
        boolean resolved = c == 'L';
        boolean bl = removePackageQualifiers = !fullyQualifyTypeNames;
        if (!resolved) {
            removePackageQualifiers = false;
        }
        int p = start + 1;
        int checkpoint = buffer.length();
        while (true) {
            if (p >= string.length) {
                throw new IllegalArgumentException();
            }
            c = string[p];
            switch (c) {
                case ';': {
                    return p;
                }
                case '<': {
                    int e = Signature.appendTypeArgumentSignatures(string, p, fullyQualifyTypeNames, buffer);
                    removePackageQualifiers = false;
                    p = e;
                    break;
                }
                case '.': {
                    if (removePackageQualifiers) {
                        buffer.setLength(checkpoint);
                        break;
                    }
                    buffer.append('.');
                    break;
                }
                case '/': {
                    if (removePackageQualifiers) {
                        buffer.setLength(checkpoint);
                        break;
                    }
                    buffer.append('/');
                    break;
                }
                case '$': {
                    if (!resolved) break;
                    removePackageQualifiers = false;
                    buffer.append('.');
                    break;
                }
                default: {
                    buffer.append(c);
                }
            }
            ++p;
        }
    }

    private static int appendTypeArgumentSignatures(char[] string, int start, boolean fullyQualifyTypeNames, StringBuffer buffer) {
        if (start >= string.length - 1) {
            throw new IllegalArgumentException();
        }
        char c = string[start];
        if (c != '<') {
            throw new IllegalArgumentException();
        }
        buffer.append('<');
        int p = start + 1;
        int count = 0;
        while (true) {
            if (p >= string.length) {
                throw new IllegalArgumentException();
            }
            c = string[p];
            if (c == '>') {
                buffer.append('>');
                return p;
            }
            if (count != 0) {
                buffer.append(',');
            }
            int e = Signature.appendTypeArgumentSignature(string, p, fullyQualifyTypeNames, buffer);
            ++count;
            p = e + 1;
        }
    }

    private static int appendTypeArgumentSignature(char[] string, int start, boolean fullyQualifyTypeNames, StringBuffer buffer) {
        if (start >= string.length) {
            throw new IllegalArgumentException();
        }
        char c = string[start];
        switch (c) {
            case '*': {
                buffer.append('?');
                return start;
            }
            case '+': {
                buffer.append("? extends ");
                return Signature.appendTypeSignature(string, start + 1, fullyQualifyTypeNames, buffer);
            }
            case '-': {
                buffer.append("? super ");
                return Signature.appendTypeSignature(string, start + 1, fullyQualifyTypeNames, buffer);
            }
        }
        return Signature.appendTypeSignature(string, start, fullyQualifyTypeNames, buffer);
    }

    public static char[] toQualifiedName(char[][] segments) {
        int length = segments.length;
        if (length == 0) {
            return CharOperation.NO_CHAR;
        }
        if (length == 1) {
            return segments[0];
        }
        int resultLength = 0;
        int i = 0;
        while (i < length) {
            resultLength += segments[i].length + 1;
            ++i;
        }
        char[] result = new char[--resultLength];
        int index = 0;
        int i2 = 0;
        while (i2 < length) {
            char[] segment = segments[i2];
            int segmentLength = segment.length;
            System.arraycopy(segment, 0, result, index, segmentLength);
            index += segmentLength;
            if (i2 != length - 1) {
                result[index++] = 46;
            }
            ++i2;
        }
        return result;
    }

    public static String toQualifiedName(String[] segments) {
        int length = segments.length;
        char[][] charArrays = new char[length][];
        int i = 0;
        while (i < length) {
            charArrays[i] = segments[i].toCharArray();
            ++i;
        }
        return new String(Signature.toQualifiedName(charArrays));
    }

    public static String toString(String signature) throws IllegalArgumentException {
        return new String(Signature.toCharArray(signature.toCharArray()));
    }

    public static String toString(String methodSignature, String methodName, String[] parameterNames, boolean fullyQualifyTypeNames, boolean includeReturnType) {
        Object params;
        if (parameterNames == null) {
            params = null;
        } else {
            int paramLength = parameterNames.length;
            params = new char[paramLength][];
            int i = 0;
            while (i < paramLength) {
                params[i] = parameterNames[i].toCharArray();
                ++i;
            }
        }
        return new String(Signature.toCharArray(methodSignature.toCharArray(), methodName == null ? null : methodName.toCharArray(), params, fullyQualifyTypeNames, includeReturnType));
    }
}

