/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner2;

import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTFunctionStyleMacroParameter;
import org.eclipse.cdt.core.dom.ast.IASTMacroExpansion;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorElifStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorElseStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorEndifStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorErrorStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorFunctionStyleMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIfdefStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIfndefStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIncludeStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorObjectStyleMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorPragmaStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorUndefStatement;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IMacroBinding;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IMacro;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ASTPreprocessorSelectionResult;
import org.eclipse.cdt.internal.core.parser.scanner2.DependencyTree;
import org.eclipse.cdt.internal.core.parser.scanner2.DynamicFunctionStyleMacro;
import org.eclipse.cdt.internal.core.parser.scanner2.DynamicStyleMacro;
import org.eclipse.cdt.internal.core.parser.scanner2.FunctionStyleMacro;
import org.eclipse.cdt.internal.core.parser.scanner2.IDependencyNodeHost;
import org.eclipse.cdt.internal.core.parser.scanner2.ILocationResolver;
import org.eclipse.cdt.internal.core.parser.scanner2.IScannerPreprocessorLog;
import org.eclipse.cdt.internal.core.parser.scanner2.InclusionNode;
import org.eclipse.cdt.internal.core.parser.scanner2.InvalidPreprocessorNodeException;
import org.eclipse.cdt.internal.core.parser.scanner2.MacroBinding;
import org.eclipse.cdt.internal.core.parser.scanner2.ObjectStyleMacro;
import org.eclipse.cdt.internal.core.parser.scanner2.ScannerASTProblem;

public class LocationMap
implements ILocationResolver,
IScannerPreprocessorLog {
    private static final String NOT_VALID_MACRO = "Not a valid macro selection";
    private static final String TU_INCLUDE_NOT_FOUND = "File searching does not match TU or #includes.";
    protected _TranslationUnit tu = new _TranslationUnit();
    protected _CompositeContext currentContext = this.tu;
    private static final IASTProblem[] EMPTY_PROBLEMS_ARRAY = new IASTProblem[0];
    private static final IASTNodeLocation[] EMPTY_LOCATION_ARRAY = new IASTNodeLocation[0];
    private static final IASTPreprocessorMacroDefinition[] EMPTY_MACRO_DEFINITIONS_ARRAY = new IASTPreprocessorMacroDefinition[0];
    private static final IASTPreprocessorIncludeStatement[] EMPTY_INCLUDES_ARRAY = new IASTPreprocessorIncludeStatement[0];
    private static final IASTPreprocessorStatement[] EMPTY_PREPROCESSOR_ARRAY = new IASTPreprocessorStatement[0];
    protected static final int V_ALL = 1;
    protected static final int V_INCLUSIONS = 2;
    protected static final int V_PROBLEMS = 3;
    protected static final int V_MACRODEFS = 4;
    protected static final int V_PREPROCESSOR = 5;
    protected static final int V_MACRODEFSUNDEFS = 6;
    private static final char[] EMPTY_CHAR_ARRAY = "".toCharArray();
    private static final IASTName[] EMPTY_NAME_ARRAY = new IASTName[0];
    protected IASTTranslationUnit rootNode;
    private static final String EMPTY_STRING = "";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public IASTPreprocessorMacroDefinition[] getMacroDefinitions() {
        int size = LocationMap.collectContexts(4, this.tu, null, 0);
        if (size == 0) {
            return EMPTY_MACRO_DEFINITIONS_ARRAY;
        }
        _Context[] contexts = new _Context[size];
        LocationMap.collectContexts(4, this.tu, contexts, 0);
        IASTPreprocessorMacroDefinition[] result = new IASTPreprocessorMacroDefinition[contexts.length];
        int i = 0;
        while (i < contexts.length) {
            result[i] = this.createASTMacroDefinition((_MacroDefinition)contexts[i]);
            ++i;
        }
        return result;
    }

    public IMacroBinding resolveBindingForMacro(char[] name, int offset) {
        _Context search = this.findContextForOffset(offset);
        IScannerPreprocessorLog.IMacroDefinition macroDefinition = null;
        if (search instanceof _MacroDefinition) {
            _MacroDefinition macroDef = (_MacroDefinition)search;
            if (CharArrayUtils.equals(name, macroDef.name) && offset == macroDef.nameOffset) {
                macroDefinition = macroDef;
            }
        } else if (search instanceof _MacroExpansion) {
            _MacroExpansion expansion = (_MacroExpansion)search;
            macroDefinition = expansion.definition;
        }
        if (macroDefinition == null) {
            return null;
        }
        if (macroDefinition.getBinding() == null) {
            macroDefinition.setBinding(new MacroBinding(name, this.rootNode.getScope(), macroDefinition));
        }
        return macroDefinition.getBinding();
    }

    private IASTPreprocessorMacroDefinition createASTMacroDefinition(_MacroDefinition d) {
        ASTNode r = null;
        if (d instanceof _ObjectMacroDefinition) {
            r = new ASTObjectMacro();
        } else if (d instanceof _FunctionMacroDefinition) {
            ASTFunctionMacro f = new ASTFunctionMacro();
            char[][] parms = ((_FunctionMacroDefinition)d).getParms();
            int j = 0;
            while (j < parms.length) {
                ASTFunctionMacroParameter parm = new ASTFunctionMacroParameter();
                parm.setParameter(new String(parms[j]));
                f.addParameter(parm);
                parm.setParent(f);
                parm.setPropertyInParent(IASTPreprocessorFunctionStyleMacroDefinition.PARAMETER);
                ++j;
            }
            r = f;
        }
        ASTMacroName name = new ASTMacroName(d.name);
        name.setPropertyInParent(IASTPreprocessorMacroDefinition.MACRO_NAME);
        name.setParent(r);
        ((ASTNode)name).setOffsetAndLength(d.nameOffset, d.name.length);
        r.setName(name);
        r.setExpansion(new String(d.getExpansion()));
        r.setOffsetAndLength(d.context_directive_start, d.context_directive_end - d.context_directive_start);
        d.astNode = r;
        r.setParent(this.rootNode);
        r.setPropertyInParent(IASTTranslationUnit.PREPROCESSOR_STATEMENT);
        return r;
    }

    public IASTPreprocessorIncludeStatement[] getIncludeDirectives() {
        int size = LocationMap.collectContexts(2, this.tu, null, 0);
        if (size == 0) {
            return EMPTY_INCLUDES_ARRAY;
        }
        _Context[] contexts = new _Context[size];
        LocationMap.collectContexts(2, this.tu, contexts, 0);
        IASTPreprocessorIncludeStatement[] result = new IASTPreprocessorIncludeStatement[size];
        int i = 0;
        while (i < size) {
            result[i] = this.createASTInclusion((_Inclusion)contexts[i]);
            ++i;
        }
        return result;
    }

    private IASTPreprocessorIncludeStatement createASTInclusion(_Inclusion inc) {
        ASTInclusionStatement result = new ASTInclusionStatement(inc.reader.filename);
        ((ASTNode)result).setOffsetAndLength(inc.context_directive_start, inc.context_directive_end - inc.context_directive_start);
        result.startOffset = inc.context_directive_end;
        result.endOffset = inc.context_ends;
        result.setParent(this.rootNode);
        result.setPropertyInParent(IASTTranslationUnit.PREPROCESSOR_STATEMENT);
        result.setParent(this.rootNode);
        result.setPropertyInParent(IASTTranslationUnit.PREPROCESSOR_STATEMENT);
        return result;
    }

    public IASTPreprocessorStatement[] getAllPreprocessorStatements() {
        int size = LocationMap.collectContexts(5, this.tu, null, 0);
        if (size == 0) {
            return EMPTY_PREPROCESSOR_ARRAY;
        }
        _Context[] contexts = new _Context[size];
        LocationMap.collectContexts(5, this.tu, contexts, 0);
        IASTPreprocessorStatement[] result = new IASTPreprocessorStatement[size];
        int i = 0;
        while (i < size) {
            result[i] = this.createPreprocessorStatement(contexts[i]);
            ++i;
        }
        return result;
    }

    private IASTPreprocessorStatement createPreprocessorStatement(_Context context) {
        IASTPreprocessorStatement result = null;
        if (context instanceof _Inclusion) {
            result = this.createASTInclusion((_Inclusion)context);
        } else if (context instanceof _MacroDefinition) {
            result = this.createASTMacroDefinition((_MacroDefinition)context);
        } else if (context instanceof _Undef) {
            result = this.createASTUndef((_Undef)context);
        } else if (context instanceof _Pragma) {
            result = this.createASTPragma((_Pragma)context);
        } else if (context instanceof _Error) {
            result = this.createASTError((_Error)context);
        } else if (context instanceof _If) {
            result = this.createASTIf((_If)context);
        } else if (context instanceof _Ifdef) {
            result = this.createASTIfdef((_Ifdef)context);
        } else if (context instanceof _Ifndef) {
            result = this.createASTIfndef((_Ifndef)context);
        } else if (context instanceof _Else) {
            result = this.createASTElse((_Else)context);
        } else if (context instanceof _Elif) {
            result = this.createASTElif((_Elif)context);
        } else if (context instanceof _Endif) {
            result = this.createASTEndif((_Endif)context);
        }
        return result;
    }

    private IASTPreprocessorStatement createASTEndif(_Endif endif) {
        ASTEndif result = new ASTEndif();
        ((ASTNode)result).setOffsetAndLength(endif.context_directive_start, endif.context_directive_end - endif.context_directive_start);
        result.setParent(this.rootNode);
        result.setPropertyInParent(IASTTranslationUnit.PREPROCESSOR_STATEMENT);
        return result;
    }

    private IASTPreprocessorStatement createASTElif(_Elif elif) {
        ASTElif result = new ASTElif(elif.taken);
        ((ASTNode)result).setOffsetAndLength(elif.context_directive_start, elif.context_directive_end - elif.context_directive_start);
        result.setParent(this.rootNode);
        result.setPropertyInParent(IASTTranslationUnit.PREPROCESSOR_STATEMENT);
        return result;
    }

    private IASTPreprocessorStatement createASTElse(_Else e) {
        ASTElse result = new ASTElse(e.taken);
        ((ASTNode)result).setOffsetAndLength(e.context_directive_start, e.context_directive_end - e.context_directive_start);
        result.setParent(this.rootNode);
        result.setPropertyInParent(IASTTranslationUnit.PREPROCESSOR_STATEMENT);
        return result;
    }

    private IASTPreprocessorStatement createASTIfndef(_Ifndef ifndef) {
        ASTIfndef result = new ASTIfndef(ifndef.taken);
        ((ASTNode)result).setOffsetAndLength(ifndef.context_directive_start, ifndef.context_directive_end - ifndef.context_directive_start);
        result.setParent(this.rootNode);
        result.setPropertyInParent(IASTTranslationUnit.PREPROCESSOR_STATEMENT);
        return result;
    }

    private IASTPreprocessorStatement createASTIfdef(_Ifdef ifdef) {
        ASTIfdef result = new ASTIfdef(ifdef.taken);
        ((ASTNode)result).setOffsetAndLength(ifdef.context_directive_start, ifdef.context_directive_end - ifdef.context_directive_start);
        result.setParent(this.rootNode);
        result.setPropertyInParent(IASTTranslationUnit.PREPROCESSOR_STATEMENT);
        return result;
    }

    private IASTPreprocessorStatement createASTIf(_If i) {
        ASTIf result = new ASTIf(i.taken);
        ((ASTNode)result).setOffsetAndLength(i.context_directive_start, i.context_directive_end - i.context_directive_start);
        result.setParent(this.rootNode);
        result.setPropertyInParent(IASTTranslationUnit.PREPROCESSOR_STATEMENT);
        return result;
    }

    private IASTPreprocessorStatement createASTError(_Error error) {
        ASTError result = new ASTError();
        ((ASTNode)result).setOffsetAndLength(error.context_directive_start, error.context_directive_end - error.context_directive_start);
        result.setParent(this.rootNode);
        result.setPropertyInParent(IASTTranslationUnit.PREPROCESSOR_STATEMENT);
        return result;
    }

    private IASTPreprocessorStatement createASTPragma(_Pragma pragma) {
        ASTPragma result = new ASTPragma();
        ((ASTNode)result).setOffsetAndLength(pragma.context_directive_start, pragma.context_directive_end - pragma.context_directive_start);
        result.setParent(this.rootNode);
        result.setPropertyInParent(IASTTranslationUnit.PREPROCESSOR_STATEMENT);
        return result;
    }

    private IASTPreprocessorStatement createASTUndef(_Undef undef) {
        ASTUndef result = new ASTUndef(undef.getName());
        ((ASTNode)result).setOffsetAndLength(undef.context_directive_start, undef.context_directive_end - undef.context_directive_start);
        result.setParent(this.rootNode);
        result.setPropertyInParent(IASTTranslationUnit.PREPROCESSOR_STATEMENT);
        return result;
    }

    public IASTNodeLocation[] getLocations(int offset, int length) {
        _WeightedContext[] extraContexts;
        if (this.tu == null) {
            return EMPTY_LOCATION_ARRAY;
        }
        _Context c = this.findContextForOffset(offset);
        if (c == null) {
            return EMPTY_LOCATION_ARRAY;
        }
        int offset1 = offset + length;
        if (offset1 >= c.context_directive_start && offset1 <= c.context_ends) {
            if (c instanceof _CompositeContext) {
                _Context[] subz = ((_CompositeContext)c).getSubContexts();
                boolean foundNested = false;
                int i = 0;
                while (i < subz.length) {
                    _Context sub = subz[i];
                    if (sub.context_directive_start > offset && sub.context_ends <= offset + length) {
                        foundNested = true;
                        break;
                    }
                    ++i;
                }
                if (!foundNested) {
                    return this.createSoleLocationArray(c, offset, length);
                }
            } else {
                return this.createSoleLocationArray(c, offset, length);
            }
        }
        if ((extraContexts = this.findAllContextsForLength(offset, length)).length == 0) {
            return EMPTY_LOCATION_ARRAY;
        }
        if (extraContexts.length == 1) {
            return this.createSoleLocationArray(extraContexts[0].context, offset, length);
        }
        return this.createMegaLocationArray(offset, length, extraContexts);
    }

    private IASTNodeLocation[] createMegaLocationArray(int offset, int length, _WeightedContext[] contexts) {
        Object[] result = new IASTNodeLocation[contexts.length];
        int currentOffset = offset;
        int i = 0;
        while (i < contexts.length) {
            IASTNodeLocation location = this.createSoleLocation(contexts[i].context, currentOffset, contexts[i].count);
            result[i] = location;
            currentOffset += contexts[i].count;
            ++i;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.dom.ast.IASTNodeLocation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IASTNodeLocation[])ArrayUtil.removeNulls(clazz, result);
    }

    protected _WeightedContext[] findAllContextsForLength(int offset, int length) {
        Object[] result = new _WeightedContext[2];
        _Context cc = null;
        int currentCount = 0;
        int i = offset;
        while (i < offset + length) {
            _Context r = this.tu.findContextContainingOffset(i);
            if (cc == null) {
                cc = r;
                currentCount = 1;
            } else if (cc == r) {
                ++currentCount;
            } else if (cc instanceof _MacroExpansion && r.hasAncestor(cc)) {
                ++currentCount;
            } else {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.cdt.internal.core.parser.scanner2.LocationMap$_WeightedContext");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                result = (_WeightedContext[])ArrayUtil.append(clazz, result, new _WeightedContext(cc, currentCount));
                cc = r;
                currentCount = 1;
            }
            ++i;
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.cdt.internal.core.parser.scanner2.LocationMap$_WeightedContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        result = (_WeightedContext[])ArrayUtil.append(clazz, result, new _WeightedContext(cc, currentCount));
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.cdt.internal.core.parser.scanner2.LocationMap$_WeightedContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (_WeightedContext[])ArrayUtil.removeNulls(clazz2, result);
    }

    protected IASTNodeLocation createSoleLocation(_Context c, int offset, int length) {
        if ((c instanceof _IPreprocessorDirective || c instanceof _Problem) && c.containsInDirective(offset, length)) {
            _CompositeContext parent = c.parent;
            while (!(parent instanceof _CompositeFileContext)) {
                parent = parent.parent;
            }
            _CompositeFileContext fc = (_CompositeFileContext)parent;
            return new FileLocation(fc.reader.filename, this.reconcileOffset(fc, c, offset), length);
        }
        if (c instanceof _CompositeFileContext) {
            return new FileLocation(((_CompositeFileContext)c).reader.filename, LocationMap.reconcileOffset(c, offset), length);
        }
        if (c instanceof _MacroExpansion) {
            _MacroExpansion expansion = (_MacroExpansion)c;
            if (c.containsInDirective(offset, length)) {
                _CompositeContext parent = c.parent;
                while (!(parent instanceof _CompositeFileContext)) {
                    parent = parent.parent;
                }
                _CompositeFileContext fc = (_CompositeFileContext)parent;
                return new FileLocation(fc.reader.filename, this.reconcileOffset(fc, c, offset), length);
            }
            IASTNodeLocation[] locations = this.createSoleLocationArray(c.parent, c.context_directive_start, c.context_directive_end - c.context_directive_start + 1);
            IASTPreprocessorMacroDefinition definition = null;
            _MacroDefinition d = (_MacroDefinition)expansion.definition;
            if (d.astNode != null) {
                definition = d.astNode;
            } else {
                IASTPreprocessorMacroDefinition astNode;
                d.astNode = astNode = this.createASTMacroDefinition(d);
                definition = astNode;
            }
            return new MacroExpansionLocation(definition, locations, LocationMap.reconcileOffset(c, offset), length);
        }
        return null;
    }

    protected IASTNodeLocation[] createSoleLocationArray(_Context c, int offset, int length) {
        IASTNodeLocation value = this.createSoleLocation(c, offset, length);
        if (value == null) {
            return EMPTY_LOCATION_ARRAY;
        }
        IASTNodeLocation[] result = new IASTNodeLocation[]{value};
        return result;
    }

    protected int reconcileOffset(_CompositeFileContext fc, _Context c, int offset) {
        int subtractOff = 0;
        if (c.parent == fc) {
            _Context[] subs = fc.getSubContexts();
            int i = 0;
            while (i < subs.length) {
                _Context sample = subs[i];
                if (sample == c) break;
                if (sample instanceof _CompositeContext) {
                    subtractOff += sample.context_ends - sample.context_directive_end;
                }
                ++i;
            }
        }
        return offset - fc.context_directive_end - subtractOff;
    }

    protected static int reconcileOffset(_Context c, int offset) {
        int result;
        int subtractOff = 0;
        if (c instanceof _CompositeFileContext) {
            _Context[] subs = ((_CompositeFileContext)c).getSubContexts();
            int i = 0;
            while (i < subs.length) {
                _Context subC = subs[i];
                if (subC.context_ends > offset) break;
                if (subC instanceof _CompositeContext) {
                    subtractOff += subC.context_ends - subC.context_directive_end;
                }
                ++i;
            }
        }
        return (result = offset - c.context_directive_end - subtractOff) < 0 ? 0 : result;
    }

    protected _Context findContextForOffset(int offset) {
        return this.tu.findContextContainingOffset(offset);
    }

    public void startTranslationUnit(CodeReader tu_reader) {
        this.tu.reader = tu_reader;
    }

    public void endTranslationUnit(int offset) {
        this.tu.context_ends = offset;
    }

    public void startInclusion(CodeReader reader, int offset, int endOffset) {
        _Inclusion i = new _Inclusion(this.currentContext, reader, offset, endOffset);
        this.currentContext.addSubContext(i);
        this.currentContext = i;
    }

    public void endInclusion(CodeReader reader, int offset) {
        if (this.currentContext instanceof _Inclusion && ((_Inclusion)this.currentContext).reader == reader) {
            ((_Inclusion)this.currentContext).context_ends = offset;
            this.currentContext = this.currentContext.getParent();
            return;
        }
        _CompositeContext test = this.currentContext;
        while ((test = test.getParent()) != this.tu) {
            if (!(test instanceof _Inclusion) || ((_Inclusion)test).reader != reader) continue;
            this.currentContext = test;
            ((_Inclusion)this.currentContext).context_ends = offset;
            this.currentContext = this.currentContext.getParent();
            return;
        }
    }

    public void startObjectStyleMacroExpansion(IScannerPreprocessorLog.IMacroDefinition macro, int startOffset, int endOffset) {
        _ObjectMacroExpansion context = new _ObjectMacroExpansion(this.currentContext, startOffset, endOffset, macro);
        this.currentContext.addSubContext(context);
        this.currentContext = context;
    }

    public void endObjectStyleMacroExpansion(IScannerPreprocessorLog.IMacroDefinition macro, int offset) {
        if (this.currentContext instanceof _MacroExpansion && ((_MacroExpansion)this.currentContext).definition == macro) {
            ((_ObjectMacroExpansion)this.currentContext).context_ends = offset;
            this.currentContext = this.currentContext.getParent();
            return;
        }
        _CompositeContext test = this.currentContext;
        while ((test = test.getParent()) != this.tu) {
            if (!(test instanceof _MacroExpansion) || ((_MacroExpansion)test).definition != macro) continue;
            this.currentContext = test;
            ((_ObjectMacroExpansion)this.currentContext).context_ends = offset;
            this.currentContext = this.currentContext.getParent();
            return;
        }
    }

    public void startFunctionStyleExpansion(IScannerPreprocessorLog.IMacroDefinition macro, char[][] parameters, int startOffset, int endOffset) {
        _FunctionMacroExpansion context = new _FunctionMacroExpansion(this.currentContext, startOffset, endOffset, macro, parameters);
        this.currentContext.addSubContext(context);
        this.currentContext = context;
    }

    public void endFunctionStyleExpansion(IScannerPreprocessorLog.IMacroDefinition macro, int offset) {
        if (this.currentContext instanceof _MacroExpansion && ((_MacroExpansion)this.currentContext).definition == macro) {
            ((_FunctionMacroExpansion)this.currentContext).context_ends = offset;
            this.currentContext = this.currentContext.getParent();
            return;
        }
        _CompositeContext test = this.currentContext;
        while ((test = test.getParent()) != this.tu) {
            if (!(test instanceof _MacroExpansion) || ((_MacroExpansion)test).definition != macro) continue;
            this.currentContext = test;
            ((_FunctionMacroExpansion)this.currentContext).context_ends = offset;
            this.currentContext = this.currentContext.getParent();
            return;
        }
    }

    public IScannerPreprocessorLog.IMacroDefinition defineObjectStyleMacro(ObjectStyleMacro m, int startOffset, int nameOffset, int nameEndOffset, int endOffset) {
        _ObjectMacroDefinition objectMacroDefinition = new _ObjectMacroDefinition(this.currentContext, startOffset, endOffset, m.name, nameOffset, m.getExpansion());
        this.currentContext.addSubContext(objectMacroDefinition);
        return objectMacroDefinition;
    }

    public IScannerPreprocessorLog.IMacroDefinition defineFunctionStyleMacro(FunctionStyleMacro m, int startOffset, int nameOffset, int nameEndOffset, int endOffset) {
        _FunctionMacroDefinition functionMacroDefinition = new _FunctionMacroDefinition(this.currentContext, startOffset, endOffset, m.name, nameOffset, m.getExpansion(), this.removeNullArguments(m.arglist));
        this.currentContext.addSubContext(functionMacroDefinition);
        return functionMacroDefinition;
    }

    private char[][] removeNullArguments(char[][] arglist) {
        int nullCount = 0;
        int i = 0;
        while (i < ((char[][])arglist).length) {
            if (arglist[i] == null) {
                ++nullCount;
            }
            ++i;
        }
        if (nullCount == 0) {
            return arglist;
        }
        char[][] old = arglist;
        int newSize = old.length - nullCount;
        arglist = new char[newSize][];
        int i2 = 0;
        while (i2 < newSize) {
            arglist[i2] = old[i2];
            ++i2;
        }
        return arglist;
    }

    public void encounterPoundIf(int startOffset, int endOffset, boolean taken) {
        this.currentContext.addSubContext(new _If(this.currentContext, startOffset, endOffset, taken));
    }

    public void encounterPoundPragma(int startOffset, int endOffset) {
        this.currentContext.addSubContext(new _Pragma(this.currentContext, startOffset, endOffset));
    }

    public void encounterPoundError(int startOffset, int endOffset) {
        this.currentContext.addSubContext(new _Error(this.currentContext, startOffset, endOffset));
    }

    public void encounterPoundIfdef(int startOffset, int endOffset, boolean taken) {
        this.currentContext.addSubContext(new _Ifdef(this.currentContext, startOffset, endOffset, taken));
    }

    public void encounterPoundUndef(int startOffset, int endOffset, char[] symbol, int nameOffset, IScannerPreprocessorLog.IMacroDefinition macroDefinition) {
        this.currentContext.addSubContext(new _Undef(this.currentContext, startOffset, endOffset, symbol, nameOffset, macroDefinition));
    }

    public void encounterPoundElse(int startOffset, int endOffset, boolean taken) {
        this.currentContext.addSubContext(new _Else(this.currentContext, startOffset, endOffset, taken));
    }

    public void encounterPoundElif(int startOffset, int endOffset, boolean taken) {
        this.currentContext.addSubContext(new _Elif(this.currentContext, startOffset, endOffset, taken));
    }

    public void encounterPoundEndIf(int startOffset, int endOffset) {
        this.currentContext.addSubContext(new _Endif(this.currentContext, startOffset, endOffset));
    }

    public String getTranslationUnitPath() {
        return new String(this.tu.reader.filename);
    }

    public void cleanup() {
        this.tu = null;
    }

    public IASTProblem[] getScannerProblems() {
        int size = LocationMap.collectContexts(3, this.tu, null, 0);
        if (size == 0) {
            return EMPTY_PROBLEMS_ARRAY;
        }
        _Context[] contexts = new _Context[size];
        LocationMap.collectContexts(3, this.tu, contexts, 0);
        IASTProblem[] result = new IASTProblem[size];
        int i = 0;
        while (i < size) {
            result[i] = ((_Problem)contexts[i]).problem;
            result[i].setParent(this.rootNode);
            result[i].setPropertyInParent(IASTTranslationUnit.SCANNER_PROBLEM);
            ++i;
        }
        return result;
    }

    public void encounterProblem(IASTProblem problem) {
        ScannerASTProblem p = (ScannerASTProblem)problem;
        _Problem pr = new _Problem(this.currentContext, p.getOffset(), p.getOffset() + p.getLength(), problem);
        pr.context_ends = p.getOffset() + p.getLength();
        this.currentContext.addSubContext(pr);
    }

    protected static int collectContexts(int key, _Context source, _Context[] result, int s) {
        int startAt = s;
        int count = 0;
        switch (key) {
            case 1: {
                if (result != null) {
                    result[startAt++] = source;
                }
                ++count;
                break;
            }
            case 2: {
                if (!(source instanceof _Inclusion)) break;
                if (result != null) {
                    result[startAt++] = source;
                }
                ++count;
                break;
            }
            case 3: {
                if (!(source instanceof _Problem)) break;
                if (result != null) {
                    result[startAt++] = source;
                }
                ++count;
                break;
            }
            case 4: {
                if (!(source instanceof _MacroDefinition)) break;
                if (result != null) {
                    result[startAt++] = source;
                }
                ++count;
                break;
            }
            case 5: {
                if (!(source instanceof _IPreprocessorDirective)) break;
                if (result != null) {
                    result[startAt++] = source;
                }
                ++count;
                break;
            }
            case 6: {
                if (!(source instanceof _MacroDefinition) && !(source instanceof _Undef)) break;
                if (result != null) {
                    result[startAt++] = source;
                }
                ++count;
            }
        }
        if (source instanceof _CompositeContext) {
            _Context[] l = ((_CompositeContext)source).getSubContexts();
            int i = 0;
            while (i < l.length) {
                int value = LocationMap.collectContexts(key, l[i], result, startAt);
                count += value;
                startAt += value;
                ++i;
            }
        }
        return count;
    }

    public char[] getUnpreprocessedSignature(IASTNodeLocation[] locations) {
        switch (locations.length) {
            case 1: {
                if (locations[0] instanceof IASTFileLocation) {
                    IASTNodeLocation nodeLocation = locations[0];
                    char[] name = ((IASTFileLocation)nodeLocation).getFileName().toCharArray();
                    if (this.readerCompatable(nodeLocation, this.tu.reader, name)) {
                        return CharArrayUtils.extract(this.tu.reader.buffer, nodeLocation.getNodeOffset(), nodeLocation.getNodeLength());
                    }
                    int size = LocationMap.collectContexts(2, this.tu, null, 0);
                    if (size == 0) {
                        return EMPTY_CHAR_ARRAY;
                    }
                    _Context[] inclusions = new _Context[size];
                    LocationMap.collectContexts(2, this.tu, inclusions, 0);
                    int i = 0;
                    while (i < size) {
                        _Inclusion inc = (_Inclusion)inclusions[i];
                        if (this.readerCompatable(nodeLocation, inc.reader, name)) {
                            return CharArrayUtils.extract(inc.reader.buffer, nodeLocation.getNodeOffset(), nodeLocation.getNodeLength());
                        }
                        ++i;
                    }
                }
                return EMPTY_CHAR_ARRAY;
            }
            case 0: {
                return EMPTY_CHAR_ARRAY;
            }
        }
        return EMPTY_CHAR_ARRAY;
    }

    private boolean readerCompatable(IASTNodeLocation nodeLocation, CodeReader reader, char[] name) {
        if (!CharArrayUtils.equals(reader.filename, name)) {
            return false;
        }
        if (nodeLocation.getNodeOffset() > reader.buffer.length) {
            return false;
        }
        return nodeLocation.getNodeOffset() + nodeLocation.getNodeLength() <= reader.buffer.length;
    }

    public void encounterPoundIfndef(int startOffset, int endOffset, boolean taken) {
        this.currentContext.addSubContext(new _Ifndef(this.currentContext, startOffset, endOffset, taken));
    }

    _Inclusion findInclusion(_CompositeContext context, String path) {
        _Inclusion foundContext = null;
        _Context[] contexts = context.getSubContexts();
        _Inclusion tempContext = null;
        int i = 0;
        while (foundContext == null && i < contexts.length) {
            if (contexts[i] instanceof _Inclusion) {
                tempContext = (_Inclusion)contexts[i];
                if (CharArrayUtils.equals(tempContext.reader.filename, path.toCharArray())) {
                    foundContext = tempContext;
                    break;
                }
                foundContext = this.findInclusion(tempContext, path);
            }
            ++i;
        }
        return foundContext;
    }

    private ASTPreprocessorSelectionResult getPreprocessorNode(int globalOffset, int length, _Context startContext) throws InvalidPreprocessorNodeException {
        IASTNode result = null;
        if (!(startContext instanceof _CompositeContext)) {
            throw new InvalidPreprocessorNodeException(NOT_VALID_MACRO, globalOffset);
        }
        _Context[] contexts = ((_CompositeContext)startContext).getSubContexts();
        int i = 0;
        while (result == null && i < contexts.length) {
            _Context context = contexts[i];
            if (globalOffset > context.context_directive_end) {
                globalOffset += context.context_ends - context.context_directive_end;
            }
            if (globalOffset == context.context_directive_start && length == context.context_directive_end - context.context_directive_start) {
                result = this.createPreprocessorStatement(context);
            } else if (context instanceof _MacroExpansion && globalOffset == context.context_directive_start) {
                _MacroExpansion expansion = (_MacroExpansion)context;
                if (expansion.definition.getName().length == length) {
                    result = expansion.getName();
                }
            }
            if (globalOffset >= context.context_directive_start && globalOffset <= context.context_ends && context instanceof _MacroDefinition && globalOffset == ((_MacroDefinition)context).nameOffset && length == ((_MacroDefinition)context).name.length) {
                result = this.createASTMacroDefinition((_MacroDefinition)context).getName();
            }
            if (globalOffset < context.context_directive_end) break;
            ++i;
        }
        return new ASTPreprocessorSelectionResult(result, globalOffset);
    }

    public ASTPreprocessorSelectionResult getPreprocessorNode(String path, int offset, int length) throws InvalidPreprocessorNodeException {
        ASTPreprocessorSelectionResult result = null;
        int globalOffset = 0;
        _CompositeFileContext foundContext = this.tu;
        if (CharArrayUtils.equals(this.tu.reader.filename, path.toCharArray())) {
            globalOffset = offset;
        } else {
            foundContext = this.findInclusion(this.tu, path);
            if (foundContext == null) {
                throw new InvalidPreprocessorNodeException(TU_INCLUDE_NOT_FOUND, globalOffset);
            }
            if (foundContext instanceof _Inclusion) {
                globalOffset = foundContext.context_directive_end + offset;
            }
        }
        result = this.getPreprocessorNode(globalOffset, length, foundContext);
        return result;
    }

    public void setRootNode(IASTTranslationUnit root) {
        this.rootNode = root;
    }

    public IASTFileLocation flattenLocations(IASTNodeLocation[] nodeLocations) {
        if (nodeLocations == null) {
            return null;
        }
        if (nodeLocations.length == 0) {
            return null;
        }
        if (nodeLocations.length == 1 && nodeLocations[0] instanceof IASTFileLocation) {
            return (IASTFileLocation)nodeLocations[0];
        }
        IASTFileLocation[] result = new IASTFileLocation[nodeLocations.length];
        int i = 0;
        while (i < nodeLocations.length) {
            if (nodeLocations[i] != null) {
                result[i] = nodeLocations[i].asFileLocation();
            }
            ++i;
        }
        return this.flatten(result);
    }

    private IASTFileLocation flatten(IASTFileLocation[] result) {
        String filename = null;
        int offset = 0;
        int length = 0;
        int i = 0;
        while (i < result.length) {
            if (i == 0) {
                offset = result[0].getNodeOffset();
                filename = result[0].getFileName();
                length = result[0].getNodeLength();
            } else {
                if (result[i] != null && !result[i].getFileName().equals(filename)) {
                    return null;
                }
                if (result[i].getNodeOffset() != result[i - 1].getNodeOffset()) {
                    if (result[i] != null && result[i].getNodeOffset() != offset + length) {
                        return null;
                    }
                    if (result[i] != null) {
                        length += result[i].getNodeLength();
                    }
                }
            }
            ++i;
        }
        return new FileLocation(filename.toCharArray(), offset, length);
    }

    public IASTName[] getReferences(IMacroBinding binding) {
        if (binding instanceof MacroBinding) {
            IScannerPreprocessorLog.IMacroDefinition d = ((MacroBinding)binding).getDefinition();
            _Context[] r = this.findReferences(this.tu, d);
            return this.createNameArray(r);
        }
        return EMPTY_NAME_ARRAY;
    }

    private IASTName[] createNameArray(_Context[] r) {
        IASTName[] result = new IASTName[r.length];
        int i = 0;
        while (i < r.length) {
            IASTName n = null;
            if (r[i] instanceof _MacroExpansion) {
                n = ((_MacroExpansion)r[i]).getName();
            } else if (r[i] instanceof _Undef) {
                n = ((_Undef)r[i]).getName();
                this.createASTUndef((_Undef)r[i]);
            }
            result[i] = n;
            ++i;
        }
        return result;
    }

    protected _Context[] findReferences(_CompositeContext c, IScannerPreprocessorLog.IMacroDefinition d) {
        Object[] results = new _Context[2];
        _Context[] subs = c.getSubContexts();
        int i = 0;
        while (i < subs.length) {
            Object[] s;
            if (subs[i] instanceof _MacroExpansion) {
                if (((_MacroExpansion)subs[i]).definition == d) {
                    Class<?> clazz = class$2;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.cdt.internal.core.parser.scanner2.LocationMap$_Context");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    results = (_Context[])ArrayUtil.append(clazz, results, subs[i]);
                }
            } else if (subs[i] instanceof _Undef && ((_Undef)subs[i]).macroDefn == d) {
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.cdt.internal.core.parser.scanner2.LocationMap$_Context");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                results = (_Context[])ArrayUtil.append(clazz, results, subs[i]);
            }
            if (subs[i] instanceof _CompositeContext && (s = this.findReferences((_CompositeContext)subs[i], d)).length > 0) {
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.cdt.internal.core.parser.scanner2.LocationMap$_Context");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                results = (_Context[])ArrayUtil.addAll(clazz, results, s);
            }
            ++i;
        }
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.cdt.internal.core.parser.scanner2.LocationMap$_Context");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (_Context[])ArrayUtil.removeNulls(clazz, results);
    }

    public IASTName[] getDeclarations(IMacroBinding binding) {
        IScannerPreprocessorLog.IMacroDefinition d;
        if (binding instanceof MacroBinding && (d = ((MacroBinding)binding).getDefinition()) instanceof _MacroDefinition) {
            return this.createNameArray((_MacroDefinition)d);
        }
        return EMPTY_NAME_ARRAY;
    }

    private IASTName[] createNameArray(_MacroDefinition definition) {
        if (definition == null) {
            return EMPTY_NAME_ARRAY;
        }
        IASTName[] result = new IASTName[1];
        if (definition.astNode == null) {
            IASTPreprocessorMacroDefinition astNode;
            definition.astNode = astNode = this.createASTMacroDefinition(definition);
            result[0] = definition.astNode.getName();
        } else {
            result[0] = definition.astNode.getName();
        }
        return result;
    }

    public IASTName[] getMacroExpansions() {
        return null;
    }

    public IASTTranslationUnit.IDependencyTree getDependencyTree() {
        DependencyTree result = new DependencyTree(this.getTranslationUnitPath());
        this.buildDependencyTree(result, this.tu);
        return result;
    }

    protected void buildDependencyTree(IDependencyNodeHost result, _CompositeFileContext context) {
        _Context[] subs = context.getSubContexts();
        int i = 0;
        while (i < subs.length) {
            if (subs[i] instanceof _Inclusion) {
                IASTTranslationUnit.IDependencyTree.IASTInclusionNode node = this.createDepTreeNode((_Inclusion)subs[i]);
                result.addInclusionNode(node);
            }
            ++i;
        }
    }

    private IASTTranslationUnit.IDependencyTree.IASTInclusionNode createDepTreeNode(_Inclusion inclusion) {
        IASTPreprocessorIncludeStatement stmt = this.createASTInclusion(inclusion);
        InclusionNode node = new InclusionNode(stmt);
        this.buildDependencyTree(node, inclusion);
        return node;
    }

    public IScannerPreprocessorLog.IMacroDefinition registerBuiltinObjectStyleMacro(ObjectStyleMacro macro) {
        _ObjectMacroDefinition result = new _ObjectMacroDefinition((_CompositeContext)this.tu, -1, -1, macro.name, -1, macro);
        this.tu.addBuiltinMacro(result);
        return result;
    }

    public IScannerPreprocessorLog.IMacroDefinition registerBuiltinFunctionStyleMacro(FunctionStyleMacro macro) {
        _FunctionMacroDefinition result = new _FunctionMacroDefinition((_CompositeContext)this.tu, -1, -1, macro.name, -1, macro, this.removeNullArguments(macro.arglist));
        this.tu.addBuiltinMacro(result);
        return result;
    }

    public IScannerPreprocessorLog.IMacroDefinition registerBuiltinDynamicFunctionStyleMacro(DynamicFunctionStyleMacro macro) {
        _MacroDefinition result = new _MacroDefinition((_CompositeContext)this.tu, -1, -1, macro.name, -1, macro.getExpansion());
        this.tu.addBuiltinMacro(result);
        return result;
    }

    public IScannerPreprocessorLog.IMacroDefinition registerBuiltinDynamicStyleMacro(DynamicStyleMacro macro) {
        _MacroDefinition result = new _MacroDefinition((_CompositeContext)this.tu, -1, -1, macro.name, -1, macro.execute());
        this.tu.addBuiltinMacro(result);
        return result;
    }

    public String getContainingFilename(int offset) {
        _Context c = this.findContextForOffset(offset);
        if (c == null) {
            return EMPTY_STRING;
        }
        _CompositeFileContext file = c.getContainingFileContext();
        if (file == null) {
            return EMPTY_STRING;
        }
        return file.reader.getPath();
    }

    public class MacroExpansionLocation
    implements IASTMacroExpansion {
        private final int length;
        private final int offset;
        private final IASTNodeLocation[] locations;
        private final IASTPreprocessorMacroDefinition definition;

        public MacroExpansionLocation(IASTPreprocessorMacroDefinition macroDefinition, IASTNodeLocation[] locations, int offset, int length) {
            this.definition = macroDefinition;
            this.locations = locations;
            this.offset = offset;
            this.length = length;
        }

        public IASTPreprocessorMacroDefinition getMacroDefinition() {
            return this.definition;
        }

        public IASTNodeLocation[] getExpansionLocations() {
            return this.locations;
        }

        public int getNodeOffset() {
            return this.offset;
        }

        public int getNodeLength() {
            return this.length;
        }

        public IASTFileLocation asFileLocation() {
            return LocationMap.this.rootNode.flattenLocationsToFile(this.locations);
        }

        public String toString() {
            return "Macro Expansion " + this.definition.getName().toString() + " flattened to " + this.asFileLocation().toString();
        }
    }

    public static class ASTEndif
    extends ASTNode
    implements IASTPreprocessorEndifStatement {
    }

    public static class ASTElif
    extends ASTNode
    implements IASTPreprocessorElifStatement {
        private final boolean taken;

        public boolean taken() {
            return this.taken;
        }

        public ASTElif(boolean taken) {
            this.taken = taken;
        }
    }

    public static class ASTElse
    extends ASTNode
    implements IASTPreprocessorElseStatement {
        private final boolean taken;

        public boolean taken() {
            return this.taken;
        }

        public ASTElse(boolean taken) {
            this.taken = taken;
        }
    }

    public static class ASTIfndef
    extends ASTNode
    implements IASTPreprocessorIfndefStatement {
        private final boolean taken;

        public boolean taken() {
            return this.taken;
        }

        public ASTIfndef(boolean taken) {
            this.taken = taken;
        }
    }

    public static class ASTIfdef
    extends ASTNode
    implements IASTPreprocessorIfdefStatement {
        private final boolean taken;

        public boolean taken() {
            return this.taken;
        }

        public ASTIfdef(boolean taken) {
            this.taken = taken;
        }
    }

    public static class ASTIf
    extends ASTNode
    implements IASTPreprocessorIfStatement {
        private final boolean taken;

        public boolean taken() {
            return this.taken;
        }

        public ASTIf(boolean taken) {
            this.taken = taken;
        }
    }

    public static class ASTError
    extends ASTNode
    implements IASTPreprocessorErrorStatement {
    }

    public static class ASTPragma
    extends ASTNode
    implements IASTPreprocessorPragmaStatement {
    }

    public static class ASTUndef
    extends ASTNode
    implements IASTPreprocessorUndefStatement {
        private final IASTName n;

        public ASTUndef(IASTName n) {
            this.n = n;
            n.setPropertyInParent(IASTPreprocessorUndefStatement.MACRO_NAME);
            n.setParent(this);
        }

        public IASTName getMacroName() {
            return this.n;
        }
    }

    protected static class _Endif
    extends _Context
    implements _IPreprocessorDirective {
        public _Endif(_CompositeContext parent, int startOffset, int endOffset) {
            super(parent, startOffset, endOffset);
        }
    }

    protected static class _Elif
    extends _Context
    implements _IPreprocessorDirective {
        public final boolean taken;

        public _Elif(_CompositeContext parent, int startOffset, int endOffset, boolean taken) {
            super(parent, startOffset, endOffset);
            this.taken = taken;
        }
    }

    protected static class _Ifdef
    extends _Context
    implements _IPreprocessorDirective {
        public final boolean taken;

        public _Ifdef(_CompositeContext parent, int startOffset, int endOffset, boolean taken) {
            super(parent, startOffset, endOffset);
            this.taken = taken;
        }
    }

    protected static class _Ifndef
    extends _Context
    implements _IPreprocessorDirective {
        public final boolean taken;

        public _Ifndef(_CompositeContext parent, int startOffset, int endOffset, boolean taken) {
            super(parent, startOffset, endOffset);
            this.taken = taken;
        }
    }

    protected static class _Error
    extends _Context
    implements _IPreprocessorDirective {
        public _Error(_CompositeContext parent, int startOffset, int endOffset) {
            super(parent, startOffset, endOffset);
        }
    }

    protected static class _Pragma
    extends _Context
    implements _IPreprocessorDirective {
        public _Pragma(_CompositeContext parent, int startOffset, int endOffset) {
            super(parent, startOffset, endOffset);
        }
    }

    protected class _If
    extends _Context
    implements _IPreprocessorDirective {
        public final boolean taken;

        public _If(_CompositeContext parent, int startOffset, int endOffset, boolean taken) {
            super(parent, startOffset, endOffset);
            this.taken = taken;
        }
    }

    protected static class _Else
    extends _Context
    implements _IPreprocessorDirective {
        public final boolean taken;

        public _Else(_CompositeContext parent, int startOffset, int endOffset, boolean taken) {
            super(parent, startOffset, endOffset);
            this.taken = taken;
        }
    }

    public static class ASTInclusionStatement
    extends ASTNode
    implements IASTPreprocessorIncludeStatement {
        private final char[] path;
        public int startOffset;
        public int endOffset;

        public ASTInclusionStatement(char[] cs) {
            this.path = cs;
        }

        public String getPath() {
            return new String(this.path);
        }

        public String toString() {
            return this.getPath();
        }
    }

    public static class ASTFunctionMacro
    extends ASTNode
    implements IASTPreprocessorFunctionStyleMacroDefinition {
        private IASTName name;
        private String expansion;
        private int currentIndex = 0;
        private IASTFunctionStyleMacroParameter[] parameters = null;
        private static final int DEFAULT_PARMS_LIST_SIZE = 2;

        public IASTFunctionStyleMacroParameter[] getParameters() {
            if (this.parameters == null) {
                return IASTFunctionStyleMacroParameter.EMPTY_PARAMETER_ARRAY;
            }
            this.removeNullParameters();
            return this.parameters;
        }

        public void addParameter(IASTFunctionStyleMacroParameter parm) {
            if (this.parameters == null) {
                this.parameters = new IASTFunctionStyleMacroParameter[2];
                this.currentIndex = 0;
            }
            if (this.parameters.length == this.currentIndex) {
                IASTFunctionStyleMacroParameter[] old = this.parameters;
                this.parameters = new IASTFunctionStyleMacroParameter[old.length * 2];
                int i = 0;
                while (i < old.length) {
                    this.parameters[i] = old[i];
                    ++i;
                }
            }
            this.parameters[this.currentIndex++] = parm;
        }

        private void removeNullParameters() {
            int nullCount = 0;
            int i = 0;
            while (i < this.parameters.length) {
                if (this.parameters[i] == null) {
                    ++nullCount;
                }
                ++i;
            }
            if (nullCount == 0) {
                return;
            }
            IASTFunctionStyleMacroParameter[] old = this.parameters;
            int newSize = old.length - nullCount;
            this.parameters = new IASTFunctionStyleMacroParameter[newSize];
            int i2 = 0;
            while (i2 < newSize) {
                this.parameters[i2] = old[i2];
                ++i2;
            }
            this.currentIndex = newSize;
        }

        public IASTName getName() {
            return this.name;
        }

        public void setName(IASTName name) {
            this.name = name;
        }

        public String getExpansion() {
            return this.expansion;
        }

        public void setExpansion(String exp) {
            this.expansion = exp;
        }

        public int getRoleForName(IASTName n) {
            if (this.name == n) {
                return 2;
            }
            return 3;
        }
    }

    public static interface _IPreprocessorDirective {
    }

    protected class _Undef
    extends _Context
    implements _IPreprocessorDirective {
        public final char[] name;
        public final int nameOffset;
        private IASTName expansionName;
        public final IScannerPreprocessorLog.IMacroDefinition macroDefn;

        public IASTName getName() {
            if (this.expansionName == null) {
                this.expansionName = new ASTMacroName(this.name);
                this.expansionName.setParent(LocationMap.this.rootNode);
                this.expansionName.setPropertyInParent(IASTPreprocessorUndefStatement.MACRO_NAME);
                ((ASTNode)((Object)this.expansionName)).setOffsetAndLength(this.context_directive_start, this.name.length);
            }
            return this.expansionName;
        }

        public _Undef(_CompositeContext parent, int startOffset, int endOffset, char[] name, int nameOffset, IScannerPreprocessorLog.IMacroDefinition macro) {
            super(parent, startOffset, endOffset);
            this.name = name;
            this.nameOffset = nameOffset;
            this.macroDefn = macro;
        }
    }

    public class ASTMacroName
    extends ASTNode
    implements IASTName {
        private final char[] name;
        private IMacroBinding binding = null;

        public ASTMacroName(char[] n) {
            this.name = n;
        }

        public IBinding resolveBinding() {
            if (this.binding == null) {
                this.binding = LocationMap.this.resolveBindingForMacro(this.name, this.getOffset());
            }
            return this.binding;
        }

        public IBinding[] resolvePrefix() {
            return null;
        }

        public char[] toCharArray() {
            return this.name;
        }

        public String toString() {
            return new String(this.name);
        }

        public boolean isDeclaration() {
            return this.getParent() instanceof IASTPreprocessorMacroDefinition && this.getPropertyInParent() == IASTPreprocessorMacroDefinition.MACRO_NAME;
        }

        public boolean isDefinition() {
            return this.isDeclaration();
        }

        public boolean isReference() {
            return !this.isDeclaration();
        }

        public IBinding getBinding() {
            return this.binding;
        }

        public void setBinding(IBinding binding) {
        }
    }

    public static class ASTObjectMacro
    extends ASTNode
    implements IASTPreprocessorObjectStyleMacroDefinition {
        private IASTName name;
        private String expansion;

        public int getRoleForName(IASTName n) {
            if (this.name == n) {
                return 2;
            }
            return 3;
        }

        public IASTName getName() {
            return this.name;
        }

        public void setName(IASTName name) {
            this.name = name;
        }

        public String getExpansion() {
            return this.expansion;
        }

        public void setExpansion(String exp) {
            this.expansion = exp;
        }
    }

    public static abstract class Location
    implements IASTNodeLocation {
        private final int nodeOffset;
        private final int nodeLength;

        public Location(int offset, int length) {
            this.nodeOffset = offset;
            this.nodeLength = length;
        }

        public int getNodeOffset() {
            return this.nodeOffset;
        }

        public int getNodeLength() {
            return this.nodeLength;
        }
    }

    public static class ASTFunctionMacroParameter
    extends ASTNode
    implements IASTFunctionStyleMacroParameter {
        private String value;

        public String getParameter() {
            return this.value;
        }

        public void setParameter(String value) {
            this.value = value;
        }
    }

    public class FileLocation
    extends Location
    implements IASTFileLocation {
        private String fileName;
        private _CompositeFileContext _fileContext;

        public FileLocation(char[] tu_filename, int offset, int length) {
            super(offset, length);
            this.fileName = new String(tu_filename);
        }

        public String getFileName() {
            return this.fileName;
        }

        public IASTFileLocation asFileLocation() {
            return this;
        }

        public int getStartingLineNumber() {
            _CompositeFileContext i = this.getFileContext();
            if (i != null) {
                return i.getLineNumber(this.getNodeOffset());
            }
            return 0;
        }

        private _CompositeFileContext getFileContext() {
            if (this._fileContext == null) {
                this._fileContext = this.fileName.equals(LocationMap.this.getTranslationUnitPath()) ? LocationMap.this.tu : LocationMap.this.findInclusion(LocationMap.this.tu, this.fileName);
            }
            return this._fileContext;
        }

        public int getEndingLineNumber() {
            _CompositeFileContext i = this.getFileContext();
            if (i != null) {
                return i.getLineNumber(this.getNodeOffset() + this.getNodeLength());
            }
            return 0;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer(this.fileName);
            buffer.append(" line ");
            buffer.append(this.getStartingLineNumber());
            buffer.append(" to ");
            buffer.append(this.getEndingLineNumber());
            return buffer.toString();
        }
    }

    protected static class _Context {
        public int context_directive_start;
        public int context_directive_end;
        public int context_ends;
        public _CompositeContext parent;

        public _Context(_CompositeContext parent, int startOffset, int endOffset) {
            this.context_directive_start = startOffset;
            this.context_directive_end = endOffset;
            this.context_ends = endOffset;
            this.parent = parent;
        }

        public _CompositeContext getParent() {
            return this.parent;
        }

        public final boolean contains(int offset) {
            return offset >= this.context_directive_start && offset <= this.context_ends;
        }

        public boolean containsInDirective(int offset, int length) {
            if (length > 0 && offset == this.context_directive_end) {
                return false;
            }
            return offset >= this.context_directive_start && offset + length - 1 <= this.context_directive_end;
        }

        public boolean hasAncestor(_Context cc) {
            _CompositeContext p = this.parent;
            while (p != null) {
                if (p == cc) {
                    return true;
                }
                p = p.parent;
            }
            return false;
        }

        public _CompositeFileContext getContainingFileContext() {
            if (this instanceof _CompositeFileContext) {
                return (_CompositeFileContext)this;
            }
            _CompositeContext result = this.getParent();
            while (!(result instanceof _CompositeFileContext)) {
                result = result.getParent();
            }
            return (_CompositeFileContext)result;
        }
    }

    protected static class _CompositeContext
    extends _Context {
        private static final int DEFAULT_SUBCONTEXT_ARRAY_SIZE = 8;
        private _Context[] subContexts = null;
        private static final _Context[] EMPTY_CONTEXT_ARRAY = new _Context[0];
        static /* synthetic */ Class class$0;

        public _CompositeContext(_CompositeContext parent, int startOffset, int endOffset) {
            super(parent, startOffset, endOffset);
        }

        public _Context[] getSubContexts() {
            if (this.subContexts == null) {
                return EMPTY_CONTEXT_ARRAY;
            }
            this.trimSubContexts();
            return this.subContexts;
        }

        private void trimSubContexts() {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.internal.core.parser.scanner2.LocationMap$_Context");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.subContexts = (_Context[])ArrayUtil.trim(clazz, this.subContexts);
        }

        public void addSubContext(_Context c) {
            Class<?> clazz;
            if (this.subContexts == null) {
                this.subContexts = new _Context[8];
            }
            if ((clazz = class$0) == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.internal.core.parser.scanner2.LocationMap$_Context");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.subContexts = (_Context[])ArrayUtil.append(clazz, this.subContexts, c);
        }

        public void removeSubContext(_Context c) {
            if (this.subContexts == null) {
                return;
            }
            int i = 0;
            while (i < this.subContexts.length) {
                if (this.subContexts[i] == c) {
                    this.subContexts[i] = null;
                    return;
                }
                ++i;
            }
        }

        public boolean hasSubContexts() {
            if (this.subContexts == null) {
                return false;
            }
            int i = 0;
            while (i < this.subContexts.length) {
                if (this.subContexts[i] != null) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public _Context findContextContainingOffset(int offset) {
            if (this.subContexts != null) {
                int i = 0;
                while (i < this.subContexts.length) {
                    _Context c = this.subContexts[i];
                    if (c != null && offset >= c.context_directive_start && offset <= c.context_ends) {
                        if (c instanceof _CompositeContext) {
                            _Context trial = ((_CompositeContext)c).findContextContainingOffset(offset);
                            if (trial == null) {
                                return c;
                            }
                            return trial;
                        }
                        return c;
                    }
                    ++i;
                }
            }
            if (offset >= this.context_directive_start && offset <= this.context_ends) {
                return this;
            }
            return null;
        }

        public int getNumberOfContexts() {
            _Context[] contextz = this.getSubContexts();
            int result = contextz.length;
            int i = 0;
            while (i < contextz.length) {
                if (contextz[i] instanceof _CompositeContext) {
                    result += ((_CompositeContext)contextz[i]).getNumberOfContexts();
                }
                ++i;
            }
            return result;
        }
    }

    protected static class _CompositeFileContext
    extends _CompositeContext {
        public CodeReader reader;

        public _CompositeFileContext(_CompositeContext parent, int startOffset, int endOffset, CodeReader reader) {
            super(parent, startOffset, endOffset);
            this.reader = reader;
        }

        public _CompositeFileContext(_CompositeContext parent, int startOffset, int endOffset) {
            super(parent, startOffset, endOffset);
        }

        public int getLineNumber(int nodeOffset) {
            if (nodeOffset >= this.reader.buffer.length) {
                return 1;
            }
            int lineNumber = 1;
            int i = 0;
            while (i < nodeOffset) {
                if (this.reader.buffer[i] == '\n') {
                    ++lineNumber;
                }
                ++i;
            }
            return lineNumber;
        }
    }

    protected static class _Inclusion
    extends _CompositeFileContext
    implements _IPreprocessorDirective {
        public _Inclusion(_CompositeContext parent, CodeReader reader, int startOffset, int endOffset) {
            super(parent, startOffset, endOffset, reader);
        }
    }

    protected static class _TranslationUnit
    extends _CompositeFileContext {
        IScannerPreprocessorLog.IMacroDefinition[] builtins = new IScannerPreprocessorLog.IMacroDefinition[2];
        private int builtinsPos = -1;
        static /* synthetic */ Class class$0;

        public _TranslationUnit() {
            super(null, 0, 0);
        }

        public void addBuiltinMacro(IScannerPreprocessorLog.IMacroDefinition def) {
            if (def != null) {
                ++this.builtinsPos;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.cdt.internal.core.parser.scanner2.IScannerPreprocessorLog$IMacroDefinition");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                this.builtins = (IScannerPreprocessorLog.IMacroDefinition[])ArrayUtil.append(clazz, this.builtins, def);
            }
        }

        public IScannerPreprocessorLog.IMacroDefinition[] getBuiltinMacroDefinitions() {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.internal.core.parser.scanner2.IScannerPreprocessorLog$IMacroDefinition");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.builtins = (IScannerPreprocessorLog.IMacroDefinition[])ArrayUtil.removeNullsAfter(clazz, this.builtins, this.builtinsPos);
            return this.builtins;
        }
    }

    protected static class _MacroDefinition
    extends _Context
    implements IScannerPreprocessorLog.IMacroDefinition {
        public final char[] name;
        public final int nameOffset;
        public IASTPreprocessorMacroDefinition astNode;
        private char[] expansion;
        private IMacro macro;
        private IMacroBinding bind;

        public _MacroDefinition(_CompositeContext parent, int startOffset, int endOffset, char[] name, int nameOffset, char[] expansion) {
            super(parent, startOffset, endOffset);
            this.name = name;
            this.expansion = expansion;
            this.nameOffset = nameOffset;
        }

        public _MacroDefinition(_CompositeContext parent, int startOffset, int endOffset, char[] name, int nameOffset, IMacro macro) {
            super(parent, startOffset, endOffset);
            this.name = name;
            this.macro = macro;
            this.nameOffset = nameOffset;
        }

        public char[] getName() {
            return this.name;
        }

        public char[] getExpansion() {
            if (this.expansion == null && this.macro != null) {
                this.expansion = this.macro.getExpansion();
            }
            return this.expansion;
        }

        public IMacroBinding getBinding() {
            return this.bind;
        }

        public void setBinding(IMacroBinding b) {
            this.bind = b;
        }
    }

    protected static class _ObjectMacroDefinition
    extends _MacroDefinition
    implements _IPreprocessorDirective {
        public _ObjectMacroDefinition(_CompositeContext parent, int startOffset, int endOffset, char[] name, int nameOffset, char[] expansion) {
            super(parent, startOffset, endOffset, name, nameOffset, expansion);
        }

        public _ObjectMacroDefinition(_CompositeContext parent, int startOffset, int endOffset, char[] name, int nameOffset, IMacro macro) {
            super(parent, startOffset, endOffset, name, nameOffset, macro);
        }
    }

    protected static class _FunctionMacroDefinition
    extends _MacroDefinition
    implements _IPreprocessorDirective {
        private final char[][] parms;

        public _FunctionMacroDefinition(_CompositeContext parent, int startOffset, int endOffset, char[] name, int nameOffset, char[] expansion, char[][] parameters) {
            super(parent, startOffset, endOffset, name, nameOffset, expansion);
            this.parms = parameters;
        }

        public _FunctionMacroDefinition(_CompositeContext parent, int startOffset, int endOffset, char[] name, int nameOffset, IMacro macro, char[][] parameters) {
            super(parent, startOffset, endOffset, name, nameOffset, macro);
            this.parms = parameters;
        }

        public char[][] getParms() {
            return this.parms;
        }
    }

    protected static class _Problem
    extends _Context {
        public final IASTProblem problem;

        public _Problem(_CompositeContext parent, int startOffset, int endOffset, IASTProblem problem) {
            super(parent, startOffset, endOffset);
            this.problem = problem;
        }
    }

    protected class _MacroExpansion
    extends _CompositeContext {
        public final IScannerPreprocessorLog.IMacroDefinition definition;
        private IASTName expansionName;

        public _MacroExpansion(_CompositeContext parent, int startOffset, int endOffset, IScannerPreprocessorLog.IMacroDefinition definition) {
            super(parent, startOffset, endOffset);
            this.definition = definition;
        }

        public IASTName getName() {
            if (this.expansionName == null) {
                this.expansionName = new ASTMacroName(this.definition.getName());
                this.expansionName.setParent(LocationMap.this.rootNode);
                this.expansionName.setPropertyInParent(IASTTranslationUnit.EXPANSION_NAME);
                ((ASTNode)((Object)this.expansionName)).setOffsetAndLength(this.context_directive_start, this.context_directive_end - this.context_directive_start + 1);
            }
            return this.expansionName;
        }
    }

    protected class _ObjectMacroExpansion
    extends _MacroExpansion {
        public _ObjectMacroExpansion(_CompositeContext parent, int startOffset, int endOffset, IScannerPreprocessorLog.IMacroDefinition definition) {
            super(parent, startOffset, endOffset, definition);
        }
    }

    protected class _FunctionMacroExpansion
    extends _MacroExpansion {
        public final char[][] args;

        public _FunctionMacroExpansion(_CompositeContext parent, int startOffset, int endOffset, IScannerPreprocessorLog.IMacroDefinition definition, char[][] args) {
            super(parent, startOffset, endOffset, definition);
            this.args = args;
        }
    }

    protected static final class _WeightedContext {
        public final _Context context;
        public final int count;

        public _WeightedContext(_Context c, int currentCount) {
            this.context = c;
            this.count = currentCount;
        }
    }
}

