/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICDebugConfiguration;
import org.eclipse.cdt.debug.core.ICDebugConstants;
import org.eclipse.cdt.debug.mi.core.IMIConstants;
import org.eclipse.cdt.debug.mi.core.IMILaunchConfigurationConstants;
import org.eclipse.cdt.debug.mi.core.IMITTY;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MIProcess;
import org.eclipse.cdt.debug.mi.core.MIProcessAdapter;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.MITTYAdapter;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.command.CLITargetAttach;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIStackListFrames;
import org.eclipse.cdt.debug.mi.core.command.MITargetSelect;
import org.eclipse.cdt.debug.mi.core.command.factories.CommandFactoryManager;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.osgi.framework.BundleContext;

public class MIPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.cdt.debug.mi.core";
    public static final String EXTENSION_POINT_COMMAND_FACTORIES = "commandFactories";
    private static MIPlugin plugin;
    private static final String GDB = "gdb";
    private CommandFactoryManager fCommandFactoryManager;
    private static ResourceBundle fgResourceBundle;

    static {
        try {
            fgResourceBundle = ResourceBundle.getBundle("org.eclipse.cdt.debug.mi.core.MIPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            fgResourceBundle = null;
        }
    }

    public MIPlugin() {
        plugin = this;
    }

    public static MIPlugin getDefault() {
        return plugin;
    }

    public MISession createMISession(MIProcess process, IMITTY pty, int timeout, int type, int launchTimeout, String miVersion, IProgressMonitor monitor) throws MIException {
        return new MISession(process, pty, type, timeout, launchTimeout, miVersion, monitor);
    }

    public MISession createMISession(MIProcess process, IMITTY pty, int type, String miVersion, IProgressMonitor monitor) throws MIException {
        MIPlugin miPlugin = MIPlugin.getDefault();
        Preferences prefs = miPlugin.getPluginPreferences();
        int timeout = prefs.getInt(IMIConstants.PREF_REQUEST_TIMEOUT);
        int launchTimeout = prefs.getInt(IMIConstants.PREF_REQUEST_LAUNCH_TIMEOUT);
        return this.createMISession(process, pty, timeout, type, launchTimeout, miVersion, monitor);
    }

    private MISession createMISession0(int type, MIProcess process, CommandFactory commandFactory, IMITTY pty, int timeout) throws MIException {
        return new MISession(process, pty, type, commandFactory, timeout);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Session createCSession(String gdb, String miVersion, File program, File cwd, String gdbinit, IProgressMonitor monitor) throws IOException, MIException {
        InputStream in2;
        Session session;
        MITTYAdapter pty = null;
        boolean failed = false;
        try {
            PTY pseudo = new PTY();
            pty = new MITTYAdapter(pseudo);
        }
        catch (IOException iOException) {}
        try {
            try {
                session = this.createCSession(gdb, miVersion, program, cwd, gdbinit, pty, monitor);
                Object var10_13 = null;
                if (!failed) return session;
                if (pty == null) return session;
            }
            catch (IOException exc) {
                failed = true;
                throw exc;
            }
            catch (MIException exc) {
                failed = true;
                throw exc;
            }
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            if (!failed) throw throwable;
            if (pty == null) throw throwable;
            try {
                InputStream in2;
                OutputStream out = pty.getOutputStream();
                if (out != null) {
                    out.close();
                }
                if ((in2 = pty.getInputStream()) == null) throw throwable;
                in2.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw throwable;
            }
        }
        try {}
        catch (IOException iOException) {}
        OutputStream out = pty.getOutputStream();
        if (out != null) {
            out.close();
        }
        if ((in2 = pty.getInputStream()) == null) return session;
        in2.close();
        return session;
    }

    public Session createCSession(String gdb, String miVersion, File program, File cwd, String gdbinit, IMITTY pty, IProgressMonitor monitor) throws IOException, MIException {
        MISession session;
        String commandFile;
        if (gdb == null || gdb.length() == 0) {
            gdb = GDB;
        }
        String string = commandFile = gdbinit != null && gdbinit.length() > 0 ? "--command=" + gdbinit : "--nx";
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        String[] args = pty != null ? (program == null ? new String[]{gdb, "--cd=" + cwd.getAbsolutePath(), commandFile, "-q", "-nw", "-tty", pty.getSlaveName(), "-i", miVersion} : new String[]{gdb, "--cd=" + cwd.getAbsolutePath(), commandFile, "-q", "-nw", "-tty", pty.getSlaveName(), "-i", miVersion, program.getAbsolutePath()}) : (program == null ? new String[]{gdb, "--cd=" + cwd.getAbsolutePath(), commandFile, "-q", "-nw", "-i", miVersion} : new String[]{gdb, "--cd=" + cwd.getAbsolutePath(), commandFile, "-q", "-nw", "-i", miVersion, program.getAbsolutePath()});
        int launchTimeout = MIPlugin.getDefault().getPluginPreferences().getInt(IMIConstants.PREF_REQUEST_LAUNCH_TIMEOUT);
        MIProcessAdapter pgdb = new MIProcessAdapter(args, launchTimeout, monitor);
        if (MIPlugin.getDefault().isDebugging()) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < args.length) {
                sb.append(args[i]);
                sb.append(' ');
                ++i;
            }
            MIPlugin.getDefault().debugLog(sb.toString());
        }
        try {
            session = this.createMISession(pgdb, pty, 0, miVersion, monitor);
        }
        catch (MIException e) {
            pgdb.destroy();
            throw e;
        }
        try {
            CommandFactory factory = session.getCommandFactory();
            MIStackListFrames frames = factory.createMIStackListFrames();
            session.postCommand(frames);
            MIInfo info = frames.getMIInfo();
            if (info == null) {
                pgdb.destroy();
                throw new MIException(MIPlugin.getResourceString("src.common.No_answer"));
            }
            session.getMIInferior().setSuspended();
            session.getMIInferior().update();
        }
        catch (MIException mIException) {}
        return new Session(session, false);
    }

    public Session createCSession(String gdb, String miVersion, File program, File core, File cwd, String gdbinit, IProgressMonitor monitor) throws IOException, MIException {
        MISession session;
        String commandFile;
        if (gdb == null || gdb.length() == 0) {
            gdb = GDB;
        }
        String string = commandFile = gdbinit != null && gdbinit.length() > 0 ? "--command=" + gdbinit : "--nx";
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        String[] args = program == null ? new String[]{gdb, "--cd=" + cwd.getAbsolutePath(), commandFile, "--quiet", "-nw", "-i", miVersion, "-c", core.getAbsolutePath()} : new String[]{gdb, "--cd=" + cwd.getAbsolutePath(), commandFile, "--quiet", "-nw", "-i", miVersion, "-c", core.getAbsolutePath(), program.getAbsolutePath()};
        int launchTimeout = MIPlugin.getDefault().getPluginPreferences().getInt(IMIConstants.PREF_REQUEST_LAUNCH_TIMEOUT);
        MIProcessAdapter pgdb = new MIProcessAdapter(args, launchTimeout, monitor);
        if (MIPlugin.getDefault().isDebugging()) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < args.length) {
                sb.append(args[i]);
                sb.append(' ');
                ++i;
            }
            MIPlugin.getDefault().debugLog(sb.toString());
        }
        try {
            session = this.createMISession(pgdb, null, 2, miVersion, monitor);
            session.getMIInferior().setSuspended();
        }
        catch (MIException e) {
            pgdb.destroy();
            throw e;
        }
        return new Session(session);
    }

    public Session createCSession(String gdb, String miVersion, File program, int pid, String[] targetParams, File cwd, String gdbinit, IProgressMonitor monitor) throws IOException, MIException {
        MISession session;
        String commandFile;
        if (gdb == null || gdb.length() == 0) {
            gdb = GDB;
        }
        String string = commandFile = gdbinit != null && gdbinit.length() > 0 ? "--command=" + gdbinit : "--nx";
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        String[] args = program == null ? new String[]{gdb, "--cd=" + cwd.getAbsolutePath(), commandFile, "--quiet", "-nw", "-i", miVersion} : new String[]{gdb, "--cd=" + cwd.getAbsolutePath(), commandFile, "--quiet", "-nw", "-i", miVersion, program.getAbsolutePath()};
        int launchTimeout = MIPlugin.getDefault().getPluginPreferences().getInt(IMIConstants.PREF_REQUEST_LAUNCH_TIMEOUT);
        MIProcessAdapter pgdb = new MIProcessAdapter(args, launchTimeout, monitor);
        if (MIPlugin.getDefault().isDebugging()) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < args.length) {
                sb.append(args[i]);
                sb.append(' ');
                ++i;
            }
            MIPlugin.getDefault().debugLog(sb.toString());
        }
        try {
            session = this.createMISession(pgdb, null, 1, miVersion, monitor);
        }
        catch (MIException e) {
            pgdb.destroy();
            throw e;
        }
        CommandFactory factory = session.getCommandFactory();
        try {
            MIInfo info;
            if (targetParams != null && targetParams.length > 0) {
                MITargetSelect target = factory.createMITargetSelect(targetParams);
                session.postCommand(target);
                info = target.getMIInfo();
                if (info == null) {
                    throw new MIException(MIPlugin.getResourceString("src.common.No_answer"));
                }
            }
            if (pid > 0) {
                CLITargetAttach attach = factory.createCLITargetAttach(pid);
                session.postCommand(attach);
                info = attach.getMIInfo();
                if (info == null) {
                    throw new MIException(MIPlugin.getResourceString("src.common.No_answer"));
                }
                session.getMIInferior().setInferiorPID(pid);
                session.getMIInferior().setConnected();
            }
        }
        catch (MIException e) {
            pgdb.destroy();
            throw e;
        }
        session.getMIInferior().setSuspended();
        session.getMIInferior().update();
        return new Session(session, true);
    }

    /*
     * Exception decompiling
     */
    public Session createSession(int sessionType, String gdb, CommandFactory factory, File program, String[] extraArgs, boolean usePty, IProgressMonitor monitor) throws IOException, MIException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [4 : 400->403)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String getUniqueIdentifier() {
        if (MIPlugin.getDefault() == null) {
            return PLUGIN_ID;
        }
        return MIPlugin.getDefault().getBundle().getSymbolicName();
    }

    public void debugLog(String message) {
        if (MIPlugin.getDefault().isDebugging()) {
            message = MessageFormat.format("[{0}] {1}", new Long(System.currentTimeMillis()), message);
            while (message.length() > 100) {
                String partial = message.substring(0, 100);
                message = message.substring(100);
                System.out.println(String.valueOf(partial) + "\\");
            }
            if (message.endsWith("\n")) {
                System.out.print(message);
            } else {
                System.out.println(message);
            }
        }
    }

    public static String getResourceString(String key) {
        try {
            return fgResourceBundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return String.valueOf('!') + key + '!';
        }
        catch (NullPointerException nullPointerException) {
            return String.valueOf('#') + key + '#';
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        ICDebugConfiguration dc = CDebugCorePlugin.getDefault().getDefaultDefaultDebugConfiguration();
        if (dc == null) {
            CDebugCorePlugin.getDefault().getPluginPreferences().setDefault(ICDebugConstants.PREF_DEFAULT_DEBUGGER_TYPE, "org.eclipse.cdt.debug.mi.core.CDebuggerNew");
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.savePluginPreferences();
        super.stop(context);
    }

    public static int getCommandTimeout() {
        Preferences prefs = MIPlugin.getDefault().getPluginPreferences();
        return prefs.getInt(IMIConstants.PREF_REQUEST_TIMEOUT);
    }

    public static int getLaunchTimeout() {
        Preferences prefs = plugin.getPluginPreferences();
        return prefs.getInt(IMIConstants.PREF_REQUEST_LAUNCH_TIMEOUT);
    }

    public static String getMIVersion(ILaunchConfiguration config) {
        String miVersion = "";
        try {
            miVersion = config.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_PROTOCOL, "");
        }
        catch (CoreException coreException) {}
        if (miVersion.length() == 0) {
            try {
                miVersion = config.getAttribute("org.eclipse.cdt.launch.protocol", "mi");
            }
            catch (CoreException coreException) {
                miVersion = "mi";
            }
        }
        return miVersion;
    }

    public static String getCommandFactory(ILaunchConfiguration config) {
        String commandFactory = "";
        try {
            commandFactory = config.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_COMMAND_FACTORY, "");
        }
        catch (CoreException coreException) {}
        return commandFactory;
    }

    public CommandFactoryManager getCommandFactoryManager() {
        if (this.fCommandFactoryManager == null) {
            this.fCommandFactoryManager = new CommandFactoryManager();
        }
        return this.fCommandFactoryManager;
    }
}

