/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.indexview;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOMNode;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeVisitor;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMFile;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMMacro;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMName;
import org.eclipse.cdt.internal.ui.indexview.IndexAction;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;

public class CountNodeAction
extends IndexAction {
    static final int FILES = 0;
    static final int MACROS = 1;
    static final int SYMBOLS = 2;
    static final int REFS = 3;
    static final int DECLS = 4;
    static final int DEFS = 5;

    public CountNodeAction(TreeViewer viewer) {
        super(viewer, CUIPlugin.getResourceString("IndexView.CountSymbols.name"));
    }

    public boolean valid() {
        ISelection selection = this.viewer.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return false;
        }
        Object[] objs = ((IStructuredSelection)selection).toArray();
        int i = 0;
        while (i < objs.length) {
            if (objs[i] instanceof ICProject) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void run() {
        final int[] count = new int[6];
        try {
            ISelection selection = this.viewer.getSelection();
            if (!(selection instanceof IStructuredSelection)) {
                return;
            }
            Object[] objs = ((IStructuredSelection)selection).toArray();
            int i = 0;
            while (i < objs.length) {
                if (objs[i] instanceof ICProject) {
                    ICProject project = (ICProject)objs[i];
                    final PDOM pdom = (PDOM)CCorePlugin.getPDOMManager().getPDOM(project);
                    pdom.getFileIndex().accept(new IBTreeVisitor(){

                        public int compare(int record) throws CoreException {
                            return 1;
                        }

                        public boolean visit(int record) throws CoreException {
                            if (record != 0) {
                                PDOMFile file = new PDOMFile(pdom, record);
                                count[0] = count[0] + 1;
                                PDOMMacro macro = file.getFirstMacro();
                                while (macro != null) {
                                    count[1] = count[1] + 1;
                                    macro = macro.getNextMacro();
                                }
                            }
                            return true;
                        }
                    });
                    pdom.accept(new IPDOMVisitor(){

                        public boolean visit(IPDOMNode node) throws CoreException {
                            count[2] = count[2] + 1;
                            if (node instanceof PDOMBinding) {
                                PDOMBinding binding = (PDOMBinding)node;
                                PDOMName name = binding.getFirstReference();
                                while (name != null) {
                                    count[3] = count[3] + 1;
                                    name = name.getNextInBinding();
                                }
                                name = binding.getFirstDeclaration();
                                while (name != null) {
                                    count[4] = count[4] + 1;
                                    name = name.getNextInBinding();
                                }
                                name = binding.getFirstDefinition();
                                while (name != null) {
                                    count[5] = count[5] + 1;
                                    name = name.getNextInBinding();
                                }
                            }
                            return true;
                        }

                        public void leave(IPDOMNode node) throws CoreException {
                        }
                    });
                }
                ++i;
            }
        }
        catch (CoreException e) {
            CUIPlugin.getDefault().log(e);
        }
        MessageDialog.openInformation(null, (String)CUIPlugin.getResourceString("IndexView.CountSymbols.title"), (String)CUIPlugin.getFormattedString("IndexView.CountSymbols.message", new String[]{String.valueOf(count[0]), String.valueOf(count[1]), String.valueOf(count[2]), String.valueOf(count[3]), String.valueOf(count[4]), String.valueOf(count[5])}));
    }
}

