/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.wizards;

import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.CConventions;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.browser.AllTypesCache;
import org.eclipse.cdt.core.browser.IQualifiedTypeName;
import org.eclipse.cdt.core.browser.ITypeInfo;
import org.eclipse.cdt.core.browser.ITypeSearchScope;
import org.eclipse.cdt.core.browser.PathUtil;
import org.eclipse.cdt.core.browser.QualifiedTypeName;
import org.eclipse.cdt.core.browser.TypeSearchScope;
import org.eclipse.cdt.core.browser.TypeUtil;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.cdt.internal.ui.util.SWTUtil;
import org.eclipse.cdt.internal.ui.wizards.NewElementWizardPage;
import org.eclipse.cdt.internal.ui.wizards.SourceFolderSelectionDialog;
import org.eclipse.cdt.internal.ui.wizards.classwizard.BaseClassInfo;
import org.eclipse.cdt.internal.ui.wizards.classwizard.BaseClassesListDialogField;
import org.eclipse.cdt.internal.ui.wizards.classwizard.ConstructorMethodStub;
import org.eclipse.cdt.internal.ui.wizards.classwizard.DestructorMethodStub;
import org.eclipse.cdt.internal.ui.wizards.classwizard.IBaseClassInfo;
import org.eclipse.cdt.internal.ui.wizards.classwizard.IMethodStub;
import org.eclipse.cdt.internal.ui.wizards.classwizard.MethodStubsListDialogField;
import org.eclipse.cdt.internal.ui.wizards.classwizard.NamespaceSelectionDialog;
import org.eclipse.cdt.internal.ui.wizards.classwizard.NewBaseClassSelectionDialog;
import org.eclipse.cdt.internal.ui.wizards.classwizard.NewClassCodeGenerator;
import org.eclipse.cdt.internal.ui.wizards.classwizard.NewClassWizardMessages;
import org.eclipse.cdt.internal.ui.wizards.classwizard.NewClassWizardPrefs;
import org.eclipse.cdt.internal.ui.wizards.classwizard.NewClassWizardUtil;
import org.eclipse.cdt.internal.ui.wizards.classwizard.SourceFileSelectionDialog;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.Separator;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class NewClassCreationWizardPage
extends NewElementWizardPage {
    protected static final String PAGE_NAME = "NewClassWizardPage";
    protected static final int MAX_FIELD_CHARS = 50;
    protected static final int SOURCE_FOLDER_ID = 1;
    protected static final int NAMESPACE_ID = 2;
    protected static final int CLASS_NAME_ID = 4;
    protected static final int BASE_CLASSES_ID = 8;
    protected static final int METHOD_STUBS_ID = 16;
    protected static final int HEADER_FILE_ID = 32;
    protected static final int SOURCE_FILE_ID = 64;
    protected static final int ALL_FIELDS = 127;
    protected int fLastFocusedField = 0;
    protected StringButtonDialogField fSourceFolderDialogField;
    protected SelectionButtonDialogField fNamespaceSelection;
    protected StringButtonDialogField fNamespaceDialogField;
    protected StringDialogField fClassNameDialogField;
    protected BaseClassesListDialogField fBaseClassesDialogField;
    protected MethodStubsListDialogField fMethodStubsDialogField;
    protected SelectionButtonDialogField fUseDefaultSelection;
    protected StringButtonDialogField fHeaderFileDialogField;
    protected StringButtonDialogField fSourceFileDialogField;
    protected IStatus fSourceFolderStatus;
    protected IStatus fNamespaceStatus;
    protected IStatus fClassNameStatus;
    protected IStatus fBaseClassesStatus;
    protected IStatus fMethodStubsStatus;
    protected IStatus fHeaderFileStatus;
    protected IStatus fSourceFileStatus;
    protected final IStatus STATUS_OK = new StatusInfo();
    protected IFile fCreatedSourceFile = null;
    protected IFile fCreatedHeaderFile = null;
    protected ICElement fCreatedClass = null;
    protected static final IMethodStub[] DEFAULT_METHOD_STUBS = new IMethodStub[]{new ConstructorMethodStub(), new DestructorMethodStub()};
    private static final int MAX_UNIQUE_CLASSNAME = 99;

    public NewClassCreationWizardPage() {
        super(PAGE_NAME);
        this.setDescription(NewClassWizardMessages.getString("NewClassCreationWizardPage.description"));
        SourceFolderFieldAdapter sourceFolderAdapter = new SourceFolderFieldAdapter();
        this.fSourceFolderDialogField = new StringButtonDialogField(sourceFolderAdapter);
        this.fSourceFolderDialogField.setDialogFieldListener(sourceFolderAdapter);
        this.fSourceFolderDialogField.setLabelText(NewClassWizardMessages.getString("NewClassCreationWizardPage.sourceFolder.label"));
        this.fSourceFolderDialogField.setButtonLabel(NewClassWizardMessages.getString("NewClassCreationWizardPage.sourceFolder.button"));
        NamespaceFieldAdapter namespaceAdapter = new NamespaceFieldAdapter();
        this.fNamespaceSelection = new SelectionButtonDialogField(32);
        this.fNamespaceSelection.setDialogFieldListener(namespaceAdapter);
        this.fNamespaceSelection.setLabelText(NewClassWizardMessages.getString("NewClassCreationWizardPage.namespace.label"));
        this.fNamespaceDialogField = new StringButtonDialogField(namespaceAdapter);
        this.fNamespaceDialogField.setDialogFieldListener(namespaceAdapter);
        this.fNamespaceDialogField.setButtonLabel(NewClassWizardMessages.getString("NewClassCreationWizardPage.namespace.button"));
        ClassNameFieldAdapter classAdapter = new ClassNameFieldAdapter();
        this.fClassNameDialogField = new StringDialogField();
        this.fClassNameDialogField.setDialogFieldListener(classAdapter);
        this.fClassNameDialogField.setLabelText(NewClassWizardMessages.getString("NewClassCreationWizardPage.className.label"));
        BaseClassesFieldAdapter baseClassesAdapter = new BaseClassesFieldAdapter();
        this.fBaseClassesDialogField = new BaseClassesListDialogField(NewClassWizardMessages.getString("NewClassCreationWizardPage.baseClasses.label"), baseClassesAdapter);
        MethodStubsFieldAdapter methodStubsAdapter = new MethodStubsFieldAdapter();
        this.fMethodStubsDialogField = new MethodStubsListDialogField(NewClassWizardMessages.getString("NewClassCreationWizardPage.methodStubs.label"), methodStubsAdapter);
        FileGroupFieldAdapter fileGroupAdapter = new FileGroupFieldAdapter();
        this.fUseDefaultSelection = new SelectionButtonDialogField(32);
        this.fUseDefaultSelection.setDialogFieldListener(fileGroupAdapter);
        this.fUseDefaultSelection.setLabelText(NewClassWizardMessages.getString("NewClassCreationWizardPage.useDefaultLocation.label"));
        this.fHeaderFileDialogField = new StringButtonDialogField(fileGroupAdapter);
        this.fHeaderFileDialogField.setDialogFieldListener(fileGroupAdapter);
        this.fHeaderFileDialogField.setLabelText(NewClassWizardMessages.getString("NewClassCreationWizardPage.headerFile.label"));
        this.fHeaderFileDialogField.setButtonLabel(NewClassWizardMessages.getString("NewClassCreationWizardPage.headerFile.button"));
        this.fSourceFileDialogField = new StringButtonDialogField(fileGroupAdapter);
        this.fSourceFileDialogField.setDialogFieldListener(fileGroupAdapter);
        this.fSourceFileDialogField.setLabelText(NewClassWizardMessages.getString("NewClassCreationWizardPage.sourceFile.label"));
        this.fSourceFileDialogField.setButtonLabel(NewClassWizardMessages.getString("NewClassCreationWizardPage.sourceFile.button"));
        this.fSourceFolderStatus = this.STATUS_OK;
        this.fNamespaceStatus = this.STATUS_OK;
        this.fClassNameStatus = this.STATUS_OK;
        this.fBaseClassesStatus = this.STATUS_OK;
        this.fMethodStubsStatus = this.STATUS_OK;
        this.fHeaderFileStatus = this.STATUS_OK;
        this.fSourceFileStatus = this.STATUS_OK;
        this.fLastFocusedField = 0;
        this.updateNamespaceEnableState();
        this.updateFileGroupEnableState();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        this.createSourceFolderControls(composite, nColumns);
        this.createNamespaceControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createClassNameControls(composite, nColumns);
        this.createBaseClassesControls(composite, nColumns);
        this.createMethodStubsControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createFileControls(composite, nColumns);
        composite.layout();
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
    }

    protected void createSeparator(Composite composite, int nColumns) {
        new Separator(258).doFillIntoGrid(composite, nColumns, this.convertHeightInCharsToPixels(1));
    }

    protected void createSourceFolderControls(Composite parent, int nColumns) {
        this.fSourceFolderDialogField.doFillIntoGrid(parent, nColumns);
        Text textControl = this.fSourceFolderDialogField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)textControl, this.getMaxFieldWidth());
        textControl.addFocusListener((FocusListener)new StatusFocusListener(1));
    }

    protected void createNamespaceControls(Composite composite, int nColumns) {
        Composite tabGroup = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        tabGroup.setLayout((Layout)layout);
        this.fNamespaceSelection.doFillIntoGrid(tabGroup, 1);
        Text textControl = this.fNamespaceDialogField.getTextControl(composite);
        GridData gd = new GridData(768);
        gd.widthHint = this.getMaxFieldWidth();
        gd.horizontalSpan = 2;
        textControl.setLayoutData((Object)gd);
        textControl.addFocusListener((FocusListener)new StatusFocusListener(2));
        Button button = this.fNamespaceDialogField.getChangeControl(composite);
        gd = new GridData(256);
        gd.heightHint = SWTUtil.getButtonHeigthHint(button);
        gd.widthHint = SWTUtil.getButtonWidthHint(button);
        button.setLayoutData((Object)gd);
    }

    protected void createClassNameControls(Composite composite, int nColumns) {
        this.fClassNameDialogField.doFillIntoGrid(composite, nColumns - 1);
        DialogField.createEmptySpace(composite);
        Text textControl = this.fClassNameDialogField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)textControl, this.getMaxFieldWidth());
        textControl.addFocusListener((FocusListener)new StatusFocusListener(4));
    }

    protected void createBaseClassesControls(Composite composite, int nColumns) {
        this.fBaseClassesDialogField.doFillIntoGrid(composite, nColumns);
        Control listControl = this.fBaseClassesDialogField.getListControl(null);
        GridData gd = (GridData)listControl.getLayoutData();
        gd.heightHint = this.convertHeightInCharsToPixels(5);
        gd.grabExcessVerticalSpace = false;
        gd.widthHint = this.getMaxFieldWidth();
        listControl.addFocusListener((FocusListener)new StatusFocusListener(8));
    }

    protected void createMethodStubsControls(Composite composite, int nColumns) {
        this.fMethodStubsDialogField.doFillIntoGrid(composite, nColumns);
        Control listControl = this.fMethodStubsDialogField.getListControl(null);
        GridData gd = (GridData)listControl.getLayoutData();
        gd.heightHint = this.convertHeightInCharsToPixels(5);
        gd.grabExcessVerticalSpace = false;
        gd.widthHint = this.getMaxFieldWidth();
        listControl.addFocusListener((FocusListener)new StatusFocusListener(16));
    }

    protected void createFileControls(Composite composite, int nColumns) {
        Composite tabGroup = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        tabGroup.setLayout((Layout)layout);
        this.fUseDefaultSelection.doFillIntoGrid(tabGroup, 1);
        LayoutUtil.setHorizontalSpan((Control)this.fHeaderFileDialogField.getLabelControl(composite), 1);
        Text textControl = this.fHeaderFileDialogField.getTextControl(composite);
        GridData gd = new GridData(768);
        gd.widthHint = this.getMaxFieldWidth();
        gd.horizontalSpan = 1;
        textControl.setLayoutData((Object)gd);
        textControl.addFocusListener((FocusListener)new StatusFocusListener(32));
        Button button = this.fHeaderFileDialogField.getChangeControl(composite);
        gd = new GridData(256);
        gd.heightHint = SWTUtil.getButtonHeigthHint(button);
        gd.widthHint = SWTUtil.getButtonWidthHint(button);
        button.setLayoutData((Object)gd);
        DialogField.createEmptySpace(composite, 1);
        LayoutUtil.setHorizontalSpan((Control)this.fSourceFileDialogField.getLabelControl(composite), 1);
        textControl = this.fSourceFileDialogField.getTextControl(composite);
        gd = new GridData(768);
        gd.widthHint = this.getMaxFieldWidth();
        gd.horizontalSpan = 1;
        textControl.setLayoutData((Object)gd);
        textControl.addFocusListener((FocusListener)new StatusFocusListener(64));
        button = this.fSourceFileDialogField.getChangeControl(composite);
        gd = new GridData(256);
        gd.heightHint = SWTUtil.getButtonHeigthHint(button);
        gd.widthHint = SWTUtil.getButtonWidthHint(button);
        button.setLayoutData((Object)gd);
    }

    public void init(IStructuredSelection selection) {
        String text;
        ICElement ns;
        ICElement celem = this.getInitialCElement(selection);
        String namespace = null;
        if (celem != null && (ns = NewClassWizardUtil.getNamespace(celem)) != null && (namespace = TypeUtil.getFullyQualifiedName((ICElement)ns).toString()) == null && namespace.length() == 0) {
            namespace = null;
        }
        this.setNamespaceText(namespace, false);
        this.setNamespaceSelection(namespace != null, true);
        IPath folderPath = null;
        if (celem != null) {
            ICProject cproject;
            ICContainer folder = NewClassWizardUtil.getSourceFolder(celem);
            if (folder == null && (cproject = celem.getCProject()) != null) {
                folder = NewClassWizardUtil.getFirstSourceRoot(cproject);
            }
            if (folder != null) {
                folderPath = folder.getResource().getFullPath();
            }
        }
        this.setSourceFolderFullPath(folderPath, false);
        String className = null;
        ITextSelection textSel = this.getEditorTextSelection();
        if (textSel != null && (text = textSel.getText()) != null && text.length() > 0 && CConventions.validateClassName((String)text).isOK()) {
            className = text;
        }
        this.setClassName(className, false);
        IMethodStub[] stubs = this.getDefaultMethodStubs();
        int i = 0;
        while (i < stubs.length) {
            this.addMethodStub(stubs[i], true);
            ++i;
        }
        this.setUseDefaultSelection(true, true);
        this.handleFieldChanged(127);
    }

    protected ICElement getInitialCElement(IStructuredSelection selection) {
        ICElement celem = NewClassWizardUtil.getCElementFromSelection(selection);
        if (celem == null) {
            celem = NewClassWizardUtil.getCElementFromEditor();
        }
        if (celem == null || celem.getElementType() == 10) {
            try {
                ICProject[] projects = CoreModel.create((IWorkspaceRoot)NewClassWizardUtil.getWorkspaceRoot()).getCProjects();
                if (projects.length == 1) {
                    celem = projects[0];
                }
            }
            catch (CModelException e) {
                CUIPlugin.getDefault().log(e);
            }
        }
        return celem;
    }

    protected int getMaxFieldWidth() {
        return this.convertWidthInCharsToPixels(50);
    }

    protected ITextSelection getEditorTextSelection() {
        ISelection selection;
        ISelectionProvider selectionProvider;
        IWorkbenchPart part;
        IWorkbenchPage page = CUIPlugin.getActivePage();
        if (page != null && (part = page.getActivePart()) instanceof IEditorPart && (selectionProvider = part.getSite().getSelectionProvider()) != null && (selection = selectionProvider.getSelection()) instanceof ITextSelection) {
            return (ITextSelection)selection;
        }
        return null;
    }

    protected IMethodStub[] getDefaultMethodStubs() {
        return DEFAULT_METHOD_STUBS;
    }

    public String getSourceFolderText() {
        return this.fSourceFolderDialogField.getText();
    }

    public void setSourceFolderText(String folder, boolean update) {
        this.fSourceFolderDialogField.setTextWithoutUpdate(folder != null ? folder : "");
        if (update) {
            this.fSourceFolderDialogField.dialogFieldChanged();
        }
    }

    protected IPath getSourceFolderFullPath() {
        String text = this.getSourceFolderText();
        if (text.length() > 0) {
            return new Path(text).makeAbsolute();
        }
        return null;
    }

    protected void setSourceFolderFullPath(IPath folderPath, boolean update) {
        String str = folderPath != null ? folderPath.makeRelative().toString() : "";
        this.setSourceFolderText(str, update);
    }

    protected ICProject getCurrentProject() {
        IPath folderPath = this.getSourceFolderFullPath();
        if (folderPath != null) {
            return PathUtil.getEnclosingProject((IPath)folderPath);
        }
        return null;
    }

    public String getNamespaceText() {
        return this.fNamespaceDialogField.getText();
    }

    public void setNamespaceText(String namespace, boolean update) {
        this.fNamespaceDialogField.setTextWithoutUpdate(namespace != null ? namespace : "");
        if (update) {
            this.fNamespaceDialogField.dialogFieldChanged();
        }
    }

    public boolean isNamespaceSelected() {
        return this.fNamespaceSelection.isSelected();
    }

    public void setNamespaceSelection(boolean isSelected, boolean canBeModified) {
        this.fNamespaceSelection.setSelection(isSelected);
        this.fNamespaceSelection.setEnabled(canBeModified);
        this.updateNamespaceEnableState();
    }

    private void updateNamespaceEnableState() {
        this.fNamespaceDialogField.setEnabled(this.isNamespaceSelected());
    }

    public String getClassName() {
        return this.fClassNameDialogField.getText();
    }

    public void setClassName(String name, boolean update) {
        this.fClassNameDialogField.setTextWithoutUpdate(name != null ? name : "");
        if (update) {
            this.fClassNameDialogField.dialogFieldChanged();
        }
    }

    protected IMethodStub[] getSelectedMethodStubs() {
        return this.fMethodStubsDialogField.getCheckedMethodStubs();
    }

    protected void addMethodStub(IMethodStub methodStub, boolean selected) {
        this.fMethodStubsDialogField.addMethodStub(methodStub, selected);
    }

    protected IBaseClassInfo[] getBaseClasses() {
        List classesList = this.fBaseClassesDialogField.getElements();
        return classesList.toArray(new IBaseClassInfo[classesList.size()]);
    }

    protected void addBaseClass(ITypeInfo newBaseClass, ASTAccessVisibility access, boolean isVirtual) {
        List baseClasses = this.fBaseClassesDialogField.getElements();
        if (baseClasses != null) {
            Iterator i = baseClasses.iterator();
            while (i.hasNext()) {
                BaseClassInfo info = (BaseClassInfo)i.next();
                if (!info.getType().equals(newBaseClass)) continue;
                return;
            }
        }
        if (this.verifyBaseClasses()) {
            NewClassWizardUtil.resolveClassLocation(newBaseClass, (IRunnableContext)this.getContainer());
        }
        this.fBaseClassesDialogField.addBaseClass(new BaseClassInfo(newBaseClass, access, isVirtual));
    }

    public boolean isUseDefaultSelected() {
        return this.fUseDefaultSelection.isSelected();
    }

    public void setUseDefaultSelection(boolean isSelected, boolean canBeModified) {
        this.fUseDefaultSelection.setSelection(isSelected);
        this.fUseDefaultSelection.setEnabled(canBeModified);
        this.updateFileGroupEnableState();
    }

    private void updateFileGroupEnableState() {
        boolean filegroup = !this.isUseDefaultSelected();
        this.fHeaderFileDialogField.setEnabled(filegroup);
        this.fSourceFileDialogField.setEnabled(filegroup);
    }

    public String getHeaderFileText() {
        return this.fHeaderFileDialogField.getText();
    }

    public void setHeaderFileText(String header, boolean update) {
        this.fHeaderFileDialogField.setTextWithoutUpdate(header != null ? header : "");
        if (update) {
            this.fHeaderFileDialogField.dialogFieldChanged();
        }
    }

    protected IPath getHeaderFileFullPath() {
        IPath folderPath;
        String str = this.getHeaderFileText();
        Path path = null;
        if (str.length() > 0 && !(path = new Path(str)).isAbsolute() && (folderPath = this.getSourceFolderFullPath()) != null) {
            path = folderPath.append((IPath)path);
        }
        return path;
    }

    protected void setHeaderFileFullPath(IPath path, boolean update) {
        String str = null;
        if (path != null) {
            IPath relativePath;
            IPath sourceFolder = this.getSourceFolderFullPath();
            if (sourceFolder != null && (relativePath = PathUtil.makeRelativePath((IPath)path, (IPath)sourceFolder)) != null) {
                path = relativePath;
            }
            str = path.makeRelative().toString();
        }
        this.setHeaderFileText(str, update);
    }

    public String getSourceFileText() {
        return this.fSourceFileDialogField.getText();
    }

    public void setSourceFileText(String source, boolean update) {
        this.fSourceFileDialogField.setTextWithoutUpdate(source != null ? source : "");
        if (update) {
            this.fSourceFileDialogField.dialogFieldChanged();
        }
    }

    protected IPath getSourceFileFullPath() {
        IPath folderPath;
        String str = this.getSourceFileText();
        Path path = null;
        if (str.length() > 0 && !(path = new Path(str)).isAbsolute() && (folderPath = this.getSourceFolderFullPath()) != null) {
            path = folderPath.append((IPath)path);
        }
        return path;
    }

    protected void setSourceFileFullPath(IPath path, boolean update) {
        String str = null;
        if (path != null) {
            IPath relativePath;
            IPath sourceFolder = this.getSourceFolderFullPath();
            if (sourceFolder != null && (relativePath = PathUtil.makeRelativePath((IPath)path, (IPath)sourceFolder)) != null) {
                path = relativePath;
            }
            str = path.makeRelative().toString();
        }
        this.setSourceFileText(str, update);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setFocus();
        }
    }

    protected void setFocus() {
        this.fClassNameDialogField.setFocus();
    }

    private IPath chooseSourceFolder(IPath initialPath) {
        Object result;
        ICProject cProject;
        ISourceRoot projRoot;
        ICContainer initElement = NewClassWizardUtil.getSourceFolder(initialPath);
        if (initElement instanceof ISourceRoot && (projRoot = (cProject = initElement.getCProject()).findSourceRoot((IResource)cProject.getProject())) != null && projRoot.equals(initElement)) {
            initElement = cProject;
        }
        SourceFolderSelectionDialog dialog = new SourceFolderSelectionDialog(this.getShell());
        dialog.setInput(CoreModel.create((IWorkspaceRoot)NewClassWizardUtil.getWorkspaceRoot()));
        dialog.setInitialSelection(initElement);
        if (dialog.open() == 0 && (result = dialog.getFirstResult()) instanceof ICElement) {
            ICProject cproject;
            ISourceRoot folder;
            ICElement element = (ICElement)result;
            if (element instanceof ICProject && (folder = (cproject = (ICProject)element).findSourceRoot((IResource)cproject.getProject())) != null) {
                return folder.getResource().getFullPath();
            }
            return element.getResource().getFullPath();
        }
        return null;
    }

    private IPath updateSourceFolderFromPath(IPath filePath) {
        ICProject cProject;
        ISourceRoot projRoot;
        ICContainer folder = NewClassWizardUtil.getSourceFolder(filePath);
        if (folder instanceof ISourceRoot && (projRoot = (cProject = folder.getCProject()).findSourceRoot((IResource)cProject.getProject())) != null && projRoot.equals(folder)) {
            folder = cProject;
        }
        if (folder != null) {
            return folder.getPath();
        }
        ICProject proj = PathUtil.getEnclosingProject((IPath)filePath);
        if (proj != null) {
            return proj.getProject().getFullPath();
        }
        return null;
    }

    private ITypeInfo chooseNamespace() {
        ICProject project = this.getCurrentProject();
        TypeSearchScope scope = project != null ? new TypeSearchScope(project) : new TypeSearchScope(true);
        Object[] elements = AllTypesCache.getNamespaces((ITypeSearchScope)scope, (boolean)false);
        if (elements == null || elements.length == 0) {
            String title = NewClassWizardMessages.getString("NewClassCreationWizardPage.getTypes.noNamespaces.title");
            String message = NewClassWizardMessages.getString("NewClassCreationWizardPage.getTypes.noNamespaces.message");
            MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)message);
            return null;
        }
        NamespaceSelectionDialog dialog = new NamespaceSelectionDialog(this.getShell());
        dialog.setElements(elements);
        int result = dialog.open();
        if (result == 0) {
            return (ITypeInfo)dialog.getFirstResult();
        }
        return null;
    }

    private void chooseBaseClasses() {
        Object[] elements = NewClassWizardUtil.getReachableClasses(this.getCurrentProject());
        if (elements == null || elements.length == 0) {
            String title = NewClassWizardMessages.getString("NewClassCreationWizardPage.getTypes.noClasses.title");
            String message = NewClassWizardMessages.getString("NewClassCreationWizardPage.getTypes.noClasses.message");
            MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)message);
            return;
        }
        List oldContents = this.fBaseClassesDialogField.getElements();
        NewBaseClassSelectionDialog dialog = new NewBaseClassSelectionDialog(this.getShell());
        dialog.addListener(new NewBaseClassSelectionDialog.ITypeSelectionListener(){

            public void typeAdded(ITypeInfo newBaseClass) {
                NewClassCreationWizardPage.this.addBaseClass(newBaseClass, ASTAccessVisibility.PUBLIC, false);
            }
        });
        dialog.setElements(elements);
        int result = dialog.open();
        if (result != 0) {
            this.fBaseClassesDialogField.setElements(oldContents);
        }
    }

    private IPath chooseHeaderFile() {
        SourceFileSelectionDialog dialog = new SourceFileSelectionDialog(this.getShell());
        dialog.setTitle(NewClassWizardMessages.getString("NewClassCreationWizardPage.ChooseHeaderFileDialog.title"));
        ICModel input = CoreModel.create((IWorkspaceRoot)NewClassWizardUtil.getWorkspaceRoot());
        ICProject project = this.getCurrentProject();
        if (project != null) {
            input = project;
        }
        dialog.setInput((ICElement)input);
        IPath filePath = this.getHeaderFileFullPath();
        if (filePath != null) {
            String folderName = filePath.removeLastSegments(1).toString();
            String fileName = filePath.lastSegment();
            dialog.setInitialSelection(folderName, fileName);
        } else {
            filePath = this.getSourceFolderFullPath();
            if (filePath != null) {
                dialog.setInitialSelection(filePath.toString(), null);
            }
        }
        if (dialog.open() == 0) {
            return dialog.getFilePath();
        }
        return null;
    }

    private IPath chooseSourceFile() {
        SourceFileSelectionDialog dialog = new SourceFileSelectionDialog(this.getShell());
        dialog.setTitle(NewClassWizardMessages.getString("NewClassCreationWizardPage.ChooseSourceFileDialog.title"));
        ICModel input = CoreModel.create((IWorkspaceRoot)NewClassWizardUtil.getWorkspaceRoot());
        ICProject project = this.getCurrentProject();
        if (project != null) {
            input = project;
        }
        dialog.setInput((ICElement)input);
        IPath filePath = this.getSourceFileFullPath();
        if (filePath != null) {
            String folderName = filePath.removeLastSegments(1).toString();
            String fileName = filePath.lastSegment();
            dialog.setInitialSelection(folderName, fileName);
        } else {
            filePath = this.getSourceFolderFullPath();
            if (filePath != null) {
                dialog.setInitialSelection(filePath.toString(), null);
            }
        }
        if (dialog.open() == 0) {
            return dialog.getFilePath();
        }
        return null;
    }

    private void updateFilesFromClassName(String className) {
        String[] names;
        String headerName = null;
        String sourceName = null;
        IPath folder = this.getSourceFolderFullPath();
        if (className != null && className.length() > 0 && (names = this.generateFileNames(className, folder)) != null && names.length == 2) {
            headerName = names[0];
            sourceName = names[1];
        }
        this.fHeaderFileDialogField.setTextWithoutUpdate(headerName != null ? headerName : "");
        this.fSourceFileDialogField.setTextWithoutUpdate(sourceName != null ? sourceName : "");
    }

    protected String[] generateFileNames(String className, IPath folder) {
        String headerName = null;
        String sourceName = null;
        if (folder == null) {
            headerName = NewClassWizardUtil.createHeaderFileName(className);
            sourceName = NewClassWizardUtil.createSourceFileName(className);
        } else {
            String currName = className;
            int count = 0;
            String separator = "";
            if (Character.isDigit(className.charAt(className.length() - 1))) {
                separator = "_";
            }
            while (count < 99) {
                String source;
                String header = NewClassWizardUtil.createHeaderFileName(currName);
                IPath path = folder.append(header);
                if (!path.toFile().exists() && !(path = folder.append(source = NewClassWizardUtil.createSourceFileName(currName))).toFile().exists()) {
                    headerName = header;
                    sourceName = source;
                    break;
                }
                currName = String.valueOf(className) + separator + ++count;
            }
        }
        return new String[]{headerName, sourceName};
    }

    protected void handleFieldChanged(int fields) {
        if (fields == 0) {
            return;
        }
        if (this.fieldChanged(fields, 1)) {
            this.fSourceFolderStatus = this.sourceFolderChanged();
        }
        if (this.fieldChanged(fields, 2)) {
            this.fNamespaceStatus = this.namespaceChanged();
        }
        if (this.fieldChanged(fields, 4)) {
            this.fClassNameStatus = this.classNameChanged();
        }
        if (this.fieldChanged(fields, 8)) {
            this.fBaseClassesStatus = this.baseClassesChanged();
        }
        if (this.fieldChanged(fields, 16)) {
            this.fMethodStubsStatus = this.methodStubsChanged();
        }
        if (this.fieldChanged(fields, 32)) {
            this.fHeaderFileStatus = this.headerFileChanged();
        }
        if (this.fieldChanged(fields, 64)) {
            this.fSourceFileStatus = this.sourceFileChanged();
        }
        this.doStatusUpdate();
    }

    private boolean fieldChanged(int fields, int fieldID) {
        return (fields & fieldID) != 0;
    }

    protected void doStatusUpdate() {
        IStatus lastStatus = this.getLastFocusedStatus();
        IStatus[] status = new IStatus[]{lastStatus, this.fSourceFolderStatus != lastStatus ? this.fSourceFolderStatus : this.STATUS_OK, this.fNamespaceStatus != lastStatus ? this.fNamespaceStatus : this.STATUS_OK, this.fClassNameStatus != lastStatus ? this.fClassNameStatus : this.STATUS_OK, this.fBaseClassesStatus != lastStatus ? this.fBaseClassesStatus : this.STATUS_OK, this.fMethodStubsStatus != lastStatus ? this.fMethodStubsStatus : this.STATUS_OK, this.fHeaderFileStatus != lastStatus ? this.fHeaderFileStatus : this.STATUS_OK, this.fSourceFileStatus != lastStatus ? this.fSourceFileStatus : this.STATUS_OK};
        this.updateStatus(status);
    }

    protected IStatus getLastFocusedStatus() {
        switch (this.fLastFocusedField) {
            case 1: {
                return this.fSourceFolderStatus;
            }
            case 2: {
                return this.fNamespaceStatus;
            }
            case 4: {
                return this.fClassNameStatus;
            }
            case 8: {
                return this.fBaseClassesStatus;
            }
            case 16: {
                return this.fMethodStubsStatus;
            }
            case 32: {
                return this.fHeaderFileStatus;
            }
            case 64: {
                return this.fSourceFileStatus;
            }
        }
        return this.STATUS_OK;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected IStatus sourceFolderChanged() {
        StatusInfo status = new StatusInfo();
        IPath folderPath = this.getSourceFolderFullPath();
        if (folderPath == null) {
            status.setError(NewClassWizardMessages.getString("NewClassCreationWizardPage.error.EnterSourceFolderName"));
            return status;
        }
        IResource res = NewClassWizardUtil.getWorkspaceRoot().findMember(folderPath);
        if (res != null && res.exists()) {
            int resType = res.getType();
            if (resType == 4 || resType == 2) {
                IProject proj = res.getProject();
                if (!proj.isOpen()) {
                    status.setError(NewClassWizardMessages.getFormattedString("NewClassCreationWizardPage.error.NotAFolder", folderPath));
                    return status;
                }
                if (!CoreModel.hasCCNature((IProject)proj) && !CoreModel.hasCNature((IProject)proj)) {
                    if (resType == 4) {
                        status.setError(NewClassWizardMessages.getString("NewClassCreationWizardPage.warning.NotACProject"));
                        return status;
                    }
                    status.setWarning(NewClassWizardMessages.getString("NewClassCreationWizardPage.warning.NotInACProject"));
                }
                if (NewClassWizardUtil.getSourceFolder(res) != null) return status;
                status.setError(NewClassWizardMessages.getFormattedString("NewClassCreationWizardPage.error.NotASourceFolder", folderPath));
                return status;
            }
            status.setError(NewClassWizardMessages.getFormattedString("NewClassCreationWizardPage.error.NotAFolder", folderPath));
            return status;
        }
        status.setError(NewClassWizardMessages.getFormattedString("NewClassCreationWizardPage.error.FolderDoesNotExist", folderPath));
        return status;
    }

    protected IStatus namespaceChanged() {
        StatusInfo status = new StatusInfo();
        if (!this.isNamespaceSelected()) {
            return status;
        }
        String namespace = this.getNamespaceText();
        if (namespace == null || namespace.length() == 0) {
            status.setError(NewClassWizardMessages.getString("NewClassCreationWizardPage.error.EnterNamespace"));
            return status;
        }
        IStatus val = CConventions.validateNamespaceName((String)namespace);
        if (val.getSeverity() == 4) {
            status.setError(NewClassWizardMessages.getFormattedString("NewClassCreationWizardPage.error.InvalidNamespace", val.getMessage()));
            return status;
        }
        if (val.getSeverity() == 2) {
            status.setWarning(NewClassWizardMessages.getFormattedString("NewClassCreationWizardPage.warning.NamespaceDiscouraged", val.getMessage()));
        }
        QualifiedTypeName typeName = new QualifiedTypeName(namespace);
        ICProject project = this.getCurrentProject();
        if (project != null) {
            int searchResult;
            if (typeName.isQualified() && (searchResult = NewClassWizardUtil.searchForCppType(typeName.getEnclosingTypeName(), project, 8)) != 1) {
                status.setError(NewClassWizardMessages.getString("NewClassCreationWizardPage.error.EnclosingNamespaceNotExists"));
                return status;
            }
            searchResult = NewClassWizardUtil.searchForCppType((IQualifiedTypeName)typeName, project, 8);
            switch (searchResult) {
                case 1: {
                    status.setOK();
                    return status;
                }
                case 2: {
                    status.setWarning(NewClassWizardMessages.getString("NewClassCreationWizardPage.error.TypeMatchingNamespaceExists"));
                    return status;
                }
                case 3: {
                    status.setWarning(NewClassWizardMessages.getString("NewClassCreationWizardPage.error.NamespaceExistsDifferentCase"));
                    return status;
                }
                case 4: {
                    status.setWarning(NewClassWizardMessages.getString("NewClassCreationWizardPage.error.TypeMatchingNamespaceExistsDifferentCase"));
                    return status;
                }
                case 0: {
                    status.setWarning(NewClassWizardMessages.getString("NewClassCreationWizardPage.warning.NamespaceNotExists"));
                }
            }
        }
        if ((val = CConventions.validateNamespaceName((String)typeName.lastSegment())).getSeverity() == 4) {
            status.setError(NewClassWizardMessages.getFormattedString("NewClassCreationWizardPage.error.InvalidNamespace", val.getMessage()));
            return status;
        }
        return status;
    }

    protected IStatus classNameChanged() {
        ICProject project;
        StatusInfo status = new StatusInfo();
        String className = this.getClassName();
        if (className == null || className.length() == 0) {
            status.setError(NewClassWizardMessages.getString("NewClassCreationWizardPage.error.EnterClassName"));
            return status;
        }
        QualifiedTypeName typeName = new QualifiedTypeName(className);
        if (typeName.isQualified()) {
            status.setError(NewClassWizardMessages.getString("NewClassCreationWizardPage.error.QualifiedClassName"));
            return status;
        }
        IStatus val = CConventions.validateClassName((String)className);
        if (val.getSeverity() == 4) {
            status.setError(NewClassWizardMessages.getFormattedString("NewClassCreationWizardPage.error.InvalidClassName", val.getMessage()));
            return status;
        }
        if (val.getSeverity() == 2) {
            status.setWarning(NewClassWizardMessages.getFormattedString("NewClassCreationWizardPage.warning.ClassNameDiscouraged", val.getMessage()));
        }
        if ((project = this.getCurrentProject()) != null) {
            String namespace;
            QualifiedTypeName fullyQualifiedName = typeName;
            if (this.isNamespaceSelected() && (namespace = this.getNamespaceText()) != null && namespace.length() > 0) {
                fullyQualifiedName = new QualifiedTypeName(namespace).append((IQualifiedTypeName)typeName);
            }
            int searchResult = NewClassWizardUtil.searchForCppType((IQualifiedTypeName)fullyQualifiedName, project, 5);
            switch (searchResult) {
                case 1: {
                    status.setError(NewClassWizardMessages.getString("NewClassCreationWizardPage.error.ClassNameExists"));
                    return status;
                }
                case 2: {
                    status.setError(NewClassWizardMessages.getString("NewClassCreationWizardPage.error.TypeMatchingClassExists"));
                    return status;
                }
                case 3: {
                    status.setWarning(NewClassWizardMessages.getString("NewClassCreationWizardPage.error.ClassNameExistsDifferentCase"));
                    return status;
                }
                case 4: {
                    status.setWarning(NewClassWizardMessages.getString("NewClassCreationWizardPage.error.TypeMatchingClassExistsDifferentCase"));
                    return status;
                }
            }
        }
        return status;
    }

    protected IStatus baseClassesChanged() {
        if (this.verifyBaseClasses()) {
            IBaseClassInfo[] baseClasses;
            IPath folder = this.getSourceFolderFullPath();
            ICProject project = this.getCurrentProject();
            if (project != null && (baseClasses = this.getBaseClasses()) != null && baseClasses.length > 0) {
                IStatus status = this.baseClassesChanged(project, folder, baseClasses);
                if (status.isMultiStatus()) {
                    return StatusUtil.getMostSevere(status.getChildren());
                }
                return status;
            }
        }
        return Status.OK_STATUS;
    }

    protected IStatus baseClassesChanged(ICProject project, IPath sourceFolder, IBaseClassInfo[] baseClasses) {
        IScannerInfo info;
        MultiStatus status = new MultiStatus(CUIPlugin.getPluginId(), 0, "", null);
        IScannerInfoProvider provider = CCorePlugin.getDefault().getScannerInfoProvider(project.getProject());
        if (provider != null && (info = provider.getScannerInformation((IResource)project.getProject())) != null) {
            String[] includePaths = info.getIncludePaths();
            int i = 0;
            while (i < baseClasses.length) {
                IBaseClassInfo baseClass = baseClasses[i];
                ITypeInfo baseType = baseClass.getType();
                StatusInfo baseClassStatus = new StatusInfo();
                if (!NewClassWizardUtil.isTypeReachable(baseType, project, includePaths)) {
                    baseClassStatus.setError(NewClassWizardMessages.getFormattedString("NewClassCreationWizardPage.error.BaseClassNotExistsInProject", baseType.getQualifiedTypeName().toString()));
                }
                status.add((IStatus)baseClassStatus);
                ++i;
            }
        }
        return status;
    }

    public boolean verifyBaseClasses() {
        return NewClassWizardPrefs.verifyBaseClasses();
    }

    protected IStatus methodStubsChanged() {
        return Status.OK_STATUS;
    }

    protected IStatus headerFileChanged() {
        StatusInfo status = new StatusInfo();
        if (this.isUseDefaultSelected()) {
            return status;
        }
        IPath path = this.getHeaderFileFullPath();
        if (path == null) {
            status.setError(NewClassWizardMessages.getString("NewClassCreationWizardPage.error.EnterHeaderFileName"));
            return status;
        }
        IPath sourceFolderPath = this.getSourceFolderFullPath();
        if (sourceFolderPath == null || !sourceFolderPath.isPrefixOf(path)) {
            status.setError(NewClassWizardMessages.getString("NewClassCreationWizardPage.error.HeaderFileNotInSourceFolder"));
            return status;
        }
        boolean fileExists = false;
        IResource file = NewClassWizardUtil.getWorkspaceRoot().findMember(path);
        if (file != null && file.exists()) {
            if (file.getType() == 1) {
                IProject proj = file.getProject();
                if (!proj.isOpen()) {
                    status.setError(NewClassWizardMessages.getFormattedString("NewClassCreationWizardPage.error.NotAFile", path));
                    return status;
                }
                fileExists = true;
                if (!CoreModel.hasCCNature((IProject)proj) && !CoreModel.hasCNature((IProject)proj)) {
                    status.setWarning(NewClassWizardMessages.getString("NewClassCreationWizardPage.warning.NotInACProject"));
                } else {
                    status.setWarning(NewClassWizardMessages.getString("NewClassCreationWizardPage.warning.HeaderFileExists"));
                }
            } else {
                status.setError(NewClassWizardMessages.getString("NewClassCreationWizardPage.error.NotAFile"));
                return status;
            }
        }
        IPath folderPath = path.removeLastSegments(1).makeRelative();
        IResource folder = NewClassWizardUtil.getWorkspaceRoot().findMember(folderPath);
        if (folder == null || !folder.exists() || folder.getType() != 4 && folder.getType() != 2) {
            status.setError(NewClassWizardMessages.getFormattedString("NewClassCreationWizardPage.error.FolderDoesNotExist", folderPath));
            return status;
        }
        if (!fileExists) {
            IStatus val = CConventions.validateHeaderFileName((IProject)this.getCurrentProject().getProject(), (String)path.lastSegment());
            if (val.getSeverity() == 4) {
                status.setError(NewClassWizardMessages.getFormattedString("NewClassCreationWizardPage.error.InvalidHeaderFileName", val.getMessage()));
                return status;
            }
            if (val.getSeverity() == 2) {
                status.setWarning(NewClassWizardMessages.getFormattedString("NewClassCreationWizardPage.warning.HeaderFileNameDiscouraged", val.getMessage()));
            }
        }
        return status;
    }

    protected IStatus sourceFileChanged() {
        StatusInfo status = new StatusInfo();
        if (this.isUseDefaultSelected()) {
            return status;
        }
        IPath path = this.getSourceFileFullPath();
        if (path == null) {
            status.setError(NewClassWizardMessages.getString("NewClassCreationWizardPage.error.EnterSourceFileName"));
            return status;
        }
        IPath sourceFolderPath = this.getSourceFolderFullPath();
        if (sourceFolderPath == null || !sourceFolderPath.isPrefixOf(path)) {
            status.setError(NewClassWizardMessages.getString("NewClassCreationWizardPage.error.SourceFileNotInSourceFolder"));
            return status;
        }
        boolean fileExists = false;
        IResource file = NewClassWizardUtil.getWorkspaceRoot().findMember(path);
        if (file != null && file.exists()) {
            if (file.getType() == 1) {
                IProject proj = file.getProject();
                if (!proj.isOpen()) {
                    status.setError(NewClassWizardMessages.getFormattedString("NewClassCreationWizardPage.error.NotAFile", path));
                    return status;
                }
                fileExists = true;
                if (!CoreModel.hasCCNature((IProject)proj) && !CoreModel.hasCNature((IProject)proj)) {
                    status.setWarning(NewClassWizardMessages.getString("NewClassCreationWizardPage.warning.NotInACProject"));
                } else {
                    status.setWarning(NewClassWizardMessages.getString("NewClassCreationWizardPage.warning.SourceFileExists"));
                }
            } else {
                status.setError(NewClassWizardMessages.getString("NewClassCreationWizardPage.error.NotAFile"));
                return status;
            }
        }
        IPath folderPath = path.removeLastSegments(1).makeRelative();
        IResource folder = NewClassWizardUtil.getWorkspaceRoot().findMember(folderPath);
        if (folder == null || !folder.exists() || folder.getType() != 4 && folder.getType() != 2) {
            status.setError(NewClassWizardMessages.getFormattedString("NewClassCreationWizardPage.error.FolderDoesNotExist", folderPath));
            return status;
        }
        if (!fileExists) {
            IStatus val = CConventions.validateSourceFileName((IProject)this.getCurrentProject().getProject(), (String)path.lastSegment());
            if (val.getSeverity() == 4) {
                status.setError(NewClassWizardMessages.getFormattedString("NewClassCreationWizardPage.error.InvalidSourceFileName", val.getMessage()));
                return status;
            }
            if (val.getSeverity() == 2) {
                status.setWarning(NewClassWizardMessages.getFormattedString("NewClassCreationWizardPage.warning.SourceFileNameDiscouraged", val.getMessage()));
            }
        }
        return status;
    }

    public void createClass(IProgressMonitor monitor) throws CoreException, InterruptedException {
        this.fCreatedClass = null;
        this.fCreatedHeaderFile = null;
        this.fCreatedSourceFile = null;
        this.createClass(this.getHeaderFileFullPath(), this.getSourceFileFullPath(), this.getClassName(), this.isNamespaceSelected() ? this.getNamespaceText() : null, this.getBaseClasses(), this.getSelectedMethodStubs(), monitor);
    }

    public boolean openClassInEditor() {
        return NewClassWizardPrefs.openClassInEditor();
    }

    protected void createClass(IPath headerPath, IPath sourcePath, String className, String namespace, IBaseClassInfo[] baseClasses, IMethodStub[] methodStubs, IProgressMonitor monitor) throws CoreException, InterruptedException {
        NewClassCodeGenerator generator = new NewClassCodeGenerator(headerPath, sourcePath, className, namespace, baseClasses, methodStubs);
        generator.createClass(monitor);
        this.fCreatedClass = generator.getCreatedClass();
        this.fCreatedHeaderFile = generator.getCreatedHeaderFile();
        this.fCreatedSourceFile = generator.getCreatedSourceFile();
    }

    public ICElement getCreatedClass() {
        return this.fCreatedClass;
    }

    public IFile getCreatedHeaderFile() {
        return this.fCreatedHeaderFile;
    }

    public IFile getCreatedSourceFile() {
        return this.fCreatedSourceFile;
    }

    private final class StatusFocusListener
    implements FocusListener {
        private int fieldID;

        public StatusFocusListener(int fieldID) {
            this.fieldID = fieldID;
        }

        public void focusGained(FocusEvent e) {
            if (NewClassCreationWizardPage.this.fLastFocusedField != this.fieldID) {
                NewClassCreationWizardPage.this.fLastFocusedField = this.fieldID;
                NewClassCreationWizardPage.this.doStatusUpdate();
            }
        }

        public void focusLost(FocusEvent e) {
            if (NewClassCreationWizardPage.this.fLastFocusedField != 0) {
                NewClassCreationWizardPage.this.fLastFocusedField = 0;
                NewClassCreationWizardPage.this.doStatusUpdate();
            }
        }
    }

    private final class SourceFolderFieldAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        private SourceFolderFieldAdapter() {
        }

        public void changeControlPressed(DialogField field) {
            IPath oldFolderPath = NewClassCreationWizardPage.this.getSourceFolderFullPath();
            IPath newFolderPath = NewClassCreationWizardPage.this.chooseSourceFolder(oldFolderPath);
            if (newFolderPath != null) {
                IPath headerPath = NewClassCreationWizardPage.this.getHeaderFileFullPath();
                IPath sourcePath = NewClassCreationWizardPage.this.getSourceFileFullPath();
                NewClassCreationWizardPage.this.setSourceFolderFullPath(newFolderPath, false);
                if (!NewClassCreationWizardPage.this.isUseDefaultSelected()) {
                    if (oldFolderPath != null && oldFolderPath.matchingFirstSegments(newFolderPath) == 0) {
                        if (headerPath != null) {
                            headerPath = newFolderPath.append(headerPath.lastSegment());
                        }
                        if (sourcePath != null) {
                            sourcePath = newFolderPath.append(sourcePath.lastSegment());
                        }
                    }
                    NewClassCreationWizardPage.this.setHeaderFileFullPath(headerPath, false);
                    NewClassCreationWizardPage.this.setSourceFileFullPath(sourcePath, false);
                }
                NewClassCreationWizardPage.this.handleFieldChanged(127);
            }
        }

        public void dialogFieldChanged(DialogField field) {
            NewClassCreationWizardPage.this.handleFieldChanged(127);
        }
    }

    private final class NamespaceFieldAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        private NamespaceFieldAdapter() {
        }

        public void changeControlPressed(DialogField field) {
            ITypeInfo ns = NewClassCreationWizardPage.this.chooseNamespace();
            if (ns != null) {
                int changedFields = 6;
                IPath oldFolderPath = NewClassCreationWizardPage.this.getSourceFolderFullPath();
                if (oldFolderPath == null) {
                    IPath headerPath = NewClassCreationWizardPage.this.getHeaderFileFullPath();
                    IPath sourcePath = NewClassCreationWizardPage.this.getSourceFileFullPath();
                    IPath newFolderPath = NewClassCreationWizardPage.this.updateSourceFolderFromPath(ns.getEnclosingProject().getProject().getFullPath());
                    if (newFolderPath != null) {
                        changedFields |= 0x61;
                        if (oldFolderPath != null && oldFolderPath.matchingFirstSegments(newFolderPath) == 0) {
                            if (headerPath != null) {
                                headerPath = newFolderPath.append(headerPath.lastSegment());
                            }
                            if (sourcePath != null) {
                                sourcePath = newFolderPath.append(sourcePath.lastSegment());
                            }
                        }
                        NewClassCreationWizardPage.this.setSourceFolderFullPath(newFolderPath, false);
                        NewClassCreationWizardPage.this.setHeaderFileFullPath(headerPath, false);
                        NewClassCreationWizardPage.this.setSourceFileFullPath(sourcePath, false);
                    }
                }
                NewClassCreationWizardPage.this.setNamespaceText(ns.getQualifiedTypeName().toString(), false);
                NewClassCreationWizardPage.this.handleFieldChanged(changedFields);
            }
        }

        public void dialogFieldChanged(DialogField field) {
            NewClassCreationWizardPage.this.updateNamespaceEnableState();
            NewClassCreationWizardPage.this.handleFieldChanged(6);
        }
    }

    private final class ClassNameFieldAdapter
    implements IDialogFieldListener {
        private ClassNameFieldAdapter() {
        }

        public void dialogFieldChanged(DialogField field) {
            int changedFields = 4;
            if (NewClassCreationWizardPage.this.isUseDefaultSelected()) {
                NewClassCreationWizardPage.this.updateFilesFromClassName(NewClassCreationWizardPage.this.fClassNameDialogField.getText());
                changedFields |= 0x60;
            }
            NewClassCreationWizardPage.this.handleFieldChanged(changedFields);
        }
    }

    private final class BaseClassesFieldAdapter
    implements IListAdapter {
        private BaseClassesFieldAdapter() {
        }

        public void customButtonPressed(ListDialogField field, int index) {
            if (index == 0) {
                NewClassCreationWizardPage.this.chooseBaseClasses();
            }
            NewClassCreationWizardPage.this.handleFieldChanged(8);
        }

        public void selectionChanged(ListDialogField field) {
        }

        public void doubleClicked(ListDialogField field) {
        }
    }

    private final class MethodStubsFieldAdapter
    implements IListAdapter {
        private MethodStubsFieldAdapter() {
        }

        public void customButtonPressed(ListDialogField field, int index) {
        }

        public void selectionChanged(ListDialogField field) {
        }

        public void doubleClicked(ListDialogField field) {
        }
    }

    private final class FileGroupFieldAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        private FileGroupFieldAdapter() {
        }

        public void changeControlPressed(DialogField field) {
            IPath filePath = null;
            IPath headerPath = NewClassCreationWizardPage.this.getHeaderFileFullPath();
            IPath sourcePath = NewClassCreationWizardPage.this.getSourceFileFullPath();
            if (field == NewClassCreationWizardPage.this.fHeaderFileDialogField) {
                filePath = NewClassCreationWizardPage.this.chooseHeaderFile();
                if (filePath != null) {
                    headerPath = filePath;
                }
            } else if (field == NewClassCreationWizardPage.this.fSourceFileDialogField && (filePath = NewClassCreationWizardPage.this.chooseSourceFile()) != null) {
                sourcePath = filePath;
            }
            if (filePath != null) {
                int segments;
                IPath folderPath = null;
                int changedFields = 0;
                int headerSegments = 0;
                int sourceSegments = 0;
                if (headerPath != null) {
                    headerSegments = filePath.matchingFirstSegments(headerPath);
                }
                if (sourcePath != null) {
                    sourceSegments = filePath.matchingFirstSegments(sourcePath);
                }
                if ((segments = Math.min(headerSegments, sourceSegments)) > 0) {
                    IPath newFolderPath = filePath.uptoSegment(segments);
                    folderPath = NewClassCreationWizardPage.this.updateSourceFolderFromPath(newFolderPath);
                }
                if (folderPath != null) {
                    changedFields |= 0x61;
                    NewClassCreationWizardPage.this.setSourceFolderFullPath(folderPath, false);
                    NewClassCreationWizardPage.this.setHeaderFileFullPath(headerPath, false);
                    NewClassCreationWizardPage.this.setSourceFileFullPath(sourcePath, false);
                }
                if (field == NewClassCreationWizardPage.this.fHeaderFileDialogField) {
                    NewClassCreationWizardPage.this.setHeaderFileFullPath(filePath, false);
                    changedFields |= 0x20;
                } else if (field == NewClassCreationWizardPage.this.fSourceFileDialogField) {
                    NewClassCreationWizardPage.this.setSourceFileFullPath(filePath, false);
                    changedFields |= 0x40;
                }
                NewClassCreationWizardPage.this.handleFieldChanged(changedFields);
            }
        }

        public void dialogFieldChanged(DialogField field) {
            int changedFields = 0;
            if (field == NewClassCreationWizardPage.this.fUseDefaultSelection) {
                boolean enabled = !NewClassCreationWizardPage.this.isUseDefaultSelected();
                NewClassCreationWizardPage.this.fHeaderFileDialogField.setEnabled(enabled);
                NewClassCreationWizardPage.this.fSourceFileDialogField.setEnabled(enabled);
                if (!enabled) {
                    NewClassCreationWizardPage.this.updateFilesFromClassName(NewClassCreationWizardPage.this.fClassNameDialogField.getText());
                }
                changedFields = 96;
                NewClassCreationWizardPage.this.updateFileGroupEnableState();
            }
            if (field == NewClassCreationWizardPage.this.fHeaderFileDialogField) {
                changedFields |= 0x20;
            } else if (field == NewClassCreationWizardPage.this.fSourceFileDialogField) {
                changedFields |= 0x40;
            }
            NewClassCreationWizardPage.this.handleFieldChanged(changedFields);
        }
    }
}

