/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;

public class CPPFunctionType
implements ICPPFunctionType {
    private IType[] parameters = null;
    private IType returnType = null;
    private boolean isConst = false;
    private boolean isVolatile = false;

    public CPPFunctionType(IType returnType, IType[] types) {
        this.returnType = returnType;
        this.parameters = types;
    }

    public CPPFunctionType(IType returnType, IType[] types, boolean isConst, boolean isVolatile) {
        this.returnType = returnType;
        this.parameters = types;
        this.isConst = isConst;
        this.isVolatile = isVolatile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isSameType(IType o) {
        IType[] fps;
        if (o instanceof ITypedef) {
            return o.isSameType(this);
        }
        if (!(o instanceof ICPPFunctionType)) {
            return false;
        }
        ICPPFunctionType ft = (ICPPFunctionType)o;
        try {
            fps = ft.getParameterTypes();
        }
        catch (DOMException dOMException) {
            return false;
        }
        try {
            if (this.returnType == null ^ ft.getReturnType() == null) {
                return false;
            }
            if (this.returnType != null && !this.returnType.isSameType(ft.getReturnType())) {
                return false;
            }
        }
        catch (DOMException dOMException) {
            return false;
        }
        try {
            if (this.parameters.length == 1 && fps.length == 0) {
                if (this.parameters[0] instanceof IBasicType && ((IBasicType)this.parameters[0]).getType() == 1) return this.isConst == ft.isConst() && this.isVolatile == ft.isVolatile();
                return false;
            }
            if (fps.length == 1 && this.parameters.length == 0) {
                if (fps[0] instanceof IBasicType && ((IBasicType)fps[0]).getType() == 1) return this.isConst == ft.isConst() && this.isVolatile == ft.isVolatile();
                return false;
            } else {
                if (this.parameters.length != fps.length) {
                    return false;
                }
                int i = 0;
                while (i < this.parameters.length) {
                    if (this.parameters[i] == null || !this.parameters[i].isSameType(fps[i])) {
                        return false;
                    }
                    ++i;
                }
            }
            return this.isConst == ft.isConst() && this.isVolatile == ft.isVolatile();
        }
        catch (DOMException dOMException) {
            return false;
        }
    }

    public IType getReturnType() {
        return this.returnType;
    }

    public IType[] getParameterTypes() {
        return this.parameters;
    }

    public Object clone() {
        IType t = null;
        try {
            t = (IType)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return t;
    }

    public boolean isConst() {
        return this.isConst;
    }

    public boolean isVolatile() {
        return this.isVolatile;
    }
}

