/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.wizards;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIMessages;
import org.eclipse.cdt.managedbuilder.ui.wizards.MBSCustomPageData;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.wizard.IWizardPage;

public final class MBSCustomPageManager {
    public static final String NATURE_ID = "natureID";
    public static final String VERSIONS_SUPPORTED = "versionsSupported";
    public static final String TOOLCHAIN_ID = "toolchainID";
    public static final String PROJECT_TYPE_ID = "projectTypeID";
    public static final String NATURE = "nature";
    public static final String TOOLCHAIN = "toolchain";
    public static final String PROJECT_TYPE = "projectType";
    public static final String PAGE_CLASS = "pageClass";
    public static final String OPERATION_CLASS = "operationClass";
    public static final String ID = "ID";
    public static final String WIZARD_PAGE = "wizardPage";
    private static Map idToPageDataMap = null;
    private static Set pageSet = null;
    private static Map pageIDtoPagePropertiesMap = null;
    private static final String EXTENSION_POINT_ID = "org.eclipse.cdt.managedbuilder.ui.newWizardPages";

    public static void loadExtensions() throws BuildException {
        MBSCustomPageManager.loadExtensionsSynchronized();
    }

    private static synchronized void loadExtensionsSynchronized() throws BuildException {
        IExtension[] extensions;
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT_ID);
        if (extensionPoint != null && (extensions = extensionPoint.getExtensions()) != null) {
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] elements = extension.getConfigurationElements();
                int k = 0;
                while (k < elements.length) {
                    IConfigurationElement element = elements[k];
                    if (!element.getName().equals(WIZARD_PAGE)) {
                        throw new BuildException(String.valueOf(ManagedBuilderUIMessages.getResourceString("MBSCustomPageManager.error0")) + element.getName() + ManagedBuilderUIMessages.getResourceString("MBSCustomPageManager.error1") + EXTENSION_POINT_ID);
                    }
                    MBSCustomPageManager.loadWizardPage(element);
                    ++k;
                }
                ++i;
            }
        }
    }

    private static void loadWizardPage(IConfigurationElement element) throws BuildException {
        String id = element.getAttribute(ID);
        element.getAttribute(OPERATION_CLASS);
        IWizardPage wizardPage = null;
        Runnable operation = null;
        try {
            wizardPage = (IWizardPage)element.createExecutableExtension(PAGE_CLASS);
            if (element.getAttribute(OPERATION_CLASS) != null) {
                operation = (Runnable)element.createExecutableExtension(OPERATION_CLASS);
            }
        }
        catch (CoreException e) {
            throw new BuildException(e.getMessage());
        }
        MBSCustomPageData currentPageData = new MBSCustomPageData(id, wizardPage, operation, false);
        idToPageDataMap.put(id, currentPageData);
        pageSet.add(currentPageData);
        IConfigurationElement[] children = element.getChildren();
        int k = 0;
        while (k < children.length) {
            IConfigurationElement childElement = children[k];
            if (childElement.getName().equals(PROJECT_TYPE)) {
                MBSCustomPageManager.loadProjectType(childElement, currentPageData);
            } else if (childElement.getName().equals(TOOLCHAIN)) {
                MBSCustomPageManager.loadToolchain(childElement, currentPageData);
            } else if (childElement.getName().equals(NATURE)) {
                MBSCustomPageManager.loadNature(childElement, currentPageData);
            } else {
                throw new BuildException(String.valueOf(ManagedBuilderUIMessages.getResourceString("MBSCustomPageManager.error2")) + element.getName() + ManagedBuilderUIMessages.getResourceString("MBSCustomPageManager.error3") + EXTENSION_POINT_ID);
            }
            ++k;
        }
    }

    private static void loadProjectType(IConfigurationElement element, MBSCustomPageData currentPageData) throws BuildException {
        String projectType = element.getAttribute(PROJECT_TYPE_ID);
        if (projectType == null) {
            throw new BuildException(ManagedBuilderUIMessages.getResourceString("MBSCustomPageManager.error4"));
        }
        currentPageData.addProjectType(projectType);
    }

    private static void loadToolchain(IConfigurationElement element, MBSCustomPageData currentPageData) throws BuildException {
        String[] versionsSupported;
        String toolchainID = element.getAttribute(TOOLCHAIN_ID);
        if (toolchainID != null) {
            String unparsedVersions = element.getAttribute(VERSIONS_SUPPORTED);
            versionsSupported = null;
            if (unparsedVersions != null) {
                versionsSupported = unparsedVersions.split(",");
            }
        } else {
            throw new BuildException(ManagedBuilderUIMessages.getResourceString("MBSCustomPageManager.error5"));
        }
        currentPageData.addToolchain(toolchainID, versionsSupported);
    }

    private static void loadNature(IConfigurationElement element, MBSCustomPageData currentPageData) throws BuildException {
        String nature = element.getAttribute(NATURE_ID);
        if (nature == null) {
            throw new BuildException(ManagedBuilderUIMessages.getResourceString("MBSCustomPageManager.error6"));
        }
        currentPageData.addNature(nature);
    }

    public static MBSCustomPageData getPageData(String pageID) {
        return (MBSCustomPageData)idToPageDataMap.get(pageID);
    }

    public static boolean isPageVisible(String pageID) {
        MBSCustomPageData page = MBSCustomPageManager.getPageData(pageID);
        if (page == null) {
            return false;
        }
        Map pagePropertiesMap = (Map)pageIDtoPagePropertiesMap.get("org.eclipse.cdt.managedbuilder.ui.wizard.platformPage");
        String projectType = pagePropertiesMap.get(PROJECT_TYPE).toString();
        Set toolchainSet = (Set)pagePropertiesMap.get(TOOLCHAIN);
        String nature = pagePropertiesMap.get(NATURE).toString();
        if (page.shouldBeVisibleForNature(nature) && page.shouldBeVisibleForProjectType(projectType)) {
            MBSCustomPageData.ToolchainData[] toolchainData = page.getToolchains();
            if (toolchainData == null) {
                return true;
            }
            int k = 0;
            while (k < toolchainData.length) {
                Iterator toolchainIterator = toolchainSet.iterator();
                while (toolchainIterator.hasNext()) {
                    String version;
                    IToolChain toolchain = (IToolChain)toolchainIterator.next();
                    String id = ManagedBuildManager.getIdFromIdAndVersion((String)toolchain.getId());
                    if (!page.shouldBeVisibleForToolchain(id, version = ManagedBuildManager.getVersionFromIdAndVersion((String)toolchain.getId()))) continue;
                    return true;
                }
                ++k;
            }
        }
        return false;
    }

    public static void addPageProperty(String pageID, String key, Object data) {
        TreeMap<String, Object> propertiesMap = (TreeMap<String, Object>)pageIDtoPagePropertiesMap.get(pageID);
        if (propertiesMap == null) {
            propertiesMap = new TreeMap<String, Object>();
            pageIDtoPagePropertiesMap.put(pageID, propertiesMap);
        }
        propertiesMap.put(key, data);
    }

    public static Object getPageProperty(String pageID, String key) {
        Map propertiesMap = (Map)pageIDtoPagePropertiesMap.get(pageID);
        if (propertiesMap != null) {
            return propertiesMap.get(key);
        }
        return null;
    }

    public static IWizardPage getNextPage(String currentPageID) {
        MBSCustomPageData pageData = MBSCustomPageManager.getPageData(currentPageID);
        MBSCustomPageData currentData = null;
        Iterator iterator = pageSet.iterator();
        while (iterator.hasNext()) {
            currentData = (MBSCustomPageData)iterator.next();
            if (currentData == pageData) break;
        }
        if (currentData == pageData) {
            Map pagePropertiesMap = (Map)pageIDtoPagePropertiesMap.get("org.eclipse.cdt.managedbuilder.ui.wizard.platformPage");
            pagePropertiesMap.get(PROJECT_TYPE).toString();
            Set cfr_ignored_0 = (Set)pagePropertiesMap.get(TOOLCHAIN);
            pagePropertiesMap.get(NATURE).toString();
            IWizardPage nextPage = null;
            boolean pageFound = false;
            while (iterator.hasNext() && !pageFound) {
                MBSCustomPageData potentialPage = (MBSCustomPageData)iterator.next();
                if (!MBSCustomPageManager.isPageVisible(potentialPage.getID())) continue;
                pageFound = true;
                nextPage = potentialPage.getWizardPage();
            }
            if (pageFound) {
                return nextPage;
            }
        }
        return null;
    }

    public static void addStockPage(IWizardPage page, String pageID) {
        MBSCustomPageData pageData = new MBSCustomPageData(pageID, page, null, true);
        idToPageDataMap.put(pageID, pageData);
        pageSet.add(pageData);
    }

    public static IWizardPage getPreviousPage(String currentPageID) {
        MBSCustomPageData pageData = MBSCustomPageManager.getPageData(currentPageID);
        MBSCustomPageData currentData = null;
        Iterator iterator = pageSet.iterator();
        Stack<MBSCustomPageData> pageDataStack = new Stack<MBSCustomPageData>();
        while (iterator.hasNext()) {
            currentData = (MBSCustomPageData)iterator.next();
            if (currentData == pageData) break;
            pageDataStack.push(currentData);
        }
        if (currentData == pageData) {
            Map pagePropertiesMap = (Map)pageIDtoPagePropertiesMap.get("org.eclipse.cdt.managedbuilder.ui.wizard.platformPage");
            pagePropertiesMap.get(PROJECT_TYPE).toString();
            Set cfr_ignored_0 = (Set)pagePropertiesMap.get(TOOLCHAIN);
            pagePropertiesMap.get(NATURE).toString();
            IWizardPage prevPage = null;
            boolean pageFound = false;
            while (pageDataStack.size() != 0 && !pageFound) {
                MBSCustomPageData potentialPage = (MBSCustomPageData)pageDataStack.pop();
                if (!MBSCustomPageManager.isPageVisible(potentialPage.getID())) continue;
                pageFound = true;
                prevPage = potentialPage.getWizardPage();
            }
            if (pageFound) {
                return prevPage;
            }
        }
        return null;
    }

    public static IWizardPage[] getPages() {
        IWizardPage[] pages = new IWizardPage[pageSet.size()];
        Iterator iterator = pageSet.iterator();
        int k = 0;
        while (iterator.hasNext()) {
            MBSCustomPageData page = (MBSCustomPageData)iterator.next();
            pages[k++] = page.getWizardPage();
        }
        return pages;
    }

    public static IWizardPage[] getCustomPages() {
        LinkedHashSet<IWizardPage> customPageSet = new LinkedHashSet<IWizardPage>();
        Iterator pageIterator = pageSet.iterator();
        while (pageIterator.hasNext()) {
            MBSCustomPageData page = (MBSCustomPageData)pageIterator.next();
            if (page.isStockPage()) continue;
            customPageSet.add(page.getWizardPage());
        }
        Iterator iterator = customPageSet.iterator();
        IWizardPage[] pages = new IWizardPage[customPageSet.size()];
        int k = 0;
        while (iterator.hasNext()) {
            pages[k++] = (IWizardPage)iterator.next();
        }
        return pages;
    }

    public static Runnable[] getOperations() {
        LinkedHashSet<Runnable> operationSet = new LinkedHashSet<Runnable>();
        Iterator pageIterator = pageSet.iterator();
        while (pageIterator.hasNext()) {
            MBSCustomPageData page = (MBSCustomPageData)pageIterator.next();
            if (page.isStockPage() || !MBSCustomPageManager.isPageVisible(page.getID()) || page.getOperation() == null) continue;
            operationSet.add(page.getOperation());
        }
        if (operationSet.size() == 0) {
            return null;
        }
        Iterator iterator = operationSet.iterator();
        Runnable[] operations = new Runnable[operationSet.size()];
        int k = 0;
        while (iterator.hasNext()) {
            operations[k++] = (Runnable)iterator.next();
        }
        return operations;
    }

    public static void init() {
        idToPageDataMap = new TreeMap();
        pageIDtoPagePropertiesMap = new TreeMap();
        pageSet = new LinkedHashSet();
    }

    private MBSCustomPageManager() {
    }
}

