/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.indexview;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOMNode;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ElementChangedEvent;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMName;
import org.eclipse.cdt.internal.ui.IndexLabelProvider;
import org.eclipse.cdt.internal.ui.indexview.CountNodeAction;
import org.eclipse.cdt.internal.ui.indexview.DiscardExternalDefsAction;
import org.eclipse.cdt.internal.ui.indexview.FindDeclarationsAction;
import org.eclipse.cdt.internal.ui.indexview.FindReferencesAction;
import org.eclipse.cdt.internal.ui.indexview.IndexAction;
import org.eclipse.cdt.internal.ui.indexview.OpenDefinitionAction;
import org.eclipse.cdt.internal.ui.indexview.ToggleLinkingAction;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;

public class IndexView
extends ViewPart
implements PDOM.IListener,
IElementChangedListener {
    private TreeViewer viewer;
    private ToggleLinkingAction toggleLinkingAction;
    private IndexAction countSymbolsAction;
    private IndexAction discardExternalDefsAction;
    private IndexAction openDefinitionAction;
    private IndexAction findDeclarationsAction;
    private IndexAction findReferencesAction;
    Filter filter = new Filter();
    public boolean isLinking = false;

    public void toggleExternalDefs() {
        if (!this.filter.showExternalDefs) {
            this.viewer.addFilter((ViewerFilter)this.filter);
        } else {
            this.viewer.removeFilter((ViewerFilter)this.filter);
        }
        this.filter.showExternalDefs = !this.filter.showExternalDefs;
    }

    public void toggleLinking() {
        boolean bl = this.isLinking = !this.isLinking;
        if (this.isLinking) {
            this.openDefinitionAction.run();
        }
    }

    void handleSelectionChanged(SelectionChangedEvent event) {
        if (this.isLinking) {
            this.openDefinitionAction.run();
        }
    }

    static PDOMBinding[] trim(PDOMBinding[] binding) {
        int len = 0;
        while (len < binding.length) {
            if (binding[len] == null) {
                PDOMBinding[] newBinding = new PDOMBinding[len];
                System.arraycopy(binding, 0, newBinding, 0, len);
                return newBinding;
            }
            ++len;
        }
        return binding;
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 770);
        this.viewer.setContentProvider((IContentProvider)new IndexContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new IndexLabelProvider());
        ICModel model = CoreModel.getDefault().getCModel();
        this.viewer.setInput((Object)model);
        try {
            ICProject[] projects = model.getCProjects();
            int i = 0;
            while (i < projects.length) {
                PDOM pdom = (PDOM)CCorePlugin.getPDOMManager().getPDOM(projects[i]);
                pdom.addListener((PDOM.IListener)this);
                ++i;
            }
            this.viewer.setChildCount((Object)model, projects.length);
        }
        catch (CoreException e) {
            CUIPlugin.getDefault().log(e);
        }
        CoreModel.getDefault().addElementChangedListener((IElementChangedListener)this);
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            private void hideMenuItems(IMenuManager manager) {
            }

            public void menuAboutToShow(IMenuManager manager) {
                IndexView.this.fillContextMenu(manager);
                this.hideMenuItems(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IndexView.this.handleSelectionChanged(event);
            }
        });
    }

    public void dispose() {
        super.dispose();
        ICModel model = CoreModel.getDefault().getCModel();
        try {
            ICProject[] projects = model.getCProjects();
            int i = 0;
            while (i < projects.length) {
                PDOM pdom = (PDOM)CCorePlugin.getPDOMManager().getPDOM(projects[i]);
                pdom.removeListener((PDOM.IListener)this);
                ++i;
            }
            this.viewer.setChildCount((Object)model, projects.length);
        }
        catch (CoreException e) {
            CUIPlugin.getDefault().log(e);
        }
        CoreModel.getDefault().removeElementChangedListener((IElementChangedListener)this);
    }

    private void makeActions() {
        this.countSymbolsAction = new CountNodeAction(this.viewer);
        this.discardExternalDefsAction = new DiscardExternalDefsAction(this.viewer, this);
        this.toggleLinkingAction = new ToggleLinkingAction(this);
        this.openDefinitionAction = new OpenDefinitionAction(this.viewer);
        this.findDeclarationsAction = new FindDeclarationsAction(this.viewer);
        this.findReferencesAction = new FindReferencesAction(this.viewer);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IndexView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void fillContextMenu(IMenuManager manager) {
        if (this.countSymbolsAction.valid()) {
            manager.add((IAction)this.countSymbolsAction);
        }
        if (this.discardExternalDefsAction.valid()) {
            manager.add((IAction)this.discardExternalDefsAction);
        }
        if (this.openDefinitionAction.valid()) {
            manager.add((IAction)this.openDefinitionAction);
        }
        if (this.findDeclarationsAction.valid()) {
            manager.add((IAction)this.findDeclarationsAction);
        }
        if (this.findReferencesAction.valid()) {
            manager.add((IAction)this.findReferencesAction);
        }
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IndexView.this.openDefinitionAction.run();
            }
        });
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.toggleLinkingAction);
        manager.add((IAction)this.discardExternalDefsAction);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void handleChange(PDOM pdom) {
        this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IndexView.this.viewer.refresh();
            }
        });
    }

    public void elementChanged(ElementChangedEvent event) {
        if (event.getType() != 1) {
            return;
        }
        this.processDelta(event.getDelta());
    }

    private void processDelta(ICElementDelta delta) {
        block11: {
            int type = delta.getElement().getElementType();
            switch (type) {
                case 10: {
                    ICElementDelta[] children = delta.getAffectedChildren();
                    int i = 0;
                    while (i < children.length) {
                        this.processDelta(children[i]);
                        ++i;
                    }
                    break;
                }
                case 11: {
                    switch (delta.getKind()) {
                        case 1: {
                            try {
                                PDOM pdom = (PDOM)CCorePlugin.getPDOMManager().getPDOM((ICProject)delta.getElement());
                                pdom.addListener((PDOM.IListener)this);
                                this.handleChange(pdom);
                            }
                            catch (CoreException coreException) {}
                            break block11;
                        }
                        case 2: {
                            this.handleChange(null);
                        }
                    }
                }
            }
        }
    }

    private static class Filter
    extends ViewerFilter {
        public boolean showExternalDefs = false;

        private Filter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof PDOMBinding) {
                PDOMName name;
                block6: {
                    PDOMBinding binding = (PDOMBinding)element;
                    try {
                        name = binding.getFirstReference();
                        if (name == null) {
                            name = binding.getFirstDeclaration();
                        }
                        if (name == null) {
                            name = binding.getFirstDefinition();
                        }
                        if (name != null) break block6;
                        return false;
                    }
                    catch (CoreException e) {
                        CUIPlugin.getDefault().log(e);
                        return true;
                    }
                }
                IASTFileLocation location = name.getFileLocation();
                Path path = new Path(location.getFileName());
                IFile input = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
                return input != null;
            }
            return true;
        }
    }

    private class Counter
    implements IPDOMVisitor {
        public int count;

        private Counter() {
        }

        public boolean visit(IPDOMNode node) throws CoreException {
            ++this.count;
            return false;
        }

        public void leave(IPDOMNode node) throws CoreException {
        }
    }

    private static class Children
    implements IPDOMVisitor {
        private int index;
        private IPDOMNode[] nodes;

        public Children(IPDOMNode[] nodes) {
            this.nodes = nodes;
        }

        public boolean visit(IPDOMNode node) throws CoreException {
            this.nodes[this.index++] = node;
            return false;
        }

        public void leave(IPDOMNode node) throws CoreException {
        }
    }

    private static class HasChildren
    implements IPDOMVisitor {
        public boolean hasChildren;

        private HasChildren() {
        }

        public boolean visit(IPDOMNode node) throws CoreException {
            this.hasChildren = true;
            throw new CoreException(Status.OK_STATUS);
        }

        public void leave(IPDOMNode node) throws CoreException {
        }
    }

    private class IndexContentProvider
    implements ITreeContentProvider {
        private IndexContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            try {
                if (parentElement instanceof ICProject) {
                    PDOMLinkage firstLinkage;
                    PDOM pdom = (PDOM)CCorePlugin.getPDOMManager().getPDOM((ICProject)parentElement);
                    int n = 0;
                    PDOMLinkage linkage = firstLinkage = pdom.getFirstLinkage();
                    while (linkage != null) {
                        ++n;
                        linkage = linkage.getNextLinkage();
                    }
                    if (n == 1) {
                        return this.getChildren(firstLinkage);
                    }
                    Object[] linkages = new PDOMLinkage[n];
                    int i = 0;
                    PDOMLinkage linkage2 = pdom.getFirstLinkage();
                    while (linkage2 != null) {
                        linkages[i++] = linkage2;
                        linkage2 = linkage2.getNextLinkage();
                    }
                    return linkages;
                }
                if (parentElement instanceof IPDOMNode) {
                    IPDOMNode node = (IPDOMNode)parentElement;
                    Counter counter = new Counter();
                    node.accept((IPDOMVisitor)counter);
                    Object[] children = new IPDOMNode[counter.count];
                    Children childrener = new Children((IPDOMNode[])children);
                    node.accept((IPDOMVisitor)childrener);
                    return children;
                }
            }
            catch (CoreException e) {
                CUIPlugin.getDefault().log(e);
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            block9: {
                block7: {
                    PDOMLinkage[] linkages;
                    block8: {
                        if (!(element instanceof ICProject)) break block7;
                        PDOM pdom = (PDOM)CCorePlugin.getPDOMManager().getPDOM((ICProject)element);
                        linkages = pdom.getLinkages();
                        if (linkages.length != 0) break block8;
                        return false;
                    }
                    if (linkages.length == 1) {
                        return this.hasChildren(linkages[0]);
                    }
                    return true;
                }
                try {
                    HasChildren hasChildren;
                    block10: {
                        if (!(element instanceof IPDOMNode)) break block9;
                        hasChildren = new HasChildren();
                        try {
                            ((IPDOMNode)element).accept((IPDOMVisitor)hasChildren);
                        }
                        catch (CoreException e) {
                            if (e.getStatus() == Status.OK_STATUS) break block10;
                            throw e;
                        }
                    }
                    return hasChildren.hasChildren;
                }
                catch (CoreException e) {
                    CUIPlugin.getDefault().log(e);
                }
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            try {
                if (inputElement instanceof ICModel) {
                    ICModel model = (ICModel)inputElement;
                    Object[] projects = model.getCProjects();
                    Arrays.sort(projects, new Comparator(this){
                        final /* synthetic */ IndexContentProvider this$1;
                        {
                            this.this$1 = indexContentProvider;
                        }

                        public int compare(Object arg0, Object arg1) {
                            String name0 = ((ICProject)arg0).getElementName();
                            String name1 = ((ICProject)arg1).getElementName();
                            return name0.compareToIgnoreCase(name1);
                        }
                    });
                    return projects;
                }
            }
            catch (CModelException e) {
                CUIPlugin.getDefault().log(e);
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

