/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.actions;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.internal.ui.dialogs.StatusDialog;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConvertManagedBuildObject;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class ConvertTargetDialog
extends StatusDialog {
    private final String title;
    protected List convertersList;
    private IProject project;
    private Map conversionElements;
    private IConfigurationElement selectedConversionElement;
    private static boolean isConversionSuccessful = false;
    public static final String PREFIX = "ProjectConvert";
    public static final String CONVERTERS_LIST = "ProjectConvert.convertersList";

    protected ConvertTargetDialog(Shell parentShell, IProject project, String title) {
        super(parentShell);
        this.title = title;
        this.setProject(project);
        this.conversionElements = ManagedBuildManager.getConversionElements((IBuildObject)this.getProjectType());
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.handleConverterSelection();
            IConvertManagedBuildObject convertBuildObject = null;
            try {
                convertBuildObject = (IConvertManagedBuildObject)this.getSelectedConversionElement().createExecutableExtension("class");
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            if (convertBuildObject != null) {
                String fromId = this.getSelectedConversionElement().getAttribute("fromId");
                String toId = this.getSelectedConversionElement().getAttribute("toId");
                IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)this.getProject());
                if (info != null) {
                    IManagedProject managedProject = info.getManagedProject();
                    if (managedProject != null) {
                        if (convertBuildObject.convert((IBuildObject)managedProject, fromId, toId, true) == null) {
                            this.setConversionSuccessful(false);
                        } else {
                            this.setConversionSuccessful(true);
                        }
                    } else {
                        this.setConversionSuccessful(false);
                    }
                } else {
                    this.setConversionSuccessful(false);
                }
            } else {
                this.setConversionSuccessful(false);
            }
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setFont(parent.getFont());
        comp.setLayout((Layout)new GridLayout(1, true));
        comp.setLayoutData((Object)new GridData(1808));
        Group convertersListGroup = new Group(comp, 0);
        convertersListGroup.setFont(parent.getFont());
        convertersListGroup.setText(ManagedBuilderUIMessages.getResourceString(CONVERTERS_LIST));
        convertersListGroup.setLayout((Layout)new GridLayout(1, false));
        convertersListGroup.setLayoutData((Object)new GridData(1808));
        this.convertersList = new List((Composite)convertersListGroup, 2820);
        this.convertersList.setFont(convertersListGroup.getFont());
        GridData data = new GridData(1808);
        this.convertersList.setLayoutData((Object)data);
        this.convertersList.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                ConvertTargetDialog.this.convertersList = null;
            }
        });
        this.convertersList.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ConvertTargetDialog.this.validateState();
            }
        });
        Object[] objs = this.getConversionElements().keySet().toArray();
        String[] names = new String[objs.length];
        int i = 0;
        while (i < objs.length) {
            Object object = objs[i];
            names[i] = (String)object;
            ++i;
        }
        this.convertersList.setItems(names);
        this.validateState();
        return comp;
    }

    private void handleConverterSelection() {
        int selectionIndex = this.convertersList.getSelectionIndex();
        String selectedConverterName = this.convertersList.getItem(selectionIndex);
        IConfigurationElement selectedElement = (IConfigurationElement)this.getConversionElements().get(selectedConverterName);
        this.setSelectedConversionElement(selectedElement);
    }

    private void validateState() {
        StatusInfo status = new StatusInfo();
        if (this.convertersList.getSelectionIndex() == -1) {
            status.setError("");
        }
        this.updateStatus((IStatus)status);
    }

    private Map getConversionElements() {
        if (this.conversionElements == null) {
            this.conversionElements = new HashMap();
        }
        return this.conversionElements;
    }

    private IProjectType getProjectType() {
        IManagedProject managedProject;
        IProjectType projectType = null;
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)this.getProject());
        if (info != null && (managedProject = info.getManagedProject()) != null) {
            projectType = managedProject.getProjectType();
        }
        return projectType;
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public IConfigurationElement getSelectedConversionElement() {
        return this.selectedConversionElement;
    }

    public void setSelectedConversionElement(IConfigurationElement selectedConversionElement) {
        this.selectedConversionElement = selectedConversionElement;
    }

    public static boolean isConversionSuccessful() {
        return isConversionSuccessful;
    }

    public void setConversionSuccessful(boolean isConversionSuccessful) {
        ConvertTargetDialog.isConversionSuccessful = isConversionSuccessful;
    }
}

