/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.importexecutable;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceLookupDirector;
import org.eclipse.cdt.debug.ui.importexecutable.ImportExecutablePageOne;
import org.eclipse.cdt.debug.ui.importexecutable.ImportExecutablePageTwo;
import org.eclipse.cdt.debug.ui.importexecutable.Messages;
import org.eclipse.cdt.internal.core.model.ExternalTranslationUnit;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.DirectorySourceContainer;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.progress.UIJob;

public abstract class AbstractImportExecutableWizard
extends Wizard
implements INewWizard {
    public static final String DEBUG_PROJECT_ID = "org.eclipse.cdt.debug";
    protected ImportExecutablePageOne pageOne;
    protected ImportExecutablePageTwo pageTwo;

    public abstract void addBinaryParsers(IProject var1) throws CoreException;

    private void addExecutables(IProject project) throws CoreException {
        String[] executables = this.pageOne.getSelectedExecutables();
        int i = 0;
        while (i < executables.length) {
            IPath location = Path.fromOSString((String)executables[i]);
            String executableName = location.toFile().getName();
            IFile exeFile = project.getFile(executableName);
            if (!exeFile.exists()) {
                exeFile.createLink(location, 0, null);
            }
            ++i;
        }
    }

    public void addPages() {
        super.addPages();
        this.pageOne = new ImportExecutablePageOne(this);
        this.addPage((IWizardPage)this.pageOne);
        this.pageTwo = new ImportExecutablePageTwo(this);
        this.addPage((IWizardPage)this.pageTwo);
    }

    private void addSourceLocation(ISourceLocator locator, AbstractSourceLookupDirector director, IPath unitLocation) {
        if (unitLocation.toFile().exists()) {
            boolean found = false;
            String unitLocationPathString = unitLocation.toOSString();
            if (locator instanceof ICSourceLocator) {
                found = ((ICSourceLocator)locator).findSourceElement(unitLocationPathString) != null;
            } else if (locator instanceof CSourceLookupDirector) {
                found = ((CSourceLookupDirector)locator).contains(unitLocationPathString);
            }
            if (!found) {
                DirectorySourceContainer directoryContainer = new DirectorySourceContainer(unitLocation.removeLastSegments(1), false);
                ArrayList<ISourceContainer> containerList = new ArrayList<ISourceContainer>(Arrays.asList(director.getSourceContainers()));
                containerList.add((ISourceContainer)directoryContainer);
                director.setSourceContainers(containerList.toArray(new ISourceContainer[containerList.size()]));
            }
        }
    }

    protected void addSourceLocations(IBinary[] binaries, ILaunchConfigurationWorkingCopy configuration) {
        String memento = null;
        String type = null;
        try {
            ILaunchManager launchManager;
            IPersistableSourceLocator locator;
            memento = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, null);
            type = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, null);
            if (type == null) {
                type = configuration.getType().getSourceLocatorId();
            }
            if ((locator = (launchManager = DebugPlugin.getDefault().getLaunchManager()).newSourceLocator(type)) instanceof AbstractSourceLookupDirector) {
                AbstractSourceLookupDirector director = (AbstractSourceLookupDirector)locator;
                if (memento == null) {
                    director.initializeDefaults((ILaunchConfiguration)configuration);
                } else {
                    director.initializeFromMemento(memento, (ILaunchConfiguration)configuration);
                }
                int i = 0;
                while (i < binaries.length) {
                    IBinary binary = binaries[i];
                    if (!binary.getPath().lastSegment().startsWith(".")) {
                        this.addSourceLocation((ISourceLocator)locator, director, binary.getUnderlyingResource().getLocation());
                        List sourceFiles = binary.getChildrenOfType(60);
                        if (sourceFiles.size() == 0) {
                            sourceFiles = binary.getChildrenOfType(60);
                        }
                        Iterator iter = sourceFiles.iterator();
                        while (iter.hasNext()) {
                            Object element = iter.next();
                            if (!(element instanceof ExternalTranslationUnit)) continue;
                            ExternalTranslationUnit unit = (ExternalTranslationUnit)element;
                            IPath unitLocation = unit.getLocation();
                            this.addSourceLocation((ISourceLocator)locator, director, unitLocation);
                        }
                    }
                    ++i;
                }
                configuration.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, director.getMemento());
                configuration.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, director.getId());
            }
        }
        catch (CoreException coreException) {
            return;
        }
    }

    public IProject createCProjectForExecutable(String projectName) throws OperationCanceledException, CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject newProjectHandle = workspace.getRoot().getProject(projectName);
        IProjectDescription description = workspace.newProjectDescription(newProjectHandle.getName());
        description.setLocation(null);
        IProject newProject = CCorePlugin.getDefault().createCProject(description, newProjectHandle, null, DEBUG_PROJECT_ID);
        return newProject;
    }

    public void createLaunchConfiguration(ICProject targetProject) throws CoreException {
        ILaunchConfigurationWorkingCopy wc = this.getSelectedLaunchConfigurationType().newInstance(null, this.getImportExecutablePage2().getNewConfigurationName());
        wc.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", targetProject.getProject().getName());
        wc.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", new File(this.getImportExecutablePage().getSelectedExecutables()[0]).getName());
        this.addSourceLocations(targetProject.getBinaryContainer().getBinaries(), wc);
        this.setConfigurationDefaults(wc);
        StructuredSelection selection = new StructuredSelection((Object)wc.doSave());
        String identifier = new String("org.eclipse.debug.ui.launchGroup.debug");
        UIJob openLaunchConfigJob = new UIJob(Messages.AbstractImportExecutableWizard_CreateLaunchConfiguration, (IStructuredSelection)selection, identifier){
            private final /* synthetic */ IStructuredSelection val$selection;
            private final /* synthetic */ String val$identifier;
            {
                this.val$selection = iStructuredSelection;
                this.val$identifier = string;
                super($anonymous0);
            }

            public IStatus runInUIThread(IProgressMonitor monitor) {
                DebugUITools.openLaunchConfigurationDialogOnGroup((Shell)CUIPlugin.getActiveWorkbenchShell(), (IStructuredSelection)this.val$selection, (String)this.val$identifier);
                return Status.OK_STATUS;
            }
        };
        openLaunchConfigJob.schedule();
    }

    public abstract String getExecutableListLabel();

    public ImportExecutablePageOne getImportExecutablePage() {
        return this.pageOne;
    }

    public ImportExecutablePageTwo getImportExecutablePage2() {
        return this.pageTwo;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.pageOne) {
            this.pageTwo.checkExecutableSettings();
        }
        return super.getNextPage(page);
    }

    public abstract String getPageOneDescription();

    public abstract String getPageOneTitle();

    public ILaunchConfigurationType getSelectedLaunchConfigurationType() {
        return this.pageTwo.getSelectedLaunchConfigurationType();
    }

    public String getDefaultWindowTitle() {
        return Messages.AbstractImportExecutableWizard_windowTitle;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(this.getDefaultWindowTitle());
        this.setNeedsProgressMonitor(true);
    }

    public abstract boolean isExecutableFile(File var1);

    public boolean performFinish() {
        ICProject targetProject = null;
        try {
            if (this.pageTwo.isCreateNewProjectSelected()) {
                IProject newProject = this.createCProjectForExecutable(this.pageTwo.getNewProjectName());
                this.setupProject(newProject);
                this.addExecutables(newProject);
                this.addBinaryParsers(newProject);
                targetProject = CCorePlugin.getDefault().getCoreModel().create(newProject);
            } else {
                ICProject existingProject = this.pageTwo.getExistingCProject();
                this.addExecutables(existingProject.getProject());
                targetProject = existingProject;
            }
            if (this.pageTwo.isCreateLaunchConfigurationSelected()) {
                this.createLaunchConfiguration(targetProject);
            }
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        catch (CoreException coreException) {}
        return true;
    }

    public void setConfigurationDefaults(ILaunchConfigurationWorkingCopy config) {
    }

    public abstract void setupFileDialog(FileDialog var1);

    public void setupProject(IProject newProject) throws CoreException {
    }

    public abstract boolean supportsConfigurationType(ILaunchConfigurationType var1);
}

