/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom;

import java.util.LinkedList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.cdt.core.dom.IPDOM;
import org.eclipse.cdt.core.dom.IPDOMIndexer;
import org.eclipse.cdt.core.dom.IPDOMIndexerTask;
import org.eclipse.cdt.core.dom.IPDOMManager;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ElementChangedEvent;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.PDOMIndexerJob;
import org.eclipse.cdt.internal.core.pdom.indexer.nulli.PDOMNullIndexer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

public class PDOMManager
implements IPDOMManager,
IElementChangedListener {
    private static final QualifiedName indexerProperty = new QualifiedName("org.eclipse.cdt.core", "pdomIndexer");
    private static final QualifiedName dbNameProperty = new QualifiedName("org.eclipse.cdt.core", "pdomName");
    private static final QualifiedName pdomProperty = new QualifiedName("org.eclipse.cdt.core", "pdom");
    private static final String INDEXER_ID_KEY = "indexerId";
    private PDOMIndexerJob indexerJob;
    private LinkedList indexerJobQueue = new LinkedList();
    private Object indexerJobMutex = new Object();

    public synchronized IPDOM getPDOM(ICProject project) throws CoreException {
        IProject rproject = project.getProject();
        PDOM pdom = (PDOM)rproject.getSessionProperty(pdomProperty);
        if (pdom == null) {
            String dbName = rproject.getPersistentProperty(dbNameProperty);
            if (dbName == null) {
                dbName = String.valueOf(project.getElementName()) + "." + System.currentTimeMillis() + ".pdom";
                rproject.setPersistentProperty(dbNameProperty, dbName);
            }
            IPath dbPath = CCorePlugin.getDefault().getStateLocation().append(dbName);
            pdom = new PDOM(dbPath);
            rproject.setSessionProperty(pdomProperty, (Object)pdom);
            if (pdom.versionMismatch()) {
                this.getIndexer(project).reindex();
            }
        }
        return pdom;
    }

    public IPDOMIndexer getIndexer(ICProject project) {
        try {
            IProject rproject = project.getProject();
            IPDOMIndexer indexer = (IPDOMIndexer)rproject.getSessionProperty(indexerProperty);
            if (indexer == null) {
                indexer = this.createIndexer(project, this.getIndexerId(project));
            }
            return indexer;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    public synchronized void elementChanged(ElementChangedEvent event) {
        if (event.getType() != 1) {
            return;
        }
        try {
            this.processDelta(event.getDelta());
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processDelta(ICElementDelta delta) throws CoreException {
        int type = delta.getElement().getElementType();
        block0 : switch (type) {
            case 10: {
                ICElementDelta[] children = delta.getAffectedChildren();
                int i = 0;
                while (i < children.length) {
                    this.processDelta(children[i]);
                    ++i;
                }
                return;
            }
            case 11: {
                final ICProject project = (ICProject)delta.getElement();
                switch (delta.getKind()) {
                    case 1: {
                        IEclipsePreferences prefs = new ProjectScope(project.getProject()).getNode("org.eclipse.cdt.core");
                        prefs.addNodeChangeListener(new IEclipsePreferences.INodeChangeListener(){

                            public void added(IEclipsePreferences.NodeChangeEvent event) {
                                String indexerId = event.getParent().get(PDOMManager.INDEXER_ID_KEY, null);
                                try {
                                    PDOMManager.this.createIndexer(project, indexerId);
                                }
                                catch (CoreException e) {
                                    CCorePlugin.log(e);
                                }
                            }

                            public void removed(IEclipsePreferences.NodeChangeEvent event) {
                            }
                        });
                        break block0;
                    }
                    case 4: {
                        IPDOMIndexer indexer = this.getIndexer(project);
                        if (indexer == null) return;
                        indexer.handleDelta(delta);
                    }
                }
            }
        }
    }

    public IElementChangedListener getElementChangedListener() {
        return this;
    }

    public String getDefaultIndexerId() {
        IPreferencesService prefService = Platform.getPreferencesService();
        return prefService.getString("org.eclipse.cdt.core", INDEXER_ID_KEY, "org.eclipse.cdt.core.fastIndexer", null);
    }

    public void setDefaultIndexerId(String indexerId) {
        IEclipsePreferences prefs = new InstanceScope().getNode("org.eclipse.cdt.core");
        if (prefs == null) {
            return;
        }
        prefs.put(INDEXER_ID_KEY, indexerId);
        try {
            prefs.flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }

    public String getIndexerId(ICProject project) throws CoreException {
        IEclipsePreferences prefs = new ProjectScope(project.getProject()).getNode("org.eclipse.cdt.core");
        if (prefs == null) {
            return this.getDefaultIndexerId();
        }
        String indexerId = prefs.get(INDEXER_ID_KEY, null);
        if (indexerId == null) {
            try {
                ICDescriptor desc = CCorePlugin.getDefault().getCProjectDescription(project.getProject(), false);
                if (desc != null) {
                    IExtension indexerExt;
                    ICExtensionReference[] ref = desc.get("org.eclipse.cdt.core.CIndexer");
                    if (ref != null && ref.length > 0) {
                        indexerId = ref[0].getID();
                    }
                    if (indexerId != null && (indexerExt = Platform.getExtensionRegistry().getExtension("org.eclipse.cdt.core.CIndexer", indexerId)) == null) {
                        indexerId = null;
                    }
                }
            }
            catch (CoreException coreException) {}
            if (indexerId == null || indexerId.equals("org.eclipse.cdt.core.ctagsindexer")) {
                indexerId = this.getDefaultIndexerId();
            }
            this.setIndexerId(project, indexerId);
        }
        return indexerId;
    }

    public void setIndexerId(ICProject project, String indexerId) throws CoreException {
        IEclipsePreferences prefs = new ProjectScope(project.getProject()).getNode("org.eclipse.cdt.core");
        if (prefs == null) {
            return;
        }
        String oldId = prefs.get(INDEXER_ID_KEY, null);
        if (!indexerId.equals(oldId)) {
            prefs.put(INDEXER_ID_KEY, indexerId);
            this.createIndexer(project, indexerId).reindex();
            new SavePrefs(project).schedule(2000L);
        }
    }

    private IPDOMIndexer createIndexer(ICProject project, String indexerId) throws CoreException {
        IPDOMIndexer indexer = null;
        IExtension indexerExt = Platform.getExtensionRegistry().getExtension("org.eclipse.cdt.core.CIndexer", indexerId);
        if (indexerExt != null) {
            IConfigurationElement[] elements = indexerExt.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement element = elements[i];
                if ("run".equals(element.getName())) {
                    indexer = (IPDOMIndexer)element.createExecutableExtension("class");
                    break;
                }
                ++i;
            }
        }
        if (indexer == null) {
            indexer = new PDOMNullIndexer();
        }
        indexer.setProject(project);
        project.getProject().setSessionProperty(indexerProperty, (Object)indexer);
        return indexer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(IPDOMIndexerTask subjob) {
        Object object = this.indexerJobMutex;
        synchronized (object) {
            this.indexerJobQueue.addLast(subjob);
            if (this.indexerJob == null) {
                this.indexerJob = new PDOMIndexerJob(this);
                this.indexerJob.schedule();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IPDOMIndexerTask getNextTask() {
        Object object = this.indexerJobMutex;
        synchronized (object) {
            return this.indexerJobQueue.isEmpty() ? null : (IPDOMIndexerTask)this.indexerJobQueue.removeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean finishIndexerJob() {
        Object object = this.indexerJobMutex;
        synchronized (object) {
            block4: {
                if (!this.indexerJobQueue.isEmpty()) break block4;
                this.indexerJob = null;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleting(ICProject project) {
        IPDOMIndexer indexer = this.getIndexer(project);
        Object object = this.indexerJobMutex;
        synchronized (object) {
            if (this.indexerJob != null) {
                this.indexerJob.cancelJobs(indexer);
            }
        }
    }

    public void startup() {
        CoreModel.getDefault().addElementChangedListener(this);
    }

    private class SavePrefs
    extends Job {
        private final ICProject project;

        public SavePrefs(ICProject project) {
            super("Save Project Preferences");
            this.project = project;
            this.setSystem(true);
            this.setRule((ISchedulingRule)project.getProject());
        }

        protected IStatus run(IProgressMonitor monitor) {
            IEclipsePreferences prefs = new ProjectScope(this.project.getProject()).getNode("org.eclipse.cdt.core");
            if (prefs != null) {
                try {
                    prefs.flush();
                }
                catch (BackingStoreException backingStoreException) {}
            }
            return Status.OK_STATUS;
        }
    }
}

