/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.db;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.internal.core.pdom.db.Chunk;
import org.eclipse.cdt.internal.core.pdom.db.DBStatus;
import org.eclipse.cdt.internal.core.pdom.db.IString;
import org.eclipse.cdt.internal.core.pdom.db.LongString;
import org.eclipse.cdt.internal.core.pdom.db.ShortString;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class Database {
    final RandomAccessFile file;
    Chunk[] toc;
    private long malloced;
    private long freed;
    public static final int VERSION_OFFSET = 0;
    public static final int CHUNK_SIZE = 16384;
    public static final int MIN_SIZE = 16;
    public static final int INT_SIZE = 4;
    public static final int CHAR_SIZE = 2;
    public static final int PREV_OFFSET = 4;
    public static final int NEXT_OFFSET = 8;
    public static final int DATA_AREA = 4100;
    public static final int MAX_SIZE = 16380;

    public Database(String filename) throws CoreException {
        try {
            this.file = new RandomAccessFile(filename, "rw");
            long nChunks = this.file.length() / 16384L;
            if (nChunks == 0L) {
                this.file.seek(0L);
                this.file.write(new byte[16384]);
                ++nChunks;
            }
            this.toc = new Chunk[(int)nChunks];
            this.toc[0] = new Chunk(this.file, 0);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new DBStatus(e));
        }
    }

    public int getVersion() {
        return this.toc[0].getInt(0);
    }

    public void setVersion(int version) {
        this.toc[0].putInt(0, version);
    }

    public void clear() throws CoreException {
        this.toc[0].clear(4, 4096);
        int block = (this.toc.length - 1) * 16384;
        while (block > 0) {
            this.addBlock(this.getChunk(block), 16384, block);
            block -= 16384;
        }
        this.freed = 0L;
        this.malloced = 0L;
    }

    public boolean save() throws CoreException {
        if (!this.toc[0].save()) {
            return false;
        }
        int i = 1;
        while (i < this.toc.length) {
            if (this.toc[i] != null) {
                this.toc[i].save();
            }
            ++i;
        }
        return true;
    }

    public Chunk getChunk(int offset) throws CoreException {
        int index = offset / 16384;
        Chunk chunk = this.toc[index];
        if (chunk == null) {
            chunk = this.toc[index] = new Chunk(this.file, index * 16384);
        }
        return chunk;
    }

    public int malloc(int size) throws CoreException {
        Chunk chunk;
        if (size > 16380) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", 0, CCorePlugin.getResourceString("pdom.requestTooLarge"), (Throwable)new IllegalArgumentException()));
        }
        int freeblock = 0;
        int matchsize = 0;
        int blocksize = 16;
        while (blocksize <= 16384) {
            if (blocksize - 4 >= size) {
                if (matchsize == 0) {
                    matchsize = blocksize;
                }
                if ((freeblock = this.getFirstBlock(blocksize)) != 0) break;
            }
            blocksize += 16;
        }
        if (freeblock == 0) {
            int i = this.createChunk();
            chunk = this.toc[i];
            freeblock = i * 16384;
            blocksize = 16384;
        } else {
            chunk = this.getChunk(freeblock);
            this.removeBlock(chunk, blocksize, freeblock);
        }
        if (blocksize != matchsize) {
            this.addBlock(chunk, blocksize - matchsize, freeblock + matchsize);
        }
        chunk.putInt(freeblock, -matchsize);
        chunk.clear(freeblock + 4, size);
        this.malloced += (long)matchsize;
        return freeblock + 4;
    }

    private int createChunk() throws CoreException {
        try {
            Chunk[] oldtoc = this.toc;
            int n = oldtoc.length;
            int offset = n * 16384;
            this.file.seek(offset);
            this.file.write(new byte[16384]);
            this.toc = new Chunk[n + 1];
            System.arraycopy(oldtoc, 0, this.toc, 0, n);
            this.toc[n] = new Chunk(this.file, offset);
            return n;
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new DBStatus(e));
        }
    }

    private int getFirstBlock(int blocksize) {
        return this.toc[0].getInt(blocksize / 16 * 4);
    }

    private void setFirstBlock(int blocksize, int block) {
        this.toc[0].putInt(blocksize / 16 * 4, block);
    }

    private void removeBlock(Chunk chunk, int blocksize, int block) throws CoreException {
        int prevblock = chunk.getInt(block + 4);
        int nextblock = chunk.getInt(block + 8);
        if (prevblock != 0) {
            this.putInt(prevblock + 8, nextblock);
        } else {
            this.setFirstBlock(blocksize, nextblock);
        }
        if (nextblock != 0) {
            this.putInt(nextblock + 4, prevblock);
        }
    }

    private void addBlock(Chunk chunk, int blocksize, int block) throws CoreException {
        chunk.putInt(block, blocksize);
        int prevfirst = this.getFirstBlock(blocksize);
        chunk.putInt(block + 4, 0);
        chunk.putInt(block + 8, prevfirst);
        if (prevfirst != 0) {
            this.putInt(prevfirst + 4, block);
        }
        this.setFirstBlock(blocksize, block);
    }

    public void free(int offset) throws CoreException {
        int block = offset - 4;
        Chunk chunk = this.getChunk(block);
        int blocksize = -chunk.getInt(block);
        if (blocksize < 0) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", 0, "Already Freed", (Throwable)new Exception()));
        }
        this.addBlock(chunk, blocksize, block);
        this.freed += (long)blocksize;
    }

    public void putByte(int offset, byte value) throws CoreException {
        Chunk chunk = this.getChunk(offset);
        chunk.putByte(offset, value);
    }

    public byte getByte(int offset) throws CoreException {
        Chunk chunk = this.getChunk(offset);
        return chunk.getByte(offset);
    }

    public void putInt(int offset, int value) throws CoreException {
        Chunk chunk = this.getChunk(offset);
        chunk.putInt(offset, value);
    }

    public int getInt(int offset) throws CoreException {
        Chunk chunk = this.getChunk(offset);
        return chunk.getInt(offset);
    }

    public void putChar(int offset, char value) throws CoreException {
        Chunk chunk = this.getChunk(offset);
        chunk.putChar(offset, value);
    }

    public char getChar(int offset) throws CoreException {
        Chunk chunk = this.getChunk(offset);
        return chunk.getChar(offset);
    }

    public IString newString(String string) throws CoreException {
        if (string.length() > 8188) {
            return new LongString(this, string);
        }
        return new ShortString(this, string);
    }

    public IString newString(char[] chars) throws CoreException {
        if (chars.length > 8188) {
            return new LongString(this, chars);
        }
        return new ShortString(this, chars);
    }

    public IString getString(int offset) throws CoreException {
        int length = this.getInt(offset);
        if (length > 8188) {
            return new LongString(this, offset);
        }
        return new ShortString(this, offset);
    }

    public int getNumChunks() {
        return this.toc.length;
    }

    public void reportFreeBlocks() throws CoreException {
        System.out.println("Allocated size: " + this.toc.length * 16384);
        System.out.println("malloc'ed: " + this.malloced);
        System.out.println("free'd: " + this.freed);
        System.out.println("wasted: " + ((long)(this.toc.length * 16384) - (this.malloced - this.freed)));
        System.out.println("Free blocks");
        int bs = 16;
        while (bs <= 16384) {
            int count = 0;
            int block = this.getFirstBlock(bs);
            while (block != 0) {
                ++count;
                block = this.getInt(block + 8);
            }
            if (count != 0) {
                System.out.println("Block size: " + bs + "=" + count);
            }
            bs += 16;
        }
    }
}

