/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNotImplementedError;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPParameter;
import org.eclipse.core.runtime.CoreException;

public class PDOMCPPFunction
extends PDOMBinding
implements ICPPFunction,
ICPPFunctionType {
    public static final int NUM_PARAMS = 24;
    public static final int FIRST_PARAM = 28;
    public static final int RECORD_SIZE = 32;

    public PDOMCPPFunction(PDOM pdom, PDOMNode parent, IASTName name) throws CoreException {
        super(pdom, parent, name);
        IASTNode parentNode = name.getParent();
        if (parentNode instanceof ICPPASTFunctionDeclarator) {
            ICPPASTFunctionDeclarator funcDecl = (ICPPASTFunctionDeclarator)parentNode;
            IASTParameterDeclaration[] params = funcDecl.getParameters();
            pdom.getDB().putInt(this.record + 24, params.length);
            int i = 0;
            while (i < params.length) {
                ICPPASTParameterDeclaration param = (ICPPASTParameterDeclaration)params[i];
                IASTName paramName = param.getDeclarator().getName();
                IBinding binding = paramName.resolveBinding();
                if (binding instanceof ICPPParameter) {
                    ICPPParameter paramBinding = (ICPPParameter)binding;
                    this.setFirstParameter(new PDOMCPPParameter(pdom, this, paramName, paramBinding));
                }
                ++i;
            }
        }
    }

    public PDOMCPPFunction(PDOM pdom, int bindingRecord) {
        super(pdom, bindingRecord);
    }

    protected int getRecordSize() {
        return 32;
    }

    public int getNodeType() {
        return 4;
    }

    public PDOMCPPParameter getFirstParameter() throws CoreException {
        int rec = this.pdom.getDB().getInt(this.record + 28);
        return rec != 0 ? new PDOMCPPParameter(this.pdom, rec) : null;
    }

    public void setFirstParameter(PDOMCPPParameter param) throws CoreException {
        if (param != null) {
            param.setNextParameter(this.getFirstParameter());
        }
        int rec = param != null ? param.getRecord() : 0;
        this.pdom.getDB().putInt(this.record + 28, rec);
    }

    public boolean isInline() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public boolean isMutable() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public IScope getFunctionScope() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public IParameter[] getParameters() throws DOMException {
        try {
            int n = this.pdom.getDB().getInt(this.record + 24);
            IParameter[] params = new IParameter[n];
            PDOMCPPParameter param = this.getFirstParameter();
            while (param != null) {
                params[--n] = param;
                param = param.getNextParameter();
            }
            return params;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new IParameter[0];
        }
    }

    public IFunctionType getType() throws DOMException {
        return this;
    }

    public boolean isAuto() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public boolean isExtern() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public boolean isRegister() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public boolean isStatic() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public boolean takesVarArgs() throws DOMException {
        return false;
    }

    public String[] getQualifiedName() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public char[][] getQualifiedNameCharArray() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public boolean isGloballyQualified() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public IType[] getParameterTypes() throws DOMException {
        try {
            int n = this.pdom.getDB().getInt(this.record + 24);
            IType[] types = new IType[n];
            PDOMCPPParameter param = this.getFirstParameter();
            while (param != null) {
                types[--n] = param.getType();
                param = param.getNextParameter();
            }
            return types;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new IType[0];
        }
    }

    public IType getReturnType() throws DOMException {
        return null;
    }

    public boolean isConst() {
        throw new PDOMNotImplementedError();
    }

    public boolean isVolatile() {
        throw new PDOMNotImplementedError();
    }

    public boolean isSameType(IType type) {
        if (type instanceof PDOMCPPFunction) {
            return this.record == ((PDOMCPPFunction)type).getRecord();
        }
        return false;
    }

    public Object clone() {
        throw new PDOMNotImplementedError();
    }
}

