/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import java.util.ArrayList;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOM;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCStructure;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPClassType;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPLinkage;
import org.eclipse.cdt.internal.ui.search.PDOMSearchQuery;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;

public class PDOMSearchPatternQuery
extends PDOMSearchQuery {
    public static final int FIND_CLASS_STRUCT = 16;
    public static final int FIND_FUNCTION = 32;
    public static final int FIND_VARIABLE = 64;
    public static final int FIND_UNION = 256;
    public static final int FIND_METHOD = 512;
    public static final int FIND_FIELD = 1024;
    public static final int FIND_ENUM = 4096;
    public static final int FIND_ENUMERATOR = 8192;
    public static final int FIND_NAMESPACE = 16384;
    public static final int FIND_TYPEDEF = 65536;
    public static final int FIND_MACRO = 131072;
    public static final int FIND_ALL_TYPES = 227184;
    private String scopeDesc;
    private String patternStr;
    private Pattern[] pattern;

    public PDOMSearchPatternQuery(ICElement[] scope, String scopeDesc, String patternStr, boolean isCaseSensitive, int flags) throws PatternSyntaxException {
        super(scope, flags);
        this.scopeDesc = scopeDesc;
        this.patternStr = patternStr;
        ArrayList<Pattern> patternList = new ArrayList<Pattern>();
        StringBuffer buff = new StringBuffer();
        int n = patternStr.length();
        int i = 0;
        while (i < n) {
            char c = patternStr.charAt(i);
            switch (c) {
                case '*': {
                    buff.append(".*");
                    break;
                }
                case '?': {
                    buff.append('.');
                    break;
                }
                case '.': 
                case ':': {
                    if (buff.length() <= 0) break;
                    if (isCaseSensitive) {
                        patternList.add(Pattern.compile(buff.toString()));
                    } else {
                        patternList.add(Pattern.compile(buff.toString(), 2));
                    }
                    buff = new StringBuffer();
                    break;
                }
                default: {
                    buff.append(c);
                }
            }
            ++i;
        }
        if (buff.length() > 0) {
            if (isCaseSensitive) {
                patternList.add(Pattern.compile(buff.toString()));
            } else {
                patternList.add(Pattern.compile(buff.toString(), 2));
            }
        }
        this.pattern = patternList.toArray(new Pattern[patternList.size()]);
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        try {
            int i = 0;
            while (i < this.projects.length) {
                this.searchProject(this.projects[i], monitor);
                ++i;
            }
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            return e.getStatus();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void searchProject(ICProject project, IProgressMonitor monitor) throws CoreException {
        IPDOM pdom = CCorePlugin.getPDOMManager().getPDOM(project);
        try {
            pdom.acquireReadLock();
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        try {
            IBinding[] bindings = pdom.findBindings(this.pattern, monitor);
            int i = 0;
            while (i < bindings.length) {
                PDOMBinding pdomBinding = (PDOMBinding)bindings[i];
                if ((this.flags & 0x37770) == 227184) {
                    this.createMatches(pdomBinding.getLinkage().getLanguage(), (IBinding)pdomBinding);
                } else if (pdomBinding.getLinkage() instanceof PDOMCPPLinkage) {
                    switch (pdomBinding.getNodeType()) {
                        case 5: {
                            switch (((PDOMCPPClassType)pdomBinding).getKey()) {
                                case 1: 
                                case 3: {
                                    if ((this.flags & 0x10) != 16) break;
                                    this.createMatches(pdomBinding.getLinkage().getLanguage(), (IBinding)pdomBinding);
                                    break;
                                }
                                case 2: {
                                    if ((this.flags & 0x100) != 256) break;
                                    this.createMatches(pdomBinding.getLinkage().getLanguage(), (IBinding)pdomBinding);
                                    break;
                                }
                            }
                            break;
                        }
                        case 12: {
                            if ((this.flags & 0x1000) != 4096) break;
                            this.createMatches(pdomBinding.getLinkage().getLanguage(), (IBinding)pdomBinding);
                            break;
                        }
                        case 13: {
                            if ((this.flags & 0x2000) != 8192) break;
                            this.createMatches(pdomBinding.getLinkage().getLanguage(), (IBinding)pdomBinding);
                            break;
                        }
                        case 6: {
                            if ((this.flags & 0x400) != 1024) break;
                            this.createMatches(pdomBinding.getLinkage().getLanguage(), (IBinding)pdomBinding);
                            break;
                        }
                        case 4: {
                            if ((this.flags & 0x20) != 32) break;
                            this.createMatches(pdomBinding.getLinkage().getLanguage(), (IBinding)pdomBinding);
                            break;
                        }
                        case 7: {
                            if ((this.flags & 0x200) != 512) break;
                            this.createMatches(pdomBinding.getLinkage().getLanguage(), (IBinding)pdomBinding);
                            break;
                        }
                        case 8: 
                        case 9: {
                            if ((this.flags & 0x4000) != 16384) break;
                            this.createMatches(pdomBinding.getLinkage().getLanguage(), (IBinding)pdomBinding);
                            break;
                        }
                        case 14: {
                            if ((this.flags & 0x10000) != 65536) break;
                            this.createMatches(pdomBinding.getLinkage().getLanguage(), (IBinding)pdomBinding);
                            break;
                        }
                        case 3: {
                            if ((this.flags & 0x40) != 64) break;
                            this.createMatches(pdomBinding.getLinkage().getLanguage(), (IBinding)pdomBinding);
                            break;
                        }
                    }
                } else if (pdomBinding.getLinkage() instanceof PDOMCLinkage) {
                    switch (pdomBinding.getNodeType()) {
                        case 5: {
                            switch (((PDOMCStructure)pdomBinding).getKey()) {
                                case 1: {
                                    if ((this.flags & 0x10) != 16) break;
                                    this.createMatches(pdomBinding.getLinkage().getLanguage(), (IBinding)pdomBinding);
                                    break;
                                }
                                case 2: {
                                    if ((this.flags & 0x100) != 256) break;
                                    this.createMatches(pdomBinding.getLinkage().getLanguage(), (IBinding)pdomBinding);
                                    break;
                                }
                            }
                            break;
                        }
                        case 7: {
                            if ((this.flags & 0x1000) != 4096) break;
                            this.createMatches(pdomBinding.getLinkage().getLanguage(), (IBinding)pdomBinding);
                            break;
                        }
                        case 8: {
                            if ((this.flags & 0x2000) != 8192) break;
                            this.createMatches(pdomBinding.getLinkage().getLanguage(), (IBinding)pdomBinding);
                            break;
                        }
                        case 6: {
                            if ((this.flags & 0x400) != 1024) break;
                            this.createMatches(pdomBinding.getLinkage().getLanguage(), (IBinding)pdomBinding);
                            break;
                        }
                        case 4: {
                            if ((this.flags & 0x20) != 32) break;
                            this.createMatches(pdomBinding.getLinkage().getLanguage(), (IBinding)pdomBinding);
                            break;
                        }
                        case 9: {
                            if ((this.flags & 0x10000) != 65536) break;
                            this.createMatches(pdomBinding.getLinkage().getLanguage(), (IBinding)pdomBinding);
                            break;
                        }
                        case 3: {
                            if ((this.flags & 0x40) != 64) break;
                            this.createMatches(pdomBinding.getLinkage().getLanguage(), (IBinding)pdomBinding);
                            break;
                        }
                    }
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            pdom.releaseReadLock();
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        pdom.releaseReadLock();
    }

    public String getLabel() {
        return String.valueOf(super.getLabel()) + " " + this.patternStr + " in " + this.scopeDesc;
    }
}

