/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.macros;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOutputType;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.macros.BuildMacro;
import org.eclipse.cdt.managedbuilder.internal.macros.IMacroContextInfo;
import org.eclipse.cdt.managedbuilder.internal.macros.IMacroSubstitutor;
import org.eclipse.cdt.managedbuilder.internal.macros.MacroResolver;
import org.eclipse.cdt.managedbuilder.internal.macros.OptionContextData;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacro;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacroSupplier;
import org.eclipse.cdt.managedbuilder.macros.IFileContextBuildMacroValues;
import org.eclipse.cdt.managedbuilder.macros.IFileContextData;
import org.eclipse.cdt.managedbuilder.macros.IOptionContextData;
import org.eclipse.cdt.managedbuilder.makegen.IManagedBuilderMakefileGenerator;
import org.eclipse.cdt.utils.Platform;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.osgi.framework.Bundle;

public class MbsMacroSupplier
implements IBuildMacroSupplier {
    private static MbsMacroSupplier fInstance;
    public static final String DOT = ".";
    public static final String EMPTY_STRING = "";
    private static final String[] fFileMacros;
    private static final String[] fOptionMacros;
    private static final String[] fToolMacros;
    private static final String[] fConfigurationMacros;
    private static final String[] fProjectMacros;
    private static final String[] fWorkspaceMacros;
    private static final String[] fCDTEclipseMacros;

    static {
        fFileMacros = new String[]{"InputFileName", "InputFileExt", "InputFileBaseName", "InputFileRelPath", "InputDirRelPath", "OutputFileName", "OutputFileExt", "OutputFileBaseName", "OutputFileRelPath", "OutputDirRelPath"};
        fOptionMacros = new String[]{"IncludeDefaults", "ParentVersion"};
        fToolMacros = new String[]{"ToolVersion"};
        fConfigurationMacros = new String[]{"ConfigName", "ConfigDescription", "BuildArtifactFileName", "BuildArtifactFileExt", "BuildArtifactFileBaseName", "BuildArtifactFilePrefix", "TargetOsList", "TargetArchList", "ToolChainVersion", "BuilderVersion"};
        fProjectMacros = new String[]{"ProjName", "ProjDirPath"};
        fWorkspaceMacros = new String[]{"WorkspaceDirPath", "DirectoryDelimiter", "PathDelimiter"};
        fCDTEclipseMacros = new String[]{"EclipseVersion", "CDTVersion", "MBSVersion", "HostOsName", "HostArchName", "OsType", "ArchType"};
    }

    private String getExplicitFileMacroValue(String name, IPath inputFileLocation, IPath outputFileLocation, IConfiguration cfg) {
        IPath filePath;
        IPath workingDirectory;
        String value = null;
        if ("InputFileName".equals(name)) {
            if (inputFileLocation != null && inputFileLocation.segmentCount() > 0) {
                value = inputFileLocation.lastSegment();
            }
        } else if ("InputFileExt".equals(name)) {
            if (inputFileLocation != null && inputFileLocation.segmentCount() > 0) {
                value = this.getExtension(inputFileLocation.lastSegment());
            }
        } else if ("InputFileBaseName".equals(name)) {
            if (inputFileLocation != null && inputFileLocation.segmentCount() > 0) {
                value = this.getBaseName(inputFileLocation.lastSegment());
            }
        } else if ("InputFileRelPath".equals(name)) {
            IPath filePath2;
            IPath workingDirectory2;
            if (inputFileLocation != null && inputFileLocation.segmentCount() > 0 && (workingDirectory2 = this.getBuilderCWD(cfg)) != null && (filePath2 = ManagedBuildManager.calculateRelativePath(workingDirectory2, inputFileLocation)) != null) {
                value = filePath2.toOSString();
            }
        } else if ("InputDirRelPath".equals(name)) {
            IPath filePath3;
            IPath workingDirectory3;
            if (inputFileLocation != null && inputFileLocation.segmentCount() > 0 && (workingDirectory3 = this.getBuilderCWD(cfg)) != null && (filePath3 = ManagedBuildManager.calculateRelativePath(workingDirectory3, inputFileLocation.removeLastSegments(1).addTrailingSeparator())) != null) {
                value = filePath3.toOSString();
            }
        } else if ("OutputFileName".equals(name)) {
            if (outputFileLocation != null && outputFileLocation.segmentCount() > 0) {
                value = outputFileLocation.lastSegment();
            }
        } else if ("OutputFileExt".equals(name)) {
            if (outputFileLocation != null && outputFileLocation.segmentCount() > 0) {
                value = this.getExtension(outputFileLocation.lastSegment());
            }
        } else if ("OutputFileBaseName".equals(name)) {
            if (outputFileLocation != null && outputFileLocation.segmentCount() > 0) {
                value = this.getBaseName(outputFileLocation.lastSegment());
            }
        } else if ("OutputFileRelPath".equals(name)) {
            IPath filePath4;
            IPath workingDirectory4;
            if (outputFileLocation != null && outputFileLocation.segmentCount() > 0 && (workingDirectory4 = this.getBuilderCWD(cfg)) != null && (filePath4 = ManagedBuildManager.calculateRelativePath(workingDirectory4, outputFileLocation)) != null) {
                value = filePath4.toOSString();
            }
        } else if ("OutputDirRelPath".equals(name) && outputFileLocation != null && outputFileLocation.segmentCount() > 0 && (workingDirectory = this.getBuilderCWD(cfg)) != null && (filePath = ManagedBuildManager.calculateRelativePath(workingDirectory, outputFileLocation.removeLastSegments(1).addTrailingSeparator())) != null) {
            value = filePath.toOSString();
        }
        return value;
    }

    public String[] getMacroNames(int contextType) {
        return this.getMacroNames(contextType, true);
    }

    private String[] getMacroNames(int contextType, boolean clone) {
        String[] names = null;
        switch (contextType) {
            case 1: {
                names = fFileMacros;
                break;
            }
            case 2: {
                names = fOptionMacros;
                break;
            }
            case 8: {
                names = fToolMacros;
                break;
            }
            case 3: {
                names = fConfigurationMacros;
                break;
            }
            case 4: {
                names = fProjectMacros;
                break;
            }
            case 5: {
                names = fWorkspaceMacros;
                break;
            }
            case 6: {
                names = fCDTEclipseMacros;
                break;
            }
        }
        if (names != null) {
            return clone ? (String[])names.clone() : names;
        }
        return null;
    }

    private MbsMacroSupplier() {
    }

    public static MbsMacroSupplier getInstance() {
        if (fInstance == null) {
            fInstance = new MbsMacroSupplier();
        }
        return fInstance;
    }

    public IBuildMacro getMacro(String macroName, int contextType, Object contextData) {
        IBuildMacro macro = null;
        block0 : switch (contextType) {
            case 1: {
                if (!(contextData instanceof IFileContextData)) break;
                int i = 0;
                while (i < fFileMacros.length) {
                    if (macroName.equals(fFileMacros[i])) {
                        macro = new FileContextMacro(macroName, (IFileContextData)contextData);
                        break block0;
                    }
                    ++i;
                }
                break;
            }
            case 2: {
                if (!(contextData instanceof IOptionContextData)) break;
                macro = this.getMacro(macroName, (IOptionContextData)contextData);
                break;
            }
            case 8: {
                if (!(contextData instanceof ITool)) break;
                macro = this.getMacro(macroName, (ITool)contextData);
                break;
            }
            case 3: {
                if (!(contextData instanceof IConfiguration)) break;
                macro = this.getMacro(macroName, (IConfiguration)contextData);
                break;
            }
            case 4: {
                if (!(contextData instanceof IManagedProject)) break;
                macro = this.getMacro(macroName, (IManagedProject)contextData);
                break;
            }
            case 5: {
                if (!(contextData instanceof IWorkspace)) break;
                macro = this.getMacro(macroName, (IWorkspace)contextData);
                break;
            }
            case 6: {
                if (contextData != null) break;
                macro = this.getMacro(macroName);
                break;
            }
        }
        return macro;
    }

    public IBuildMacro getMacro(String macroName, IOptionContextData optionContext) {
        IHoldsOptions holder;
        BuildMacro macro = null;
        if ("IncludeDefaults".equals(macroName)) {
            if (!this.canHandle(optionContext)) {
                optionContext = null;
            }
            macro = new OptionMacro(macroName, optionContext);
        } else if ("ParentVersion".equals(macroName) && (holder = OptionContextData.getHolder(optionContext)) != null && holder.getVersion() != null) {
            macro = new BuildMacro(macroName, 1, holder.getVersion().toString());
        }
        return macro;
    }

    public IBuildMacro getMacro(String macroName, ITool tool) {
        BuildMacro macro = null;
        if ("ToolVersion".equals(macroName) && tool.getVersion() != null) {
            macro = new BuildMacro(macroName, 1, tool.getVersion().toString());
        }
        return macro;
    }

    public IBuildMacro getMacro(String macroName, IConfiguration cfg) {
        PluginVersionIdentifier version;
        BuildMacro macro = null;
        if ("ConfigName".equals(macroName)) {
            macro = new BuildMacro(macroName, 1, cfg.getName());
        } else if ("ConfigDescription".equals(macroName)) {
            macro = new BuildMacro(macroName, 1, cfg.getDescription());
        } else if ("BuildArtifactFileName".equals(macroName)) {
            String name = cfg.getArtifactName();
            String ext = cfg.getArtifactExtension();
            if (ext != null && !EMPTY_STRING.equals(ext)) {
                name = String.valueOf(name) + DOT + ext;
            }
            macro = new BuildMacro(macroName, 1, name);
        } else if ("BuildArtifactFileExt".equals(macroName)) {
            String ext = cfg.getArtifactExtension();
            macro = new BuildMacro(macroName, 1, ext);
        } else if ("BuildArtifactFileBaseName".equals(macroName)) {
            String name = cfg.getArtifactName();
            ITool targetTool = cfg.calculateTargetTool();
            if (targetTool != null) {
                IOutputType pot = targetTool.getPrimaryOutputType();
                String prefix = pot.getOutputPrefix();
                IBuildObject toolParent = targetTool.getParent();
                IConfiguration config = null;
                if (toolParent instanceof IConfiguration) {
                    config = (IConfiguration)toolParent;
                } else if (toolParent instanceof IToolChain) {
                    config = ((IToolChain)toolParent).getParent();
                } else if (toolParent instanceof IResourceConfiguration) {
                    config = ((IResourceConfiguration)toolParent).getParent();
                } else {
                    throw new AssertionError((Object)"tool parent must be one of configuration, toolchain, or resource configuration");
                }
                if (config != null) {
                    try {
                        prefix = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(prefix, EMPTY_STRING, " ", 3, config);
                    }
                    catch (BuildMacroException buildMacroException) {}
                }
                if (prefix != null && !EMPTY_STRING.equals(prefix)) {
                    name = String.valueOf(prefix) + name;
                }
            }
            macro = new BuildMacro(macroName, 1, name);
        } else if ("BuildArtifactFilePrefix".equals(macroName)) {
            ITool targetTool = cfg.calculateTargetTool();
            if (targetTool != null) {
                IOutputType pot = targetTool.getPrimaryOutputType();
                String prefix = pot.getOutputPrefix();
                IBuildObject toolParent = targetTool.getParent();
                IConfiguration config = null;
                if (toolParent instanceof IConfiguration) {
                    config = (IConfiguration)toolParent;
                } else if (toolParent instanceof IToolChain) {
                    config = ((IToolChain)toolParent).getParent();
                } else if (toolParent instanceof IResourceConfiguration) {
                    config = ((IResourceConfiguration)toolParent).getParent();
                } else {
                    throw new AssertionError((Object)"tool parent must be one of configuration, toolchain, or resource configuration");
                }
                if (config != null) {
                    try {
                        prefix = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(prefix, EMPTY_STRING, " ", 3, config);
                    }
                    catch (BuildMacroException buildMacroException) {}
                }
                if (prefix == null) {
                    prefix = EMPTY_STRING;
                }
                macro = new BuildMacro(macroName, 1, prefix);
            }
        } else if ("TargetOsList".equals(macroName)) {
            IToolChain toolChain = cfg.getToolChain();
            String[] osList = toolChain.getOSList();
            if (osList == null) {
                osList = new String[]{};
            }
            macro = new BuildMacro(macroName, 2, osList);
        } else if ("TargetArchList".equals(macroName)) {
            IToolChain toolChain = cfg.getToolChain();
            String[] archList = toolChain.getArchList();
            if (archList == null) {
                archList = new String[]{};
            }
            macro = new BuildMacro(macroName, 2, archList);
        } else if ("ToolChainVersion".equals(macroName)) {
            if (cfg.getToolChain().getVersion() != null) {
                macro = new BuildMacro(macroName, 1, cfg.getToolChain().getVersion().toString());
            }
        } else if ("BuilderVersion".equals(macroName) && (version = cfg.getToolChain().getBuilder().getVersion()) != null) {
            macro = new BuildMacro(macroName, 1, version.toString());
        }
        return macro;
    }

    private String getBaseName(String name) {
        String value = null;
        int index = name.lastIndexOf(46);
        value = index == -1 ? name : name.substring(0, index);
        return value;
    }

    private String getExtension(String name) {
        String value = null;
        int index = name.lastIndexOf(46);
        if (index != -1) {
            value = name.substring(index + 1);
        }
        return value;
    }

    public IBuildMacro getMacro(String macroName, IManagedProject mngProj) {
        BuildMacro macro = null;
        if ("ProjName".equals(macroName)) {
            macro = new BuildMacro(macroName, 1, mngProj.getOwner().getName());
        } else if ("ProjDirPath".equals(macroName)) {
            macro = new BuildMacro(macroName, 5, mngProj.getOwner().getLocation().toOSString());
        }
        return macro;
    }

    public IBuildMacro getMacro(String macroName, IWorkspace wsp) {
        BuildMacro macro = null;
        if ("WorkspaceDirPath".equals(macroName)) {
            macro = new BuildMacro(macroName, 5, wsp.getRoot().getLocation().toOSString());
        } else if ("DirectoryDelimiter".equals(macroName)) {
            macro = this.isWin32() ? new BuildMacro(macroName, 1, "\\") : new BuildMacro(macroName, 1, "/");
        } else if ("PathDelimiter".equals(macroName)) {
            macro = this.isWin32() ? new BuildMacro(macroName, 1, ";") : new BuildMacro(macroName, 1, ":");
        }
        return macro;
    }

    private boolean isWin32() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.startsWith("windows ");
    }

    public IBuildMacro getMacro(String macroName) {
        BuildMacro macro = null;
        if ("EclipseVersion".equals(macroName)) {
            Bundle bundle = Platform.getBundle((String)"org.eclipse.platform");
            String version = bundle != null ? (String)bundle.getHeaders().get("Bundle-Version") : null;
            macro = new BuildMacro(macroName, 1, version);
        } else if ("CDTVersion".equals(macroName)) {
            String version = (String)CCorePlugin.getDefault().getBundle().getHeaders().get("Bundle-Version");
            macro = new BuildMacro(macroName, 1, version);
        } else if ("MBSVersion".equals(macroName)) {
            String version = ManagedBuildManager.getBuildInfoVersion().toString();
            macro = new BuildMacro(macroName, 1, version);
        } else if ("HostOsName".equals(macroName)) {
            String os = System.getProperty("os.name");
            macro = new BuildMacro(macroName, 1, os);
        } else if ("HostArchName".equals(macroName)) {
            String arch = System.getProperty("os.arch");
            macro = new BuildMacro(macroName, 1, arch);
        } else if ("OsType".equals(macroName)) {
            String os = Platform.getOS();
            macro = new BuildMacro(macroName, 1, os);
        } else if ("ArchType".equals(macroName)) {
            String arch = Platform.getOSArch();
            macro = new BuildMacro(macroName, 1, arch);
        }
        return macro;
    }

    public IBuildMacro[] getMacros(int contextType, Object contextData) {
        String[] names = this.getMacroNames(contextType, false);
        if (names != null) {
            IBuildMacro[] macros = new IBuildMacro[names.length];
            int num = 0;
            int i = 0;
            while (i < names.length) {
                IBuildMacro macro = this.getMacro(names[i], contextType, contextData);
                if (macro != null) {
                    macros[num++] = macro;
                }
                ++i;
            }
            if (macros.length != num) {
                IBuildMacro[] tmp = new IBuildMacro[num];
                if (num > 0) {
                    System.arraycopy(macros, 0, tmp, 0, num);
                }
                macros = tmp;
            }
            return macros;
        }
        return null;
    }

    private IPath getBuilderCWD(IConfiguration cfg) {
        IPath workingDirectory = null;
        IResource owner = cfg.getOwner();
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo(owner);
        if (info != null && info.getDefaultConfiguration().equals(cfg)) {
            IManagedBuilderMakefileGenerator generator = ManagedBuildManager.getBuildfileGenerator(info.getDefaultConfiguration());
            generator.initialize((IProject)owner, info, null);
            IPath topBuildDir = generator.getBuildWorkingDir();
            if (topBuildDir == null) {
                topBuildDir = new Path(info.getConfigurationName());
            }
            IPath projectLocation = owner.getLocation();
            workingDirectory = projectLocation.append(topBuildDir);
        }
        return workingDirectory;
    }

    private IPath getOutputFilePath(IPath inputPath, IConfiguration cfg) {
        ITool[] buildTools = null;
        IResourceConfiguration rcCfg = cfg.getResourceConfiguration(inputPath.toString());
        if (rcCfg != null) {
            buildTools = rcCfg.getToolsToInvoke();
        }
        if (buildTools == null || buildTools.length == 0) {
            buildTools = cfg.getFilteredTools();
        }
        String name = null;
        Path path = null;
        int i = 0;
        while (i < buildTools.length) {
            IOutputType prymOutType;
            String[] names;
            ITool tool = buildTools[i];
            IInputType inputType = tool.getInputType(inputPath.getFileExtension());
            if (inputType != null && (names = (prymOutType = tool.getPrimaryOutputType()).getOutputNames()) != null && names.length > 0) {
                name = names[0];
            }
            ++i;
        }
        if (name != null) {
            Path namePath = new Path(name);
            if (namePath.isAbsolute()) {
                path = namePath;
            } else {
                IPath cwd = this.getBuilderCWD(cfg);
                if (cwd != null) {
                    path = cwd.append((IPath)namePath);
                }
            }
        }
        return path;
    }

    public IOption getOption(ITool tool, String optionId) {
        if (optionId == null) {
            return null;
        }
        IOption[] options = tool.getOptions();
        int i = 0;
        while (i < options.length) {
            IOption targetOption;
            IOption option = targetOption = options[i];
            do {
                if (!optionId.equals(option.getId())) continue;
                return targetOption;
            } while ((option = option.getSuperClass()) != null);
            ++i;
        }
        return null;
    }

    private OptionData getParent(IOptionContextData optionContext) {
        IBuildObject parentObject;
        if (optionContext == null) {
            return null;
        }
        IOption option = optionContext.getOption();
        if (option == null) {
            return null;
        }
        IOption parentOption = null;
        IBuildObject parent = option.getParent();
        ITool tool = null;
        if (parent instanceof ITool) {
            tool = (ITool)parent;
        }
        IBuildObject bObj = optionContext instanceof OptionData ? ((OptionData)optionContext).getOptionContainer() : optionContext.getParent();
        IResourceConfiguration rcCfg = null;
        ITool holderTool = null;
        if (bObj instanceof ITool) {
            holderTool = (ITool)bObj;
            IBuildObject p = holderTool.getParent();
            if (p instanceof IResourceConfiguration) {
                rcCfg = (IResourceConfiguration)p;
            }
        } else if (bObj instanceof IResourceConfiguration) {
            rcCfg = (IResourceConfiguration)bObj;
        }
        IBuildObject iBuildObject = parentObject = rcCfg == null ? bObj : rcCfg.getParent();
        if (rcCfg != null && rcCfg.getTool(tool.getId()) != null) {
            tool = tool.getSuperClass();
            parentOption = tool.getOptionBySuperClassId(option.getSuperClass().getId());
        } else {
            parentOption = option.getSuperClass();
        }
        if (parentOption != null) {
            return new OptionData(parentOption, bObj, parentObject);
        }
        return null;
    }

    private boolean canHandle(IOptionContextData optionData) {
        IOption option = optionData.getOption();
        if (option == null) {
            return false;
        }
        boolean can = false;
        try {
            switch (option.getValueType()) {
                case 0: {
                    break;
                }
                case 2: {
                    can = true;
                    break;
                }
                case 1: {
                    break;
                }
                case 3: {
                    can = true;
                    break;
                }
                case 4: {
                    can = true;
                    break;
                }
                case 5: {
                    can = true;
                    break;
                }
                case 6: {
                    can = true;
                    break;
                }
                case 7: {
                    can = true;
                }
            }
        }
        catch (BuildException buildException) {
            can = false;
        }
        return can;
    }

    private class OptionData
    extends OptionContextData {
        private IBuildObject fOptionContainer;

        public OptionData(IOption option, IBuildObject parent) {
            this(option, parent, parent);
        }

        public OptionData(IOption option, IBuildObject parent, IBuildObject optionContainer) {
            super(option, parent);
            this.fOptionContainer = optionContainer;
        }

        public IBuildObject getOptionContainer() {
            return this.fOptionContainer;
        }
    }

    public class FileContextMacro
    extends BuildMacro {
        private IFileContextData fContextData;
        private IConfiguration fConfiguration;
        private boolean fIsExplicit = true;
        private boolean fIsInitialized;
        private String fExplicitValue;
        private boolean fIsExplicitResolved;

        private FileContextMacro(String name, IFileContextData contextData) {
            this.fName = name;
            this.fType = 1;
            this.fContextData = contextData;
        }

        private void loadValue() {
            IFileContextBuildMacroValues values;
            String value;
            if (this.fIsInitialized) {
                return;
            }
            IBuilder builder = null;
            IOptionContextData optionContext = this.fContextData.getOptionContextData();
            if (optionContext != null) {
                IToolChain toolChain;
                IBuildObject buildObject = optionContext.getParent();
                if (buildObject instanceof ITool) {
                    buildObject = ((ITool)buildObject).getParent();
                } else if (buildObject instanceof IConfiguration) {
                    buildObject = ((IConfiguration)buildObject).getToolChain();
                }
                if (buildObject instanceof IToolChain) {
                    toolChain = (IToolChain)buildObject;
                    builder = toolChain.getBuilder();
                    this.fConfiguration = toolChain.getParent();
                } else if (buildObject instanceof IResourceConfiguration) {
                    this.fConfiguration = ((IResourceConfiguration)buildObject).getParent();
                    if (this.fConfiguration != null && (toolChain = this.fConfiguration.getToolChain()) != null) {
                        builder = toolChain.getBuilder();
                    }
                }
            }
            if (builder != null && (value = (values = builder.getFileContextBuildMacroValues()).getMacroValue(this.fName)) != null) {
                this.fStringValue = value;
                this.fIsExplicit = false;
            }
            if (this.fStringValue == null) {
                this.fIsExplicit = true;
                this.fExplicitValue = this.fStringValue = MbsMacroSupplier.this.getExplicitFileMacroValue(this.fName, this.fContextData.getInputFileLocation(), this.fContextData.getOutputFileLocation(), this.fConfiguration);
                this.fIsExplicitResolved = true;
            }
            this.fIsInitialized = true;
        }

        public String getExplicitMacroValue() {
            this.loadValue();
            if (!this.fIsExplicitResolved) {
                this.fExplicitValue = MbsMacroSupplier.this.getExplicitFileMacroValue(this.fName, this.fContextData.getInputFileLocation(), this.fContextData.getOutputFileLocation(), this.fConfiguration);
                this.fIsExplicitResolved = true;
            }
            return this.fExplicitValue;
        }

        public boolean isExplicit() {
            this.loadValue();
            return this.fIsExplicit;
        }

        public String getStringValue() {
            this.loadValue();
            return this.fStringValue;
        }
    }

    private class IncludeDefaultsSubstitutor
    implements IMacroSubstitutor {
        private IOptionContextData fOptionContextData;

        public IncludeDefaultsSubstitutor(IOptionContextData data) {
            this.fOptionContextData = data;
        }

        public String resolveToString(String macroName) throws BuildMacroException {
            if (!"IncludeDefaults".equals(macroName)) {
                return MacroResolver.createMacroReference(macroName);
            }
            OptionData parent = MbsMacroSupplier.this.getParent(this.fOptionContextData);
            if (parent == null) {
                return MbsMacroSupplier.EMPTY_STRING;
            }
            IncludeDefaultsSubstitutor sub = new IncludeDefaultsSubstitutor(parent);
            IOption option = parent.getOption();
            String str = null;
            String[] strL = null;
            try {
                switch (option.getValueType()) {
                    case 2: {
                        str = option.getStringValue();
                        break;
                    }
                    case 3: {
                        strL = option.getStringListValue();
                        break;
                    }
                    case 4: {
                        strL = option.getIncludePaths();
                        break;
                    }
                    case 5: {
                        strL = option.getDefinedSymbols();
                        break;
                    }
                    case 6: {
                        strL = option.getLibraries();
                        break;
                    }
                    case 7: {
                        strL = option.getUserObjects();
                        break;
                    }
                }
                if (str != null) {
                    return MacroResolver.resolveToString(str, sub);
                }
                if (strL != null) {
                    strL = MacroResolver.resolveStringListValues(strL, sub, true);
                    return MacroResolver.convertStringListToString(strL, " ");
                }
            }
            catch (BuildException buildException) {
            }
            catch (BuildMacroException buildMacroException) {}
            return null;
        }

        public String[] resolveToStringList(String macroName) throws BuildMacroException {
            if (!"IncludeDefaults".equals(macroName)) {
                return new String[]{MacroResolver.createMacroReference(macroName)};
            }
            OptionData parent = MbsMacroSupplier.this.getParent(this.fOptionContextData);
            if (parent == null) {
                return new String[]{MbsMacroSupplier.EMPTY_STRING};
            }
            IncludeDefaultsSubstitutor sub = new IncludeDefaultsSubstitutor(parent);
            IOption option = parent.getOption();
            String str = null;
            String[] strL = null;
            try {
                switch (option.getValueType()) {
                    case 2: {
                        str = option.getStringValue();
                        break;
                    }
                    case 3: {
                        strL = option.getStringListValue();
                        break;
                    }
                    case 4: {
                        strL = option.getIncludePaths();
                        break;
                    }
                    case 5: {
                        strL = option.getDefinedSymbols();
                        break;
                    }
                    case 6: {
                        strL = option.getLibraries();
                        break;
                    }
                    case 7: {
                        strL = option.getUserObjects();
                        break;
                    }
                }
                if (str != null) {
                    return MacroResolver.resolveToStringList(str, sub);
                }
                if (strL != null) {
                    return MacroResolver.resolveStringListValues(strL, sub, true);
                }
            }
            catch (BuildException buildException) {
            }
            catch (BuildMacroException buildMacroException) {}
            return null;
        }

        public void setMacroContextInfo(int contextType, Object contextData) throws BuildMacroException {
        }

        public IMacroContextInfo getMacroContextInfo() {
            return null;
        }
    }

    public class OptionMacro
    extends BuildMacro {
        private IOptionContextData fOptionContextData;
        private IOptionContextData fParentOptionContextData;

        private OptionMacro(String name, IOptionContextData optionContextData) {
            this.fName = name;
            this.fOptionContextData = optionContextData;
            this.fParentOptionContextData = MbsMacroSupplier.this.getParent(this.fOptionContextData);
            this.load();
        }

        private boolean load() {
            boolean result;
            this.fStringValue = null;
            this.fStringListValue = null;
            this.fType = 0;
            if (this.fParentOptionContextData != null) {
                IOption option = this.fParentOptionContextData.getOption();
                try {
                    switch (option.getValueType()) {
                        case 0: {
                            break;
                        }
                        case 2: {
                            this.fType = 1;
                            this.fStringValue = option.getStringValue();
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 3: {
                            this.fType = 2;
                            this.fStringListValue = option.getStringListValue();
                            break;
                        }
                        case 4: {
                            this.fType = 6;
                            this.fStringListValue = option.getIncludePaths();
                            break;
                        }
                        case 5: {
                            this.fType = 2;
                            this.fStringListValue = option.getDefinedSymbols();
                            break;
                        }
                        case 6: {
                            this.fType = 4;
                            this.fStringListValue = option.getLibraries();
                            break;
                        }
                        case 7: {
                            this.fType = 4;
                            this.fStringListValue = option.getUserObjects();
                        }
                    }
                    if (this.fStringValue != null) {
                        this.fStringValue = MacroResolver.resolveToString(this.fStringValue, new IncludeDefaultsSubstitutor(this.fParentOptionContextData));
                    } else if (this.fStringListValue != null) {
                        this.fStringListValue = MacroResolver.resolveStringListValues(this.fStringListValue, new IncludeDefaultsSubstitutor(this.fParentOptionContextData), true);
                    }
                }
                catch (Exception exception) {
                    this.fType = 0;
                }
            }
            boolean bl = result = this.fType != 0;
            if (!result) {
                this.fType = 1;
                this.fStringListValue = null;
                this.fStringValue = null;
            }
            return result;
        }
    }
}

