/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.model.IContributedModelBuilder;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;

public class LanguageManager {
    private static LanguageManager instance;
    private Map cache = new HashMap();

    public static LanguageManager getInstance() {
        if (instance == null) {
            instance = new LanguageManager();
        }
        return instance;
    }

    public ILanguage getLanguage(String id) throws CoreException {
        ILanguage language = (ILanguage)this.cache.get(id);
        if (language != null) {
            return language;
        }
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.core", "language");
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] languages = extension.getConfigurationElements();
            int j = 0;
            while (j < languages.length) {
                IConfigurationElement languageElem = languages[j];
                String langId = String.valueOf(extension.getNamespace()) + "." + languageElem.getAttribute("id");
                if (langId.equals(id)) {
                    language = (ILanguage)languageElem.createExecutableExtension("class");
                    this.cache.put(id, language);
                    return language;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public ILanguage getLanguage(IContentType contentType) throws CoreException {
        IContentTypeManager manager = Platform.getContentTypeManager();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.core", "language");
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] languages = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < languages.length) {
                IConfigurationElement language = languages[j];
                IConfigurationElement[] contentTypes = language.getChildren("contentType");
                int k = 0;
                while (k < contentTypes.length) {
                    IContentType langContType = manager.getContentType(contentTypes[k].getAttribute("id"));
                    if (contentType.equals(langContType)) {
                        return (ILanguage)language.createExecutableExtension("class");
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public ArrayList getAllContentTypes() {
        ArrayList<String> allTypes = new ArrayList<String>();
        allTypes.add("org.eclipse.cdt.core.asmSource");
        allTypes.add("org.eclipse.cdt.core.cHeader");
        allTypes.add("org.eclipse.cdt.core.cSource");
        allTypes.add("org.eclipse.cdt.core.cxxHeader");
        allTypes.add("org.eclipse.cdt.core.cxxSource");
        IContentTypeManager manager = Platform.getContentTypeManager();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.core", "language");
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] languages = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < languages.length) {
                IConfigurationElement language = languages[j];
                IConfigurationElement[] contentTypes = language.getChildren("contentType");
                int k = 0;
                while (k < contentTypes.length) {
                    IContentType langContType = manager.getContentType(contentTypes[k].getAttribute("id"));
                    allTypes.add(langContType.getId());
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return allTypes;
    }

    public boolean isContributedContentType(String contentTypeId) {
        return this.getAllContentTypes().contains(contentTypeId);
    }

    public IContributedModelBuilder getContributedModelBuilderFor(TranslationUnit tu) {
        try {
            ILanguage lang = tu.getLanguage();
            return lang == null ? null : lang.createModelBuilder(tu);
        }
        catch (CoreException coreException) {
            return null;
        }
    }
}

