/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.indexer.fast;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.pdom.PDOMCodeReaderFactory;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMFile;
import org.eclipse.cdt.internal.core.pdom.indexer.fast.PDOMFastIndexer;
import org.eclipse.cdt.internal.core.pdom.indexer.fast.PDOMFastIndexerJob;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;

class PDOMFastHandleDelta
extends PDOMFastIndexerJob {
    private final ICElementDelta delta;
    private List added = new ArrayList();
    private List changed = new ArrayList();
    private List removed = new ArrayList();

    public PDOMFastHandleDelta(PDOMFastIndexer indexer, ICElementDelta delta) throws CoreException {
        super(indexer);
        this.delta = delta;
    }

    public void run(IProgressMonitor monitor) {
        try {
            ITranslationUnit tu;
            long start = System.currentTimeMillis();
            this.processDelta(this.delta);
            Iterator i = this.changed.iterator();
            while (i.hasNext()) {
                tu = (ITranslationUnit)i.next();
                try {
                    this.changeTU(tu);
                }
                catch (Throwable e) {
                    CCorePlugin.log(e);
                    if (++this.errorCount <= 10) continue;
                    return;
                }
            }
            i = this.added.iterator();
            while (i.hasNext()) {
                tu = (ITranslationUnit)i.next();
                try {
                    this.addTU(tu);
                }
                catch (Throwable e) {
                    CCorePlugin.log(e);
                    if (++this.errorCount <= 10) continue;
                    return;
                }
            }
            i = this.removed.iterator();
            while (i.hasNext()) {
                tu = (ITranslationUnit)i.next();
                this.removeTU(tu);
            }
            String showTimings = Platform.getDebugOption((String)"org.eclipse.cdt.core/debug/pdomtimings");
            if (showTimings != null && showTimings.equalsIgnoreCase("true")) {
                System.out.println("PDOM Fast Delta Time: " + (System.currentTimeMillis() - start));
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        catch (InterruptedException interruptedException) {}
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void processDelta(ICElementDelta delta) throws CoreException {
        int flags = delta.getFlags();
        if ((flags & 8) != 0) {
            ICElementDelta[] children = delta.getAffectedChildren();
            int i = 0;
            while (i < children.length) {
                this.processDelta(children[i]);
                ++i;
            }
        }
        ICElement element = delta.getElement();
        switch (element.getElementType()) {
            case 60: {
                ITranslationUnit tu = (ITranslationUnit)element;
                switch (delta.getKind()) {
                    case 4: {
                        if ((flags & 1) == 0) return;
                        this.changed.add(tu);
                        break;
                    }
                    case 1: {
                        if (tu.isWorkingCopy()) return;
                        this.added.add(tu);
                        break;
                    }
                    case 2: {
                        if (tu.isWorkingCopy()) return;
                        this.removed.add(tu);
                    }
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void changeTU(ITranslationUnit tu) throws CoreException, InterruptedException {
        ILanguage language = tu.getLanguage();
        if (language == null) {
            return;
        }
        PDOMCodeReaderFactory codeReaderFactory = new PDOMCodeReaderFactory(this.pdom);
        IASTTranslationUnit ast = language.getASTTranslationUnit(tu, codeReaderFactory, 9);
        if (ast == null) {
            return;
        }
        codeReaderFactory.clearMacros();
        this.pdom.acquireWriteLock();
        try {
            IPath path = ((IFile)tu.getResource()).getLocation();
            PDOMFile file = this.pdom.getFile(path);
            if (file != null) {
                file.clear();
            }
            this.addSymbols(tu.getLanguage(), ast);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.pdom.releaseWriteLock();
            throw throwable;
        }
        {
            Object var7_9 = null;
            this.pdom.releaseWriteLock();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void removeTU(ITranslationUnit tu) throws CoreException, InterruptedException {
        this.pdom.acquireWriteLock();
        try {
            IPath path = ((IFile)tu.getResource()).getLocation();
            PDOMFile file = this.pdom.getFile(path);
            if (file != null) {
                file.clear();
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.pdom.releaseWriteLock();
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.pdom.releaseWriteLock();
            return;
        }
    }
}

